/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.graphboard;

import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.graphboard.GraphBoardFrame;
import com.spss.uitools.help.StatsHelp;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.vismodel.NviznModelEvent;
import com.spss.vis.graphboard.vismodel.NviznModelEventListener;
import java.awt.event.ActionEvent;

public class GraphBoardAction
extends SpssAction
implements NviznModelEventListener {
    private GraphBoardFrame mFrame;
    private Graphboard mGraphBoard;
    private static boolean sInEditMode = false;

    public GraphBoardAction(String string, Graphboard graphboard, GraphBoardFrame graphBoardFrame) {
        super(string);
        this.mFrame = graphBoardFrame;
        this.mGraphBoard = graphboard;
        this.configureAction(true);
        if (this.mActionId.equals("edit_undo") || this.mActionId.equals("edit_redo") || this.mActionId.equals("model_view_edit_mode") || this.mActionId.equals("model_view_explore_mode")) {
            this.mGraphBoard.getModel().addListener((NviznModelEventListener)this);
            this.mGraphBoard.getModel().clearUndo();
        }
        sInEditMode = this.mGraphBoard.isEditEnabled();
    }

    public boolean getMenuItemEnableStatus(GraphBoardFrame graphBoardFrame) {
        boolean bl = true;
        if (this.mActionId.equals("edit_undo")) {
            bl = this.mGraphBoard.getModel().canUndo();
        } else if (this.mActionId.equals("edit_redo")) {
            bl = this.mGraphBoard.getModel().canRedo();
        }
        return bl;
    }

    public boolean getMenuItemCheckStatus(GraphBoardFrame graphBoardFrame) {
        boolean bl = true;
        if (this.mActionId.equals("model_view_edit_mode")) {
            bl = sInEditMode;
        } else if (this.mActionId.equals("model_view_explore_mode")) {
            bl = !sInEditMode;
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mActionId.equals("model_file_close")) {
            this.mFrame.close();
        } else if (this.mActionId.equals("model_view_edit_mode")) {
            this.mGraphBoard.setEditEnabled(true);
            sInEditMode = true;
        } else if (this.mActionId.equals("model_view_explore_mode")) {
            this.mGraphBoard.setEditEnabled(false);
            sInEditMode = false;
        } else if (this.mActionId.equals("edit_undo")) {
            this.mGraphBoard.getModel().undo();
        } else if (this.mActionId.equals("edit_redo")) {
            this.mGraphBoard.getModel().redo();
        } else if (this.mActionId.equals("help_topics")) {
            StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_graphboard_editor");
        }
    }

    public void modelChanged(NviznModelEvent nviznModelEvent) {
        if (nviznModelEvent.getType() == NviznModelEvent.SPECIFICATION_CHANGED) {
            if (this.mActionId.equals("edit_undo")) {
                this.setEnabled(this.mGraphBoard.getModel().canUndo());
            } else if (this.mActionId.equals("edit_redo")) {
                this.setEnabled(this.mGraphBoard.getModel().canRedo());
            }
            this.mFrame.setDirty(true);
        } else if (nviznModelEvent.getType() == NviznModelEvent.EDIT_MODE_CHANGED) {
            sInEditMode = this.mGraphBoard.isEditEnabled();
        }
    }
}

