/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output.drag_drop;

import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ViewerTreePaneDragAdapter
extends ComponentDragAdapter {
    private JTree mSourceTree;
    private int[] mDraggedRows;
    private boolean mDisabled;

    public ViewerTreePaneDragAdapter(JTree jTree, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mSourceTree = jTree;
        this.mDisabled = false;
    }

    public void enableDragDrop(boolean bl) {
        this.mDisabled = !bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mDisabled) {
            return;
        }
        this.mDndArmedEvent = null;
        if (mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        this.mDndArmedEvent = mouseEvent;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mTransferData == null) {
            this.mDndArmedEvent = null;
            return;
        }
        super.mouseReleased(mouseEvent);
    }

    public Object getTransferData() {
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        return this.mTransferData;
    }

    public int[] getDraggedRows() {
        return this.mDraggedRows;
    }

    protected void startDrag(MouseEvent mouseEvent) {
        super.startDrag(mouseEvent);
        this.mDraggedRows = this.mSourceTree.getSelectionRows();
    }

    protected BufferedImage getDragImage(Component component) {
        return null;
    }

    protected void acquireTransferData() {
        if (this.mSourceTree != null) {
            Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
            int[] nArray = this.mSourceTree.getSelectionRows();
            if (nArray != null) {
                int n;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(nArray[n]);
                }
                Collections.sort(arrayList);
                for (n = 0; n < arrayList.size(); ++n) {
                    int n2 = (Integer)arrayList.get(n);
                    TreePath treePath = this.mSourceTree.getPathForRow(n2);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    vector.add(defaultMutableTreeNode);
                }
                this.mTransferData = vector;
            }
        }
    }
}

