/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.RenderTask;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.shared.export.table_export.BaseImageRenderer;
import com.spss.uitools.util.TraceSettings;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Visualization;
import com.spss.vis.processors.Graphics2DProcessor;
import com.spss.vis.specification.VisualizationInterruptedException;
import com.spss.vizimager.DataFilterInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class VizTiler {
    private static final int MAX_STACK_SIZE = 5;
    private static final int MAX_TILE_SIZE = 600;
    private static final int IMAGE_MARGIN = 3;
    private int mTileWidth;
    private int mTileHeight;
    private int mTotalWidth;
    private int mTotalHeight;
    private ViewerImage[][] mTiles;
    private Visualization mVisualization = null;
    private GraphicsConfiguration mGraphicsConfiguration = null;
    private TableViewerItem mTableItem;
    private Timer mTimer;
    private boolean mNeedsSize;
    private final Stack<Point> mStack = new Stack();
    private DataFilterInfo mDataFilterInfo;
    private FontRenderContext mFrc = new FontRenderContext(null, true, false);

    public VizTiler(TableViewerItem tableViewerItem, DataFilterInfo dataFilterInfo) {
        this.mTableItem = tableViewerItem;
        this.mDataFilterInfo = dataFilterInfo;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Stack<Point> stack = this.mStack;
        synchronized (stack) {
            this.mStack.clear();
        }
        this.clearTiles();
        this.mTotalWidth = 0;
        this.mTotalHeight = 0;
        this.mVisualization = null;
        this.mNeedsSize = true;
    }

    protected void paintComponent(Graphics graphics) {
        Container container = this.mTableItem.getParent();
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = container instanceof ViewerOutputPane && !((ViewerOutputPane)container).canRender();
        boolean bl2 = this.mTableItem.getCoreItem().isComplete();
        if (!bl2 || this.mTiles == null) {
            BufferedImage bufferedImage = ImageGenerator2.getImageGenerator().getWaitImage();
            if (!bl && this.mNeedsSize) {
                this.mNeedsSize = false;
                this.setItemSize(bufferedImage.getWidth() - 3, bufferedImage.getHeight() - 3);
            }
            graphics.drawImage(bufferedImage, 1, 1, null);
            if (!bl && bl2) {
                this.doVisualizationActualize();
            } else if (bl) {
                this.mTableItem.repaint(500L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            return;
        }
        if (this.mGraphicsConfiguration == null) {
            this.mGraphicsConfiguration = this.mTableItem.getGraphicsConfiguration();
        }
        Rectangle rectangle2 = new Rectangle(this.mTotalWidth, this.mTotalHeight);
        rectangle = rectangle.intersection(rectangle2);
        int n = (int)Math.floor(rectangle.getMinX() / (double)this.mTileWidth);
        int n2 = (int)Math.floor(rectangle.getMaxX() / (double)this.mTileWidth);
        int n3 = (int)Math.floor(rectangle.getMinY() / (double)this.mTileHeight);
        int n4 = (int)Math.floor(rectangle.getMaxY() / (double)this.mTileHeight);
        n2 = Math.min(n2, this.mTiles.length - 1);
        n4 = Math.min(n4, this.mTiles[0].length - 1);
        graphics.translate(1, 1);
        for (int i = n4; i >= n3; --i) {
            for (int j = n2; j >= n; --j) {
                BufferedImage bufferedImage = null;
                if (this.mTiles != null && this.mTiles[j] != null && this.mTiles[j][i] != null) {
                    bufferedImage = this.mTiles[j][i].get();
                }
                if (bufferedImage == null) {
                    graphics.drawImage(ImageGenerator2.getImageGenerator().getWaitImage(), 1, 1, null);
                    if (bl) {
                        this.mTableItem.repaint(500L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        continue;
                    }
                    Rectangle rectangle3 = new Rectangle(j * this.mTileWidth, i * this.mTileHeight, this.mTileWidth, this.mTileHeight);
                    new TileBuilder(this.mTableItem, rectangle3).build(j, i);
                    continue;
                }
                graphics.drawImage(bufferedImage, j * this.mTileWidth, i * this.mTileHeight, this.mTableItem);
            }
        }
        graphics.translate(-1, -1);
    }

    private void setItemSize(final int n, final int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setItemSizeHelper(n, n2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VizTiler.this.setItemSizeHelper(n, n2);
                }
            });
        }
    }

    private void setItemSizeHelper(int n, int n2) {
        boolean bl;
        int n3 = 0;
        boolean bl2 = bl = this.mDataFilterInfo != null && this.mDataFilterInfo.isDisplayFiltering() && this.mDataFilterInfo.getTotalPageCount() > 1;
        if (bl) {
            if (this.mDataFilterInfo.getActivePageId() - 1 >= 0) {
                n3 += TableViewerItem.FEEDBACK_HEIGHT;
            }
            if (this.mDataFilterInfo.getActivePageId() + 1 < this.mDataFilterInfo.getTotalPageCount()) {
                n3 += TableViewerItem.FEEDBACK_HEIGHT;
            }
        }
        Dimension dimension = new Dimension(n + 3, n2 + 3 + n3);
        Dimension dimension2 = this.mTableItem.getSize();
        if ((dimension2.width != dimension.width || dimension2.height != dimension.height) && this.mTableItem.getParent() instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.mTableItem.getParent();
            Rectangle rectangle = viewerOutputPane.getVisibleRect();
            ViewerItem viewerItem = viewerOutputPane.getFocusedViewerItem();
            Rectangle rectangle2 = null;
            if (viewerItem != null) {
                rectangle2 = viewerItem.getBounds();
            }
            boolean bl3 = rectangle2 != null && rectangle.y >= rectangle2.y - 2 && rectangle.y <= rectangle2.y + 2;
            boolean bl4 = (int)rectangle.getMaxY() >= viewerOutputPane.getHeight();
            boolean bl5 = false;
            if (viewerOutputPane.getTopLevelAncestor() instanceof ViewerFrame) {
                bl5 = ((ViewerFrame)viewerOutputPane.getTopLevelAncestor()).getDocument().getCoreDocument().isInDocumentOpen();
            }
            boolean bl6 = !bl5 && (bl3 || bl4);
            TableItem tableItem = (TableItem)this.mTableItem.getCoreItem();
            tableItem.setWidth(dimension.width);
            tableItem.setHeight(dimension.height);
            this.mTableItem.setPreferredSize(dimension);
            this.mTableItem.setSize(dimension);
            this.mTableItem.setRendered(true);
            this.mTableItem.revalidate();
            if (bl6) {
                ViewerItem viewerItem2;
                ViewerItem viewerItem3 = viewerItem2 = viewerItem != null ? viewerItem : viewerOutputPane.getLastItem();
                if (viewerItem2 != null) {
                    Rectangle rectangle3 = viewerItem2.getBounds();
                    rectangle3.y = rectangle3.y + rectangle.height - 10;
                    rectangle3.height = 10;
                    viewerOutputPane.scrollRectToVisible(rectangle3);
                }
            }
        }
    }

    private void clearTiles() {
        if (this.mTiles == null) {
            return;
        }
        ViewerImage[][] viewerImageArray = this.mTiles;
        int n = viewerImageArray.length;
        for (int i = 0; i < n; ++i) {
            ViewerImage[] viewerImageArray2;
            for (ViewerImage viewerImage : viewerImageArray2 = viewerImageArray[i]) {
                if (viewerImage == null) continue;
                ImageCache.getImageCache().remove(viewerImage);
            }
        }
        this.mTiles = null;
    }

    private void doVisualizationActualize() {
        if (this.mVisualization != null) {
            return;
        }
        ImageGenerator2.getImageGenerator().addRenderTask(new VizBuilder(this.mTableItem, new Rectangle(-1, -1, 0, 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void actualizeVisualization() {
        if (this.mVisualization != null) {
            return;
        }
        try {
            int n;
            int n2;
            boolean bl;
            boolean bl2 = bl = TraceSettings.getTrace((int)0x300000) || TraceSettings.getFileTrace((int)0x300000);
            if (bl) {
                TraceSettings.tracePerformance((String)("VizTiler.actualizeVisualization( START ) - " + this.mTableItem.getCoreItem().getDescription()));
            }
            this.mVisualization = VizCache.getCache().getVisualization((TableItem)this.mTableItem.getCoreItem());
            if (this.mVisualization == null || ImageGenerator2.getImageGenerator().isStopped()) {
                return;
            }
            if (bl) {
                TraceSettings.tracePerformance((String)("VizTiler.actualizeVisualization( GOT VIZ ) - " + this.mTableItem.getCoreItem().getDescription()));
            }
            Object object = this.mVisualization;
            synchronized (object) {
                this.mVisualization.setRenderingHints(BaseImageRenderer.getRendingHints());
                n2 = this.mVisualization.getOutputWidth(this.mFrc) + 2;
                n = this.mVisualization.getOutputHeight(this.mFrc) + 2;
                if (bl) {
                    TraceSettings.tracePerformance((String)("VizTiler.actualizeVisualization( VIZ SIZE ) - " + this.mTableItem.getCoreItem().getDescription()));
                }
            }
            if (this.mVisualization == null || ImageGenerator2.getImageGenerator().isStopped()) {
                return;
            }
            if (this.mGraphicsConfiguration == null) {
                this.mGraphicsConfiguration = this.mTableItem.getGraphicsConfiguration();
            }
            object = new Dimension(n2, n);
            int n3 = (int)Math.ceil(((Dimension)object).getWidth() / 600.0);
            int n4 = (int)Math.ceil(((Dimension)object).getHeight() / 600.0);
            this.mTileWidth = (int)Math.ceil(((Dimension)object).getWidth() / (double)n3);
            this.mTileHeight = (int)Math.ceil(((Dimension)object).getHeight() / (double)n4);
            this.clearTiles();
            this.mTiles = new ViewerImage[n3][n4];
            this.mTotalWidth = n2;
            this.mTotalHeight = n;
            this.mNeedsSize = true;
            this.mTimer = new Timer(120000, new ActionListener(){

                @Override
                public synchronized void actionPerformed(ActionEvent actionEvent) {
                    VizTiler.this.mTimer.stop();
                    VizTiler.this.mTimer = null;
                    VizTiler.this.mVisualization = null;
                }
            });
            if (bl) {
                TraceSettings.tracePerformance((String)("VizTiler.actualizeVisualization( END ) - " + this.mTableItem.getCoreItem().getDescription()));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof VisualizationInterruptedException || throwable.getCause() instanceof VisualizationInterruptedException) {
                TraceSettings.trace1((String)"Visualization actualization interrupted", (int)15);
                this.clear();
            }
            if (throwable instanceof OutOfMemoryError || throwable.getCause() instanceof OutOfMemoryError) {
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
            }
            throwable.printStackTrace();
        }
    }

    private void checkTiles() {
        if (this.mTiles == null) {
            return;
        }
        for (ViewerImage[] viewerImageArray : this.mTiles) {
            for (int i = 0; i < this.mTiles[0].length; ++i) {
                if (viewerImageArray[i] != null) continue;
                return;
            }
        }
        this.mVisualization = null;
    }

    private RenderTask.TaskPriority getTaskPriority() {
        RenderTask.TaskPriority taskPriority = RenderTask.TaskPriority.medium;
        if (this.itemHasFocus()) {
            taskPriority = RenderTask.TaskPriority.high;
        }
        return taskPriority;
    }

    private boolean itemHasFocus() {
        return this.mTableItem == ((ViewerOutputPane)this.mTableItem.getParent()).getFocusedViewerItem();
    }

    private final class TileBuilder
    extends RenderTask {
        public TileBuilder(ViewerItem viewerItem, Rectangle rectangle) {
            super(viewerItem, rectangle, VizTiler.this.getTaskPriority());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build(int n, int n2) {
            Point point = new Point(n, n2);
            Stack stack = VizTiler.this.mStack;
            synchronized (stack) {
                while (VizTiler.this.mStack.size() > 5) {
                    VizTiler.this.mStack.remove(0);
                }
                VizTiler.this.mStack.remove(point);
                VizTiler.this.mStack.push(point);
            }
            ImageGenerator2.getImageGenerator().addRenderTask(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VizTiler vizTiler = VizTiler.this;
            synchronized (vizTiler) {
                while (!VizTiler.this.mStack.isEmpty()) {
                    Point point;
                    Cloneable cloneable = VizTiler.this.mStack;
                    synchronized (cloneable) {
                        if (VizTiler.this.mStack.isEmpty()) {
                            continue;
                        }
                        point = (Point)VizTiler.this.mStack.pop();
                    }
                    if (VizTiler.this.mTiles == null) {
                        return;
                    }
                    if (VizTiler.this.mTiles[point.x][point.y] != null && VizTiler.this.mTiles[point.x][point.y].get() != null) continue;
                    this.createTile(point);
                    cloneable = new Rectangle(VizTiler.this.mTileWidth, VizTiler.this.mTileHeight);
                    ((Rectangle)cloneable).translate(point.x * VizTiler.this.mTileWidth, point.y * VizTiler.this.mTileHeight);
                    ((Rectangle)cloneable).grow(1, 1);
                    VizTiler.this.mTableItem.repaint((Rectangle)cloneable);
                }
                VizTiler.this.checkTiles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createTile(Point point) {
            Graphics graphics = null;
            boolean bl = TraceSettings.getTrace((int)0x300000) || TraceSettings.getFileTrace((int)0x300000);
            try {
                if (VizTiler.this.mVisualization == null || VizTiler.this.mTiles == null) {
                    VizTiler.this.clear();
                    VizTiler.this.doVisualizationActualize();
                    return;
                }
                if (bl) {
                    TraceSettings.tracePerformance((String)("TileBuilder.createTile( START ) - " + VizTiler.this.mTableItem.getCoreItem().getDescription()));
                }
                BufferedImage bufferedImage = VizTiler.this.mGraphicsConfiguration.createCompatibleImage(VizTiler.this.mTileWidth, VizTiler.this.mTileHeight);
                graphics = bufferedImage.createGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, VizTiler.this.mTileWidth, VizTiler.this.mTileHeight);
                ((Graphics2D)graphics).translate(-point.x * VizTiler.this.mTileWidth, -point.y * VizTiler.this.mTileHeight);
                Object object = new Graphics2DProcessor((Graphics2D)graphics){

                    public FontRenderContext getFontRenderContext() {
                        return VizTiler.this.mFrc;
                    }
                };
                object.setViewRect((Rectangle2D)new Rectangle(point.x * VizTiler.this.mTileWidth - 1, point.y * VizTiler.this.mTileHeight - 1, VizTiler.this.mTileWidth + 2, VizTiler.this.mTileHeight + 2));
                VizTiler.this.mVisualization.runProcessor((ResultsProcessor)object);
                if (VizTiler.this.mTiles[point.x][point.y] != null) {
                    ImageCache.getImageCache().remove(VizTiler.this.mTiles[point.x][point.y]);
                }
                ((VizTiler)VizTiler.this).mTiles[point.x][point.y] = new ViewerImage(VizTiler.this.mTableItem, bufferedImage, true, true);
                ImageCache.getImageCache().add(VizTiler.this.mTiles[point.x][point.y]);
                if (bl) {
                    TraceSettings.tracePerformance((String)("TileBuilder.createTile( MADE TILE ) - " + VizTiler.this.mTableItem.getCoreItem().getDescription()));
                }
                if (VizTiler.this.mNeedsSize) {
                    VizTiler.this.mNeedsSize = false;
                    VizTiler.this.setItemSize(VizTiler.this.mTotalWidth, VizTiler.this.mTotalHeight);
                    if (bl) {
                        TraceSettings.tracePerformance((String)("TileBuilder.createTile( SET ITEM SIZE ) - " + VizTiler.this.mTableItem.getCoreItem().getDescription()));
                    }
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof VisualizationInterruptedException || throwable.getCause() instanceof VisualizationInterruptedException) {
                    TraceSettings.trace1((String)"Visualization rendering interrupted", (int)15);
                } else if (throwable instanceof OutOfMemoryError || throwable.getCause() instanceof OutOfMemoryError) {
                    AppMgr.getAppMgr().handleOutOfMemoryCondition();
                } else {
                    throwable.printStackTrace();
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
                if (bl) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String string = simpleDateFormat.format(GregorianCalendar.getInstance().getTime());
                    TraceSettings.tracePerformance((String)("TileBuilder.createTile( END ) @ " + string + " - " + "Procedure: " + VizTiler.this.mTableItem.getCoreItem().getProcedureName() + "; Description: " + VizTiler.this.mTableItem.getCoreItem().getDescription()));
                }
            }
        }
    }

    private final class VizBuilder
    extends RenderTask {
        public VizBuilder(ViewerItem viewerItem, Rectangle rectangle) {
            super(viewerItem, rectangle, VizTiler.this.getTaskPriority());
        }

        @Override
        public void run() {
            VizTiler.this.actualizeVisualization();
            VizTiler.this.mTableItem.repaint();
        }
    }
}

