/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.header.RootItem;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerItemListener;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonChartViewerItem;
import com.spss.java_client.ui.doc_types.output.LogViewerItem;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.NotesViewerItem;
import com.spss.java_client.ui.doc_types.output.OutputContextMenu;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.TitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.WarningViewerItem;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerTreePaneDragAdapter;
import com.spss.java_client.ui.doc_types.output.undo.OutputSearchReplaceUndo;
import com.spss.java_client.ui.doc_types.output.undo.OutputUndoableEdit;
import com.spss.java_client.ui.doc_types.output.undo.UndoItemInfo;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class ViewerTreePane
extends JPanel
implements TreeExpansionListener,
IViewerItemListener,
TreeSelectionListener,
IDropListener,
FocusListener {
    private static Vector<ImageIcon> sOpenImages = new Vector();
    private static Vector<ImageIcon> sClosedImages = new Vector();
    private static Cursor sCustomCursor = null;
    private static final ImageIcon FOCUS_ICON = new ImageIcon(ResUtil.getImageResource("NavFocusArrowSmall.png"));
    private static final ImageIcon PAGE_TITLE_ICON = new ImageIcon(ResUtil.getImageResource("NavPageBreakSmall.png"));
    private OutlineTree mTree = null;
    private DefaultTreeModel mTreeModel = null;
    private NavTreeKeyHandler mKeyHandler = new NavTreeKeyHandler();
    private IViewerWindow mWindow = null;
    private TreeImageSize mTreeImageSize = TreeImageSize.small;
    private boolean mIsRootNodeSelected = false;
    private int mCount;
    private LinkedHashSet<Integer> mSelectedRowNumbers;
    private LinkedHashSet<Integer> mUnSelectedRowNumbers;
    private JScrollPane mTreeScroller;
    private KeyAdapter mEditKeyAdapter = null;
    private int mChildHeaderNodes = 0;
    private boolean mToEdit;
    private Rectangle mFocusBounds = null;

    public ViewerTreePane(IViewerWindow iViewerWindow) {
        this(iViewerWindow, true);
    }

    public ViewerTreePane(IViewerWindow iViewerWindow, boolean bl) {
        super(new GridLayout(), bl);
        this.mWindow = iViewerWindow;
        this.init();
        this.loadFontFromPrefs();
        this.mTree.addFocusListener(this);
    }

    public TreeImageSize getTreeImageSize() {
        return this.mTreeImageSize;
    }

    public void setTreeImageSize(TreeImageSize treeImageSize) {
        Object object;
        float f;
        String string;
        int n;
        this.mTreeImageSize = treeImageSize;
        switch (this.mTreeImageSize) {
            default: {
                assert (false);
            }
            case small: {
                n = 17;
                string = "16";
                f = 12.0f;
                break;
            }
            case medium: {
                n = 26;
                string = "24";
                f = 16.0f;
                break;
            }
            case large: {
                n = 34;
                string = "32";
                f = 20.0f;
            }
        }
        this.mTree.setFont(this.mTree.getFont().deriveFont(f));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC && ((FontMetrics)(object = this.getFontMetrics(this.mTree.getFont()))).getMaxAscent() + ((FontMetrics)object).getMaxDescent() > n) {
            n += ((FontMetrics)object).getMaxDescent() + 2;
        }
        this.mTree.setRowHeight(n);
        sOpenImages.setSize(0);
        ViewerTreePane.loadTreeImages(string);
        this.validate();
        object = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences = ((Preferences)object).node("doc_types/output");
        preferences.put("tree_image_size", string);
    }

    public JScrollPane getTreeScroller() {
        return this.mTreeScroller;
    }

    public void editAndSelect(ViewerSearchOptions viewerSearchOptions, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), viewerSearchOptions.getCurrentItem());
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            ViewerItem viewerItem = viewerSearchOptions.getCurrentItem();
            this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
            this.mWindow.setActivePane(IViewerWindow.PaneType.Outline);
            this.mTree.scrollPathToVisible(treePath);
            if (this.mTree.isVisible(treePath)) {
                Container container = this.getTopLevelAncestor();
                if (!(container instanceof ITopWindow)) {
                    return;
                }
                ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
                ViewerFindDlg viewerFindDlg = iTopWindow.getViewerPanel().getSearchDialog();
                boolean bl = viewerFindDlg != null && viewerFindDlg.isVisible();
                this.mToEdit = true;
                boolean bl2 = this.editNodeText(treePath);
                this.mToEdit = false;
                if (bl2) {
                    NavTreeCellEditor navTreeCellEditor = (NavTreeCellEditor)this.mTree.getCellEditor();
                    navTreeCellEditor.select(viewerSearchOptions.getOffset(), n);
                    if (bl) {
                        Rectangle rectangle = this.mTree.getPathBounds(treePath);
                        Point point = new Point(rectangle.x, rectangle.y);
                        SwingUtilities.convertPointToScreen(point, this.mTree);
                        rectangle = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
                        viewerFindDlg.adjustPosition(rectangle);
                    }
                }
            }
        }
    }

    public void replaceEditingTextSelection(String string) {
        if (this.mTree.isEditing()) {
            new OutputSearchReplaceUndo(this.mWindow, this.mTree, string);
        }
    }

    public boolean selectionIsSearchString(String string) {
        if (this.mTree.isEditing()) {
            NavTreeCellEditor navTreeCellEditor = (NavTreeCellEditor)this.mTree.getCellEditor();
            return navTreeCellEditor.matchesSelection(string);
        }
        return false;
    }

    public String getOutlineTitle(ViewerItem viewerItem) {
        String string;
        if (this.mTree.isEditing()) {
            NavTreeCellEditor navTreeCellEditor = (NavTreeCellEditor)this.mTree.getCellEditor();
            string = navTreeCellEditor.getEditingComponent().getText();
        } else {
            string = viewerItem.getCoreItem().getDescription();
        }
        if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
            string = ComponentState.removeBidiDirectionMarks((String)string);
        }
        return string;
    }

    public void commitEdits(ViewerSearchOptions viewerSearchOptions) {
        if (this.mTree.isEditing()) {
            this.mTree.stopEditing();
            if (viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
                this.restoreSelections(viewerSearchOptions);
            }
        }
    }

    public boolean canShowSelections() {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem || !viewerItem.isHidden()) continue;
            return true;
        }
        return false;
    }

    public boolean canHideSelections() {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem || viewerItem.isHidden()) continue;
            return true;
        }
        return false;
    }

    public void showSelections() {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        boolean bl = false;
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem || viewerItem.isVisible()) continue;
            viewerItem.setVisible(true);
            bl = true;
        }
        if (bl) {
            this.mWindow.getDocument().getCoreDocument().setModifiedFlag(true);
        }
        this.validate();
        this.repaint();
        this.mWindow.updateToolbarEnableStatus();
    }

    public void hideSelections() {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        boolean bl = false;
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem || !viewerItem.isVisible()) continue;
            viewerItem.setVisible(false);
            bl = true;
        }
        if (bl) {
            this.mWindow.getDocument().getCoreDocument().setModifiedFlag(true);
        }
        this.validate();
        this.repaint();
        this.mWindow.updateToolbarEnableStatus();
    }

    public boolean getSelectionExpandState(boolean bl) {
        boolean bl2 = false;
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return false;
        }
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (object instanceof DefaultMutableTreeNode && ((viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) instanceof HeaderViewerItem || object == this.mTreeModel.getRoot())) {
                boolean bl3 = bl2 = bl ? this.mTree.isCollapsed(treePath) : this.mTree.isExpanded(treePath);
            }
            if (bl2) break;
        }
        return bl2;
    }

    public void setSelectionExpandState(boolean bl) {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        for (TreePath treePath : treePathArray) {
            ViewerItem viewerItem;
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || (viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) != null && !(viewerItem instanceof HeaderViewerItem)) continue;
            if (bl) {
                this.mTree.expandPath(treePath);
                continue;
            }
            this.mTree.collapsePath(treePath);
        }
    }

    public JTree getViewerTree() {
        return this.mTree;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
        if (object instanceof DefaultMutableTreeNode) {
            this.setExpandedState((DefaultMutableTreeNode)object, true);
            if (viewerItem != null && viewerItem.getCoreItem() instanceof HeaderItem) {
                viewerItem.setCollapsed(false);
                ((HeaderItem)viewerItem.getCoreItem()).setCollapsed(false);
            }
            this.mWindow.updateToolbarEnableStatus();
        }
        if (viewerItem != null && !(viewerItem.getCoreItem() instanceof RootItem)) {
            this.selectNodes(viewerItem.isSelected(), treePath, false, false);
        }
        if (treePath.getLastPathComponent().equals(this.mTree.getModel().getRoot())) {
            this.selectRootNode();
        }
        this.mWindow.enablePromoteDemoteAction();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            this.setExpandedState((DefaultMutableTreeNode)object, false);
            this.mWindow.updateToolbarEnableStatus();
            ViewerItem viewerItem = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem();
            if (viewerItem != null && viewerItem.getCoreItem() instanceof HeaderItem) {
                viewerItem.setCollapsed(true);
                ((HeaderItem)viewerItem.getCoreItem()).setCollapsed(true);
            }
        }
        this.mWindow.enablePromoteDemoteAction();
    }

    public void setVisible(ViewerItem viewerItem) {
        this.toggleItemVisibility(viewerItem, false);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.mWindow != null) {
            this.mWindow.setActivePane(IViewerWindow.PaneType.Outline);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void notifyNewItem(ViewerItem viewerItem, IOutputItem iOutputItem, boolean bl) {
        NavTreeNode navTreeNode = new NavTreeNode(viewerItem, viewerItem.getComponentType(), viewerItem.getName());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(navTreeNode);
        Object object = this.mTreeModel.getRoot();
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object;
            if (iOutputItem instanceof RootItem && viewerItem instanceof LogViewerItem) {
                this.putNode(defaultMutableTreeNode2, defaultMutableTreeNode, 0, bl);
            } else if (iOutputItem instanceof RootItem) {
                this.putNode(defaultMutableTreeNode2, defaultMutableTreeNode, 0, bl);
            } else if (iOutputItem == null && viewerItem instanceof HeaderViewerItem) {
                this.putNode(defaultMutableTreeNode2, defaultMutableTreeNode, -1, bl);
            } else {
                this.addNewNode(defaultMutableTreeNode, bl);
            }
        }
    }

    @Override
    public void notifyRemoveItem(ViewerItem viewerItem) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), viewerItem);
        if (defaultMutableTreeNode != null) {
            this.mTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    @Override
    public void notifyObjectPropertyChange(IOutputItem iOutputItem) {
        if (iOutputItem == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), iOutputItem);
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof NavTreeNode) {
            NavTreeNode navTreeNode = (NavTreeNode)object;
            navTreeNode.setName(iOutputItem.getDescription());
            this.mTreeModel.nodeChanged(defaultMutableTreeNode);
            ViewerItem viewerItem = navTreeNode.getItem();
            if (viewerItem == null) {
                return;
            }
            if (viewerItem != null && iOutputItem.getVisible() != viewerItem.isVisible()) {
                viewerItem.setVisible(iOutputItem.getVisible());
            }
        }
    }

    @Override
    public void notifyEndHeading() {
    }

    @Override
    public void notifyFocusedItem(ViewerItem viewerItem, boolean bl) {
        if (this.mTreeModel == null || this.mTreeModel.getRoot() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), viewerItem);
        if (defaultMutableTreeNode != null) {
            final TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            if (bl && this.mTree != null) {
                this.mTree.scrollPathToVisible(treePath);
            }
            this.invalidateFocusArrow(treePath);
            if (this.mWindow.getActivePane() != IViewerWindow.PaneType.Outline && this.mTree != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ViewerTreePane.this.mTree != null) {
                            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)ViewerTreePane.this.mTree, null, true, null, treePath);
                            ViewerTreePane.this.mTree.fireValueChange(treeSelectionEvent);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void notifySelectionChange(ViewerItem viewerItem, boolean bl, boolean bl2) {
        TreePath treePath;
        boolean bl3;
        DefaultMutableTreeNode defaultMutableTreeNode = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), viewerItem);
        if (defaultMutableTreeNode != null && (bl3 = this.mTree.isPathSelected(treePath = new TreePath(defaultMutableTreeNode.getPath()))) != bl) {
            if (bl) {
                if (bl2) {
                    this.mTree.addSelectionPath(treePath);
                } else {
                    this.mTree.setSelectionPath(treePath);
                }
            } else {
                this.mTree.removeSelectionPath(treePath);
            }
        }
        this.mWindow.updateToolbarEnableStatus();
    }

    @Override
    public void notifyKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    public void notifyClearHeaderSelections() {
        this.mTree.clearSelection();
    }

    public void selectRootNode(boolean bl) {
        if (this.mIsRootNodeSelected) {
            if (bl) {
                this.mTree.removeSelectionInterval(0, this.mTree.getRowCount());
                this.mSelectedRowNumbers.clear();
                this.mIsRootNodeSelected = false;
            } else {
                this.mTree.clearSelection();
                this.mSelectedRowNumbers.clear();
                if (this.editNodeText(this.mTree.getPathForRow(0)) && ((NavTreeCellEditor)this.mTree.getCellEditor()).getEditingComponent() != null) {
                    ((NavTreeCellEditor)this.mTree.getCellEditor()).getEditingComponent().selectAll();
                }
            }
        } else {
            this.mTree.setSelectionInterval(0, this.mTree.getRowCount());
            for (int i = 0; i < this.mTree.getRowCount(); ++i) {
                this.mSelectedRowNumbers.add(i);
            }
            this.mIsRootNodeSelected = true;
        }
    }

    public void selectNodes(boolean bl, TreePath treePath, boolean bl2, boolean bl3) {
        this.mIsRootNodeSelected = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int n = this.mTree.getRowForPath(treePath);
        if (defaultMutableTreeNode.getChildCount() > 0 && !this.mTree.isCollapsed(n)) {
            if (this.mSelectedRowNumbers.contains(n) && bl3) {
                this.mSelectedRowNumbers.clear();
                this.mTree.clearSelection();
                if (this.editNodeText(treePath)) {
                    ((NavTreeCellEditor)this.mTree.getCellEditor()).getEditingComponent().selectAll();
                }
            } else {
                if (!bl2) {
                    this.mSelectedRowNumbers.clear();
                }
                this.mUnSelectedRowNumbers.clear();
                this.recursiveRowCount(defaultMutableTreeNode, n, bl);
                if (bl) {
                    this.mSelectedRowNumbers.add(n);
                    this.setSelection();
                } else {
                    this.mUnSelectedRowNumbers.add(n);
                    for (Integer n2 : this.mUnSelectedRowNumbers) {
                        this.mSelectedRowNumbers.remove(n2);
                    }
                    this.setSelection();
                }
                this.mCount = 0;
            }
        } else if (defaultMutableTreeNode.getChildCount() == 0 && this.mSelectedRowNumbers.contains(n) && bl3) {
            this.mTree.clearSelection();
            if (this.editNodeText(treePath)) {
                ((NavTreeCellEditor)this.mTree.getCellEditor()).getEditingComponent().selectAll();
            }
        }
        if (bl) {
            if (defaultMutableTreeNode.getChildCount() == 0 && !bl2) {
                this.mSelectedRowNumbers.clear();
            }
            this.mSelectedRowNumbers.add(n);
        } else {
            this.removeParentSelection(treePath.getParentPath());
            this.mSelectedRowNumbers.remove(this.mTree.getRowForPath(treePath));
            this.mSelectedRowNumbers.remove(this.mTree.getRowForPath(treePath.getParentPath()));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray;
        for (TreePath treePath : treePathArray = treeSelectionEvent.getPaths()) {
            Object object = treePath.getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            if (viewerItem != null) {
                this.mWindow.getDocument().selectionChanged(viewerItem, treeSelectionEvent.isAddedPath(treePath), false);
                continue;
            }
            this.mWindow.updateToolbarEnableStatus();
        }
        this.mWindow.enablePromoteDemoteAction();
    }

    public void clearChildSelections(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            this.mTree.removeSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
    }

    public boolean isHeaderNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = true;
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof NavTreeNode) {
            ViewerItem viewerItem = ((NavTreeNode)object).getItem();
            bl = viewerItem instanceof HeaderViewerItem;
        }
        return bl;
    }

    public DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, IOutputItem iOutputItem) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof NavTreeNode) {
            ViewerItem viewerItem = ((NavTreeNode)object).getItem();
            if (viewerItem != null && iOutputItem == viewerItem.getCoreItem()) {
                return defaultMutableTreeNode;
            }
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNode(defaultMutableTreeNode2, iOutputItem);
                if (defaultMutableTreeNode3 == null) continue;
                return defaultMutableTreeNode3;
            }
        }
        return null;
    }

    public void connectRootNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        NavTreeNode navTreeNode = (NavTreeNode)defaultMutableTreeNode.getUserObject();
        ViewerItem viewerItem = this.mWindow.getDocument().getViewerItems().get(0);
        navTreeNode.setItem(viewerItem);
        viewerItem.getCoreItem().setDescription(navTreeNode.mName);
    }

    public void setOutlineText(TreePath treePath, String string) {
        this.mTreeModel.valueForPathChanged(treePath, string);
    }

    private boolean editNodeText(TreePath treePath) {
        if (VersionInfo.isSmartReader() && this.mWindow.getDocument().getCoreDocument().isLocked()) {
            this.mTree.setSelectionPath(treePath);
            return false;
        }
        this.mTree.startEditingAtPath(treePath);
        return this.mTree.isEditing();
    }

    private void restoreSelections(ViewerSearchOptions viewerSearchOptions) {
        ViewerItem[] viewerItemArray = viewerSearchOptions.getSelectedItems();
        if (viewerItemArray == null) {
            return;
        }
        boolean bl = true;
        for (ViewerItem viewerItem : viewerItemArray) {
            this.mWindow.getDocument().selectionChanged(viewerItem, true, !bl);
            bl = false;
        }
    }

    private void loadFontFromPrefs() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/output");
        String string = preferences2.get("font_family", PrefDefaults.DEF_VIEWER_FONT_FAMILY);
        int n = preferences2.getInt("font_style", 0);
        int n2 = this.mTree.getFont().getSize();
        Font font = FontUtil.makeFont((String)string, (int)n, (float)n2);
        this.mTree.setFont(font);
        String string2 = preferences2.get("tree_image_size", "16");
        this.mTreeImageSize = TreeImageSize.small;
        if (string2.equals("24")) {
            this.mTreeImageSize = TreeImageSize.medium;
        } else if (string2.equals("32")) {
            this.mTreeImageSize = TreeImageSize.large;
        }
        this.setTreeImageSize(this.getTreeImageSize());
    }

    private void putNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n, boolean bl) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        }
        int n2 = defaultMutableTreeNode.getChildCount();
        int n3 = n = n < 0 ? n2 : n;
        if (n <= n2) {
            this.mTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            this.mTree.expandPath(new TreePath(defaultMutableTreeNode3.getPath()));
            if (bl) {
                TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
                this.mTree.scrollVerticallyToVisible(treePath);
            }
        }
    }

    private DefaultMutableTreeNode findNode(DefaultMutableTreeNode defaultMutableTreeNode, ViewerItem viewerItem) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof NavTreeNode) {
            ViewerItem viewerItem2 = ((NavTreeNode)object).getItem();
            if (viewerItem == viewerItem2) {
                return defaultMutableTreeNode;
            }
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.findNode(defaultMutableTreeNode2, viewerItem);
                if (defaultMutableTreeNode3 == null) continue;
                return defaultMutableTreeNode3;
            }
        }
        return null;
    }

    private void toggleItemVisibility(ViewerItem viewerItem, boolean bl) {
        viewerItem.setVisible(!viewerItem.isVisible());
        this.mWindow.getDocument().getCoreDocument().setModifiedFlag(true);
        this.validate();
        this.repaint();
        if (bl) {
            this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
        }
        this.mWindow.updateToolbarEnableStatus();
    }

    private void setExpandedState(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode2.getUserObject()).getItem();
            if (viewerItem != null) {
                viewerItem.setCollapsed(!bl);
                this.mWindow.getDocument().getCoreDocument().setModifiedFlag(true);
            }
            if (!this.isHeaderNode(defaultMutableTreeNode2)) continue;
            this.setExpandedState(defaultMutableTreeNode2, bl);
        }
    }

    private void renderPageBreaks(Graphics graphics) {
        ViewerDocument viewerDocument;
        ViewerDocument viewerDocument2 = viewerDocument = this.mWindow == null ? null : this.mWindow.getDocument();
        if (viewerDocument != null) {
            for (ViewerItem viewerItem : viewerDocument.getViewerItems()) {
                if (!viewerItem.getPageBreak() || viewerItem instanceof HeaderViewerItem) continue;
                this.renderDecoration(graphics, viewerItem, PAGE_TITLE_ICON.getImage(), true);
            }
        }
    }

    private void renderFocus(Graphics graphics) {
        if (this.mWindow != null && this.mWindow.getDocument() != null) {
            ViewerItem viewerItem = this.mWindow.getDocument().getFocusedViewerItem();
            Image image = FOCUS_ICON.getImage();
            this.renderDecoration(graphics, viewerItem, image, false);
        }
    }

    private void renderDecoration(Graphics graphics, ViewerItem viewerItem, Image image, boolean bl) {
        Rectangle rectangle;
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode = viewerItem != null ? this.findNode(defaultMutableTreeNode2, viewerItem) : defaultMutableTreeNode2;
        if (defaultMutableTreeNode != null && (rectangle = this.mTree.getPathBounds(new TreePath(defaultMutableTreeNode.getPath()))) != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            int n3 = bl ? rectangle.y : (int)((double)rectangle.y + (rectangle.getHeight() - (double)n2) / 2.0);
            int n4 = this.getComponentOrientation().isLeftToRight() ? rectangle.x - n - 2 : (int)rectangle.getMaxX();
            graphics.drawImage(image, n4, n3, null);
        }
    }

    private void addNewNode(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof NavTreeNode) {
            ViewerItem viewerItem = ((NavTreeNode)object).getItem();
            IOutputItem iOutputItem = viewerItem.getCoreItem().getParentItem();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.findNode((DefaultMutableTreeNode)this.mTreeModel.getRoot(), iOutputItem);
            int n = ((HeaderItem)iOutputItem).getItemIndex(viewerItem.getCoreItem());
            this.putNode(defaultMutableTreeNode2, defaultMutableTreeNode, n, bl);
        }
    }

    private void handleTreeKeyEvent(KeyEvent keyEvent) {
        Object object;
        Object object2;
        ViewerItem viewerItem = this.mWindow.getDocument().getFocusedViewerItem();
        ViewerItem viewerItem2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        DefaultMutableTreeNode defaultMutableTreeNode2 = viewerItem != null ? this.findNode(defaultMutableTreeNode, viewerItem) : defaultMutableTreeNode;
        Serializable serializable = null;
        boolean bl = false;
        int n = keyEvent.getKeyCode();
        if (n == 36 || n == 35) {
            object2 = n == 36 ? this.mTree.getPathForRow(0) : this.mTree.getPathForRow(this.mTree.getRowCount() - 1);
            object = object2 != null ? ((TreePath)object2).getLastPathComponent() : null;
            Serializable serializable2 = serializable = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
            if (serializable != null) {
                viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem();
                bl = true;
            }
        } else if (n == 38) {
            if (!defaultMutableTreeNode2.isRoot()) {
                object2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                TreeNode treeNode = ((DefaultMutableTreeNode)object2).getChildBefore(defaultMutableTreeNode2);
                if (treeNode != null) {
                    serializable = (DefaultMutableTreeNode)treeNode;
                    if (!((DefaultMutableTreeNode)serializable).isLeaf()) {
                        serializable = this.findLastVisibleChildNode((DefaultMutableTreeNode)treeNode);
                    }
                } else {
                    serializable = object2;
                }
                viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem();
                bl = true;
            }
        } else if (n == 40) {
            if (defaultMutableTreeNode2.isRoot()) {
                TreeNode treeNode;
                TreeNode treeNode2 = treeNode = defaultMutableTreeNode2.getChildCount() > 0 ? defaultMutableTreeNode2.getFirstChild() : null;
                if (treeNode != null && this.mTree.isVisible(new TreePath(((DefaultMutableTreeNode)treeNode).getPath()))) {
                    serializable = (DefaultMutableTreeNode)treeNode;
                }
            } else {
                TreeNode treeNode;
                object2 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                TreeNode treeNode3 = treeNode = defaultMutableTreeNode2.getChildCount() > 0 ? defaultMutableTreeNode2.getFirstChild() : null;
                if (treeNode == null || !this.mTree.isVisible(new TreePath(((DefaultMutableTreeNode)treeNode).getPath()))) {
                    treeNode = ((DefaultMutableTreeNode)object2).getChildAfter(defaultMutableTreeNode2);
                    while (!(object2 == defaultMutableTreeNode || treeNode != null && this.mTree.isVisible(new TreePath(((DefaultMutableTreeNode)treeNode).getPath())))) {
                        object = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
                        treeNode = ((DefaultMutableTreeNode)object).getChildAfter((TreeNode)object2);
                        object2 = object;
                    }
                }
                if (treeNode != null) {
                    serializable = (DefaultMutableTreeNode)treeNode;
                }
            }
            if (serializable != null) {
                viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem();
                bl = true;
            }
        } else if (n == 37) {
            object2 = new TreePath(defaultMutableTreeNode2.getPath());
            if (defaultMutableTreeNode2.isRoot() || viewerItem instanceof HeaderViewerItem) {
                if (this.mTree.isExpanded((TreePath)object2)) {
                    this.mTree.collapsePath((TreePath)object2);
                } else if (viewerItem instanceof HeaderViewerItem) {
                    serializable = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                    viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem();
                    bl = true;
                }
            }
        } else if (n == 39) {
            object2 = new TreePath(defaultMutableTreeNode2.getPath());
            if (defaultMutableTreeNode2.isRoot() || viewerItem instanceof HeaderViewerItem) {
                if (this.mTree.isCollapsed((TreePath)object2)) {
                    this.mTree.expandPath((TreePath)object2);
                } else if (defaultMutableTreeNode2.getChildCount() > 0) {
                    serializable = (DefaultMutableTreeNode)defaultMutableTreeNode2.getFirstChild();
                    viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem();
                    bl = true;
                }
            }
        } else if (n == 33 || n == 34) {
            this.mWindow.getDocument().notifyKeyEvent(keyEvent);
        }
        if (serializable != null) {
            object2 = new TreePath(((DefaultMutableTreeNode)serializable).getPath());
            object = new TreeSelectionEvent((Object)this.mTree, null, true, null, (TreePath)object2);
            this.mTree.setLeadSelectionPath((TreePath)object2);
            this.mTree.fireValueChange((TreeSelectionEvent)object);
        }
        if (bl) {
            this.mWindow.getDocument().setFocusedViewerItem(viewerItem2);
        }
    }

    private DefaultMutableTreeNode findLastVisibleChildNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        TreeNode treeNode = defaultMutableTreeNode.getLastChild();
        if (!this.mTree.isVisible(new TreePath(((DefaultMutableTreeNode)treeNode).getPath()))) {
            return defaultMutableTreeNode;
        }
        if (treeNode.isLeaf()) {
            return (DefaultMutableTreeNode)treeNode;
        }
        return this.findLastVisibleChildNode((DefaultMutableTreeNode)treeNode);
    }

    private void invalidateFocusArrow(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Rectangle rectangle = this.mTree.getPathBounds(treePath);
        if (rectangle == null) {
            return;
        }
        final Rectangle rectangle2 = SwingUtilities.convertRectangle(this.mTree, this.mTree.getPathBounds(treePath), this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                rectangle2.x -= 10;
                rectangle2.width = 30;
                ViewerTreePane.this.repaint(rectangle2);
                if (ViewerTreePane.this.mFocusBounds != null) {
                    ViewerTreePane.this.repaint(ViewerTreePane.this.mFocusBounds);
                }
                ViewerTreePane.this.mFocusBounds = rectangle2;
            }
        });
    }

    private ImageIcon getNodeIcon(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        ViewerItem viewerItem = null;
        int n = ViewerDocument.ComponentType.generic.ordinal();
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 instanceof NavTreeNode) {
            object = (NavTreeNode)object2;
            n = ((NavTreeNode)object).getType().ordinal();
            viewerItem = ((NavTreeNode)object).getItem();
        }
        if (viewerItem == null || viewerItem instanceof HeaderViewerItem) {
            boolean bl = true;
            if (defaultMutableTreeNode.getChildCount() > 0) {
                bl = this.mTree.isVisible(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild()).getPath()));
            }
            object = bl ? sOpenImages.get(n) : sClosedImages.get(n);
        } else {
            object = viewerItem instanceof ChartViewerItem && !viewerItem.getCoreItem().isEditable() ? (viewerItem.isVisible() ? sOpenImages.get(ViewerDocument.ComponentType.image.ordinal()) : sClosedImages.get(ViewerDocument.ComponentType.image.ordinal())) : (viewerItem instanceof GenericViewerItem && ((GenericItem)viewerItem.getCoreItem()).isTreeImage() ? (viewerItem.isVisible() ? sOpenImages.get(ViewerDocument.ComponentType.tree.ordinal()) : sClosedImages.get(ViewerDocument.ComponentType.tree.ordinal())) : (viewerItem.isVisible() ? sOpenImages.get(n) : sClosedImages.get(n)));
        }
        return object;
    }

    private void init() {
        Object object;
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.white);
        }
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            Locale.setDefault(ComponentState.getOLangLocale());
            ResUtil.setLocale(ComponentState.getOLangLocale());
        }
        String string = ResUtil.getString("IDS_OUTPUT_NODE");
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            Locale.setDefault(ComponentState.getILangLocale());
            ResUtil.setLocale(ComponentState.getILangLocale());
        }
        NavTreeNode navTreeNode = new NavTreeNode(null, ViewerDocument.ComponentType.header, string);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(navTreeNode);
        this.mTreeModel = new DefaultTreeModel(defaultMutableTreeNode){

            @Override
            public void valueForPathChanged(TreePath treePath, Object object) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object2 = defaultMutableTreeNode.getUserObject();
                if (object2 instanceof NavTreeNode) {
                    NavTreeNode navTreeNode = (NavTreeNode)object2;
                    String string = object.toString();
                    if (!string.equals(navTreeNode.getItem().getCoreItem().getDescription())) {
                        navTreeNode.setName(string);
                        navTreeNode.getItem().getCoreItem().setDescription(string);
                        this.nodeChanged(defaultMutableTreeNode);
                        ViewerTreePane.this.mWindow.getDocument().getCoreDocument().setModifiedFlag(true);
                        ViewerTreePane.this.mWindow.getDocument().notifyChangedModifiedFlag();
                    }
                }
            }
        };
        this.mTree = new OutlineTree(this.mTreeModel);
        this.setTreeImageSize(this.mTreeImageSize);
        NavTreeCellRenderer navTreeCellRenderer = new NavTreeCellRenderer();
        this.mTree.setCellRenderer(navTreeCellRenderer);
        this.mTree.setCellEditor(new NavTreeCellEditor(this.mTree, navTreeCellRenderer));
        this.mTree.setShowsRootHandles(true);
        this.mTree.setEditable(true);
        this.mTree.setInvokesStopCellEditing(true);
        this.mTree.addTreeExpansionListener(this);
        TreeUI treeUI = this.mTree.getUI();
        if (treeUI instanceof BasicTreeUI) {
            object = (BasicTreeUI)treeUI;
            int n = ((BasicTreeUI)object).getRightChildIndent();
            ((BasicTreeUI)object).setRightChildIndent(n + 5);
        }
        this.mTree.addTreeSelectionListener(this);
        this.mTree.addKeyListener(this.mKeyHandler);
        this.mTreeScroller = new JScrollPane(this.mTree);
        this.add(this.mTreeScroller);
        this.mWindow.getDocument().addItemListener(this);
        object = this.mTree.getSelectionModel();
        object.setSelectionMode(4);
        this.mTree.setSelectionModel((TreeSelectionModel)object);
        this.mSelectedRowNumbers = new LinkedHashSet();
        this.mUnSelectedRowNumbers = new LinkedHashSet();
    }

    public void performClose() {
        Serializable serializable;
        if (this.mTree != null) {
            this.mTree.removeAll();
            this.mTree.setCellEditor(null);
            this.mTree.setCellRenderer(null);
            this.mTree.setUI(null);
            this.mTree.removeFocusListener(this);
            this.mTree.removeTreeExpansionListener(this);
            this.mTree.removeTreeSelectionListener(this);
            this.mTree.removeKeyListener(this.mKeyHandler);
            this.mTree = null;
        }
        this.mKeyHandler = null;
        if (this.mTreeModel != null) {
            serializable = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)serializable).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                defaultMutableTreeNode.removeFromParent();
                defaultMutableTreeNode.setUserObject(null);
            }
            this.mTreeModel = null;
        }
        this.mWindow = null;
        this.removeAll();
        serializable = this.getParent();
        if (serializable != null) {
            ((Container)serializable).removeAll();
            ((Container)serializable).remove((Component)serializable);
        }
    }

    private void setSelection() {
        int[] nArray = new int[this.mSelectedRowNumbers.size()];
        Iterator iterator = this.mSelectedRowNumbers.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        this.mTree.setSelectionRows(nArray);
    }

    private void selectRootNode() {
        if (this.mIsRootNodeSelected) {
            this.mTree.setSelectionInterval(0, this.mTree.getRowCount());
        }
    }

    private void removeParentSelection(TreePath treePath) {
        int n = this.mTree.getRowForPath(treePath);
        this.mTree.removeSelectionInterval(n, n);
        this.mSelectedRowNumbers.remove(this.mTree.getRowForPath(treePath));
        if (treePath != null && treePath.getParentPath() != null) {
            this.removeParentSelection(treePath.getParentPath());
        }
    }

    private void recursiveRowCount(DefaultMutableTreeNode defaultMutableTreeNode, int n, boolean bl) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            ++this.mCount;
            if (bl) {
                this.mSelectedRowNumbers.add(n + this.mCount);
            } else {
                this.mUnSelectedRowNumbers.add(n + this.mCount);
            }
            if (defaultMutableTreeNode.getChildAt(i).getChildCount() <= 0 || this.mTree.isCollapsed(this.mCount + n)) continue;
            this.recursiveRowCount((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), n, bl);
        }
    }

    private static void loadTreeImages(String string) {
        if (sOpenImages.size() != 0 && sClosedImages.size() != 0) {
            return;
        }
        String[] stringArray = new String[]{"NavTreeHeader", "NavTreeTitle", "NavTreePageTitle", "NavTreeTable", "NavTreeLightTable", "NavTreeNotes", "NavTreeChart", "NavTreeTreeModel", "NavTreeText", "NavTreeLog", "NavTreeWarning", "NavTreeGeneric", "NavTreeModel", "NavTreeGraphBoard", "NavTreeImage", "NavTreeJsonChart", "NavTreeUnknown"};
        String string2 = "";
        try {
            sOpenImages.setSize(stringArray.length);
            sClosedImages.setSize(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i] + "Open" + string + ".png";
                sOpenImages.set(i, new ImageIcon(ResUtil.getImageResource(string2)));
                string2 = stringArray[i] + "Closed" + string + ".png";
                sClosedImages.set(i, new ImageIcon(ResUtil.getImageResource(string2)));
            }
        }
        catch (Exception exception) {
            ComponentState.trace1((String)("Can't load image: " + string2), (int)15);
            exception.printStackTrace();
        }
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mTree);
        if (dragDropAdapter instanceof ViewerTreePaneDragAdapter) {
            int[] nArray = ((ViewerTreePaneDragAdapter)dragDropAdapter).getDraggedRows();
            TreePath treePath = this.mTree.getPathForLocation(point2.x, point2.y);
            if (treePath != null) {
                int n = this.mTree.getRowForPath(treePath);
                treePath = this.mTree.getPathForRow(n);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
                Graphics graphics = this.mTree.getGraphics();
                this.renderFocus(graphics);
                graphics.dispose();
                if (this.isDropRowInDraggedRows(n, nArray)) {
                    cursor = DragPane.getNoDropCursor();
                } else {
                    if (sCustomCursor == null) {
                        ImageIcon imageIcon = new ImageIcon(ResUtil.getImageResource(ResUtil.getString("IDS_MOVE_CURSOR_IMAGE")));
                        sCustomCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(0, 0), "tree pane cursor");
                    }
                    cursor = sCustomCursor;
                }
            } else {
                cursor = DragPane.getNoDropCursor();
            }
        }
        return cursor;
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        return dragDropAdapter.getTransferData() instanceof Vector;
    }

    public void itemDropped(DropEvent dropEvent) {
        Component component = dropEvent.getSource();
        Point point = (Point)dropEvent.getDropLocation().clone();
        SwingUtilities.convertPointFromScreen(point, this.mTree);
        if (component instanceof JTree) {
            IOutputItem iOutputItem;
            ViewerItem viewerItem;
            DefaultMutableTreeNode defaultMutableTreeNode;
            UndoItemInfo undoItemInfo;
            Object object;
            int n;
            HeaderItem headerItem;
            IOutputItem iOutputItem2;
            Cloneable cloneable2;
            Object object2 = dropEvent.getDragSourceAdapter().getTransferData();
            if (object2 == null || !(object2 instanceof Vector)) {
                return;
            }
            TreePath treePath = this.mTree.getPathForLocation(point.x, point.y);
            if (treePath == null) {
                return;
            }
            int[] nArray = ((ViewerTreePaneDragAdapter)dropEvent.getDragSourceAdapter()).getDraggedRows();
            int n2 = this.mTree.getRowForPath(treePath);
            if (this.isDropRowInDraggedRows(n2, nArray)) {
                return;
            }
            Object object3 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Vector vector = (Vector)object2;
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            for (Cloneable cloneable2 : vector) {
                iOutputItem2 = ((NavTreeNode)((DefaultMutableTreeNode)cloneable2).getUserObject()).getItem().getCoreItem();
                headerItem = (HeaderItem)iOutputItem2.getParentItem();
                n = headerItem.getItemIndex(iOutputItem2);
                object = n == 0 ? headerItem : headerItem.getChildItem(n - 1);
                undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)object);
                linkedHashMap.put(iOutputItem2, undoItemInfo);
                if (!this.isHeaderNode((DefaultMutableTreeNode)cloneable2)) continue;
                object = iOutputItem2;
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)cloneable2).children();
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                    iOutputItem = viewerItem.getCoreItem();
                    undoItemInfo = new UndoItemInfo(iOutputItem2, (IOutputItem)object);
                    linkedHashMap.put(iOutputItem, undoItemInfo);
                    object = viewerItem.getCoreItem();
                }
            }
            Object object4 = ((NavTreeNode)((DefaultMutableTreeNode)object3).getUserObject()).getItem();
            cloneable2 = new HashMap();
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : vector) {
                ((HashMap)cloneable2).put(defaultMutableTreeNode2, false);
            }
            int n3 = 0;
            for (Object object5 : vector) {
                if (((Boolean)((HashMap)cloneable2).get(object5)).booleanValue()) continue;
                Serializable serializable = ((NavTreeNode)((DefaultMutableTreeNode)object5).getUserObject()).getItem();
                if (this.isHeaderNode((DefaultMutableTreeNode)object5)) {
                    boolean bl;
                    if (((DefaultMutableTreeNode)object5).getParent().equals(object3)) {
                        bl = !this.mTree.isExpanded(new TreePath(((DefaultMutableTreeNode)object3).getPath()));
                    } else if (((DefaultMutableTreeNode)object3).getChildCount() == 0) {
                        bl = false;
                    } else if (this.isHeaderNode((DefaultMutableTreeNode)object3)) {
                        bl = true;
                        if (this.mTree.isExpanded(new TreePath(((DefaultMutableTreeNode)object3).getPath()))) {
                            bl = n3 > 0;
                        }
                    } else {
                        bl = false;
                    }
                    this.addChildren((DefaultMutableTreeNode)object5, (DefaultMutableTreeNode)object3, (HashMap<DefaultMutableTreeNode, Boolean>)cloneable2, bl);
                    object3 = object5;
                    object4 = ((NavTreeNode)((DefaultMutableTreeNode)object3).getUserObject()).getItem();
                    ++n3;
                    this.mChildHeaderNodes = 0;
                    continue;
                }
                boolean bl = ((DefaultMutableTreeNode)object3).getChildCount() != 0 && !this.mTree.isExpanded(new TreePath(((DefaultMutableTreeNode)object3).getPath()));
                this.mWindow.getDocument().getCoreDocument().deleteItem(((ViewerItem)serializable).getCoreItem());
                this.mWindow.getDocument().getCoreDocument().insertItem(((ViewerItem)serializable).getCoreItem(), ((ViewerItem)object4).getCoreItem(), bl);
                object4 = serializable;
                object3 = object5;
                ((HashMap)cloneable2).put(object5, true);
            }
            LinkedHashMap linkedHashMap2 = new LinkedHashMap();
            for (Serializable serializable : vector) {
                iOutputItem2 = ((NavTreeNode)((DefaultMutableTreeNode)serializable).getUserObject()).getItem().getCoreItem();
                headerItem = (HeaderItem)iOutputItem2.getParentItem();
                n = headerItem.getItemIndex(iOutputItem2);
                object = n == 0 ? headerItem : headerItem.getChildItem(n - 1);
                undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)object);
                linkedHashMap2.put(iOutputItem2, undoItemInfo);
                if (!this.isHeaderNode((DefaultMutableTreeNode)serializable)) continue;
                object = iOutputItem2;
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)serializable).children();
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                    iOutputItem = viewerItem.getCoreItem();
                    undoItemInfo = new UndoItemInfo(iOutputItem2, (IOutputItem)object);
                    linkedHashMap2.put(iOutputItem, undoItemInfo);
                    object = viewerItem.getCoreItem();
                }
            }
            new OutputUndoableEdit(this.mWindow, linkedHashMap, linkedHashMap2, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private DefaultMutableTreeNode addChildren(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode object, HashMap<DefaultMutableTreeNode, Boolean> hashMap, boolean bl) {
        void var11_14;
        Object object3;
        ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
        ViewerItem viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem();
        Vector<IOutputItem> vector = new Vector<IOutputItem>();
        if (viewerItem.getCoreItem() instanceof HeaderItem) {
            object3 = (HeaderItem)viewerItem.getCoreItem();
            vector.add((IOutputItem)object3);
            for (int i = 0; i < object3.getChildCount(); ++i) {
                IOutputItem iOutputItem = object3.getChildItem(i);
                vector.add(iOutputItem);
                if (!(iOutputItem instanceof HeaderItem)) continue;
                this.deleteOneHeader((HeaderItem)iOutputItem, vector);
            }
            for (IOutputItem object22 : vector) {
                this.mWindow.getDocument().getCoreDocument().deleteItem(object22);
            }
        }
        object3 = viewerItem2 == null ? this.mWindow.getDocument().getCoreDocument().getRootItem() : viewerItem2.getCoreItem();
        this.mWindow.getDocument().getCoreDocument().insertItem(viewerItem.getCoreItem(), (IOutputItem)object3, bl);
        object = defaultMutableTreeNode;
        viewerItem2 = viewerItem;
        hashMap.put(defaultMutableTreeNode, true);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        Object var11_13 = null;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (this.isHeaderNode(defaultMutableTreeNode2)) {
                if (defaultMutableTreeNode2.getParent().equals(object)) {
                    bl = false;
                } else if (this.isHeaderNode((DefaultMutableTreeNode)object)) {
                    if (((DefaultMutableTreeNode)object).getChildCount() == 0) {
                        bl = false;
                    } else {
                        bl = true;
                        if (this.mTree.isExpanded(new TreePath(((DefaultMutableTreeNode)object).getPath()))) {
                            bl = this.mChildHeaderNodes > 0;
                        }
                    }
                } else {
                    bl = false;
                }
                ++this.mChildHeaderNodes;
                this.addChildren(defaultMutableTreeNode2, (DefaultMutableTreeNode)object, hashMap, bl);
                object = defaultMutableTreeNode2;
                viewerItem2 = ((NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem();
                continue;
            }
            bl = !defaultMutableTreeNode2.getParent().equals(object);
            ViewerItem viewerItem3 = ((NavTreeNode)defaultMutableTreeNode2.getUserObject()).getItem();
            IOutputItem iOutputItem = viewerItem3.getCoreItem();
            this.mWindow.getDocument().getCoreDocument().insertItem(iOutputItem, viewerItem2.getCoreItem(), bl);
            viewerItem2 = viewerItem3;
            object = defaultMutableTreeNode2;
            hashMap.put(defaultMutableTreeNode2, true);
        }
        return var11_14;
    }

    private void deleteOneHeader(HeaderItem headerItem, Vector<IOutputItem> vector) {
        for (int i = 0; i < headerItem.getChildCount(); ++i) {
            IOutputItem iOutputItem = headerItem.getChildItem(i);
            vector.add(iOutputItem);
            if (!(iOutputItem instanceof HeaderItem)) continue;
            this.deleteOneHeader((HeaderItem)iOutputItem, vector);
        }
    }

    private boolean isDropRowInDraggedRows(int n, int[] nArray) {
        boolean bl = false;
        for (int n2 : nArray) {
            if (n2 != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void initPopup(MouseEvent mouseEvent, boolean bl) {
        if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive() && mouseEvent.getClickCount() == 1) {
            TreePath treePath = this.mTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (treePath != null) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                if (bl) {
                    object = this.mTree.getSelectionPaths();
                    boolean bl2 = false;
                    if (object != null) {
                        for (int i = 0; i < ((TreePath[])object).length; ++i) {
                            TreePath treePath2 = object[i];
                            if (treePath2 != treePath) continue;
                            bl2 = true;
                            break;
                        }
                    }
                    if (bl2 && !(viewerItem instanceof HeaderViewerItem)) {
                        mouseEvent.consume();
                    }
                    this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
                }
                if (!(bl || mouseEvent.isShiftDown() || SwingUtilities.isRightMouseButton(mouseEvent))) {
                    if (viewerItem.isSelected() && this.mTree.getSelectionCount() > 1 && !mouseEvent.isControlDown()) {
                        this.mTree.clearSelection();
                        this.mTree.setSelectionPath(treePath);
                        viewerItem.getCoreItem().setSelected(true);
                        this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
                    }
                    this.mWindow.getDocument().selectionChanged(viewerItem, viewerItem.isSelected(), mouseEvent.isControlDown());
                    if (viewerItem instanceof HeaderViewerItem && viewerItem.isSelected()) {
                        this.selectNodes(true, treePath, mouseEvent.isControlDown(), false);
                    }
                }
                if (mouseEvent.isPopupTrigger()) {
                    object = new OutputContextMenu(viewerItem, 1);
                    ((JPopupMenu)object).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else if (mouseEvent.isPopupTrigger()) {
                OutputContextMenu outputContextMenu = new OutputContextMenu(this);
                outputContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.mTree.clearSelection();
            }
        }
    }

    class OutlineTree
    extends JTree {
        public OutlineTree(DefaultTreeModel defaultTreeModel) {
            super(defaultTreeModel);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ViewerTreePane.this.renderFocus(graphics);
            ViewerTreePane.this.renderPageBreaks(graphics);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            MouseListener[] mouseListenerArray = this.getMouseListeners();
            if (mouseEvent.getID() == 501) {
                ViewerTreePane.this.initPopup(mouseEvent, true);
                this.initPop2();
            }
            if (mouseEvent.getID() == 500) {
                this.processMouseClicked(mouseEvent);
            }
            if (mouseEvent.getID() == 502) {
                this.handleShiftDown(mouseEvent);
                ViewerTreePane.this.initPopup(mouseEvent, false);
            }
            super.processMouseEvent(mouseEvent);
        }

        private void initPop2() {
            ViewerItem viewerItem = ViewerTreePane.this.mWindow.getDocument().getFocusedViewerItem();
            if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) {
                viewerItem.endEdit();
            }
            ViewerTreePane.this.mWindow.endInPlaceEdits();
        }

        public void handleShiftDown(MouseEvent mouseEvent) {
            TreePath treePath;
            if (mouseEvent.getClickCount() == 1 && mouseEvent.isShiftDown() && (treePath = ViewerTreePane.this.mTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y)) != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                ViewerTreePane.this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
                int n = ViewerTreePane.this.mTree.getRowForPath(treePath);
                int[] nArray = ViewerTreePane.this.mTree.getSelectionRows();
                TreePath treePath2 = ViewerTreePane.this.mTree.getAnchorSelectionPath();
                if (nArray != null && nArray.length > 0) {
                    int n2 = nArray[nArray.length - 1];
                    if (n2 > n) {
                        ViewerTreePane.this.mTree.setSelectionInterval(n, n2);
                    } else if (n2 < n) {
                        ViewerTreePane.this.mTree.setSelectionInterval(n2, n);
                    }
                    TreePath treePath3 = ViewerTreePane.this.mTree.getPathForRow(n2);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath3.getLastPathComponent();
                    if (defaultMutableTreeNode2.getChildCount() > 0) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2.getLastLeaf();
                        TreePath treePath4 = new TreePath(defaultMutableTreeNode3.getPath());
                        int n3 = ViewerTreePane.this.mTree.getRowForPath(treePath4);
                        ViewerTreePane.this.mTree.addSelectionInterval(n2 + 1, n3);
                        ViewerTreePane.this.mTree.setAnchorSelectionPath(treePath2);
                    }
                }
            }
        }

        private void processMouseClicked(MouseEvent mouseEvent) {
            TreePath treePath = ViewerTreePane.this.mTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            int n = ViewerTreePane.this.mTree.getRowForPath(treePath);
            ViewerTreePane.this.mToEdit = !SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive() && ViewerTreePane.this.mSelectedRowNumbers.contains(n) && mouseEvent.getButton() == 1 && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown();
            StatusBar statusBar = ViewerTreePane.this.mWindow.getStatusBar();
            if (statusBar != null) {
                statusBar.putPaneMessage(StatusBar.StatusPane.objectSizePane, "      ");
                statusBar.putPaneMessage(StatusBar.StatusPane.helpPane, "      ");
            }
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                if (viewerItem != null) {
                    boolean bl;
                    ImageIcon imageIcon = ViewerTreePane.this.getNodeIcon(defaultMutableTreeNode);
                    int n2 = imageIcon.getIconWidth();
                    int n3 = imageIcon.getIconHeight();
                    Rectangle rectangle = ViewerTreePane.this.mTree.getRowBounds(n);
                    boolean bl2 = bl = mouseEvent.getPoint().x > rectangle.x + n2 || mouseEvent.getPoint().y > rectangle.y + n3;
                    if (mouseEvent.getClickCount() > 1) {
                        if (viewerItem.isSelected()) {
                            if (!bl) {
                                ViewerTreePane.this.toggleItemVisibility(viewerItem, true);
                            }
                        } else {
                            ViewerTreePane.this.toggleItemVisibility(viewerItem, true);
                        }
                        if (!treePath.getLastPathComponent().equals(ViewerTreePane.this.mTree.getModel().getRoot()) && bl) {
                            ViewerTreePane.this.selectNodes(viewerItem.isSelected(), treePath, mouseEvent.isControlDown(), ViewerTreePane.this.mToEdit);
                        }
                    } else if (!mouseEvent.isShiftDown() && !treePath.getLastPathComponent().equals(ViewerTreePane.this.mTree.getModel().getRoot())) {
                        if (ViewerTreePane.this.mToEdit) {
                            if (bl) {
                                ViewerTreePane.this.selectNodes(viewerItem.isSelected(), treePath, mouseEvent.isControlDown(), ViewerTreePane.this.mToEdit);
                            }
                        } else if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                            ViewerTreePane.this.selectNodes(viewerItem.isSelected(), treePath, mouseEvent.isControlDown(), ViewerTreePane.this.mToEdit);
                        }
                    }
                    Dimension dimension = viewerItem.getSize();
                    double d = (int)dimension.getHeight();
                    double d2 = (int)dimension.getWidth();
                    Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
                    String string = preferences.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
                    int n4 = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string);
                    int n5 = Toolkit.getDefaultToolkit().getScreenResolution();
                    double d3 = (double)n5 / 2.54;
                    String string2 = " pt.";
                    switch (n4) {
                        case 1: {
                            d /= (double)n5;
                            d2 /= (double)n5;
                            string2 = " in";
                            break;
                        }
                        case 2: {
                            d /= d3;
                            d2 /= d3;
                            string2 = " cm";
                        }
                    }
                    if (d != 0.0 && d2 != 0.0) {
                        String string3;
                        if (n4 == 0) {
                            string3 = "H: " + (int)d + ", W: " + (int)d2 + string2;
                        } else {
                            NumberFormat numberFormat = NumberFormat.getNumberInstance();
                            numberFormat.setMaximumFractionDigits(2);
                            string3 = "H: " + numberFormat.format(d) + ", W: " + numberFormat.format(d2) + string2;
                        }
                        if (statusBar != null) {
                            statusBar.putPaneMessage(StatusBar.StatusPane.objectSizePane, string3);
                        }
                    }
                    this.setStatusBarHelpMsg(statusBar, viewerItem);
                }
                if (treePath.getLastPathComponent().equals(ViewerTreePane.this.mTree.getModel().getRoot())) {
                    ViewerTreePane.this.selectRootNode(mouseEvent.isControlDown());
                }
                if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                    ViewerTreePane.this.mWindow.enablePromoteDemoteAction();
                }
            }
        }

        private void setStatusBarHelpMsg(StatusBar statusBar, ViewerItem viewerItem) {
            String string = "";
            boolean bl = viewerItem.isVisible();
            if (viewerItem instanceof LogViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_LOG") : string + ResUtil.getString("IDS_VIEWPANE_LOG_HIDDEN");
            } else if (viewerItem instanceof TitleViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_TITLE") : string + ResUtil.getString("IDS_VIEWPANE_TITLE_HIDDEN");
            } else if (viewerItem instanceof TextViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_TEXT_OUTPUT") : string + ResUtil.getString("IDS_VIEWPANE_TEXT_OUTPUT_HIDDEN");
            } else if (viewerItem instanceof NotesViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_NOTES") : string + ResUtil.getString("IDS_VIEWPANE_NOTES_HIDDEN");
            } else if (viewerItem instanceof WarningViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_WARNING") : string + ResUtil.getString("IDS_VIEWPANE_WARNING_HIDDEN");
            } else if (viewerItem instanceof TableViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_PIVOT_TABLE") : string + ResUtil.getString("IDS_VIEWPANE_PIVOT_TABLE_HIDDEN");
            } else if (viewerItem instanceof ChartViewerItem || viewerItem instanceof JsonChartViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_CHARAT") : string + ResUtil.getString("IDS_VIEWPANE_CHARAT_HIDDEN");
            } else if (viewerItem instanceof GraphBoardViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_GRAPHBOARD") : string + ResUtil.getString("IDS_VIEWPANE_GRAPHBOARD_HIDDEN");
            } else if (viewerItem instanceof TreeModelViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_TREE") : string + ResUtil.getString("IDS_VIEWPANE_TREE_HIDDEN");
            } else if (viewerItem instanceof ModelViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_MODEL") : string + ResUtil.getString("IDS_VIEWPANE_MODEL_HIDDEN");
            } else if (viewerItem instanceof ImageViewerItem) {
                string = bl ? string + ResUtil.getString("IDS_VIEWPANE_IMAGE") : string + ResUtil.getString("IDS_VIEWPANE_IMAGE_HIDDEN");
            }
            if (statusBar != null) {
                statusBar.putPaneMessage(StatusBar.StatusPane.helpPane, string);
            }
        }

        public void scrollVerticallyToVisible(TreePath treePath) {
            if (treePath != null) {
                this.makeVisible(treePath);
                Rectangle rectangle = this.getPathBounds(treePath);
                if (rectangle != null) {
                    rectangle.x = 0;
                    this.scrollRectToVisible(rectangle);
                    if (this.accessibleContext != null) {
                        ((JTree.AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            }
        }

        public void fireValueChange(TreeSelectionEvent treeSelectionEvent) {
            if (System.getProperty("javax.accessibility.assistive_technologies") != null && this.accessibleContext != null) {
                ((MyAccessibleJTree)this.accessibleContext).valueChanged(treeSelectionEvent);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new MyAccessibleJTree();
            }
            return this.accessibleContext;
        }

        protected class MyAccessibleJTree
        extends JTree.AccessibleJTree {
            private Accessible mLeadSelectionAccessible;

            public MyAccessibleJTree() {
                super(OutlineTree.this);
                TreeModel treeModel = OutlineTree.this.getModel();
                if (treeModel != null) {
                    treeModel.addTreeModelListener(this);
                }
                OutlineTree.this.addTreeExpansionListener(this);
                OutlineTree.this.addTreeSelectionListener(this);
                TreePath treePath = OutlineTree.this.getLeadSelectionPath();
                this.mLeadSelectionAccessible = treePath != null ? new MyAccessibleJTreeNode((JTree)OutlineTree.this, treePath, (Accessible)OutlineTree.this) : null;
            }

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath;
                TreePath treePath2 = treeSelectionEvent.getOldLeadSelectionPath();
                if (treePath2 != (treePath = treeSelectionEvent.getNewLeadSelectionPath())) {
                    Accessible accessible = this.mLeadSelectionAccessible;
                    if (treePath != null) {
                        this.mLeadSelectionAccessible = new MyAccessibleJTreeNode((JTree)OutlineTree.this, treePath, null);
                    }
                    this.firePropertyChange("AccessibleActiveDescendant", accessible, this.mLeadSelectionAccessible);
                }
                this.firePropertyChange("AccessibleSelection", false, true);
            }

            protected class MyAccessibleJTreeNode
            extends JTree.AccessibleJTree.AccessibleJTreeNode {
                public MyAccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
                    super(MyAccessibleJTree.this, jTree, treePath, accessible);
                }

                @Override
                public AccessibleStateSet getAccessibleStateSet() {
                    AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                    accessibleStateSet.add(AccessibleState.SELECTED);
                    return accessibleStateSet;
                }
            }
        }
    }

    class NavTreeKeyHandler
    extends KeyAdapter {
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl = false;
            switch (keyEvent.getKeyCode()) {
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    ViewerTreePane.this.handleTreeKeyEvent(keyEvent);
                    bl = true;
                    break;
                }
                case 121: {
                    if (!keyEvent.isShiftDown()) break;
                    this.doContextMenu();
                    bl = true;
                    break;
                }
                case 67: {
                    if (!keyEvent.isControlDown()) break;
                    ViewerTreePane.this.mWindow.doCopy();
                    bl = true;
                    break;
                }
                case 86: {
                    if (!keyEvent.isControlDown()) break;
                    if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                        ViewerTreePane.this.mWindow.doPaste();
                    }
                    bl = true;
                    break;
                }
                case 32: {
                    ViewerItem viewerItem = ViewerTreePane.this.mWindow.getDocument().getFocusedViewerItem();
                    if (viewerItem == null) break;
                    if (viewerItem instanceof HeaderViewerItem) {
                        ViewerTreePane.this.mWindow.selectChildNodesOf((HeaderViewerItem)viewerItem);
                    } else {
                        boolean bl2 = keyEvent.isControlDown();
                        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                            bl2 = keyEvent.isMetaDown();
                        }
                        ViewerTreePane.this.mWindow.getDocument().selectionChanged(viewerItem, true, bl2);
                    }
                    bl = true;
                    break;
                }
                case 88: {
                    if (!keyEvent.isControlDown()) break;
                    if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                        ViewerTreePane.this.mWindow.doCut();
                    }
                    bl = true;
                    break;
                }
                case 127: {
                    if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                        ViewerTreePane.this.mWindow.doDelete();
                    }
                    bl = true;
                    break;
                }
            }
            if (bl) {
                keyEvent.consume();
            }
        }

        private void doContextMenu() {
            ViewerItem viewerItem = ViewerTreePane.this.mWindow.getDocument().getFocusedViewerItem();
            OutputContextMenu outputContextMenu = new OutputContextMenu(viewerItem, 1);
            Point point = new Point(40, 40);
            outputContextMenu.show(ViewerTreePane.this.mTree, point.x, point.y);
        }
    }

    public class NavTreeNode {
        private ViewerItem mItem;
        private ViewerDocument.ComponentType mType;
        private String mName;

        NavTreeNode(ViewerItem viewerItem, ViewerDocument.ComponentType componentType, String string) {
            this.mItem = viewerItem;
            this.mType = componentType;
            this.mName = string;
        }

        public ViewerItem getItem() {
            return this.mItem;
        }

        public void setItem(ViewerItem viewerItem) {
            this.mItem = viewerItem;
        }

        public ViewerDocument.ComponentType getType() {
            return this.mType;
        }

        public String toString() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }
    }

    public class NavTreeCellEditor
    extends DefaultTreeCellEditor {
        private boolean mListenerAdded;

        NavTreeCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.mListenerAdded = false;
        }

        public JTextField getEditingComponent() {
            if (this.tree.isEditing() && this.editingComponent instanceof JTextField) {
                return (JTextField)this.editingComponent;
            }
            return null;
        }

        public void select(int n, int n2) {
            if (this.tree.isEditing() && this.editingComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)this.editingComponent;
                jTextField.getCaret().setSelectionVisible(true);
                jTextField.select(n, n + n2);
            }
        }

        public void replace(String string) {
            if (this.tree.isEditing() && this.editingComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)this.editingComponent;
                int n = jTextField.getSelectionStart();
                jTextField.replaceSelection(string);
                jTextField.select(n, n + string.length());
            }
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return (!VersionInfo.isSmartReader() || !ViewerTreePane.this.mWindow.getDocument().getCoreDocument().isLocked()) && super.isCellEditable(eventObject);
        }

        @Override
        public void cancelCellEditing() {
            super.cancelCellEditing();
            if (this.editingComponent instanceof JTextField) {
                this.editingComponent.removeKeyListener(ViewerTreePane.this.mEditKeyAdapter);
                this.mListenerAdded = false;
            }
        }

        @Override
        public boolean stopCellEditing() {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Serializable serializable;
            boolean bl = super.stopCellEditing();
            ViewerTreePane.this.mIsRootNodeSelected = false;
            if (this.editingComponent instanceof JTextField) {
                serializable = this.tree.getEditingPath();
                if (serializable != null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
                    ViewerItem viewerItem = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                    viewerItem.setSelected(false);
                }
                this.editingComponent.removeKeyListener(ViewerTreePane.this.mEditKeyAdapter);
                this.mListenerAdded = false;
            }
            if (this.lastPath != null) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)this.lastPath.getLastPathComponent();
                serializable = ((NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                ((ViewerItem)serializable).setSelected(false);
                ViewerTreePane.this.mSelectedRowNumbers.clear();
                ViewerTreePane.this.mTree.clearSelection();
            }
            return bl;
        }

        boolean matchesSelection(String string) {
            if (this.tree.isEditing() && this.editingComponent instanceof JTextField) {
                JTextField jTextField = (JTextField)this.editingComponent;
                String string2 = jTextField.getSelectedText();
                return string.equalsIgnoreCase(string2);
            }
            return false;
        }

        @Override
        protected void prepareForEditing() {
            super.prepareForEditing();
            if (ViewerTreePane.this.mEditKeyAdapter == null) {
                ViewerTreePane.this.mEditKeyAdapter = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 114) {
                            IViewerWindow iViewerWindow;
                            ViewerFindDlg viewerFindDlg;
                            Container container = ViewerTreePane.this.getTopLevelAncestor();
                            if (container instanceof IViewerWindow && (viewerFindDlg = (iViewerWindow = (IViewerWindow)((Object)container)).getSearchDialog()).getLastFindValue().length() > 0) {
                                viewerFindDlg.findNext();
                            }
                            keyEvent.consume();
                        } else if (keyEvent.getKeyCode() == 10) {
                            NavTreeCellEditor.this.stopCellEditing();
                            keyEvent.consume();
                        }
                    }
                };
            }
            if (!this.mListenerAdded && this.editingComponent instanceof JTextField) {
                this.editingComponent.addKeyListener(ViewerTreePane.this.mEditKeyAdapter);
                this.mListenerAdded = true;
            }
        }

        @Override
        protected void determineOffset(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (this.renderer != null && object instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                this.editingIcon = ViewerTreePane.this.getNodeIcon(defaultMutableTreeNode);
                this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
            } else {
                this.editingIcon = null;
                this.offset = 0;
            }
        }
    }

    class NavTreeCellRenderer
    extends DefaultTreeCellRenderer {
        NavTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.getTreeCellRendererComponent(jTree, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, bl3, n, bl4);
            } else {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            this.setIcon(ViewerTreePane.this.getNodeIcon(defaultMutableTreeNode));
            if (jTree.isEnabled()) {
                this.setOpaque(true);
                if (bl) {
                    if (jTree.hasFocus()) {
                        object2 = this.getBackgroundSelectionColor();
                        object2 = new Color(((Color)object2).getRed(), ((Color)object2).getGreen(), ((Color)object2).getBlue());
                        this.setBackground((Color)object2);
                        this.setForeground(this.getTextSelectionColor());
                    } else {
                        this.setBackground(Color.lightGray);
                        this.setForeground(Color.black);
                    }
                } else {
                    this.setBackground(jTree.getBackground());
                    this.setForeground(jTree.getForeground());
                }
            } else {
                this.setOpaque(false);
            }
            object2 = "";
            if (bl) {
                object2 = ResUtil.getString("IDS_IS_SELECTED");
            }
            String string = ViewerTreePane.this.mWindow.getActivePane() == IViewerWindow.PaneType.Outline ? ResUtil.getString("IDS_OUTLINE_PANE") : ResUtil.getString("IDS_OUTPUT_PANE");
            this.getAccessibleContext().setAccessibleName(defaultMutableTreeNode.toString() + (String)object2 + ResUtil.getString("IDS_IN") + string);
            return this;
        }
    }

    public static enum TreeImageSize {
        small,
        medium,
        large;

    }
}

