/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.renderer.LtEMFProcessor;
import com.ibm.statistics.lighttable.renderer.LtGdipRenderer;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.export.OutputExporter;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.header.RootItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.modelviewer.ModelItem;
import com.spss.java_client.core.documents.output.serialize.IOutputFlavor;
import com.spss.java_client.core.documents.output.serialize.OutputSerializer;
import com.spss.java_client.core.documents.output.serialize.OutputTransfer;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.output.treemodel.TreeModelItem;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SwingWorker;
import com.spss.java_client.ui.dialogs.documents.output.output_export.ExportOutputUtil;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.NewOutputAction;
import com.spss.java_client.ui.doc_types.actions.OpenOutputAction;
import com.spss.java_client.ui.doc_types.output.BaseViewerLayout;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.ChartViewerItemHelper;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.IViewerWindowEx;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonChartViewerItem;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.MGOHelper;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerOutputPaneDragAdapter;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerTreePaneDragAdapter;
import com.spss.java_client.ui.doc_types.output.undo.OutputUndoableEdit;
import com.spss.java_client.ui.doc_types.output.undo.UndoItemInfo;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.export.DocumentExportOptions;
import com.spss.shared.export.ExportCopyParams;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.IExportOutputResultItem;
import com.spss.shared.export.ISpssExportable;
import com.spss.shared.export.table_export.ExcelExporter;
import com.spss.shared.export.table_export.TableImager;
import com.spss.shared.export.table_export.rtf.SpssRtfExporter;
import com.spss.treemodeleditor.TreeImager;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.IniHandler;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.uitools.util.TraceSettings;
import com.spss.uitools.winutils.BiffCopyHelper;
import com.spss.uitools.winutils.DumpMGOToClipboard;
import com.spss.uitools.winutils.EmfCopyHelper;
import com.spss.vis.Visualization;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.VisualizationInterruptedException;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vizimager.VizDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class ViewerPanel
extends JPanel
implements IViewerWindowEx {
    private static final String COPY_MASK_FILE = "viewer_copy.ini";
    private static final String COPY_MASK_SECTION = "clipboard_formats";
    private final String EDIT_COPY_SPECIAL_DEFAULT = "edit_copy_special_default_foramt";
    private final String ROOT_PATH = "doc_types/output/menus";
    private static int sCopyMask = -1;
    private int mSavedCopyMask = -1;
    private IViewerWindow mWindow;
    private Border sActiveBorder;
    private Border sInactiveBorder;
    private DragPane mOutputDragPane;
    private JScrollPane mScrollPane;
    private JSplitPane mSplitPane;
    private ViewerOutputPane mOutputPane;
    private ViewerTreePane mTreePane;
    private ViewerOutputPaneDragAdapter mViewerOutputPaneDragAdapter;
    private ViewerTreePaneDragAdapter mViewerTreePaneDragAdapter;
    private ViewerDocument mViewerDocument;
    private CopyProgressDlg mProgressDlg;
    private IViewerWindow.PaneType mActivePane;

    public ViewerPanel(IViewerWindow iViewerWindow) {
        super(new BorderLayout());
        this.mWindow = iViewerWindow;
    }

    public void init() {
        this.mViewerDocument = new ViewerDocument(this.mWindow);
        this.mTreePane = new ViewerTreePane(this.mWindow, true);
        Color color = OSInfo.getOSType() == OSInfo.OSType.WIN ? SystemColor.window : SystemColor.white;
        this.mOutputPane = new ViewerOutputPane(this.mWindow, new BaseViewerLayout(), false);
        this.mOutputPane.addMouseListener((MouseListener)((Object)this.mWindow));
        this.mScrollPane = new JScrollPane(this.mOutputPane);
        this.mScrollPane.getViewport().setBackground(color);
        this.mOutputDragPane = new DragPane();
        this.mViewerTreePaneDragAdapter = new ViewerTreePaneDragAdapter(this.mTreePane.getViewerTree(), this.mOutputDragPane, "viewerTreePaneDragAdapter");
        this.mTreePane.addMouseListener((MouseListener)((Object)this.mViewerTreePaneDragAdapter));
        this.mTreePane.addMouseMotionListener((MouseMotionListener)((Object)this.mViewerTreePaneDragAdapter));
        this.mTreePane.getViewerTree().addMouseListener((MouseListener)((Object)this.mViewerTreePaneDragAdapter));
        this.mTreePane.getViewerTree().addMouseMotionListener((MouseMotionListener)((Object)this.mViewerTreePaneDragAdapter));
        this.mOutputDragPane.addDropListener((IDropListener)this.mTreePane);
        this.mViewerOutputPaneDragAdapter = new ViewerOutputPaneDragAdapter(this.mOutputPane, this.mOutputDragPane, "viewerOutputPaneDragAdapter");
        DialogUtil.modifyMouseInputListeners(this.mOutputPane, this.mViewerOutputPaneDragAdapter);
        this.mOutputDragPane.addDropListener((IDropListener)this.mOutputPane);
        this.setGlassPane((Component)this.mOutputDragPane);
        boolean bl = !this.getComponentOrientation().isLeftToRight();
        JComponent jComponent = !bl ? this.mTreePane : this.mScrollPane;
        JComponent jComponent2 = bl ? this.mTreePane : this.mScrollPane;
        this.mSplitPane = new JSplitPane(1, jComponent, jComponent2);
        this.mSplitPane.setDividerLocation(200);
        this.add((Component)this.mSplitPane, "Center");
        if (this.getRootPane() != null) {
            InputMap inputMap = this.getRootPane().getInputMap(2);
            ActionMap actionMap = this.getRootPane().getActionMap();
            KeyStroke keyStroke = ResUtil.getShortcut("IDK_NEW_WINDOW");
            NewOutputAction newOutputAction = new NewOutputAction("file_new_output");
            inputMap.put(keyStroke, newOutputAction.getValue("Name"));
            actionMap.put(newOutputAction.getValue("Name"), newOutputAction);
            KeyStroke keyStroke2 = ResUtil.getShortcut("IDK_OPEN_WINDOW");
            OpenOutputAction openOutputAction = new OpenOutputAction("file_open_output");
            inputMap.put(keyStroke2, openOutputAction.getValue("Name"));
            actionMap.put(openOutputAction.getValue("Name"), openOutputAction);
        }
        this.setActivePane(IViewerWindow.PaneType.Outline);
    }

    public void enableDragDrop(boolean bl) {
        this.mViewerTreePaneDragAdapter.enableDragDrop(bl);
        this.mViewerOutputPaneDragAdapter.enableDragDrop(bl);
    }

    @Override
    public Window getTopWindow() {
        return this.mWindow.getTopWindow();
    }

    @Override
    public void activateAndSelect(ViewerSearchOptions viewerSearchOptions, int n) {
        if (viewerSearchOptions.getCurrentPane() == IViewerWindow.PaneType.Outline) {
            this.mTreePane.editAndSelect(viewerSearchOptions, n);
        } else {
            this.mOutputPane.editAndSelect(viewerSearchOptions, n);
        }
    }

    @Override
    public boolean canEdit(ViewerItem viewerItem) {
        return false;
    }

    @Override
    public void commitEdits(ViewerSearchOptions viewerSearchOptions) {
        this.mTreePane.commitEdits(viewerSearchOptions);
        ViewerItem viewerItem = this.mOutputPane.getEditingItem();
        if (viewerItem != null && viewerItem.isInEditMode()) {
            boolean bl;
            if (viewerItem instanceof TableViewerItem) {
                viewerSearchOptions.getTableSearcher().restoreOriginalSearchLayer(viewerSearchOptions);
                if (viewerSearchOptions.isReplaceAll()) {
                    ((TableViewerItem)viewerItem).getTableEditor().getPivotTableInfo().redrawTable(null);
                }
            }
            boolean bl2 = bl = !(viewerItem instanceof LightTableViewerItem) || viewerSearchOptions.getItemDone();
            if (bl) {
                viewerItem.endEdit();
                ViewerFindDlg viewerFindDlg = this.mWindow.getSearchDialog();
                if (viewerFindDlg != null && viewerFindDlg.isVisible()) {
                    viewerFindDlg.editingStopped();
                }
            }
        }
    }

    public boolean isSwingWorkerFinished() {
        return this.mProgressDlg == null;
    }

    @Override
    public void doCopy() {
        this.doCopyAndCut(false);
    }

    @Override
    public void doCut() {
        this.doCopyAndCut(true);
    }

    public void doSimpleCopy() {
        this.doSimpleCopyAndCut(false);
    }

    public void doSimpleCut() {
        this.doSimpleCopyAndCut(true);
    }

    @Override
    public void doDelete() {
        if (VersionInfo.isSmartReader() && this.mViewerDocument.getCoreDocument().isLocked()) {
            return;
        }
        try {
            this.mViewerDocument.deleteSelected();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void doPaste() {
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        if (appClipboard.isFlavorAvailable(IOutputFlavor.NATIVE_FLAVOR)) {
            this.doPaste(IOutputFlavor.NATIVE_FLAVOR);
        } else if (appClipboard.isFlavorAvailable(IOutputFlavor.HTML_FLAVOR)) {
            this.doPaste(IOutputFlavor.HTML_FLAVOR);
        } else if (appClipboard.isFlavorAvailable(IOutputFlavor.TEXT_FLAVOR)) {
            this.doPaste(IOutputFlavor.TEXT_FLAVOR);
        } else if (appClipboard.isFlavorAvailable(IOutputFlavor.IMAGE_FLAVOR)) {
            this.doPaste(IOutputFlavor.IMAGE_FLAVOR);
        } else if (appClipboard.isFlavorAvailable(IOutputFlavor.RTF_FLAVOR)) {
            this.doPaste(IOutputFlavor.RTF_FLAVOR);
        }
    }

    @Override
    public void doPaste(DataFlavor dataFlavor) {
        int n;
        IOutputItem iOutputItem;
        if (VersionInfo.isSmartReader() && this.mViewerDocument.getCoreDocument().isLocked()) {
            return;
        }
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        ViewerItem viewerItem = this.mViewerDocument.getFocusedViewerItem();
        boolean bl = false;
        if (viewerItem != null) {
            iOutputItem = viewerItem.getCoreItem();
            n = (int)this.mViewerDocument.getCoreDocument().getPreorderItemIndex(iOutputItem);
            if (viewerItem instanceof HeaderViewerItem && !this.getExpanded(n)) {
                bl = true;
            }
        } else {
            return;
        }
        if (dataFlavor.equals(IOutputFlavor.NATIVE_FLAVOR) && appClipboard.isFlavorAvailable(IOutputFlavor.NATIVE_FLAVOR)) {
            int n2;
            Object object;
            OutputTransfer outputTransfer = (OutputTransfer)appClipboard.getClipboardData(IOutputFlavor.NATIVE_FLAVOR);
            OutputSerializer outputSerializer = new OutputSerializer();
            IOutputItem[] iOutputItemArray = outputSerializer.deserializeItems(outputTransfer.getBytes());
            HeaderItem headerItem = (HeaderItem)(iOutputItem instanceof HeaderItem ? iOutputItem : iOutputItem.getParentItem());
            for (int i = 0; i < iOutputItemArray.length; ++i) {
                object = i == 0 ? iOutputItem : iOutputItemArray[i - 1];
                int n3 = headerItem.getTreeLevelDirect();
                if (bl && i == 0) {
                    n3 = headerItem.getTreeLevel();
                }
                int n4 = iOutputItemArray[i].getTreeLevelDirect();
                while (bl && n3 > 0 && n4 <= n3) {
                    headerItem = (HeaderItem)headerItem.getParentItem();
                    --n3;
                }
                int n5 = n2 = object instanceof RootItem ? 0 : ((HeaderItem)object.getParentItem()).getItemIndex(object) + 1;
                if (!(object instanceof RootItem) && n2 < headerItem.getChildCount() && headerItem != object.getParentItem()) {
                    n2 = headerItem.getChildCount();
                }
                this.mViewerDocument.getCoreDocument().insertItemAt(iOutputItemArray[i], headerItem, n2);
                if (iOutputItemArray[i] instanceof TableItem) {
                    ((TableItem)iOutputItemArray[i]).setAppliedTableLook(true);
                }
                if (!(iOutputItemArray[i] instanceof HeaderItem)) continue;
                headerItem = (HeaderItem)iOutputItemArray[i];
            }
            ViewerItem viewerItem2 = this.mViewerDocument.getLastAddedItem();
            if (viewerItem2 != null) {
                this.mViewerDocument.setFocusedViewerItem(viewerItem2);
                this.mViewerDocument.selectionChanged(viewerItem2, true, false);
            }
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            for (int i = iOutputItemArray.length - 1; i >= 0; --i) {
                HeaderItem headerItem2 = (HeaderItem)iOutputItemArray[i].getParentItem();
                n2 = headerItem2.getItemIndex(iOutputItemArray[i]);
                n2 = n2 == -1 ? headerItem2.getChildCount() : n2;
                object = n2 == 0 ? headerItem2 : headerItem2.getChildItem(n2 - 1);
                UndoItemInfo undoItemInfo = new UndoItemInfo(iOutputItemArray[i], (IOutputItem)object);
                linkedHashMap.put(iOutputItemArray[i], undoItemInfo);
            }
            new OutputUndoableEdit(this.mWindow, linkedHashMap, true);
            if (bl) {
                this.setExpanded(n, false);
            }
            return;
        }
        if (dataFlavor.equals(IOutputFlavor.HTML_FLAVOR) && appClipboard.isFlavorAvailable(IOutputFlavor.HTML_FLAVOR)) {
            String string = (String)appClipboard.getClipboardData(IOutputFlavor.HTML_FLAVOR);
            TextItem textItem = new TextItem();
            textItem.setDescription(ResUtil.getString("IDS_PASTED_OBJECT"));
            textItem.setContents(string);
            this.mViewerDocument.getCoreDocument().insertItem((IOutputItem)textItem, viewerItem.getCoreItem());
            ViewerItem viewerItem3 = this.mViewerDocument.getLastAddedItem();
            if (viewerItem3 != null) {
                this.mViewerDocument.setFocusedViewerItem(viewerItem3);
                this.mViewerDocument.selectionChanged(viewerItem3, true, false);
            }
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)textItem, viewerItem.getCoreItem());
            linkedHashMap.put((IOutputItem)textItem, undoItemInfo);
            new OutputUndoableEdit(this.mWindow, linkedHashMap, true);
            return;
        }
        if (dataFlavor.equals(IOutputFlavor.TEXT_FLAVOR) && appClipboard.isFlavorAvailable(IOutputFlavor.TEXT_FLAVOR)) {
            String string = (String)appClipboard.getClipboardData(IOutputFlavor.TEXT_FLAVOR);
            TextItem textItem = new TextItem();
            textItem.setDescription(ResUtil.getString("IDS_PASTED_OBJECT"));
            textItem.setContents(string);
            this.mViewerDocument.getCoreDocument().insertItem((IOutputItem)textItem, viewerItem.getCoreItem());
            ViewerItem viewerItem4 = this.mViewerDocument.getLastAddedItem();
            if (viewerItem4 != null) {
                this.mViewerDocument.setFocusedViewerItem(viewerItem4);
                this.mViewerDocument.selectionChanged(viewerItem4, true, false);
            }
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)textItem, viewerItem.getCoreItem());
            linkedHashMap.put((IOutputItem)textItem, undoItemInfo);
            new OutputUndoableEdit(this.mWindow, linkedHashMap, true);
            return;
        }
        if (dataFlavor.equals(IOutputFlavor.IMAGE_FLAVOR) && appClipboard.isFlavorAvailable(IOutputFlavor.IMAGE_FLAVOR)) {
            Image image = (Image)appClipboard.getClipboardData(IOutputFlavor.IMAGE_FLAVOR);
            this.mViewerDocument.insertImageAfter(image, this.mViewerDocument.getFocusedViewerItem());
            ViewerItem viewerItem5 = this.mViewerDocument.getLastAddedItem();
            if (viewerItem5 != null) {
                this.mViewerDocument.setFocusedViewerItem(viewerItem5);
                this.mViewerDocument.selectionChanged(viewerItem5, true, false);
            }
            GenericItem genericItem = new GenericItem(image);
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)genericItem, viewerItem.getCoreItem());
            linkedHashMap.put((IOutputItem)genericItem, undoItemInfo);
            new OutputUndoableEdit(this.mWindow, linkedHashMap, true);
            return;
        }
        if (dataFlavor.equals(IOutputFlavor.RTF_FLAVOR) && appClipboard.isFlavorAvailable(IOutputFlavor.RTF_FLAVOR)) {
            String string = null;
            Object object = appClipboard.getClipboardData(IOutputFlavor.RTF_FLAVOR);
            if (object != null && object instanceof byte[]) {
                string = new String((byte[])object);
            }
            if (string != null) {
                this.pasteRtfText(string, viewerItem);
            }
        }
    }

    @Override
    public void enablePromoteDemoteAction() {
    }

    @Override
    public void endInPlaceEdits() {
        if (!this.mOutputPane.editingItemInFrame()) {
            this.mOutputPane.endEdits();
        }
    }

    @Override
    public ViewerDocument getDocument() {
        return this.mViewerDocument;
    }

    @Override
    public boolean getExpanded(int n) {
        ViewerItem viewerItem;
        JTree jTree = this.mTreePane.getViewerTree();
        TreePath treePath = jTree.getPathForRow(n);
        if (treePath == null) {
            return false;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && ((viewerItem = ((ViewerTreePane.NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem)) {
            return jTree.isExpanded(treePath);
        }
        return false;
    }

    @Override
    public int getExtendedState() {
        return 0;
    }

    @Override
    public String getOutlineTitle(ViewerItem viewerItem) {
        return this.mTreePane.getOutlineTitle(viewerItem);
    }

    public DragPane getOutputDragPane() {
        return this.mOutputDragPane;
    }

    @Override
    public ViewerOutputPane getOutputPane() {
        return this.mOutputPane;
    }

    @Override
    public ViewerOutputPaneDragAdapter getOutputPaneDragAdapter() {
        return this.mViewerOutputPaneDragAdapter;
    }

    @Override
    public JScrollPane getOutputScrollPane() {
        return this.mScrollPane;
    }

    @Override
    public ViewerFindDlg getSearchDialog() {
        return this.mWindow.getSearchDialog();
    }

    @Override
    public StatusBar getStatusBar() {
        return null;
    }

    @Override
    public SpssUndoManager getUndoManager() {
        return null;
    }

    public JSplitPane getViewerSplitPane() {
        return this.mSplitPane;
    }

    @Override
    public ViewerTreePane getViewerTreePane() {
        return this.mTreePane;
    }

    public void performCloseAllOpenItems() {
    }

    @Override
    public void performClose() {
        if (this.mViewerDocument == null) {
            return;
        }
        this.cleanVizCache();
        ViewerDocument viewerDocument = this.mViewerDocument;
        this.mViewerDocument = null;
        IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
        OutputManager.getOutputManager().closeDocument(iOutputDocument);
        if (this.mOutputDragPane != null) {
            this.mOutputDragPane.removeAll();
            this.mOutputDragPane.removeDropListener((IDropListener)this.mOutputPane);
            this.mOutputDragPane.removeDropListener((IDropListener)this.mTreePane);
            this.mOutputDragPane = null;
        }
        if (this.mOutputPane != null) {
            this.mOutputPane.removeMouseListener((MouseListener)((Object)this.mWindow));
            this.mOutputPane.removeAll();
            this.mOutputPane.performClose();
            this.mOutputPane = null;
        }
        if (this.mTreePane != null) {
            DialogUtil.removeMouseInputListeners(this.mTreePane.getViewerTree());
            this.mTreePane.removeAll();
            this.mTreePane.removeMouseListener((MouseListener)((Object)this.mViewerTreePaneDragAdapter));
            this.mTreePane.removeMouseMotionListener((MouseMotionListener)((Object)this.mViewerTreePaneDragAdapter));
            this.mTreePane.performClose();
            this.mTreePane = null;
        }
        viewerDocument.close();
        this.mViewerTreePaneDragAdapter = null;
        this.mViewerOutputPaneDragAdapter = null;
        this.mWindow = null;
    }

    @Override
    public boolean saveCoreDocument() {
        return false;
    }

    @Override
    public void replaceEditingTextSelection(ViewerSearchOptions viewerSearchOptions, String string) {
        IViewerWindow.PaneType paneType = viewerSearchOptions.getCurrentPane();
        if (paneType == IViewerWindow.PaneType.Outline) {
            this.mTreePane.replaceEditingTextSelection(string);
        } else {
            this.mOutputPane.replaceEditingTextSelection(string, viewerSearchOptions);
        }
    }

    @Override
    public void selectChildNodesOf(HeaderViewerItem headerViewerItem) {
        if (headerViewerItem == null) {
            return;
        }
        Vector<ViewerItem> vector = this.mViewerDocument.getViewerItems();
        HeaderItem headerItem = (HeaderItem)headerViewerItem.getCoreItem();
        this.mViewerDocument.selectionChanged(headerViewerItem, true, true);
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getParentItem() == null || !viewerItem.getCoreItem().getParentItem().equals(headerItem)) continue;
            this.mViewerDocument.selectionChanged(viewerItem, true, true);
        }
    }

    @Override
    public boolean selectionIsSearchString(ViewerSearchOptions viewerSearchOptions, String string) {
        IViewerWindow.PaneType paneType = viewerSearchOptions.getCurrentPane();
        if (paneType == IViewerWindow.PaneType.Outline) {
            return this.mTreePane.selectionIsSearchString(string);
        }
        return this.mOutputPane.selectionIsSearchString(viewerSearchOptions, string);
    }

    @Override
    public IViewerWindow.PaneType getActivePane() {
        return this.mActivePane;
    }

    @Override
    public void setActivePane(IViewerWindow.PaneType paneType) {
        Object object;
        this.mActivePane = paneType;
        if (this.sActiveBorder == null || this.sInactiveBorder == null) {
            object = this.mScrollPane.getBorder();
            if (object == null) {
                object = UIManager.getBorder("ScrollPane.viewportBorder");
            }
            Border border = BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor(), 1);
            Border border2 = BorderFactory.createLineBorder(Color.white, 1);
            this.sActiveBorder = BorderFactory.createCompoundBorder((Border)object, border);
            this.sInactiveBorder = BorderFactory.createCompoundBorder((Border)object, border2);
        }
        object = this.mTreePane.getTreeScroller();
        if (paneType == IViewerWindow.PaneType.Content) {
            this.mScrollPane.setBorder(this.sActiveBorder);
            ((JComponent)object).setBorder(this.sInactiveBorder);
        } else {
            ((JComponent)object).setBorder(this.sActiveBorder);
            this.mScrollPane.setBorder(this.sInactiveBorder);
        }
    }

    @Override
    public void setCoreDocument(IOutputDocument iOutputDocument) {
        this.mViewerDocument.setCoreDocument(iOutputDocument);
        this.mTreePane.connectRootNode();
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.mWindow.setCursor(cursor);
    }

    @Override
    public void setExpanded(int n, boolean bl) {
        ViewerItem viewerItem;
        JTree jTree = this.mTreePane.getViewerTree();
        TreePath treePath = jTree.getPathForRow(n);
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && ((viewerItem = ((ViewerTreePane.NavTreeNode)((DefaultMutableTreeNode)object).getUserObject()).getItem()) == null || viewerItem instanceof HeaderViewerItem)) {
            if (bl) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }
    }

    @Override
    public void setExtendedState(int n) {
    }

    @Override
    public void setModified(boolean bl) {
        if (this.mViewerDocument.getCoreDocument() != null && this.mViewerDocument.getCoreDocument().getModifiedFlag() != bl) {
            this.mViewerDocument.getCoreDocument().setModifiedFlag(bl);
            this.updateTitleBar();
        }
    }

    @Override
    public void setSelected(IOutputItem iOutputItem, boolean bl) {
        if (bl) {
            this.mViewerDocument.selectionChanged((ViewerItem)iOutputItem.getUIAgent(), true, true);
        } else {
            this.mViewerDocument.selectionChanged((ViewerItem)iOutputItem.getUIAgent(), false, false);
        }
    }

    @Override
    public void setSelectionExpandState(boolean bl) {
        this.mTreePane.setSelectionExpandState(bl);
    }

    @Override
    public void updateTitleBar() {
        String string;
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        if (this.mViewerDocument.getCoreDocument() != null) {
            string2 = this.mViewerDocument.getCoreDocument().getDocName();
            bl = this.mViewerDocument.getCoreDocument().getModifiedFlag();
            string3 = OutputManager.getOutputManager().getOutputDocumentUniqueName(this.mViewerDocument.getCoreDocument());
        }
        String string4 = ResUtil.getString("IDS_SPSS_OUTPUT_VIEWER");
        Container container = this.getTopLevelAncestor();
        if (container instanceof ViewerFrame) {
            string4 = String.format(ComponentState.getILangLocale(), string4, VersionInfo.getProductNickName());
        }
        String string5 = "";
        if (bl) {
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                string5 = "*";
            } else {
                string = UIManager.getLookAndFeel().getClass().getName();
                if (string.contains("SpssPlasticXPLookAndFeel")) {
                    string5 = "*";
                }
            }
            if (this.getRootPane() != null) {
                this.getRootPane().putClientProperty("Window.documentModified", Boolean.TRUE);
            }
        } else if (this.getRootPane() != null) {
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
        }
        string = "[" + string3 + "] - " + string4;
        String string6 = string2.length() > 0 ? string5 + string2 + " " + string : string;
        this.setTitle(string6);
        if (this.mViewerDocument != null) {
            try {
                if (this.mViewerDocument.getCoreDocument() != null && this.mViewerDocument.getCoreDocument().getFileSpec() != null) {
                    String string7 = this.mViewerDocument.getCoreDocument().getFileSpec().getCanonicalPath();
                    this.getRootPane().putClientProperty("Window.documentFile", new File(string7));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    public void updateToolbarEnableStatus() {
    }

    @Override
    public int getCopyFormats() {
        if (sCopyMask == -1) {
            this.loadCopyMask();
        }
        return sCopyMask;
    }

    @Override
    public void setCopyFormats(int n) {
        sCopyMask = n;
    }

    public void setSavedCopyFormats(int n) {
        this.mSavedCopyMask = n;
    }

    public void gotoTableRows(TableViewerItem.TableSection tableSection) {
        ViewerItem viewerItem = this.mViewerDocument.getFocusedViewerItem();
        if (viewerItem instanceof TableViewerItem) {
            TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
            tableViewerItem.gotoTableRows(tableSection);
        }
    }

    public boolean isNavigateEnabled(TableViewerItem.TableSection tableSection) {
        ViewerItem viewerItem = this.mViewerDocument.getFocusedViewerItem();
        if (viewerItem instanceof TableViewerItem) {
            TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
            return tableViewerItem.isNavigateEnabled(tableSection);
        }
        return false;
    }

    private boolean canCopy(int n, int n2) {
        if (n2 == -1) {
            this.loadCopyMask();
            n2 = sCopyMask;
        }
        return (n2 & n) != 0;
    }

    private boolean onlyOneVisItem(ViewerItem[] viewerItemArray) {
        boolean bl = false;
        for (ViewerItem viewerItem : viewerItemArray) {
            if (!(viewerItem instanceof TableViewerItem) && !(viewerItem instanceof ChartViewerItem) && !(viewerItem instanceof GraphBoardViewerItem) && !(viewerItem instanceof TreeModelViewerItem) && !(viewerItem instanceof LightTableViewerItem) && !(viewerItem instanceof ModelViewerItem)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private String doEMFCopy(ViewerItem viewerItem) {
        String string;
        block3: {
            if (OSInfo.getOSType() != OSInfo.OSType.WIN) {
                return null;
            }
            string = null;
            try {
                string = this.doConvertEMF(viewerItem.getCoreItem());
            }
            catch (Exception exception) {
                TraceSettings.trace((String)("EMF clipboard copy failed! " + exception.getMessage()));
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block3;
                throw (OutOfMemoryError)exception.getCause();
            }
        }
        return string;
    }

    private void loadCopyMask() {
        String string = System.getProperty("application.home");
        if (string == null || string.length() == 0) {
            sCopyMask = 15;
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(stringBuffer.length() - 1) != File.separatorChar) {
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(COPY_MASK_FILE);
        File file = new File(stringBuffer.toString());
        if (file.exists()) {
            String string2;
            sCopyMask = 1;
            String string3 = stringBuffer.toString();
            IniHandler iniHandler = IniHandler.loadIniFile((String)string3, (boolean)true, (String)"UTF-8");
            LinkedList linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "RTF");
            if (linkedList.size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 4;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "TEXT")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 2;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "IMAGE")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 8;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "BIFF")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 0x10;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "EMF")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 0x20;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "MGO")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 0x40;
            }
            if ((linkedList = iniHandler.getPrivateProfileString(COPY_MASK_SECTION, "TRANSPARENT_IMAGES")).size() > 0 && ("true".equals(string2 = ((String)linkedList.get(0)).toLowerCase()) || "yes".equals(string2))) {
                sCopyMask |= 0x1000;
            }
            IniHandler.unCacheIniFile((String)string3);
        } else {
            sCopyMask = OSInfo.getOSType() == OSInfo.OSType.WIN ? this.getDefaultCopySpecialFormat(87) : (OSInfo.getOSType() == OSInfo.OSType.MAC ? this.getDefaultCopySpecialFormat(11) : (OSInfo.getOSType() == OSInfo.OSType.LINUX ? this.getDefaultCopySpecialFormat(15) : this.getDefaultCopySpecialFormat(127)));
        }
    }

    private String extractPlainText(TextViewerItem textViewerItem) {
        String string = "";
        SpssTextPane spssTextPane = textViewerItem.getTextPane();
        String string2 = spssTextPane.getText();
        int n = spssTextPane.getSelectionStart();
        int n2 = spssTextPane.getSelectionEnd();
        spssTextPane.setSelectionStart(0);
        spssTextPane.setSelectionEnd(string2.length());
        int n3 = spssTextPane.getSelectionStart();
        int n4 = spssTextPane.getSelectionEnd();
        if (n4 - n3 > 0) {
            try {
                StringWriter stringWriter = new StringWriter(n4 - n3);
                spssTextPane.getEditorKit().write(stringWriter, spssTextPane.getDocument(), n3, n4 - n3);
                StringReader stringReader = new StringReader(stringWriter.toString());
                HTMLDocument hTMLDocument = new HTMLDocument();
                spssTextPane.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
                string = spssTextPane.getSelectedText(hTMLDocument, spssTextPane.getSelectedText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        spssTextPane.select(n, n2);
        string = string.replace("//", "");
        return string.replace("\u00a0", " ").replace("\u000f", "");
    }

    private String doConvertEMF(IOutputItem iOutputItem) {
        String string = "";
        try {
            File file = PASWFileUtil.createTempFile((String)"emf", (String)".emf", (File)new File(DialogUtil.readTempDirLocationPrefs()));
            file.deleteOnExit();
            string = file.getAbsolutePath();
            int n = iOutputItem.getWidth();
            int n2 = iOutputItem.getHeight();
            TableImager tableImager = new TableImager();
            if (iOutputItem instanceof TableItem) {
                Visualization visualization = VizCache.getCache().getVisualization((TableItem)iOutputItem);
                FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
                int n3 = visualization.getOutputWidth(fontRenderContext);
                int n4 = visualization.getOutputHeight(fontRenderContext);
                VizDataSource.switchToFullTable((Visualization)visualization);
                tableImager.renderToFile(visualization, string, 3, n, n2);
                VizDataSource.switchToRowsTable((Visualization)visualization);
                visualization.setOutputSize(n3, n4);
            } else if (iOutputItem instanceof ChartItem) {
                Visualization visualization = VizCache.getCache().getVisualization((ChartItem)iOutputItem);
                tableImager.renderToFile(visualization, string, 3, n, n2);
            } else if (iOutputItem instanceof TreeModelItem) {
                TreeImager treeImager = new TreeImager();
                treeImager.renderToFile(iOutputItem.getCompressedXML().array(), ((TreeModelItem)iOutputItem).getDisplayData(), string, 3, false, 100);
            } else if (iOutputItem instanceof ModelItem) {
                ModelItem modelItem = (ModelItem)iOutputItem;
                Visualization visualization = modelItem.getMainVisualization();
                tableImager.renderToFile(visualization, string, 3, n, n2);
            }
        }
        catch (VisualizationException visualizationException) {
            if (visualizationException.getCause() instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)visualizationException.getCause();
            }
            visualizationException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String doLtEMFCopy(LightTableItem lightTableItem) {
        if (OSInfo.getOSType() != OSInfo.OSType.WIN) {
            return null;
        }
        String string = "";
        try {
            File file = PASWFileUtil.createTempFile((String)"emf", (String)".emf", (File)new File(DialogUtil.readTempDirLocationPrefs()));
            file.deleteOnExit();
            string = file.getAbsolutePath();
            int n = lightTableItem.getWidth();
            int n2 = lightTableItem.getHeight();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LtEMFProcessor ltEMFProcessor = new LtEMFProcessor(new Rectangle(n, n2), (OutputStream)fileOutputStream);
            LtGdipRenderer ltGdipRenderer = new LtGdipRenderer(lightTableItem.getLightPivotTable());
            ltEMFProcessor.start(null);
            ltGdipRenderer.render(ltEMFProcessor);
            ltEMFProcessor.finish();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void emfFileToClipboard(String string) {
        try {
            EmfCopyHelper.setEmfToClipboard((String)string);
            new File(string).delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new File(string).deleteOnExit();
        }
    }

    private void doBiffCopy(ViewerItem[] viewerItemArray) {
        if (OSInfo.getOSType() == OSInfo.OSType.WIN && this.hasNonChartItems(viewerItemArray)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ExcelExporter excelExporter = new ExcelExporter((OutputStream)byteArrayOutputStream, OutputExporter.getPrefTextStyle());
                DocumentExportOptions documentExportOptions = new DocumentExportOptions();
                documentExportOptions.setCopy(true);
                for (ViewerItem viewerItem : viewerItemArray) {
                    if (viewerItem.getCoreItem() instanceof ISpssExportable) {
                        IExportOptions.PivotTableOptions pivotTableOptions = ((ISpssExportable)viewerItem.getCoreItem()).isExportAllLayers() ? IExportOptions.PivotTableOptions.PTExportAllLayers : IExportOptions.PivotTableOptions.PTExportVisibleLayer;
                        documentExportOptions.setPivotTableOption(pivotTableOptions);
                        excelExporter.doDocExcelExport((ISpssExportable)viewerItem.getCoreItem(), documentExportOptions);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    return;
                }
                excelExporter.closeStream();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray != null && byArray.length > 0) {
                    BiffCopyHelper.setImageToClipboard((byte[])byArray, (int)0);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private boolean hasNonChartItems(ViewerItem[] viewerItemArray) {
        boolean bl = false;
        for (ViewerItem viewerItem : viewerItemArray) {
            if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem || viewerItem instanceof TreeModelViewerItem || viewerItem instanceof ModelViewerItem || viewerItem instanceof ImageViewerItem || viewerItem instanceof JsonChartViewerItem || viewerItem instanceof GenericViewerItem) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void cleanVizCache() {
        VizCache vizCache = VizCache.getCache();
        Vector<ViewerItem> vector = this.mViewerDocument.getViewerItems();
        for (ViewerItem viewerItem : vector) {
            if (!(viewerItem instanceof TableViewerItem) && !(viewerItem instanceof ChartViewerItem) && !(viewerItem instanceof GraphBoardViewerItem)) continue;
            vizCache.clearItem(viewerItem.getId());
        }
    }

    private void setTitle(String string) {
        if (this.mWindow instanceof JFrame) {
            ((JFrame)((Object)this.mWindow)).setTitle(string);
        } else if (this.mWindow instanceof JDialog) {
            ((JDialog)((Object)this.mWindow)).setTitle(string);
        }
    }

    private void setGlassPane(Component component) {
        if (this.mWindow instanceof JFrame) {
            ((JFrame)((Object)this.mWindow)).setGlassPane(component);
        } else if (this.mWindow instanceof JDialog) {
            ((JDialog)((Object)this.mWindow)).setGlassPane(component);
        }
    }

    private void pasteRtfText(String string, ViewerItem viewerItem) {
        Object object;
        DefaultStyledDocument defaultStyledDocument;
        String string2 = null;
        StringReader stringReader = new StringReader(string);
        try {
            defaultStyledDocument = new DefaultStyledDocument();
            new RTFEditorKit().read(stringReader, (Document)defaultStyledDocument, 0);
            object = new ByteArrayOutputStream(defaultStyledDocument.getLength());
            new HTMLEditorKit().write((OutputStream)object, (Document)defaultStyledDocument, 0, defaultStyledDocument.getLength());
            string2 = ((ByteArrayOutputStream)object).toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        defaultStyledDocument = new TextItem();
        defaultStyledDocument.setDescription(ResUtil.getString("IDS_PASTED_OBJECT"));
        defaultStyledDocument.setContents(string2);
        this.mViewerDocument.getCoreDocument().insertItem((IOutputItem)defaultStyledDocument, viewerItem.getCoreItem());
        object = this.mViewerDocument.getLastAddedItem();
        if (object != null) {
            this.mViewerDocument.setFocusedViewerItem((ViewerItem)object);
            this.mViewerDocument.selectionChanged((ViewerItem)object, true, false);
        }
        LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
        UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)defaultStyledDocument, viewerItem.getCoreItem());
        linkedHashMap.put((IOutputItem)defaultStyledDocument, undoItemInfo);
        new OutputUndoableEdit(this.mWindow, linkedHashMap, true);
    }

    private void doCopyAndCut(final boolean bl) {
        this.mProgressDlg = this.mWindow instanceof JFrame ? new CopyProgressDlg((JFrame)((Object)this.mWindow), ResUtil.getString("edit_copy_objects")) : new CopyProgressDlg(null, ResUtil.getString("edit_copy_objects"));
        SwingWorker<Object> swingWorker = new SwingWorker<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() {
                boolean bl2;
                try {
                    ViewerPanel.this.mWindow.setCursor(Cursor.getPredefinedCursor(3));
                    bl2 = ViewerPanel.this.doCopyWork(this);
                    if (bl2 && bl) {
                        ViewerPanel.this.doDelete();
                    }
                }
                finally {
                    ViewerPanel.this.mProgressDlg.setCancel(false);
                    ViewerPanel.this.mProgressDlg.dispose();
                    ViewerPanel.this.mProgressDlg = null;
                    ViewerPanel.this.mWindow.setCursor(null);
                }
                return bl2;
            }
        };
        this.mProgressDlg.setSwingWorker(swingWorker);
        swingWorker.start();
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (ViewerPanel.this.mProgressDlg != null) {
                    ViewerPanel.this.mProgressDlg.setVisible(true);
                }
            }
        };
        timer.schedule(timerTask, 2000L);
    }

    private void doSimpleCopyAndCut(boolean bl) {
        boolean bl2 = this.doCopyWork(null);
        if (bl2 && bl) {
            this.doDelete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean doCopyWork(SwingWorker swingWorker) {
        block51: {
            int n = sCopyMask;
            boolean bl = true;
            try {
                Object object;
                String string;
                ViewerItem[] viewerItemArray;
                AppClipboard appClipboard;
                block50: {
                    if (!bl) {
                        // empty if block
                    }
                    appClipboard = AppClipboard.getAppClipboard();
                    viewerItemArray = this.mViewerDocument.getSelectedItems(true);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( START )");
                    if (this.canCopy(1, n)) {
                        try {
                            OutputSerializer outputSerializer = new OutputSerializer();
                            IOutputItem[] iOutputItemArray = new IOutputItem[viewerItemArray.length];
                            for (int i = 0; i < viewerItemArray.length; ++i) {
                                iOutputItemArray[i] = viewerItemArray[i].getCoreItem();
                            }
                            byte[] byArray = outputSerializer.serializeItems(iOutputItemArray);
                            appClipboard.addClipboardData(IOutputFlavor.NATIVE_FLAVOR, (Object)new OutputTransfer(byArray), false);
                            TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID NATIVE )");
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            outOfMemoryError.printStackTrace();
                            AppMgr.getAppMgr().handleOutOfMemoryCondition();
                            return false;
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    boolean bl3 = this.canCopy(2, n);
                    boolean bl4 = this.canCopy(32, n) && OSInfo.getOSType() == OSInfo.OSType.WIN && this.onlyOneVisItem(viewerItemArray);
                    boolean bl2 = false;
                    string = null;
                    String string2 = "\n";
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl3 || bl4) {
                        try {
                            this.updateStatus(2, false);
                            for (ViewerItem object2 : viewerItemArray) {
                                Object string3;
                                ViewerItem viewerItem;
                                if (swingWorker != null && swingWorker.isCancelled()) {
                                    return false;
                                }
                                if (bl3 && object2 instanceof TextViewerItem) {
                                    viewerItem = (TextViewerItem)object2;
                                    string3 = this.extractPlainText((TextViewerItem)viewerItem);
                                    stringBuffer.append((String)string3).append(string2);
                                    continue;
                                }
                                if (object2 instanceof TableViewerItem) {
                                    String string4;
                                    viewerItem = (TableViewerItem)object2;
                                    string3 = ((TableViewerItem)viewerItem).acquireVisualization();
                                    VizDataSource.switchToFullTable((Visualization)string3);
                                    if (bl3 && (string4 = ((TableViewerItem)viewerItem).getTableEditor().getFrame().getTableTabDelimitedText(string3, true)) != null) {
                                        stringBuffer.append(string4).append(string2).append(string2);
                                    }
                                    if (bl4) {
                                        this.updateStatus(32, false);
                                        string = this.doEMFCopy(viewerItem);
                                    }
                                    VizDataSource.switchToRowsTable((Visualization)string3);
                                    continue;
                                }
                                if (object2 instanceof LightTableViewerItem) {
                                    viewerItem = (LightTableViewerItem)object2;
                                    if (bl3 && (string3 = ((LightTableViewerItem)viewerItem).getCoreItem().getTableTabDelimitedText()) != null) {
                                        stringBuffer.append((String)string3).append(string2).append(string2);
                                    }
                                    if (swingWorker != null && swingWorker.isCancelled()) {
                                        return false;
                                    }
                                    if (!bl4) continue;
                                    string = this.doLtEMFCopy(((LightTableViewerItem)viewerItem).getCoreItem());
                                    continue;
                                }
                                if (!(object2 instanceof ChartViewerItem) && !(object2 instanceof GraphBoardViewerItem) && !(object2 instanceof TreeModelViewerItem) && !(object2 instanceof ModelViewerItem) && !(object2 instanceof JsonChartViewerItem) && !(object2 instanceof ImageViewerItem)) continue;
                                if (bl4) {
                                    this.updateStatus(32, false);
                                    string = this.doEMFCopy(object2);
                                }
                                bl2 = true;
                            }
                        }
                        catch (VisualizationInterruptedException visualizationInterruptedException) {
                            return false;
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            outOfMemoryError.printStackTrace();
                            AppMgr.getAppMgr().handleOutOfMemoryCondition();
                            return false;
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    if (bl3 && this.hasNonChartItems(viewerItemArray)) {
                        appClipboard.addClipboardData(new DataFlavor("text/plain; class=java.lang.String", "plain data"), (Object)stringBuffer.toString(), false);
                        appClipboard.addClipboardData(IOutputFlavor.TEXT_FLAVOR, (Object)stringBuffer.toString(), false);
                        TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID TEXT )");
                        this.updateStatus(2, true);
                    }
                    if (this.canCopy(4, n)) {
                        this.updateStatus(4, false);
                        object = new ByteArrayOutputStream();
                        ExportCopyParams exportCopyParams = PageSetupUtil.collectExportCopyParams(this.mWindow);
                        SpssRtfExporter spssRtfExporter = new SpssRtfExporter((OutputStream)object, exportCopyParams);
                        for (ViewerItem viewerItem : viewerItemArray) {
                            IOutputItem iOutputItem = viewerItem.getCoreItem();
                            if (iOutputItem instanceof ISpssExportable) {
                                spssRtfExporter.addItem((ISpssExportable)viewerItem.getCoreItem());
                            }
                            if (!Thread.currentThread().isInterrupted()) continue;
                            return false;
                        }
                        if (spssRtfExporter.closeStream()) {
                            appClipboard.addClipboardData(new DataFlavor("text/rtf; class=java.nio.ByteBuffer", "rtf data"), (Object)ByteBuffer.wrap(((ByteArrayOutputStream)object).toByteArray()), false);
                            TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID RTF )");
                            this.updateStatus(4, true);
                            Vector vector = spssRtfExporter.getExportWarnings();
                            for (IExportOutputResultItem iExportOutputResultItem : vector) {
                                ExportOutputUtil.displayAlert((JFrame)((Object)this.mWindow), iExportOutputResultItem.getResultCode(), iExportOutputResultItem.getLabel());
                            }
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    object = null;
                    if (this.canCopy(8, n) || this.isSingleChartSelected(viewerItemArray)) {
                        this.updateStatus(8, false);
                        object = this.mViewerDocument.getSelectionImage(this.canCopy(4096, n));
                        if (object != null) {
                            if (this.isSingleChartSelected(viewerItemArray) && !this.canCopy(32, n)) {
                                appClipboard.addClipboardData(IOutputFlavor.IMAGE_FLAVOR, object, false);
                                TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID IMAGE )");
                                this.updateStatus(8, true);
                            }
                        } else if (!bl2 && viewerItemArray != null && viewerItemArray.length > 0) {
                            void var15_36;
                            ViewerItem[] viewerItemArray2 = viewerItemArray;
                            int n2 = viewerItemArray2.length;
                            boolean bl5 = false;
                            while (var15_36 < n2) {
                                ViewerItem viewerItem = viewerItemArray2[var15_36];
                                if (viewerItem instanceof HeaderViewerItem) {
                                    String string5 = viewerItem.getCoreItem().getDescription();
                                    if (string5 == null || string5.length() <= 0) break;
                                    appClipboard.addClipboardData(new DataFlavor("text/plain; class=java.lang.String", "plain data"), (Object)string5, false);
                                    break;
                                }
                                ++var15_36;
                            }
                        }
                    }
                    if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                        appClipboard.flush();
                    } else {
                        try {
                            appClipboard.flush();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            Object object5 = appClipboard.getClipboardData(IOutputFlavor.IMAGE_FLAVOR);
                            if (object == null || object5 == null) break block50;
                            appClipboard.removeClipboardData(IOutputFlavor.IMAGE_FLAVOR);
                            appClipboard.flush();
                        }
                    }
                }
                if (swingWorker != null && swingWorker.isCancelled()) {
                    return false;
                }
                if (string != null) {
                    this.emfFileToClipboard(string);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID EMF )");
                    this.updateStatus(32, true);
                }
                if (object != null && OSInfo.getOSType() == OSInfo.OSType.WIN && this.canCopy(8, n)) {
                    this.updateStatus(8, false);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
                    BiffCopyHelper.setImageToClipboard((byte[])byteArrayOutputStream.toByteArray(), (int)1);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)object, "jpeg", byteArrayOutputStream);
                    BiffCopyHelper.setImageToClipboard((byte[])byteArrayOutputStream.toByteArray(), (int)2);
                    this.updateStatus(8, true);
                }
                if (swingWorker != null && swingWorker.isCancelled()) {
                    return false;
                }
                if (CommonState.getApplicationType() == CommonState.AppType.STATISTICS && this.canCopy(16, n)) {
                    this.updateStatus(16, false);
                    this.doBiffCopy(viewerItemArray);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID BIFF )");
                    this.updateStatus(16, true);
                }
                if (this.canCopy(64, n) && MGOHelper.canDoMGOForSelection(this.getDocument())) {
                    ViewerItem viewerItem;
                    this.updateStatus(64, false);
                    object = this.mViewerDocument.getSelectionImage(this.canCopy(4096, n));
                    if (object != null && (viewerItem = this.mViewerDocument.getFirstSelectedItem()) instanceof ChartViewerItem) {
                        this.writeMGOCopyToClipboard(viewerItem);
                    }
                }
                appClipboard.flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
                return false;
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) break block51;
                exception.printStackTrace();
            }
        }
        if (this.mSavedCopyMask != -1) {
            sCopyMask = this.mSavedCopyMask;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean doCopyWork(SwingWorker swingWorker, String string) {
        block64: {
            int n = sCopyMask;
            if (string.equalsIgnoreCase("context_output_copy_as_mgo")) {
                n = 64;
            } else if (string.equalsIgnoreCase("context_output_copy_as_image")) {
                n = 8;
            } else if (string.equalsIgnoreCase("context_output_copy_as_biff")) {
                n = 16;
            } else if (string.equalsIgnoreCase("context_output_copy_as_rtf")) {
                n = 4;
            } else if (string.equalsIgnoreCase("context_output_copy_as_emf")) {
                n = 32;
            } else if (string.equalsIgnoreCase("context_output_copy_as_native")) {
                n = 1;
            } else if (string.equalsIgnoreCase("context_output_copy_as_text")) {
                n = 2;
            }
            boolean bl = true;
            try {
                Object object;
                String string2;
                ViewerItem[] viewerItemArray;
                AppClipboard appClipboard;
                block63: {
                    if (!bl) {
                        // empty if block
                    }
                    appClipboard = AppClipboard.getAppClipboard();
                    viewerItemArray = this.mViewerDocument.getSelectedItems(true);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( START )");
                    if (this.canCopy(1, n)) {
                        try {
                            OutputSerializer outputSerializer = new OutputSerializer();
                            IOutputItem[] iOutputItemArray = new IOutputItem[viewerItemArray.length];
                            for (int i = 0; i < viewerItemArray.length; ++i) {
                                iOutputItemArray[i] = viewerItemArray[i].getCoreItem();
                            }
                            byte[] byArray = outputSerializer.serializeItems(iOutputItemArray);
                            appClipboard.addClipboardData(IOutputFlavor.NATIVE_FLAVOR, (Object)new OutputTransfer(byArray), false);
                            TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID NATIVE )");
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            outOfMemoryError.printStackTrace();
                            AppMgr.getAppMgr().handleOutOfMemoryCondition();
                            return false;
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    boolean bl3 = this.canCopy(2, n);
                    boolean bl4 = this.canCopy(32, n) && OSInfo.getOSType() == OSInfo.OSType.WIN && this.onlyOneVisItem(viewerItemArray);
                    boolean bl2 = false;
                    string2 = null;
                    String string3 = "\n";
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl3 || bl4) {
                        try {
                            this.updateStatus(2, false);
                            for (ViewerItem object2 : viewerItemArray) {
                                Object string4;
                                ViewerItem viewerItem;
                                if (swingWorker != null && swingWorker.isCancelled()) {
                                    return false;
                                }
                                if (bl3 && object2 instanceof TextViewerItem) {
                                    viewerItem = (TextViewerItem)object2;
                                    string4 = this.extractPlainText((TextViewerItem)viewerItem);
                                    stringBuffer.append((String)string4).append(string3);
                                    continue;
                                }
                                if (object2 instanceof TableViewerItem) {
                                    String string5;
                                    viewerItem = (TableViewerItem)object2;
                                    string4 = ((TableViewerItem)viewerItem).acquireVisualization();
                                    VizDataSource.switchToFullTable((Visualization)string4);
                                    if (bl3 && (string5 = ((TableViewerItem)viewerItem).getTableEditor().getFrame().getTableTabDelimitedText(string4, true)) != null) {
                                        stringBuffer.append(string5).append(string3).append(string3);
                                    }
                                    if (bl4) {
                                        this.updateStatus(32, false);
                                        string2 = this.doEMFCopy(viewerItem);
                                    }
                                    VizDataSource.switchToRowsTable((Visualization)string4);
                                    continue;
                                }
                                if (object2 instanceof LightTableViewerItem) {
                                    viewerItem = (LightTableViewerItem)object2;
                                    if (bl3 && (string4 = ((LightTableViewerItem)viewerItem).getCoreItem().getTableTabDelimitedText()) != null) {
                                        stringBuffer.append((String)string4).append(string3).append(string3);
                                    }
                                    if (swingWorker != null && swingWorker.isCancelled()) {
                                        return false;
                                    }
                                    if (!bl4) continue;
                                    string2 = this.doLtEMFCopy(((LightTableViewerItem)viewerItem).getCoreItem());
                                    continue;
                                }
                                if (!(object2 instanceof ChartViewerItem) && !(object2 instanceof GraphBoardViewerItem) && !(object2 instanceof TreeModelViewerItem) && !(object2 instanceof ModelViewerItem) && !(object2 instanceof JsonChartViewerItem) && !(object2 instanceof ImageViewerItem)) continue;
                                if (bl4) {
                                    this.updateStatus(32, false);
                                    string2 = this.doEMFCopy(object2);
                                }
                                bl2 = true;
                            }
                        }
                        catch (VisualizationInterruptedException visualizationInterruptedException) {
                            return false;
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            outOfMemoryError.printStackTrace();
                            AppMgr.getAppMgr().handleOutOfMemoryCondition();
                            return false;
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    if (bl3 && this.hasNonChartItems(viewerItemArray)) {
                        appClipboard.addClipboardData(new DataFlavor("text/plain; class=java.lang.String", "plain data"), (Object)stringBuffer.toString(), false);
                        appClipboard.addClipboardData(IOutputFlavor.TEXT_FLAVOR, (Object)stringBuffer.toString(), false);
                        TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID TEXT )");
                        this.updateStatus(2, true);
                    }
                    if (this.canCopy(4, n)) {
                        this.updateStatus(4, false);
                        object = new ByteArrayOutputStream();
                        ExportCopyParams exportCopyParams = PageSetupUtil.collectExportCopyParams(this.mWindow);
                        SpssRtfExporter spssRtfExporter = new SpssRtfExporter((OutputStream)object, exportCopyParams);
                        for (ViewerItem viewerItem : viewerItemArray) {
                            IOutputItem iOutputItem = viewerItem.getCoreItem();
                            if (iOutputItem instanceof ISpssExportable) {
                                spssRtfExporter.addItem((ISpssExportable)viewerItem.getCoreItem());
                            }
                            if (!Thread.currentThread().isInterrupted()) continue;
                            return false;
                        }
                        if (spssRtfExporter.closeStream()) {
                            appClipboard.addClipboardData(new DataFlavor("text/rtf; class=java.nio.ByteBuffer", "rtf data"), (Object)ByteBuffer.wrap(((ByteArrayOutputStream)object).toByteArray()), false);
                            TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID RTF )");
                            this.updateStatus(4, true);
                            Vector vector = spssRtfExporter.getExportWarnings();
                            for (IExportOutputResultItem iExportOutputResultItem : vector) {
                                ExportOutputUtil.displayAlert((JFrame)((Object)this.mWindow), iExportOutputResultItem.getResultCode(), iExportOutputResultItem.getLabel());
                            }
                        }
                    }
                    if (swingWorker != null && swingWorker.isCancelled()) {
                        return false;
                    }
                    object = null;
                    if (this.canCopy(8, n) || this.isSingleChartSelected(viewerItemArray)) {
                        this.updateStatus(8, false);
                        object = this.mViewerDocument.getSelectionImage(this.canCopy(4096, n));
                        if (object != null) {
                            if (this.isSingleChartSelected(viewerItemArray) && !this.canCopy(32, n)) {
                                appClipboard.addClipboardData(IOutputFlavor.IMAGE_FLAVOR, object, false);
                                TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID IMAGE )");
                                this.updateStatus(8, true);
                            }
                        } else if (!bl2 && viewerItemArray != null && viewerItemArray.length > 0) {
                            void var16_37;
                            ViewerItem[] viewerItemArray2 = viewerItemArray;
                            int n2 = viewerItemArray2.length;
                            boolean bl5 = false;
                            while (var16_37 < n2) {
                                ViewerItem viewerItem = viewerItemArray2[var16_37];
                                if (viewerItem instanceof HeaderViewerItem) {
                                    String string6 = viewerItem.getCoreItem().getDescription();
                                    if (string6 == null || string6.length() <= 0) break;
                                    appClipboard.addClipboardData(new DataFlavor("text/plain; class=java.lang.String", "plain data"), (Object)string6, false);
                                    break;
                                }
                                ++var16_37;
                            }
                        }
                    }
                    if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
                        appClipboard.flush();
                    } else {
                        try {
                            appClipboard.flush();
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            Object object5 = appClipboard.getClipboardData(IOutputFlavor.IMAGE_FLAVOR);
                            if (object == null || object5 == null) break block63;
                            appClipboard.removeClipboardData(IOutputFlavor.IMAGE_FLAVOR);
                            appClipboard.flush();
                        }
                    }
                }
                if (swingWorker != null && swingWorker.isCancelled()) {
                    return false;
                }
                if (string2 != null) {
                    this.emfFileToClipboard(string2);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID EMF )");
                    this.updateStatus(32, true);
                }
                if (object != null && OSInfo.getOSType() == OSInfo.OSType.WIN && this.canCopy(8, n)) {
                    this.updateStatus(8, false);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
                    BiffCopyHelper.setImageToClipboard((byte[])byteArrayOutputStream.toByteArray(), (int)1);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)object, "jpeg", byteArrayOutputStream);
                    BiffCopyHelper.setImageToClipboard((byte[])byteArrayOutputStream.toByteArray(), (int)2);
                    this.updateStatus(8, true);
                }
                if (swingWorker != null && swingWorker.isCancelled()) {
                    return false;
                }
                if (CommonState.getApplicationType() == CommonState.AppType.STATISTICS && this.canCopy(16, n)) {
                    this.updateStatus(16, false);
                    this.doBiffCopy(viewerItemArray);
                    TraceSettings.tracePerformance((String)"ViewerPanel.doCopy( DID BIFF )");
                    this.updateStatus(16, true);
                }
                if (this.canCopy(64, n) && MGOHelper.canDoMGOForSelection(this.getDocument())) {
                    ViewerItem viewerItem;
                    this.updateStatus(64, false);
                    object = this.mViewerDocument.getSelectionImage(this.canCopy(4096, n));
                    if (object != null && (viewerItem = this.mViewerDocument.getFirstSelectedItem()) instanceof ChartViewerItem) {
                        this.writeMGOCopyToClipboard(viewerItem);
                    }
                }
                appClipboard.flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
                AppMgr.getAppMgr().handleOutOfMemoryCondition();
                return false;
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) break block64;
                exception.printStackTrace();
            }
        }
        if (this.mSavedCopyMask != -1) {
            sCopyMask = this.mSavedCopyMask;
        }
        return true;
    }

    public void writeMGOCopyToClipboard(ViewerItem viewerItem) throws Exception {
        File file = MGOHelper.writeMGOToTempFile(viewerItem);
        if (file != null && file.length() > 0L) {
            try {
                DumpMGOToClipboard.putMGO((String)file.getPath());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        }
        catch (TransformerException transformerException) {
            System.out.println("nodeToString Transformer Exception");
        }
        return stringWriter.toString();
    }

    private void updateStatus(final int n, final boolean bl) {
        String string = this.getCopyUIName(n);
        final String string2 = string + " " + ResUtil.getString("edit_copy") + "...";
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ViewerPanel.this.mProgressDlg != null) {
                    ViewerPanel.this.mProgressDlg.updateProgress(string2, n, bl);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private String getCopyUIName(int n) {
        String string = null;
        ResourceBundle resourceBundle = ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (n == 2) {
            string = ResUtil.getString(resourceBundle, "IDS_PLAIN_TEXT");
        } else if (n == 4) {
            string = ResUtil.getString(resourceBundle, "IDS_RICH_TEXT");
        }
        if (n == 8) {
            string = ResUtil.getString(resourceBundle, "IDS_IMAGE");
        }
        if (n == 32) {
            string = ResUtil.getString(resourceBundle, "IDS_METAFILE");
        }
        if (n == 16) {
            string = ResUtil.getString(resourceBundle, "IDS_BIFF");
        }
        return string;
    }

    @Override
    public void saveDefaultCopySpecialFormat(int n) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/output/menus");
        preferences2.putInt("edit_copy_special_default_foramt", n);
    }

    private int getDefaultCopySpecialFormat(int n) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/output/menus");
        return preferences2.getInt("edit_copy_special_default_foramt", n);
    }

    private boolean isSingleChartSelected(ViewerItem[] viewerItemArray) {
        if (viewerItemArray != null && viewerItemArray.length == 1) {
            return viewerItemArray[0] instanceof ChartViewerItem || viewerItemArray[0] instanceof GraphBoardViewerItem || viewerItemArray[0] instanceof TreeModelViewerItem || viewerItemArray[0] instanceof ModelViewerItem || viewerItemArray[0] instanceof JsonChartViewerItem || viewerItemArray[0] instanceof ImageViewerItem;
        }
        return false;
    }

    public ChartViewerItemHelper.ChartType getGraphicChartType(ViewerItem viewerItem) {
        IOutputItem iOutputItem = viewerItem.getCoreItem();
        Visualization visualization = VizCache.getCache().getVisualization((ChartItem)iOutputItem);
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        return ChartViewerItemHelper.getGraphicChartType(visualizationSpecification);
    }

    class CopyProgressDlg
    extends SpssProgressDlg {
        SwingWorker mSwingWorker;
        private ArrayList<JCheckBox> activeChecks;

        CopyProgressDlg(JFrame jFrame, String string) {
            super((Window)jFrame, string);
            this.activeChecks = new ArrayList();
            this.updateMessagePanel();
        }

        @Override
        public void setMessage(String string) {
            super.setMessage(string);
        }

        void setSwingWorker(SwingWorker swingWorker) {
            this.mSwingWorker = swingWorker;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.cancel();
            super.windowClosing(windowEvent);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
            super.actionPerformed(actionEvent);
        }

        void cancel() {
            if (this.mSwingWorker != null) {
                this.mSwingWorker.cancel(true);
                super.setCancel(true);
                this.mSwingWorker = null;
            }
        }

        void updateMessagePanel() {
            if (ViewerPanel.this.canCopy(2, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(2)));
            }
            if (ViewerPanel.this.canCopy(4, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(4)));
            }
            if (ViewerPanel.this.canCopy(8, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(8)));
            }
            if (ViewerPanel.this.canCopy(32, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(32)));
            }
            if (ViewerPanel.this.canCopy(16, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(16)));
            }
            if (ViewerPanel.this.canCopy(64, sCopyMask)) {
                this.activeChecks.add(new JCheckBox(ViewerPanel.this.getCopyUIName(64)));
            }
            for (JCheckBox jCheckBox : this.activeChecks) {
                this.mMessagePanel.add(jCheckBox);
            }
            JLabel jLabel = new JLabel(ResUtil.getString("IDS_VIEWER_PROG_INFO"));
            this.mMessagePanel.add(jLabel);
            this.pack();
        }

        void updateProgress(String string, int n, boolean bl) {
            if (ViewerPanel.this.mProgressDlg == null) {
                return;
            }
            if (bl) {
                ViewerPanel.this.mProgressDlg.checkComplete(n);
            } else {
                ViewerPanel.this.mProgressDlg.setMessage(string);
            }
        }

        void checkComplete(int n) {
            for (JCheckBox jCheckBox : this.activeChecks) {
                String string = ViewerPanel.this.getCopyUIName(n);
                if (!jCheckBox.getText().equals(string)) continue;
                jCheckBox.setSelected(true);
                break;
            }
        }
    }
}

