/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.LightPivotTable;
import com.ibm.statistics.lighttable.ui.LtCanvasComponent;
import com.ibm.statistics.lighttable.ui.LtEditorFrame;
import com.ibm.statistics.lighttable.ui.LtEditorInfo;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.header.RootItem;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.output.BaseViewerLayout;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerItemListener;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.LogViewerItem;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.NotesViewerItem;
import com.spss.java_client.ui.doc_types.output.OutputContextMenu;
import com.spss.java_client.ui.doc_types.output.PageTitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.TitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerItemConstraints;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.doc_types.output.WarningViewerItem;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerOutputPaneDragAdapter;
import com.spss.java_client.ui.doc_types.output.undo.OutputSearchReplaceUndo;
import com.spss.java_client.ui.doc_types.output.undo.OutputUndoableEdit;
import com.spss.java_client.ui.doc_types.output.undo.UndoItemInfo;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.pivottable.PTInfo;
import com.spss.pivottable.gui.TableEditorFrame;
import com.spss.pivottable.gui.editing.InPlaceEditor;
import com.spss.pivottable.selection.SelectionProcessor;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.util.IOptionConstants;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ViewerOutputPane
extends JPanel
implements IViewerItemListener,
Scrollable,
IDropListener,
FocusListener {
    protected static float[] sDragDash1 = new float[]{1.0f};
    protected static BasicStroke sDragStroke = new BasicStroke(1.0f, 0, 0, 1.0f, sDragDash1, 0.0f);
    private static final ImageIcon FOCUS_ICON = new ImageIcon(ResUtil.getImageResource("NavFocusArrow.png"));
    private static Preferences sOptionsPrefs = null;
    public static ImageIcon LEFT_ALIGNMENT_ICON = new ImageIcon(ResUtil.getImageResource("leftjus.png"));
    public static ImageIcon CENTER_ALIGNMENT_ICON = new ImageIcon(ResUtil.getImageResource("centerjus.png"));
    public static ImageIcon RIGHT_ALIGNMENT_ICON = new ImageIcon(ResUtil.getImageResource("rightjus.png"));
    public static ImageIcon PAGE_TITLE_ICON = new ImageIcon(ResUtil.getImageResource("NavPageBreak.png"));
    private IViewerWindow mWindow = null;
    private ViewerItem mCurrentEdit = null;
    protected Rectangle mLastDragRect = null;
    private ViewerItem mDropItem;
    private boolean mIsResizing;
    private KeyAdapter mKeyListener = null;
    private MouseAdapter mMouseListener = null;
    private Rectangle mFocusBounds = null;
    private BaseViewerLayout mLayoutMgr = null;
    private RenderTimer mRenderTimer = null;

    public ViewerOutputPane(IViewerWindow iViewerWindow, BaseViewerLayout baseViewerLayout, boolean bl) {
        super(baseViewerLayout, bl);
        this.mWindow = iViewerWindow;
        this.mLayoutMgr = baseViewerLayout;
        this.init();
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(new MouseHandler());
        if (sOptionsPrefs == null) {
            sOptionsPrefs = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("general");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 40;
        dimension.height += 20;
        Container container = this.getParent();
        if (container != null) {
            Dimension dimension2 = container.getSize();
            dimension.width = dimension2.width > dimension.width ? dimension2.width : dimension.width;
            dimension.height = dimension2.height > dimension.height ? dimension2.height : dimension.height;
        }
        return dimension;
    }

    public void setDocumentModifiedFlag(boolean bl) {
        this.mWindow.setModified(bl);
    }

    public boolean canRender() {
        return this.mRenderTimer == null || !this.mRenderTimer.isRunning();
    }

    public void editAndSelect(ViewerSearchOptions viewerSearchOptions, int n) {
        boolean bl;
        Serializable serializable;
        boolean bl2 = false;
        ViewerFindDlg viewerFindDlg = null;
        ViewerItem viewerItem = viewerSearchOptions.getCurrentItem();
        if (viewerItem instanceof TextViewerItem) {
            serializable = (TextViewerItem)viewerItem;
            this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
            this.mWindow.setActivePane(IViewerWindow.PaneType.Content);
            bl = ((ViewerItem)serializable).isInEditMode();
            if (!bl) {
                ((ViewerItem)serializable).setInplaceMode(true);
                if (!((TextViewerItem)serializable).getTextPane().isHTMLDocument()) {
                    viewerSearchOptions.setOffset(viewerSearchOptions.getOffset());
                }
                this.startEdit((ViewerItem)serializable);
                viewerFindDlg = this.mWindow.getSearchDialog();
                if (viewerFindDlg != null && !viewerFindDlg.isVisible()) {
                    ((TextViewerItem)serializable).getTextPane().requestFocus();
                }
            }
            ((TextViewerItem)serializable).getTextPane().getCaret().setSelectionVisible(true);
            boolean bl3 = viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected;
            int n2 = viewerSearchOptions.getOffset();
            if (bl3 && (viewerSearchOptions.getInitiatedFromInPlaceEdit() || bl)) {
                n2 += viewerSearchOptions.getStartSelection();
            }
            ((TextViewerItem)serializable).selectContent(n2, n);
            bl2 = true;
        } else if (viewerItem instanceof TableViewerItem) {
            serializable = (TableViewerItem)viewerItem;
            if (!viewerSearchOptions.getInitiatedFromOutOfPlaceFrame()) {
                this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
                this.mWindow.setActivePane(IViewerWindow.PaneType.Content);
                if (!((ViewerItem)serializable).isInEditMode()) {
                    ((ViewerItem)serializable).setInplaceMode(true);
                    this.startEdit((ViewerItem)serializable);
                }
            }
            viewerSearchOptions.getTableSearcher().setCurrentSearchLayer(viewerSearchOptions);
            PTInfo pTInfo = ((TableViewerItem)serializable).getTableEditor().getPivotTableInfo();
            SelectionProcessor selectionProcessor = pTInfo.getSelectionMgr().getSelectionProcessor();
            Point point = viewerSearchOptions.getTableSearcher().getCellLocation();
            selectionProcessor.editAndSelect(pTInfo, point, viewerSearchOptions.getOffset(), n, !viewerSearchOptions.isReplaceAll());
            bl2 = true;
        } else if (viewerItem instanceof LightTableViewerItem) {
            serializable = (LightTableViewerItem)viewerItem;
            this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
            this.mWindow.setActivePane(IViewerWindow.PaneType.Content);
            bl = ((ViewerItem)serializable).isInEditMode();
            if (!bl && !viewerSearchOptions.isReplaceAll()) {
                ((ViewerItem)serializable).setInplaceMode(true);
                this.startEdit((ViewerItem)serializable);
            }
            Point point = viewerSearchOptions.getLightTableCell();
            final LtEditorFrame ltEditorFrame = ((LightTableViewerItem)serializable).getEditorFrame();
            if (ltEditorFrame != null && point.x > -1 && point.y > -1) {
                ltEditorFrame.getEditorInfo().getCanvas().clearSelection();
                Rectangle rectangle = ((LightTableViewerItem)serializable).getCoreItem().getLightPivotTable().getCellSpanRect(point.y, point.x);
                ltEditorFrame.getEditorInfo().getCanvas().addSelectionRect(rectangle);
                final int n3 = viewerSearchOptions.getOffset();
                final int n4 = viewerSearchOptions.getOffset() + n;
                if (viewerSearchOptions.getFootnoteMarkerOnly()) {
                    LtEditorInfo ltEditorInfo = ltEditorFrame.getEditorInfo();
                    ltEditorInfo.getCanvas().repaint();
                } else {
                    LtCanvasComponent ltCanvasComponent = ltEditorFrame.getEditorInfo().getCanvas().getComponent(new Point(rectangle.x + 2, rectangle.y + 2));
                    if (ltCanvasComponent == null) {
                        ltEditorFrame.getEditorInfo().getCanvas().scrollRectToVisible(rectangle);
                    } else {
                        ltCanvasComponent.scrollRectToVisible(rectangle);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            com.ibm.statistics.lighttable.ui.edit.InPlaceEditor inPlaceEditor = new com.ibm.statistics.lighttable.ui.edit.InPlaceEditor(ltEditorFrame.getEditorInfo());
                            Component component = inPlaceEditor.getComponent();
                            if (component instanceof JTextPane) {
                                String string = ((JTextPane)component).getText();
                                try {
                                    Double d = Double.parseDouble(string);
                                    ((JTextPane)component).select(n3, string.length());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ((JTextPane)component).select(n3, n4 > string.length() ? string.length() : n4);
                                }
                            }
                        }
                    });
                }
                bl2 = true;
            }
        }
        if (bl2 && !viewerSearchOptions.isReplaceAll()) {
            Object object;
            Window window = viewerSearchOptions.getTopFrame();
            if (window instanceof TableEditorFrame) {
                object = ((TableEditorFrame)window).getCanvas();
                serializable = object.getBounds();
                object = object.getParent();
            } else if (window instanceof LtEditorFrame) {
                object = ((LtEditorFrame)window).getEditorInfo().getCanvas();
                serializable = this.getSelectionBounds(viewerItem, viewerSearchOptions);
            } else {
                serializable = this.getSelectionBounds(viewerItem, viewerSearchOptions);
                object = this;
            }
            Point point = new Point(((Rectangle)serializable).x, ((Rectangle)serializable).y);
            SwingUtilities.convertPointToScreen(point, (Component)object);
            serializable = new Rectangle(point.x, point.y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            if (viewerFindDlg == null) {
                viewerFindDlg = this.mWindow.getDocument().getSearchDialog(window);
            }
            if (viewerFindDlg != null && viewerFindDlg.isVisible()) {
                viewerFindDlg.adjustPosition((Rectangle)serializable);
            }
        }
    }

    public void replaceEditingTextSelection(String string, ViewerSearchOptions viewerSearchOptions) {
        if (this.mCurrentEdit != null && this.mCurrentEdit.isInEditMode()) {
            if (this.mCurrentEdit instanceof TextViewerItem) {
                new OutputSearchReplaceUndo(this.mWindow, (TextViewerItem)this.mCurrentEdit, string);
            } else if (this.mCurrentEdit instanceof TableViewerItem) {
                new OutputSearchReplaceUndo(this.mWindow, (TableViewerItem)this.mCurrentEdit, viewerSearchOptions, string);
            } else if (this.mCurrentEdit instanceof LightTableViewerItem) {
                new OutputSearchReplaceUndo(this.mWindow, (LightTableViewerItem)this.mCurrentEdit, viewerSearchOptions, string);
            }
        }
    }

    public boolean selectionIsSearchString(ViewerSearchOptions viewerSearchOptions, String string) {
        if (this.mCurrentEdit != null && this.mCurrentEdit.isInEditMode()) {
            if (this.mCurrentEdit instanceof TextViewerItem) {
                TextViewerItem textViewerItem = (TextViewerItem)this.mCurrentEdit;
                SpssTextPane spssTextPane = textViewerItem.getTextPane();
                String string2 = spssTextPane.getSelectedText();
                if (!string.equalsIgnoreCase(string2 = string2.replace("\u00a0", " "))) {
                    int n = spssTextPane.getCaretPosition();
                    n = n - string.length() + 1;
                    spssTextPane.setCaretPosition(n);
                    spssTextPane.select(n, n + string.length());
                    string2 = spssTextPane.getSelectedText();
                    string2 = string2.replace("\u00a0", " ");
                }
                return string.equalsIgnoreCase(string2);
            }
            if (this.mCurrentEdit instanceof TableViewerItem) {
                Component component;
                TableViewerItem tableViewerItem = (TableViewerItem)this.mCurrentEdit;
                InPlaceEditor inPlaceEditor = tableViewerItem.getTableEditor().getPivotTableInfo().getTextEditor();
                Component component2 = component = inPlaceEditor != null ? inPlaceEditor.getComponent() : null;
                if (component instanceof JTextPane) {
                    if (viewerSearchOptions.getTableSearcher().currentCellIsLayerLabel()) {
                        return true;
                    }
                    String string3 = ((JTextPane)component).getSelectedText();
                    if (string3 != null) {
                        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
                        int n = string3.indexOf(decimalFormatSymbols.getDecimalSeparator());
                        if (n > -1) {
                            string3 = string3.substring(0, n);
                            return string.startsWith(string3);
                        }
                        return string.equalsIgnoreCase(string3);
                    }
                }
            } else if (this.mCurrentEdit instanceof LightTableViewerItem) {
                String string4;
                Component component;
                LightTableViewerItem lightTableViewerItem = (LightTableViewerItem)this.mCurrentEdit;
                com.ibm.statistics.lighttable.ui.edit.InPlaceEditor inPlaceEditor = lightTableViewerItem.getEditorFrame().getEditorInfo().getTextEditor();
                Component component3 = component = inPlaceEditor != null ? inPlaceEditor.getComponent() : null;
                if (component instanceof JTextPane && (string4 = ((JTextPane)component).getSelectedText()) != null) {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(ComponentState.getSPSSLocale());
                    int n = string4.indexOf(decimalFormatSymbols.getDecimalSeparator());
                    if (n > -1) {
                        string4 = string4.substring(0, n);
                        return string.startsWith(string4);
                    }
                    return string.equalsIgnoreCase(string4);
                }
            }
        }
        return false;
    }

    public void invalidateItem(ViewerItem viewerItem) {
        this.mLayoutMgr.invalidateItem(viewerItem);
    }

    public void clearCurrentEdit() {
        this.mCurrentEdit = null;
    }

    public void endAllEditors() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof ViewerItem) || !((ViewerItem)component).isInEditMode()) continue;
            ((ViewerItem)component).closeEditorWindow();
        }
    }

    public boolean isScrollToNewOutput() {
        IOutputDocument iOutputDocument = this.mWindow != null && this.mWindow.getDocument() != null ? this.mWindow.getDocument().getCoreDocument() : null;
        boolean bl = false;
        if (iOutputDocument != null) {
            bl = iOutputDocument.isInDocumentOpen();
        }
        return !bl && sOptionsPrefs.getBoolean("scroll_to_new", true);
    }

    public void hideSearchWindow() {
        ViewerFindDlg viewerFindDlg = this.mWindow.getSearchDialog();
        if (viewerFindDlg != null && viewerFindDlg.isVisible()) {
            viewerFindDlg.setVisible(false);
        }
    }

    public void reparentSearchWindow() {
        Serializable serializable;
        ViewerItem viewerItem = this.getEditingItem();
        if (viewerItem == null && this.mWindow.getDocument() != null) {
            serializable = this.mWindow.getDocument().getViewerItems();
            Iterator<ViewerItem> iterator = ((Vector)serializable).iterator();
            while (iterator.hasNext()) {
                ViewerItem viewerItem2 = iterator.next();
                if (!viewerItem2.isInEditMode()) continue;
                viewerItem = viewerItem2;
                break;
            }
        }
        if (viewerItem != null && !viewerItem.isInPlaceEdit()) {
            if (viewerItem instanceof TextViewerItem) {
                serializable = (TextViewerItem)viewerItem;
                if (((TextViewerItem)serializable).getTextFrame() != null && ((TextViewerItem)serializable).getTextFrame().getFindReplaceDlg() != null) {
                    ((TextViewerItem)serializable).getTextFrame().getFindReplaceDlg().setVisible(true);
                }
            } else if (viewerItem instanceof TableViewerItem && ((TableViewerItem)(serializable = (TableViewerItem)viewerItem)).getTableEditor() != null && ((TableViewerItem)serializable).getTableEditor().getPivotTableInfo().getSearchProxy() != null) {
                ((TableViewerItem)serializable).getTableEditor().getPivotTableInfo().getSearchProxy().showFindDialog((Window)((TableViewerItem)serializable).getTableEditor().getFrame(), false);
            }
        } else {
            this.mWindow.getSearchDialog().setVisible(true);
        }
    }

    public void handleSelectionChange(ViewerItem viewerItem, boolean bl) {
        if (!bl) {
            this.deselectAllItems(viewerItem);
        }
        boolean bl2 = true;
        if (bl && viewerItem.isSelected()) {
            bl2 = false;
        }
        if (this.mWindow.getDocument() != null) {
            this.mWindow.getDocument().selectionChanged(viewerItem, bl2, bl);
        }
    }

    public Object getTransferData() {
        return this.getFocusedViewerItem();
    }

    public ViewerItem getFocusedViewerItem() {
        return this.mWindow.getDocument().getFocusedViewerItem();
    }

    void setIsResizing(boolean bl) {
        this.mIsResizing = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.mWindow.setActivePane(IViewerWindow.PaneType.Content);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void notifyNewItem(final ViewerItem viewerItem, IOutputItem iOutputItem, boolean bl) {
        Rectangle rectangle;
        if (viewerItem == null || viewerItem instanceof HeaderViewerItem) {
            return;
        }
        if (viewerItem instanceof LogViewerItem) {
            viewerItem.removeMouseListener((MouseListener)((Object)this.mWindow.getOutputPaneDragAdapter()));
            viewerItem.removeMouseMotionListener((MouseMotionListener)((Object)this.mWindow.getOutputPaneDragAdapter()));
        }
        viewerItem.addMouseListener((MouseListener)((Object)this.mWindow.getOutputPaneDragAdapter()));
        viewerItem.addMouseMotionListener((MouseMotionListener)((Object)this.mWindow.getOutputPaneDragAdapter()));
        viewerItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ViewerOutputPane.this.handleItemMouseEvent(mouseEvent, viewerItem);
            }
        });
        this.mRenderTimer.start(viewerItem);
        int n = this.getNewItemIndex(viewerItem, iOutputItem);
        Insets insets = new Insets(2, 2, 20, 2);
        ViewerItemConstraints viewerItemConstraints = new ViewerItemConstraints(0, n, insets);
        this.add(viewerItem, viewerItemConstraints, n);
        if (viewerItem instanceof TextViewerItem) {
            ((TextViewerItem)viewerItem).getTextPane().setPreferredSize(null);
        }
        if (bl && (rectangle = viewerItem.getBounds()) != null) {
            rectangle.x = 0;
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void notifyRemoveItem(ViewerItem viewerItem) {
        this.remove(viewerItem);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void notifyEndHeading() {
    }

    @Override
    public void notifyObjectPropertyChange(IOutputItem iOutputItem) {
    }

    @Override
    public void notifyFocusedItem(ViewerItem viewerItem, boolean bl) {
        if (viewerItem == null) {
            return;
        }
        if (bl) {
            this.scrollItemIntoView(viewerItem);
        }
        if (this.mWindow == null || this.mWindow.getDocument() == null) {
            return;
        }
        ViewerItem viewerItem2 = this.mWindow.getDocument().getFocusedViewerItem();
        if (viewerItem2 != null && viewerItem2.isVisible()) {
            Rectangle rectangle = viewerItem2.getBounds();
            rectangle.width = rectangle.x;
            rectangle.x = 0;
            this.repaint(rectangle);
            if (this.mFocusBounds != null) {
                this.repaint(this.mFocusBounds);
            }
            this.mFocusBounds = rectangle;
        }
    }

    @Override
    public void notifySelectionChange(ViewerItem viewerItem, boolean bl, boolean bl2) {
        Container container = viewerItem.getParent();
        if (container != null) {
            Rectangle rectangle = viewerItem.getBounds();
            rectangle.grow(3, 3);
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void notifyKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 33 || keyEvent.getKeyCode() == 34) {
            int n = keyEvent.getKeyCode() == 33 ? -1 : 1;
            JScrollBar jScrollBar = this.mWindow.getOutputScrollPane().getVerticalScrollBar();
            int n2 = jScrollBar.getValue();
            int n3 = jScrollBar.getBlockIncrement(n);
            int n4 = n3 * n;
            int n5 = n2 + n4;
            if (n4 > 0 && n5 < n2) {
                n5 = jScrollBar.getMaximum();
            } else if (n4 < 0 && n5 > n2) {
                n5 = jScrollBar.getMinimum();
            }
            jScrollBar.setValue(n5);
        }
    }

    @Override
    public void notifyClearHeaderSelections() {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 30;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        JViewport jViewport;
        Component component;
        if (this.mIsResizing) {
            return Cursor.getDefaultCursor();
        }
        Cursor cursor = null;
        Point point2 = (Point)point.clone();
        Component component2 = this.mWindow.getOutputScrollPane().getComponent(0);
        if (component2 instanceof JViewport && (component = (jViewport = (JViewport)component2).getComponent(0)) instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)component;
            SwingUtilities.convertPointFromScreen(point2, viewerOutputPane);
            if (viewerOutputPane.contains(point2)) {
                if (dragDropAdapter instanceof ViewerOutputPaneDragAdapter) {
                    Component component3 = viewerOutputPane.getVisibleComponentAt(point2);
                    if (component3 instanceof ViewerItem) {
                        viewerOutputPane.mDropItem = (ViewerItem)component3;
                        cursor = DragPane.getNoDropCursor();
                        this.mWindow.getDocument().setFocusedViewerItem((ViewerItem)component3);
                        Graphics graphics = viewerOutputPane.getGraphics();
                        viewerOutputPane.renderFocus(graphics);
                        graphics.dispose();
                    } else if (viewerOutputPane.getComponentCount() == 0) {
                        try {
                            cursor = Cursor.getSystemCustomCursor("MoveDrop.32x32");
                        }
                        catch (AWTException aWTException) {
                            aWTException.printStackTrace();
                        }
                    } else {
                        try {
                            cursor = Cursor.getSystemCustomCursor("MoveDrop.32x32");
                        }
                        catch (AWTException aWTException) {
                            aWTException.printStackTrace();
                        }
                        Component component4 = viewerOutputPane.getVisibleComponentAbove(point2);
                        if (component4 instanceof ViewerItem && this.mWindow.getDocument().getFocusedViewerItem() != component4) {
                            viewerOutputPane.mDropItem = (ViewerItem)component4;
                            this.mWindow.getDocument().setFocusedViewerItem((ViewerItem)component4);
                            Graphics graphics = viewerOutputPane.getGraphics();
                            viewerOutputPane.renderFocus(graphics);
                            graphics.dispose();
                        }
                    }
                }
                viewerOutputPane.setCursor(cursor);
            }
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getVisibleComponentAt(Point point) {
        int n = point.x;
        int n2 = point.y;
        if (!this.contains(n, n2)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n3 = this.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible() || !component.contains(n - component.getBounds().x, n2 - component.getBounds().y)) continue;
                return component;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getVisibleComponentAbove(Point point) {
        int n = point.x;
        int n2 = point.y;
        if (!this.contains(n, n2)) {
            return null;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Component[] componentArray = this.getComponents();
            int n3 = this.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible()) continue;
                Component component2 = null;
                int n4 = i + 1;
                if (n4 < n3) {
                    component2 = componentArray[n4];
                    while (!component2.isVisible() && n4 < n3) {
                        component2 = componentArray[++n4];
                    }
                }
                if (!(component.getLocation().getY() < (double)n2) || component2 != null && !(component2.getLocation().getY() > (double)n2)) continue;
                return component;
            }
        }
        return this;
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        return dragDropAdapter.getTransferData() instanceof ViewerItem;
    }

    public void itemDropped(DropEvent dropEvent) {
        if (this.mIsResizing || this.getCursor() == DragPane.getNoDropCursor()) {
            return;
        }
        Component component = dropEvent.getSource();
        if (component instanceof ViewerItem) {
            JViewport jViewport;
            Component component2;
            Object object = dropEvent.getDragSourceAdapter().getTransferData();
            if (object == null || !(object instanceof ViewerItem)) {
                return;
            }
            ViewerItem viewerItem = (ViewerItem)object;
            LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
            IOutputItem iOutputItem = viewerItem.getCoreItem();
            HeaderItem headerItem = (HeaderItem)iOutputItem.getParentItem();
            int n = headerItem.getItemIndex(iOutputItem);
            Object object2 = n == 0 ? headerItem : headerItem.getChildItem(n - 1);
            UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)object2);
            linkedHashMap.put(iOutputItem, undoItemInfo);
            Point point = (Point)dropEvent.getDropLocation().clone();
            Component component3 = this.mWindow.getOutputScrollPane().getComponent(0);
            if (component3 instanceof JViewport && (component2 = (jViewport = (JViewport)component3).getComponent(0)) instanceof ViewerOutputPane) {
                ViewerOutputPane viewerOutputPane = (ViewerOutputPane)component2;
                SwingUtilities.convertPointFromScreen(point, viewerOutputPane);
                if (viewerOutputPane.contains(point) && component.getParent() == viewerOutputPane) {
                    if (viewerOutputPane.mDropItem == null) {
                        if (viewerOutputPane.getComponentCount() > 0) {
                            this.updateCursorForOutputPanes();
                            return;
                        }
                    } else if (viewerItem.equals(viewerOutputPane.mDropItem)) {
                        this.updateCursorForOutputPanes();
                        return;
                    }
                    if (this.equals(viewerOutputPane)) {
                        this.mWindow.getDocument().getCoreDocument().deleteItem(viewerItem.getCoreItem());
                    }
                    this.mWindow.getDocument().getCoreDocument().insertItem(viewerItem.getCoreItem(), viewerOutputPane.mDropItem == null ? null : viewerOutputPane.mDropItem.getCoreItem());
                    this.updateCursorForOutputPanes();
                    LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap2 = new LinkedHashMap<IOutputItem, UndoItemInfo>();
                    iOutputItem = viewerItem.getCoreItem();
                    headerItem = (HeaderItem)iOutputItem.getParentItem();
                    n = headerItem.getItemIndex(iOutputItem);
                    object2 = n == 0 ? headerItem : headerItem.getChildItem(n - 1);
                    undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)object2);
                    linkedHashMap2.put(iOutputItem, undoItemInfo);
                    new OutputUndoableEdit(this.mWindow, linkedHashMap, linkedHashMap2, true);
                    return;
                }
            }
        }
        this.updateCursorForOutputPanes();
    }

    @Override
    public void paint(Graphics graphics) {
        ViewerDocument viewerDocument;
        super.paint(graphics);
        ViewerDocument viewerDocument2 = viewerDocument = this.mWindow == null ? null : this.mWindow.getDocument();
        if (viewerDocument != null) {
            Vector<ViewerItem> vector = viewerDocument.getViewerItems();
            for (ViewerItem viewerItem : vector) {
                if (!viewerItem.isVisible()) continue;
                this.drawAlignmentImage(viewerItem, graphics, viewerItem.getCoreItem().getAlignment());
                if (!viewerItem.getPageBreak()) continue;
                this.drawViewerOutputPaneImage(graphics, viewerItem, PAGE_TITLE_ICON.getImage());
            }
        }
        this.renderFocus(graphics);
    }

    public void drawFeedback(Graphics graphics, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.white);
        graphics2D.setXORMode(Color.black);
        graphics2D.setStroke(sDragStroke);
        if (this.mLastDragRect != null) {
            graphics2D.drawRect(this.mLastDragRect.x, this.mLastDragRect.y, this.mLastDragRect.width, this.mLastDragRect.height);
        }
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.mLastDragRect = rectangle;
    }

    public void resetFeedback() {
        this.mLastDragRect = null;
    }

    public void startEdit(ViewerItem viewerItem) {
        if (!this.mWindow.canEdit(viewerItem)) {
            return;
        }
        if (!this.editingItemInFrame()) {
            this.endEdits();
        }
        this.mCurrentEdit = viewerItem;
        if (this.mCurrentEdit != null && !this.mCurrentEdit.startEdit()) {
            this.mCurrentEdit = null;
        }
    }

    public ViewerItem getEditingItem() {
        return this.mCurrentEdit;
    }

    public void setEditingItem(ViewerItem viewerItem) {
        this.mCurrentEdit = viewerItem;
    }

    public void setOutlineTitle(String string, ViewerItem viewerItem) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        this.handleSelectionChange(viewerItem, false);
        TreePath treePath = this.mWindow.getViewerTreePane().getViewerTree().getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof ViewerTreePane.NavTreeNode) {
            ViewerTreePane.NavTreeNode navTreeNode = (ViewerTreePane.NavTreeNode)object;
            navTreeNode.setName(string);
            ((DefaultTreeModel)this.mWindow.getViewerTreePane().getViewerTree().getModel()).nodeChanged(defaultMutableTreeNode);
        }
    }

    private void handleArrowKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40) {
            return;
        }
        this.mWindow.getDocument().moveFocus(keyEvent.getKeyCode() == 38);
    }

    private void handleHomeKeyEvent(KeyEvent keyEvent) {
        Vector<ViewerItem> vector;
        if ((keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 35) && (vector = this.mWindow.getDocument().getViewerItems()).size() > 1) {
            if (keyEvent.getKeyCode() == 36) {
                this.mWindow.getDocument().setFocusedViewerItem(vector.get(1));
            } else {
                this.mWindow.getDocument().setFocusedViewerItem(vector.get(vector.size() - 1));
            }
        }
    }

    private void renderFocus(Graphics graphics) {
        ViewerItem viewerItem;
        ViewerDocument viewerDocument;
        ViewerDocument viewerDocument2 = viewerDocument = this.mWindow == null ? null : this.mWindow.getDocument();
        if (viewerDocument != null && (viewerItem = this.mWindow.getDocument().getFocusedViewerItem()) != null && viewerItem.isVisible()) {
            Rectangle rectangle = viewerItem.getBounds();
            this.drawViewerOutputPaneImage(graphics, viewerItem, FOCUS_ICON.getImage());
            if (!(!viewerItem.isSelected() || viewerItem.isInEditMode() || viewerItem instanceof TableViewerItem || viewerItem instanceof ModelViewerItem || viewerItem instanceof LightTableViewerItem)) {
                boolean bl = viewerItem instanceof TextViewerItem;
                this.drawHandles((Graphics2D)graphics, rectangle, bl);
            }
        }
    }

    void scrollItemIntoView(ViewerItem viewerItem) {
        Container container = this.getParent();
        if (container instanceof JViewport && viewerItem.isVisible()) {
            boolean bl = false;
            Rectangle rectangle = viewerItem.getBounds();
            if (rectangle.height == 0 || rectangle.width == 0) {
                if (viewerItem.getCoreItem() instanceof HeaderItem) {
                    HeaderItem headerItem = (HeaderItem)viewerItem.getCoreItem();
                    if (headerItem.getChildCount() > 0) {
                        IOutputItem iOutputItem = headerItem.getChildItem(0);
                        for (int i = 0; i < this.getComponentCount(); ++i) {
                            Component component = this.getComponent(i);
                            if (!(component instanceof ViewerItem) || ((ViewerItem)component).getCoreItem() != iOutputItem) continue;
                            rectangle = component.getBounds();
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                rectangle.x = 0;
                this.scrollRectToViewTop(rectangle);
            } else {
                container.validate();
                this.scrollToEnd();
            }
        }
    }

    void scrollRectToViewTop(Rectangle rectangle) {
        Rectangle rectangle2 = this.getVisibleRect();
        if (rectangle.y > rectangle2.y && rectangle.getMaxY() < rectangle2.getMaxY()) {
            return;
        }
        if (this.mWindow != null) {
            JScrollBar jScrollBar = this.mWindow.getOutputScrollPane().getVerticalScrollBar();
            jScrollBar.setValue(rectangle.y - 2);
        }
    }

    ViewerItem getLastItem() {
        int n = this.getComponentCount();
        for (int i = n - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ViewerItem) || !((ViewerItem)component).getCoreItem().getVisible()) continue;
            return (ViewerItem)component;
        }
        return null;
    }

    private Rectangle getSelectionBounds(ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions) {
        if (!viewerItem.isInEditMode()) {
            return viewerItem.getBounds();
        }
        Rectangle rectangle = null;
        if (viewerItem instanceof TextViewerItem) {
            try {
                SpssTextPane spssTextPane = ((TextViewerItem)viewerItem).getTextPane();
                Rectangle rectangle2 = spssTextPane.modelToView(spssTextPane.getSelectionStart());
                rectangle2 = rectangle2.union(spssTextPane.modelToView(spssTextPane.getSelectionEnd()));
                rectangle = SwingUtilities.convertRectangle(spssTextPane, rectangle2, this);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else if (viewerItem instanceof TableViewerItem) {
            PTInfo pTInfo = ((TableViewerItem)viewerItem).getTableEditor().getPivotTableInfo();
            InPlaceEditor inPlaceEditor = pTInfo.getTextEditor();
            if (inPlaceEditor != null) {
                Component component = inPlaceEditor.getComponent();
                rectangle = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), this);
            }
        } else if (viewerItem instanceof LightTableViewerItem) {
            LightPivotTable lightPivotTable = ((LightTableViewerItem)viewerItem).getCoreItem().getLightPivotTable();
            rectangle = lightPivotTable.getCellSpanRect(viewerSearchOptions.getLightTableCell().y, viewerSearchOptions.getLightTableCell().x);
        }
        if (rectangle == null) {
            rectangle = viewerItem.getBounds();
        }
        return rectangle;
    }

    private void drawAlignmentImage(ViewerItem viewerItem, Graphics graphics, OutputItemAlignment outputItemAlignment) {
        Image image = LEFT_ALIGNMENT_ICON.getImage();
        if (outputItemAlignment == OutputItemAlignment.Center) {
            image = CENTER_ALIGNMENT_ICON.getImage();
        } else if (outputItemAlignment == OutputItemAlignment.Right) {
            image = RIGHT_ALIGNMENT_ICON.getImage();
        }
        this.drawViewerOutputPaneImage(graphics, viewerItem, image);
    }

    private void drawViewerOutputPaneImage(Graphics graphics, ViewerItem viewerItem, Image image) {
        Rectangle rectangle = viewerItem.getBounds();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = (int)((double)rectangle.y + (rectangle.getHeight() - (double)n2) / 2.0);
        if (image == LEFT_ALIGNMENT_ICON.getImage() || image == CENTER_ALIGNMENT_ICON.getImage() || image == RIGHT_ALIGNMENT_ICON.getImage()) {
            n3 = (int)rectangle.getMaxY() - n2;
        } else if (image == PAGE_TITLE_ICON.getImage()) {
            n3 = rectangle.y;
        }
        int n4 = this.getComponentOrientation().isLeftToRight() ? rectangle.x - (n + 2) : (int)(rectangle.getMaxX() + 2.0);
        graphics.drawImage(image, n4, n3, null);
    }

    private void drawHandles(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        if (!bl) {
            this.drawSquareHandle(graphics2D, rectangle.getX(), rectangle.getY());
            this.drawSquareHandle(graphics2D, rectangle.getX() + rectangle.getWidth() - 1.0, rectangle.getY());
            this.drawSquareHandle(graphics2D, rectangle.getX(), rectangle.getY() + rectangle.getHeight() - 1.0);
            this.drawSquareHandle(graphics2D, rectangle.getX() + rectangle.getWidth() - 1.0, rectangle.getY() + rectangle.getHeight() - 1.0);
        }
        if (!bl) {
            this.drawSquareHandle(graphics2D, rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY());
            this.drawSquareHandle(graphics2D, rectangle.getX() + rectangle.getWidth() / 2.0, rectangle.getY() + rectangle.getHeight() - 1.0);
        }
        this.drawSquareHandle(graphics2D, rectangle.getX() + rectangle.getWidth() - 1.0, rectangle.getY() + rectangle.getHeight() / 2.0);
        this.drawSquareHandle(graphics2D, rectangle.getX(), rectangle.getY() + rectangle.getHeight() / 2.0);
    }

    private void drawSquareHandle(Graphics2D graphics2D, double d, double d2) {
        graphics2D.fill(new Rectangle2D.Double(d - 2.0, d2 - 2.0, 5.0, 5.0));
    }

    private void handleShiftClick(ViewerItem viewerItem) {
        JTree jTree = this.mWindow.getViewerTreePane().getViewerTree();
        TreePath treePath = jTree.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem2 = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            this.deselectAllItems(viewerItem2);
            boolean bl = false;
            boolean bl2 = false;
            for (Component component : this.getComponents()) {
                if (!(component instanceof ViewerItem)) continue;
                if (!((ViewerItem)component).isSelected() && bl && !bl2) {
                    this.mWindow.getDocument().selectionChanged((ViewerItem)component, true, true);
                }
                if (viewerItem != component && viewerItem2 != component) continue;
                if (!bl) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (((ViewerItem)component).isSelected()) continue;
                this.mWindow.getDocument().selectionChanged((ViewerItem)component, true, true);
            }
        }
    }

    private void handleItemMouseEvent(MouseEvent mouseEvent, ViewerItem viewerItem) {
        String string;
        Serializable serializable;
        String string2;
        if (mouseEvent.getButton() != 1) {
            if (mouseEvent.getButton() == 3) {
                boolean bl = viewerItem.isSelected();
                if (bl || mouseEvent.isControlDown()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (mouseEvent.getClickCount() == 1 && !this.editingItemInFrame()) {
            this.endEdits();
        }
        this.mWindow.getDocument().setFocusedViewerItem(viewerItem);
        if (mouseEvent.isShiftDown()) {
            this.handleShiftClick(viewerItem);
        } else {
            this.handleSelectionChange(viewerItem, mouseEvent.isControlDown());
        }
        Dimension dimension = viewerItem.getSize();
        String string3 = sOptionsPrefs.get("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[0]);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string3);
        int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
        double d = (double)n2 / 2.54;
        double d2 = dimension.getHeight();
        double d3 = dimension.getWidth();
        String string4 = " pt.";
        switch (n) {
            case 1: {
                d2 /= (double)n2;
                d3 /= (double)n2;
                string4 = " in";
                break;
            }
            case 2: {
                d2 /= d;
                d3 /= d;
                string4 = " cm";
            }
        }
        if (n == 0) {
            string2 = "H: " + (int)d2 + ", W: " + (int)d3 + string4;
        } else {
            serializable = NumberFormat.getNumberInstance();
            ((NumberFormat)serializable).setMaximumFractionDigits(2);
            string2 = "H: " + ((NumberFormat)serializable).format(d2) + ", W: " + ((NumberFormat)serializable).format(d3) + string4;
        }
        serializable = this.mWindow.getStatusBar();
        if (serializable != null) {
            ((StatusBar)serializable).putPaneMessage(StatusBar.StatusPane.objectSizePane, string2);
        }
        if (viewerItem instanceof GenericViewerItem) {
            if (serializable != null) {
                ((StatusBar)serializable).putPaneMessage(StatusBar.StatusPane.helpPane, ResUtil.getString("IDS_CANNOT_EDIT_STATIC"));
            }
            return;
        }
        String string5 = ResUtil.getString("IDS_DBL_CLK_PROMPT");
        if (viewerItem instanceof LogViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_LOG");
        } else if (viewerItem instanceof NotesViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_NOTES");
        } else if (viewerItem instanceof TitleViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_TITLE");
        } else if (viewerItem instanceof PageTitleViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_PAGETITLE");
        } else if (viewerItem instanceof WarningViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_WARNINGS");
        } else if (viewerItem instanceof TextViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_TEXT");
        } else if (viewerItem instanceof TreeModelViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_TREE");
        } else if (viewerItem instanceof ChartViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_CHART");
        } else if (viewerItem instanceof GraphBoardViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_GRAPHBOARD");
        } else if (viewerItem instanceof ModelViewerItem) {
            string = ResUtil.getString("IDS_VIEWER_ITEM_MODELVIEWER");
        } else {
            if (viewerItem instanceof ImageViewerItem) {
                return;
            }
            string = ResUtil.getString("IDS_VIEWER_ITEM_TABLE");
            if (viewerItem instanceof TableViewerItem) {
                ((TableViewerItem)viewerItem).classifyTableSize();
            } else if (viewerItem instanceof LightTableViewerItem) {
                ((LightTableViewerItem)viewerItem).classifyTableSize();
            }
        }
        String string6 = String.format(string5, string);
        if (serializable != null) {
            ((StatusBar)serializable).putPaneMessage(StatusBar.StatusPane.helpPane, string6);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerOutputPane.this.requestFocus();
            }
        });
    }

    private void scrollToEnd() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = ViewerOutputPane.this.getBounds();
                rectangle.x = 0;
                rectangle.width = 10;
                rectangle.y = rectangle.height - 10;
                rectangle.height = 10;
                ViewerOutputPane.this.scrollRectToVisible(rectangle);
            }
        });
    }

    public boolean editingItemInFrame() {
        return this.mCurrentEdit != null && this.mCurrentEdit.isInEditMode() && !this.mCurrentEdit.isInPlaceEdit();
    }

    private int getNewItemIndex(ViewerItem viewerItem, IOutputItem iOutputItem) {
        int n;
        if (iOutputItem instanceof RootItem) {
            return 0;
        }
        if (iOutputItem != null) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!(component instanceof ViewerItem) || ((ViewerItem)component).getCoreItem() != iOutputItem) continue;
                return i + 1;
            }
        }
        HeaderItem headerItem = (HeaderItem)viewerItem.getCoreItem().getParentItem();
        boolean bl = false;
        if (iOutputItem != null && iOutputItem instanceof HeaderItem && iOutputItem == headerItem && headerItem.getItemIndex(viewerItem.getCoreItem()) == 0) {
            bl = true;
        }
        int n2 = 0;
        int n3 = this.getNonHeaderChildCount(headerItem, true);
        if (n3 == 1 || bl) {
            HeaderItem headerItem2 = headerItem;
            HeaderItem headerItem3 = (HeaderItem)headerItem2.getParentItem();
            if (headerItem3 == null) {
                return 0;
            }
            while (headerItem3 != null) {
                int n4 = headerItem3.getItemIndex((IOutputItem)headerItem2);
                for (int i = 0; i < n4; ++i) {
                    headerItem2 = headerItem3.getChildItem(i);
                    if (headerItem2 instanceof HeaderItem) {
                        n2 += this.getNonHeaderChildCount(headerItem2, true);
                        continue;
                    }
                    ++n2;
                }
                headerItem2 = headerItem3;
                headerItem3 = (HeaderItem)headerItem2.getParentItem();
            }
            return n2;
        }
        boolean bl2 = true;
        int n5 = n = headerItem != null ? headerItem.getItemIndex(viewerItem.getCoreItem()) : 0;
        if (n == 0) {
            bl2 = false;
        }
        IOutputItem iOutputItem2 = this.getNonHeaderChild(headerItem, n, bl2);
        if (bl2 && iOutputItem2 == null) {
            return this.getComponentCount();
        }
        if (!bl2 && iOutputItem2 == null) {
            return 0;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ViewerItem) || ((ViewerItem)component).getCoreItem() != iOutputItem2) continue;
            return bl2 ? i + 1 : i;
        }
        return this.getComponentCount();
    }

    private int getNonHeaderChildCount(HeaderItem headerItem, boolean bl) {
        int n = 0;
        if (headerItem != null) {
            int n2 = headerItem.getChildCount();
            for (int i = 0; i < n2; ++i) {
                if (!(headerItem.getChildItem(i) instanceof HeaderItem)) {
                    ++n;
                    continue;
                }
                if (!bl) continue;
                n += this.getNonHeaderChildCount((HeaderItem)headerItem.getChildItem(i), true);
            }
        }
        return n;
    }

    private IOutputItem getNonHeaderChild(HeaderItem headerItem, int n, boolean bl) {
        if (headerItem == null) {
            return null;
        }
        int n2 = bl ? -1 : 1;
        int n3 = n + n2;
        IOutputItem iOutputItem = headerItem.getChildItem(n3);
        HeaderItem headerItem2 = headerItem;
        int n4 = headerItem2.getChildCount();
        while (iOutputItem instanceof HeaderItem) {
            while (iOutputItem instanceof HeaderItem && this.getNonHeaderChildCount((HeaderItem)iOutputItem, true) == 0 && (bl ? n3 > 0 : n3 < n4 - 1)) {
                iOutputItem = headerItem2.getChildItem(n3 += n2);
            }
            if (!(iOutputItem instanceof HeaderItem)) {
                return iOutputItem;
            }
            if (this.getNonHeaderChildCount((HeaderItem)iOutputItem, true) != 0) {
                int n5 = ((HeaderItem)iOutputItem).getChildCount();
                return this.getNonHeaderChild((HeaderItem)iOutputItem, bl ? n5 : -1, bl);
            }
            if (!bl ? n3 < n4 - 1 : n3 > 0) continue;
            headerItem2 = (HeaderItem)iOutputItem.getParentItem().getParentItem();
            if (headerItem2 == null) break;
            n3 = headerItem2.getItemIndex(iOutputItem.getParentItem());
            iOutputItem = headerItem2.getChildItem(n3 + n2);
        }
        if (!(iOutputItem instanceof HeaderItem)) {
            return iOutputItem;
        }
        return null;
    }

    public void endEdits() {
        if (this.mCurrentEdit != null) {
            this.mCurrentEdit.endEdit();
            ViewerFindDlg viewerFindDlg = this.mWindow.getSearchDialog();
            if (viewerFindDlg != null && viewerFindDlg.isVisible()) {
                viewerFindDlg.editingStopped();
            }
        }
        this.mCurrentEdit = null;
    }

    private void deselectAllItems(ViewerItem viewerItem) {
        if (this.mWindow.getDocument() == null) {
            return;
        }
        for (Component component : this.getComponents()) {
            if (!(component instanceof ViewerItem) || !((ViewerItem)component).isSelected() || viewerItem != null && viewerItem == component) continue;
            this.mWindow.getDocument().selectionChanged((ViewerItem)component, false, false);
        }
        this.mWindow.getDocument().deselectHeaderNodes();
    }

    private void init() {
        this.setOpaque(true);
        if (OSCheck.getOSType() == OSInfo.OSType.WIN) {
            this.setBackground(SystemColor.window);
        } else {
            this.setBackground(SystemColor.white);
        }
        this.mRenderTimer = new RenderTimer();
        this.mWindow.getDocument().addItemListener(this);
        this.mKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                boolean bl = false;
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        ViewerItem viewerItem = ViewerOutputPane.this.mWindow.getDocument().getFocusedViewerItem();
                        if (viewerItem == null) break;
                        viewerItem.initiateEditing();
                        bl = true;
                        break;
                    }
                    case 38: 
                    case 40: {
                        ViewerOutputPane.this.handleArrowKeyEvent(keyEvent);
                        bl = true;
                        break;
                    }
                    case 121: {
                        if (!keyEvent.isShiftDown()) break;
                        ViewerOutputPane.this.doContextMenu(keyEvent);
                        bl = true;
                        break;
                    }
                    case 525: {
                        ViewerOutputPane.this.doContextMenu(keyEvent);
                        bl = true;
                        break;
                    }
                    case 35: 
                    case 36: {
                        if (!keyEvent.isControlDown() && !keyEvent.isMetaDown()) break;
                        ViewerOutputPane.this.handleHomeKeyEvent(keyEvent);
                        bl = true;
                        break;
                    }
                    case 127: {
                        ViewerOutputPane.this.mWindow.doDelete();
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    keyEvent.consume();
                }
            }
        };
        this.addKeyListener(this.mKeyListener);
        this.mMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    OutputContextMenu outputContextMenu = new OutputContextMenu(ViewerOutputPane.this);
                    outputContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                ViewerOutputPane.this.requestFocusInWindow();
                if (!ViewerOutputPane.this.editingItemInFrame()) {
                    ViewerOutputPane.this.endEdits();
                }
                ViewerOutputPane.this.deselectAllItems(null);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && !SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                    OutputContextMenu outputContextMenu = new OutputContextMenu(ViewerOutputPane.this);
                    outputContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.addMouseListener(this.mMouseListener);
    }

    private void doContextMenu(KeyEvent keyEvent) {
        if (CommandLine.isClementineCaller()) {
            return;
        }
        int n = this.mWindow.getDocument().getSelectedItemCount(true);
        ViewerItem viewerItem = this.mWindow.getDocument().getFocusedViewerItem();
        Point point = keyEvent.getComponent().getMousePosition();
        if (point == null) {
            point = keyEvent.getComponent().getLocation();
            point.translate(10, 10);
        }
        OutputContextMenu outputContextMenu = viewerItem != null && n == 1 ? new OutputContextMenu(viewerItem, 2) : new OutputContextMenu(this);
        outputContextMenu.show(keyEvent.getComponent(), (int)point.getX(), (int)point.getY());
    }

    public void performClose() {
        this.removeFocusListener(this);
        this.removeKeyListener(this.mKeyListener);
        this.removeMouseListener(this.mMouseListener);
        this.mKeyListener = null;
        this.mMouseListener = null;
        this.removeAll();
        Container container = this.getParent();
        if (container != null) {
            container.removeAll();
            container.remove(container);
        }
        this.setLayout(null);
        this.mWindow = null;
    }

    private void updateCursorForOutputPanes() {
        JViewport jViewport;
        Component component;
        Component component2 = this.mWindow.getOutputScrollPane().getComponent(0);
        if (component2 instanceof JViewport && (component = (jViewport = (JViewport)component2).getComponent(0)) instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)component;
            viewerOutputPane.setCursor(null);
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ViewerItem viewerItem = ViewerOutputPane.this.mWindow.getDocument().getFocusedViewerItem();
            if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) {
                viewerItem.endEdit();
            }
        }
    }

    class RenderTimer
    implements ActionListener {
        private Timer mTimer = null;
        private TreeMap<Integer, ViewerItem> mRenderItems = new TreeMap();

        public void start(ViewerItem viewerItem) {
            if (viewerItem == null) {
                return;
            }
            this.mRenderItems.put(viewerItem.getId(), viewerItem);
            if (this.mTimer != null) {
                this.mTimer.stop();
            }
            this.mTimer = new Timer(100, this);
            this.mTimer.start();
        }

        public boolean isRunning() {
            return this.mTimer != null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.mTimer.stop();
            this.mTimer = null;
            for (ViewerItem viewerItem : this.mRenderItems.values()) {
                viewerItem.repaint();
            }
            this.mRenderItems.clear();
        }
    }
}

