/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.ui.doc_types.output.BaseViewerLayout;
import com.spss.java_client.ui.doc_types.output.ViewerItemConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.io.Serializable;

public class ViewerLayout
extends BaseViewerLayout {
    private BaseViewerLayout.FasterVector<BaseViewerLayout.FasterVector<Component>> mRowData = null;

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof ViewerItemConstraints) {
            this.setConstraints(component, (ViewerItemConstraints)object);
            this.mRowData = null;
        } else if (object != null) {
            throw new IllegalArgumentException("Cannot add to layout: constraints must be a ViewerItemConstraint");
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
        this.mRowData = null;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (this.mRowData == null) {
            this.mRowData = new BaseViewerLayout.FasterVector(this.mCompTable.size());
            this.determineGridPositions(container, this.mRowData);
            this.determineGridRects(this.mRowData, false);
            this.positionComponents(container, this.mRowData, false, false);
        }
        return this.determineExtents(this.mRowData);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (this.mRowData == null) {
            this.mRowData = new BaseViewerLayout.FasterVector(this.mCompTable.size());
            this.determineGridPositions(container, this.mRowData);
            this.determineGridRects(this.mRowData, true);
            this.positionComponents(container, this.mRowData, true, false);
        }
        return this.determineExtents(this.mRowData);
    }

    @Override
    public void layoutContainer(Container container) {
        if (this.mRowData == null) {
            this.mRowData = new BaseViewerLayout.FasterVector(this.mCompTable.size());
        }
        this.mRowData.clear();
        this.determineGridPositions(container, this.mRowData);
        this.determineGridRects(this.mRowData, false);
        this.positionComponents(container, this.mRowData, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private void determineGridPositions(Container container, BaseViewerLayout.FasterVector<BaseViewerLayout.FasterVector<Component>> fasterVector) {
        ViewerItemConstraints viewerItemConstraints;
        int n;
        Component[] componentArray;
        Component[] componentArray2 = componentArray = container.getComponents();
        int n2 = componentArray2.length;
        for (n = 0; n < n2; ++n) {
            BaseViewerLayout.FasterVector<Object> fasterVector2;
            Component component = componentArray2[n];
            if (!component.isVisible()) continue;
            viewerItemConstraints = this.lookupConstraints(component);
            if (viewerItemConstraints.getYPos() >= fasterVector.size()) {
                fasterVector2 = new BaseViewerLayout.FasterVector<Object>();
                while (fasterVector.size() < viewerItemConstraints.getYPos()) {
                    fasterVector.add(null);
                }
                if (fasterVector.size() == viewerItemConstraints.getYPos() || fasterVector.get(viewerItemConstraints.getYPos()) != null) {
                    fasterVector.add(viewerItemConstraints.getYPos(), fasterVector2);
                } else {
                    fasterVector.set(viewerItemConstraints.getYPos(), fasterVector2);
                }
            }
            if ((fasterVector2 = (BaseViewerLayout.FasterVector<Object>)fasterVector.get(viewerItemConstraints.getYPos())) == null) {
                fasterVector2 = new BaseViewerLayout.FasterVector<Object>();
                fasterVector.set(viewerItemConstraints.getYPos(), fasterVector2);
            }
            while (fasterVector2.size() < viewerItemConstraints.getXPos()) {
                fasterVector2.add(null);
            }
            if (fasterVector2.size() == viewerItemConstraints.getXPos() || fasterVector2.get(viewerItemConstraints.getXPos()) != null) {
                fasterVector2.add(viewerItemConstraints.getXPos(), component);
                continue;
            }
            fasterVector2.set(viewerItemConstraints.getXPos(), component);
        }
        for (int i = fasterVector.size() - 1; i >= 0; --i) {
            if (fasterVector.get(i) != null) continue;
            fasterVector.remove(i);
        }
        for (BaseViewerLayout.FasterVector fasterVector3 : fasterVector) {
            for (n = fasterVector3.size() - 1; n >= 0; --n) {
                if (fasterVector3.get(n) != null) continue;
                fasterVector3.remove(n);
            }
        }
        boolean bl = false;
        for (BaseViewerLayout.FasterVector fasterVector3 : fasterVector) {
            void var7_11;
            int n3 = fasterVector.indexOf(fasterVector3, (int)(++var7_11));
            n = 0;
            for (Component component : fasterVector3) {
                viewerItemConstraints = this.lookupConstraints(component);
                viewerItemConstraints.setAdjustedXPos(fasterVector3.indexOf(component, n++));
                viewerItemConstraints.setAdjustedYPos(n3);
            }
        }
    }

    private void determineGridRects(BaseViewerLayout.FasterVector<BaseViewerLayout.FasterVector<Component>> fasterVector, boolean bl) {
        int n = 0;
        int n2 = 0;
        Rectangle rectangle = new Rectangle();
        for (BaseViewerLayout.FasterVector fasterVector2 : fasterVector) {
            int n3 = 0;
            for (Component component : fasterVector2) {
                if (!component.isVisible()) continue;
                ViewerItemConstraints viewerItemConstraints = this.lookupConstraints(component);
                Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
                rectangle.x = n2;
                rectangle.y = n;
                rectangle.width = dimension.width;
                rectangle.height = dimension.height;
                int n4 = rectangle.height + insets.top + insets.bottom;
                n3 = n3 > n4 ? n3 : n4;
                viewerItemConstraints.setPosition(rectangle);
                n2 += rectangle.width + insets.left + insets.right + 1;
            }
            n2 = 0;
            n += n3 + 1;
        }
    }

    private void positionComponents(Container container, BaseViewerLayout.FasterVector<BaseViewerLayout.FasterVector<Component>> fasterVector, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        boolean bl3 = !container.getComponentOrientation().isLeftToRight();
        for (BaseViewerLayout.FasterVector fasterVector2 : fasterVector) {
            ViewerItemConstraints viewerItemConstraints;
            Serializable serializable;
            Object object;
            if (bl3) {
                Serializable serializable2 = this.lookupConstraints((Component)fasterVector2.get(fasterVector2.size() - 1)).getPosition();
                int n3 = ((Rectangle)serializable2).x + ((Rectangle)serializable2).width;
                object = fasterVector2.iterator();
                while (object.hasNext()) {
                    serializable = (Component)object.next();
                    if (!((Component)serializable).isVisible()) continue;
                    viewerItemConstraints = this.lookupConstraints((Component)serializable);
                    Rectangle rectangle = viewerItemConstraints.getPosition();
                    rectangle.x = n3 - (rectangle.x + rectangle.width);
                    viewerItemConstraints.setPosition(rectangle);
                }
            }
            for (Serializable serializable2 : fasterVector2) {
                if (!((Component)serializable2).isVisible()) continue;
                viewerItemConstraints = this.lookupConstraints((Component)serializable2);
                Rectangle rectangle = viewerItemConstraints.getPosition();
                Object object2 = object = bl ? ((Component)serializable2).getMinimumSize() : ((Component)serializable2).getPreferredSize();
                if (((Dimension)object).width < rectangle.width) {
                    rectangle.x += (int)((float)(rectangle.width - ((Dimension)object).width) * this.getLayoutAlignmentX(container));
                }
                if (((Dimension)object).height < rectangle.height) {
                    rectangle.y += (int)((float)(rectangle.height - ((Dimension)object).height) * this.getLayoutAlignmentY(container));
                }
                if (bl2) {
                    serializable = (Rectangle)rectangle.clone();
                    Insets insets = this.getAdjustedInsets(viewerItemConstraints, (Component)serializable2);
                    ((Rectangle)serializable).x += insets.left;
                    ((Rectangle)serializable).y += insets.top;
                    ((Component)serializable2).setBounds((Rectangle)serializable);
                    n = (int)((double)n < ((RectangularShape)((Object)serializable)).getMaxX() ? ((RectangularShape)((Object)serializable)).getMaxX() : (double)n);
                    n2 = (int)((double)n2 < ((RectangularShape)((Object)serializable)).getMaxY() ? ((RectangularShape)((Object)serializable)).getMaxY() : (double)n2);
                    continue;
                }
                viewerItemConstraints.setPosition(rectangle);
            }
        }
        if (bl2) {
            Dimension dimension = container.getSize();
            n = dimension.width;
            n2 = n2 > dimension.height ? n2 : dimension.height;
            container.setSize(n, n2);
        }
    }

    private Dimension determineExtents(BaseViewerLayout.FasterVector<BaseViewerLayout.FasterVector<Component>> fasterVector) {
        int n = 0;
        int n2 = 0;
        for (BaseViewerLayout.FasterVector fasterVector2 : fasterVector) {
            for (Component component : fasterVector2) {
                ViewerItemConstraints viewerItemConstraints = this.lookupConstraints(component);
                Rectangle rectangle = viewerItemConstraints.getPosition();
                Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
                n = (int)((double)n < rectangle.getMaxX() + (double)insets.right ? rectangle.getMaxX() + (double)insets.right : (double)n);
                n2 = (int)((double)n2 < rectangle.getMaxY() + (double)insets.bottom ? rectangle.getMaxY() + (double)insets.bottom : (double)n2);
            }
        }
        return new Dimension(n, n2);
    }
}

