/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.IOutputItemUIAgent;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.OutputContextMenu;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.IUpdater;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextAttribute;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.InflaterInputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class ViewerItem
extends JComponent
implements IOutputItemUIAgent,
IUpdater,
Accessible {
    protected static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.black, 1);
    protected static final Border EDITING_BORDER = new DashBorder();
    protected static Border HIGHLIGHT_BORDER = null;
    protected static String TIP_TEXT = ResUtil.getString("IDS_ITEM_TIP_TEXT");
    protected IOutputItem mCoreItem = null;
    protected MouseHandler mMouseHandler = new MouseHandler();
    protected boolean mIsCollapsed = false;
    protected boolean mIsHidden = false;
    protected Border mOriginalBorder = null;
    private boolean mIsEditMode = false;
    private boolean mIsInPlaceEditing = false;
    private boolean mIsInPlaceEditMode = false;
    protected JMenuBar mFrameMainMenuBar;
    protected JMenuBar mFrameEditingMenuBar;
    protected String mUILanguage;
    private boolean mIsRendered;
    private AccessibleContext mAccessibleContext;

    public ViewerItem(IOutputItem iOutputItem) {
        this.mCoreItem = iOutputItem;
        if (this.mCoreItem != null) {
            this.mCoreItem.setUIAgent((IOutputItemUIAgent)this);
        }
        this.mIsRendered = true;
        this.init();
    }

    public static void resetResStrings() {
        TIP_TEXT = ResUtil.getString("IDS_ITEM_TIP_TEXT");
    }

    public abstract ViewerDocument.ComponentType getComponentType();

    public abstract void renderContents(Graphics2D var1);

    public void renderWithTransparency(Graphics2D graphics2D) {
        this.renderContents(graphics2D);
    }

    @Override
    public abstract Dimension getPreferredSize();

    @Override
    public abstract Dimension getMinimumSize();

    public static void setHighlightBorderColor() {
        Color color = UIManager.getColor("List.selectionBackground");
        if (color == null) {
            color = new Color(255, 203, 0);
        }
        HIGHLIGHT_BORDER = new LineBorder(color, 2, true);
    }

    public boolean isRendered() {
        return this.mIsRendered;
    }

    public void setRendered(boolean bl) {
        this.mIsRendered = bl;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)container;
            viewerOutputPane.invalidateItem(this);
        }
    }

    public boolean startEdit() {
        this.mIsEditMode = true;
        this.setBorder(EDITING_BORDER);
        this.revalidate();
        return true;
    }

    public void endEdit() {
        this.mIsEditMode = false;
        this.setBorder(this.mCoreItem.isSelected() ? SELECTED_BORDER : this.mOriginalBorder);
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)container;
            viewerOutputPane.clearCurrentEdit();
            viewerOutputPane.requestFocusInWindow();
        }
    }

    public IOutputItem getCoreItem() {
        return this.mCoreItem;
    }

    public int getId() {
        return this.mCoreItem != null ? this.mCoreItem.getId() : 0;
    }

    public void setSelected(boolean bl) {
        boolean bl2 = this.mCoreItem.isSelected();
        if (bl2 == bl) {
            return;
        }
        this.mCoreItem.setSelected(bl);
        if (this.mCoreItem instanceof TextItem && bl) {
            TextViewerItem textViewerItem = (TextViewerItem)this;
            textViewerItem.positionTextControl();
        }
        this.setBorder(bl ? SELECTED_BORDER : this.mOriginalBorder);
    }

    public boolean isSelected() {
        return this.mCoreItem.isSelected();
    }

    public void setPageBreak(boolean bl) {
        this.mCoreItem.setPageBreak(bl);
    }

    public boolean getPageBreak() {
        return this.mCoreItem.getPageBreak();
    }

    public void setLabel(String string) {
        this.mCoreItem.setDescription(string);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        boolean bl2 = this.mIsHidden = !bl;
        if (this.mCoreItem.getVisible() != bl) {
            ViewerDocument viewerDocument;
            this.mCoreItem.setVisible(bl);
            if (this.getTopLevelAncestor() != null && (viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument()) != null && viewerDocument.getFocusedViewerItem() == this) {
                this.repaintFocusArrow();
            }
        }
    }

    public void setCollapsed(boolean bl) {
        ViewerDocument viewerDocument;
        boolean bl2;
        boolean bl3 = this.mIsCollapsed != bl;
        this.mIsCollapsed = bl;
        boolean bl4 = bl2 = !bl;
        if (this.mIsHidden && bl2) {
            bl2 = false;
        }
        super.setVisible(bl2);
        if (bl3 && this.getTopLevelAncestor() != null && (viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument()) != null && viewerDocument.getFocusedViewerItem() == this) {
            this.repaintFocusArrow();
        }
    }

    public boolean isCollapsed() {
        return this.mIsCollapsed;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public boolean isInEditMode() {
        return this.mIsEditMode;
    }

    public boolean isInPlaceEdit() {
        return this.mIsInPlaceEditing;
    }

    protected void setInPlaceEdit(boolean bl) {
        this.mIsInPlaceEditing = bl;
    }

    public boolean isInPlaceMode() {
        return this.mIsInPlaceEditMode;
    }

    public void setInplaceMode(boolean bl) {
        this.mIsInPlaceEditMode = bl;
    }

    public boolean canEdit() {
        return !this.isInEditMode() && this.isRendered();
    }

    public void initiateEditing() {
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)container;
            viewerOutputPane.startEdit(this);
        }
    }

    public void closeEditorWindow() {
    }

    public void resetTipText() {
        this.setToolTipText(TIP_TEXT);
    }

    public void refreshDisplay() {
        this.repaint();
        Container container = this.getTopLevelAncestor();
        if (container instanceof ITopWindow) {
            ((ITopWindow)((Object)container)).getViewerPanel().updateToolbarEnableStatus();
        }
    }

    public void refreshLayout() {
    }

    public void refreshContent() {
        Dimension dimension = new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.refreshSize();
        this.revalidate();
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)container;
            viewerOutputPane.setOutlineTitle(this.mCoreItem.getDescription(), this);
        }
    }

    public void relayoutSimple() {
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.mAccessibleContext == null) {
            this.mAccessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.mAccessibleContext;
    }

    public int isValidVarName(String string) {
        VarNameValidator.ValidNameCode validNameCode;
        boolean bl;
        int n = 1;
        boolean bl2 = bl = !VarNameValidator.validateAgainstCurCharSet((String)string);
        if (bl && ((validNameCode = VarNameValidator.validateSPSSName((String)string, (boolean)true)) == VarNameValidator.ValidNameCode.SPSSNAME_STANDARD || validNameCode == VarNameValidator.ValidNameCode.SPSSNAME_WARN_UNDERSCORE)) {
            LocallyUniqueId locallyUniqueId;
            n = 0;
            DataMgr dataMgr = DataMgr.getDataMgr();
            ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(locallyUniqueId = dataMgr.getActiveDocumentId());
            if (iSpssDataSrc == null) {
                iSpssDataSrc = dataMgr.getDataSource(dataMgr.getActiveBackendDocumentId());
            }
            if (iSpssDataSrc != null && iSpssDataSrc.findVarIndex(string) > -1) {
                n = 2;
            }
        }
        return n;
    }

    public boolean pasteOrRunSyntax(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (bl) {
            return SyntaxMgr.getSyntaxMgr().pasteSyntax(string);
        }
        return SyntaxMgr.getSyntaxMgr().executeSyntax(string);
    }

    public void applySizeChange(int n, int n2) {
    }

    public void applyStyleChanges(HashMap<TextAttribute, Object> hashMap) {
    }

    protected void refreshSize() {
    }

    protected void renderingComplete(BufferedImage bufferedImage) {
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (graphics instanceof Graphics2D) {
            this.renderContents((Graphics2D)graphics);
        }
    }

    protected void init() {
        this.removeMouseListener(this.mMouseHandler);
        this.removeMouseMotionListener(this.mMouseHandler);
        this.addMouseListener(this.mMouseHandler);
        this.addMouseMotionListener(this.mMouseHandler);
        this.setToolTipText(TIP_TEXT);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mOriginalBorder = this.getBorder();
        if (HIGHLIGHT_BORDER == null) {
            ViewerItem.setHighlightBorderColor();
        }
    }

    protected boolean canResize(int n) {
        return true;
    }

    protected boolean changeCursor(Point point, boolean bl) {
        int n = this.getCursor().getType();
        if (!this.isSelected() || !this.canResize(-1)) {
            if (n != 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            return false;
        }
        SwingUtilities.convertPointToScreen(point, this);
        SwingUtilities.convertPointFromScreen(point, this.getParent());
        int n2 = (int)point.getX();
        int n3 = (int)point.getY();
        int n4 = 5;
        int n5 = 5;
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle((int)rectangle.getMinX(), (int)rectangle.getMinY(), (int)((RectangularShape)rectangle).getWidth(), (int)((RectangularShape)rectangle).getHeight());
        rectangle2.grow(-n4 / 2, -n4 / 2);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        rectangle3.grow(n4 / 2, n5 / 2);
        Rectangle rectangle4 = new Rectangle(rectangle2);
        if (((RectangularShape)rectangle).getHeight() > (double)(n5 * 2)) {
            rectangle4.grow(-n4 / 2 - 1, -n5 / 2 - 1);
        } else {
            rectangle3.grow(n4 / 2, n5 / 2);
        }
        int n6 = -1;
        boolean bl2 = rectangle3.contains(n2, n3);
        boolean bl3 = rectangle4.contains(n2, n3);
        if (!bl3 && bl2) {
            rectangle2.translate(-n4 / 2, -n5 / 2);
            Rectangle rectangle5 = new Rectangle(rectangle2.getLocation(), new Dimension(n4, n5));
            Rectangle rectangle6 = new Rectangle((int)rectangle2.getX(), (int)rectangle2.getCenterY(), n4, n5);
            Rectangle rectangle7 = new Rectangle((int)rectangle2.getX(), (int)(rectangle2.getHeight() + rectangle2.getY()), n4, n5);
            Rectangle rectangle8 = new Rectangle((int)(rectangle2.getWidth() + rectangle2.getX()), (int)(rectangle2.getHeight() + rectangle2.getY()), n4, n5);
            Rectangle rectangle9 = new Rectangle((int)(rectangle2.getWidth() + rectangle2.getX()), (int)rectangle2.getCenterY(), n4, n5);
            Rectangle rectangle10 = new Rectangle((int)(rectangle2.getWidth() + rectangle2.getX()), (int)rectangle2.getY(), n4, n5);
            Rectangle rectangle11 = new Rectangle((int)rectangle2.getCenterX(), (int)rectangle2.getY(), n4, n5);
            Rectangle rectangle12 = new Rectangle((int)rectangle2.getCenterX(), (int)(rectangle2.getHeight() + rectangle2.getY()), n4, n5);
            if (rectangle10.contains(n2, n3)) {
                n6 = 7;
            } else if (rectangle9.contains(n2, n3)) {
                n6 = 11;
            } else if (rectangle8.contains(n2, n3)) {
                n6 = 5;
            } else if (rectangle7.contains(n2, n3)) {
                n6 = 4;
            } else if (rectangle12.contains(n2, n3)) {
                n6 = 9;
            } else if (rectangle6.contains(n2, n3)) {
                n6 = 10;
            } else if (rectangle5.contains(n2, n3)) {
                n6 = 6;
            } else if (rectangle11.contains(n2, n3)) {
                n6 = 8;
            }
            if (n6 > -1 && !this.canResize(n6)) {
                n6 = 0;
            }
            if (n6 < 0 && bl) {
                n6 = 13;
            }
        } else {
            n6 = 0;
        }
        if (n != n6) {
            if (n6 != -1) {
                this.setCursor(Cursor.getPredefinedCursor(n6));
            }
            return true;
        }
        return false;
    }

    protected void borderResize(Point point) {
        if (!this.isSelected()) {
            return;
        }
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null) {
            ((ViewerOutputPane)this.getParent()).setIsResizing(true);
            Graphics graphics = this.getParent().getGraphics();
            ((ViewerOutputPane)this.getParent()).drawFeedback(graphics, rectangle);
        } else {
            ((ViewerOutputPane)this.getParent()).setIsResizing(false);
        }
    }

    protected void resize(Point point) {
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null) {
            this.mCoreItem.setWidth(rectangle.width + 2);
            this.mCoreItem.setHeight(rectangle.height + 2);
            ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
            viewerDocument.setFocusedViewerItem(this);
            viewerDocument.getCoreDocument().setModifiedFlag(true);
            viewerDocument.notifyChangedModifiedFlag();
            ((ViewerOutputPane)this.getParent()).handleSelectionChange(this, false);
        }
        ((ViewerOutputPane)this.getParent()).resetFeedback();
    }

    protected Rectangle getDragRect(Point point) {
        double d;
        double d2;
        SwingUtilities.convertPointToScreen(point, this);
        SwingUtilities.convertPointFromScreen(point, this.getParent());
        Rectangle rectangle = this.getBounds();
        double d3 = point.getX();
        double d4 = point.getY();
        double d5 = rectangle.getMinX();
        double d6 = rectangle.getMinY();
        switch (this.getCursor().getType()) {
            case 8: {
                d6 = d4;
                d2 = ((RectangularShape)rectangle).getWidth();
                d = rectangle.getMaxY() - d4;
                break;
            }
            case 9: {
                d2 = ((RectangularShape)rectangle).getWidth();
                d = d4 - rectangle.getMinY();
                break;
            }
            case 11: {
                d2 = d3 - rectangle.getMinX();
                d = ((RectangularShape)rectangle).getHeight();
                break;
            }
            case 10: {
                d5 = d3;
                d2 = rectangle.getMaxX() - d3;
                d = ((RectangularShape)rectangle).getHeight();
                break;
            }
            case 7: {
                d6 = d4;
                d2 = d3 - rectangle.getMinX();
                d = rectangle.getMaxY() - d4;
                break;
            }
            case 6: {
                d5 = d3;
                d6 = d4;
                d2 = rectangle.getMaxX() - d3;
                d = rectangle.getMaxY() - d4;
                break;
            }
            case 4: {
                d5 = d3;
                d2 = rectangle.getMaxX() - d3;
                d = d4 - rectangle.getMinY();
                break;
            }
            case 5: {
                d2 = d3 - rectangle.getMinX();
                d = d4 - rectangle.getMinY();
                break;
            }
            default: {
                return null;
            }
        }
        double d7 = d5 + d2;
        double d8 = d6 + d;
        return new Rectangle((int)Math.min(d5, d7), (int)Math.min(d6, d8), (int)Math.abs(d5 - d7), (int)Math.abs(d6 - d8));
    }

    protected void renderEditModeHatchPattern(Graphics2D graphics2D, int n, int n2) {
        if (!this.mIsEditMode) {
            return;
        }
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        rectangle.grow(-2, -2);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle);
        int n3 = 1;
        do {
            graphics2D.drawLine(0, n3 * 5, n3 * 5, 0);
        } while (++n3 * 5 <= n + n2);
        graphics2D.setClip(shape);
    }

    protected void updateViewerFrameMenus(boolean bl) {
        Container container = this.getTopLevelAncestor();
        if (!(container instanceof SpssFrame)) {
            return;
        }
        if (bl) {
            this.setEditingMenu();
        } else {
            this.restoreMainMenu();
        }
    }

    protected void updateViewerFrameToolBars(boolean bl) {
        Container container = this.getTopLevelAncestor();
        if (!(container instanceof SpssFrame)) {
            return;
        }
        if (bl) {
            this.setEditingToolBars();
        } else {
            this.restoreMainToolBars();
        }
    }

    protected void setEditingMenu() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof SpssFrame) {
            SpssFrame spssFrame = (SpssFrame)container;
            this.mFrameMainMenuBar = spssFrame.getJMenuBar();
            this.mFrameEditingMenuBar = this.composeMixedMenuBar(spssFrame, this.mFrameMainMenuBar);
            if (this.mFrameEditingMenuBar != null) {
                spssFrame.setJMenuBar(this.mFrameEditingMenuBar);
                spssFrame.removeMenuBarListeners(this.mFrameMainMenuBar);
                spssFrame.addMenuBarListeners(this.mFrameEditingMenuBar);
                this.mFrameEditingMenuBar.revalidate();
            }
        }
        this.mUILanguage = PrefsMgr.getILangName();
    }

    protected void restoreMainMenu() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof SpssFrame) {
            final SpssFrame spssFrame = (SpssFrame)container;
            this.mFrameEditingMenuBar.setVisible(false);
            String string = PrefsMgr.getILangName();
            if (!string.equals(this.mUILanguage)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JMenuBar jMenuBar = spssFrame.getJMenuBar();
                        if (jMenuBar != null && ViewerItem.this.getTopLevelAncestor() instanceof JFrame) {
                            ((JFrame)ViewerItem.this.getTopLevelAncestor()).setJMenuBar(jMenuBar);
                        }
                    }
                });
            } else {
                ((JFrame)this.getTopLevelAncestor()).setJMenuBar(this.mFrameMainMenuBar);
            }
            if (this.mFrameEditingMenuBar != null) {
                spssFrame.removeMenuBarListeners(this.mFrameEditingMenuBar);
            }
            spssFrame.addMenuBarListeners(this.mFrameMainMenuBar);
        }
    }

    protected void setEditingToolBars() {
    }

    protected void restoreMainToolBars() {
    }

    protected JMenuBar composeMixedMenuBar(SpssFrame spssFrame, JMenuBar jMenuBar) {
        return null;
    }

    protected JMenu getTopLevelMenu(JMenuBar jMenuBar, String string) {
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            Action action = jMenu.getAction();
            if (!(action instanceof SpssAction) || !((SpssAction)action).getActionId().equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    protected void repaintFocusArrow() {
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)container;
            Rectangle rectangle = this.getBounds();
            rectangle.width = rectangle.x;
            rectangle.x = 0;
            viewerOutputPane.repaint(200L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected InputStream getProperInputStream(byte[] byArray) {
        InputStream inputStream = null;
        if (byArray.length > 0) {
            inputStream = byArray[0] == 120 ? new InflaterInputStream(new ByteArrayInputStream(byArray)) : new ByteArrayInputStream(byArray);
        }
        return inputStream;
    }

    protected JMenuBar cloneMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = new JMenuBar();
        int n = jMenuBar.getMenuCount();
        for (int i = 0; i < n; ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            JMenu jMenu2 = null;
            jMenu2 = jMenu.getAction() != null ? new JMenu(jMenu.getAction()) : new JMenu(jMenu.getText());
            jMenuBar2.add(jMenu2);
            this.cloneMenu(jMenu, jMenu2);
        }
        return jMenuBar2;
    }

    private void cloneMenu(JMenu jMenu, JMenu jMenu2) {
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem instanceof JMenu) {
                JMenu jMenu3 = new JMenu(jMenuItem.getAction());
                jMenu2.add(jMenu3);
                this.cloneMenu((JMenu)jMenuItem, jMenu3);
                continue;
            }
            if (jMenuItem instanceof JMenuItem) {
                jMenu2.add(new JMenuItem(jMenuItem.getAction()));
                continue;
            }
            jMenu2.addSeparator();
        }
    }

    private void initPopup(MouseEvent mouseEvent, boolean bl) {
        if (mouseEvent.isPopupTrigger()) {
            if (!CommandLine.isClementineCaller()) {
                OutputContextMenu outputContextMenu = new OutputContextMenu(this, 2);
                outputContextMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (bl) {
            int n = this.getCursor().getType();
            if (this.isSelected() && (n == 8 || n == 9 || n == 11 || n == 10 || n == 7 || n == 6 || n == 4 || n == 5)) {
                this.resize(mouseEvent.getPoint());
            }
        }
    }

    protected void setupVisualizationSpec() {
    }

    static class DashBorder
    extends EmptyBorder {
        private BasicStroke mStroke = null;

        public DashBorder() {
            super(1, 1, 1, 1);
            float[] fArray = new float[]{2.0f, 6.0f, 2.0f, 6.0f};
            this.mStroke = new BasicStroke(1.0f, 1, 1, 0.0f, fArray, 0.0f);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(SystemColor.black);
                graphics2D.setStroke(this.mStroke);
                graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
                graphics2D.setStroke(stroke);
                graphics2D.setColor(color);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                if (ViewerItem.this instanceof ModelViewerItem) {
                    ((ModelViewerItem)ViewerItem.this).showView(mouseEvent.getPoint());
                }
                mouseEvent.consume();
                ViewerItem.this.initiateEditing();
            } else {
                ViewerItem.this.setupVisualizationSpec();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                ViewerItem.this.initPopup(mouseEvent, true);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                ViewerItem.this.initPopup(mouseEvent, false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SpssFrameMgr.getSpssFrameMgr().isModifyOutputDialogActive()) {
                ViewerItem.this.borderResize(mouseEvent.getPoint());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ViewerItem.this.changeCursor(mouseEvent.getPoint(), false);
            if (ViewerItem.this.canEdit()) {
                ViewerItem.this.setBorder(HIGHLIGHT_BORDER);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (ViewerItem.this.canEdit()) {
                ViewerItem.this.setBorder(HIGHLIGHT_BORDER);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (ViewerItem.this.canEdit()) {
                ViewerItem.this.setBorder(ViewerItem.this.mCoreItem.isSelected() ? SELECTED_BORDER : ViewerItem.this.mOriginalBorder);
            }
        }
    }
}

