/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.imageio.ImageIO;

class ViewerImage {
    private WeakReference<byte[]> mBufferRef = new WeakReference<Object>(null);
    private byte[] mBuffer = null;
    private ViewerItem mViewerItem = null;
    private boolean mComplete = false;
    private boolean mFinished = false;
    private BufferedImage mTemporaryImage = null;

    ViewerImage() {
    }

    ViewerImage(ViewerItem viewerItem, BufferedImage bufferedImage, boolean bl, boolean bl2) {
        if (bufferedImage != null) {
            this.mViewerItem = viewerItem;
            this.mComplete = bl;
            boolean bl3 = this.mFinished = this.mComplete && bl2;
            if (this.mFinished) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", ImageIO.createImageOutputStream(byteArrayOutputStream));
                    this.mBufferRef = new WeakReference<byte[]>(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.mTemporaryImage = bufferedImage;
            }
        }
    }

    BufferedImage get() {
        BufferedImage bufferedImage = null;
        if (this.mComplete) {
            if (this.mFinished) {
                byte[] byArray = (byte[])this.mBufferRef.get();
                if (byArray != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    try {
                        bufferedImage = ImageIO.read(ImageIO.createImageInputStream(byteArrayInputStream));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                bufferedImage = this.mTemporaryImage;
            }
        }
        return bufferedImage;
    }

    boolean cache() {
        this.mBuffer = (byte[])this.mBufferRef.get();
        return this.mBuffer != null;
    }

    boolean uncache() {
        boolean bl = this.mBuffer != null;
        this.mBuffer = null;
        if (this.mViewerItem != null) {
            ImageGenerator2.getImageGenerator().clearItem(this.mViewerItem);
        }
        return bl;
    }

    int size() {
        int n = 0;
        byte[] byArray = (byte[])this.mBufferRef.get();
        if (byArray != null) {
            n = byArray.length;
        }
        return n;
    }

    ViewerItem getViewerItem() {
        return this.mViewerItem;
    }
}

