/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.statistics.lighttable.base.TableLayer;
import com.ibm.statistics.lighttable.data.LightTableListener;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.spss.bagpipe.factory.BPFactory;
import com.spss.bagpipe.factory.DisplayHeadings;
import com.spss.bagpipe.factory.PivotTable;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.ASMapsError;
import com.spss.java_client.core.comp_util.SysFileProxy;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.ICoreDocumentUIAgent;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputDocumentUIAgent;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.IPageSetupInfo;
import com.spss.java_client.core.documents.output.OutputItem;
import com.spss.java_client.core.documents.output.PageSetupInfo;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.core.documents.output.text.PageTitleItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.output.text.TitleItem;
import com.spss.java_client.core.nps_feedless.INpsTriggerListener;
import com.spss.java_client.core.nps_feedless.UserInfoUtil;
import com.spss.java_client.core.script.autoscripts.IAutoscriptEvent;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controlbar.ToolbarItem;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.SPSSFontChooser;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.dialogs.nps_feedless.NpsFeedlessPane;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputDlg;
import com.spss.java_client.ui.dialogs.post_processing_output.ModifyOutputSelectDlg;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.StatusBar;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.UserMenuAction;
import com.spss.java_client.ui.doc_types.actions.output.ConvertLightTableAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuMgr;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.IViewerWindowEx;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.OutputFactory;
import com.spss.java_client.ui.doc_types.output.SelectSpssTreeNodes;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.doc_types.output.ViewerStatusBar;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import com.spss.java_client.ui.doc_types.output.drag_drop.ViewerOutputPaneDragAdapter;
import com.spss.java_client.ui.print.OutputViewPrintable;
import com.spss.java_client.ui.print.SpssPrintable;
import com.spss.java_client.ui.print.pdf_export.PdfExporter;
import com.spss.java_client.ui.print.ppt_export.PptExporter;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.java_client.ui.texteditor.actions.BaseTextAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.export.IExportOptions;
import com.spss.shared.export.PDFDocumentExportOptions;
import com.spss.shared.export.PPTDocumentExportOptions;
import com.spss.uitools.dialogs.IProgressUIAgent;
import com.spss.uitools.util.WindowUtil;
import com.spss.vis.graphboard.util.PrintOptions;
import com.spss.vizimager.VizDataWriter;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.FocusManager;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ViewerFrame
extends SpssFrame
implements IViewerWindowEx,
MouseListener,
IOutputDocumentUIAgent,
INpsTriggerListener {
    protected ViewerPanel mImpl;
    private static ViewerFindDlg sSearchDialog = null;
    private static MenuCache sMenuTreeCache = new MenuCache(null);
    private static Vector<String> sDeletedAddOnItems = new Vector();
    private OutputViewPrintable.PrintRange mPrintRange = null;
    private IViewerWindow.PaneType mActivePane;
    ModifyOutputDlg mModifyOutputDlg;
    private GlobalKeyHandler mKeyHandler = new GlobalKeyHandler();

    public static ViewerFrame createViewerFrame(boolean bl, boolean bl2) throws HeadlessException {
        ViewerFrame viewerFrame = null;
        try {
            OutputFactory.getOutputFactory();
            viewerFrame = new ViewerFrame();
            SpssFrameMgr.getSpssFrameMgr().positionNewFrame(viewerFrame);
            if (bl2) {
                viewerFrame.setExtendedState(1);
            }
            if (bl) {
                viewerFrame.setVisible(true);
            }
            UserInfoUtil.addTriggerListener((INpsTriggerListener)viewerFrame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return viewerFrame;
    }

    public void notifyTriggerPopUp() {
        npsDisplayThread npsDisplayThread2 = new npsDisplayThread(this);
        npsDisplayThread2.start();
    }

    public IOutputItem getCurrentItem() {
        ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
        if (viewerItem != null) {
            return viewerItem.getCoreItem();
        }
        return null;
    }

    public void setCurrentItem(IOutputItem iOutputItem, boolean bl) {
        if (bl) {
            this.mImpl.getDocument().setFocusedViewerItem((ViewerItem)iOutputItem.getUIAgent(), false);
        } else {
            this.mImpl.getDocument().setFocusedViewerItem(null);
        }
    }

    public IOutputItem convertToStdTable(IOutputItem iOutputItem) {
        ConvertLightTableAction convertLightTableAction = (ConvertLightTableAction)ActionCatalog.getActionCatalog().getSpssAction("edit_convert_table");
        return convertLightTableAction.doConversion(this, null, (LightTableItem)iOutputItem);
    }

    @Override
    public DocType docType() {
        return DocType.OUTPUT_DOC;
    }

    @Override
    public void setModified(boolean bl) {
        if (this.mImpl.getDocument().getCoreDocument() != null && bl != this.mImpl.getDocument().getCoreDocument().getModifiedFlag()) {
            this.mImpl.setModified(bl);
            this.updateToolbarEnableStatus();
        }
    }

    @Override
    public void setActivePane(IViewerWindow.PaneType paneType) {
        this.mActivePane = paneType;
        this.mImpl.setActivePane(paneType);
    }

    @Override
    public IViewerWindow.PaneType getActivePane() {
        return this.mActivePane;
    }

    @Override
    public MenuItemCache getMenuTreeCache() {
        return sMenuTreeCache;
    }

    @Override
    public void setMenuTreeCache(MenuCache menuCache) {
        sMenuTreeCache = menuCache;
        try {
            this.saveMenuBarPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        this.refreshMenuBar();
    }

    @Override
    public ICoreDocument getCoreDocument() {
        if (this.mImpl.getDocument() != null) {
            return this.mImpl.getDocument().getCoreDocument();
        }
        return null;
    }

    @Override
    public void setCoreDocument(IOutputDocument iOutputDocument) {
        this.mImpl.setCoreDocument(iOutputDocument);
        iOutputDocument.setUIAgent((ICoreDocumentUIAgent)this);
    }

    public void notifyDocumentLoadComplete() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerFrame.this.documentLoaded();
            }
        });
    }

    @Override
    public ViewerFindDlg getSearchDialog() {
        if (sSearchDialog == null) {
            sSearchDialog = new ViewerFindDlg(this, this.mImpl.getDocument(), this.hasNonLightTableSelected());
        } else if (sSearchDialog.getParent() != this) {
            sSearchDialog.dispose();
            sSearchDialog = new ViewerFindDlg(this, this.mImpl.getDocument(), this.hasNonLightTableSelected());
        } else {
            sSearchDialog.refreshTab(this.hasNonLightTableSelected());
        }
        return sSearchDialog;
    }

    @Override
    public void resetSearchDialog() {
        if (sSearchDialog != null) {
            sSearchDialog.dispose();
            sSearchDialog = null;
        }
    }

    public ViewerItem getEditedItem() {
        return this.mImpl.getOutputPane().getEditingItem();
    }

    @Override
    public JScrollPane getOutputScrollPane() {
        return this.mImpl.getOutputScrollPane();
    }

    public boolean getSelectionExpandState(boolean bl) {
        return this.mImpl.getViewerTreePane().getSelectionExpandState(bl);
    }

    @Override
    public void setSelectionExpandState(boolean bl) {
        this.mImpl.getViewerTreePane().setSelectionExpandState(bl);
    }

    @Override
    public ViewerTreePane getViewerTreePane() {
        return this.mImpl.getViewerTreePane();
    }

    @Override
    public SpssPrintable getPrintable() {
        boolean bl = false;
        this.mPrintOptions.setPrintMode(SpssPrintable.PrintMode.NORMAL);
        if (this.mPrintRange == null) {
            this.mPrintRange = OutputViewPrintable.PrintRange.eVISIBLE;
            bl = false;
        } else if (this.mPrintRange == OutputViewPrintable.PrintRange.eSELECTED) {
            bl = true;
        }
        IPageSetupInfo iPageSetupInfo = ((IOutputDocument)this.getCoreDocument()).getPageSetupInfo();
        if (iPageSetupInfo == null) {
            iPageSetupInfo = new PageSetupInfo();
            ((IOutputDocument)this.getCoreDocument()).setPageSetupInfo(iPageSetupInfo);
        }
        OutputViewPrintable outputViewPrintable = new OutputViewPrintable(this, this.mPrintOptions, this.mPrintRange, OutputViewPrintable.TableLayerPrintSetting.eHONOR_TABLE_SETTING);
        outputViewPrintable.setPrintSelection(bl);
        return outputViewPrintable;
    }

    @Override
    public int getCopyFormats() {
        return this.mImpl.getCopyFormats();
    }

    @Override
    public void setCopyFormats(int n) {
        this.mImpl.setCopyFormats(n);
    }

    public void setSavedCopyFormats(int n) {
        this.mImpl.setSavedCopyFormats(n);
    }

    @Override
    public void saveDefaultCopySpecialFormat(int n) {
        this.mImpl.saveDefaultCopySpecialFormat(n);
    }

    @Override
    public void doCopy() {
        this.mImpl.doCopy();
    }

    public boolean isCopyDone() {
        return this.mImpl.isSwingWorkerFinished();
    }

    @Override
    public void doPaste() {
        this.mImpl.doPaste();
    }

    @Override
    public void doPaste(DataFlavor dataFlavor) {
        this.mImpl.doPaste(dataFlavor);
    }

    @Override
    public void doCut() {
        this.mImpl.doCut();
    }

    @Override
    public void doDelete() {
        this.mImpl.doDelete();
    }

    @Override
    public void doGridFont() {
        this.changeFont(this.mImpl.getViewerTreePane().getViewerTree());
    }

    public void doPageBreaks(boolean bl) {
        this.mImpl.getDocument().setPageBreaksOnSelected(bl);
    }

    @Override
    public ViewerDocument getDocument() {
        return this.mImpl.getDocument();
    }

    @Override
    public ViewerDocument getViewerDocument() {
        return this.getDocument();
    }

    public void performCloseAllItems() {
        if (this.mImpl.getOutputPane() != null) {
            this.mImpl.getOutputPane().endAllEditors();
        }
    }

    @Override
    public void performClose() {
        Container container;
        boolean bl = false;
        if (this.mImpl.getDocument() != null) {
            if (!this.saveModified()) {
                return;
            }
            bl = this.mImpl.getDocument().isSearchWindowVisible(this);
            this.mImpl.performClose();
            if (this.mStatusBarPanel != null) {
                this.mStatusBarPanel.removeAll();
                container = this.mStatusBarPanel.getParent();
                if (container != null) {
                    container.remove(this.mStatusBarPanel);
                }
                this.mStatusBarPanel = null;
            }
        }
        this.saveFrameSize();
        this.terminateRenderingTasks();
        if (sSearchDialog != null && sSearchDialog.isVisible()) {
            sSearchDialog.setVisible(false);
            sSearchDialog.dispose();
            sSearchDialog = null;
            container = SpssFrameMgr.getSpssFrameMgr().getDesignatedFrame(DocType.OUTPUT_DOC);
            if (container instanceof ViewerFrame) {
                ViewerFrame viewerFrame = (ViewerFrame)container;
                viewerFrame.getSearchDialog().setVisible(true);
            }
        }
        this.setVisible(false);
        super.performClose();
        this.mImpl = null;
        this.dispose();
        if (bl) {
            SpssFrameMgr.getSpssFrameMgr().reparentSearchDialog(DocType.OUTPUT_DOC);
        }
    }

    @Override
    protected boolean canClose() {
        if (this.mModifyOutputDlg != null) {
            Toolkit.getDefaultToolkit().beep();
        }
        return this.mModifyOutputDlg == null;
    }

    @Override
    public boolean saveModified() {
        if (this.mImpl.getOutputPane() != null) {
            this.mImpl.getOutputPane().endAllEditors();
        }
        return this.mImpl.getDocument() == null || this.mImpl.getDocument().saveModified();
    }

    @Override
    public void saveFrameSize() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types").node("output");
        if (this.getExtendedState() == 6) {
            preferences2.putInt("viewer_height", -1);
            preferences2.putInt("viewer_width", -1);
        } else {
            Dimension dimension = this.getSize();
            preferences2.putInt("viewer_height", (int)dimension.getHeight());
            preferences2.putInt("viewer_width", (int)dimension.getWidth());
        }
    }

    @Override
    public void updateTitleBar() {
        if (this.mImpl != null) {
            this.mImpl.updateTitleBar();
        }
    }

    public ViewerTreePane.TreeImageSize getOutlineSize() {
        return this.mImpl.getViewerTreePane().getTreeImageSize();
    }

    public void setOutlineSize(ViewerTreePane.TreeImageSize treeImageSize) {
        this.mImpl.getViewerTreePane().setTreeImageSize(treeImageSize);
    }

    public boolean canShowSelections() {
        return this.mImpl.getViewerTreePane().canShowSelections();
    }

    public boolean canHideSelections() {
        return this.mImpl.getViewerTreePane().canHideSelections();
    }

    public void showSelections() {
        this.mImpl.getViewerTreePane().showSelections();
    }

    public void hideSelections() {
        this.mImpl.getViewerTreePane().hideSelections();
    }

    @Override
    public ViewerOutputPane getOutputPane() {
        return this.mImpl.getOutputPane();
    }

    @Override
    public ViewerOutputPaneDragAdapter getOutputPaneDragAdapter() {
        return this.mImpl.getOutputPaneDragAdapter();
    }

    @Override
    public Window getTopWindow() {
        return this;
    }

    @Override
    public void activateAndSelect(ViewerSearchOptions viewerSearchOptions, int n) {
        this.mImpl.activateAndSelect(viewerSearchOptions, n);
    }

    @Override
    public void replaceEditingTextSelection(ViewerSearchOptions viewerSearchOptions, String string) {
        this.mImpl.replaceEditingTextSelection(viewerSearchOptions, string);
    }

    @Override
    public boolean selectionIsSearchString(ViewerSearchOptions viewerSearchOptions, String string) {
        return this.mImpl.selectionIsSearchString(viewerSearchOptions, string);
    }

    @Override
    public String getOutlineTitle(ViewerItem viewerItem) {
        return this.mImpl.getOutlineTitle(viewerItem);
    }

    @Override
    public boolean canEdit(ViewerItem viewerItem) {
        return true;
    }

    @Override
    public void commitEdits(ViewerSearchOptions viewerSearchOptions) {
        this.mImpl.commitEdits(viewerSearchOptions);
    }

    @Override
    public void endInPlaceEdits() {
        this.mImpl.endInPlaceEdits();
    }

    public void doPdfExport(PDFDocumentExportOptions pDFDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport, IProgressUIAgent iProgressUIAgent) {
        this.doPdfExport(pDFDocumentExportOptions, string, objectToExport, iProgressUIAgent, false);
    }

    public void doPdfExport(PDFDocumentExportOptions pDFDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport, IProgressUIAgent iProgressUIAgent, boolean bl) {
        PdfExporter pdfExporter = new PdfExporter(pDFDocumentExportOptions, string, objectToExport, this, bl);
        pdfExporter.export(iProgressUIAgent);
    }

    public void doPptExport(PPTDocumentExportOptions pPTDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport) {
        PptExporter pptExporter = new PptExporter(pPTDocumentExportOptions, string, objectToExport, this);
        pptExporter.export();
    }

    public void doPptExport(PPTDocumentExportOptions pPTDocumentExportOptions, String string, IExportOptions.ObjectToExport objectToExport, IAutoscriptEvent iAutoscriptEvent) {
        PptExporter pptExporter = new PptExporter(pPTDocumentExportOptions, string, objectToExport, this);
        pptExporter.SetEventInfo(iAutoscriptEvent);
        pptExporter.export();
    }

    public long getSplitterPosition() {
        return this.mImpl.getViewerSplitPane().getDividerLocation();
    }

    public void setSplitterPosition(long l) throws IllegalArgumentException {
        if (l < 0L || l > (long)this.getWidth()) {
            throw new IllegalArgumentException();
        }
        this.mImpl.getViewerSplitPane().setDividerLocation((int)l);
    }

    public void selectAll() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        for (ViewerItem viewerItem : vector) {
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void deSelectAll() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        for (ViewerItem viewerItem : vector) {
            this.mImpl.getDocument().selectionChanged(viewerItem, false, false);
        }
    }

    public void selectAllTables() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            IOutputItem iOutputItem = viewerItem.getCoreItem();
            if (!(iOutputItem instanceof LightTableItem) && !(iOutputItem instanceof TableItem) || iOutputItem.getType() != OutputItemType.PIVOT) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllTablesEx() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.PIVOT) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllTitles() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.TITLE) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllCharts() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.CHART && viewerItem.getCoreItem().getType() != OutputItemType.GRAPHBOARD && viewerItem.getCoreItem().getType() != OutputItemType.IMAGE) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllText() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.TEXT) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllNotes() {
        this.mImpl.getDocument().selectAllNotes();
    }

    public void selectAllNotesEx() {
        this.mImpl.getDocument().selectAllNotesEx();
    }

    public void selectAllLogs() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.LOG) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllWarnings() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            IOutputItem iOutputItem = viewerItem.getCoreItem();
            if (!(iOutputItem instanceof LightTableItem) && !(iOutputItem instanceof TableItem) || iOutputItem.getType() != OutputItemType.WARNING) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllWarningsEx() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.WARNING) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllModels() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.MODEL) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    public void selectAllOther() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        Vector<ViewerItem> vector2 = new Vector<ViewerItem>();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem object : vector) {
            if (object.getCoreItem().getType() != OutputItemType.GENERIC) continue;
            vector2.add(object);
        }
        int n = 0;
        do {
            if (n != 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            for (ViewerItem viewerItem : vector2) {
                this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
            }
        } while (!this.isAllSelected(vector2) && n++ < vector.size());
    }

    private boolean isAllSelected(Vector<ViewerItem> vector) {
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.isSelected()) continue;
            return false;
        }
        return true;
    }

    public void selectLastOutput() {
        ViewerFrame viewerFrame = this;
        SelectSpssTreeNodes selectSpssTreeNodes = new SelectSpssTreeNodes(viewerFrame);
        selectSpssTreeNodes.selectLastOutput();
    }

    public void selectAllPageTitles() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        this.mImpl.getDocument().deselectHeaderNodes();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() != OutputItemType.PAGETITLE) continue;
            this.mImpl.getDocument().selectionChanged(viewerItem, true, true);
        }
    }

    @Override
    public void selectChildNodesOf(HeaderViewerItem headerViewerItem) {
        this.mImpl.selectChildNodesOf(headerViewerItem);
    }

    @Override
    public void setSelected(IOutputItem iOutputItem, boolean bl) {
        this.mImpl.setSelected(iOutputItem, bl);
    }

    public void clearSelection() {
        this.mImpl.getDocument().deselectHeaderNodes();
    }

    public void copy() {
        this.mImpl.doSimpleCopy();
    }

    public void cut() {
        this.mImpl.doSimpleCut();
    }

    public void delete() {
        this.doDelete();
    }

    public void remove() {
        this.doDelete();
    }

    public void pasteAfter() {
        this.doPaste();
    }

    public void pasteBefore() {
        ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        if (viewerItem == null) {
            return;
        }
        IOutputItem iOutputItem = viewerItem.getCoreItem();
        HeaderItem headerItem = (HeaderItem)iOutputItem.getParentItem();
        HeaderItem headerItem2 = null;
        int n = headerItem.getChildCount();
        IOutputItem iOutputItem2 = null;
        for (int i = 0; i < n; ++i) {
            IOutputItem iOutputItem3 = headerItem.getChildItem(i);
            if (iOutputItem.equals(iOutputItem3) && iOutputItem2 == null) {
                headerItem2 = headerItem;
                break;
            }
            if (iOutputItem.equals(iOutputItem3) && iOutputItem2 != null) {
                headerItem2 = iOutputItem2;
                break;
            }
            iOutputItem2 = iOutputItem3;
        }
        for (ViewerItem viewerItem2 : vector) {
            if (!viewerItem2.getCoreItem().equals(headerItem2)) continue;
            this.mImpl.getDocument().setFocusedViewerItem(viewerItem2);
            this.mImpl.getDocument().selectionChanged(viewerItem2, true, false);
            this.doPaste();
            break;
        }
    }

    public void clearDataLinkState() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        for (ViewerItem viewerItem : vector) {
            if (!(viewerItem instanceof ChartViewerItem)) continue;
            ((ChartViewerItem)viewerItem).clearDataLinkState();
        }
    }

    public void undo() {
        this.getUndoManager().undo();
    }

    public IOutputItem InsertHeading(String string) {
        JComponent jComponent;
        Object object;
        Object object2;
        Object object3;
        HeaderItem headerItem = new HeaderItem();
        headerItem.setDescription(string);
        IOutputDocument iOutputDocument = this.mImpl.getDocument().getCoreDocument();
        ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
        if (viewerItem != null) {
            object3 = viewerItem.getCoreItem();
            if (object3 instanceof HeaderItem) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                boolean bl;
                object2 = (HeaderItem)object3;
                object = this.getViewerTreePane();
                jComponent = ((ViewerTreePane)object).getViewerTree();
                boolean bl2 = bl = ((JTree)jComponent).isExpanded(new TreePath((defaultMutableTreeNode = ((ViewerTreePane)object).findNode((DefaultMutableTreeNode)((JTree)jComponent).getModel().getRoot(), (IOutputItem)object2)).getPath())) || defaultMutableTreeNode.getChildCount() == 0;
                if (bl) {
                    iOutputDocument.insertItem((IOutputItem)headerItem, (IOutputItem)object2);
                } else {
                    iOutputDocument.insertItem((IOutputItem)headerItem, (IOutputItem)object3, true);
                }
            } else {
                iOutputDocument.insertItem((IOutputItem)headerItem, (IOutputItem)object3);
            }
        } else {
            iOutputDocument.insertItem((IOutputItem)headerItem, null);
        }
        object3 = this.mImpl.getDocument().getViewerItems();
        object2 = null;
        object = ((Vector)object3).iterator();
        while (object.hasNext()) {
            jComponent = (ViewerItem)object.next();
            if (!headerItem.equals(((ViewerItem)jComponent).getCoreItem())) continue;
            object2 = jComponent;
            break;
        }
        if (object2 != null) {
            this.mImpl.getDocument().setFocusedViewerItem((ViewerItem)object2);
            this.mImpl.getDocument().selectionChanged((ViewerItem)object2, true, false);
        }
        return headerItem;
    }

    public IOutputItem InsertTable(String string, int n, int n2, int n3) {
        if (string == null) {
            string = "";
        }
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        OutputItem outputItem = null;
        try {
            Object object;
            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            Preferences preferences2 = preferences.node("tables");
            String string2 = preferences2.get("table_render", "light");
            outputItem = string2.equalsIgnoreCase("full") ? this.createVETable(string, n, n2, n3) : this.createFTable(string, n, n2, n3);
            outputItem.setDescription(string);
            IOutputDocument iOutputDocument = this.mImpl.getDocument().getCoreDocument();
            ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
            if (viewerItem != null) {
                object = viewerItem.getCoreItem();
                iOutputDocument.insertItem((IOutputItem)outputItem, (IOutputItem)object);
            } else {
                iOutputDocument.insertItem((IOutputItem)outputItem, null);
            }
            object = this.mImpl.getDocument().getViewerItems();
            ViewerItem viewerItem2 = null;
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                ViewerItem viewerItem3 = (ViewerItem)iterator.next();
                if (!outputItem.equals(viewerItem3.getCoreItem())) continue;
                viewerItem2 = viewerItem3;
                break;
            }
            if (viewerItem2 != null) {
                this.mImpl.getDocument().setFocusedViewerItem(viewerItem2);
                this.mImpl.getDocument().selectionChanged(viewerItem2, true, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return outputItem;
    }

    private OutputItem createVETable(String string, int n, int n2, int n3) {
        TableItem tableItem = new TableItem();
        String string2 = n3 == 0 ? this.readXMLFromURL(ViewerFrame.class.getResource(ResUtil.getString("IDS_INSERT_TABLE_2D_XML"))) : this.readXMLFromURL(ViewerFrame.class.getResource(ResUtil.getString("IDS_INSERT_TABLE_3D_XML")));
        try {
            if (string2 != null) {
                string2 = this.generateXMLForInsertTable(string2, string, n, n2, n3);
                ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(string2.getBytes("UTF-8")));
                tableItem.setCompressedXML(byteBuffer);
                tableItem.setVDPData(null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return tableItem;
    }

    private OutputItem createFTable(String string, int n, int n2, int n3) {
        int n4;
        int n5;
        Object object;
        String string2;
        int n6;
        LightTableItem lightTableItem = new LightTableItem(OutputItemType.PIVOT);
        long l = n3 > 0 ? PivotTable.CreateTable((String)string, (int)1, (int)1, (int)1) : PivotTable.CreateTable((String)string, (int)0, (int)1, (int)1);
        long l2 = Long.reverse(l);
        lightTableItem.setTableId(l2);
        BPFactory.get().addTableListener(l2, (LightTableListener)lightTableItem);
        String string3 = ResUtil.getString("IDS_INSERT_TABLE_ROW_CATEGORY_PREFIX");
        String string4 = ResUtil.getString("IDS_INSERT_TABLE_COLUMN_CATEGORY_PREFIX");
        String string5 = "Layer";
        if (n3 > 0) {
            for (n6 = 0; n6 < n3; ++n6) {
                string2 = string5 + " " + String.valueOf(n6 + 1);
                PivotTable.AppendCategory((long)l, (int)0, (int)0, (int)n6, (String)string2, (double)0.0, (long)0L);
            }
        }
        for (n6 = 0; n6 < n; ++n6) {
            string2 = string3 + " " + String.valueOf(n6 + 1);
            PivotTable.AppendCategory((long)l, (int)1, (int)0, (int)n6, (String)string2, (double)0.0, (long)0L);
        }
        for (n6 = 0; n6 < n2; ++n6) {
            string2 = string4 + " " + String.valueOf(n6 + 1);
            PivotTable.AppendCategory((long)l, (int)2, (int)0, (int)n6, (String)string2, (double)0.0, (long)0L);
        }
        if (n3 > 0) {
            object = new int[3];
            for (n5 = 0; n5 < n3; ++n5) {
                object[0] = n5;
                for (n4 = 0; n4 < n; ++n4) {
                    object[1] = n4;
                    int n7 = 0;
                    while (n7 < n2) {
                        object[2] = n7++;
                        PivotTable.AddCell((long)l, (int[])object, (String)".", (double)0.0, (long)0L);
                    }
                }
            }
        } else {
            object = new int[2];
            for (n5 = 0; n5 < n; ++n5) {
                object[0] = n5;
                n4 = 0;
                while (n4 < n2) {
                    object[1] = n4++;
                    PivotTable.AddCell((long)l, (int[])object, (String)".", (double)0.0, (long)0L);
                }
            }
        }
        lightTableItem.tableComplete(l2, l, true);
        object = lightTableItem.getLightPivotTable();
        TableLayer tableLayer = object.getCurrentLayer();
        long l3 = tableLayer.getRowHeadingHandle();
        long l4 = tableLayer.getColumnHeadingHandle();
        DisplayHeadings.RowHeadingSetDimensionLabelVisible((long)l3, (int)0, (boolean)false);
        DisplayHeadings.ColumnHeadingSetDimensionLabelVisible((long)l4, (int)0, (boolean)false);
        lightTableItem.tableComplete(l2, l, true);
        return lightTableItem;
    }

    @Override
    public void enablePromoteDemoteAction() {
        SpssAction spssAction;
        SpssAction spssAction2 = this.getToolbarAction(new ToolbarItem("edit_outline_promote", false, null, false), true);
        if (spssAction2 != null) {
            if (CommandLine.isRunSyntax()) {
                spssAction2.setEnabled(false);
            } else {
                spssAction2.setEnabled(spssAction2.getMenuItemEnableStatus(this));
            }
        }
        if ((spssAction = this.getToolbarAction(new ToolbarItem("edit_outline_demote", false, null, false), true)) != null) {
            if (CommandLine.isRunSyntax()) {
                spssAction.setEnabled(false);
            } else {
                spssAction.setEnabled(spssAction.getMenuItemEnableStatus(this));
            }
        }
    }

    public void changeFont(JTree jTree) {
        int n;
        int n2;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/output");
        String string = preferences2.get("font_family", PrefDefaults.DEF_VIEWER_FONT_FAMILY);
        SPSSFontChooser sPSSFontChooser = new SPSSFontChooser(this, true, string, n2 = preferences2.getInt("font_style", 0), n = jTree.getFont().getSize(), false);
        if (sPSSFontChooser.getReturnValue() == 0) {
            Font font = sPSSFontChooser.getSelectedFont();
            jTree.setFont(font.deriveFont((float)n));
            preferences2.put("font_family", font.getFamily(ResUtil.getLocale()));
            preferences2.putInt("font_style", font.getStyle());
        }
    }

    @Override
    public void gotoTableRows(TableViewerItem.TableSection tableSection) {
        this.mImpl.gotoTableRows(tableSection);
    }

    @Override
    public boolean isNavigateEnabled(TableViewerItem.TableSection tableSection) {
        return this.mImpl.isNavigateEnabled(tableSection);
    }

    @Override
    protected boolean doActivate() {
        return true;
    }

    public ViewerFrame() throws HeadlessException {
        super(String.format(ComponentState.getSPSSLocale(), ResUtil.getString("IDS_SPSS_OUTPUT_VIEWER"), VersionInfo.getProductNickName()), "output");
        WindowUtil.setMacWindowCanFullScreen((Window)this, (boolean)true);
        this.mImpl = new ViewerPanel(this);
        this.getContentPane().add((Component)this.mImpl, "Center");
        this.mImpl.init();
        this.setupMenuRadioGroup();
        this.setDefaultCloseOperation(0);
        if (this.getDocument().getCoreDocument() != null) {
            PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
            Paper paper = PageSetupUtil.getPaper(this, pageFormat.getPaper());
            pageFormat.setPaper(paper);
            PrintOptions printOptions = PrintOptions.getInstance();
            printOptions.setPageFormat(pageFormat);
        }
        this.pack();
        this.mImpl.getOutputPane().requestFocus();
    }

    private void setupMenuRadioGroup() {
        if (CommandLine.isExternalCaller()) {
            return;
        }
        ViewerTreePane.TreeImageSize treeImageSize = this.getOutlineSize();
        JMenu jMenu = this.mMainMenuBar.getMenu(2);
        if (jMenu == null) {
            return;
        }
        Action action = jMenu.getAction();
        if (action instanceof SpssAction && ((SpssAction)action).getActionId().equals("View")) {
            for (Component component : jMenu.getMenuComponents()) {
                JMenu jMenu2;
                SpssAction spssAction;
                if (!(component instanceof JMenu) || !(((JMenu)component).getAction() instanceof SpssAction) || !(spssAction = (SpssAction)(jMenu2 = (JMenu)component).getAction()).getActionId().equals("view_outline_size")) continue;
                ButtonGroup buttonGroup = new ButtonGroup();
                for (int i = 0; i < jMenu2.getItemCount(); ++i) {
                    JMenuItem jMenuItem = jMenu2.getItem(i);
                    String string = ((SpssAction)jMenuItem.getAction()).getActionId();
                    if (treeImageSize == ViewerTreePane.TreeImageSize.small && string.equals("view_outline_size_small") || treeImageSize == ViewerTreePane.TreeImageSize.medium && string.equals("view_outline_size_medium") || treeImageSize == ViewerTreePane.TreeImageSize.large && string.equals("view_outline_size_large")) {
                        jMenuItem.setSelected(true);
                    }
                    buttonGroup.add(jMenuItem);
                }
                break;
            }
        }
    }

    @Override
    protected void buildMenuBar() {
        try {
            Preferences preferences;
            String string;
            Preferences preferences2 = PrefsMgr.getPrefsMgr().getUIUserPrefs();
            if (preferences2.nodeExists(this.mRootMenuPrefPath + "/0;File") && (string = (preferences = preferences2.node(this.mRootMenuPrefPath + "/0;File")).get("14", "")).equals("file_cache_data")) {
                Preferences preferences3 = preferences2.node(this.mRootMenuPrefPath);
                preferences3.removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        super.buildMenuBar();
    }

    @Override
    protected void saveMenuBarDefaultPreferences() throws BackingStoreException {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(this.mRootMenuPrefPath);
        preferences2.removeNode();
        preferences2 = preferences.node(this.mRootMenuPrefPath);
        Preferences preferences3 = PrefsMgr.getPrefsMgr().getUISystemPrefs();
        Preferences preferences4 = null;
        if (preferences3 != null && preferences3.nodeExists(this.mRootMenuPrefPath)) {
            preferences4 = preferences3.node(this.mRootMenuPrefPath);
        }
        Preferences preferences5 = preferences2.node("0;File");
        MenuMgr.saveOutputFileMenuDefaultPreferences(preferences5);
        Preferences preferences6 = preferences2.node("1;Edit");
        MenuMgr.saveOutputEditDefaultPreferences(preferences6);
        Preferences preferences7 = preferences2.node("2;View");
        MenuMgr.saveOutputViewDefaultPreferences(preferences7);
        Preferences preferences8 = preferences2.node("3;Data");
        MenuMgr.saveViewerDataMenuDefaultPreferences(preferences8);
        Preferences preferences9 = preferences2.node("4;Transform");
        MenuMgr.saveTransformDefaultPreferences(preferences9);
        Preferences preferences10 = preferences2.node("5;Insert");
        MenuMgr.saveInsertDefaultPreferences(preferences10);
        Preferences preferences11 = preferences2.node("6;Format");
        MenuMgr.saveFormatDefaultPreferences(preferences11);
        Preferences preferences12 = preferences2.node("7;Analyze");
        this.copyMenuItemFromInstaller(preferences4, preferences12, "7;Analyze");
        MenuMgr.saveAnalyzeDefaultPreferences(preferences12);
        Preferences preferences13 = preferences2.node("9;Graphs");
        MenuMgr.saveGraphsDefaultPreferences(preferences13);
        Preferences preferences14 = preferences2.node("10;Utilities");
        MenuMgr.saveViewerUtilitiesDefaultPreferences(preferences14);
        Preferences preferences15 = preferences2.node("12;Extensions");
        MenuMgr.saveExtensionPreferences(preferences15);
        Preferences preferences16 = preferences2.node("13;Window");
        MenuMgr.saveOutputWindowDefaultPreferences(preferences16);
        Preferences preferences17 = preferences2.node("14;Help");
        this.copyMenuItemFromInstaller(preferences4, preferences17, "15;Help");
        MenuMgr.saveHelpDefaultPreferences(preferences17);
        String string = "doc_types/output/menus_edit";
        Preferences preferences18 = preferences.node(string);
        preferences18.removeNode();
        preferences18 = preferences.node(string);
        Preferences preferences19 = preferences18.node("0;File");
        MenuMgr.saveOutputEditingFileMenuDefaultPreferences(preferences19);
    }

    @Override
    protected void setupStatusBar() {
        this.mStatusBarPanel = new ViewerStatusBar();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.objectSizePane, "       ");
        this.mStatusBarPanel.putPaneMessage(StatusBar.StatusPane.helpPane, "      ");
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private String generateXMLForInsertTable(String string, String string2, int n, int n2, int n3) {
        int n4;
        int n5;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = ResUtil.getString("IDS_INSERT_TABLE_ROW_CATEGORY_PREFIX");
        String string4 = ResUtil.getString("IDS_INSERT_TABLE_COLUMN_CATEGORY_PREFIX");
        String string5 = ResUtil.getString("IDS_INSERT_TABLE_LAYER_CATEGORY_PREFIX");
        stringBuffer.append("<embeddedSource id=\"tableData\">");
        if (n3 == 0) {
            stringBuffer.append("<names>cell;rowDimensionCategories;columnDimensionCategories</names>");
            stringBuffer.append("<types>string;string;string</types>");
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    stringBuffer.append("<row>");
                    stringBuffer.append(".;");
                    stringBuffer.append(n4);
                    stringBuffer.append(";");
                    stringBuffer.append(n5);
                    stringBuffer.append("</row>");
                }
            }
        } else {
            stringBuffer.append("<names>cell;rowDimensionCategories;columnDimensionCategories;layerDimensionCategories</names>");
            stringBuffer.append("<types>string;string;string;string</types>");
            for (n5 = 0; n5 < n3; ++n5) {
                for (n4 = 0; n4 < n2; ++n4) {
                    for (int i = 0; i < n; ++i) {
                        stringBuffer.append("<row>");
                        stringBuffer.append(".;");
                        stringBuffer.append(i);
                        stringBuffer.append(";");
                        stringBuffer.append(n4);
                        stringBuffer.append(";");
                        stringBuffer.append(n5);
                        stringBuffer.append("</row>");
                    }
                }
            }
        }
        stringBuffer.append("</embeddedSource>");
        String string6 = string.replaceFirst("<embeddedSource></embeddedSource>", stringBuffer.toString());
        if (n3 > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("<format>");
            for (n5 = 0; n5 < n3; ++n5) {
                stringBuffer.append("<relabel from=\"");
                stringBuffer.append(n5);
                stringBuffer.append("\" to=\"");
                stringBuffer.append(string5);
                stringBuffer.append(" ");
                stringBuffer.append(n5 + 1);
                stringBuffer.append("\" />");
            }
            stringBuffer.append("</format>");
            string6 = string6.replaceFirst("<format>layer</format>", stringBuffer.toString());
        }
        if (n > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("<format>");
            for (n5 = 0; n5 < n; ++n5) {
                stringBuffer.append("<relabel from=\"");
                stringBuffer.append(n5);
                stringBuffer.append("\" to=\"");
                stringBuffer.append(string3);
                stringBuffer.append(" ");
                stringBuffer.append(n5 + 1);
                stringBuffer.append("\" />");
            }
            stringBuffer.append("</format>");
            string6 = string6.replaceFirst("<format>row</format>", stringBuffer.toString());
        }
        if (n2 > 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("<format>");
            for (n5 = 0; n5 < n2; ++n5) {
                stringBuffer.append("<relabel from=\"");
                stringBuffer.append(n5);
                stringBuffer.append("\" to=\"");
                stringBuffer.append(string4);
                stringBuffer.append(" ");
                stringBuffer.append(n5 + 1);
                stringBuffer.append("\" />");
            }
            stringBuffer.append("</format>");
            string6 = string6.replaceFirst("<format>column</format>", stringBuffer.toString());
        }
        string6 = string6.replaceFirst("Table Title", string2);
        return string6;
    }

    private String readXMLFromURL(URL uRL) {
        String string = null;
        try {
            InputStream inputStream = uRL.openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            while (string2 != null) {
                stringBuffer.append(string2);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public IOutputItem InsertTitle(String string, String string2) {
        JComponent jComponent;
        Object object;
        Object object2;
        Object object3;
        TitleItem titleItem = new TitleItem();
        titleItem.setDescription(string);
        ((TextItem)titleItem).setContents(string2);
        IOutputDocument iOutputDocument = this.mImpl.getDocument().getCoreDocument();
        ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
        if (viewerItem != null) {
            object3 = viewerItem.getCoreItem();
            if (object3 instanceof TitleItem) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                boolean bl;
                object2 = (TitleItem)object3;
                object = this.getViewerTreePane();
                jComponent = ((ViewerTreePane)object).getViewerTree();
                boolean bl2 = bl = ((JTree)jComponent).isExpanded(new TreePath((defaultMutableTreeNode = ((ViewerTreePane)object).findNode((DefaultMutableTreeNode)((JTree)jComponent).getModel().getRoot(), (IOutputItem)object2)).getPath())) || defaultMutableTreeNode.getChildCount() == 0;
                if (bl) {
                    iOutputDocument.insertItem((IOutputItem)titleItem, (IOutputItem)object2);
                } else {
                    iOutputDocument.insertItem((IOutputItem)titleItem, (IOutputItem)object3, true);
                }
            } else {
                iOutputDocument.insertItem((IOutputItem)titleItem, (IOutputItem)object3);
            }
        } else {
            iOutputDocument.insertItem((IOutputItem)titleItem, null);
        }
        object3 = this.mImpl.getDocument().getViewerItems();
        object2 = null;
        object = ((Vector)object3).iterator();
        while (object.hasNext()) {
            jComponent = (ViewerItem)object.next();
            if (!titleItem.equals(((ViewerItem)jComponent).getCoreItem())) continue;
            object2 = jComponent;
            break;
        }
        if (object2 != null) {
            this.mImpl.getDocument().setFocusedViewerItem((ViewerItem)object2);
            this.mImpl.getDocument().selectionChanged((ViewerItem)object2, true, false);
        }
        return titleItem;
    }

    public IOutputItem InsertPageTitle(String string, String string2) {
        JComponent jComponent;
        Object object;
        Object object2;
        Object object3;
        PageTitleItem pageTitleItem = new PageTitleItem();
        pageTitleItem.setDescription(string);
        pageTitleItem.setContents(string2);
        IOutputDocument iOutputDocument = this.mImpl.getDocument().getCoreDocument();
        ViewerItem viewerItem = this.mImpl.getDocument().getFocusedViewerItem();
        if (viewerItem != null) {
            object3 = viewerItem.getCoreItem();
            if (object3 instanceof PageTitleItem) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                boolean bl;
                object2 = (PageTitleItem)object3;
                object = this.getViewerTreePane();
                jComponent = ((ViewerTreePane)object).getViewerTree();
                boolean bl2 = bl = ((JTree)jComponent).isExpanded(new TreePath((defaultMutableTreeNode = ((ViewerTreePane)object).findNode((DefaultMutableTreeNode)((JTree)jComponent).getModel().getRoot(), (IOutputItem)object2)).getPath())) || defaultMutableTreeNode.getChildCount() == 0;
                if (bl) {
                    iOutputDocument.insertItem((IOutputItem)pageTitleItem, (IOutputItem)object2);
                } else {
                    iOutputDocument.insertItem((IOutputItem)pageTitleItem, (IOutputItem)object3, true);
                }
            } else {
                iOutputDocument.insertItem((IOutputItem)pageTitleItem, (IOutputItem)object3);
            }
        } else {
            iOutputDocument.insertItem((IOutputItem)pageTitleItem, null);
        }
        object3 = this.mImpl.getDocument().getViewerItems();
        object2 = null;
        object = ((Vector)object3).iterator();
        while (object.hasNext()) {
            jComponent = (ViewerItem)object.next();
            if (!pageTitleItem.equals(((ViewerItem)jComponent).getCoreItem())) continue;
            object2 = jComponent;
            break;
        }
        if (object2 != null) {
            this.mImpl.getDocument().setFocusedViewerItem((ViewerItem)object2);
            this.mImpl.getDocument().selectionChanged((ViewerItem)object2, true, false);
        }
        return pageTitleItem;
    }

    public void Promote() {
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("edit_outline_promote");
        JPanel jPanel = super.getToolBarPanel();
        ActionEvent actionEvent = new ActionEvent(jPanel, 1001, spssAction.getActionId());
        if (spssAction.getMenuItemEnableStatus(this)) {
            spssAction.actionPerformed(actionEvent);
        }
    }

    public void Demote() {
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction("edit_outline_demote");
        JPanel jPanel = super.getToolBarPanel();
        ActionEvent actionEvent = new ActionEvent(jPanel, 1001, spssAction.getActionId());
        if (spssAction.getMenuItemEnableStatus(this)) {
            spssAction.actionPerformed(actionEvent);
        }
    }

    public void setVisible(IOutputItem iOutputItem) {
        this.mImpl.getViewerTreePane().setVisible((ViewerItem)iOutputItem.getUIAgent());
    }

    public boolean setPrintRange(long l) {
        boolean bl;
        switch ((int)l) {
            case 0: {
                bl = this.isAnythingVisibleToPrint();
                if (bl) {
                    this.mPrintRange = OutputViewPrintable.PrintRange.eALL;
                }
                bl = true;
                break;
            }
            case 1: {
                bl = this.isAnythingSelectedToPrint();
                if (bl) {
                    this.mPrintRange = OutputViewPrintable.PrintRange.eSELECTED;
                }
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public void closeDocument() {
        this.performClose();
    }

    @Override
    public void setExpanded(int n, boolean bl) {
        this.mImpl.setExpanded(n, bl);
    }

    @Override
    public boolean getExpanded(int n) {
        return this.mImpl.getExpanded(n);
    }

    protected void documentLoaded() {
        this.validate();
        this.setCursor(null);
        if (this.mImpl != null && this.mImpl.getOutputPane() != null) {
            this.mImpl.getOutputPane().requestFocus();
        }
    }

    private void terminateRenderingTasks() {
        if (this.mImpl != null && this.mImpl.getDocument() == null) {
            return;
        }
        ImageGenerator2.getImageGenerator().stopThread();
    }

    private boolean isAnythingVisibleToPrint() {
        return this.mImpl.getDocument().getViewerItems().size() != 0;
    }

    private boolean isAnythingSelectedToPrint() {
        Vector<ViewerItem> vector = this.mImpl.getDocument().getViewerItems();
        for (ViewerItem viewerItem : vector) {
            if (viewerItem.getCoreItem().getType() == OutputItemType.HEAD || !viewerItem.getCoreItem().isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addDeletedAddOnItem(String string) {
        sDeletedAddOnItems.add(string);
    }

    @Override
    protected Vector<String> getDeletedAddOnItem() {
        return sDeletedAddOnItems;
    }

    @Override
    public void clearDeletedAddOnItems() {
        sDeletedAddOnItems.removeAllElements();
    }

    public void updateTreePaneForItem(IOutputItem iOutputItem) {
        if (iOutputItem == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.mImpl.getViewerTreePane().findNode((DefaultMutableTreeNode)this.mImpl.getViewerTreePane().getViewerTree().getModel().getRoot(), iOutputItem);
        if (defaultMutableTreeNode == null) {
            return;
        }
        String string = iOutputItem.getDescription();
        iOutputItem.setDescription("");
        TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
        this.mImpl.getViewerTreePane().setOutlineText(treePath, string);
    }

    @Override
    public boolean saveCoreDocument() {
        return DocUtil.saveCoreDocument(this);
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            this.updateStatusBarHelpText(jMenu);
        }
        if (!(jMenu.getAction() instanceof UserMenuAction) && jMenu.getAction() != null) {
            String string;
            if (jMenu.getAction() instanceof SpssAction) {
                String string2 = ((SpssAction)jMenu.getAction()).getActionId();
                if ("View".equals(string2)) {
                    this.refreshMenuCheckStatus(jMenu);
                    this.refreshMenuText(jMenu);
                } else if ("Window".equals(string2)) {
                    this.updateWindowMenuDocuments(jMenu);
                    this.refreshMenuCheckStatus(jMenu);
                    this.refreshMenuText(jMenu);
                } else if ("file_MRUD".equals(string2)) {
                    this.updateDataMRUMenu(jMenu);
                } else if ("run_active_dataset".equals(string2)) {
                    this.updateActiveDatasetMenu(jMenu);
                } else if ("file_MRUF".equals(string2)) {
                    this.updateFileMRUMenu(jMenu);
                } else if ("File".equals(string2)) {
                    this.refreshMenuText(jMenu);
                } else if ("Tools".equals(string2)) {
                    this.refreshMenuCheckStatus(jMenu);
                    this.refreshMenuText(jMenu);
                } else if ("syntax_goto_bookmark".equals(string2)) {
                    this.updateSyntaxGotoBookmarkMenu(jMenu);
                } else if ("Format".equals(string2)) {
                    this.refreshMenuCheckStatus(jMenu);
                    this.refreshMenuText(jMenu);
                }
            } else if (jMenu.getAction() instanceof BaseTextAction && ("View".equals(string = ((BaseTextAction)jMenu.getAction()).getActionId()) || "Format".equals(string))) {
                this.refreshTextEditorMenuEnableStatus(jMenu);
                this.refreshTextEditorMenuCheckStatus(jMenu);
            }
        }
        this.updateMenuEnableStatus(jMenu);
    }

    private void refreshTextEditorMenuEnableStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        if (!(this.getEditedItem() instanceof TextViewerItem)) {
            return;
        }
        TextEditorFrame textEditorFrame = ((TextViewerItem)this.getEditedItem()).getTextFrame();
        if (textEditorFrame == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            BaseTextAction baseTextAction = (BaseTextAction)jMenuItem.getAction();
            jMenuItem.setEnabled(baseTextAction.getMenuItemEnableStatus(textEditorFrame));
        }
    }

    private void refreshTextEditorMenuCheckStatus(JMenu jMenu) {
        int n = jMenu.getItemCount();
        if (!(this.getEditedItem() instanceof TextViewerItem)) {
            return;
        }
        TextEditorFrame textEditorFrame = ((TextViewerItem)this.getEditedItem()).getTextFrame();
        if (textEditorFrame == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            BaseTextAction baseTextAction;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)jMenuItem2;
                baseTextAction = (BaseTextAction)jMenuItem2.getAction();
                ((JCheckBoxMenuItem)jMenuItem).setState(baseTextAction.getMenuItemCheckStatus(textEditorFrame));
                continue;
            }
            if (!(jMenuItem2 instanceof JRadioButtonMenuItem)) continue;
            jMenuItem = (JRadioButtonMenuItem)jMenuItem2;
            baseTextAction = (BaseTextAction)jMenuItem2.getAction();
            jMenuItem.setSelected(baseTextAction.getMenuItemCheckStatus(textEditorFrame));
        }
    }

    private boolean hasNonLightTableSelected() {
        ViewerDocument viewerDocument = this.mImpl.getDocument();
        Vector<ViewerItem> vector = viewerDocument.getViewerItems();
        int n = viewerDocument.getSelectedItemCount(true);
        if (n == 0) {
            for (ViewerItem viewerItem : vector) {
                if (viewerItem instanceof LightTableViewerItem) continue;
                return true;
            }
        }
        for (ViewerItem viewerItem : vector) {
            if (!viewerItem.isSelected() || viewerItem instanceof LightTableViewerItem) continue;
            return true;
        }
        return false;
    }

    public void launchModifyOutputDialog() {
        if (this.mModifyOutputDlg == null) {
            this.mModifyOutputDlg = new ModifyOutputDlg(this, true, new ModifyOutputDlg.ModifyOutputCallback(){

                @Override
                public void processDialogClosing() {
                    ViewerFrame.this.processModifyOutputDialogClosed();
                }
            });
            this.addModifyOutputWindowListener();
            SpssFrameMgr.getSpssFrameMgr().disableAllFramesButThis(DocType.OUTPUT_DOC);
            this.updateToolbarEnableStatus();
            this.mImpl.enableDragDrop(false);
            Toolkit.getDefaultToolkit().addAWTEventListener(this.mKeyHandler, 8L);
        }
    }

    @Override
    public void minimized(boolean bl) {
        if (bl) {
            this.setState(1);
        } else {
            this.setState(0);
        }
    }

    private void addModifyOutputWindowListener() {
        this.mModifyOutputDlg.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ViewerFrame.this.processModifyOutputDialogClosed();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ViewerFrame.this.processModifyOutputDialogClosed();
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
    }

    @Override
    public void updateToolbarEnableStatus() {
        if (this.mModifyOutputDlg == null) {
            super.updateToolbarEnableStatus();
        } else if (SwingUtilities.isEventDispatchThread()) {
            try {
                this.disableAllToolbarItems();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewerFrame.this.disableAllToolbarItems();
                }
            });
        }
    }

    public void processModifyOutputDialogClosed() {
        this.mModifyOutputDlg = null;
        SpssFrameMgr.getSpssFrameMgr().enableAllFrames();
        this.updateToolbarEnableStatus();
        if (this.mImpl != null) {
            this.mImpl.enableDragDrop(true);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mKeyHandler);
    }

    public boolean isOuputModifyDialogActive() {
        return this.mModifyOutputDlg != null;
    }

    public void requestFousToModifyOutput() {
        if (this.mModifyOutputDlg != null) {
            this.mModifyOutputDlg.forceFocus();
        }
    }

    @Override
    public ViewerPanel getViewerPanel() {
        return this.mImpl;
    }

    @Override
    public IViewerWindow getIViewerWindow() {
        return this;
    }

    public boolean canExecuteASL() {
        return true;
    }

    public boolean executeASL(JSONObject jSONObject, Vector<JSONObject> vector) {
        boolean bl;
        ASMapsError aSMapsError = null;
        Vector vector2 = new Vector();
        String string = (String)BasicFactory.getItem((Object)jSONObject, (String)"messageId");
        if (string.equals("GetImpactDiagram")) {
            Object object;
            Object object2;
            String string2 = (String)BasicFactory.getItem((Object)jSONObject, (String)"modelFilePath");
            String string3 = (String)BasicFactory.getItem((Object)jSONObject, (String)"metricVar");
            JSONArray jSONArray = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"dimFields");
            Vector<String> vector3 = new Vector<String>();
            for (int i = 0; i < jSONArray.size(); ++i) {
                object2 = (JSONObject)BasicFactory.getArrayItem((JSONArray)jSONArray, (int)i);
                vector3.add((String)BasicFactory.getItem((Object)object2, (String)"field"));
            }
            JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem((Object)jSONObject, (String)"dimValues");
            object2 = new Vector();
            for (int i = 0; i < jSONArray2.size(); ++i) {
                object = (JSONObject)BasicFactory.getArrayItem((JSONArray)jSONArray2, (int)i);
                ((Vector)object2).add((String)BasicFactory.getItem((Object)object, (String)"value"));
            }
            String string4 = (String)BasicFactory.getItem((Object)jSONObject, (String)"showEffects");
            object = (String)BasicFactory.getItem((Object)jSONObject, (String)"numLevels");
            String string5 = (String)BasicFactory.getItem((Object)jSONObject, (String)"activeDataSetLUIDOriginator");
            String string6 = (String)BasicFactory.getItem((Object)jSONObject, (String)"activeDataSetLUIDSequence");
            LocallyUniqueId locallyUniqueId = new LocallyUniqueId();
            if (string5 != null && string6 != null) {
                locallyUniqueId = new LocallyUniqueId(Integer.parseInt(string5), Integer.parseInt(string6));
            }
            aSMapsError = SysFileProxy.getSysFileProxy().getImpactDiagram(locallyUniqueId, string2, string3, vector3, (Vector)object2, string4.equals("true"), Integer.parseInt((String)object), vector2);
        }
        boolean bl2 = bl = aSMapsError != null && !aSMapsError.getHasError();
        if (bl) {
            try {
                vector.add(JSONObject.parse((String)((String)vector2.get(0))));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    private class GlobalKeyHandler
    implements AWTEventListener {
        private GlobalKeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Window window;
            Component component;
            int n = keyEvent.getKeyCode();
            if (keyEvent.isControlDown() && n == 9 && (component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && (window = this.getParentWindow(component)) != null) {
                if (window instanceof ViewerFrame) {
                    this.sendFocusToModifyOutput(keyEvent);
                } else if (window instanceof ModifyOutputDlg || window instanceof ModifyOutputSelectDlg) {
                    ViewerFrame.this.mImpl.getViewerTreePane().requestFocus();
                    ViewerFrame.this.mImpl.getViewerTreePane().getViewerTree().requestFocusInWindow();
                    keyEvent.consume();
                }
            }
        }

        private void sendFocusToModifyOutput(KeyEvent keyEvent) {
            if (ViewerFrame.this.mModifyOutputDlg != null) {
                ViewerFrame.this.mModifyOutputDlg.forceFocus();
                keyEvent.consume();
            }
        }

        private Window getParentWindow(Component component) {
            while (component != null && !(component instanceof Window)) {
                component = component.getParent();
            }
            return component != null ? (Window)component : null;
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 401) {
                this.keyPressed((KeyEvent)aWTEvent);
            }
        }
    }

    public static class npsDisplayThread
    extends Thread {
        private ViewerFrame parentFrame;

        public npsDisplayThread(ViewerFrame viewerFrame) {
            this.parentFrame = viewerFrame;
        }

        @Override
        public void run() {
            try {
                npsDisplayThread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.parentFrame.isFocused() && UserInfoUtil.isOnceNotified() && !UserInfoUtil.isOnceNpsDialogShowed()) {
                NpsFeedlessPane.showNpsFeedlessDialog(this.parentFrame, VersionInfo.getAppVersionString());
                UserInfoUtil.setOnceNpsDialogShowed((boolean)true);
            }
        }
    }
}

