/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.LightPivotTable;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ILocaleListener;
import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.IOutputItemListener;
import com.spss.java_client.core.documents.output.IOutputLogListener;
import com.spss.java_client.core.documents.output.OutputManager;
import com.spss.java_client.core.documents.output.header.HeaderItem;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.core.documents.output.text.LogItem;
import com.spss.java_client.core.documents.output.text.PageTitleItem;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.documents.output.text.TitleItem;
import com.spss.java_client.ui.dialogs.base.edit.find.IReplaceAllCallback;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.ChartViewerItemHelper;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphServiceViewerItem;
import com.spss.java_client.ui.doc_types.output.HeaderViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerItemListener;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonChartViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonInteractiveViewerItem;
import com.spss.java_client.ui.doc_types.output.LightTableViewerItem;
import com.spss.java_client.ui.doc_types.output.LogViewerItem;
import com.spss.java_client.ui.doc_types.output.ModelViewerItem;
import com.spss.java_client.ui.doc_types.output.NotesViewerItem;
import com.spss.java_client.ui.doc_types.output.PageTitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.TitleViewerItem;
import com.spss.java_client.ui.doc_types.output.TreeModelViewerItem;
import com.spss.java_client.ui.doc_types.output.UnknownViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.WarningViewerItem;
import com.spss.java_client.ui.doc_types.output.undo.OutputUndoableEdit;
import com.spss.java_client.ui.doc_types.output.undo.UndoItemInfo;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.IUISearchAndReplaceProxy;
import com.spss.uitools.util.TraceSettings;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.processors.Graphics2DProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.undo.CompoundEdit;

public class ViewerDocument
implements IOutputItemListener,
IOutputLogListener,
ISearchProxy,
IUISearchAndReplaceProxy,
ILocaleListener {
    private IOutputDocument mCoreDocument = null;
    private Vector<ViewerItem> mViewerItems = new Vector();
    private final Object ITEMS_LOCK = new Object();
    private Vector<IViewerItemListener> mListeners = new Vector();
    private ViewerItem mFocusedViewerItem = null;
    private IViewerWindow mWindow = null;
    private WeakReference<ViewerItem> mLastAddedItem;
    private Stack<WeakReference<ViewerItem>> mProcedureHeaderItemStack = new Stack();
    private ViewerFindDlg mPivotTableSearchWindow = null;
    private LogViewerItem mCurrentLog = null;
    private Timer mSearchTimer = null;
    private boolean mSearchStopped = false;
    private CompoundEdit mBigEdit = null;
    private int mReplaceAllCount = 0;
    private IReplaceAllCallback mReplaceAllCallback = null;
    private ViewerSearchOptions mReplaceAllContext = null;

    public ViewerDocument(IViewerWindow iViewerWindow) {
        this.mWindow = iViewerWindow;
        ComponentState.addLocaleListener((ILocaleListener)this);
    }

    public void close() {
        ComponentState.removeLocaleListener((ILocaleListener)this);
        this.mViewerItems.clear();
        this.mListeners.clear();
        this.mProcedureHeaderItemStack.clear();
        this.mViewerItems = null;
        this.mListeners = null;
        this.mProcedureHeaderItemStack = null;
        this.mCoreDocument = null;
        this.mFocusedViewerItem = null;
        this.mWindow = null;
        this.mLastAddedItem = null;
        this.mPivotTableSearchWindow = null;
        this.mCurrentLog = null;
    }

    public void insertImageAfter(Image image, ViewerItem viewerItem) {
        this.mCoreDocument.insertImageAfter(image, viewerItem != null ? viewerItem.getCoreItem() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean itemsPending() {
        boolean bl = false;
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (!viewerItem.getCoreItem().isValid() || viewerItem.getCoreItem().isComplete()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSelected() {
        Vector<IOutputItem> vector = new Vector<IOutputItem>();
        LinkedHashMap<IOutputItem, UndoItemInfo> linkedHashMap = new LinkedHashMap<IOutputItem, UndoItemInfo>();
        Iterator iterator = this.ITEMS_LOCK;
        synchronized (iterator) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                HeaderItem headerItem;
                if (viewerItem.isInEditMode()) {
                    viewerItem.endEdit();
                }
                if (!viewerItem.isSelected() || (headerItem = (HeaderItem)viewerItem.getCoreItem().getParentItem()) == null) continue;
                int n = headerItem.getItemIndex(viewerItem.getCoreItem());
                Object object = n == 0 ? headerItem : headerItem.getChildItem(n - 1);
                UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)object);
                linkedHashMap.put(viewerItem.getCoreItem(), undoItemInfo);
                vector.add(viewerItem.getCoreItem());
                if (!(viewerItem.getCoreItem() instanceof HeaderItem)) continue;
                this.deleteChildItemsFromOneHeader((HeaderItem)viewerItem.getCoreItem(), linkedHashMap, vector);
            }
        }
        new OutputUndoableEdit(this.mWindow, linkedHashMap);
        for (IOutputItem iOutputItem : vector) {
            this.mCoreDocument.deleteItem(iOutputItem);
        }
        return vector.size();
    }

    private IOutputItem deleteChildItemsFromOneHeader(HeaderItem headerItem, Map<IOutputItem, UndoItemInfo> map, Vector<IOutputItem> vector) {
        HeaderItem headerItem2 = headerItem;
        int n = headerItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            IOutputItem iOutputItem = headerItem.getChildItem(i);
            UndoItemInfo undoItemInfo = new UndoItemInfo((IOutputItem)headerItem, (IOutputItem)headerItem2);
            map.put(iOutputItem, undoItemInfo);
            vector.add(iOutputItem);
            headerItem2 = iOutputItem;
            if (!(iOutputItem instanceof HeaderItem)) continue;
            headerItem2 = this.deleteChildItemsFromOneHeader((HeaderItem)iOutputItem, map, vector);
        }
        return headerItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageBreaksOnSelected(boolean bl) {
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (!viewerItem.isSelected() || viewerItem.getPageBreak() == bl) continue;
                viewerItem.setPageBreak(bl);
            }
        }
    }

    public ViewerItem getFirstSelectedItem() {
        for (ViewerItem viewerItem : this.mViewerItems) {
            if (!viewerItem.isSelected()) continue;
            return viewerItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewerItem[] getSelectedItems(boolean bl) {
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            Vector<ViewerItem> vector = this.getOrderedItems();
            LinkedList<ViewerItem> linkedList = new LinkedList<ViewerItem>();
            for (ViewerItem viewerItem : vector) {
                if (!bl && viewerItem instanceof HeaderViewerItem || !viewerItem.isSelected() && !this.ancestorSelectedAndCollapsed(viewerItem)) continue;
                linkedList.add(viewerItem);
            }
            return linkedList.toArray(new ViewerItem[linkedList.size()]);
        }
    }

    public Vector<ViewerItem> getOrderedItems() {
        Vector<ViewerItem> vector = new Vector<ViewerItem>();
        if (this.mCoreDocument != null) {
            long l = this.mCoreDocument.getItemCount();
            int n = 0;
            while ((long)n < l) {
                ViewerItem viewerItem = this.locateItem(this.mCoreDocument.getItemAtIndex((long)n));
                if (viewerItem != null) {
                    vector.add(viewerItem);
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector<ViewerItem> getViewerItemsAtlevel(int n) {
        Vector<ViewerItem> vector = this.getOrderedItems();
        Vector<ViewerItem> vector2 = new Vector<ViewerItem>();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i).getCoreItem().getTreeLevel() != n) continue;
                vector2.add(vector.get(i));
            }
        }
        return vector2;
    }

    public HashMap<ViewerItem, Integer> createViewerItemToIndexMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<ViewerItem, Integer> hashMap2 = new HashMap<ViewerItem, Integer>();
        Vector<ViewerItem> vector = this.getViewerItemsAtlevel(1);
        for (ViewerItem viewerItem : vector) {
            String string = viewerItem.getCoreItem().getProcedureName().trim();
            Integer n = (Integer)hashMap.get(string);
            n = n == null ? 1 : n + 1;
            hashMap.put(string, n);
            hashMap2.put(viewerItem, n);
        }
        return hashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedItemCount(boolean bl) {
        int n = 0;
        int n2 = -1;
        Vector<HeaderItem> vector = new Vector<HeaderItem>();
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            boolean bl2 = false;
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (bl2 && !viewerItem.isSelected() && viewerItem.isCollapsed()) {
                    if (n > 0 && n2 >= 0 && vector.get(n2) != null && ((HeaderItem)vector.get(n2)).getItemIndex(viewerItem.getCoreItem()) >= 0) {
                        ++n;
                    } else {
                        bl2 = false;
                    }
                }
                if (!viewerItem.isSelected() || !bl && viewerItem instanceof HeaderViewerItem) continue;
                ++n;
                if (!(viewerItem.getCoreItem() instanceof HeaderItem)) continue;
                vector.add((HeaderItem)viewerItem.getCoreItem());
                ++n2;
                bl2 = true;
            }
        }
        return n;
    }

    public Image getSelectionImage(boolean bl) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        ViewerItem[] viewerItemArray = this.getSelectedItems(false);
        for (ViewerItem viewerItemArray2 : viewerItemArray) {
            if (!this.canCopyRaster(viewerItemArray2)) continue;
            Dimension dimension = viewerItemArray2.getSize();
            rectangle.width = rectangle.width > dimension.width ? rectangle.width : dimension.width;
            rectangle.height += dimension.height;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        if (!this.canConvertImageToBytes(rectangle.width, rectangle.height)) {
            return null;
        }
        Object object = null;
        try {
            object = bl ? new BufferedImage(rectangle.width, rectangle.height, 6) : new BufferedImage(rectangle.width, rectangle.height, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            object = null;
            try {
                object = new BufferedImage(rectangle.width, rectangle.height, 13);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                object = null;
            }
        }
        if (object == null) {
            return null;
        }
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        Color color = new Color(255, 255, 255, 0);
        graphics2D.setBackground(color);
        graphics2D.setColor(color);
        graphics2D.clearRect(0, 0, rectangle.width, rectangle.height);
        for (ViewerItem viewerItem : viewerItemArray) {
            if (!this.canCopyRaster(viewerItem)) continue;
            Dimension dimension = viewerItem.getSize();
            graphics2D.setClip(0, 0, dimension.width, dimension.height);
            if (viewerItem instanceof LightTableViewerItem) {
                ((LightTableViewerItem)viewerItem).getRenderer().render((Graphics)graphics2D);
            } else if (viewerItem instanceof ModelViewerItem) {
                ((ModelViewerItem)viewerItem).renderModelNoThumbnail(graphics2D);
            } else if (viewerItem instanceof TableViewerItem) {
                try {
                    Graphics2DProcessor visualizationException = new Graphics2DProcessor(graphics2D);
                    ((TableItem)viewerItem.getCoreItem()).getExportVisualization().runProcessor((ResultsProcessor)visualizationException);
                }
                catch (VisualizationException visualizationException) {
                    visualizationException.printStackTrace();
                }
            } else if (bl) {
                viewerItem.renderWithTransparency(graphics2D);
            } else {
                viewerItem.renderContents(graphics2D);
            }
            graphics2D.translate(0, dimension.height);
        }
        graphics2D.dispose();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortVisualizations() {
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            BufferedImage bufferedImage = null;
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (!viewerItem.getCoreItem().isValid() || viewerItem.getCoreItem().isComplete()) continue;
                if (bufferedImage == null) {
                    bufferedImage = ImageGenerator2.getImageGenerator().generateInfoImage(ResUtil.getString("IDS_BAD_TABLE"), 300, 120);
                }
                viewerItem.getCoreItem().setValid(false);
                viewerItem.renderingComplete(bufferedImage);
            }
        }
    }

    public final Vector<ViewerItem> getViewerItems() {
        return this.mViewerItems;
    }

    public void setFocusedViewerItem(ViewerItem viewerItem) {
        this.setFocusedViewerItem(viewerItem, true);
    }

    public void setFocusedViewerItem(ViewerItem viewerItem, boolean bl) {
        if (this.mCoreDocument == null || this.mListeners == null) {
            return;
        }
        if (this.mFocusedViewerItem != viewerItem) {
            if (this.mFocusedViewerItem instanceof ChartViewerItem || this.mFocusedViewerItem instanceof GraphBoardViewerItem || this.mFocusedViewerItem instanceof ModelViewerItem) {
                this.mFocusedViewerItem.endEdit();
            }
            ViewerItem viewerItem2 = this.mFocusedViewerItem;
            this.mFocusedViewerItem = viewerItem;
            this.handleScreenReader(viewerItem2, viewerItem);
        }
        this.notifyFocusedItem(viewerItem, bl);
    }

    public ViewerItem getFocusedViewerItem() {
        return this.mFocusedViewerItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFocus(boolean bl) {
        ViewerItem viewerItem = this.mFocusedViewerItem;
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            if (viewerItem == null) {
                if (this.mViewerItems.size() > 0) {
                    viewerItem = this.mViewerItems.get(0);
                }
            } else {
                int n = this.mViewerItems.indexOf(viewerItem);
                do {
                    if (bl) {
                        n = n > 0 ? n - 1 : -1;
                    } else {
                        int n2 = n = n < this.mViewerItems.size() - 1 ? n + 1 : -1;
                    }
                    if (n > -1) {
                        viewerItem = this.mViewerItems.get(n);
                    }
                    if (viewerItem != this.mFocusedViewerItem) continue;
                    viewerItem = null;
                } while (viewerItem != null && !viewerItem.isVisible());
            }
        }
        if (viewerItem != null) {
            this.setFocusedViewerItem(viewerItem);
        }
    }

    public boolean saveModified() {
        if (this.mCoreDocument == null) {
            TraceSettings.trace1((String)"Null core document in ViewerDocument.saveModified()", (int)15);
            return true;
        }
        if (this.mCoreDocument.getModifiedFlag() && this.mCoreDocument.getPromptToSaveFlag()) {
            String string;
            if (this.mWindow.getExtendedState() == 1) {
                this.mWindow.setExtendedState(0);
            }
            Toolkit.getDefaultToolkit().beep();
            if (this.mCoreDocument.getFileSpec() == null) {
                String string2 = OutputManager.getOutputManager().getOutputDocumentUniqueName(this.mCoreDocument);
                string = this.mCoreDocument.getDocName() + " [" + string2 + ']';
            } else {
                string = this.mCoreDocument.getFileSpec().getPath();
            }
            String string3 = String.format(ResUtil.getString("ERR_VIEWER_SAVE_QUERY"), string);
            String string4 = VersionInfo.getAppVersionString();
            SpssAlertOptionPane.OptionType optionType = VersionInfo.isSmartReader() ? SpssAlertOptionPane.OptionType.YES_NO_OPTION : SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION;
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWindow), string3, string4, optionType);
            if (optionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION && n == 3 || n == -1) {
                return false;
            }
            if (n == 1 && !this.mWindow.saveCoreDocument() && optionType == SpssAlertOptionPane.OptionType.YES_NO_CANCEL_OPTION) {
                return false;
            }
        }
        ImageCache.getImageCache().clean();
        this.mCoreDocument.removeOutputItemListener((IOutputItemListener)this);
        this.mCoreDocument.removeOutputLogListener((IOutputLogListener)this);
        return true;
    }

    public void selectionChanged(ViewerItem viewerItem, boolean bl, boolean bl2) {
        if (viewerItem.isSelected() != bl) {
            viewerItem.setSelected(bl);
            this.notifySelectionChange(viewerItem, bl, bl2);
        }
    }

    public void deselectHeaderNodes() {
        this.notifyClearHeaderSelections();
    }

    public void addItemListener(IViewerItemListener iViewerItemListener) {
        this.mListeners.add(iViewerItemListener);
    }

    public void removeItemListener(IViewerItemListener iViewerItemListener) {
        this.mListeners.remove(iViewerItemListener);
    }

    public IOutputDocument getCoreDocument() {
        return this.mCoreDocument;
    }

    @Override
    public String getDocumentName() {
        return this.mCoreDocument != null ? this.mCoreDocument.getDocName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoreDocument(IOutputDocument iOutputDocument) {
        this.mCoreDocument = iOutputDocument;
        this.mCoreDocument.addOutputItemListener((IOutputItemListener)this);
        this.mCoreDocument.addOutputLogListener((IOutputLogListener)this);
        HeaderViewerItem headerViewerItem = new HeaderViewerItem((IOutputItem)iOutputDocument.getRootItem(), "", "");
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            this.mViewerItems.add(headerViewerItem);
        }
        this.setFocusedViewerItem(headerViewerItem);
    }

    public void notifyKeyEvent(KeyEvent keyEvent) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyKeyEvent(keyEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAllNotes() {
        this.deselectHeaderNodes();
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                IOutputItem iOutputItem = viewerItem.getCoreItem();
                if (!(iOutputItem instanceof LightTableItem) && !(iOutputItem instanceof TableItem) || iOutputItem.getType() != OutputItemType.NOTE) continue;
                this.selectionChanged(viewerItem, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAllNotesEx() {
        this.deselectHeaderNodes();
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (viewerItem.getCoreItem().getType() != OutputItemType.NOTE) continue;
                this.selectionChanged(viewerItem, true, true);
            }
        }
    }

    public final Object getItemLock() {
        return this.ITEMS_LOCK;
    }

    public void notifySpssLocaleChange(Locale locale) {
    }

    public void notifyCharsetChange(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyILangChange(Locale locale) {
        ViewerItem.resetResStrings();
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                viewerItem.resetTipText();
            }
        }
    }

    ViewerFindDlg getSearchDialog(Window window) {
        ViewerFindDlg viewerFindDlg = null;
        if (window instanceof ITopWindow) {
            viewerFindDlg = ((ITopWindow)((Object)window)).getIViewerWindow().getSearchDialog();
        } else if (window != null) {
            if (this.mPivotTableSearchWindow == null || this.mPivotTableSearchWindow.getParent() != window) {
                this.mPivotTableSearchWindow = new ViewerFindDlg(window, this, false);
            }
            viewerFindDlg = this.mPivotTableSearchWindow;
        }
        return viewerFindDlg;
    }

    protected void addItem(ViewerItem viewerItem, IOutputItem iOutputItem) {
        this.addItem(viewerItem, iOutputItem, this.mWindow.getOutputPane().isScrollToNewOutput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addItem(final ViewerItem viewerItem, IOutputItem iOutputItem, final boolean bl) {
        IOutputItem iOutputItem2 = viewerItem.getCoreItem();
        HeaderItem headerItem = (HeaderItem)iOutputItem2.getParentItem();
        if (headerItem == null) {
            return;
        }
        int n = headerItem.getItemIndex(iOutputItem2);
        int n2 = n;
        if (n2 < 0 || n2 > headerItem.getChildCount()) {
            n2 = headerItem.getChildCount();
        }
        int n3 = 0;
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem2 : this.mViewerItems) {
                if (viewerItem2.getCoreItem() == headerItem) {
                    n2 += n3 + 1;
                    break;
                }
                ++n3;
            }
            n2 = Math.min(n2, this.mViewerItems.size());
            if (iOutputItem != null) {
                this.mViewerItems.add(n2, viewerItem);
            } else {
                this.mViewerItems.add(viewerItem);
            }
        }
        this.notifyNewItem(viewerItem, iOutputItem, bl);
        viewerItem.invalidate();
        if (n == 0 && viewerItem.getCoreItem().getTreeLevel() == 2) {
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!viewerItem.isHidden() && !viewerItem.isCollapsed()) {
                            ViewerDocument.this.setFocusedViewerItem(viewerItem, bl);
                        }
                    }
                });
            } else {
                this.setFocusedViewerItem(viewerItem, bl);
            }
        }
        if (viewerItem instanceof TableViewerItem || viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem) {
            this.mWindow.updateToolbarEnableStatus();
        }
    }

    public ViewerItem locateItem(IOutputItem iOutputItem) {
        for (ViewerItem viewerItem : this.mViewerItems) {
            if (viewerItem.getCoreItem() != iOutputItem) continue;
            return viewerItem;
        }
        return null;
    }

    private boolean canCopyRaster(ViewerItem viewerItem) {
        return !(viewerItem.getCoreItem() instanceof TextItem);
    }

    private void notifyNewItem(ViewerItem viewerItem, IOutputItem iOutputItem, boolean bl) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyNewItem(viewerItem, iOutputItem, bl);
        }
    }

    private void notifyRemoveItem(ViewerItem viewerItem) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyRemoveItem(viewerItem);
        }
    }

    public void notifyObjectPropertyChange(IOutputItem iOutputItem) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyObjectPropertyChange(iOutputItem);
        }
    }

    private void notifyFocusedItem(ViewerItem viewerItem, boolean bl) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyFocusedItem(viewerItem, bl);
        }
    }

    static Component compositeRequestFocus(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                ((Component)object2).requestFocus();
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                component2.requestFocus();
                return component2;
            }
        }
        if (component.isFocusable()) {
            component.requestFocus();
            return component;
        }
        return null;
    }

    private void notifySelectionChange(ViewerItem viewerItem, boolean bl, boolean bl2) {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifySelectionChange(viewerItem, bl, bl2);
        }
    }

    private void notifyClearHeaderSelections() {
        for (IViewerItemListener iViewerItemListener : this.mListeners) {
            iViewerItemListener.notifyClearHeaderSelections();
        }
    }

    public synchronized void notifyNewOutputItem(final IOutputItem iOutputItem, final IOutputItem iOutputItem2, final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerDocument.this.insertNewOutputItemImpl(iOutputItem, iOutputItem2, bl, bl2);
            }
        });
    }

    public void notifyChangedModifiedFlag() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ViewerDocument.this.mWindow != null) {
                    ViewerDocument.this.mWindow.updateTitleBar();
                    ViewerDocument.this.mWindow.updateToolbarEnableStatus();
                }
            }
        });
    }

    public void notifyHeaderCollapsed(final HeaderItem headerItem) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerDocument.this.mWindow.setSelected((IOutputItem)headerItem, true);
                ViewerDocument.this.mWindow.setSelectionExpandState(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewOutputItemImpl(IOutputItem iOutputItem, IOutputItem iOutputItem2, boolean bl, boolean bl2) {
        Object object;
        if (this.mWindow.getUndoManager() != null && (object = this.mWindow.getUndoManager().getTopFrame()) instanceof Window) {
            ((Window)object).setCursor(Cursor.getPredefinedCursor(3));
        }
        try {
            switch (iOutputItem.getType()) {
                case HEAD: {
                    object = new HeaderViewerItem(iOutputItem, iOutputItem.getDescription(), "");
                    this.mProcedureHeaderItemStack.push(new WeakReference<Object>(object));
                    break;
                }
                case LOG: {
                    object = new LogViewerItem(iOutputItem, iOutputItem.getDescription(), iOutputItem.getContentAsText());
                    break;
                }
                case CHART: 
                case IGRAPH: {
                    object = new ChartViewerItem(iOutputItem);
                    break;
                }
                case PIVOT: 
                case NOTE: 
                case WARNING: {
                    object = this.makeTableItem(iOutputItem);
                    break;
                }
                case TEXT: {
                    object = new TextViewerItem(iOutputItem, iOutputItem.getDescription(), ((TextItem)iOutputItem).getContents());
                    break;
                }
                case TITLE: {
                    object = new TitleViewerItem(iOutputItem, iOutputItem.getDescription(), ((TitleItem)iOutputItem).getContents());
                    break;
                }
                case PAGETITLE: {
                    object = new PageTitleViewerItem(iOutputItem, iOutputItem.getDescription(), ((PageTitleItem)iOutputItem).getContents());
                    break;
                }
                case TREEMODEL: {
                    object = new TreeModelViewerItem(iOutputItem, iOutputItem.getDescription());
                    break;
                }
                case GENERIC: {
                    object = new GenericViewerItem(iOutputItem);
                    break;
                }
                case IMAGE: {
                    object = new ImageViewerItem(iOutputItem);
                    break;
                }
                case MODEL: {
                    if (iOutputItem instanceof JsonInteractiveItem) {
                        object = new JsonInteractiveViewerItem(iOutputItem);
                        break;
                    }
                    object = new ModelViewerItem(iOutputItem);
                    break;
                }
                case GRAPHBOARD: {
                    object = new GraphBoardViewerItem(iOutputItem);
                    break;
                }
                case JSONCHART: {
                    object = new JsonChartViewerItem(iOutputItem);
                    break;
                }
                case JSONTABLE: {
                    object = new LightTableViewerItem(iOutputItem);
                    break;
                }
                case GRAPHSERVICE: {
                    object = new GraphServiceViewerItem(iOutputItem);
                    break;
                }
                case UNKNOWN: {
                    object = new UnknownViewerItem(iOutputItem);
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            ((ViewerItem)object).setVisible(bl);
            this.addItem((ViewerItem)object, iOutputItem2, !bl2 && this.mWindow.getOutputPane().isScrollToNewOutput());
            this.mLastAddedItem = new WeakReference<Object>(object);
            if (object instanceof TextViewerItem) {
                ((TextViewerItem)object).setInitialPosition();
            }
        }
        finally {
            ITopWindow iTopWindow;
            if (this.mWindow.getUndoManager() != null && (iTopWindow = this.mWindow.getUndoManager().getTopFrame()) instanceof Window) {
                ((Window)((Object)iTopWindow)).setCursor(null);
            }
        }
    }

    private ViewerItem makeTableItem(IOutputItem iOutputItem) {
        ViewerItem viewerItem = null;
        if (iOutputItem instanceof TableItem) {
            switch (iOutputItem.getType()) {
                case PIVOT: {
                    viewerItem = new TableViewerItem(iOutputItem, iOutputItem.getDescription());
                    break;
                }
                case NOTE: {
                    viewerItem = new NotesViewerItem(iOutputItem, iOutputItem.getDescription());
                    break;
                }
                case WARNING: {
                    viewerItem = new WarningViewerItem(iOutputItem, iOutputItem.getDescription());
                    break;
                }
            }
        } else if (iOutputItem instanceof LightTableItem) {
            viewerItem = new LightTableViewerItem(iOutputItem);
        }
        return viewerItem;
    }

    ViewerItem getLastAddedItem() {
        return this.mLastAddedItem != null ? (ViewerItem)this.mLastAddedItem.get() : null;
    }

    ViewerItem getLastAddedHeaderItem() {
        if (this.mProcedureHeaderItemStack.size() > 0) {
            return (ViewerItem)this.mProcedureHeaderItemStack.peek().get();
        }
        return null;
    }

    ViewerItem getNextAddedHeaderItem() {
        if (this.mProcedureHeaderItemStack.size() > 1) {
            this.mProcedureHeaderItemStack.pop();
            return (ViewerItem)this.mProcedureHeaderItemStack.peek().get();
        }
        return null;
    }

    public synchronized void notifyRemoveItem(IOutputItem iOutputItem) {
        final IOutputItem iOutputItem2 = iOutputItem;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerDocument.this.removeItemImpl(iOutputItem2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemImpl(IOutputItem iOutputItem) {
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (viewerItem.getCoreItem() != iOutputItem) continue;
                if (this.getFocusedViewerItem() == viewerItem) {
                    int n = this.mViewerItems.indexOf(viewerItem);
                    n = n == 0 ? this.mViewerItems.size() - 1 : n - 1;
                    this.setFocusedViewerItem(this.mViewerItems.get(n));
                }
                this.notifyRemoveItem(viewerItem);
                this.mViewerItems.remove(viewerItem);
                ImageGenerator2.getImageGenerator().clearItem(viewerItem);
                break;
            }
        }
    }

    public synchronized void notifyOutputLog(LogItem logItem, String string, boolean bl, IOutputItem iOutputItem, boolean bl2) {
        final String string2 = string;
        if (string2.length() == 0) {
            return;
        }
        final LogItem logItem2 = logItem;
        final IOutputItem iOutputItem2 = iOutputItem;
        final boolean bl3 = bl2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerDocument.this.outputLogImpl(string2, logItem2, iOutputItem2, bl3);
            }
        });
    }

    private void outputLogImpl(String string, LogItem logItem, IOutputItem iOutputItem, boolean bl) {
        if (this.mCurrentLog == null || this.mCurrentLog.getCoreItem() != logItem) {
            String string2 = logItem.getDescription();
            if (string2 == null || string2.length() == 0) {
                string2 = ResUtil.getString("IDS_VIEWER_ITEM_LOG");
            }
            this.mCurrentLog = new LogViewerItem((IOutputItem)logItem, string2, string);
            this.mCurrentLog.getCoreItem().setDescription(this.mCurrentLog.getName());
            this.addItem(this.mCurrentLog, null);
            this.mLastAddedItem = new WeakReference<LogViewerItem>(this.mCurrentLog);
            this.mCurrentLog.setInitialPosition();
        } else if (iOutputItem != null) {
            this.addItem(this.mCurrentLog, iOutputItem);
        } else {
            this.mCurrentLog.append(string);
            this.mWindow.getOutputScrollPane().revalidate();
        }
        if (!bl) {
            this.mWindow.setModified(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findNext(String string, SearchOptions searchOptions) {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        if (!this.areaSearchable(viewerSearchOptions)) {
            viewerSearchOptions.setItemsSearched(0);
            return false;
        }
        this.mWindow.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = false;
        boolean bl2 = viewerSearchOptions.isFirstSearch();
        try {
            ViewerItem viewerItem;
            if (bl2) {
                this.saveSelections(viewerSearchOptions);
            }
            ViewerItem viewerItem2 = viewerItem = bl2 ? this.getFirstSearchItem(viewerSearchOptions) : this.getNextSearchItem(viewerSearchOptions);
            while (viewerItem != null) {
                viewerSearchOptions.incrementItemsSearched();
                boolean bl3 = false;
                bl3 = viewerSearchOptions.getFindType() == ViewerSearchOptions.FindType.findrange ? this.findExpression(string, viewerItem, viewerSearchOptions) : this.findText(string, viewerItem, viewerSearchOptions);
                if (bl3) {
                    bl = true;
                    break;
                }
                if (!viewerSearchOptions.getInitiatedFromInPlaceEdit()) {
                    ViewerItem viewerItem3 = viewerSearchOptions.getCurrentItem();
                    viewerItem = this.getNextSearchItem(viewerSearchOptions);
                    if (viewerSearchOptions.getFindType() != ViewerSearchOptions.FindType.findrange || viewerItem3 != viewerItem) continue;
                    this.mWindow.commitEdits(viewerSearchOptions);
                    viewerItem = this.nextItem(viewerSearchOptions, viewerItem);
                    viewerSearchOptions.setCurrentItem(viewerItem);
                    continue;
                }
                viewerItem = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.mWindow.setCursor(null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceNext(String string, String string2, SearchOptions searchOptions) {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        if (!this.areaSearchable(viewerSearchOptions)) {
            viewerSearchOptions.setItemsSearched(0);
            return false;
        }
        boolean bl = viewerSearchOptions.isFirstSearch();
        if (bl || !this.selectionIsSearchString(viewerSearchOptions, string)) {
            return this.findNext(string, viewerSearchOptions);
        }
        boolean bl2 = false;
        this.mWindow.setCursor(Cursor.getPredefinedCursor(3));
        try {
            viewerSearchOptions.setSearchString(string);
            this.mWindow.replaceEditingTextSelection(viewerSearchOptions, string2);
            int n = string2.length() - string.length();
            viewerSearchOptions.setOffset(viewerSearchOptions.getOffset() + n);
            bl2 = this.findNext(string, viewerSearchOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        finally {
            viewerSearchOptions.setSearchString(null);
        }
        this.mWindow.setCursor(null);
        return bl2;
    }

    @Override
    public int replaceAll(String string, String string2, SearchOptions searchOptions) {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        if (!this.areaSearchable(viewerSearchOptions)) {
            viewerSearchOptions.setItemsSearched(0);
            return 0;
        }
        CompoundEdit compoundEdit = new CompoundEdit();
        this.mWindow.getUndoManager().addEdit(compoundEdit);
        int n = 0;
        this.saveSelections(viewerSearchOptions);
        if (!viewerSearchOptions.isFirstSearch() && this.selectionIsSearchString(viewerSearchOptions, string)) {
            ++n;
        }
        boolean bl = this.replaceNext(string, string2, viewerSearchOptions);
        while (bl) {
            ++n;
            viewerSearchOptions.setFirstSearch(false);
            bl = this.replaceNext(string, string2, viewerSearchOptions);
        }
        if (n > 0) {
            compoundEdit.end();
            ViewerItem viewerItem = this.mWindow.getOutputPane().getEditingItem();
            if (viewerItem != null && viewerItem == viewerSearchOptions.getCurrentItem() && viewerItem instanceof TableViewerItem && viewerItem.isInEditMode()) {
                viewerSearchOptions.getTableSearcher().restoreOriginalSearchLayer(viewerSearchOptions);
                if (viewerSearchOptions.isReplaceAll()) {
                    ((TableViewerItem)viewerItem).getTableEditor().getPivotTableInfo().redrawTable(null);
                }
            }
            viewerSearchOptions.getTableSearcher().clear();
        } else {
            compoundEdit.die();
        }
        this.mWindow.updateToolbarEnableStatus();
        return n;
    }

    public void delayedReplaceAll(final String string, final String string2, SearchOptions searchOptions, IReplaceAllCallback iReplaceAllCallback) {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)searchOptions;
        if (!this.areaSearchable(viewerSearchOptions)) {
            viewerSearchOptions.setItemsSearched(0);
            return;
        }
        this.saveSelections(viewerSearchOptions);
        this.mReplaceAllContext = viewerSearchOptions;
        this.mReplaceAllCallback = iReplaceAllCallback;
        this.mBigEdit = new CompoundEdit();
        this.mWindow.getUndoManager().addEdit(this.mBigEdit);
        this.mReplaceAllCount = 0;
        if (!viewerSearchOptions.isFirstSearch() && this.selectionIsSearchString(viewerSearchOptions, string)) {
            ++this.mReplaceAllCount;
            viewerSearchOptions.incrementItemsSearched();
        }
        this.mSearchStopped = false;
        this.mSearchTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ViewerDocument.this.mSearchStopped) {
                    ViewerDocument.this.replaceAllComplete();
                    return;
                }
                ViewerDocument.this.doReplaceOne(string, string2);
            }
        });
        this.mSearchTimer.setCoalesce(true);
        this.mSearchTimer.start();
    }

    private void doReplaceOne(String string, String string2) {
        boolean bl = this.replaceNext(string, string2, this.mReplaceAllContext);
        if (bl) {
            ++this.mReplaceAllCount;
            this.mReplaceAllContext.setFirstSearch(false);
        } else {
            this.replaceAllComplete();
        }
    }

    private void replaceAllComplete() {
        if (this.mSearchTimer != null) {
            this.mSearchTimer.stop();
        }
        this.mSearchTimer = null;
        this.mSearchStopped = true;
        if (this.mReplaceAllCount > 0) {
            this.mBigEdit.end();
            ViewerItem viewerItem = this.mWindow.getOutputPane().getEditingItem();
            if (viewerItem != null && viewerItem == this.mReplaceAllContext.getCurrentItem() && viewerItem instanceof TableViewerItem && viewerItem.isInEditMode()) {
                this.mReplaceAllContext.getTableSearcher().restoreOriginalSearchLayer(this.mReplaceAllContext);
                if (this.mReplaceAllContext.isReplaceAll()) {
                    ((TableViewerItem)viewerItem).getTableEditor().getPivotTableInfo().redrawTable(null);
                }
            } else if (viewerItem instanceof TableViewerItem && viewerItem.isInEditMode() && this.mReplaceAllContext.getCurrentItem() == null && this.mReplaceAllContext.isReplaceAll()) {
                ((TableViewerItem)viewerItem).getTableEditor().getPivotTableInfo().redrawTable(null);
            } else if (viewerItem instanceof LightTableViewerItem && this.mReplaceAllContext.isReplaceAll()) {
                ((LightTableViewerItem)viewerItem).getEditorFrame().getEditorInfo().reloadAndRedrawTable();
            }
            this.mReplaceAllContext.getTableSearcher().clear();
        } else {
            this.mBigEdit.die();
        }
        this.mReplaceAllCallback.notifyReplaceAllComplete(this.mReplaceAllCount, 0);
        this.mReplaceAllContext = null;
        this.mReplaceAllCallback = null;
        this.mBigEdit = null;
        this.mReplaceAllCount = 0;
        this.mWindow.updateToolbarEnableStatus();
    }

    @Override
    public void stopSearch() {
        this.mSearchStopped = true;
    }

    public void showFindDialog(Window window, boolean bl) {
        ViewerFindDlg viewerFindDlg = this.getSearchDialog(window);
        if (viewerFindDlg != null) {
            viewerFindDlg.selectReplace(bl);
            viewerFindDlg.setVisible(true);
        }
    }

    public boolean isSearchWindowVisible(Window window) {
        ViewerFindDlg viewerFindDlg = null;
        if (this.mWindow == window) {
            viewerFindDlg = this.mWindow.getSearchDialog();
        } else if (window != null && this.mPivotTableSearchWindow != null) {
            viewerFindDlg = this.mPivotTableSearchWindow;
        }
        return viewerFindDlg != null && viewerFindDlg.getParent() == window && viewerFindDlg.isVisible();
    }

    public boolean doFindAgain(Window window) {
        boolean bl = false;
        ViewerFindDlg viewerFindDlg = this.getSearchDialog(window);
        if (viewerFindDlg != null && viewerFindDlg.getLastFindValue().length() > 0) {
            bl = viewerFindDlg.findNext();
        }
        return bl;
    }

    public boolean hasFindItem(Window window) {
        ViewerFindDlg viewerFindDlg = this.getSearchDialog(window);
        return viewerFindDlg != null && viewerFindDlg.getLastFindValue().length() > 0;
    }

    private void saveSelections(ViewerSearchOptions viewerSearchOptions) {
        if (viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            viewerSearchOptions.setSelectedItems(this.getSelectedItems(true));
        }
    }

    private boolean selectionIsSearchString(ViewerSearchOptions viewerSearchOptions, String string) {
        return this.mWindow.selectionIsSearchString(viewerSearchOptions, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areaSearchable(ViewerSearchOptions viewerSearchOptions) {
        if (this.getCoreDocument().isDocumentEmpty()) {
            return false;
        }
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            for (ViewerItem viewerItem : this.mViewerItems) {
                if (!this.searchableItem(viewerItem, viewerSearchOptions)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean searchableItem(ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions) {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected;
        if (bl2 && !viewerItem.isSelected()) {
            return false;
        }
        boolean bl4 = viewerSearchOptions.getIncludeHidden();
        boolean bl5 = bl = bl4 || viewerItem.isVisible();
        if (bl && (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem || viewerItem instanceof TreeModelViewerItem || viewerItem instanceof ModelViewerItem || viewerItem instanceof ImageViewerItem || viewerItem instanceof JsonChartViewerItem || viewerItem instanceof GenericViewerItem)) {
            bl = viewerSearchOptions.getCurrentPane() == IViewerWindow.PaneType.Outline;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerItem getFirstSearchItem(ViewerSearchOptions viewerSearchOptions) {
        boolean bl;
        ViewerItem viewerItem = null;
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            if (this.mFocusedViewerItem != null) {
                viewerItem = this.mFocusedViewerItem;
            } else if (this.mViewerItems.size() > 0) {
                viewerItem = this.mViewerItems.firstElement();
            }
        }
        viewerSearchOptions.setStartItem(viewerItem);
        viewerSearchOptions.setItemDone(false);
        boolean bl2 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        while (viewerItem != null && !this.searchableItem(viewerItem, viewerSearchOptions)) {
            Object object2 = this.ITEMS_LOCK;
            synchronized (object2) {
                int n = this.mViewerItems.indexOf(viewerItem);
                if (bl) {
                    viewerItem = n > 0 ? this.mViewerItems.get(n - 1) : this.mViewerItems.lastElement();
                } else {
                    ViewerItem viewerItem2 = viewerItem = n < this.mViewerItems.size() - 1 ? this.mViewerItems.get(n + 1) : this.mViewerItems.firstElement();
                }
                if (viewerItem == viewerSearchOptions.getStartItem()) {
                    viewerItem = null;
                }
            }
        }
        viewerSearchOptions.setStartItem(viewerItem);
        viewerSearchOptions.setCurrentItem(viewerItem);
        if (viewerItem != null && viewerItem.isInEditMode() && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.outline) {
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
        } else if (bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.outline) {
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
        } else if (!bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.contents) {
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
        }
        if (viewerItem instanceof TableViewerItem) {
            viewerSearchOptions.setOffset(bl ? -1 : 0);
        } else {
            viewerSearchOptions.setOffset(0);
        }
        return viewerItem;
    }

    private ViewerItem getNextSearchItem(ViewerSearchOptions viewerSearchOptions) {
        boolean bl;
        boolean bl2 = false;
        ViewerItem viewerItem = viewerSearchOptions.getCurrentItem();
        if (viewerItem == null) {
            return null;
        }
        if (viewerSearchOptions.getItemDone() || !this.searchableItem(viewerItem, viewerSearchOptions)) {
            if (!viewerSearchOptions.getInitiatedFromOutOfPlaceFrame()) {
                this.mWindow.commitEdits(viewerSearchOptions);
                viewerItem = this.nextItem(viewerSearchOptions, viewerItem);
                bl2 = true;
            } else if (viewerItem instanceof TableViewerItem) {
                TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
                if (tableViewerItem.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
                    tableViewerItem.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit();
                }
                viewerItem = null;
            } else if (viewerItem instanceof LightTableViewerItem) {
                viewerItem = null;
            }
            viewerSearchOptions.setItemDone(false);
        }
        boolean bl3 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        while (viewerItem != null && !this.searchableItem(viewerItem, viewerSearchOptions)) {
            if (bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.outline && viewerSearchOptions.getCurrentPane() == IViewerWindow.PaneType.Outline) {
                viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
                continue;
            }
            if (!bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.contents && viewerSearchOptions.getCurrentPane() == IViewerWindow.PaneType.Content) {
                viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
                continue;
            }
            viewerItem = this.nextItem(viewerSearchOptions, viewerItem);
            viewerSearchOptions.setItemDone(false);
            bl2 = true;
        }
        viewerSearchOptions.setCurrentItem(viewerItem);
        if (viewerItem != null && bl2) {
            if (bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.outline) {
                viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
            } else if (!bl && viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.contents) {
                viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
            }
            if (viewerItem instanceof TableViewerItem) {
                viewerSearchOptions.setOffset(bl ? -1 : 0);
            } else {
                viewerSearchOptions.setOffset(0);
            }
        }
        return viewerItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ViewerItem nextItem(ViewerSearchOptions viewerSearchOptions, ViewerItem viewerItem) {
        ViewerItem viewerItem2;
        boolean bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        Object object = this.ITEMS_LOCK;
        synchronized (object) {
            int n = (int)this.mCoreDocument.getItemCount();
            int n2 = (int)this.mCoreDocument.getPreorderItemIndex(viewerItem.getCoreItem());
            IOutputItem iOutputItem = bl ? (n2 > 0 ? this.mCoreDocument.getItemAtIndex((long)(n2 - 1)) : this.mCoreDocument.getItemAtIndex((long)(n - 1))) : (n2 < n - 1 ? this.mCoreDocument.getItemAtIndex((long)(n2 + 1)) : this.mCoreDocument.getItemAtIndex(0L));
            viewerItem2 = this.getItemFromCoreItem(iOutputItem);
        }
        if (viewerItem2 == viewerSearchOptions.getStartItem()) {
            this.setFocusedViewerItem(viewerSearchOptions.getStartItem());
            viewerItem2 = null;
        }
        return viewerItem2;
    }

    private ViewerItem getItemFromCoreItem(IOutputItem iOutputItem) {
        for (ViewerItem viewerItem : this.mViewerItems) {
            if (iOutputItem != viewerItem.getCoreItem()) continue;
            return viewerItem;
        }
        return null;
    }

    private boolean findExpression(String string, ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions) {
        if (!(viewerItem instanceof LightTableViewerItem)) {
            return false;
        }
        boolean bl = false;
        viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
        LightTableViewerItem lightTableViewerItem = (LightTableViewerItem)viewerItem;
        bl = lightTableViewerItem.findExpression(string, viewerSearchOptions);
        if (bl) {
            this.mWindow.activateAndSelect(viewerSearchOptions, -1);
        } else {
            viewerSearchOptions.setItemDone(true);
            if (lightTableViewerItem.isInEditMode()) {
                Window[] windowArray;
                Point point = null;
                boolean bl2 = false;
                for (Window window : windowArray = viewerSearchOptions.getTopFrame().getOwnedWindows()) {
                    if (!(window instanceof ViewerFindDlg)) continue;
                    point = window.getLocation();
                    bl2 = ((ViewerFindDlg)((Object)window)).isReplaceChecked();
                    break;
                }
            }
        }
        return bl;
    }

    private boolean isExpression(String string) {
        return string.indexOf("<") >= 0 || string.indexOf(">") >= 0;
    }

    private boolean findText(String string, ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions) {
        boolean bl;
        boolean bl2;
        int n = string.length();
        string = string.replace("\\", "\\\\");
        string = string.replace(".", "\\x2E");
        string = string.replace("*", "\\x2A");
        string = string.replace("$", "\\x24");
        string = string.replace("^", "\\x5E");
        string = string.replace("(", "\\x28");
        string = string.replace(")", "\\x29");
        String string2 = !viewerSearchOptions.getMatchCase() ? "(?i)(?u)" + string : string;
        Pattern pattern = Pattern.compile(string2);
        IViewerWindow.PaneType paneType = viewerSearchOptions.getPaneSelection() == ViewerSearchOptions.PaneSelection.contents ? IViewerWindow.PaneType.Content : (viewerSearchOptions.getPaneSelection() == ViewerSearchOptions.PaneSelection.outline ? IViewerWindow.PaneType.Outline : viewerSearchOptions.getCurrentPane());
        boolean bl3 = bl2 = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        if (paneType == IViewerWindow.PaneType.Outline) {
            bl = this.findInOutline(viewerItem, viewerSearchOptions, pattern, n);
            if (viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.outline) {
                if (!bl && !bl2) {
                    viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
                    if (this.searchableItem(viewerItem, viewerSearchOptions)) {
                        viewerSearchOptions.setItemDone(false);
                        viewerSearchOptions.setOffset(0);
                        bl = this.findInContent(viewerItem, viewerSearchOptions, pattern, n);
                    }
                    if (!bl) {
                        viewerSearchOptions.setItemDone(true);
                    }
                }
            } else if (!bl) {
                viewerSearchOptions.setItemDone(true);
            }
        } else {
            bl = this.findInContent(viewerItem, viewerSearchOptions, pattern, n);
            if (viewerSearchOptions.getPaneSelection() != ViewerSearchOptions.PaneSelection.contents) {
                if (!bl && bl2) {
                    viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
                    if (this.searchableItem(viewerItem, viewerSearchOptions)) {
                        viewerSearchOptions.setItemDone(false);
                        viewerSearchOptions.setOffset(0);
                        bl = this.findInOutline(viewerItem, viewerSearchOptions, pattern, n);
                    }
                    if (!bl) {
                        viewerSearchOptions.setItemDone(true);
                    }
                }
            } else if (!bl) {
                viewerSearchOptions.setItemDone(true);
            }
        }
        if (bl && viewerSearchOptions.getCurrentPane() == IViewerWindow.PaneType.Content && !viewerItem.isVisible() && !(viewerItem instanceof HeaderViewerItem) && viewerSearchOptions.getIncludeHidden()) {
            viewerItem.setVisible(true);
            viewerSearchOptions.setPreviouslyHiddenItem(viewerItem);
        }
        return bl;
    }

    private boolean findInOutline(ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions, Pattern pattern, int n) {
        boolean bl;
        boolean bl2 = false;
        viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
        this.mWindow.commitEdits(viewerSearchOptions);
        viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
        String string = this.mWindow.getOutlineTitle(viewerItem);
        Matcher matcher = pattern.matcher(string);
        boolean bl3 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        if (bl) {
            if (!viewerSearchOptions.getItemDone() && viewerSearchOptions.getOffset() == 0) {
                viewerSearchOptions.setOffset(string.length());
            }
            if (bl2 = this.reverseFind(matcher, viewerSearchOptions)) {
                this.mWindow.activateAndSelect(viewerSearchOptions, n);
                if (viewerSearchOptions.getOffset() == 0) {
                    viewerSearchOptions.setItemDone(true);
                }
            } else {
                this.mWindow.commitEdits(viewerSearchOptions);
                viewerSearchOptions.setItemDone(true);
            }
        } else {
            int n2 = viewerSearchOptions.getOffset();
            if (n2 < string.length() && matcher.find(n2)) {
                bl2 = true;
                viewerSearchOptions.setOffset(matcher.start());
                this.mWindow.activateAndSelect(viewerSearchOptions, n);
                viewerSearchOptions.setOffset(matcher.end());
            } else {
                this.mWindow.commitEdits(viewerSearchOptions);
                viewerSearchOptions.setItemDone(true);
            }
        }
        return bl2;
    }

    private boolean findInContent(ViewerItem viewerItem, ViewerSearchOptions viewerSearchOptions, Pattern pattern, int n) {
        boolean bl;
        block15: {
            LightTableViewerItem lightTableViewerItem;
            block18: {
                boolean bl2;
                block16: {
                    TableViewerItem tableViewerItem;
                    block17: {
                        block13: {
                            block14: {
                                if (viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem || viewerItem instanceof TreeModelViewerItem || viewerItem instanceof ModelViewerItem || viewerItem instanceof ImageViewerItem || viewerItem instanceof JsonChartViewerItem || viewerItem instanceof GenericViewerItem) {
                                    return false;
                                }
                                bl = false;
                                boolean bl3 = bl2 = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
                                if (!(viewerItem instanceof TextViewerItem)) break block13;
                                TextViewerItem textViewerItem = (TextViewerItem)viewerItem;
                                bl = textViewerItem.findPattern(pattern, viewerSearchOptions);
                                if (!bl) break block14;
                                this.mWindow.activateAndSelect(viewerSearchOptions, n);
                                if (bl2) break block15;
                                viewerSearchOptions.setOffset(viewerSearchOptions.getOffset() + n);
                                break block15;
                            }
                            if (!viewerSearchOptions.getInitiatedFromInPlaceEdit()) {
                                this.mWindow.commitEdits(viewerSearchOptions);
                            }
                            viewerSearchOptions.setItemDone(true);
                            break block15;
                        }
                        if (!(viewerItem instanceof TableViewerItem)) break block16;
                        tableViewerItem = (TableViewerItem)viewerItem;
                        try {
                            bl = viewerSearchOptions.getTableSearcher().findPattern(tableViewerItem, pattern, viewerSearchOptions, n);
                        }
                        catch (VisualizationException visualizationException) {
                            visualizationException.printStackTrace();
                        }
                        if (!bl) break block17;
                        if (tableViewerItem.getDataFilterInfo().isDisplayFiltering() && tableViewerItem.getDataFilterInfo().getTotalPageCount() > 0) {
                            tableViewerItem.endEdit();
                            tableViewerItem.setInplaceMode(true);
                            ((ViewerOutputPane)tableViewerItem.getParent()).startEdit(tableViewerItem);
                            try {
                                bl = viewerSearchOptions.getTableSearcher().findPattern(tableViewerItem, pattern, viewerSearchOptions, n);
                            }
                            catch (VisualizationException visualizationException) {
                                visualizationException.printStackTrace();
                            }
                        }
                        this.mWindow.activateAndSelect(viewerSearchOptions, n);
                        if (bl2) break block15;
                        viewerSearchOptions.setOffset(viewerSearchOptions.getOffset() + n);
                        break block15;
                    }
                    if (!viewerSearchOptions.getInitiatedFromOutOfPlaceFrame()) {
                        if (!viewerSearchOptions.getInitiatedFromInPlaceEdit()) {
                            this.mWindow.commitEdits(viewerSearchOptions);
                            viewerSearchOptions.getTableSearcher().clear();
                        }
                    } else if (tableViewerItem.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
                        tableViewerItem.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit();
                    }
                    viewerSearchOptions.setItemDone(true);
                    break block15;
                }
                if (!(viewerItem instanceof LightTableViewerItem)) break block15;
                lightTableViewerItem = (LightTableViewerItem)viewerItem;
                bl = lightTableViewerItem.findPattern(pattern, viewerSearchOptions, n);
                if (!bl) break block18;
                this.mWindow.activateAndSelect(viewerSearchOptions, n);
                if (bl2) break block15;
                viewerSearchOptions.setOffset(viewerSearchOptions.getOffset() + n);
                break block15;
            }
            viewerSearchOptions.setItemDone(true);
            if (lightTableViewerItem.isInEditMode()) {
                Window[] windowArray;
                Point point = null;
                boolean bl4 = false;
                for (Window window : windowArray = viewerSearchOptions.getTopFrame().getOwnedWindows()) {
                    if (!(window instanceof ViewerFindDlg)) continue;
                    point = window.getLocation();
                    bl4 = ((ViewerFindDlg)((Object)window)).isReplaceChecked();
                    break;
                }
            }
        }
        return bl;
    }

    private boolean reverseFind(Matcher matcher, ViewerSearchOptions viewerSearchOptions) {
        boolean bl = false;
        int n = 0;
        int n2 = viewerSearchOptions.getOffset();
        if (n2 > -1) {
            while (matcher.find(n)) {
                int n3 = matcher.start();
                n = matcher.end();
                if (n3 >= n2) continue;
                bl = true;
                viewerSearchOptions.setOffset(n3);
            }
        }
        if (!bl) {
            viewerSearchOptions.setItemDone(true);
        }
        return bl;
    }

    private boolean ancestorSelectedAndCollapsed(ViewerItem viewerItem) {
        IOutputItem iOutputItem = viewerItem.getCoreItem().getParentItem();
        if (iOutputItem == null) {
            return false;
        }
        ViewerItem viewerItem2 = this.getItemFromCoreItem(iOutputItem);
        if (viewerItem2 == null) {
            return false;
        }
        if (iOutputItem.isSelected() && viewerItem2.isCollapsed()) {
            return true;
        }
        return this.ancestorSelectedAndCollapsed(viewerItem2);
    }

    private boolean canConvertImageToBytes(int n, int n2) {
        return n <= 65500 && n2 <= 65500 && n * (n2 - 1) + n > 0;
    }

    private void handleScreenReader(ViewerItem viewerItem, ViewerItem viewerItem2) {
        String string = "";
        String string2 = "";
        if (this.mFocusedViewerItem instanceof TextViewerItem) {
            string = viewerItem instanceof TextViewerItem ? ((TextViewerItem)viewerItem).getPlainText() : "";
            string2 = ((TextViewerItem)viewerItem2).getPlainText();
            if (string2.length() == 0) {
                string2 = ResUtil.getString("IDS_VIEWER_ITEM_TREE");
            }
        } else if (this.mFocusedViewerItem instanceof LightTableViewerItem) {
            string = viewerItem instanceof LightTableViewerItem ? ((LightTableViewerItem)viewerItem).getCoreItem().getLightPivotTable().getTableSummary() : "";
            LightPivotTable lightPivotTable = ((LightTableViewerItem)viewerItem2).getCoreItem().getLightPivotTable();
            if (lightPivotTable != null && ((string2 = lightPivotTable.getTableSummary()) == null || string2.length() == 0)) {
                string2 = this.mFocusedViewerItem.getName();
            }
        } else if (this.mFocusedViewerItem instanceof ChartViewerItem) {
            string = viewerItem instanceof ChartViewerItem ? ChartViewerItemHelper.getGraphicTitleLabel(viewerItem) : "";
            string2 = ResUtil.getString("IDS_VIEWER_ITEM_CHART");
            if (ChartViewerItemHelper.getGraphicTitleLabel(this.mFocusedViewerItem).length() != 0) {
                string2 = string2 + ResUtil.getString("IDS_WITH_TITLE") + ChartViewerItemHelper.getGraphicTitleLabel(this.mFocusedViewerItem);
            }
        } else if (this.mFocusedViewerItem instanceof ModelViewerItem) {
            string = viewerItem instanceof ModelViewerItem ? ResUtil.getString("IDS_VIEWER_ITEM_MODELVIEWER") : "";
            string2 = ResUtil.getString("IDS_VIEWER_ITEM_MODELVIEWER");
        } else if (this.mFocusedViewerItem instanceof GraphBoardViewerItem) {
            string = viewerItem instanceof ModelViewerItem ? ResUtil.getString("IDS_VIEWER_ITEM_GRAPHBOARD") : "";
            string2 = ResUtil.getString("IDS_VIEWER_ITEM_GRAPHBOARD");
        } else if (this.mFocusedViewerItem instanceof TreeModelViewerItem) {
            string = viewerItem instanceof ModelViewerItem ? ResUtil.getString("IDS_VIEWER_ITEM_DECISION_TREE") : "";
            string2 = ResUtil.getString("IDS_VIEWER_ITEM_DECISION_TREE");
        }
        this.mFocusedViewerItem.getAccessibleContext().setAccessibleName(string2);
        this.mFocusedViewerItem.getAccessibleContext().firePropertyChange("AccessibleName", string, string2);
    }

    public static enum ComponentType {
        header,
        title,
        pageTitle,
        table,
        ltable,
        notes,
        chart,
        tree,
        text,
        log,
        warning,
        generic,
        model,
        graphboard,
        image,
        jsonChart,
        unknown,
        baseEnd;

    }
}

