/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.treemodel.ITreeModelItemUIAgent;
import com.spss.java_client.core.documents.output.treemodel.TreeModelItem;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.shared.core_tools.utils.ZipUtil;
import com.spss.treemodeleditor.TreeEditor;
import com.spss.uitools.util.IUpdater;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import javax.swing.JComponent;

public class TreeModelViewerItem
extends ViewerItem
implements ITreeModelItemUIAgent {
    private TreeModelItem mTreeModelItem = null;
    private TreeEditor mEditor = null;
    private ViewerImage mImage = new ViewerImage();

    public TreeModelViewerItem(IOutputItem iOutputItem, String string) {
        super(iOutputItem);
        this.mTreeModelItem = (TreeModelItem)iOutputItem;
        this.setName(string);
        iOutputItem.setDescription(string);
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.tree;
    }

    @Override
    public boolean startEdit() {
        if (this.mEditor != null && this.isInEditMode()) {
            this.mEditor.getFrame().toFront();
            return false;
        }
        boolean bl = super.startEdit();
        if (!bl) {
            return false;
        }
        try {
            this.mEditor = new TreeEditor((IUpdater)this, VersionInfo.allowSyntax(), VersionInfo.isSmartReader());
            this.mEditor.setSchemaPath(System.getProperty("application.home"));
            this.mEditor.setForModeler(CommandLine.isClementineCaller());
            TreeModelItem treeModelItem = this.getTreeModelItem();
            ByteBuffer byteBuffer = treeModelItem.getCompressedXML();
            byte[] byArray = ZipUtil.decompressBytes((byte[])treeModelItem.getDisplayData());
            this.mEditor.renderPMMLToScreen(200, 200, treeModelItem.getWidth(), treeModelItem.getHeight(), byteBuffer.array(), byArray);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.mEditor.getFrame().addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TreeModelViewerItem.this.endEdit();
            }
        });
        return bl;
    }

    @Override
    public void endEdit() {
        if (this.mEditor == null || !this.isInEditMode()) {
            return;
        }
        try {
            Object object;
            this.mEditor.deActivate();
            boolean bl = false;
            if (this.mEditor.needsRerendering()) {
                object = this.getTreeModelItem();
                byte[] byArray = this.mEditor.extractDisplayData();
                if (byArray.length > 0) {
                    object.setDisplayData(ZipUtil.compressBytes((byte[])byArray));
                }
                this.refreshItem();
                bl = true;
            }
            object = (ViewerOutputPane)this.getParent();
            ((ViewerOutputPane)object).handleSelectionChange(this, false);
            ((JComponent)object).scrollRectToVisible(this.getBounds());
            if (bl) {
                ((ViewerOutputPane)object).setDocumentModifiedFlag(bl);
            }
            this.mEditor.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mEditor = null;
        super.endEdit();
    }

    public TreeModelItem getTreeModelItem() {
        return this.mTreeModelItem;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            bufferedImage = this.refreshItem();
        }
        graphics2D.drawImage(bufferedImage, null, 1, 1);
        if (this.isInEditMode()) {
            this.renderEditModeHatchPattern(graphics2D, this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
        }
    }

    @Override
    public void applySizeChange(int n, int n2) {
        this.setSize(n, n2, 1L);
        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
        viewerOutputPane.setDocumentModifiedFlag(true);
    }

    public void setSize(long l, long l2, long l3) {
        long[] lArray;
        TreeEditor treeEditor = this.mEditor;
        if (treeEditor == null) {
            treeEditor = new TreeEditor(VersionInfo.allowSyntax(), VersionInfo.isSmartReader());
        }
        if ((lArray = treeEditor.calculateSizeArray(ZipUtil.decompressBytes((byte[])this.mTreeModelItem.getCompressedXML().array()), ZipUtil.decompressBytes((byte[])this.mTreeModelItem.getDisplayData()))).length > 1) {
            double d = (double)l / (double)lArray[0];
            double d2 = (double)l2 / (double)lArray[1];
            double d3 = d > d2 ? d2 : d;
            int n = (int)Math.round(d3 * 100.0);
            this.mTreeModelItem.setZoom(n);
            this.refreshItem();
            this.revalidate();
        }
    }

    @Override
    protected void resize(Point point) {
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null) {
            try {
                TreeModelItem treeModelItem;
                long[] lArray;
                TreeEditor treeEditor = this.mEditor;
                if (treeEditor == null) {
                    treeEditor = new TreeEditor(VersionInfo.allowSyntax(), VersionInfo.isSmartReader());
                }
                if ((lArray = treeEditor.calculateSizeArray(ZipUtil.decompressBytes((byte[])(treeModelItem = this.getTreeModelItem()).getCompressedXML().array()), ZipUtil.decompressBytes((byte[])treeModelItem.getDisplayData()))).length > 1) {
                    double d = (double)rectangle.width / (double)lArray[0];
                    double d2 = (double)rectangle.height / (double)lArray[1];
                    double d3 = d > d2 ? d2 : d;
                    int n = (int)(d3 * 100.0);
                    treeModelItem.setZoom(n);
                    this.refreshItem();
                    this.revalidate();
                    ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
                    viewerDocument.setFocusedViewerItem(this);
                    viewerDocument.getCoreDocument().setModifiedFlag(true);
                    viewerDocument.notifyChangedModifiedFlag();
                    ((ViewerOutputPane)this.getParent()).handleSelectionChange(this, false);
                    ((ViewerOutputPane)this.getParent()).resetFeedback();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.resize(point);
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return new Dimension(500, 500);
        }
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void closeEditorWindow() {
        if (this.mEditor != null) {
            this.mEditor.close();
            this.mEditor = null;
        }
    }

    private BufferedImage refreshItem() {
        ImageCache.getImageCache().remove(this.mImage);
        Container container = this.getTopLevelAncestor();
        container.setCursor(Cursor.getPredefinedCursor(3));
        TreeModelItem treeModelItem = this.getTreeModelItem();
        ImageGenerator2.ImageContainer imageContainer = ImageGenerator2.getImageGenerator().generateImage(this);
        BufferedImage bufferedImage = imageContainer.get();
        boolean bl = imageContainer.isComplete();
        this.mImage = new ViewerImage(this, bufferedImage, bl, false);
        treeModelItem.setWidth(bufferedImage.getWidth() + 2);
        treeModelItem.setHeight(bufferedImage.getHeight() + 2);
        Dimension dimension = new Dimension(treeModelItem.getWidth(), treeModelItem.getHeight());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        container.setCursor(null);
        return bufferedImage;
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            this.mCoreItem.setWidth(bufferedImage.getWidth() + 2);
            this.mCoreItem.setHeight(bufferedImage.getHeight() + 2);
            Dimension dimension = new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.revalidate();
        }
    }

    @Override
    public void refreshContent() {
        Dimension dimension = new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.repaint();
        this.revalidate();
    }

    public void setRendering(boolean bl) {
        if (this.mEditor != null) {
            this.mEditor.setNeedsRerendering(bl);
        }
    }
}

