/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.OutputItemAlignment;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.modify.ModifyOutputHandler;
import com.spss.java_client.core.documents.output.text.DefaultTextFontInfo;
import com.spss.java_client.core.documents.output.text.ITextItemUIAgent;
import com.spss.java_client.core.documents.output.text.TextItem;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.ThinMenuBarBorder;
import com.spss.java_client.ui.doc_types.output.LogViewerItem;
import com.spss.java_client.ui.doc_types.output.PageTitleViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.java_client.ui.texteditor.actions.TextActionMgr;
import com.spss.java_client.ui.texteditor.bars.TextFormatBar;
import com.spss.java_client.ui.texteditor.bars.TextMainBar;
import com.spss.java_client.ui.texteditor.menus.EditMenu;
import com.spss.java_client.ui.texteditor.menus.FormatMenu;
import com.spss.java_client.ui.texteditor.menus.InsertMenu;
import com.spss.java_client.ui.texteditor.menus.ViewMenu;
import com.spss.java_client.ui.texteditor.resources.TextEditorResBundle;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.toolbar.MultiDockToolBarUI;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;

public class TextViewerItem
extends ViewerItem
implements ITextItemUIAgent {
    protected static final int STANDARD_WIDTH = 500;
    protected static final Pattern sPat02 = Pattern.compile("<html>", 2);
    protected static final Pattern sPat03 = Pattern.compile("</html>", 2);
    protected static final Pattern sPat04 = Pattern.compile("<p", 2);
    protected static final Pattern sPat05 = Pattern.compile("</p>", 2);
    protected static final Pattern sPat06 = Pattern.compile("<br */>", 2);
    protected static final Pattern sPat08 = Pattern.compile("<br style=\"page-break-before:always\"/>", 18);
    protected static final Pattern sPat09 = Pattern.compile("<body>\n*", 2);
    protected static final Pattern sPat10 = Pattern.compile("</body>", 2);
    protected static final Pattern sPat11 = Pattern.compile("</head> *<br> *<p>\n?", 2);
    protected static final Pattern sPat12 = Pattern.compile("</head> *<br>\n?", 2);
    protected static final Pattern sPat13 = Pattern.compile("<br page-break-before=\"always\">", 18);
    protected static final int MAX_HTML_LENGTH = 10000;
    protected SpssTextPane mTextCtrl = new SpssTextPane();
    protected JScrollPane mTextScroller;
    private TextEditorFrame mEditor;
    private TextMainBar mMainToolBar;
    private TextFormatBar mFormatToolbar;
    private JPanel mInEditToolBarPanel = null;
    private JPanel mSpssToolbarPanel;
    private Preferences mRootPrefs;
    private KeyAdapter mEditKeyAdapter = null;
    private boolean mUserInitiatedEditing = false;
    private Font mDefaultFont = null;

    public TextViewerItem(IOutputItem iOutputItem, String string, String string2) {
        super(iOutputItem);
        Object object;
        this.mTextCtrl.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b' && keyEvent.getID() == 400) {
                    TextViewerItem.this.endEdit();
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n = TextViewerItem.this.mTextCtrl.getCaretPosition();
                String string = TextViewerItem.this.extractPlainText();
                int n2 = string.indexOf(58);
                if (n2 != -1 && n2 > 0 && Character.isLetter(string.charAt(n2 - 1)) && (n2 - 1 == 0 || Character.isWhitespace(string.charAt(n2 - 2)) || ComponentState.isNonBreakingSpace((char)string.charAt(n2 - 2)))) {
                    --n2;
                } else {
                    n2 = string.indexOf(File.pathSeparatorChar);
                    if (n2 == -1 || n2 + 1 >= string.length() || string.charAt(n2 + 1) != File.pathSeparatorChar || n2 != 0 && !Character.isWhitespace(string.charAt(n2 - 1)) && !ComponentState.isNonBreakingSpace((char)string.charAt(n2 - 1))) {
                        n2 = -1;
                    }
                }
                String string2 = null;
                if (n2 != -1) {
                    if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                        string2 = n <= string.length() ? (n > 0 && new Character(string.charAt(n - 2)).equals(Character.valueOf('\u200e')) ? string.substring(0, n - 2) + string.substring(n - 1) : string) : (new Character(string.charAt(string.length() - 1)).equals(Character.valueOf('\u200e')) ? string.substring(0, string.length() - 1) : string);
                        TextViewerItem.this.setText(string2);
                        TextViewerItem.this.mTextCtrl.setCaretPosition(n - 1);
                    } else if (keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 37 && keyEvent.getKeyCode() != 39) {
                        if (Character.toString(keyEvent.getKeyChar()).equals(System.getProperty("file.separator")) && string.length() > 2) {
                            if (n <= string.length()) {
                                if (Character.toString(string.charAt(n - 1)).equals(System.getProperty("file.separator"))) {
                                    string2 = n == 1 ? '\u200e' + string.substring(0) : string.substring(0, n - 1) + '\u200e' + string.substring(n - 1);
                                }
                            } else {
                                string2 = string.substring(0, string.length() - 1) + '\u200e' + System.getProperty("file.separator");
                            }
                            TextViewerItem.this.setText(string2);
                            TextViewerItem.this.mTextCtrl.setCaretPosition(n + 1);
                        }
                    } else if (keyEvent.getKeyCode() == 37 && (keyEvent.getModifiersEx() & 0x40) == 0) {
                        if (n <= string.length()) {
                            if (n > 1 && string.charAt(n - 1) == '\u200e') {
                                TextViewerItem.this.mTextCtrl.setCaretPosition(string.lastIndexOf(System.getProperty("file.separator"), n - 1) + 1);
                            }
                        } else {
                            TextViewerItem.this.mTextCtrl.setCaretPosition(string.lastIndexOf(System.getProperty("file.separator"), string.length() - 1) + 1);
                        }
                    }
                }
            }
        });
        this.mTextCtrl.setAlignmentEnabled(false);
        this.mTextCtrl.removeUndoableEditListener();
        this.setName(string);
        iOutputItem.setDescription(string);
        if (string2 == null) {
            return;
        }
        boolean bl = !string2.startsWith("<html>") && !string2.contains("</font>") && !string2.contains("</BODY>") && !string2.trim().endsWith("</HTML>");
        this.setDefaultTextStyles();
        if (string2.length() > 0) {
            if (bl) {
                this.mTextCtrl.useHTMLDocument(false);
                object = this.extractPlainText(string2);
                if (((String)object).startsWith("\n")) {
                    object = ((String)object).substring(1);
                }
                if (this.getComponentType() == ViewerDocument.ComponentType.text) {
                    this.mTextCtrl.setSoftWrap(false);
                }
                if ((object = this.handleSpaceChar((String)object)) != null && ((String)object).length() > 0) {
                    if (((String)object).contains(CoreResUtil.getDataSetName())) {
                        int n = ((String)object).indexOf(93);
                        if (n != -1) {
                            String string3;
                            ++n;
                            while (n < ((String)object).length() && (Character.isWhitespace(((String)object).charAt(n)) || ComponentState.isNonBreakingSpace((char)((String)object).charAt(n)))) {
                                ++n;
                            }
                            if (n < ((String)object).length() && ComponentState.isDirOrFilePath((String)(string3 = ((String)object).substring(n))) && ComponentState.isPathBidiProcessingNeeded((String)string3)) {
                                object = ((String)object).substring(0, n) + ComponentState.preparePathForBidiDisplay((String)string3);
                            }
                        }
                        this.mTextCtrl.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    } else if (ComponentState.containsBidiLetter((String)object)) {
                        object = string.equalsIgnoreCase("Log") ? LogViewerItem.prepareLogTextForBidiDisplay((String)object) : ComponentState.prepareStringForBidiRendering((String)object);
                    }
                }
                this.setPlainText((String)object);
            } else {
                this.setText(string2.replace("\\\"", "\""));
                this.mTextCtrl.setFont(this.mTextCtrl.getFont().deriveFont(14.0f));
                this.setWebContents(string2);
            }
        }
        object = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        this.mRootPrefs = ((Preferences)object).node("texteditor");
        this.setInplaceMode(true);
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.text;
    }

    public void setInitialPosition() {
        Rectangle rectangle = this.getBounds();
        if (rectangle.isEmpty()) {
            rectangle = new Rectangle(this.mTextCtrl.getPreferredSize());
        }
        if (this.mCoreItem.getWidth() > 0) {
            rectangle.width = this.mCoreItem.getWidth();
        } else {
            this.mCoreItem.setWidth(rectangle.width);
        }
        this.mCoreItem.setHeight(rectangle.height);
        this.mTextCtrl.setSize(rectangle.getSize());
        this.mTextCtrl.setPreferredSize(null);
        Dimension dimension = this.mTextCtrl.getPreferredSize();
        this.mTextCtrl.setPreferredSize(new Dimension(rectangle.width, dimension.height));
        this.setPreferredSize(new Dimension(rectangle.width, dimension.height));
        this.positionTextControl();
        this.invalidate();
    }

    public TextEditorFrame getTextFrame() {
        if (this.mEditor == null) {
            this.mEditor = new TextEditorFrame(this.mTextCtrl);
            URL uRL = UIToolResUtil.getImageResourceFullPath((String)(TextEditorResBundle.getImageResourceFullPath() + "text_editor.png"));
            if (uRL != null) {
                this.mEditor.setIconImage(new ImageIcon(uRL).getImage());
            }
        }
        return this.mEditor;
    }

    public String getText() {
        String string = this.mTextCtrl.getText();
        if (string == null || string.length() == 0) {
            return string;
        }
        if (!string.startsWith("<html>")) {
            String string2 = this.extractPlainText();
            if (string2 != null && string2.length() > 0 && string2.charAt(0) == '\n') {
                string2 = string2.substring(1, string2.length());
            }
            return string2;
        }
        return string;
    }

    public String getPlainText() {
        String string = this.extractPlainText();
        if (string != null && string.length() > 0 && string.charAt(0) == '\n') {
            string = string.substring(1, string.length());
        }
        return string;
    }

    public void setText(String string) {
        Object object;
        Serializable serializable;
        Object object2;
        if (string.startsWith("{\\rtf") && string.endsWith("}")) {
            object2 = new StringReader(string);
            try {
                serializable = new DefaultStyledDocument();
                new RTFEditorKit().read((Reader)object2, (Document)((Object)serializable), 0);
                object = new ByteArrayOutputStream(((AbstractDocument)serializable).getLength());
                new HTMLEditorKit().write((OutputStream)object, (Document)((Object)serializable), 0, ((AbstractDocument)serializable).getLength());
                string = ((ByteArrayOutputStream)object).toString();
            }
            catch (Exception exception) {}
        } else if (!string.startsWith("<html>")) {
            this.setPlainText(string);
            return;
        }
        try {
            Matcher matcher;
            this.mTextCtrl.useHTMLDocument(true);
            this.mTextCtrl.setPreferredSize(null);
            object2 = new StringBuffer(string);
            object = sPat02.matcher((CharSequence)object2);
            if (((Matcher)object).find()) {
                serializable = new StringBuffer();
                ((Matcher)object).appendReplacement((StringBuffer)serializable, "");
                object2 = ((Matcher)object).appendTail((StringBuffer)serializable);
            }
            if ((matcher = sPat03.matcher((CharSequence)object2)).find()) {
                serializable = new StringBuffer();
                matcher.appendReplacement((StringBuffer)serializable, "");
                object2 = matcher.appendTail((StringBuffer)serializable);
            }
            ((StringBuffer)object2).insert(0, "<html>");
            object2 = this.cleanText((StringBuffer)object2);
            boolean bl = false;
            Matcher matcher2 = sPat11.matcher((CharSequence)object2);
            if (matcher2.find()) {
                serializable = new StringBuffer();
                matcher2.appendReplacement((StringBuffer)serializable, "</head><p>\n");
                object2 = matcher2.appendTail((StringBuffer)serializable);
            } else {
                Matcher matcher3 = sPat12.matcher((CharSequence)object2);
                if (matcher3.find()) {
                    bl = true;
                    serializable = new StringBuffer();
                    matcher3.appendReplacement((StringBuffer)serializable, "</head><p>\n");
                    object2 = matcher3.appendTail((StringBuffer)serializable);
                }
            }
            if (bl) {
                ((StringBuffer)object2).append("</p>\n");
            }
            ((StringBuffer)object2).append("</html>");
            int n = ((StringBuffer)object2).indexOf("</head>");
            if (n > -1) {
                int n2 = n + 7;
                n2 = ((StringBuffer)object2).indexOf("\n\n", n2);
                while (n2 > -1) {
                    object2 = ((StringBuffer)object2).replace(n2, n2 + 2, "\n");
                    n2 = ((StringBuffer)object2).indexOf("\n\n", n2 + 5);
                }
            }
            String string2 = ((StringBuffer)object2).toString();
            this.mTextCtrl.setText(string2);
            ((TextItem)this.mCoreItem).setContents(string2);
            this.mTextCtrl.invalidate();
            this.validate();
            Dimension dimension = this.getPreferredSize();
            if (!(this.getParent() != null || this.getComponentType().equals((Object)ViewerDocument.ComponentType.text) && dimension.width >= 500)) {
                dimension.width = 500;
            }
            this.mTextCtrl.setPreferredSize(new Dimension(dimension.width, dimension.height));
            this.setPreferredSize(new Dimension(dimension.width + 3, dimension.height + 3));
            this.positionTextControl();
            this.invalidate();
            this.repaint(200L);
            this.mTextCtrl.select(1, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void AppendText(String string) {
        if (this instanceof LogViewerItem) {
            LogViewerItem logViewerItem = (LogViewerItem)this;
            logViewerItem.append(string);
        }
    }

    public void setPlainText(String string) {
        this.mTextCtrl.setPreferredSize(null);
        this.mTextCtrl.setText(string);
        this.mTextCtrl.invalidate();
        this.validate();
        Dimension dimension = this.getPreferredSize();
        if (!(this.getParent() != null || this.getComponentType().equals((Object)ViewerDocument.ComponentType.text) && dimension.width >= 500)) {
            dimension.width = 500;
        }
        this.mTextCtrl.setPreferredSize(new Dimension(dimension.width, dimension.height));
        this.setPreferredSize(new Dimension(dimension.width + 3, dimension.height + 3));
        this.positionTextControl();
        this.invalidate();
        this.repaint(200L);
        this.mTextCtrl.select(1, 1);
    }

    @Override
    public void initiateEditing() {
        super.initiateEditing();
        this.mUserInitiatedEditing = true;
        if (this.isInEditMode()) {
            this.mTextCtrl.requestFocus();
        }
    }

    @Override
    public boolean startEdit() {
        if (this.isInEditMode()) {
            return false;
        }
        this.mTextCtrl.setSoftWrap(true);
        this.setUseHtmlDocument();
        this.checkForInEditToolBarPanel();
        this.mTextCtrl.addUndoableEditListener();
        this.mTextCtrl.addCaretListener(this.mTextCtrl);
        boolean bl = super.startEdit();
        if (bl) {
            bl = this.isInPlaceMode() ? this.activateEdit() : this.activateOpen();
        }
        return bl;
    }

    public void setUseHtmlDocument() {
        if (!this.mTextCtrl.isHTMLDocument()) {
            if (this.mTextCtrl.getDocument().getLength() < 10000) {
                this.changeToHTML();
            } else {
                TraceSettings.trace1((String)"-> *NOT* switching to HTML document for text editing", (int)15);
                SpssAlertOptionPane.showPlainMessageDialog(this, ResUtil.getString("IDS_LARGE_TEXT_WARNING_MSG"), VersionInfo.getAppVersionString());
            }
        }
    }

    protected String handleSpaceChar(String string) {
        if (!this.mTextCtrl.getFont().canDisplay(160)) {
            String string2 = string;
            string2 = string2.replace("\u00a0", " ");
            string2 = string2.replace("&nbsp;", " ");
            return string2;
        }
        return string;
    }

    protected String handleBidiPath(String string) {
        if (string == null || string.length() == 0 || !string.contains("FILE=")) {
            return string;
        }
        String string2 = null;
        int n = string.indexOf(39);
        int n2 = -1;
        if (n != -1 && (n2 = string.indexOf(39, ++n)) != -1 && n2 < string.length()) {
            string2 = string.substring(n, n2);
        }
        if (string2 == null || string2.length() == 0 || !ComponentState.isPathBidiProcessingNeeded((String)string2)) {
            return string;
        }
        return string.substring(0, n) + ComponentState.preparePathForBidiDisplay((String)string2) + string.substring(n2);
    }

    protected void changeToHTML() {
        if (this.mTextCtrl.isHTMLDocument()) {
            return;
        }
        this.mTextCtrl.selectAll();
        String string = this.mTextCtrl.getSelectedText();
        if (this.mDefaultFont != null) {
            this.mTextCtrl.setFont(this.mDefaultFont);
        } else {
            this.mTextCtrl.setFont(this.mTextCtrl.getFont().deriveFont(14.0f));
        }
        this.mTextCtrl.useHTMLDocument(true);
        Insets insets = (Insets)this.mTextCtrl.getMargin().clone();
        insets.left = 4;
        insets.bottom = 4;
        this.mTextCtrl.setMargin(insets);
        if (string == null) {
            string = "";
        }
        this.setText(((TextItem)this.mCoreItem).makeHTMLFromPlainText(string));
        this.mTextCtrl.selectAll();
        MutableAttributeSet mutableAttributeSet = this.getTextPane().getInputAttributes();
        float f = StyleConstants.getLineSpacing(mutableAttributeSet);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(simpleAttributeSet, f *= 0.8f);
        DefaultTextFontInfo defaultTextFontInfo = this.getOptionViewerFont();
        StyleConstants.setFontFamily(simpleAttributeSet, defaultTextFontInfo.getFontName());
        StyleConstants.setItalic(simpleAttributeSet, defaultTextFontInfo.isItalic());
        StyleConstants.setBold(simpleAttributeSet, defaultTextFontInfo.isBold());
        StyleConstants.setUnderline(simpleAttributeSet, defaultTextFontInfo.isUnderline());
        StyleConstants.setForeground(simpleAttributeSet, TextItem.getColor((int)defaultTextFontInfo.getFontColor()));
        StyleConstants.setFontSize(simpleAttributeSet, defaultTextFontInfo.getFontSize());
        this.mTextCtrl.setParagraphAttributes(simpleAttributeSet, false);
        this.mTextCtrl.select(1, 1);
    }

    public boolean activateText() {
        this.initiateEditing();
        return true;
    }

    @Override
    public void endEdit() {
        if (!this.isInEditMode()) {
            return;
        }
        if (this.isInPlaceEdit()) {
            this.deactivateEdit();
        } else {
            this.deactivateOpen();
        }
        this.mUserInitiatedEditing = false;
        this.mTextCtrl.removeUndoableEditListener();
        this.mTextCtrl.removeCaretListener(this.mTextCtrl);
        super.endEdit();
    }

    public void deactivateText() {
        if (!this.isInEditMode()) {
            return;
        }
        this.deactivateEdit();
        this.mUserInitiatedEditing = false;
        this.mTextCtrl.removeUndoableEditListener();
        super.endEdit();
    }

    public boolean activateOpen() {
        boolean bl = false;
        try {
            ((ViewerOutputPane)this.getParent()).hideSearchWindow();
            this.mTextScroller = new JScrollPane(this.mTextCtrl);
            this.getTextFrame().add(this.mTextScroller);
            this.getTextFrame().setItemName(this.mCoreItem.getDescription());
            this.getTextFrame().applyPreferences(this.mRootPrefs);
            this.getTextFrame().setVisible(true);
            this.mTextCtrl.getCaret().setVisible(true);
            this.mEditor.updateFormatBar(this);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getTextFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TextViewerItem.this.endEdit();
            }
        });
        return bl;
    }

    public void deactivateOpen() {
        boolean bl = this.mEditor.wasSearchWindowOpen();
        this.mTextCtrl.select(1, 1);
        this.commitText();
        this.getTextFrame().remove(this.mTextScroller);
        this.mTextScroller.remove(this.mTextCtrl);
        this.mTextScroller = null;
        this.getTextFrame().exit();
        this.adjustHeight(this.getBounds());
        this.positionTextControl();
        this.invalidate();
        this.getFocusCycleRootAncestor().validate();
        this.repaint();
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ViewerOutputPane)TextViewerItem.this.getParent()).reparentSearchWindow();
                }
            });
        }
    }

    public boolean activateEdit() {
        super.startEdit();
        this.setInPlaceEdit(true);
        this.add(this.mTextCtrl);
        this.positionTextControl();
        this.updateViewerFrameMenus(true);
        this.updateViewerFrameToolBars(true);
        this.getTextFrame().applyPreferences(this.mRootPrefs);
        this.validate();
        this.mTextCtrl.getCaret().setVisible(true);
        this.mTextCtrl.setCaretPosition(this.mTextCtrl.getDocument().getLength());
        if (this.mEditKeyAdapter == null) {
            this.mEditKeyAdapter = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 114) {
                        ViewerFindDlg viewerFindDlg = null;
                        if (TextViewerItem.this.mUserInitiatedEditing) {
                            viewerFindDlg = TextViewerItem.this.getTextFrame().getFindReplaceDlg();
                        } else {
                            Container container = TextViewerItem.this.getTopLevelAncestor();
                            if (container instanceof ViewerFrame) {
                                ViewerFrame viewerFrame = (ViewerFrame)container;
                                viewerFindDlg = viewerFrame.getSearchDialog();
                            }
                        }
                        if (viewerFindDlg != null && viewerFindDlg.getLastFindValue().length() > 0) {
                            viewerFindDlg.findNext();
                        }
                        keyEvent.consume();
                    } else if (TextViewerItem.this.isInPlaceEdit()) {
                        TextViewerItem.this.adjustHeight(TextViewerItem.this.getBounds());
                        if (keyEvent.getKeyChar() == '\n') {
                            Dimension dimension = TextViewerItem.this.mTextCtrl.getPreferredSize();
                            Graphics graphics = TextViewerItem.this.getGraphics();
                            FontMetrics fontMetrics = graphics.getFontMetrics();
                            dimension.height = (int)((double)dimension.height + (fontMetrics.getMaxCharBounds(graphics).getHeight() + (double)fontMetrics.getLeading() + 2.0));
                            graphics.dispose();
                            TextViewerItem.this.mCoreItem.setHeight(dimension.height);
                            TextViewerItem.this.mTextCtrl.setSize(dimension.width - 3, dimension.height - 3);
                            TextViewerItem.this.mTextCtrl.setPreferredSize(new Dimension(dimension.width, dimension.height));
                            TextViewerItem.this.setPreferredSize(new Dimension(dimension.width, dimension.height));
                        }
                    }
                }
            };
        }
        this.mTextCtrl.addKeyListener(this.mEditKeyAdapter);
        return true;
    }

    public void deactivateEdit() {
        super.endEdit();
        this.getTextFrame().savePreferences(this.mRootPrefs);
        try {
            this.mTextCtrl.select(1, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setInPlaceEdit(false);
        ViewerFindDlg viewerFindDlg = this.getTextFrame().getFindReplaceDlg();
        if (viewerFindDlg.isVisible()) {
            viewerFindDlg.setVisible(false);
        }
        this.commitText();
        this.remove(this.mTextCtrl);
        this.mTextCtrl.removeKeyListener(this.mEditKeyAdapter);
        this.updateViewerFrameMenus(false);
        this.updateViewerFrameToolBars(false);
        this.adjustHeight(this.getBounds());
        this.positionTextControl();
        this.invalidate();
        this.getFocusCycleRootAncestor().validate();
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((ViewerOutputPane)TextViewerItem.this.getParent()).handleSelectionChange(TextViewerItem.this, false);
            }
        });
    }

    public void commitText() {
        String string = this.mTextCtrl.getText();
        String string2 = ((TextItem)this.mCoreItem).getContents();
        if (!string2.equals(string)) {
            int n;
            int n2;
            int n3;
            int n4;
            this.mTextCtrl.getCaret().setVisible(false);
            StringBuffer stringBuffer = new StringBuffer(string);
            Matcher matcher = sPat04.matcher(stringBuffer);
            while (matcher.find() && (n4 = stringBuffer.indexOf(">", matcher.end())) != -1) {
                stringBuffer.replace(matcher.start(), n4 + 1, "");
                matcher = sPat04.matcher(stringBuffer);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            Matcher matcher2 = sPat05.matcher(stringBuffer);
            while (matcher2.find()) {
                matcher2.appendReplacement(stringBuffer2, "");
            }
            stringBuffer = matcher2.appendTail(stringBuffer2);
            boolean bl = false;
            int n5 = stringBuffer.indexOf("<body>");
            int n6 = n3 = n5 > -1 ? stringBuffer.indexOf("<font", n5) : -1;
            if (n5 > -1 && n3 == -1) {
                n2 = n5 + 6;
                n = stringBuffer.indexOf("</body>", n2);
                if (n2 > -1 && n > n2) {
                    CharSequence charSequence = stringBuffer.subSequence(n2, n);
                    HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
                    DefaultTextFontInfo defaultTextFontInfo = this.getOptionViewerFont();
                    hashMap.put(TextAttribute.FAMILY, defaultTextFontInfo.getFontName());
                    hashMap.put(TextAttribute.SIZE, Float.valueOf(defaultTextFontInfo.getFontSize()));
                    hashMap.put(TextAttribute.POSTURE, defaultTextFontInfo.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                    hashMap.put(TextAttribute.WEIGHT, defaultTextFontInfo.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                    if (defaultTextFontInfo.isUnderline()) {
                        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    }
                    hashMap.put(TextAttribute.FOREGROUND, TextItem.getColor((int)defaultTextFontInfo.getFontColor()));
                    String string3 = charSequence.toString().trim();
                    String string4 = TextItem.wrapInHTMLStyle(hashMap, (String)string3);
                    stringBuffer.replace(n2, n, "\n  " + string4 + "\n  ");
                    n3 = stringBuffer.indexOf("<font", n5);
                    bl = true;
                }
            }
            if (n3 > -1) {
                n3 = stringBuffer.indexOf(">", n3);
                if (n3 > -1 && n3 < n2) {
                    String string5 = "\n    ";
                    int n7 = stringBuffer.indexOf(string5, n3);
                    for (n2 = stringBuffer.indexOf("</font>", n3); n7 > -1 && n7 < n2; n2 -= 5) {
                        stringBuffer.replace(n7, n7 + 5, "");
                        n7 = stringBuffer.indexOf(string5, n3);
                    }
                    int n8 = stringBuffer.indexOf("\n", n3);
                    while (n8 > -1 && n8 < n2) {
                        stringBuffer.replace(n8, n8 + 1, "<br>");
                        n8 = stringBuffer.indexOf("\n", n3);
                        n2 += 3;
                    }
                }
                n2 = stringBuffer.indexOf("</font>");
                n = stringBuffer.indexOf(" ", n3);
                while (n > -1 && n < n2) {
                    stringBuffer.replace(n, n + 1, "\u00a0");
                    n = stringBuffer.indexOf(" ", n3);
                }
            }
            string = stringBuffer.toString();
            this.mTextCtrl.setText(string);
            this.setWebContents(string);
            ((TextItem)this.mCoreItem).setContents(string);
            if (this.mCoreItem.getAlignment() != OutputItemAlignment.Left) {
                this.applyAlignment();
            }
            this.mTextCtrl.invalidate();
            this.validate();
            Dimension dimension = this.getPreferredSize();
            this.mTextCtrl.setPreferredSize(new Dimension(dimension.width, dimension.height));
            this.setPreferredSize(new Dimension(dimension.width + 3, dimension.height + 3));
            this.positionTextControl();
            ((ViewerOutputPane)this.getParent()).invalidateItem(this);
            this.mTextCtrl.select(1, 1);
            ((ViewerOutputPane)this.getParent()).setDocumentModifiedFlag(true);
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewerDocument viewerDocument = ((ITopWindow)((Object)TextViewerItem.this.getTopLevelAncestor())).getViewerDocument();
                        ViewerItem[] viewerItemArray = viewerDocument.getSelectedItems(true);
                        TextViewerItem.this.setSelected(false);
                        ((ViewerOutputPane)TextViewerItem.this.getParent()).handleSelectionChange(TextViewerItem.this, false);
                        viewerDocument.selectionChanged(TextViewerItem.this, false, false);
                        for (ViewerItem viewerItem : viewerItemArray) {
                            viewerDocument.selectionChanged(viewerItem, true, true);
                        }
                        TextViewerItem.this.repaint(200L);
                    }
                });
            }
        }
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        graphics2D.translate(2, 2);
        this.mTextCtrl.paint(graphics2D);
        graphics2D.translate(-2, -2);
        if (this.isInEditMode() && !this.isInPlaceEdit()) {
            Dimension dimension = this.getPreferredSize();
            this.renderEditModeHatchPattern(graphics2D, dimension.width, dimension.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        try {
            Dimension dimension = (Dimension)this.mTextCtrl.getPreferredSize().clone();
            if (!this.mTextCtrl.isPreferredSizeSet()) {
                dimension.width += 4;
                Container container = this.getParent();
                if (container != null) {
                    this.setItemSize(dimension);
                }
            }
            dimension.height += 2;
            return dimension;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Dimension(500, 30);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = this.mTextCtrl.getMinimumSize();
        if (!this.isMinimumSizeSet()) {
            dimension.width = 500;
        }
        dimension.height += 2;
        return dimension;
    }

    public boolean findPattern(Pattern pattern, ViewerSearchOptions viewerSearchOptions) {
        boolean bl;
        boolean bl2 = false;
        if (viewerSearchOptions.isFirstSearch()) {
            this.saveSelections(viewerSearchOptions);
        }
        int n = this.mTextCtrl.getSelectionStart();
        int n2 = this.mTextCtrl.getSelectionEnd();
        if (viewerSearchOptions.getSearchArea() != SearchOptions.SearchArea.selected || !viewerSearchOptions.getInitiatedFromInPlaceEdit()) {
            this.mTextCtrl.selectAll();
            if (!viewerSearchOptions.getInitiatedFromInPlaceEdit()) {
                viewerSearchOptions.setStartSelection(0);
                viewerSearchOptions.setEndSelection(this.mTextCtrl.getDocument().getLength());
            }
        } else if (viewerSearchOptions.isFirstSearch()) {
            viewerSearchOptions.setFirstSearch(false);
        } else {
            this.mTextCtrl.select(viewerSearchOptions.getStartSelection(), viewerSearchOptions.getEndSelection());
        }
        String string = this.mTextCtrl.getSelectedText();
        string = string.replace("\u00a0", " ");
        this.mTextCtrl.select(n, n2);
        if (string == null || string.length() == 0) {
            viewerSearchOptions.setItemDone(true);
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        boolean bl3 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        if (bl) {
            if (!viewerSearchOptions.getItemDone() && viewerSearchOptions.getOffset() == 0) {
                viewerSearchOptions.setOffset(string.length());
            }
            bl2 = this.reverseFind(matcher, viewerSearchOptions);
        } else {
            int n3 = viewerSearchOptions.getOffset();
            if (n3 < string.length() && matcher.find(n3)) {
                bl2 = true;
                viewerSearchOptions.setOffset(matcher.start());
            } else {
                viewerSearchOptions.setItemDone(true);
            }
        }
        if (!bl2 && viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            this.mTextCtrl.select(viewerSearchOptions.getStartSelection(), viewerSearchOptions.getEndSelection());
        }
        return bl2;
    }

    public void selectContent(int n, int n2) {
        if (this.isInEditMode()) {
            this.mTextCtrl.select(n, n + n2);
        }
    }

    public void setAlignment(OutputItemAlignment outputItemAlignment) {
        this.getCoreItem().setAlignment(outputItemAlignment);
        SpssTextPane spssTextPane = this.getTextPane();
        if (!(spssTextPane.getDocument() instanceof StyledDocument) && !spssTextPane.isHTMLDocument()) {
            this.setUseHtmlDocument();
        }
        StyledDocument styledDocument = (StyledDocument)spssTextPane.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (outputItemAlignment == OutputItemAlignment.Center) {
            StyleConstants.setAlignment(simpleAttributeSet, 1);
        } else if (outputItemAlignment == OutputItemAlignment.Left) {
            StyleConstants.setAlignment(simpleAttributeSet, 0);
        } else {
            StyleConstants.setAlignment(simpleAttributeSet, 2);
        }
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
        spssTextPane.repaint(100L);
    }

    @Override
    public void closeEditorWindow() {
        this.getTextFrame().close();
    }

    @Override
    public void applyStyleChanges(HashMap<TextAttribute, Object> hashMap) {
        Float f;
        Integer n;
        Float f2;
        Object object;
        int n2;
        String string;
        Object object2;
        Object object3;
        Object object4;
        if (hashMap.get(TextAttribute.CHAR_REPLACEMENT) != null) {
            object4 = (String)hashMap.get(TextAttribute.CHAR_REPLACEMENT);
            object3 = ((String)object4).replace(")INDEX", this.mCoreItem.getIndexString());
            if (this.mTextCtrl.isHTMLDocument()) {
                object2 = this.mTextCtrl.getText();
                int n3 = ((String)object2).indexOf(string = this.getPlainText());
                if (n3 > 0) {
                    object3 = ((String)object3).replace(")LABEL", string);
                    object3 = ((String)object2).substring(0, n3) + (String)object3 + ((String)object2).substring(n3 + string.length());
                } else {
                    int n4 = ((String)object2).indexOf("<body>");
                    n2 = ((String)object2).indexOf("</body>");
                    object = ((String)object2).substring(n4 + 7, n2);
                    object3 = ((String)object3).replace(")LABEL", (CharSequence)object);
                    object3 = ((String)object2).substring(0, n4 + 7) + (String)object3 + ((String)object2).substring(n2);
                }
            } else {
                object3 = ((String)object3).replace(")LABEL", this.mTextCtrl.getText());
            }
            this.mTextCtrl.setText((String)object3);
        }
        this.setUseHtmlDocument();
        object4 = this.mTextCtrl.getDocument();
        this.mTextCtrl.setSelectionStart(0);
        this.mTextCtrl.setSelectionEnd(object4.getLength());
        object3 = new SimpleAttributeSet();
        object2 = (Color)hashMap.get(TextAttribute.FOREGROUND);
        if (object2 != null) {
            int n5 = object4.getLength() > 0 ? 1 : 0;
            Element element = ((StyledDocument)this.mTextCtrl.getDocument()).getCharacterElement(n5);
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
            n2 = StyleConstants.getFontSize(mutableAttributeSet);
            StyleConstants.setFontSize((MutableAttributeSet)object3, n2);
            StyleConstants.setForeground((MutableAttributeSet)object3, (Color)object2);
        }
        if ((string = (String)hashMap.get(TextAttribute.FAMILY)) != null && ModifyOutputHandler.checkFontFamily((String)string)) {
            StyleConstants.setFontFamily((MutableAttributeSet)object3, ModifyOutputHandler.fontNameCaseConvert((String)string));
        }
        if ((f2 = (Float)hashMap.get(TextAttribute.SIZE)) != null) {
            StyleConstants.setFontSize((MutableAttributeSet)object3, (int)FontUtil.logicalToPhysicalSize((float)f2.floatValue()));
        }
        if ((n = (Integer)hashMap.get(TextAttribute.UNDERLINE)) != null) {
            if (TextAttribute.UNDERLINE_ON.equals(n)) {
                StyleConstants.setUnderline((MutableAttributeSet)object3, true);
            } else {
                StyleConstants.setUnderline((MutableAttributeSet)object3, false);
            }
        }
        if ((f = (Float)hashMap.get(TextAttribute.WEIGHT)) != null) {
            if (TextAttribute.WEIGHT_BOLD.equals(f)) {
                StyleConstants.setBold((MutableAttributeSet)object3, true);
            } else {
                StyleConstants.setBold((MutableAttributeSet)object3, false);
            }
        }
        if ((object = (Float)hashMap.get(TextAttribute.POSTURE)) != null) {
            if (TextAttribute.POSTURE_OBLIQUE.equals(object)) {
                StyleConstants.setItalic((MutableAttributeSet)object3, true);
            } else {
                StyleConstants.setItalic((MutableAttributeSet)object3, false);
            }
        }
        this.mTextCtrl.setCharacterAttributes((AttributeSet)object3, false);
        this.commitText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewerItem.this.adjustHeight(TextViewerItem.this.getBounds());
                TextViewerItem.this.positionTextControl();
                TextViewerItem.this.revalidate();
                TextViewerItem.this.getFocusCycleRootAncestor().validate();
                TextViewerItem.this.repaint();
            }
        });
    }

    protected DefaultTextFontInfo getOptionViewerFont() {
        return new DefaultTextFontInfo(DefaultTextFontInfo.TextType.TextOutput);
    }

    private void saveSelections(ViewerSearchOptions viewerSearchOptions) {
        if (viewerSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            viewerSearchOptions.setStartSelection(this.mTextCtrl.getSelectionStart());
            viewerSearchOptions.setEndSelection(this.mTextCtrl.getSelectionEnd());
        }
    }

    private boolean reverseFind(Matcher matcher, ViewerSearchOptions viewerSearchOptions) {
        boolean bl = false;
        int n = 0;
        int n2 = viewerSearchOptions.getOffset();
        if (n2 > -1) {
            while (matcher.find(n)) {
                int n3 = matcher.start();
                n = matcher.end();
                if (n3 >= n2) continue;
                bl = true;
                viewerSearchOptions.setOffset(n3);
            }
        }
        if (!bl) {
            viewerSearchOptions.setItemDone(true);
        }
        return bl;
    }

    private void setItemSize(Dimension dimension) {
        Container container;
        int n = 500;
        for (container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JScrollPane)) continue;
            n = container.getSize().width - 65;
            break;
        }
        if (container != null) {
            dimension.width = this.getComponentType().equals((Object)ViewerDocument.ComponentType.text) ? (dimension.width > n ? dimension.width : n) : n;
            this.mTextCtrl.setPreferredSize(dimension);
            container.invalidate();
        }
    }

    @Override
    protected boolean canResize(int n) {
        return n == -1 || n == 11 || n == 10;
    }

    @Override
    protected void resize(Point point) {
        this.mTextCtrl.setSoftWrap(true);
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null) {
            this.adjustHeight(rectangle);
        }
        this.positionTextControl();
        if (rectangle != null) {
            ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
            viewerDocument.setFocusedViewerItem(this);
            viewerDocument.getCoreDocument().setModifiedFlag(true);
            viewerDocument.notifyChangedModifiedFlag();
            ((ViewerOutputPane)this.getParent()).handleSelectionChange(this, false);
        }
        ((ViewerOutputPane)this.getParent()).resetFeedback();
    }

    private void adjustHeight(Rectangle rectangle) {
        this.mCoreItem.setWidth(rectangle.width);
        this.mCoreItem.setHeight(rectangle.height);
        this.mTextCtrl.setSize(rectangle.width - 3, rectangle.height - 3);
        this.mTextCtrl.setPreferredSize(null);
        Dimension dimension = this.mTextCtrl.getPreferredSize();
        this.mTextCtrl.setPreferredSize(new Dimension(rectangle.width, dimension.height));
        this.setPreferredSize(new Dimension(rectangle.width, dimension.height));
    }

    @Override
    protected void refreshSize() {
        this.mTextCtrl.setLocation(2, 2);
        this.mTextCtrl.setSize(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
        this.mTextCtrl.setPreferredSize(new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight()));
    }

    protected void positionTextControl() {
        Dimension dimension = this.mTextCtrl.getPreferredSize();
        this.mTextCtrl.setLocation(2, 2);
        int n = dimension.width;
        int n2 = dimension.height;
        this.mTextCtrl.setSize(n - 3, n2 - 3);
        this.mTextCtrl.setPreferredSize(dimension);
    }

    @Override
    protected JMenuBar composeMixedMenuBar(SpssFrame spssFrame, JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = new JMenuBar();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(uIDefaults.getColor("MenuBar.shadow"));
        jMenuBar2.setBorder(thinMenuBarBorder);
        try {
            JMenuBar jMenuBar3 = this.cloneMenuBar(spssFrame.getMainMenuBar());
            String string = "doc_types/output/menus";
            spssFrame.loadMenuBarPreferences(string, jMenuBar3, spssFrame.getMenuTreeCache());
            JMenu jMenu = this.getTopLevelMenu(jMenuBar3, "Analyze");
            JMenu jMenu2 = this.getTopLevelMenu(jMenuBar3, "Graphs");
            JMenu jMenu3 = this.getTopLevelMenu(jMenuBar3, "Utilities");
            JMenu jMenu4 = this.getTopLevelMenu(jMenuBar3, "Add-ons");
            JMenu jMenu5 = this.getTopLevelMenu(jMenuBar3, "Window");
            JMenu jMenu6 = this.getTopLevelMenu(jMenuBar3, "Help");
            JMenuBar jMenuBar4 = new JMenuBar();
            String string2 = "doc_types/output/menus_edit";
            spssFrame.loadMenuBarPreferences(string2, jMenuBar4, new MenuCache(null));
            JMenu jMenu7 = jMenuBar4.getMenu(0);
            jMenuBar2.add(jMenu7);
            TextActionMgr textActionMgr = this.getTextFrame().getActionMgr();
            EditMenu editMenu = new EditMenu(textActionMgr);
            jMenuBar2.add(editMenu);
            ViewMenu viewMenu = new ViewMenu(textActionMgr);
            jMenuBar2.add(viewMenu);
            InsertMenu insertMenu = new InsertMenu(textActionMgr);
            jMenuBar2.add(insertMenu);
            FormatMenu formatMenu = new FormatMenu(textActionMgr);
            jMenuBar2.add(formatMenu);
            if (jMenu != null) {
                jMenuBar2.add(jMenu);
            }
            if (jMenu2 != null) {
                jMenuBar2.add(jMenu2);
            }
            if (jMenu3 != null) {
                jMenuBar2.add(jMenu3);
            }
            if (jMenu4 != null) {
                jMenuBar2.add(jMenu4);
            }
            if (jMenu5 != null) {
                jMenuBar2.add(jMenu5);
            }
            if (jMenu6 != null) {
                jMenuBar2.add(jMenu6);
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        return jMenuBar2;
    }

    @Override
    protected void setEditingToolBars() {
        Container container = this.getTopLevelAncestor();
        if (!(container instanceof SpssFrame)) {
            return;
        }
        SpssFrame spssFrame = (SpssFrame)this.getTopLevelAncestor();
        this.mSpssToolbarPanel = spssFrame.getToolBarPanel();
        this.checkForInEditToolBarPanel();
        this.mInEditToolBarPanel.setVisible(true);
        this.mSpssToolbarPanel.setVisible(false);
        spssFrame.setToolBarPanel(this.mInEditToolBarPanel);
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("texteditor");
        this.getTextFrame().applyToolBarPreference(preferences2, this.mMainToolBar, 0);
        this.getTextFrame().applyToolBarPreference(preferences2, this.mFormatToolbar, 1);
        spssFrame.validate();
        this.mTextCtrl.setFormatToolBar(this.mFormatToolbar);
        this.mTextCtrl.setMainToolBar(this.mMainToolBar);
        this.mFormatToolbar.updateBar(this.mEditor, this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextViewerItem.this.setToolBarDialogVisible(TextViewerItem.this.getTextFrame().getExternMainToolbar(), false);
                TextViewerItem.this.setToolBarDialogVisible(TextViewerItem.this.getTextFrame().getExternFormatingToolbar(), false);
            }
        });
    }

    @Override
    protected void restoreMainToolBars() {
        this.getTextFrame().add(this.mTextCtrl);
        this.getTextFrame().reattachToolbar();
        this.setToolBarDialogVisible(this.mMainToolBar, false);
        this.setToolBarDialogVisible(this.mFormatToolbar, false);
        this.mInEditToolBarPanel.setVisible(false);
        Container container = this.getTopLevelAncestor();
        if (!(container instanceof SpssFrame)) {
            return;
        }
        SpssFrame spssFrame = (SpssFrame)container;
        this.mSpssToolbarPanel.setVisible(true);
        spssFrame.setToolBarPanel(this.mSpssToolbarPanel);
        spssFrame.validate();
    }

    public void setToolBarDialogVisible(JToolBar jToolBar, boolean bl) {
        RootPaneContainer rootPaneContainer;
        ToolBarUI toolBarUI = jToolBar.getUI();
        if (toolBarUI instanceof MultiDockToolBarUI && (rootPaneContainer = ((MultiDockToolBarUI)toolBarUI).getRootPaneContainer()) instanceof JDialog) {
            ((JDialog)rootPaneContainer).setVisible(bl);
        }
    }

    public SpssTextPane getTextPane() {
        return this.mTextCtrl;
    }

    protected StringBuffer cleanText(StringBuffer stringBuffer) {
        try {
            StringBuffer stringBuffer2 = new StringBuffer();
            Matcher matcher = sPat04.matcher(stringBuffer);
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer2, "<br");
            }
            stringBuffer = matcher.appendTail(stringBuffer2);
            stringBuffer2 = new StringBuffer();
            Matcher matcher2 = sPat05.matcher(stringBuffer);
            while (matcher2.find()) {
                matcher2.appendReplacement(stringBuffer2, "");
            }
            stringBuffer = matcher2.appendTail(stringBuffer2);
            stringBuffer2 = new StringBuffer();
            Matcher matcher3 = sPat06.matcher(stringBuffer);
            while (matcher3.find()) {
                matcher3.appendReplacement(stringBuffer2, "<br>");
            }
            stringBuffer = matcher3.appendTail(stringBuffer2);
            stringBuffer2 = new StringBuffer();
            Matcher matcher4 = sPat08.matcher(stringBuffer);
            while (matcher4.find()) {
                matcher4.appendReplacement(stringBuffer2, "<br style=\"page-break-before:always\">");
            }
            stringBuffer = matcher4.appendTail(stringBuffer2);
            if (!(this instanceof PageTitleViewerItem)) {
                Matcher matcher5;
                Matcher matcher6 = sPat09.matcher(stringBuffer);
                if (matcher6.find()) {
                    stringBuffer2 = new StringBuffer();
                    matcher6.appendReplacement(stringBuffer2, "");
                    stringBuffer = matcher6.appendTail(stringBuffer2);
                }
                if ((matcher5 = sPat10.matcher(stringBuffer)).find()) {
                    stringBuffer2 = new StringBuffer();
                    matcher5.appendReplacement(stringBuffer2, "");
                    stringBuffer = matcher5.appendTail(stringBuffer2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer;
    }

    protected String extractPlainText() {
        String string = "";
        String string2 = this.mTextCtrl.getText();
        int n = this.mTextCtrl.getSelectionStart();
        int n2 = this.mTextCtrl.getSelectionEnd();
        this.mTextCtrl.setSelectionStart(0);
        this.mTextCtrl.setSelectionEnd(string2.length());
        int n3 = this.mTextCtrl.getSelectionStart();
        int n4 = this.mTextCtrl.getSelectionEnd();
        if (n4 - n3 > 0) {
            StringWriter stringWriter = new StringWriter(n4 - n3);
            try {
                this.mTextCtrl.getEditorKit().write(stringWriter, this.mTextCtrl.getDocument(), n3, n4 - n3);
                StringReader stringReader = new StringReader(stringWriter.toString());
                HTMLDocument hTMLDocument = new HTMLDocument();
                this.mTextCtrl.getEditorKit().read(stringReader, (Document)hTMLDocument, 0);
                string = this.mTextCtrl.getSelectedText(hTMLDocument, this.mTextCtrl.getSelectedText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.mTextCtrl.select(n, n2);
        return string;
    }

    private void setDefaultTextStyles() {
        DefaultTextFontInfo defaultTextFontInfo = this.getOptionViewerFont();
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, defaultTextFontInfo.getFontName());
        hashMap.put(TextAttribute.SIZE, Float.valueOf(defaultTextFontInfo.getFontSize()));
        hashMap.put(TextAttribute.POSTURE, defaultTextFontInfo.isItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        hashMap.put(TextAttribute.WEIGHT, defaultTextFontInfo.isBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        if (defaultTextFontInfo.isUnderline()) {
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        Color color = TextItem.getColor((int)defaultTextFontInfo.getFontColor());
        Font font = new Font(hashMap);
        this.mDefaultFont = this.mTextCtrl.getFont().deriveFont(14.0f);
        this.mTextCtrl.setFont(font);
        this.mTextCtrl.setForeground(color);
    }

    private void applyAlignment() {
        SpssTextPane spssTextPane = this.getTextPane();
        if (!spssTextPane.isHTMLDocument() || this.mCoreItem.getAlignment() == OutputItemAlignment.Left) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)spssTextPane.getDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = this.mCoreItem.getAlignment() == OutputItemAlignment.Center ? 1 : 2;
        StyleConstants.setAlignment(simpleAttributeSet, n);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
    }

    private void checkForInEditToolBarPanel() {
        if (this.mInEditToolBarPanel == null) {
            FlowLayout flowLayout = new FlowLayout(3);
            flowLayout.setVgap(0);
            this.mInEditToolBarPanel = new JPanel(flowLayout);
            this.mMainToolBar = new TextMainBar(this.getTextFrame().getActionMgr(), false);
            this.mInEditToolBarPanel.add(this.mMainToolBar);
            this.mFormatToolbar = new TextFormatBar(this.getTextFrame().getActionMgr());
            this.mInEditToolBarPanel.add(this.mFormatToolbar);
        }
    }

    protected String extractPlainText(String string) {
        String string2;
        int n = string.indexOf("</head>");
        if (n == -1) {
            n = string.indexOf("</HEAD>");
        }
        if (n > -1) {
            Pattern pattern = Pattern.compile("<BR>", 18);
            Matcher matcher = pattern.matcher(string.substring(n + 7));
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "\n");
            }
            matcher.appendTail(stringBuffer);
            matcher = sPat08.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "\u000f\n");
            }
            matcher.appendTail(stringBuffer);
            matcher = sPat13.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "\u000f\n");
            }
            matcher.appendTail(stringBuffer);
            pattern = Pattern.compile("</br>", 18);
            matcher = pattern.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "");
            }
            matcher.appendTail(stringBuffer);
            pattern = Pattern.compile("&lt;", 18);
            matcher = pattern.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "<");
            }
            matcher.appendTail(stringBuffer);
            pattern = Pattern.compile("&gt;", 18);
            matcher = pattern.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, ">");
            }
            matcher.appendTail(stringBuffer);
            pattern = Pattern.compile("&nbsp;", 18);
            matcher = pattern.matcher(stringBuffer);
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "\u00a0");
            }
            matcher.appendTail(stringBuffer);
            string2 = stringBuffer.toString();
        } else {
            string2 = string;
        }
        return string2;
    }

    private void setWebContents(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new HTMLEditorKit());
        jEditorPane.setText(string);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, "sans-serif");
        StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        styledDocument.setCharacterAttributes(0, 0, simpleAttributeSet, false);
        ((TextItem)this.mCoreItem).setWebContents(jEditorPane.getText());
    }
}

