/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.IPvtPivotTable;
import com.spss.charteditor.template.ApplyTemplate;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.table.ITableItemUIAgent;
import com.spss.java_client.core.documents.output.table.TableItem;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.CloseAction;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.ThinMenuBarBorder;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.PivotTableDelegator;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.VizTiler;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pivottable.PTECloseListener;
import com.spss.pivottable.PTEUpdateListener;
import com.spss.pivottable.PTInfo;
import com.spss.pivottable.TableEditor;
import com.spss.pivottable.TableLayoutListener;
import com.spss.pivottable.dialogs.ITableUpdate;
import com.spss.pivottable.gui.PTCanvas;
import com.spss.pivottable.gui.actions.menu_actions.SaveToXmlAction;
import com.spss.pivottable.gui.menus.EditMenu;
import com.spss.pivottable.gui.menus.FormatMenu;
import com.spss.pivottable.gui.menus.InsertMenu;
import com.spss.pivottable.gui.menus.PivotMenu;
import com.spss.pivottable.gui.menus.ViewMenu;
import com.spss.pivottable.gui.toolbars.FloatingToolBarDlg;
import com.spss.pivottable.renderers.TileCompositer;
import com.spss.pivottable.util.EditorUtil;
import com.spss.pivottable.util.ITableToChartListener;
import com.spss.pivottable.util.PvtLogger;
import com.spss.shared.export.table_export.TableImager;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.IUISearchAndReplaceProxy;
import com.spss.uitools.util.TraceSettings;
import com.spss.vis.Source;
import com.spss.vis.Visualization;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.specification.LabelFrameSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.facet.FacetingSpecification;
import com.spss.vis.specification.facet.LayerSpecification;
import com.spss.vis.specification.label.DescriptionGroupSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.layout.LocationPartType;
import com.spss.vis.specification.layout.LocationSpecification;
import com.spss.vis.specification.style.FrameStyle;
import com.spss.vis.specification.style.TextStyle;
import com.spss.vizimager.DataFilterInfo;
import com.spss.vizimager.VizDataProcessor;
import com.spss.vizimager.VizDataWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class TableViewerItem
extends ViewerItem
implements ITableToChartListener,
ITableItemUIAgent,
TableLayoutListener,
PTEUpdateListener,
ITableUpdate {
    public static int FEEDBACK_HEIGHT = 16;
    private static final Dimension MEDIUM_TABLE_SIZE = new Dimension(800, 800);
    private TableEditor mEditor = null;
    protected PTCanvas mCanvasCtrl = null;
    private ViewerImage mImage = new ViewerImage();
    private VizTiler mTiler;
    private boolean mIsPivotingOn;
    private DataFilterInfo mDataFilterInfo;
    private int mNavigateBarLength;

    public TableViewerItem(IOutputItem iOutputItem, String string) {
        super(iOutputItem);
        this.setName(string);
        iOutputItem.setDescription(string);
        this.mDataFilterInfo = ((TableItem)this.mCoreItem).getDataFilterInfo();
        this.mTiler = new VizTiler(this, this.mDataFilterInfo);
        this.setRendered(false);
        this.setVisible(iOutputItem.getVisible());
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.table;
    }

    @Override
    public boolean startEdit() {
        boolean bl;
        if (this.isLockedDocument()) {
            this.activateLockedEdit();
            return true;
        }
        if (this.isInEditMode()) {
            if (!this.isInPlaceEdit()) {
                this.getTableEditor().getFrame().toFront();
            }
            return false;
        }
        TableItem tableItem = (TableItem)this.mCoreItem;
        boolean bl2 = bl = tableItem.isComplete() && tableItem.isEditable();
        if (!bl) {
            return false;
        }
        Container container = this.getTopLevelAncestor();
        container.setCursor(Cursor.getPredefinedCursor(3));
        boolean bl3 = false;
        try {
            bl3 = super.startEdit();
            bl3 = this.isInPlaceMode() ? this.activateEdit() && bl3 : this.activateOpen() && bl3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        container.setCursor(null);
        return bl3;
    }

    @Override
    public void endEdit() {
        if (this.mEditor == null) {
            return;
        }
        if (this.isLockedDocument()) {
            this.deactivateLockedEdit();
            return;
        }
        if (!this.isInEditMode()) {
            return;
        }
        if (this.isInPlaceEdit()) {
            this.deactivateEdit();
        } else {
            this.deactivateOpen();
        }
        this.updateLayerWhenEditEnd(this.acquireVisualization().getSpecification());
        this.mEditor = null;
        this.mCanvasCtrl = null;
        super.endEdit();
    }

    @Override
    public void setRendered(boolean bl) {
        super.setRendered(bl);
        this.setToolTipText(bl ? TIP_TEXT : null);
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        if (this.isEditingInPlace()) {
            return;
        }
        try {
            if (this.mTiler != null) {
                Serializable serializable;
                boolean bl = false;
                if (this.mDataFilterInfo.isDisplayFiltering() && this.mDataFilterInfo.getTotalPageCount() > 1) {
                    if (this.mDataFilterInfo.getActivePageId() - 1 >= 0) {
                        serializable = this.getClass().getResource("/com/spss/java_client/ui/resources/images/goPrev.png");
                        this.drawFeedback(graphics2D, (URL)serializable, false);
                        bl = true;
                    }
                    if (this.mDataFilterInfo.getActivePageId() + 1 < this.mDataFilterInfo.getTotalPageCount()) {
                        serializable = this.getClass().getResource("/com/spss/java_client/ui/resources/images/goNext.png");
                        this.drawFeedback(graphics2D, (URL)serializable, true);
                    }
                }
                serializable = graphics2D.getTransform();
                graphics2D.translate(1, 1);
                if (bl) {
                    graphics2D.translate(0, FEEDBACK_HEIGHT);
                }
                this.mTiler.paintComponent(graphics2D);
                graphics2D.setTransform((AffineTransform)serializable);
            } else {
                this.renderBuffered(graphics2D);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
    }

    public void tableRedraw() {
        if (this.mDataFilterInfo == null) {
            return;
        }
        int n = this.mDataFilterInfo.getPageStartRow();
        VizCache.getCache().clearItem(this.getId());
        this.cacheImage();
        VizCache.getCache().getVisualization((TableItem)this.mCoreItem);
        if (n > 0) {
            this.mDataFilterInfo.updateActivePageIdByRow(n);
        }
        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
        viewerOutputPane.handleSelectionChange(this, false);
        viewerOutputPane.setDocumentModifiedFlag(true);
        this.revalidate();
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isEditingInFrame()) {
            this.renderEditModeHatchPattern((Graphics2D)graphics, this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
        }
    }

    public boolean isEditingInPlace() {
        return this.isInEditMode() && this.isInPlaceEdit();
    }

    public boolean isEditingInFrame() {
        return this.isInEditMode() && !this.isInPlaceEdit();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        super.setPreferredSize(new Dimension(dimension.width, dimension.height + FEEDBACK_HEIGHT));
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return ImageGenerator2.getImageGenerator().getDefaultImageSize();
        }
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean activateOpen() {
        boolean bl = false;
        try {
            SaveToXmlAction.sFilePath = FileLocationsUtil.getOtherFilesDirectoryPath();
            ((ViewerOutputPane)this.getParent()).hideSearchWindow();
            FloatingToolBarDlg floatingToolBarDlg = this.getTableEditor().getPivotTableInfo().getOutPlaceToolBarDlg();
            if (floatingToolBarDlg == null) {
                this.getTableEditor().getPivotTableInfo().setOutPlaceToolBarDlg(new FloatingToolBarDlg((Frame)this.getTableEditor().getFrame(), this.getTableEditor().getFrame().getToolBar()));
            }
            Dimension dimension = new Dimension(30, 30);
            Dimension dimension2 = new Dimension(700, 500);
            Dimension dimension3 = new Dimension(200, 100);
            int n = Math.min(this.getWidth() + dimension.width, dimension2.width);
            int n2 = Math.min(this.getHeight() + dimension.height, dimension2.height);
            n = Math.max(n, dimension3.width);
            n2 = Math.max(n2, dimension3.height);
            TableItem tableItem = (TableItem)this.mCoreItem;
            Visualization visualization = VizCache.getCache().getVisualization(tableItem);
            VizDataProcessor vizDataProcessor = VizCache.getCache().getDataReader(tableItem);
            this.getTableEditor().setNavigateMsgLength(this.mNavigateBarLength);
            this.getTableEditor().renderXMLToScreen(visualization, vizDataProcessor, 200, 200, n, n2);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getTableEditor().removePTECloseListeners();
        this.getTableEditor().addPTECloseListener(new PTECloseListener(){

            public void close() {
                TableViewerItem.this.endEdit();
            }
        });
        return bl;
    }

    public void deactivateOpen() {
        Object object;
        boolean bl = false;
        boolean bl2 = this.getTableEditor().wasSearchWindowVisible();
        if (this.getTableEditor().needsRerendering()) {
            object = this.getTableEditor().extractCompressedXML();
            if (object != null) {
                this.mCoreItem.replaceCompressedXML(object);
            }
            TableItem tableItem = (TableItem)this.mCoreItem;
            tableItem.setVDPData(this.getTableEditor().extractExternalizedData());
            tableItem.setDisplayedTableLookFilePath(this.getTableEditor().getPivotTableInfo().getDisplayedTableLookFilePath());
            this.getTableEditor().getPivotTableInfo().setExternalDataSource(null);
            this.mDataFilterInfo.setRowVariables(EditorUtil.getRowVariables((VisualizationSpecification)this.getTableEditor().getPivotTableInfo().getVisualizationSpecification()));
            this.cacheImage();
            bl = true;
        }
        object = (ViewerOutputPane)this.getParent();
        object.handleSelectionChange(this, false);
        object.scrollRectToVisible(this.getBounds());
        if (bl) {
            object.setDocumentModifiedFlag(bl);
        }
        this.getTableEditor().reset();
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ViewerOutputPane)TableViewerItem.this.getParent()).reparentSearchWindow();
                }
            });
        }
    }

    public boolean activateEdit() {
        super.startEdit();
        this.setInPlaceEdit(true);
        this.mCanvasCtrl = this.getTableEditor().getPivotTableInfo().getInplaceImageComponent();
        this.mCanvasCtrl.setPreferredSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        this.mCanvasCtrl.setSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        this.add((Component)this.mCanvasCtrl);
        this.mCanvasCtrl.setLocation(2, 2);
        this.getTableEditor().setNavigateMsgLength(this.mNavigateBarLength);
        this.updateTable();
        this.updateViewerFrameMenus(true);
        this.updateViewerFrameToolBars(true);
        Container container = this.getTopLevelAncestor();
        FloatingToolBarDlg floatingToolBarDlg = this.getTableEditor().getPivotTableInfo().getInPlaceToolBarDlg();
        if (floatingToolBarDlg == null && container instanceof ViewerFrame) {
            this.getTableEditor().getPivotTableInfo().setInPlaceToolBarDlg(new FloatingToolBarDlg((Frame)((ViewerFrame)container), this.getTableEditor().getFrame().getToolBar()));
        }
        this.getTableEditor().getPivotTableInfo().applyPreferences();
        this.getTableEditor().removePTECloseListeners();
        this.getTableEditor().getPivotTableInfo().getImageComponent().requestFocusInWindow();
        this.getTableEditor().addPTECloseListener(new PTECloseListener(){

            public void close() {
                TableViewerItem.this.endEdit();
            }
        });
        this.relayout();
        return true;
    }

    public void deactivateEdit() {
        Object object;
        if (this.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
            this.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit();
        }
        super.endEdit();
        this.getTableEditor().deactivateInPlace();
        this.setInPlaceEdit(false);
        if (this.mCanvasCtrl != null) {
            this.remove((Component)this.mCanvasCtrl);
        }
        this.mCanvasCtrl = null;
        this.updateViewerFrameMenus(false);
        this.updateViewerFrameToolBars(false);
        this.getTableEditor().getPivotTableInfo().savePreferences();
        FloatingToolBarDlg floatingToolBarDlg = this.getTableEditor().getPivotTableInfo().getInPlaceToolBarDlg();
        if (floatingToolBarDlg != null) {
            floatingToolBarDlg.setVisible(false);
        }
        boolean bl = false;
        if (this.getTableEditor().needsRerendering()) {
            object = this.getTableEditor().extractCompressedXML();
            this.mCoreItem.replaceCompressedXML((byte[])object);
            TableItem tableItem = (TableItem)this.mCoreItem;
            tableItem.setVDPData(this.getTableEditor().extractExternalizedData());
            tableItem.setDisplayedTableLookFilePath(this.getTableEditor().getPivotTableInfo().getDisplayedTableLookFilePath());
            this.getTableEditor().getPivotTableInfo().setExternalDataSource(null);
            this.mDataFilterInfo.setRowVariables(EditorUtil.getRowVariables((VisualizationSpecification)this.getTableEditor().getPivotTableInfo().getVisualizationSpecification()));
            VizCache.getCache().clearItem(this.getId());
            this.cacheImage();
            bl = true;
        }
        this.getTableEditor().reset();
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).handleSelectionChange(this, false);
        ((JComponent)object).scrollRectToVisible(this.getBounds());
        if (bl) {
            ((ViewerOutputPane)object).setDocumentModifiedFlag(bl);
        }
        this.revalidate();
    }

    public void classifyTableSize() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options").node("tables");
        String string = preferences2.get("editing_mode", PrefDefaults.DEF_EDITING_MODE);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_EDITING_MODE_VALUES, string);
        boolean bl = n == 0 ? true : (n == 2 ? false : this.classifyTableType());
        this.setInplaceMode(bl);
    }

    public TableEditor getTableEditor() {
        if (this.mEditor == null || this.mEditor.getPivotTableInfo() == null) {
            this.mEditor = new TableEditor(this.getName(), ComponentState.getILangLocale().getLanguage(), this.isLockedDocument());
            this.mEditor.getPivotTableInfo().setBaseUserPrefsPath(PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath());
            this.setPropertiesToEditor();
            this.getTableEditor().setTableToChartListener((ITableToChartListener)this);
            this.getTableEditor().addLayoutListener((TableLayoutListener)this);
            ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
            this.mEditor.getPivotTableInfo().setSearchProxy((IUISearchAndReplaceProxy)viewerDocument);
        }
        return this.mEditor;
    }

    public synchronized Visualization acquireVisualization() {
        return VizCache.getCache().getVisualization((TableItem)this.mCoreItem);
    }

    public boolean addChart(String string, byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        try {
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification(TableImager.getProperInputStream((byte[])byArray));
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            visualizationSpecification.writeXml((Writer)charArrayWriter);
            charArrayWriter.close();
            String string2 = charArrayWriter.toString();
            string2 = this.applyChartTemplates(string2);
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(string2.getBytes("UTF-8")));
            byArray = byteBuffer.array();
            ChartItem chartItem = new ChartItem();
            chartItem.setDescription(string);
            chartItem.setVisible(true);
            chartItem.setCompressedXML(ByteBuffer.wrap(byArray));
            chartItem.setVDPData(ByteBuffer.wrap(byArray2));
            chartItem.setVDPid(UUID.randomUUID().getMostSignificantBits());
            chartItem.setMainMapData(null);
            chartItem.setRefMapData(null);
            ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
            ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
            IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
            IOutputItem iOutputItem = this.getCoreItem();
            if (iOutputDocument.insertItem((IOutputItem)chartItem, iOutputItem) && iOutputDocument.getUIAgent() instanceof ViewerFrame) {
                Vector<ViewerItem> vector = viewerDocument.getViewerItems();
                ViewerItem viewerItem = null;
                for (ViewerItem viewerItem2 : vector) {
                    if (!chartItem.equals(viewerItem2.getCoreItem())) continue;
                    viewerItem = viewerItem2;
                    break;
                }
                if (viewerItem != null) {
                    viewerDocument.setFocusedViewerItem(viewerItem);
                    viewerDocument.selectionChanged(viewerItem, true, false);
                }
                if (this.isEditingInPlace()) {
                    this.deactivateEdit();
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return bl;
    }

    public void relayout() {
        this.positionItemControl();
        this.revalidate();
    }

    /*
     * Exception decompiling
     */
    public void SaveImage(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ActivateTable() {
        if (this.isInEditMode()) {
            return;
        }
        this.mIsPivotingOn = PTInfo.isPivotingTrayOn();
        PTInfo.savePivotingTrayState((boolean)false);
        this.mCanvasCtrl = this.getTableEditor().getPivotTableInfo().getInplaceImageComponent();
        this.mCanvasCtrl.setPreferredSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        this.mCanvasCtrl.setSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        SaveToXmlAction.sFilePath = FileLocationsUtil.getOtherFilesDirectoryPath();
        this.setInplaceMode(true);
        super.startEdit();
        this.activateEdit();
        Container container = this.getParent();
        if (container instanceof ViewerOutputPane) {
            ((ViewerOutputPane)container).setEditingItem(this);
        }
        TileCompositer tileCompositer = this.mCanvasCtrl.getImageRenderer();
        synchronized (tileCompositer) {
            try {
                this.mCanvasCtrl.getImageRenderer().wait(3000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void DeactivateTable() {
        if (!this.isInEditMode()) {
            return;
        }
        this.deactivateEdit();
        PTInfo.savePivotingTrayState((boolean)this.mIsPivotingOn);
    }

    @Override
    public void closeEditorWindow() {
        if (this.mEditor != null) {
            this.mEditor.close(true);
        }
    }

    public DataFilterInfo getDataFilterInfo() {
        return this.mDataFilterInfo;
    }

    @Override
    protected boolean canResize(int n) {
        return false;
    }

    @Override
    protected void resize(Point point) {
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null && this.mCanvasCtrl != null) {
            this.mCanvasCtrl.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
            this.setPreferredSize(new Dimension(rectangle.width, rectangle.height));
            this.positionItemControl();
        }
        super.resize(point);
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            this.mCoreItem.setWidth(bufferedImage.getWidth() + 3);
            this.mCoreItem.setHeight(bufferedImage.getHeight() + 3);
            Dimension dimension = new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.setRendered(true);
            TraceSettings.tracePerformance((String)("TableViewerItem.renderingComplete() - " + this.getCoreItem().getDescription()));
        }
    }

    private void renderBuffered(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle.isEmpty()) {
            TraceSettings.trace1((String)"Empty Table Clip Area!", (int)15);
            return;
        }
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            bufferedImage = this.cacheImage();
        }
        try {
            int n = Math.min(rectangle.x + rectangle.width, bufferedImage.getWidth() - 1);
            int n2 = Math.min(rectangle.y + rectangle.height, bufferedImage.getHeight() - 1);
            if (n - rectangle.x > 0 && n2 - rectangle.y > 0) {
                graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y, n, n2, rectangle.x, rectangle.y, n, n2, null);
            }
        }
        catch (Exception exception) {
            TraceSettings.trace1((String)("### Error rendering viewer table: " + this.mCoreItem.getDescription()), (int)15);
            exception.printStackTrace();
        }
    }

    private boolean classifyTableType() {
        boolean bl = true;
        Dimension dimension = this.getPreferredSize();
        if (dimension.width > TableViewerItem.MEDIUM_TABLE_SIZE.width || dimension.height > TableViewerItem.MEDIUM_TABLE_SIZE.height) {
            bl = false;
        }
        return bl;
    }

    private BufferedImage cacheImage() {
        if (this.mTiler != null) {
            this.mTiler.clear();
            return null;
        }
        ImageCache.getImageCache().remove(this.mImage);
        ImageGenerator2.ImageContainer imageContainer = ImageGenerator2.getImageGenerator().generateImage(this);
        BufferedImage bufferedImage = imageContainer.get();
        boolean bl = imageContainer.isComplete();
        this.mImage = new ViewerImage(this, bufferedImage, bl, false);
        if (bufferedImage != null) {
            this.mCoreItem.setWidth(bufferedImage.getWidth() + 3);
            this.mCoreItem.setHeight(bufferedImage.getHeight() + 3);
            Dimension dimension = new Dimension(this.mCoreItem.getWidth(), this.mCoreItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        }
        return bufferedImage;
    }

    private void positionItemControl() {
        if (this.mCanvasCtrl != null) {
            this.mCanvasCtrl.setLocation(2, 2);
        }
        int n = this.getTableEditor().getPivotTableInfo().getVisWidth();
        n = Math.max(n, this.mNavigateBarLength);
        int n2 = this.getTableEditor().getPivotTableInfo().getVisHeight();
        if (n > 0 && n2 > 0) {
            this.setSize(n + 5, n2 + 5);
            this.setPreferredSize(new Dimension(n + 5, n2 + 5));
        }
    }

    protected void updateTable() {
        try {
            TableItem tableItem = (TableItem)this.mCoreItem;
            Visualization visualization = VizCache.getCache().getVisualization(tableItem);
            VizDataProcessor vizDataProcessor = VizCache.getCache().getDataReader(tableItem);
            this.getTableEditor().renderXMLInPlace(visualization, vizDataProcessor, 200, 200, 500, 500);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected JMenuBar composeMixedMenuBar(SpssFrame spssFrame, JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = new JMenuBar();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(uIDefaults.getColor("MenuBar.shadow"));
        jMenuBar2.setBorder(thinMenuBarBorder);
        try {
            JMenuBar jMenuBar3 = this.cloneMenuBar(spssFrame.getMainMenuBar());
            JMenu jMenu = this.getTopLevelMenu(jMenuBar3, "Analyze");
            JMenu jMenu2 = this.getTopLevelMenu(jMenuBar3, "Graphs");
            JMenu jMenu3 = this.getTopLevelMenu(jMenuBar3, "Utilities");
            JMenu jMenu4 = this.getTopLevelMenu(jMenuBar3, "Add-ons");
            JMenu jMenu5 = this.getTopLevelMenu(jMenuBar3, "Window");
            JMenu jMenu6 = this.getTopLevelMenu(jMenuBar3, "Help");
            JMenuBar jMenuBar4 = new JMenuBar();
            String string = "doc_types/output/menus_edit";
            spssFrame.loadMenuBarPreferences(string, jMenuBar4, new MenuCache(null));
            JMenu jMenu7 = jMenuBar4.getMenu(0);
            jMenuBar2.add(jMenu7);
            jMenuBar2.add((JMenu)new EditMenu(this.mEditor.getPivotTableInfo()));
            jMenuBar2.add((JMenu)new ViewMenu(this.mEditor.getPivotTableInfo()));
            jMenuBar2.add((JMenu)new InsertMenu(this.mEditor.getPivotTableInfo()));
            jMenuBar2.add((JMenu)new PivotMenu(this.mEditor.getPivotTableInfo()));
            jMenuBar2.add((JMenu)new FormatMenu(this.mEditor.getPivotTableInfo()));
            if (jMenu != null) {
                jMenuBar2.add(jMenu);
            }
            if (jMenu2 != null) {
                jMenuBar2.add(jMenu2);
            }
            if (jMenu3 != null) {
                jMenuBar2.add(jMenu3);
            }
            if (jMenu4 != null) {
                jMenuBar2.add(jMenu4);
            }
            if (jMenu5 != null) {
                jMenuBar2.add(jMenu5);
            }
            if (jMenu6 != null) {
                jMenuBar2.add(jMenu6);
            }
            int n = jMenu7.getItemCount();
            for (int i = 0; i < n; ++i) {
                Action action;
                JMenuItem jMenuItem = jMenu7.getItem(i);
                if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof CloseAction)) continue;
                jMenuItem.setAction((Action)this.mEditor.getPivotTableInfo().getActionManager().getAction("Close"));
                break;
            }
        }
        catch (BackingStoreException backingStoreException) {
            PvtLogger.printStackTrace((Exception)backingStoreException);
        }
        return jMenuBar2;
    }

    @Override
    protected void restoreMainMenu() {
        super.restoreMainMenu();
        JMenu jMenu = this.mFrameEditingMenuBar.getMenu(0);
        int n = jMenu.getItemCount();
        for (int i = 0; i < n; ++i) {
            Action action;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof com.spss.pivottable.gui.actions.menu_actions.CloseAction)) continue;
            jMenuItem.setAction(ActionCatalog.getActionCatalog().getSpssAction("file_close"));
            break;
        }
    }

    @Override
    protected void setEditingToolBars() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof SpssFrame) {
            SpssFrame spssFrame = (SpssFrame)container;
            spssFrame.setToolBarVisible(false);
        }
    }

    @Override
    protected void restoreMainToolBars() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof SpssFrame) {
            SpssFrame spssFrame = (SpssFrame)container;
            spssFrame.setToolBarVisible(true);
        }
    }

    private void setPropertiesToEditor() {
        if (!(this.mCoreItem instanceof TableItem)) {
            return;
        }
        TableItem tableItem = (TableItem)this.mCoreItem;
        this.getTableEditor().getPivotTableInfo().setDisplayedTableProperties(tableItem.getDisplayedTableProperties());
        this.getTableEditor().getPivotTableInfo().setDisplayedTableLookFilePath(tableItem.getDisplayedTableLookFilePath());
        Container container = this.getTopLevelAncestor();
        if (container instanceof ITopWindow) {
            ITopWindow iTopWindow = (ITopWindow)((Object)container);
            this.getTableEditor().getPivotTableInfo().setExportCopyParams(PageSetupUtil.collectExportCopyParams(iTopWindow.getViewerPanel()));
        }
    }

    public IPvtPivotTable getPivotTable() {
        TableEditor tableEditor = this.getTableEditor();
        this.getTableEditor().removePTECloseListeners();
        this.getTableEditor().addPTECloseListener(new PTECloseListener(){

            public void close() {
                TableViewerItem.this.endEdit();
            }
        });
        Visualization visualization = VizCache.getCache().getVisualization((TableItem)this.mCoreItem);
        VizDataProcessor vizDataProcessor = VizCache.getCache().getDataReader((TableItem)this.mCoreItem);
        tableEditor.getPivotTableInfo().setVisualization(visualization);
        if (((TableItem)this.mCoreItem).getVDPData() == null) {
            tableEditor.getPivotTableInfo().setExternalDataSource(null);
        } else {
            tableEditor.getPivotTableInfo().setExternalDataSource(vizDataProcessor);
        }
        if (this.mCanvasCtrl == null) {
            int n = this.mCoreItem.getWidth() - 3;
            int n2 = this.mCoreItem.getHeight() - 3;
            this.mCanvasCtrl = this.getTableEditor().getPivotTableInfo().getInplaceImageComponent();
            this.mCanvasCtrl.setPreferredSize(new Dimension(n, n2));
            this.mCanvasCtrl.setSize(new Dimension(n, n2));
        }
        tableEditor.addViewerUpdateListener((PTEUpdateListener)this);
        return new PivotTableDelegator(tableEditor.getPivotTable());
    }

    public void dispose() {
        if (this.mEditor != null) {
            this.mEditor.dispose();
            this.mEditor = null;
            VizCache.getCache().clearItem(this.getId());
        }
    }

    private String applyChartTemplates(String string) throws OutOfMemoryError {
        String string2;
        try {
            File file;
            String string3;
            Object object;
            String string4;
            String string5;
            File file2;
            String string6;
            ApplyTemplate applyTemplate = new ApplyTemplate();
            String string7 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
            File file3 = new File(string7);
            if (!file3.exists()) {
                TraceSettings.trace1((String)("CANNOT OPEN Template File: " + string7), (int)15);
            }
            if ((string6 = this.getTemplateFromFile(string7)) == null || string6.length() == 0) {
                TraceSettings.trace1((String)("CANNOT READ Template File: " + string7), (int)15);
            }
            if ((string2 = applyTemplate.apply(string, string6)) == null || string2.length() == 0) {
                TraceSettings.trace1((String)("CANNOT APPLY Template File: " + string7), (int)15);
            }
            if ((file2 = new File(string5 = (string4 = PrefsMgr.getPrefsMgr().getTempPath()) + "otmpl.tmp")).exists()) {
                string6 = this.getTemplateFromFile(string5);
                string2 = applyTemplate.apply(string2, string6);
            }
            boolean bl = true;
            String string8 = this.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
            if (string8.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string3 = this.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
                string6 = this.getTemplateFromFile(string3);
                string2 = applyTemplate.apply(string2, string6);
                bl = false;
            }
            if (bl && (file = new File((String)(object = string4 + "dtmpl.tmp"))).exists()) {
                string6 = this.getTemplateFromFile((String)object);
                string2 = applyTemplate.apply(string2, string6);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
            string2 = string;
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    private String getTemplateFromFile(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return string2;
    }

    private String getPrefsValue(String string, String string2, String string3) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node(string);
        return preferences3.get(string2, string3);
    }

    public void update(boolean bl) {
        byte[] byArray = this.getTableEditor().extractCompressedXML();
        if (byArray == null) {
            return;
        }
        this.mCoreItem.replaceCompressedXML(byArray);
        TableItem tableItem = (TableItem)this.mCoreItem;
        tableItem.setVDPData(this.getTableEditor().extractExternalizedData());
        tableItem.setDisplayedTableLookFilePath(this.getTableEditor().getPivotTableInfo().getDisplayedTableLookFilePath());
        if (bl) {
            this.cacheImage();
            this.revalidate();
            this.repaint();
        }
    }

    public boolean activateLockedEdit() {
        super.startEdit();
        this.setInPlaceEdit(true);
        this.mCanvasCtrl = this.getTableEditor().getPivotTableInfo().getInplaceImageComponent();
        this.mCanvasCtrl.setPreferredSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        this.mCanvasCtrl.setSize(new Dimension(this.mCoreItem.getWidth() - 3, this.mCoreItem.getHeight() - 3));
        this.add((Component)this.mCanvasCtrl);
        this.mCanvasCtrl.setLocation(2, 2);
        this.updateTable();
        this.getTableEditor().getPivotTableInfo().applyPreferences();
        this.getTableEditor().removePTECloseListeners();
        this.getTableEditor().addPTECloseListener(new PTECloseListener(){

            public void close() {
                TableViewerItem.this.endEdit();
            }
        });
        this.relayout();
        return true;
    }

    public void deactivateLockedEdit() {
        Object object;
        if (this.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
            this.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit();
        }
        super.endEdit();
        this.setInPlaceEdit(false);
        this.remove((Component)this.mCanvasCtrl);
        this.mCanvasCtrl = null;
        boolean bl = false;
        if (this.getTableEditor().needsRerendering()) {
            object = this.getTableEditor().extractCompressedXML();
            if (object != null) {
                this.mCoreItem.replaceCompressedXML(object);
            }
            TableItem tableItem = (TableItem)this.mCoreItem;
            tableItem.setVDPData(this.getTableEditor().extractExternalizedData());
            tableItem.setDisplayedTableLookFilePath(this.getTableEditor().getPivotTableInfo().getDisplayedTableLookFilePath());
            this.getTableEditor().getPivotTableInfo().setExternalDataSource(null);
            this.mDataFilterInfo.setRowVariables(EditorUtil.getRowVariables((VisualizationSpecification)this.getTableEditor().getPivotTableInfo().getVisualizationSpecification()));
            this.cacheImage();
            bl = true;
        }
        this.getTableEditor().reset();
        object = (ViewerOutputPane)this.getParent();
        object.handleSelectionChange(this, false);
        object.scrollRectToVisible(this.getBounds());
        if (bl) {
            object.setDocumentModifiedFlag(bl);
        }
        this.revalidate();
    }

    public void gotoTableRows(TableSection tableSection) {
        switch (tableSection) {
            case FIRST_ROWS: {
                this.mDataFilterInfo.setActivePageId(0);
                break;
            }
            case PREVIOUS_ROWS: {
                if (this.mDataFilterInfo.getActivePageId() - 1 < 0) break;
                this.mDataFilterInfo.setActivePageId(this.mDataFilterInfo.getActivePageId() - 1);
                break;
            }
            case NEXT_ROWS: {
                if (this.mDataFilterInfo.getActivePageId() + 1 >= this.mDataFilterInfo.getTotalPageCount()) break;
                this.mDataFilterInfo.setActivePageId(this.mDataFilterInfo.getActivePageId() + 1);
                break;
            }
            case LAST_ROWS: {
                if (this.mDataFilterInfo.getTotalPageCount() - 1 < 0) break;
                this.mDataFilterInfo.setActivePageId(this.mDataFilterInfo.getTotalPageCount() - 1);
            }
        }
        Visualization visualization = VizCache.getCache().getVisualization((TableItem)this.mCoreItem);
        Map map = visualization.getUserSources();
        Set set = map.keySet();
        for (String string : set) {
            visualization.addUserSource((Source)map.get(string));
        }
        this.cacheImage();
        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
        viewerOutputPane.handleSelectionChange(this, false);
        viewerOutputPane.setDocumentModifiedFlag(true);
        this.revalidate();
    }

    public boolean isNavigateEnabled(TableSection tableSection) {
        boolean bl = false;
        if (!this.mDataFilterInfo.isDisplayFiltering()) {
            return bl;
        }
        switch (tableSection) {
            case FIRST_ROWS: {
                bl = this.mDataFilterInfo.getActivePageId() != 0;
                break;
            }
            case PREVIOUS_ROWS: {
                bl = this.mDataFilterInfo.getActivePageId() - 1 >= 0;
                break;
            }
            case NEXT_ROWS: {
                bl = this.mDataFilterInfo.getActivePageId() + 1 < this.mDataFilterInfo.getTotalPageCount();
                break;
            }
            case LAST_ROWS: {
                bl = this.mDataFilterInfo.getTotalPageCount() > 0 && this.mDataFilterInfo.getActivePageId() != this.mDataFilterInfo.getTotalPageCount() - 1;
            }
        }
        return bl;
    }

    public Visualization getVisForEditor() {
        PTInfo pTInfo = this.getTableEditor().getPivotTableInfo();
        Visualization visualization = VizCache.getCache().getVisualization((TableItem)this.getCoreItem());
        try {
            EditorUtil.setLayerHeightConsideringControlWidth((Visualization)visualization, (PTInfo)pTInfo);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return visualization;
    }

    private boolean isLockedDocument() {
        if (!VersionInfo.isSmartReader()) {
            return false;
        }
        ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
        IOutputDocument iOutputDocument = iTopWindow.getViewerDocument().getCoreDocument();
        return iOutputDocument.isLocked();
    }

    private void drawFeedback(Graphics2D graphics2D, URL uRL, boolean bl) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Font font2 = font.deriveFont(11.0f);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font2);
        if (bl) {
            graphics2D.translate(0, this.mCoreItem.getHeight() - FEEDBACK_HEIGHT - 1);
        }
        String string = String.format(ResUtil.getString("table_row_range"), this.mDataFilterInfo.getPageStartRow(), this.mDataFilterInfo.getPageEndRow(), this.mDataFilterInfo.getTotalRows());
        Visualization visualization = VizCache.getCache().getVisualization((TableItem)this.mCoreItem);
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        if (((LayerSpecification[])visualizationSpecification.findDescendantsOfType(LayerSpecification.class)).length > 0) {
            string = string + ResUtil.getString("table_row_hidden");
        }
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        this.mNavigateBarLength = (int)rectangle2D.getWidth() + 105;
        graphics2D.setFont(font2);
        graphics2D.translate(3, 0);
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.drawString(string, 0, (int)(rectangle2D.getHeight() + (double)FEEDBACK_HEIGHT) / 2);
        graphics2D.setFont(font);
        graphics2D.translate(2, 2);
        ImageIcon imageIcon = new ImageIcon(uRL);
        Image image = imageIcon.getImage();
        int n = this.mCoreItem.getWidth();
        int n2 = image.getWidth(null);
        graphics2D.translate(rectangle2D.getWidth() + (double)(n2 / 2), 0.0);
        int n3 = 0;
        while ((double)n3 < ((double)n - rectangle2D.getWidth()) / (double)n2 - 2.0) {
            graphics2D.drawImage(image, null, null);
            graphics2D.translate(n2, 0);
            ++n3;
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    private void updateLayerWhenEditEnd(VisualizationSpecification visualizationSpecification) {
        LabelSpecification labelSpecification = this.getLayerLabel(visualizationSpecification);
        if (labelSpecification != null) {
            FrameStyle frameStyle;
            TextStyle textStyle = labelSpecification.getStyle();
            if (textStyle != null) {
                textStyle.setVisible(Boolean.valueOf(true));
            }
            if ((frameStyle = labelSpecification.getTextFrameStyle()) != null) {
                frameStyle.setSecondaryColor(new Color(0, 0, 0, 0));
            }
            if (labelSpecification.getParent() instanceof LabelFrameSpecification) {
                LocationSpecification locationSpecification;
                LabelFrameSpecification labelFrameSpecification = (LabelFrameSpecification)labelSpecification.getParent();
                LocationSpecification locationSpecification2 = labelFrameSpecification.getLocation(LocationPartType.WIDTH);
                LocationSpecification locationSpecification3 = labelFrameSpecification.getLocation(LocationPartType.RIGHT);
                if (locationSpecification3 != null && locationSpecification2 != null) {
                    labelFrameSpecification.remove((Specification)locationSpecification2);
                }
                if ((locationSpecification = labelFrameSpecification.getLocation(LocationPartType.HEIGHT)) != null) {
                    locationSpecification.setSizeToContent();
                }
            }
        }
    }

    private LabelSpecification getLayerLabel(VisualizationSpecification visualizationSpecification) {
        DescriptionGroupSpecification[] descriptionGroupSpecificationArray;
        LabelSpecification labelSpecification = null;
        for (DescriptionGroupSpecification descriptionGroupSpecification : descriptionGroupSpecificationArray = (DescriptionGroupSpecification[])visualizationSpecification.findDescendantsOfType(DescriptionGroupSpecification.class)) {
            Specification specification;
            Specification specification2 = descriptionGroupSpecification.getTarget();
            if (!(specification2 instanceof FacetingSpecification) || !((specification = descriptionGroupSpecification.getParent()) instanceof LabelSpecification)) continue;
            labelSpecification = (LabelSpecification)specification;
            break;
        }
        return labelSpecification;
    }

    public static enum TableSection {
        FIRST_ROWS,
        PREVIOUS_ROWS,
        NEXT_ROWS,
        LAST_ROWS;

    }
}

