/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.AppMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.uitools.util.CharacterUtil;
import com.spss.vis.CustomOutputManager;
import com.spss.vis.ItemInfo;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Source;
import com.spss.vis.Visualization;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.processors.picking.InformationProcessor;
import com.spss.vis.processors.table.TableExportProcessor;
import com.spss.vis.processors.table.TableItem;
import com.spss.vis.processors.table.TableItemType;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.label.TextSpecification;
import com.spss.vizimager.DataFilterInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterJob;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableSearcher {
    private TableViewerItem mCurrentTable = null;
    private Visualization mVisualization = null;
    private List<String[]> mLayerNames = null;
    private TableExportProcessor mProcessor = null;
    private String[] mOriginalLayer = null;
    private String[] mCurrentLayer = null;
    private Point mCurrentCell = new Point(-1, -1);
    private Point mCellLocation = new Point();
    private TableSearchCell[][] mCells = null;
    private int mPurrentPage = -1;

    public TableSearcher() {
        this.mProcessor = new TableExportProcessor();
    }

    public TableViewerItem getCurrentTable() {
        return this.mCurrentTable;
    }

    public boolean findPattern(TableViewerItem tableViewerItem, Pattern pattern, ViewerSearchOptions viewerSearchOptions, int n) throws VisualizationException {
        if (tableViewerItem != this.mCurrentTable) {
            this.clear();
            this.buildTableData(tableViewerItem);
            this.mCurrentTable = tableViewerItem;
        }
        return this.findText(pattern, viewerSearchOptions, n);
    }

    public void clear() {
        if (this.mCurrentTable != null && this.mCurrentTable.getTableEditor() != null && !this.mCurrentTable.isInEditMode()) {
            this.mCurrentTable.getTableEditor().dispose();
        }
        this.mCurrentTable = null;
        this.mVisualization = null;
        this.mLayerNames = null;
        this.mOriginalLayer = null;
        this.mCurrentLayer = null;
        this.mCurrentCell = new Point(-1, -1);
        this.mCells = null;
        this.mPurrentPage = -1;
    }

    public void setCurrentSearchLayer(ViewerSearchOptions viewerSearchOptions) {
        String[] stringArray = this.getCurrentLayer();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ViewerItem viewerItem = viewerSearchOptions.getCurrentItem();
        if (viewerItem instanceof TableViewerItem) {
            TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
            tableViewerItem.getTableEditor().getPivotTableInfo().getImageComponent().setCurrentLayer(stringArray);
        }
    }

    public void restoreOriginalSearchLayer(ViewerSearchOptions viewerSearchOptions) {
        String[] stringArray = this.getOriginalLayer();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ViewerItem viewerItem = viewerSearchOptions.getCurrentItem();
        if (viewerItem instanceof TableViewerItem) {
            TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
            tableViewerItem.getTableEditor().getPivotTableInfo().getImageComponent().setCurrentLayer(stringArray);
        }
    }

    public String[] getCurrentLayer() {
        return this.mCurrentLayer;
    }

    public String[] getOriginalLayer() {
        return this.mOriginalLayer;
    }

    public Point getCellLocation() {
        return this.mCellLocation;
    }

    public void setCellLocation(Point point) {
        this.mCellLocation = point;
    }

    public boolean currentCellIsLayerLabel() {
        if (this.mCells == null || this.mCurrentCell == null) {
            return false;
        }
        TableSearchCell tableSearchCell = this.mCells[this.mCurrentCell.x][this.mCurrentCell.y];
        return tableSearchCell.getCellItemType() == TableItemType.LAYER_LABEL;
    }

    public TableSearchCell getCurrentSearchCell() {
        if (this.mCells == null || this.mCurrentCell == null) {
            return null;
        }
        return this.mCells[this.mCurrentCell.x][this.mCurrentCell.y];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean findText(Pattern pattern, ViewerSearchOptions viewerSearchOptions, int n) throws VisualizationException {
        int n2;
        boolean bl = false;
        int n3 = n2 = this.mLayerNames != null ? this.mLayerNames.size() : 0;
        if (n2 > 1) {
            boolean bl2 = false;
            if (viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up) {
                void objectArray;
                int i = n2 - 1;
                while (objectArray >= 0) {
                    Object[] objectArray2 = this.mLayerNames.get((int)objectArray);
                    if (!bl2) {
                        boolean bl3 = bl2 = this.mCurrentLayer == null || Arrays.equals(this.mCurrentLayer, objectArray2);
                    }
                    if (bl2) {
                        if (!(this.mCells != null && this.mCurrentLayer != null && Arrays.equals(this.mCurrentLayer, objectArray2) || this.buildLayerCellData())) {
                            return false;
                        }
                        this.mCurrentLayer = objectArray2;
                        Visualization visualization = this.mVisualization;
                        synchronized (visualization) {
                            this.mVisualization.getCustomOutputManager(PrinterJob.getPrinterJob().defaultPage()).setCurrentLayer(this.mCurrentLayer);
                        }
                        bl = this.searchCurrentLayer(pattern, viewerSearchOptions, n);
                        if (bl) break;
                        this.resetLayerVariables();
                    }
                    --objectArray;
                }
            } else {
                for (Object[] objectArray : this.mLayerNames) {
                    if (!bl2) {
                        boolean bl4 = bl2 = this.mCurrentLayer == null || Arrays.equals(this.mCurrentLayer, objectArray);
                    }
                    if (!bl2) continue;
                    if (this.mCells == null || this.mCurrentLayer == null || !Arrays.equals(this.mCurrentLayer, objectArray)) {
                        this.mCurrentLayer = objectArray;
                        Visualization visualization = this.mVisualization;
                        synchronized (visualization) {
                            this.mVisualization.getCustomOutputManager(PrinterJob.getPrinterJob().defaultPage()).setCurrentLayer(this.mCurrentLayer);
                        }
                        if (!this.buildLayerCellData()) {
                            return false;
                        }
                    }
                    if (bl = this.searchCurrentLayer(pattern, viewerSearchOptions, n)) {
                        viewerSearchOptions.setCurrentLayer(this.mCurrentLayer);
                        break;
                    }
                    viewerSearchOptions.setCurrentLayer(null);
                    this.resetLayerVariables();
                }
            }
        } else {
            bl = this.searchCurrentLayer(pattern, viewerSearchOptions, n);
            viewerSearchOptions.setCurrentLayer(null);
        }
        if (!bl) {
            this.mCurrentLayer = null;
            this.resetLayerVariables();
            if (this.mCurrentTable != null && this.mOriginalLayer != null && this.mOriginalLayer.length > 0) {
                Visualization visualization = this.mVisualization;
                synchronized (visualization) {
                    this.mVisualization.getCustomOutputManager(PrinterJob.getPrinterJob().defaultPage()).setCurrentLayer(this.mOriginalLayer);
                }
            }
        }
        return bl;
    }

    private void resetLayerVariables() {
        int n = this.mLayerNames.size();
        if (n > 1) {
            this.mCells = null;
        }
        this.mCurrentCell = new Point(-1, -1);
    }

    private boolean searchCurrentLayer(Pattern pattern, ViewerSearchOptions viewerSearchOptions, int n) {
        boolean bl = false;
        this.mVisualization = this.mCurrentTable.getVisForEditor();
        DataFilterInfo dataFilterInfo = this.mCurrentTable.getDataFilterInfo();
        if (dataFilterInfo.isDisplayFiltering() && dataFilterInfo.getTotalPageCount() > 0) {
            int n2;
            int n3 = dataFilterInfo.getTotalPageCount();
            for (int i = n2 = this.mPurrentPage >= 0 ? this.mPurrentPage : 0; i < n3; ++i) {
                if (this.mPurrentPage != i) {
                    this.mCurrentCell = new Point(-1, -1);
                }
                this.mPurrentPage = i;
                dataFilterInfo.setActivePageId(i);
                Map map = this.mVisualization.getUserSources();
                Set set = map.keySet();
                for (String string : set) {
                    this.mVisualization.addUserSource((Source)map.get(string));
                }
                if (!this.buildLayerCellData()) {
                    return false;
                }
                bl = this.searchCurrentPage(pattern, viewerSearchOptions, n);
                if (!bl) {
                    continue;
                }
                break;
            }
        } else {
            bl = this.searchCurrentPage(pattern, viewerSearchOptions, n);
        }
        return bl;
    }

    private boolean searchCurrentPage(Pattern pattern, ViewerSearchOptions viewerSearchOptions, int n) {
        boolean bl;
        boolean bl2 = false;
        if (this.mCells == null) {
            return bl2;
        }
        int n2 = this.mCells.length;
        int n3 = this.mCells[0].length;
        boolean bl3 = bl = viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.up;
        if (this.mCurrentCell.x == -1 || this.mCurrentCell.y == -1) {
            this.mCurrentCell.x = bl ? n2 - 1 : 0;
            this.mCurrentCell.y = bl ? n3 - 1 : 0;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n4 = viewerSearchOptions.getOffset();
                TableSearchCell tableSearchCell = this.mCells[this.mCurrentCell.x][this.mCurrentCell.y];
                if (tableSearchCell != null) {
                    boolean bl4;
                    String string;
                    if (bl && n4 <= 0) {
                        if (this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
                            this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit(!viewerSearchOptions.isReplaceAll());
                        }
                        string = this.getCellValue(tableSearchCell);
                        n4 = string.length();
                        viewerSearchOptions.setOffset(n4);
                    } else {
                        string = this.getCellValue(tableSearchCell);
                    }
                    boolean bl5 = bl4 = bl && n4 == 0;
                    if (string.length() >= n4 && !bl4) {
                        Matcher matcher = pattern.matcher(string);
                        boolean bl6 = bl ? this.reverseFind(matcher, viewerSearchOptions) : matcher.find(n4);
                        if (bl6 && (!viewerSearchOptions.getMatchCells() || n == string.length())) {
                            bl2 = true;
                            if (!bl) {
                                viewerSearchOptions.setOffset(matcher.start());
                            } else if (viewerSearchOptions.getOffset() <= 0) {
                                if (this.mCurrentCell.x == 0) {
                                    if (this.mCurrentCell.y > 0) {
                                        --this.mCurrentCell.y;
                                    } else {
                                        viewerSearchOptions.setItemDone(true);
                                    }
                                }
                                this.mCurrentCell.x = this.mCurrentCell.x > 0 ? this.mCurrentCell.x - 1 : n2 - 1;
                            }
                            this.setCellLocation(tableSearchCell.getCellCenterPoint());
                            break;
                        }
                    }
                }
                if (this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
                    this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit(!viewerSearchOptions.isReplaceAll());
                }
                if (bl) {
                    viewerSearchOptions.setOffset(-1);
                    if (this.mCurrentCell.x > 0) {
                        --this.mCurrentCell.x;
                        continue;
                    }
                    this.mCurrentCell.x = n2 - 1;
                    break;
                }
                viewerSearchOptions.setOffset(0);
                if (this.mCurrentCell.x < n2 - 1) {
                    ++this.mCurrentCell.x;
                    continue;
                }
                this.mCurrentCell.x = 0;
                break;
            }
            if (bl2) break;
            if (this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor() != null) {
                this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor().commitEdit(!viewerSearchOptions.isReplaceAll());
            }
            if (bl) {
                if (this.mCurrentCell.y <= 0) break;
                --this.mCurrentCell.y;
            } else {
                if (this.mCurrentCell.y >= n3 - 1) break;
                ++this.mCurrentCell.y;
            }
            viewerSearchOptions.setOffset(bl ? -1 : 0);
        }
        return bl2;
    }

    private String getCellValue(TableSearchCell tableSearchCell) {
        boolean bl = this.mCurrentTable.isEditingInPlace() && this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor() != null;
        String string = bl ? this.mCurrentTable.getTableEditor().getPivotTableInfo().getTextEditor().getText() : tableSearchCell.getCellValue();
        return string == null ? "" : string;
    }

    private boolean reverseFind(Matcher matcher, ViewerSearchOptions viewerSearchOptions) {
        boolean bl = false;
        int n = 0;
        int n2 = viewerSearchOptions.getOffset();
        if (n2 > -1) {
            while (matcher.find(n)) {
                int n3 = matcher.start();
                n = matcher.end();
                if (n3 >= n2) continue;
                bl = true;
                viewerSearchOptions.setOffset(n3);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTableData(TableViewerItem tableViewerItem) {
        try {
            Visualization visualization = this.mVisualization = tableViewerItem.getVisForEditor();
            synchronized (visualization) {
                CustomOutputManager customOutputManager = this.mVisualization.getCustomOutputManager(PrinterJob.getPrinterJob().defaultPage());
                this.mLayerNames = customOutputManager.getLayers();
                this.mOriginalLayer = this.mLayerNames != null && this.mLayerNames.size() > 0 ? customOutputManager.getCurrentLayer() : null;
                this.mCurrentLayer = null;
                if (this.mLayerNames == null || this.mLayerNames.size() < 2) {
                    this.mCurrentLayer = this.mOriginalLayer;
                    if (!this.buildLayerCellData()) {
                        this.clear();
                    }
                }
            }
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            AppMgr.getAppMgr().handleOutOfMemoryCondition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildLayerCellData() {
        boolean bl = false;
        try {
            Object object = this.mVisualization;
            synchronized (object) {
                this.mVisualization.runProcessor((ResultsProcessor)this.mProcessor);
            }
            object = this.mProcessor.getRowHeights();
            float[] fArray = this.mProcessor.getColumnWidths();
            this.mCells = new TableSearchCell[fArray.length][((Visualization)object).length];
            Iterator iterator = this.mProcessor.getTableItems();
            while (iterator.hasNext()) {
                Point point;
                TableItem tableItem = (TableItem)iterator.next();
                TableItemType tableItemType = tableItem.getType();
                String string = CharacterUtil.characterIteratorToString((CharacterIterator)tableItem.getContents());
                if (tableItemType == null || string == null || string.length() == 0) continue;
                if (tableItemType == TableItemType.FOOTNOTE && string.length() > 3 && this.footnoteIsLinked(tableItem)) {
                    string = string.substring(3);
                }
                Rectangle rectangle = tableItem.getGridCellsSpanned();
                if (rectangle.x < 0 || rectangle.y < 0 || rectangle.x >= fArray.length || rectangle.y >= ((Visualization)object).length || (point = this.getCellCenterPoint(tableItem)) == null) continue;
                this.mCells[rectangle.x][rectangle.y] = new TableSearchCell(tableItemType, string, rectangle.getLocation(), point);
            }
            bl = true;
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean footnoteIsLinked(TableItem tableItem) {
        if (tableItem.getType() != TableItemType.FOOTNOTE) {
            return false;
        }
        Visualization visualization = this.mVisualization;
        synchronized (visualization) {
            LabelSpecification labelSpecification;
            Specification[] specificationArray;
            Specification specification = tableItem.getSpecification();
            if (specification instanceof LabelSpecification && (specificationArray = (labelSpecification = (LabelSpecification)specification).getChildren()).length > 0 && specificationArray[0] instanceof TextSpecification) {
                // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                TextSpecification textSpecification = (TextSpecification)specificationArray[0];
                String string = textSpecification.getUsesReference();
                return string != null && string.length() > 0;
            }
        }
        return false;
    }

    private boolean isTitleItemType(TableItemType tableItemType) {
        return tableItemType == TableItemType.TITLE || tableItemType == TableItemType.SUB_TITLE || tableItemType == TableItemType.SUB_SUB_TITLE || tableItemType == TableItemType.FOOTNOTE || tableItemType == TableItemType.SUB_FOOTNOTE || tableItemType == TableItemType.SUB_SUB_FOOTNOTE || tableItemType == TableItemType.CORNER_LABEL || tableItemType == TableItemType.LAYER_LABEL;
    }

    private boolean isTableItemType(TableItemType tableItemType) {
        return tableItemType == TableItemType.DATA || tableItemType == TableItemType.COLUMN_HEADER || tableItemType == TableItemType.ROW_HEADER;
    }

    private Point getCellCenterPoint(TableItem tableItem) {
        Point point = null;
        TableItemType tableItemType = tableItem.getType();
        if (this.isTitleItemType(tableItemType) || this.isTableItemType(tableItemType)) {
            point = tableItem.getBounds() != null ? this.getCenterPointFromTableItem(tableItem) : this.getCenterPointByInfoProcessor(tableItem);
        }
        return point;
    }

    private Point getCenterPointFromTableItem(TableItem tableItem) {
        Rectangle rectangle = tableItem.getBounds().getBounds();
        Point point = rectangle.getLocation();
        point.translate(rectangle.width / 2, rectangle.height / 2);
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point getCenterPointByInfoProcessor(TableItem tableItem) {
        String string;
        TableItemType tableItemType = tableItem.getType();
        HashMap<ItemInfo.Key, String[]> hashMap = new HashMap<ItemInfo.Key, String[]>();
        String[] stringArray = tableItem.getFacet();
        Specification specification = tableItem.getSpecification();
        String string2 = string = specification != null ? specification.getId() : null;
        if (stringArray == null && string == null) {
            if (tableItemType == TableItemType.TITLE) {
                return new Point(2, 2);
            }
            return null;
        }
        if (stringArray != null) {
            hashMap.put(ItemInfo.FACET_KEY, stringArray);
        }
        InformationProcessor informationProcessor = InformationProcessor.getInfoProcessor((String)string, hashMap);
        try {
            ItemInfo[] itemInfoArray = this.mVisualization;
            synchronized (this.mVisualization) {
                this.mVisualization.runProcessor((ResultsProcessor)informationProcessor);
                // ** MonitorExit[var8_8] (shouldn't be in output)
                for (ItemInfo itemInfo : itemInfoArray = informationProcessor.getItems()) {
                    Shape[] shapeArray = (Shape[])itemInfo.get(ItemInfo.SHAPE_KEY);
                    if (shapeArray == null || shapeArray.length == 0) continue;
                    Rectangle rectangle = shapeArray[0].getBounds();
                    Point point = rectangle.getLocation();
                    if (tableItemType == TableItemType.COLUMN_HEADER) {
                        point.translate(rectangle.width / 4, rectangle.height / 4);
                    } else {
                        point.translate(rectangle.width / 2, rectangle.height / 2);
                    }
                    return point;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public class TableSearchCell {
        private TableItemType mCellItemType;
        private String mValue;
        private Point mCellAddress;
        private Point mCellLocation;

        public TableSearchCell(TableItemType tableItemType, String string, Point point, Point point2) {
            this.mCellItemType = tableItemType;
            this.mValue = string.trim();
            this.mCellAddress = point;
            this.mCellLocation = point2;
        }

        public TableItemType getCellItemType() {
            return this.mCellItemType;
        }

        public String getCellValue() {
            return this.mValue;
        }

        public Point getCellCenterPoint() {
            return this.mCellLocation;
        }

        public Point getCellAddress() {
            return this.mCellAddress;
        }
    }
}

