/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.GenericViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerTreePane;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SelectSpssTreeNodes {
    private HashSet<Integer> mSelectedRowNumbers = new HashSet();
    private ViewerTreePane mViewerTreePane;
    private JTree mTree;
    private ITopWindow mVFrame;

    public SelectSpssTreeNodes(ITopWindow iTopWindow) {
        this.mVFrame = iTopWindow;
        this.mViewerTreePane = this.mVFrame.getViewerTreePane();
        this.mTree = this.mViewerTreePane.getViewerTree();
    }

    public void selectLastOutput() {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        for (int i = 0; i < this.mTree.getModel().getChildCount(this.mTree.getPathForRow(0).getLastPathComponent()); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getModel().getChild(this.mTree.getPathForRow(0).getLastPathComponent(), i);
            vector.add(defaultMutableTreeNode);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)((DefaultMutableTreeNode)vector.get(i)).getUserObject()).getItem();
            if (viewerItem.getComponentType() != ViewerDocument.ComponentType.header) continue;
            TreePath treePath = new TreePath(((DefaultMutableTreeNode)vector.get(i)).getPath());
            this.mViewerTreePane.selectNodes(true, treePath, false, false);
            this.setFocusOnSpssTreeNode(this.mTree.getRowForPath(treePath));
            return;
        }
    }

    public void selectAllOfThisType(ArrayList<ViewerItem> arrayList, boolean bl, boolean bl2) {
        ArrayList<ViewerDocument.ComponentType> arrayList2 = this.getUniqueComponentTypes(arrayList);
        for (ViewerDocument.ComponentType componentType : arrayList2) {
            this.selectNodeType(componentType, bl, bl2);
        }
    }

    public void selectAllOfThisSubType(ArrayList<ViewerItem> arrayList, boolean bl) {
        ArrayList<String> arrayList2 = this.getUniqueSubTypeNames(arrayList);
        for (String string : arrayList2) {
            this.selectNodeSubType(string, bl);
        }
    }

    public void selectViewerItemsBasedOnName(ArrayList<ViewerItem> arrayList, CriteriaType criteriaType, String string, boolean bl) {
        int n;
        for (n = 1; n < this.mTree.getRowCount(); ++n) {
            TreePath treePath = this.mTree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            String string2 = viewerItem.getCoreItem().getDescription();
            boolean bl2 = false;
            if (string == null || string.length() <= 0) continue;
            switch (criteriaType) {
                case BeginsWith: {
                    if (string2.indexOf(string) != 0) break;
                    bl2 = true;
                    break;
                }
                case Contains: {
                    if (string2.indexOf(string) == -1) break;
                    bl2 = true;
                    break;
                }
                case EndsWith: {
                    int n2 = string2.lastIndexOf(string);
                    if (n2 == -1 || n2 + string.length() != string2.length()) break;
                    bl2 = true;
                    break;
                }
                case Exactly: {
                    if (!string2.equalsIgnoreCase(string)) break;
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            this.mSelectedRowNumbers.add(n);
        }
        n = this.selectRows(this.mSelectedRowNumbers);
        if (bl) {
            this.setFocusOnSpssTreeNode(n);
        }
    }

    private ArrayList<ViewerDocument.ComponentType> getUniqueComponentTypes(ArrayList<ViewerItem> arrayList) {
        ArrayList<ViewerDocument.ComponentType> arrayList2 = new ArrayList<ViewerDocument.ComponentType>();
        for (ViewerItem viewerItem : arrayList) {
            if (arrayList2.contains((Object)viewerItem.getComponentType())) continue;
            arrayList2.add(viewerItem.getComponentType());
        }
        return arrayList2;
    }

    private ArrayList<String> getUniqueSubTypeNames(ArrayList<ViewerItem> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ViewerItem viewerItem : arrayList) {
            if (arrayList2.contains(viewerItem.getCoreItem().getSubType())) continue;
            arrayList2.add(viewerItem.getCoreItem().getSubType());
        }
        return arrayList2;
    }

    public void selectNodes(ArrayList<ViewerItem> arrayList, boolean bl) {
        int n;
        block0: for (n = 1; n < this.mTree.getRowCount(); ++n) {
            TreePath treePath = this.mTree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            for (ViewerItem viewerItem2 : arrayList) {
                if (viewerItem != viewerItem2) continue;
                this.mSelectedRowNumbers.add(n);
                continue block0;
            }
        }
        n = this.selectRows(this.mSelectedRowNumbers);
        if (bl) {
            this.setFocusOnSpssTreeNode(n);
        }
    }

    public void selectNodeType(ViewerDocument.ComponentType componentType) {
        this.selectNodeType(componentType, false, true);
    }

    public void selectNodeType(ViewerDocument.ComponentType componentType, boolean bl, boolean bl2) {
        int n;
        boolean bl3 = false;
        for (n = 1; n < this.mTree.getRowCount(); ++n) {
            boolean bl4;
            TreePath treePath = this.mTree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            bl3 = false;
            if (viewerItem instanceof GenericViewerItem) {
                bl3 = ((GenericItem)viewerItem.getCoreItem()).isTreeImage();
            }
            if (componentType == ViewerDocument.ComponentType.tree && bl3) {
                this.mSelectedRowNumbers.add(n);
            }
            if (!(bl4 = this.areEqualTypes(viewerItem, componentType, bl)) || componentType == ViewerDocument.ComponentType.generic && bl3) continue;
            this.mSelectedRowNumbers.add(n);
        }
        n = this.selectRows(this.mSelectedRowNumbers);
        if (bl2) {
            this.setFocusOnSpssTreeNode(n);
        }
    }

    private boolean areEqualTypes(ViewerItem viewerItem, ViewerDocument.ComponentType componentType, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = viewerItem.getComponentType() == componentType;
        if (bl && (viewerItem.getComponentType() == ViewerDocument.ComponentType.graphboard || viewerItem.getComponentType() == ViewerDocument.ComponentType.chart || viewerItem.getComponentType() == ViewerDocument.ComponentType.jsonChart)) {
            bl2 = componentType == ViewerDocument.ComponentType.graphboard || componentType == ViewerDocument.ComponentType.jsonChart || componentType == ViewerDocument.ComponentType.chart;
        }
        return bl2;
    }

    public void selectNodeSubType(String string, boolean bl) {
        int n;
        boolean bl2 = false;
        for (n = 1; n < this.mTree.getRowCount(); ++n) {
            TreePath treePath = this.mTree.getPathForRow(n);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            if (!viewerItem.getCoreItem().getSubType().equalsIgnoreCase(string)) continue;
            this.mSelectedRowNumbers.add(n);
        }
        n = this.selectRows(this.mSelectedRowNumbers);
        if (bl) {
            this.setFocusOnSpssTreeNode(n);
        }
    }

    private int selectRows(HashSet<Integer> hashSet) {
        int[] nArray = new int[this.mSelectedRowNumbers.size()];
        Iterator<Integer> iterator = this.mSelectedRowNumbers.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            nArray[n] = iterator.next();
            if (n2 < nArray[n]) {
                n2 = nArray[n];
            }
            ++n;
        }
        this.mTree.setSelectionRows(nArray);
        return n2;
    }

    public boolean enableSelectAllMenu() {
        return this.mTree.getRowCount() > 1;
    }

    public boolean enableOutPutMenu() {
        boolean bl = false;
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        for (int i = 0; i < this.mTree.getModel().getChildCount(this.mTree.getPathForRow(0).getLastPathComponent()); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getModel().getChild(this.mTree.getPathForRow(0).getLastPathComponent(), i);
            vector.add(defaultMutableTreeNode);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)((DefaultMutableTreeNode)vector.get(i)).getUserObject()).getItem();
            if (viewerItem.getComponentType() != ViewerDocument.ComponentType.header) continue;
            bl = true;
        }
        return !this.mTree.isCollapsed(0) && bl;
    }

    public boolean enableAlignmentMenuItem() {
        TreePath[] treePathArray = this.mTree.getSelectionPaths();
        if (treePathArray != null) {
            for (TreePath treePath : treePathArray) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
                if (treePath.getLastPathComponent().equals(this.mTree.getModel().getRoot())) {
                    return true;
                }
                if (viewerItem.getComponentType() == ViewerDocument.ComponentType.log || viewerItem.getComponentType() == ViewerDocument.ComponentType.text) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNodeTypePresent(ViewerDocument.ComponentType componentType) {
        boolean bl = false;
        for (int i = 1; i < this.mTree.getRowCount(); ++i) {
            TreePath treePath = this.mTree.getPathForRow(i);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
            bl = false;
            if (viewerItem instanceof GenericViewerItem) {
                bl = ((GenericItem)viewerItem.getCoreItem()).isTreeImage();
            }
            if (componentType == ViewerDocument.ComponentType.tree && bl) {
                return true;
            }
            if (viewerItem.getComponentType() != componentType || componentType == ViewerDocument.ComponentType.generic && bl) continue;
            return true;
        }
        return false;
    }

    public void setFocusOnSpssTreeNode(int n) {
        if (this.mTree == null || n < 0 || this.mTree.getRowCount() <= n) {
            return;
        }
        TreePath treePath = this.mTree.getPathForRow(n);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        ViewerItem viewerItem = ((ViewerTreePane.NavTreeNode)defaultMutableTreeNode.getUserObject()).getItem();
        this.mVFrame.getViewerDocument().setFocusedViewerItem(viewerItem);
    }

    public static enum CriteriaType {
        Contains,
        Exactly,
        BeginsWith,
        EndsWith;

    }
}

