/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.pasw.framework.common.container.Container;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.modelviewer.IModelItemUIAgent;
import com.spss.java_client.core.documents.output.modelviewer.ModelItem;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pivottable.util.PvtLogger;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.modelviewer.ModelViewer;
import com.spss.vis.modelviewer.component.ModelViewerUIComponent;
import com.spss.vis.modelviewer.component.ModelViewerUIComponentImpl;
import com.spss.vis.modelviewer.view.ViewInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.UUID;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ModelViewerItem
extends ViewerItem
implements IModelItemUIAgent {
    private ModelItem mOutputItem = null;
    private ViewerImage mImage = new ViewerImage();
    private ModelViewerFrame mFrame = null;
    private Dimension mPrefSize = null;
    private FontRenderContext mFrc = new FontRenderContext(null, true, false);
    private static Color mSelectionColor = UIManager.getColor("Menu.selectionBackground");
    private static int sIconGap = 5;

    public ModelViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        this.setName(iOutputItem.getDescription());
        if (iOutputItem instanceof ModelItem) {
            this.mOutputItem = (ModelItem)iOutputItem;
            this.setRendered(false);
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.model;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            ImageGenerator2.ImageContainer imageContainer = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = imageContainer.get();
            this.mImage = new ViewerImage(this, bufferedImage, imageContainer.isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 5, bufferedImage.getHeight() + 5));
        }
        int n = 120;
        int n2 = 120;
        ArrayList arrayList = this.mOutputItem.getImageIcons();
        if (arrayList != null && arrayList.size() > 0) {
            int n3 = this.mOutputItem.getViewIndex();
            int n4 = 2;
            int n5 = 0;
            if ((arrayList.size() - n3) * (n2 + sIconGap) > bufferedImage.getHeight()) {
                n5 = n3;
            } else {
                n5 = arrayList.size() - bufferedImage.getHeight() / (n2 + sIconGap);
                if (n5 < 0) {
                    n5 = 0;
                }
            }
            Shape shape = graphics2D.getClip();
            graphics2D.translate(2, 2);
            graphics2D.drawImage((Image)bufferedImage, n + 5, 1, null);
            graphics2D.drawRect(1, 1, bufferedImage.getWidth() + n + 3, bufferedImage.getHeight() + 2);
            for (int i = n5; i < arrayList.size() && n4 <= bufferedImage.getHeight(); n4 += n2 + sIconGap, ++i) {
                if (n4 + n2 > bufferedImage.getHeight()) {
                    graphics2D.setClip(new Rectangle(1, n4, n + 2, bufferedImage.getHeight() - n4));
                }
                if (n3 == i) {
                    Color color = graphics2D.getColor();
                    graphics2D.drawImage((Image)arrayList.get(i), 2, n4, 2 + n, n4 + n2, 0, 0, 120, 120, null);
                    graphics2D.setColor(new Color(mSelectionColor.getRed(), mSelectionColor.getGreen(), mSelectionColor.getBlue(), 120));
                    graphics2D.fillRect(1, n4, n, n2);
                    graphics2D.setColor(color);
                } else {
                    graphics2D.drawImage((Image)arrayList.get(i), 2, n4, 2 + n, n4 + n2, 0, 0, 120, 120, null);
                }
                graphics2D.draw(new Rectangle(1, n4, n, n2));
                if (n4 + n2 <= bufferedImage.getHeight()) continue;
                graphics2D.setClip(shape);
            }
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + n + 10, bufferedImage.getHeight() + 9));
        } else {
            graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
        }
        if (this.isInEditMode()) {
            if (arrayList != null && arrayList.size() > 0) {
                this.renderEditModeHatchPattern(graphics2D, this.mOutputItem.getWidth() + n + 6, this.mOutputItem.getHeight());
            } else {
                this.renderEditModeHatchPattern(graphics2D, this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
            }
        }
    }

    public void renderModelNoThumbnail(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            ImageGenerator2.ImageContainer imageContainer = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = imageContainer.get();
            this.mImage = new ViewerImage(this, bufferedImage, imageContainer.isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 5, bufferedImage.getHeight() + 5));
        }
        graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
    }

    public void print(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPrefSize == null) {
            BufferedImage bufferedImage = this.mImage.get();
            this.mPrefSize = bufferedImage == null ? ImageGenerator2.getImageGenerator().getDefaultImageSize() : new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        }
        return this.mPrefSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.mPrefSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean startEdit() {
        if (this.isInEditMode()) {
            if (this.mFrame != null) {
                this.mFrame.toFront();
            }
            return false;
        }
        super.startEdit();
        this.setCompDoc();
        this.mFrame.pack();
        Dimension dimension = this.mFrame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width > dimension2.width * 4 / 5 || dimension.height > dimension2.height * 4 / 5) {
            int n = dimension.width;
            int n2 = dimension.height;
            if (dimension.width > dimension2.width * 4 / 5) {
                n = dimension2.width * 4 / 5;
            }
            if (dimension.height > dimension2.height * 4 / 5) {
                n2 = dimension2.height * 4 / 5;
            }
            this.mFrame.setSize(n, n2);
        }
        this.mFrame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelViewerItem.this.mFrame.toFront();
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endEdit() {
        ModelViewerUIComponent modelViewerUIComponent;
        block9: {
            block10: {
                if (this.mFrame == null) {
                    return;
                }
                if (!this.isInEditMode()) {
                    return;
                }
                this.mFrame.setVisible(false);
                this.mFrame.reset();
                this.mFrame.dispose();
                this.mFrame = null;
                String string = null;
                String string2 = null;
                byte[] byArray = null;
                modelViewerUIComponent = this.mOutputItem.getModelViewer().getComponent();
                boolean bl = modelViewerUIComponent.getGraphboard(true).getModel().canUndo() || modelViewerUIComponent.getGraphboard(false).getModel().canUndo();
                try {
                    if (bl) {
                        ViewInfo[] viewInfoArray = this.mOutputItem.getModelViewer().getViewInformation();
                        string = ModelItem.getFirstMainViewName((ViewInfo[])viewInfoArray);
                        string2 = ModelItem.getFirstAuxiliaryViewName((ViewInfo[])viewInfoArray);
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        this.mOutputItem.getModelViewer().serialize(objectOutputStream);
                        byArray = byteArrayOutputStream.toByteArray();
                        objectOutputStream.close();
                        byteArrayOutputStream.close();
                    }
                    if (!bl) break block9;
                    if (string == null || string2 == null || byArray == null) break block10;
                }
                catch (IOException iOException) {
                    block11: {
                        block12: {
                            try {
                                iOException.printStackTrace();
                                if (!bl) break block11;
                                if (string == null || string2 == null || byArray == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    if (string != null && string2 != null && byArray != null) {
                                        this.mOutputItem.setMainViewName(string);
                                        this.mOutputItem.setAuxiliaryName(string2);
                                        this.mOutputItem.setEditedViewData(byArray);
                                    }
                                    this.mOutputItem.setMainViewVisualization(null);
                                }
                                SwingUtilities.invokeLater(new Runnable(modelViewerUIComponent){
                                    final /* synthetic */ ModelViewerUIComponent val$uiComp;
                                    {
                                        this.val$uiComp = modelViewerUIComponent;
                                    }

                                    @Override
                                    public void run() {
                                        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)ModelViewerItem.this.getParent();
                                        viewerOutputPane.handleSelectionChange(ModelViewerItem.this, false);
                                        viewerOutputPane.scrollRectToVisible(ModelViewerItem.this.getBounds());
                                        viewerOutputPane.setDocumentModifiedFlag(true);
                                        Graphboard graphboard = this.val$uiComp.getGraphboard(true);
                                        try {
                                            ModelViewerItem.this.mOutputItem.setHeight(graphboard.getVisualizationComponent().getVisualization().getOutputHeight(ModelViewerItem.this.mFrc) + 5);
                                            ModelViewerItem.this.mOutputItem.setWidth(graphboard.getVisualizationComponent().getVisualization().getOutputWidth(ModelViewerItem.this.mFrc) + 5);
                                        }
                                        catch (VisualizationException visualizationException) {
                                            visualizationException.printStackTrace();
                                        }
                                        ImageCache.getImageCache().remove(ModelViewerItem.this.mImage);
                                        ModelViewerItem.this.mImage = new ViewerImage();
                                        VizCache.getCache().clearItem(ModelViewerItem.this.mOutputItem.getId());
                                        ModelViewerItem.this.repaint();
                                        ModelViewerItem.super.endEdit();
                                    }
                                });
                                throw throwable;
                            }
                            this.mOutputItem.setMainViewName(string);
                            this.mOutputItem.setAuxiliaryName(string2);
                            this.mOutputItem.setEditedViewData(byArray);
                        }
                        this.mOutputItem.setMainViewVisualization(null);
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                this.mOutputItem.setMainViewName(string);
                this.mOutputItem.setAuxiliaryName(string2);
                this.mOutputItem.setEditedViewData(byArray);
            }
            this.mOutputItem.setMainViewVisualization(null);
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public void closeEditorWindow() {
        if (this.mFrame != null) {
            this.mFrame.close();
        }
    }

    public ModelItem getModelItem() {
        return this.mOutputItem;
    }

    public boolean addChart(String string, byte[] byArray, byte[] byArray2, ModelMapInfo modelMapInfo) {
        boolean bl = false;
        try {
            ChartItem chartItem = new ChartItem();
            chartItem.setChartType(false);
            chartItem.setDescription(string);
            chartItem.setVisible(true);
            chartItem.setCompressedXML(ByteBuffer.wrap(byArray));
            chartItem.setVDPData(ByteBuffer.wrap(byArray2));
            chartItem.setVDPid(UUID.randomUUID().getMostSignificantBits());
            if (modelMapInfo != null) {
                chartItem.setDataMapId(modelMapInfo.dataMapId);
                chartItem.setDataMapURI(modelMapInfo.dataMapUri);
                chartItem.setMainMapData(modelMapInfo.dataMapData);
                chartItem.setRefMapId(modelMapInfo.refMapId);
                chartItem.setRefMapURI(modelMapInfo.refMapUri);
                chartItem.setRefMapData(modelMapInfo.refMapData);
            } else {
                chartItem.setMainMapData(null);
                chartItem.setRefMapData(null);
            }
            ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
            ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
            IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
            IOutputItem iOutputItem = this.getCoreItem();
            if (iOutputDocument.insertItem((IOutputItem)chartItem, iOutputItem) && iOutputDocument.getUIAgent() instanceof ViewerFrame) {
                Vector<ViewerItem> vector = viewerDocument.getViewerItems();
                ViewerItem viewerItem = null;
                for (ViewerItem viewerItem2 : vector) {
                    if (!chartItem.equals(viewerItem2.getCoreItem())) continue;
                    viewerItem = viewerItem2;
                    break;
                }
                if (viewerItem != null) {
                    viewerDocument.setFocusedViewerItem(viewerItem);
                    viewerDocument.selectionChanged(viewerItem, true, false);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return bl;
    }

    @Override
    protected boolean canResize(int n) {
        return false;
    }

    private void setCompDoc() {
        ModelViewer modelViewer = this.mOutputItem.getModelViewer();
        ModelViewerUIComponent modelViewerUIComponent = modelViewer.getComponent();
        ((ModelViewerUIComponentImpl)modelViewerUIComponent).updateUILocale();
        this.mFrame = new ModelViewerFrame(this, modelViewer, ResUtil.getString("IDS_MODELVIEWER_EDITOR_TITLE"));
        modelViewerUIComponent.getGraphboard(true).setEditEnabled(false);
        modelViewerUIComponent.getGraphboard(true).getModel().clearUndo();
    }

    public void setSize(long l, long l2, long l3) {
    }

    public void setRendering(boolean bl) {
        if (bl) {
            this.mFrame.repaint();
        }
    }

    public ModelViewer getModelViewer() {
        return this.mOutputItem.getModelViewer();
    }

    public void reset() {
        this.mOutputItem.removeModelViewer();
    }

    @Override
    public void setRendered(boolean bl) {
        super.setRendered(bl);
        this.setToolTipText(bl ? TIP_TEXT : null);
    }

    public Container getPMMLContainer() {
        return this.mOutputItem.getPMMLContainer();
    }

    public Container getStatXMLContainer() {
        return this.mOutputItem.getStatXMLContainer();
    }

    public ArrayList<ModelViewer> getChildrenModelViewers() {
        return this.mOutputItem.getChildrenModelViewers();
    }

    public void showView(Point point) {
        ArrayList arrayList = this.mOutputItem.getImageIcons();
        int n = 120;
        int n2 = 120;
        if (arrayList != null && arrayList.size() > 0 && point.x > 0 && point.x < n) {
            BufferedImage bufferedImage = this.mImage.get();
            int n3 = 0;
            int n4 = this.mOutputItem.getViewIndex();
            int n5 = 0;
            if ((arrayList.size() - n4) * (n2 + sIconGap) > bufferedImage.getHeight()) {
                n5 = n4;
            } else {
                n5 = arrayList.size() - bufferedImage.getHeight() / (n2 + sIconGap);
                if (n5 < 0) {
                    n5 = 0;
                }
            }
            n3 = n5 + (point.y - 2) / (n2 + sIconGap);
            this.mOutputItem.setViewByIndex(n3);
        }
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            Dimension dimension = new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.setRendered(true);
            this.revalidate();
            this.repaint();
        }
    }

    public static class ModelMapInfo {
        public final long dataMapId;
        public final String dataMapUri;
        public final ByteBuffer dataMapData;
        public final long refMapId;
        public final String refMapUri;
        public final ByteBuffer refMapData;

        public ModelMapInfo(long l, String string, ByteBuffer byteBuffer, long l2, String string2, ByteBuffer byteBuffer2) {
            this.dataMapId = l;
            this.dataMapUri = string;
            this.dataMapData = byteBuffer;
            this.refMapId = l2;
            this.refMapUri = string2;
            this.refMapData = byteBuffer2;
        }
    }
}

