/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.ChartViewerItemHelper;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.officeopenxml.TemplateEntryException;
import com.spss.officeopenxml.excel2007.BaseMGOElementWriter;
import com.spss.officeopenxml.excel2007.ClusterMGOWriter;
import com.spss.officeopenxml.excel2007.ClusterWithErrorBarsMGOWriter;
import com.spss.officeopenxml.excel2007.ClusteredBoxplotMGOWriter;
import com.spss.officeopenxml.excel2007.ErrorBarClusteredMGOWriter;
import com.spss.officeopenxml.excel2007.GroupedScatterMGOWriter;
import com.spss.officeopenxml.excel2007.GroupedScatterWithFitLinesMGOWriter;
import com.spss.officeopenxml.excel2007.HistogramMGOWriter;
import com.spss.officeopenxml.excel2007.MultiBarLine;
import com.spss.officeopenxml.excel2007.MultiLineWithErrorBarsMGOWriter;
import com.spss.officeopenxml.excel2007.PieChartMGOWriter;
import com.spss.officeopenxml.excel2007.SimpleBarLine;
import com.spss.officeopenxml.excel2007.SimpleBoxplotMGOWriter;
import com.spss.officeopenxml.excel2007.SimpleErrorBar;
import com.spss.officeopenxml.excel2007.SimpleScatterMGOWriter;
import com.spss.officeopenxml.excel2007.StackedMGOWriter;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.PASWFileUtil;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.format.DateTimeType;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.format.MdyOrderType;
import com.spss.vis.specification.format.MonthRepresentationType;
import com.spss.vis.specification.format.ScientificType;
import com.spss.vis.specification.statistic.SmoothMethodType;
import com.spss.vis.specification.statistic.SmoothStatisticSpecification;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipException;
import org.apache.poi.ss.usermodel.DateUtil;

public class MGOHelper
extends ChartViewerItemHelper {
    private static String sCurrencyDolor = UIToolResUtil.getString((String)"CellFormatCurrencyDolor");
    private static String sCellFormatPercent = UIToolResUtil.getString((String)"CellFormatPercent");
    public static final String DAY_OF_WEEK = "DAY_OF_WEEK";
    public static final String MONTH_LONG = "MONTH_LONG";

    public static boolean isMGOSupporedForGraphType(ViewerItem viewerItem) {
        ChartViewerItemHelper.ChartType chartType;
        boolean bl = false;
        if (viewerItem instanceof ChartViewerItem && ((chartType = MGOHelper.getGraphicChartType(viewerItem)) != null && chartType == ChartViewerItemHelper.ChartType.SimpleBar || chartType == ChartViewerItemHelper.ChartType.ClusteredBar || chartType == ChartViewerItemHelper.ChartType.StackedBar || chartType == ChartViewerItemHelper.ChartType.SimpleLine || chartType == ChartViewerItemHelper.ChartType.MultipleLine || chartType == ChartViewerItemHelper.ChartType.PieChart || chartType == ChartViewerItemHelper.ChartType.SimpleScatter || chartType == ChartViewerItemHelper.ChartType.SimpleScatterWithFitLine || chartType == ChartViewerItemHelper.ChartType.GroupedScatter || chartType == ChartViewerItemHelper.ChartType.GroupedScatterWithFitLine || chartType == ChartViewerItemHelper.ChartType.SimpleHistogram || chartType == ChartViewerItemHelper.ChartType.SimpleBoxplot || chartType == ChartViewerItemHelper.ChartType.ClusteredBoxplot || chartType == ChartViewerItemHelper.ChartType.SimpleErrorBar || chartType == ChartViewerItemHelper.ChartType.ClusteredErrorBar || chartType == ChartViewerItemHelper.ChartType.OneDBoxplot)) {
            bl = true;
        }
        return bl;
    }

    public static boolean mgoSelectionNeedsOffice16(ViewerItem viewerItem) {
        ChartViewerItemHelper.ChartType chartType;
        boolean bl = false;
        if (viewerItem instanceof ChartViewerItem && ((chartType = MGOHelper.getGraphicChartType(viewerItem)) != null && chartType == ChartViewerItemHelper.ChartType.SimpleHistogram || chartType == ChartViewerItemHelper.ChartType.SimpleBoxplot || chartType == ChartViewerItemHelper.ChartType.ClusteredBoxplot || chartType == ChartViewerItemHelper.ChartType.OneDBoxplot)) {
            bl = true;
        }
        return bl;
    }

    public static boolean canDoMGOForSelection(ViewerDocument viewerDocument) {
        ViewerItem[] viewerItemArray = viewerDocument.getSelectedItems(true);
        return viewerItemArray.length == 1 && MGOHelper.isMGOSupporedForGraphType(viewerItemArray[0]);
    }

    public static boolean mgoSelectionNeedsOffice16(ViewerDocument viewerDocument) {
        ViewerItem[] viewerItemArray = viewerDocument.getSelectedItems(true);
        return viewerItemArray.length == 1 && MGOHelper.mgoSelectionNeedsOffice16(viewerItemArray[0]);
    }

    private static File createMGOTempFile() throws IOException {
        String string = PrefsMgr.getPrefsMgr().getTempPath();
        File file = PASWFileUtil.createTempFile((String)"mgo_clipboard", (String)".zip", (File)new File(string));
        file.deleteOnExit();
        return file;
    }

    public static BaseMGOElementWriter getMGOWriterForChartType(File file, BaseMGOElementWriter.GraphicInfo graphicInfo) {
        Object object = null;
        try {
            if (graphicInfo.getChartType() != null) {
                BaseMGOElementWriter.ChartType chartType = graphicInfo.getChartType();
                if (chartType == BaseMGOElementWriter.ChartType.SimpleBar || chartType == BaseMGOElementWriter.ChartType.SimpleLine) {
                    object = new SimpleBarLine(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.SimpleErrorBar) {
                    object = new SimpleErrorBar(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.ClusteredErrorBar) {
                    object = new ErrorBarClusteredMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.PieChart) {
                    object = new PieChartMGOWriter(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.SimpleHistogram) {
                    object = new HistogramMGOWriter(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.SimpleScatter || chartType == BaseMGOElementWriter.ChartType.SimpleScatterWithFitLine) {
                    object = new SimpleScatterMGOWriter(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.GroupedScatter) {
                    object = new GroupedScatterMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.GroupedScatterWithFitLine) {
                    object = new GroupedScatterWithFitLinesMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.SimpleBoxplot || chartType == BaseMGOElementWriter.ChartType.OneDBoxplot) {
                    object = new SimpleBoxplotMGOWriter(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo, chartType == BaseMGOElementWriter.ChartType.OneDBoxplot);
                } else if (chartType == BaseMGOElementWriter.ChartType.SimpleHistogram) {
                    object = new HistogramMGOWriter(file, (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.MultipleLine) {
                    object = !graphicInfo.hasErrorBars() ? new MultiBarLine(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo) : new MultiLineWithErrorBarsMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.StackedBar) {
                    object = new StackedMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.ClusteredBar) {
                    object = !graphicInfo.hasErrorBars() ? new ClusterMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo) : new ClusterWithErrorBarsMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                } else if (chartType == BaseMGOElementWriter.ChartType.ClusteredBoxplot) {
                    object = new ClusteredBoxplotMGOWriter(file, (BaseMGOElementWriter.LegendSplitGraphicInfo)graphicInfo);
                }
            }
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
        }
        catch (TemplateEntryException templateEntryException) {
            templateEntryException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static File writeMGOToTempFile(ViewerItem viewerItem) throws Exception {
        File file = MGOHelper.createMGOTempFile();
        BaseMGOElementWriter.GraphicInfo graphicInfo = MGOHelper.getGraphicInfo(viewerItem);
        BaseMGOElementWriter baseMGOElementWriter = MGOHelper.getMGOWriterForChartType(file, graphicInfo);
        baseMGOElementWriter.writeMGOFile();
        return file;
    }

    public static BaseMGOElementWriter.AxisInfo getAxisInfo(ViewerItem viewerItem, ChartViewerItemHelper.ChartType chartType, String string) {
        return MGOHelper.getAxisInfo(viewerItem, chartType, string, true);
    }

    public static BaseMGOElementWriter.AxisInfo getAxisInfo(ViewerItem viewerItem, ChartViewerItemHelper.ChartType chartType, String string, boolean bl) {
        ChartViewerItemHelper.RoleInfo roleInfo = ChartViewerItemHelper.getAxisValues(viewerItem, chartType, string, bl);
        ExcelFormatInfo excelFormatInfo = MGOHelper.getFormatForAxis(viewerItem, chartType, string);
        String string2 = ChartViewerItemHelper.getAxisLabel(viewerItem, string);
        boolean bl2 = ChartViewerItemHelper.isAxisCategorical(viewerItem, string);
        BaseMGOElementWriter.AxisInfo axisInfo = roleInfo != null ? new BaseMGOElementWriter.AxisInfo(string2, roleInfo.getValues(), roleInfo.getID(), roleInfo.getIdToLabelMap(), roleInfo.getCategoryOrder(), MGOHelper.convertToMGOExcelFormatInfo(excelFormatInfo), bl2) : null;
        return axisInfo;
    }

    public static BaseMGOElementWriter.GraphicInfo getGraphicInfo(ViewerItem viewerItem) {
        Object object = null;
        if (viewerItem instanceof ChartViewerItem) {
            ChartViewerItemHelper.ChartType chartType = MGOHelper.getGraphicChartType(viewerItem);
            boolean bl = true;
            boolean bl2 = MGOHelper.doesChartHaveColorSplit(chartType);
            object = bl2 ? new BaseMGOElementWriter.LegendSplitGraphicInfo() : new BaseMGOElementWriter.SimpleNoLegendGraphicInfo();
            if (object == null) {
                System.out.println("NULL GraphicInfo : Define in MGOHelper.getGraphicInfo(ViewerItem viewerItem)");
            }
            object.setChartType(MGOHelper.convertToMGOChartType(MGOHelper.getGraphicChartType(viewerItem)));
            BaseMGOElementWriter.AxisInfo axisInfo = MGOHelper.getAxisInfo(viewerItem, chartType, "x");
            BaseMGOElementWriter.AxisInfo axisInfo2 = MGOHelper.getAxisInfo(viewerItem, chartType, bl2 ? "split" : "y", bl);
            BaseMGOElementWriter.AxisInfo axisInfo3 = MGOHelper.getAxisInfo(viewerItem, chartType, bl2 ? "y" : "split");
            object.setVarXInfo(axisInfo);
            object.setVarYInfo(axisInfo2);
            object.setVarZInfo(axisInfo3);
            if (bl2) {
                object.setLegendLabel(ChartViewerItemHelper.getLegendLabel(viewerItem));
            }
            if (chartType == ChartViewerItemHelper.ChartType.SimpleScatterWithFitLine || chartType == ChartViewerItemHelper.ChartType.GroupedScatterWithFitLine) {
                object.setScatterFitlineType(MGOHelper.convertToMGOScatterFitLineTypes(ChartViewerItemHelper.getFitlineMethodTypes(viewerItem)));
            }
            MGOHelper.convertDateTimeToExcelFormat(axisInfo);
            BaseMGOElementWriter.AxisInfo axisInfo4 = object instanceof BaseMGOElementWriter.LegendSplitGraphicInfo ? axisInfo3 : axisInfo2;
            BaseMGOElementWriter.AxisInfo axisInfo5 = object instanceof BaseMGOElementWriter.LegendSplitGraphicInfo ? axisInfo2 : null;
            MGOHelper.applyStatsToData(viewerItem, axisInfo4, axisInfo5);
            if (!axisInfo.isCategorical()) {
                axisInfo.setCategoryOrderToXAxisOrder();
            }
            object.setTitleLabel(ChartViewerItemHelper.getGraphicTitleLabel(viewerItem));
            object.setHasErrorBars(ChartViewerItemHelper.isErrorBarChart(viewerItem));
            if (object instanceof BaseMGOElementWriter.SimpleNoLegendGraphicInfo) {
                BaseMGOElementWriter.SimpleNoLegendGraphicInfo simpleNoLegendGraphicInfo = (BaseMGOElementWriter.SimpleNoLegendGraphicInfo)object;
                if (object.hasErrorBars()) {
                    ArrayList<String> arrayList = MGOHelper.convertToMGOErrorBarValues(object.getVarY(true), ChartViewerItemHelper.getAxisValues(viewerItem, chartType, "yLOW").getValues(), true);
                    simpleNoLegendGraphicInfo.setLowErrorBar(arrayList);
                    simpleNoLegendGraphicInfo.setHighErrorBars(arrayList);
                }
            } else if (object instanceof BaseMGOElementWriter.LegendSplitGraphicInfo) {
                if (object.hasErrorBars()) {
                    ArrayList<String> arrayList = MGOHelper.convertToMGOErrorBarValues(object.getVarZ(true), ChartViewerItemHelper.getAxisValues(viewerItem, chartType, "yLOW", false).getValues(), true);
                    object.setMasterLowErrorBarList(arrayList);
                    object.setMasterHighErrorBarsList(arrayList);
                }
                if (chartType != ChartViewerItemHelper.ChartType.ClusteredBoxplot && chartType != ChartViewerItemHelper.ChartType.GroupedScatter && chartType != ChartViewerItemHelper.ChartType.GroupedScatterWithFitLine) {
                    MGOHelper.convertToMultiElementInfo(viewerItem, object, MGOHelper.doNullValues(chartType));
                } else {
                    object.setYAxisLabel(object.getZAxisLabel());
                }
            }
        }
        return object;
    }

    private static boolean doNullValues(ChartViewerItemHelper.ChartType chartType) {
        return chartType == ChartViewerItemHelper.ChartType.StackedBar || chartType == ChartViewerItemHelper.ChartType.MultipleLine || chartType == ChartViewerItemHelper.ChartType.StackedBar || chartType == ChartViewerItemHelper.ChartType.ClusteredBar || chartType == ChartViewerItemHelper.ChartType.ClusteredErrorBar;
    }

    private static void applyStatsToData(ViewerItem viewerItem, BaseMGOElementWriter.AxisInfo axisInfo, BaseMGOElementWriter.AxisInfo axisInfo2) {
        if (ChartViewerItemHelper.isYAxisStatistic(viewerItem)) {
            ArrayList arrayList = axisInfo2 != null ? axisInfo2.getRoleValues(false) : null;
            ArrayList arrayList2 = axisInfo2 != null ? axisInfo2.getCategoryOrder(false) : null;
            ArrayList arrayList3 = ChartViewerItemHelper.performStatsOnDataAxis(viewerItem, axisInfo.getRoleValues(false), arrayList, arrayList2);
            if (arrayList3 != null) {
                axisInfo.modifyValues(arrayList3);
            }
        }
    }

    private static void convertDateTimeToExcelFormat(BaseMGOElementWriter.AxisInfo axisInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseMGOElementWriter.ExcelFormatInfo.FormatType formatType = axisInfo.getFormatInfo().getFormatType();
        if (formatType == BaseMGOElementWriter.ExcelFormatInfo.FormatType.Date || formatType == BaseMGOElementWriter.ExcelFormatInfo.FormatType.DateTime || formatType == BaseMGOElementWriter.ExcelFormatInfo.FormatType.Time) {
            ArrayList arrayList2 = axisInfo.getRoleValues(false);
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string = (String)arrayList2.get(i);
                Date date = MGOHelper.convertToDate(string);
                double d = DateUtil.getExcelDate((Date)date, (boolean)false);
                arrayList.add("" + d);
            }
            if (arrayList != null) {
                axisInfo.modifyValues(arrayList);
                axisInfo.setCategoryOrderToXAxisOrder();
            }
        }
    }

    private static Date convertToDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    private static ArrayList<BaseMGOElementWriter.GraphicInfo.ScatterFitlineType> convertToMGOScatterFitLineTypes(ArrayList<SmoothStatisticSpecification> arrayList) {
        ArrayList<BaseMGOElementWriter.GraphicInfo.ScatterFitlineType> arrayList2 = new ArrayList<BaseMGOElementWriter.GraphicInfo.ScatterFitlineType>();
        for (SmoothStatisticSpecification smoothStatisticSpecification : arrayList) {
            if (smoothStatisticSpecification.getMethod() == SmoothMethodType.LINEAR) {
                arrayList2.add(BaseMGOElementWriter.GraphicInfo.ScatterFitlineType.LINEAR);
                continue;
            }
            if (smoothStatisticSpecification.getMethod() != SmoothMethodType.POLYNOMIAL) continue;
            if (smoothStatisticSpecification.getDegree() == 2) {
                arrayList2.add(BaseMGOElementWriter.GraphicInfo.ScatterFitlineType.QUADRATIC);
                continue;
            }
            if (smoothStatisticSpecification.getDegree() != 3) continue;
            arrayList2.add(BaseMGOElementWriter.GraphicInfo.ScatterFitlineType.CUBIC_FIT);
        }
        return arrayList2;
    }

    private static boolean doesChartHaveColorSplit(ChartViewerItemHelper.ChartType chartType) {
        return chartType == ChartViewerItemHelper.ChartType.StackedBar || chartType == ChartViewerItemHelper.ChartType.MultipleLine || chartType == ChartViewerItemHelper.ChartType.ClusteredBar || chartType == ChartViewerItemHelper.ChartType.ClusteredBoxplot || chartType == ChartViewerItemHelper.ChartType.ClusteredErrorBar || chartType == ChartViewerItemHelper.ChartType.GroupedScatter || chartType == ChartViewerItemHelper.ChartType.GroupedScatterWithFitLine;
    }

    private static void convertToMultiElementInfo(ViewerItem viewerItem, BaseMGOElementWriter.LegendSplitGraphicInfo legendSplitGraphicInfo, boolean bl) {
        BaseMGOElementWriter.AxisInfo axisInfo = legendSplitGraphicInfo.getXAxisInfo();
        BaseMGOElementWriter.AxisInfo axisInfo2 = legendSplitGraphicInfo.getYAxisInfo();
        BaseMGOElementWriter.AxisInfo axisInfo3 = legendSplitGraphicInfo.getZAxisInfo();
        legendSplitGraphicInfo.setYAxisLabel(legendSplitGraphicInfo.getZAxisLabel());
        String string = legendSplitGraphicInfo.getChartType() == BaseMGOElementWriter.ChartType.ClusteredBoxplot ? "x" : "split";
        ArrayList<String> arrayList = MGOHelper.getCategoryList(viewerItem, string);
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<String> arrayList2 = bl ? MGOHelper.getElementIDs(axisInfo.getRoleValues(false)) : MGOHelper.getXValues(arrayList.get(0), axisInfo2.getRoleValues(false), axisInfo.getRoleValues(false));
            ArrayList<String> arrayList3 = MGOHelper.getCategoryList(viewerItem, "x");
            ArrayList<BaseMGOElementWriter.LabelValuesPair> arrayList4 = new ArrayList<BaseMGOElementWriter.LabelValuesPair>();
            ArrayList<String> arrayList5 = ChartViewerItemHelper.getLabelsForValuesGivenRole(viewerItem, arrayList, axisInfo2.getRoleName());
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = arrayList.get(i);
                String string3 = arrayList5.get(i);
                ArrayList<String> arrayList6 = bl ? MGOHelper.getValues(string2, ValueType.VALUES, legendSplitGraphicInfo) : MGOHelper.getValues(string2, axisInfo2.getRoleValues(false), axisInfo3.getRoleValues(false));
                ArrayList<String> arrayList7 = legendSplitGraphicInfo.hasErrorBars() ? MGOHelper.getValues(string2, ValueType.LOW_ERROR, legendSplitGraphicInfo) : null;
                ArrayList<String> arrayList8 = legendSplitGraphicInfo.hasErrorBars() ? MGOHelper.getValues(string2, ValueType.HIGH_ERROR, legendSplitGraphicInfo) : null;
                arrayList4.add(new BaseMGOElementWriter.LabelValuesPair(string3, arrayList6, arrayList7, arrayList8));
            }
            if (arrayList2 != null) {
                axisInfo.modifyValues(arrayList2);
            }
            axisInfo3.resetLabelValuesPairs(arrayList4);
            axisInfo2.setFormatInfo(axisInfo3.getFormatInfo());
        }
    }

    private static ArrayList<String> getValues(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals(arrayList.get(i))) continue;
            arrayList3.add(arrayList2.get(i));
        }
        return arrayList3;
    }

    private static ArrayList<String> getXValues(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!string.equals(arrayList.get(i))) continue;
            arrayList3.add(arrayList2.get(i));
        }
        return arrayList3;
    }

    private static ArrayList<String> getValues(String string, ValueType valueType, BaseMGOElementWriter.LegendSplitGraphicInfo legendSplitGraphicInfo) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        BaseMGOElementWriter.AxisInfo axisInfo = legendSplitGraphicInfo.getXAxisInfo();
        BaseMGOElementWriter.AxisInfo axisInfo2 = legendSplitGraphicInfo.getYAxisInfo();
        BaseMGOElementWriter.AxisInfo axisInfo3 = legendSplitGraphicInfo.getZAxisInfo();
        ArrayList arrayList2 = axisInfo2.getRoleValues(false);
        ArrayList arrayList3 = axisInfo.getRoleValues(false);
        ArrayList arrayList4 = axisInfo3.getRoleValues(false);
        ArrayList arrayList5 = legendSplitGraphicInfo.getMasterLowErrorBarList();
        ArrayList arrayList6 = legendSplitGraphicInfo.getMasterHighErrorBarsList();
        ArrayList<XYZValues> arrayList7 = new ArrayList<XYZValues>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (!string.equals(arrayList2.get(i))) continue;
            String string3 = legendSplitGraphicInfo.hasErrorBars() && arrayList5 != null && i < arrayList5.size() ? (String)arrayList5.get(i) : null;
            string2 = legendSplitGraphicInfo.hasErrorBars() && arrayList6 != null && i < arrayList6.size() ? (String)arrayList6.get(i) : null;
            arrayList7.add(new XYZValues((String)arrayList3.get(i), (String)arrayList2.get(i), (String)arrayList4.get(i), string3, string2));
        }
        ArrayList<String> arrayList8 = MGOHelper.getElementIDs(arrayList3);
        for (int i = 0; i < arrayList8.size(); ++i) {
            string2 = arrayList8.get(i);
            XYZValues xYZValues = MGOHelper.findMatchingXValue(arrayList7, string2);
            if (xYZValues != null) {
                String string4 = xYZValues.getValue(valueType);
                arrayList.add(string4);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    private static XYZValues findMatchingXValue(ArrayList<XYZValues> arrayList, String string) {
        XYZValues xYZValues = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            XYZValues xYZValues2 = arrayList.get(i);
            if (!string.equalsIgnoreCase(xYZValues2.getxValue())) continue;
            xYZValues = xYZValues2;
            break;
        }
        return xYZValues;
    }

    private static ArrayList<String> getElementIDs(ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = arrayList.get(i);
            if (arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    private static ArrayList<String> convertToMGOErrorBarValues(ArrayList<String> arrayList, ArrayList<String> arrayList2, boolean bl) {
        ArrayList<String> arrayList3 = null;
        if (arrayList != null && arrayList2 != null && arrayList.size() == arrayList2.size()) {
            arrayList3 = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                Double d = null;
                d = arrayList2.get(i) != null ? (bl ? Double.valueOf(new Double(arrayList.get(i)) - new Double(arrayList2.get(i))) : Double.valueOf(new Double(arrayList2.get(i)) - new Double(arrayList.get(i)))) : new Double(0.0);
                if (d == null) continue;
                arrayList3.add("" + d);
            }
        }
        return arrayList3 != null ? arrayList3 : arrayList2;
    }

    private static BaseMGOElementWriter.ExcelFormatInfo convertToMGOExcelFormatInfo(ExcelFormatInfo excelFormatInfo) {
        BaseMGOElementWriter.ExcelFormatInfo.FormatType formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.String;
        switch (excelFormatInfo.getFormatType()) {
            case String: {
                formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.String;
                break;
            }
            case Numerical: {
                formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.Numerical;
                break;
            }
            case DateTime: {
                formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.DateTime;
                break;
            }
            case Date: {
                formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.Date;
                break;
            }
            case Time: {
                formatType = BaseMGOElementWriter.ExcelFormatInfo.FormatType.Time;
            }
        }
        return new BaseMGOElementWriter.ExcelFormatInfo(excelFormatInfo.getExcelFormatString(), formatType);
    }

    private static BaseMGOElementWriter.ChartType convertToMGOChartType(ChartViewerItemHelper.ChartType chartType) {
        BaseMGOElementWriter.ChartType chartType2 = BaseMGOElementWriter.ChartType.Other;
        switch (chartType) {
            case SimpleBar: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleBar;
                break;
            }
            case ClusteredBar: {
                chartType2 = BaseMGOElementWriter.ChartType.ClusteredBar;
                break;
            }
            case StackedBar: {
                chartType2 = BaseMGOElementWriter.ChartType.StackedBar;
                break;
            }
            case SimpleLine: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleLine;
                break;
            }
            case MultipleLine: {
                chartType2 = BaseMGOElementWriter.ChartType.MultipleLine;
                break;
            }
            case SimpleErrorBar: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleErrorBar;
                break;
            }
            case ClusteredErrorBar: {
                chartType2 = BaseMGOElementWriter.ChartType.ClusteredErrorBar;
                break;
            }
            case PieChart: {
                chartType2 = BaseMGOElementWriter.ChartType.PieChart;
                break;
            }
            case SimpleScatter: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleScatter;
                break;
            }
            case SimpleScatterWithFitLine: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleScatterWithFitLine;
                break;
            }
            case GroupedScatter: {
                chartType2 = BaseMGOElementWriter.ChartType.GroupedScatter;
                break;
            }
            case GroupedScatterWithFitLine: {
                chartType2 = BaseMGOElementWriter.ChartType.GroupedScatterWithFitLine;
                break;
            }
            case SimpleHistogram: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleHistogram;
                break;
            }
            case SimpleBoxplot: {
                chartType2 = BaseMGOElementWriter.ChartType.SimpleBoxplot;
                break;
            }
            case ClusteredBoxplot: {
                chartType2 = BaseMGOElementWriter.ChartType.ClusteredBoxplot;
                break;
            }
            case OneDBoxplot: {
                chartType2 = BaseMGOElementWriter.ChartType.OneDBoxplot;
                break;
            }
        }
        return chartType2;
    }

    public static ExcelFormatInfo getFormatForAxis(ViewerItem viewerItem, ChartViewerItemHelper.ChartType chartType, String string) {
        String string2;
        ExcelFormatInfo excelFormatInfo = new ExcelFormatInfo("General", ExcelFormatInfo.FormatType.String);
        VisualizationSpecification visualizationSpecification = MGOHelper.getVisSpecFromViewerItem(viewerItem);
        if (visualizationSpecification != null && (string2 = MGOHelper.getAxisColumnName(viewerItem, chartType, string)) != null) {
            FormatSpecification formatSpecification = MGOHelper.getFormatSpec(visualizationSpecification, string2);
            excelFormatInfo = MGOHelper.getExcelFormatFromFormatSpec(formatSpecification);
        }
        return excelFormatInfo;
    }

    protected static ExcelFormatInfo getExcelFormatFromFormatSpec(FormatSpecification formatSpecification) {
        ExcelFormatInfo.FormatType formatType = ExcelFormatInfo.FormatType.String;
        StringBuffer stringBuffer = new StringBuffer();
        if (formatSpecification != null) {
            if (formatSpecification.getBaseFormat() == null) {
                String string = MGOHelper.getNumberFormatFromSpec(formatSpecification);
                stringBuffer.append(string);
                formatType = ExcelFormatInfo.FormatType.Numerical;
            } else if (formatSpecification.getBaseFormat() == DateTimeType.DATE || formatSpecification.getBaseFormat() == DateTimeType.DATETIME) {
                String string = MGOHelper.getDateFormatFromSpec(formatSpecification);
                stringBuffer.append(string);
                if (formatSpecification.getBaseFormat() == DateTimeType.DATETIME) {
                    String string2 = MGOHelper.getTimeFormatFromSpec(formatSpecification);
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string2);
                }
                formatType = ExcelFormatInfo.FormatType.DateTime;
            } else if (formatSpecification.getBaseFormat() == DateTimeType.TIME) {
                String string = MGOHelper.getTimeFormatFromSpec(formatSpecification);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                formatType = ExcelFormatInfo.FormatType.Time;
            } else {
                stringBuffer.append("@");
            }
        } else {
            stringBuffer.append("General");
        }
        return new ExcelFormatInfo(stringBuffer.toString(), formatType);
    }

    private static String getTimeFormatFromSpec(FormatSpecification formatSpecification) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = formatSpecification.getShowHour();
        boolean bl2 = formatSpecification.getShowMinute();
        boolean bl3 = formatSpecification.getShowSecond();
        boolean bl4 = formatSpecification.getShowMillis();
        if (bl) {
            stringBuffer.append("hh");
        }
        if (bl2) {
            if (bl) {
                stringBuffer.append(":");
            }
            stringBuffer.append("mm");
        }
        if (bl3) {
            if (bl2) {
                stringBuffer.append(":");
            }
            stringBuffer.append("ss");
        }
        if (bl4) {
            if (bl3) {
                stringBuffer.append(".");
            }
            stringBuffer.append("ss");
        }
        return stringBuffer.toString();
    }

    private static String getDateFormatFromSpec(FormatSpecification formatSpecification) {
        StringBuffer stringBuffer = new StringBuffer();
        if (formatSpecification.getMdyOrder() == MdyOrderType.DAY_MONTH_YEAR) {
            if (formatSpecification.getYearAbbreviation().booleanValue()) {
                stringBuffer.append("dd-MMM-yy");
            } else {
                stringBuffer.append("dd-MMM-yyyy");
            }
        } else if (formatSpecification.getMdyOrder() == MdyOrderType.DAY_MONTH_YEAR) {
            if (formatSpecification.getMonth() == MonthRepresentationType.PADDED_NUMBER) {
                if (formatSpecification.getYearAbbreviation().booleanValue()) {
                    stringBuffer.append("dd.MM.yy");
                } else {
                    stringBuffer.append("dd.MM.yyyy");
                }
            } else if (formatSpecification.getYearAbbreviation().booleanValue()) {
                stringBuffer.append("d-MMM-yy");
            } else {
                stringBuffer.append("d-MMM-yyyy");
            }
        } else if (formatSpecification.getMdyOrder() == MdyOrderType.YEAR_MONTH_DAY) {
            if (formatSpecification.getMonth() == MonthRepresentationType.PADDED_NUMBER) {
                if (formatSpecification.getYearAbbreviation().booleanValue()) {
                    stringBuffer.append("yy/MM/dd");
                } else {
                    stringBuffer.append("yyyy/MM/dd");
                }
            } else if (formatSpecification.getYearAbbreviation().booleanValue()) {
                stringBuffer.append("yy-mm-dd");
            } else {
                stringBuffer.append("yyyy-mm-dd");
            }
        } else if (formatSpecification.getMdyOrder() == MdyOrderType.MONTH_DAY_YEAR) {
            if (formatSpecification.getYearAbbreviation().booleanValue()) {
                stringBuffer.append("MM/dd/yy");
            } else {
                stringBuffer.append("MM/dd/yyyy");
            }
        } else if (formatSpecification.getMdyOrder() == MdyOrderType.YEAR_MONTH_DAY) {
            if (formatSpecification.getYearAbbreviation().booleanValue()) {
                stringBuffer.append("yyDDD");
            } else {
                stringBuffer.append("yyyyDDD");
            }
        } else {
            boolean bl = formatSpecification.getShowDayOfWeek();
            boolean bl2 = formatSpecification.getShowWeek();
            boolean bl3 = formatSpecification.getShowMonth();
            boolean bl4 = formatSpecification.getShowYear();
            if (bl) {
                stringBuffer.append(DAY_OF_WEEK);
            } else if (bl3) {
                if (bl4) {
                    if (formatSpecification.getYearAbbreviation().booleanValue()) {
                        stringBuffer.append("MMM yy");
                    } else {
                        stringBuffer.append("MMM yyyy");
                    }
                } else {
                    stringBuffer.append(MONTH_LONG);
                }
            } else if (bl4) {
                boolean bl5 = formatSpecification.getShowQuarter();
                if (bl5) {
                    if (formatSpecification.getYearAbbreviation().booleanValue()) {
                        stringBuffer.append("q 'Q' yy");
                    } else {
                        stringBuffer.append("q 'Q' yy");
                    }
                } else if (bl2) {
                    if (formatSpecification.getYearAbbreviation().booleanValue()) {
                        stringBuffer.append("ww WK' yy");
                    } else {
                        stringBuffer.append("ww WK' yyyy");
                    }
                }
            } else {
                stringBuffer.append("DD");
            }
        }
        return stringBuffer.toString();
    }

    private static String getNumberFormatFromSpec(FormatSpecification formatSpecification) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = formatSpecification.getPrefix() != null && formatSpecification.getPrefix().equalsIgnoreCase(sCurrencyDolor);
        boolean bl3 = formatSpecification.getSuffix() != null && formatSpecification.getSuffix().equalsIgnoreCase(sCellFormatPercent);
        boolean bl4 = bl = formatSpecification.getUseGrouping() != null && formatSpecification.getUseGrouping() != false;
        if (bl2) {
            stringBuffer.append(SyntaxUtil.wrapTextDoubleQuotes(sCurrencyDolor));
        }
        if (!(bl3 && formatSpecification.getUseScientific() != ScientificType.FALSE || !bl2 && !bl)) {
            stringBuffer.append("#,##");
        }
        stringBuffer.append("0");
        if (formatSpecification.getMinimumFractionDigits() != null && formatSpecification.getMinimumFractionDigits() > 0) {
            stringBuffer.append(".");
            for (int i = 0; i < formatSpecification.getMinimumFractionDigits(); ++i) {
                stringBuffer.append("0");
            }
        }
        if (formatSpecification.getUseScientific() == ScientificType.TRUE) {
            stringBuffer.append("E+00");
        }
        if (bl3) {
            stringBuffer.append(sCellFormatPercent);
        }
        return stringBuffer.toString();
    }

    private static enum ValueType {
        VALUES,
        LOW_ERROR,
        HIGH_ERROR;

    }

    public static class ExcelFormatInfo {
        String mExcelFormatString;
        FormatType mFormatType;

        public ExcelFormatInfo(String string, FormatType formatType) {
            this.mExcelFormatString = string;
            this.mFormatType = formatType;
        }

        public String getExcelFormatString() {
            return this.mExcelFormatString;
        }

        public FormatType getFormatType() {
            return this.mFormatType;
        }

        public static enum FormatType {
            Numerical,
            String,
            Date,
            Time,
            DateTime;

        }
    }

    private static class XYZValues {
        String xValue;
        String yValue;
        String zValue;
        String lowErrorValue;
        String highErrorValue;

        public XYZValues(String string, String string2, String string3, String string4, String string5) {
            this.xValue = string;
            this.yValue = string2;
            this.zValue = string3;
            this.lowErrorValue = string4;
            this.highErrorValue = string5;
        }

        private String getValue(ValueType valueType) {
            String string = null;
            if (valueType == ValueType.VALUES) {
                string = this.getzValue();
            }
            if (valueType == ValueType.LOW_ERROR) {
                string = this.getLowErrorValue();
            } else if (valueType == ValueType.HIGH_ERROR) {
                string = this.getHighErrorValue();
            }
            return string;
        }

        public String getxValue() {
            return this.xValue;
        }

        public String getyValue() {
            return this.yValue;
        }

        public String getzValue() {
            return this.zValue;
        }

        public String getLowErrorValue() {
            return this.lowErrorValue;
        }

        public String getHighErrorValue() {
            return this.highErrorValue;
        }
    }
}

