/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.IPvtPivotTable;
import com.ibm.statistics.lighttable.LightPivotTable;
import com.ibm.statistics.lighttable.base.Footnote;
import com.ibm.statistics.lighttable.base.TableLayer;
import com.ibm.statistics.lighttable.data.CellData;
import com.ibm.statistics.lighttable.data.ExCellData;
import com.ibm.statistics.lighttable.renderer.SimpleRenderer;
import com.ibm.statistics.lighttable.ui.ITableViewerItemListener;
import com.ibm.statistics.lighttable.ui.LtCanvas;
import com.ibm.statistics.lighttable.ui.LtEditorFrame;
import com.ibm.statistics.lighttable.ui.LtEditorInfo;
import com.ibm.statistics.lighttable.ui.LtEditorRenderer;
import com.ibm.statistics.lighttable.ui.LtTableEditorListener;
import com.ibm.statistics.lighttable.ui.actions.menu_actions.WhatIsThisAction;
import com.ibm.statistics.lighttable.ui.edit.InPlaceEditor;
import com.ibm.statistics.lighttable.ui.menus.EditMenu;
import com.ibm.statistics.lighttable.ui.menus.FormatMenu;
import com.ibm.statistics.lighttable.ui.menus.InsertMenu;
import com.ibm.statistics.lighttable.ui.menus.PivotMenu;
import com.ibm.statistics.lighttable.ui.menus.ViewMenu;
import com.ibm.statistics.lighttable.ui.scripting.LtPivotTable;
import com.ibm.statistics.lighttable.ui.util.TableGenerator;
import com.ibm.statistics.lighttable.ui.util.TableToGraphboardSource;
import com.ibm.statistics.lighttable.util.FootnoteHandler;
import com.spss.charteditor.template.ApplyTemplate;
import com.spss.charteditor.util.StringComparator;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.core.documents.output.lighttable.LightTableItem;
import com.spss.java_client.core.documents.output.table.ITableItemUIAgent;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.CloseAction;
import com.spss.java_client.ui.doc_types.actions.output.ConvertLightTableAction;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.ThinMenuBarBorder;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.TableToGraphboardTemplateChooser;
import com.spss.java_client.ui.doc_types.output.TableViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.pivottable.gui.TableEditorFrame;
import com.spss.pivottable.util.PvtLogger;
import com.spss.shared.export.ExportCopyParams;
import com.spss.shared.export.IExporterFactory;
import com.spss.shared.export.ISpssExportable;
import com.spss.shared.export.table_export.ExporterFactory;
import com.spss.shared.export.table_export.TableImager;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.IOptionConstants;
import com.spss.uitools.util.IUISearchAndReplaceProxy;
import com.spss.uitools.util.TraceSettings;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vizimager.VizDataWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.text.BreakIterator;
import java.text.Collator;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LightTableViewerItem
extends ViewerItem
implements LtTableEditorListener,
ITableViewerItemListener,
ITableItemUIAgent {
    private static final Dimension MEDIUM_TABLE_SIZE = new Dimension(800, 800);
    private SimpleRenderer mRenderer;
    private LtEditorFrame mEditorFrame;
    private LtEditorInfo mEditorInfo;
    private LightTableItem mTableItem;
    private DecimalFormatSymbols mSymbol;
    private static int SINGLE_LINE_LENGTH = 70;
    private static int MAX_LINE_LENGTH = 80;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public LightTableViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        if (iOutputItem != null) {
            String string = iOutputItem.getDescription();
            if (string != null && string.length() > 0 && (ComponentState.isBtdRtlOrLtr() || ComponentState.containsBidiLetter((String)string))) {
                this.setName(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                this.setName(string);
            }
            this.setRendered(false);
            this.setVisible(iOutputItem.getVisible());
        } else {
            this.setVisible(false);
        }
        this.mRenderer = null;
        this.mEditorFrame = null;
        this.mEditorInfo = null;
        this.mTableItem = (LightTableItem)iOutputItem;
        this.mSymbol = new DecimalFormatSymbols(UIToolResUtil.getSPSSLocale());
    }

    private boolean isVerbositySet() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node("output_labels");
        return preferences3.getBoolean("accessibility_verbosity", true);
    }

    public void setAccessibleText(Component component, Object object) {
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext != null) {
            if (object instanceof String) {
                String string = (String)object;
                accessibleContext.setAccessibleName(string);
            } else {
                accessibleContext.setAccessibleName(object == null ? "" : object.toString());
            }
        }
    }

    public void setAccessibleDescription(Component component, Object object) {
        AccessibleContext accessibleContext = component.getAccessibleContext();
        if (accessibleContext != null) {
            if (object instanceof String) {
                String string = (String)object;
                accessibleContext.setAccessibleDescription(string);
            } else {
                accessibleContext.setAccessibleDescription(object == null ? "" : object.toString());
            }
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        if (this.getCoreItem().getType() == OutputItemType.NOTE) {
            return ViewerDocument.ComponentType.notes;
        }
        if (this.getCoreItem().getType() == OutputItemType.WARNING) {
            return ViewerDocument.ComponentType.warning;
        }
        return ViewerDocument.ComponentType.ltable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderContents(Graphics2D graphics2D) {
        if (this.isInEditMode()) {
            return;
        }
        if (((LightTableItem)super.getCoreItem()).isDestroyed()) {
            return;
        }
        if (this.getCoreItem().isOutofMemory()) {
            graphics2D.drawImage((Image)ImageGenerator2.getImageGenerator().getOutofMemoryImage(), 0, 0, null);
        } else if (!this.getCoreItem().isValidTable()) {
            graphics2D.drawImage((Image)ImageGenerator2.getImageGenerator().getInvalidImage(), 0, 0, null);
        } else if (!this.getCoreItem().isComplete()) {
            graphics2D.drawImage((Image)ImageGenerator2.getImageGenerator().getWaitImage(), 0, 0, null);
            TableGenerator.getImageGenerator().createTable((ITableViewerItemListener)this);
        } else {
            IOutputItem iOutputItem = super.getCoreItem();
            synchronized (iOutputItem) {
                if (this.getCoreItem().getLightPivotTable() != null) {
                    this.getRenderer().render((Graphics)graphics2D, this.getVisibleRect());
                    this.setPreferredSize(new Dimension(this.getCoreItem().getWidth(), this.getCoreItem().getHeight()));
                    this.setSize(new Dimension(this.getCoreItem().getWidth(), this.getCoreItem().getHeight()));
                    if (!this.isRendered()) {
                        this.revalidate();
                    }
                    this.setRendered(true);
                    this.setSummaryTooltip();
                }
            }
        }
    }

    @Override
    public void refreshDisplay() {
        this.setSummaryTooltip();
        if (this.mRenderer != null) {
            this.mRenderer.clearDimBorderLines();
        }
        if (this.mEditorInfo != null && this.mEditorInfo.getRenderer() != null) {
            this.mEditorInfo.getRenderer().clearDimBorderLines();
        }
        this.refreshLayout();
    }

    @Override
    public void refreshLayout() {
        this.relayout();
        super.refreshDisplay();
        this.invalidate();
        this.repaint();
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.isInEditMode() && !this.isInPlaceMode()) {
            graphics.setColor(Color.black);
            this.getRenderer().render(graphics, this.getVisibleRect());
            this.renderEditModeHatchPattern((Graphics2D)graphics, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected boolean canResize(int n) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getCoreItem().getLightPivotTable() == null) {
            return ImageGenerator2.getImageGenerator().getDefaultImageSize();
        }
        Dimension dimension = new Dimension(200, 200);
        if (((LightTableItem)super.getCoreItem()).isDestroyed() || this.getCoreItem().getLightPivotTable().getTableSize() == null) {
            return dimension;
        }
        dimension = this.getCoreItem().getLightPivotTable().getTableSize();
        if (this.mEditorInfo != null && this.mEditorInfo.getCanvas() != null) {
            dimension = this.mEditorInfo.getCanvas().getCanvasSize();
        }
        int n = this.getCoreItem().getLightPivotTable().getTableMeasurer().getLayerLabelWidth();
        dimension.width = Math.max(dimension.width, n);
        ++dimension.width;
        ++dimension.height;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public LightTableItem getCoreItem() {
        return (LightTableItem)super.getCoreItem();
    }

    @Override
    public boolean isRendered() {
        return true;
    }

    @Override
    public boolean startEdit() {
        return this.startEdit(false);
    }

    public boolean startEdit(boolean bl) {
        Object object;
        if (this.mRenderer != null) {
            this.mRenderer.clearDimBorderLines();
        }
        if (this.isInEditMode() && this.mEditorFrame != null) {
            this.mEditorFrame.toFront();
            return false;
        }
        boolean bl2 = false;
        Container container = this.getTopLevelAncestor();
        container.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (!bl) {
                bl2 = super.startEdit();
            }
            this.mEditorInfo = this.getEditorInfo();
            if (this.mTableItem instanceof JsonTableItem) {
                this.mEditorInfo.setJsonTable(true);
            }
            this.mEditorInfo.getLightPivotTable().setInEditing(true);
            object = this.getTopLevelAncestor();
            if (object instanceof ITopWindow) {
                ViewerDocument viewerDocument = ((ITopWindow)object).getViewerDocument();
                this.mEditorInfo.setSearchProxy((IUISearchAndReplaceProxy)viewerDocument);
            }
            this.mEditorInfo.setDisplayedTableProperties(this.getCoreItem().getDisplayedTableProperties());
            this.mEditorInfo.setBaseUserPrefsPath(PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath());
            this.mEditorInfo.setVerbose(this.isVerbositySet());
            if (this.mEditorInfo.getLightPivotTable().isShowGridlines()) {
                this.mEditorInfo.getLightPivotTable().applyBordersOnly(this.mEditorInfo.getDisplayedTableProperties(), true);
            }
            this.convertActual2Visible();
            bl2 = this.isLockedDocument() ? this.activateLockedEdit() && bl2 : (this.isInPlaceMode() ? this.activateEdit(bl) && bl2 : this.activateOpen() && bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        container.setCursor(null);
        if (bl2) {
            object = this.mEditorInfo.getCanvas().getTitleText();
            this.setAccessibleText(this, "");
            this.setAccessibleText(this, object);
        }
        return bl2;
    }

    public String getTableName() {
        return this.mEditorInfo.getTableName();
    }

    public boolean activateOpen() {
        this.mEditorInfo.setLockedHeader(true);
        this.mEditorInfo.setSpvLocked(this.isLockedDocument());
        Container container = this.getTopLevelAncestor();
        this.mEditorFrame = new LtEditorFrame(container instanceof JFrame ? (JFrame)container : null, this.getCoreItem().getLightPivotTable(), this.getName(), this.mEditorInfo);
        this.mEditorFrame.addTableEditorListener((LtTableEditorListener)this);
        this.mEditorFrame.applyPreferences();
        this.mEditorFrame.setVisible(true);
        return true;
    }

    public boolean activateEdit(boolean bl) {
        if (!bl) {
            super.startEdit();
        }
        this.setInPlaceEdit(true);
        this.mEditorInfo.setLockedHeader(false);
        this.mEditorInfo.setSpvLocked(this.isLockedDocument());
        Container container = this.getTopLevelAncestor();
        this.mEditorFrame = new LtEditorFrame(container instanceof JFrame ? (JFrame)container : null, this.getCoreItem().getLightPivotTable(), this.getName(), this.mEditorInfo, bl);
        this.mEditorFrame.addTableEditorListener((LtTableEditorListener)this);
        this.mEditorInfo.getRenderer();
        this.add(this.mEditorInfo.getEditorFrame().getGlassPane(), 0);
        this.add((Component)this.mEditorInfo.getCanvas(), 1);
        this.updateViewerFrameMenus(true);
        this.updateViewerFrameToolBars(true);
        this.mEditorFrame.applyPreferences();
        this.relayout();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LightTableViewerItem.this.mEditorInfo != null && LightTableViewerItem.this.mEditorInfo.getCanvas() != null) {
                    LightTableViewerItem.this.mEditorInfo.getCanvas().requestFocusInWindow();
                }
            }
        });
        return true;
    }

    public boolean activateLockedEdit() {
        super.startEdit();
        this.setInPlaceEdit(true);
        this.mEditorInfo.setLockedHeader(true);
        this.mEditorInfo.setSpvLocked(this.isLockedDocument());
        Container container = this.getTopLevelAncestor();
        this.mEditorFrame = new LtEditorFrame(container instanceof JFrame ? (JFrame)container : null, this.getCoreItem().getLightPivotTable(), this.getName(), this.mEditorInfo, false);
        this.mEditorFrame.addTableEditorListener((LtTableEditorListener)this);
        this.mEditorInfo.getRenderer();
        this.add(this.mEditorInfo.getEditorFrame().getGlassPane(), 0);
        this.add((Component)this.mEditorInfo.getCanvas(), 1);
        this.mEditorInfo.getCanvas().requestFocusInWindow();
        this.mEditorFrame.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LightTableViewerItem.this.mEditorFrame.getTraysDlg().setVisible(true);
            }
        });
        this.relayout();
        return true;
    }

    public void relayout() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    LightTableViewerItem.this.positionItemControl();
                    LightTableViewerItem.this.revalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void endEdit() {
        Serializable serializable;
        if (this.mRenderer != null) {
            this.mRenderer.clearDimBorderLines();
        }
        if (this.mEditorInfo != null && this.mEditorInfo.getRenderer() != null) {
            this.mEditorInfo.getRenderer().clearDimBorderLines();
        }
        LightPivotTable lightPivotTable = this.mEditorInfo.getLightPivotTable();
        lightPivotTable.setInEditing(false);
        try {
            lightPivotTable.measureTable();
            serializable = lightPivotTable.getTableSize();
            int n = lightPivotTable.getTableMeasurer().getLayerLabelWidth();
            this.mTableItem.setWidth(Math.max(((Dimension)serializable).width, n) + 4);
            this.mTableItem.setHeight(((Dimension)serializable).height);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.mEditorInfo.getLightPivotTable().setValidLayer(true);
        if (this.mEditorInfo.getLightPivotTable().isShowGridlines()) {
            this.mEditorInfo.getLightPivotTable().applyBordersOnly(null, false);
        }
        serializable = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)serializable).handleSelectionChange(this, false);
        ((JComponent)serializable).scrollRectToVisible(this.getBounds());
        if (this.mEditorInfo.isModified()) {
            ((ViewerOutputPane)serializable).setDocumentModifiedFlag(true);
        }
        if (this.isLockedDocument()) {
            this.deactivateLockedEdit();
        } else if (this.isInPlaceEdit()) {
            this.deactivateEdit();
        } else {
            this.deactivateOpen();
        }
        this.mTableItem.setDisplayBreakpoint(false);
        this.mTableItem.setSelectedCells(null);
        super.endEdit();
    }

    @Override
    public void closeEditorWindow() {
        this.endEdit();
    }

    public LtEditorFrame getEditorFrame() {
        return this.mEditorFrame;
    }

    public synchronized SimpleRenderer getRenderer() {
        if (this.mRenderer == null) {
            this.mRenderer = new SimpleRenderer(this.getCoreItem().getLightPivotTable());
        }
        return this.mRenderer;
    }

    public boolean findPattern(Pattern pattern, ViewerSearchOptions viewerSearchOptions, int n) {
        if (this.mEditorInfo != null && this.mEditorInfo.getTextEditor() != null) {
            this.mEditorInfo.getTextEditor().commitEdit(viewerSearchOptions.getFindType() == ViewerSearchOptions.FindType.replace || viewerSearchOptions.getFindType() == ViewerSearchOptions.FindType.replaceall);
        }
        LightPivotTable lightPivotTable = this.getCoreItem().getLightPivotTable();
        boolean bl = false;
        int n2 = lightPivotTable.getLayerCount();
        if (n2 > 1) {
            int n3 = lightPivotTable.getCurrentLayerIndex();
            if (viewerSearchOptions.isFirstSearch() || viewerSearchOptions.getOriginalLightTableLayer() == -1) {
                viewerSearchOptions.setOriginalLightTableLayer(n3);
            }
            if (viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.down) {
                int n4;
                for (n4 = n3; n4 < n2 && (viewerSearchOptions.isFirstSearch() || n4 != viewerSearchOptions.getOriginalLightTableLayer() || n4 == n3); ++n4) {
                    this.setActiveSearchLayer(lightPivotTable, n4);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, pattern);
                    if (bl) break;
                    viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                }
                for (n4 = 0; n4 < n3 && !bl && (viewerSearchOptions.isFirstSearch() || n4 != viewerSearchOptions.getOriginalLightTableLayer()); ++n4) {
                    this.setActiveSearchLayer(lightPivotTable, n4);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, pattern);
                    if (!bl) {
                        viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                        continue;
                    }
                    break;
                }
            } else {
                int n5;
                for (n5 = n3; n5 >= 0 && (viewerSearchOptions.isFirstSearch() || n5 != viewerSearchOptions.getOriginalLightTableLayer() || n5 == n3); --n5) {
                    this.setActiveSearchLayer(lightPivotTable, n5);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, pattern);
                    if (bl) break;
                    viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                }
                for (n5 = n2 - 1; n5 > n3 && !bl && (viewerSearchOptions.isFirstSearch() || n5 != viewerSearchOptions.getOriginalLightTableLayer()); --n5) {
                    this.setActiveSearchLayer(lightPivotTable, n5);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, pattern);
                    if (!bl) {
                        viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                        continue;
                    }
                    break;
                }
            }
            if (!bl) {
                this.setActiveSearchLayer(lightPivotTable, viewerSearchOptions.getOriginalLightTableLayer());
            }
        } else {
            bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, pattern);
            viewerSearchOptions.setCurrentLayer(null);
        }
        if (bl && viewerSearchOptions.getFindType() == ViewerSearchOptions.FindType.replaceall) {
            this.doReplace(viewerSearchOptions, n);
        }
        viewerSearchOptions.setPreviousFind(bl);
        return bl;
    }

    public void ActivateTable() {
        this.getPivotTable();
    }

    public void DeactivateTable() {
        if (this.mRenderer != null) {
            this.mRenderer.clearDimBorderLines();
        }
        if (this.mEditorInfo != null && this.mEditorInfo.getRenderer() != null) {
            this.mEditorInfo.getRenderer().clearDimBorderLines();
        }
        this.mEditorInfo.getLightPivotTable().setInEditing(false);
        try {
            this.mEditorInfo.getLightPivotTable().measureTable();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.mEditorInfo.getLightPivotTable().setValidLayer(true);
        if (this.mEditorInfo.getLightPivotTable().isShowGridlines()) {
            this.mEditorInfo.getLightPivotTable().applyBordersOnly(null, false);
        }
        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
        viewerOutputPane.scrollRectToVisible(this.getBounds());
        if (this.mEditorInfo.isModified()) {
            viewerOutputPane.setDocumentModifiedFlag(true);
        }
        if (this.isLockedDocument()) {
            this.deactivateLockedEdit();
        } else if (this.isInPlaceEdit()) {
            this.deactivateEdit();
        } else {
            this.deactivateOpen();
        }
        this.mTableItem.setDisplayBreakpoint(false);
        this.mTableItem.setSelectedCells(null);
        super.endEdit();
    }

    public IPvtPivotTable getPivotTable() {
        if (this.mEditorInfo == null) {
            this.mEditorInfo = new LtEditorInfo(ComponentState.getILangLocale().getLanguage());
            this.mEditorInfo.setViewerItemListener((ITableViewerItemListener)this);
        }
        this.mEditorInfo.setLightPivotTable(this.getCoreItem().getLightPivotTable());
        this.mEditorInfo.getLightPivotTable().setInEditing(true);
        this.mEditorInfo.setDisplayedTableProperties(this.getCoreItem().getDisplayedTableProperties());
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        this.mEditorInfo.setBaseUserPrefsPath(preferences.absolutePath());
        this.mEditorInfo.setVerbose(this.isVerbositySet());
        if (this.mEditorInfo.getLightPivotTable().isShowGridlines()) {
            this.mEditorInfo.getLightPivotTable().applyBordersOnly(null, true);
        }
        new LtCanvas(this.mEditorInfo);
        this.mEditorInfo.getRenderer();
        this.convertActual2Visible();
        return new LtPivotTable(this.mEditorInfo);
    }

    public void dispose() {
        this.endEdit();
        if (this.mEditorFrame != null) {
            this.mEditorFrame.dispose();
            this.mEditorFrame = null;
            this.mEditorInfo = null;
        }
    }

    public void SaveImage(String string) {
        BufferedImage bufferedImage;
        int n = this.mTableItem.getWidth() + 5;
        int n2 = this.mTableItem.getHeight() + 5;
        try {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            bufferedImage = null;
            try {
                bufferedImage = new BufferedImage(500, 300, 13);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawString(outOfMemoryError.getMessage(), 20, 50);
                graphics2D.dispose();
                ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                bufferedImage = null;
            }
        }
        if (bufferedImage == null) {
            return;
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Color color = new Color(255, 255, 255, 0);
        graphics2D.setBackground(color);
        graphics2D.setColor(color);
        graphics2D.clearRect(0, 0, n, n2);
        this.getRenderer().render((Graphics)graphics2D);
        graphics2D.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void tableChanged() {
        this.revalidate();
        this.repaint();
    }

    public void tableEditorClosed() {
        if (this.isInEditMode()) {
            this.endEdit();
            this.repaint();
        }
    }

    public boolean convertToVizTable() {
        if (!this.isInEditMode() || this.mEditorFrame == null) {
            return false;
        }
        final Point point = this.mEditorFrame.getLocationOnScreen();
        final Dimension dimension = this.mEditorFrame.getSize();
        ConvertLightTableAction convertLightTableAction = (ConvertLightTableAction)ActionCatalog.getActionCatalog().getSpssAction("edit_convert_table");
        final Container container = this.getTopLevelAncestor();
        if (!(container instanceof ViewerFrame) || !convertLightTableAction.doConversion((ViewerFrame)container)) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerItem viewerItem = ((ViewerFrame)container).getDocument().getFocusedViewerItem();
                if (viewerItem instanceof TableViewerItem) {
                    TableViewerItem tableViewerItem = (TableViewerItem)viewerItem;
                    tableViewerItem.setInplaceMode(false);
                    tableViewerItem.startEdit();
                    TableEditorFrame tableEditorFrame = tableViewerItem.getTableEditor().getFrame();
                    tableEditorFrame.setLocation(point);
                    tableEditorFrame.setSize(dimension);
                    tableEditorFrame.invalidate();
                    tableEditorFrame.getCanvas().revalidate();
                }
            }
        });
        return true;
    }

    public boolean addChart(String string, byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        try {
            LightTableItem lightTableItem;
            VisualizationSpecification visualizationSpecification = new VisualizationSpecification(TableImager.getProperInputStream((byte[])byArray));
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            visualizationSpecification.writeXml((Writer)charArrayWriter);
            charArrayWriter.close();
            String string2 = charArrayWriter.toString();
            string2 = this.applyChartTemplates(string2);
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(string2.getBytes("UTF-8")));
            byArray = byteBuffer.array();
            ChartItem chartItem = new ChartItem();
            chartItem.setDescription(string);
            chartItem.setVisible(true);
            chartItem.setCompressedXML(ByteBuffer.wrap(byArray));
            chartItem.setVDPData(ByteBuffer.wrap(byArray2));
            chartItem.setVDPid(UUID.randomUUID().getMostSignificantBits());
            chartItem.setMainMapData(null);
            chartItem.setRefMapData(null);
            Container container = this.getTopLevelAncestor();
            if (!(container instanceof ITopWindow)) {
                return bl;
            }
            ITopWindow iTopWindow = (ITopWindow)((Object)container);
            IOutputDocument iOutputDocument = iTopWindow.getViewerDocument().getCoreDocument();
            if (iOutputDocument.insertItem((IOutputItem)chartItem, (IOutputItem)(lightTableItem = this.getCoreItem())) && iOutputDocument.getUIAgent() instanceof ITopWindow) {
                ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
                Vector<ViewerItem> vector = viewerDocument.getViewerItems();
                ViewerItem viewerItem = null;
                for (ViewerItem viewerItem2 : vector) {
                    if (!chartItem.equals(viewerItem2.getCoreItem())) continue;
                    viewerItem = viewerItem2;
                    break;
                }
                if (viewerItem != null) {
                    viewerDocument.setFocusedViewerItem(viewerItem);
                    viewerDocument.selectionChanged(viewerItem, true, false);
                }
                if (this.isInEditMode() && this.isInPlaceEdit()) {
                    this.endEdit();
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return bl;
    }

    public boolean addGraphboardChart(VisualizationSpecification visualizationSpecification, byte[] byArray, String string) {
        boolean bl = false;
        try {
            LightTableItem lightTableItem;
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            visualizationSpecification.writeXml((Writer)charArrayWriter);
            charArrayWriter.close();
            String string2 = charArrayWriter.toString();
            string2 = this.applyChartTemplates(string2);
            ByteBuffer byteBuffer = VizDataWriter.compressStream((ByteBuffer)ByteBuffer.wrap(string2.getBytes("UTF-8")));
            byte[] byArray2 = byteBuffer.array();
            ChartItem chartItem = new ChartItem();
            chartItem.setDescription(string);
            chartItem.setVisible(true);
            chartItem.setCompressedXML(ByteBuffer.wrap(byArray2));
            chartItem.setVDPData(ByteBuffer.wrap(byArray));
            chartItem.setVDPid(UUID.randomUUID().getMostSignificantBits());
            chartItem.setMainMapData(null);
            chartItem.setRefMapData(null);
            Container container = this.getTopLevelAncestor();
            if (!(container instanceof ITopWindow)) {
                return bl;
            }
            ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
            ViewerDocument viewerDocument = iTopWindow.getViewerDocument();
            IOutputDocument iOutputDocument = viewerDocument.getCoreDocument();
            if (iOutputDocument.insertItem((IOutputItem)chartItem, (IOutputItem)(lightTableItem = this.getCoreItem())) && iOutputDocument.getUIAgent() instanceof ITopWindow) {
                Vector<ViewerItem> vector = viewerDocument.getViewerItems();
                ViewerItem viewerItem = null;
                for (ViewerItem viewerItem2 : vector) {
                    if (!chartItem.equals(viewerItem2.getCoreItem())) continue;
                    viewerItem = viewerItem2;
                    break;
                }
                if (viewerItem != null) {
                    viewerDocument.setFocusedViewerItem(viewerItem);
                    viewerDocument.selectionChanged(viewerItem, true, false);
                }
                if (this.isInEditMode() && this.isInPlaceEdit()) {
                    this.endEdit();
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return bl;
    }

    public void classifyTableSize() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options").node("tables");
        String string = preferences2.get("editing_mode", PrefDefaults.DEF_EDITING_MODE);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_EDITING_MODE_VALUES, string);
        boolean bl = n == 0 ? true : (n == 2 ? false : this.classifyTableType());
        this.setInplaceMode(bl);
    }

    public Set<Integer> getVisibleBreakpointIndexSet(boolean bl) {
        return this.mTableItem.getVisibleBreakpointIndexSet(bl);
    }

    public Set<Integer> getActualBreakpointIndexSet(boolean bl) {
        return this.mTableItem.getActualBreakpointIndexSet(bl);
    }

    public Map<Integer, Integer> getVisibleTogetherMap(boolean bl) {
        return this.mTableItem.getVisibleTogetherMap(bl);
    }

    public Map<Integer, Integer> getActualTogetherMap(boolean bl) {
        return this.mTableItem.getActualTogetherMap(bl);
    }

    public Map<Integer, Point> getTogetherStartPointMap(boolean bl) {
        return this.mTableItem.getTogetherStartPointMap(bl);
    }

    public boolean isDisplayBreakpoint() {
        return this.mTableItem.isDisplayBreakpoint();
    }

    public void setDisplayBreakpoint(boolean bl) {
        this.mTableItem.setDisplayBreakpoint(bl);
    }

    public void clearBreakHereKeepTogether() {
        this.mTableItem.clearBreakHereKeepTogether();
    }

    public void clearVisibleBreakpoints() {
        this.mTableItem.clearVisibleBreakpoints();
    }

    public void clearActualBreakpoints() {
        this.mTableItem.clearActualBreakpoints();
    }

    public void addBreakpoint(int n, boolean bl) {
        LightPivotTable lightPivotTable = this.mEditorInfo.getLightPivotTable();
        TableLayer tableLayer = lightPivotTable.getCurrentLayer();
        long l = tableLayer.getRowHeadingHandle();
        long l2 = tableLayer.getColumnHeadingHandle();
        if (bl) {
            this.getVisibleBreakpointIndexSet(true).add(n);
            this.getActualBreakpointIndexSet(true).add(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().RowHeadingGetActualRowNumber(l, n));
        } else {
            this.getVisibleBreakpointIndexSet(false).add(n);
            this.getActualBreakpointIndexSet(false).add(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().ColumnHeadingGetActualColumnNumber(l2, n));
        }
    }

    public void removeBreakpoint(int n, boolean bl) {
        LightPivotTable lightPivotTable = this.mEditorInfo.getLightPivotTable();
        TableLayer tableLayer = lightPivotTable.getCurrentLayer();
        long l = tableLayer.getRowHeadingHandle();
        long l2 = tableLayer.getColumnHeadingHandle();
        if (bl) {
            this.getVisibleBreakpointIndexSet(true).remove(n);
            this.getActualBreakpointIndexSet(true).remove(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().RowHeadingGetActualRowNumber(l, n));
        } else {
            this.getVisibleBreakpointIndexSet(false).remove(n);
            this.getActualBreakpointIndexSet(false).remove(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().ColumnHeadingGetActualColumnNumber(l2, n));
        }
    }

    public void putKeepTogether(int n, int n2, boolean bl) {
        LightPivotTable lightPivotTable = this.mEditorInfo.getLightPivotTable();
        TableLayer tableLayer = lightPivotTable.getCurrentLayer();
        long l = tableLayer.getRowHeadingHandle();
        long l2 = tableLayer.getColumnHeadingHandle();
        if (bl) {
            this.getVisibleTogetherMap(true).put(n, n2);
            int n3 = this.mEditorInfo.getLightPivotTable().getDisplayHeadings().RowHeadingGetActualRowNumber(l, n);
            int n4 = this.mEditorInfo.getLightPivotTable().getDisplayHeadings().RowHeadingGetActualRowNumber(l, n + n2 - 1);
            n2 = n4 - n3 + 1;
            this.getActualTogetherMap(true).put(n3, n2 > 1 ? n2 : 1);
        } else {
            this.getVisibleTogetherMap(false).put(n, n2);
            int n5 = this.mEditorInfo.getLightPivotTable().getDisplayHeadings().ColumnHeadingGetActualColumnNumber(l2, n);
            int n6 = this.mEditorInfo.getLightPivotTable().getDisplayHeadings().ColumnHeadingGetActualColumnNumber(l2, n + n2 - 1);
            n2 = n6 - n5 + 1;
            this.getActualTogetherMap(false).put(n5, n2 > 1 ? n2 : 1);
        }
    }

    public void removeKeepTogether(int n, boolean bl) {
        LightPivotTable lightPivotTable = this.mEditorInfo.getLightPivotTable();
        TableLayer tableLayer = lightPivotTable.getCurrentLayer();
        long l = tableLayer.getRowHeadingHandle();
        long l2 = tableLayer.getColumnHeadingHandle();
        if (bl) {
            this.getVisibleTogetherMap(true).remove(n);
            this.getActualTogetherMap(true).remove(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().RowHeadingGetActualRowNumber(l, n));
        } else {
            this.getVisibleTogetherMap(false).remove(n);
            this.getActualTogetherMap(false).remove(this.mEditorInfo.getLightPivotTable().getDisplayHeadings().ColumnHeadingGetActualColumnNumber(l2, n));
        }
    }

    public void convertActual2Visible() {
        this.mTableItem.convertActual2Visible();
    }

    public void setSelectedCells(ArrayList<ArrayList<Rectangle2D>> arrayList) {
        this.mTableItem.setSelectedCells(arrayList);
    }

    public Map<String, String> getPivotCachedStatus() {
        return this.mTableItem.getPivotCachedStatus();
    }

    public String getTableTabDelimitedText() {
        return this.mTableItem.getTableTabDelimitedText();
    }

    public String getProcedureName() {
        return this.mTableItem.getProcedureName();
    }

    public LookAndFeel getLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    public LightPivotTable getLightPivotTable() {
        return this.getCoreItem().getLightPivotTable();
    }

    public boolean isExportAllLayers() {
        return this.getCoreItem().isExportAllLayers();
    }

    public ISpssExportable getExportableItem() {
        return this.getCoreItem();
    }

    public ExportCopyParams getExportCopyParams(JFrame jFrame) {
        if (jFrame instanceof ITopWindow) {
            return PageSetupUtil.collectExportCopyParams(((ITopWindow)((Object)jFrame)).getViewerPanel());
        }
        return null;
    }

    public void createTableToGraphboardTemplateChooser(JFrame jFrame, TableToGraphboardSource tableToGraphboardSource, byte[] byArray, LtEditorInfo ltEditorInfo) {
        new TableToGraphboardTemplateChooser(jFrame, tableToGraphboardSource, byArray, ltEditorInfo);
    }

    public void executeSyntaxForNextDataset(StringBuffer stringBuffer) {
        String string = DataDocument.getNextFreeDatasetName();
        stringBuffer.append("DATASET NAME ").append(string).append(".");
        SyntaxMgr.getSyntaxMgr().executeSyntax(stringBuffer.toString());
    }

    @Override
    protected JMenuBar composeMixedMenuBar(SpssFrame spssFrame, JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = new JMenuBar();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        ThinMenuBarBorder thinMenuBarBorder = new ThinMenuBarBorder(uIDefaults.getColor("MenuBar.shadow"));
        jMenuBar2.setBorder(thinMenuBarBorder);
        try {
            JMenuBar jMenuBar3 = this.cloneMenuBar(spssFrame.getMainMenuBar());
            JMenu jMenu = this.getTopLevelMenu(jMenuBar3, "Analyze");
            JMenu jMenu2 = this.getTopLevelMenu(jMenuBar3, "Graphs");
            JMenu jMenu3 = this.getTopLevelMenu(jMenuBar3, "Utilities");
            JMenu jMenu4 = this.getTopLevelMenu(jMenuBar3, "Add-ons");
            JMenu jMenu5 = this.getTopLevelMenu(jMenuBar3, "Window");
            JMenu jMenu6 = this.getTopLevelMenu(jMenuBar3, "Help");
            JMenuBar jMenuBar4 = new JMenuBar();
            String string = "doc_types/output/menus_edit";
            spssFrame.loadMenuBarPreferences(string, jMenuBar4, new MenuCache(null));
            JMenu jMenu7 = jMenuBar4.getMenu(0);
            jMenuBar2.add(jMenu7);
            jMenuBar2.add((JMenu)new EditMenu(this.mEditorInfo));
            jMenuBar2.add((JMenu)new ViewMenu(this.mEditorInfo));
            jMenuBar2.add((JMenu)new InsertMenu(this.mEditorInfo));
            jMenuBar2.add((JMenu)new PivotMenu(this.mEditorInfo));
            jMenuBar2.add((JMenu)new FormatMenu(this.mEditorInfo));
            if (jMenu != null) {
                jMenuBar2.add(jMenu);
            }
            if (jMenu2 != null) {
                jMenuBar2.add(jMenu2);
            }
            if (jMenu3 != null) {
                jMenuBar2.add(jMenu3);
            }
            if (jMenu4 != null) {
                jMenuBar2.add(jMenu4);
            }
            if (jMenu5 != null) {
                jMenuBar2.add(jMenu5);
            }
            if (jMenu6 != null) {
                jMenuBar2.add(jMenu6);
            }
            int n = jMenu7.getItemCount();
            for (int i = 0; i < n; ++i) {
                Action action;
                JMenuItem jMenuItem = jMenu7.getItem(i);
                if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof CloseAction)) continue;
                jMenuItem.setAction((Action)this.mEditorInfo.getActionManager().getAction("Close"));
                break;
            }
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        return jMenuBar2;
    }

    @Override
    protected void restoreMainMenu() {
        super.restoreMainMenu();
        Container container = this.getTopLevelAncestor();
        if (container instanceof ViewerFrame) {
            JMenu jMenu = this.mFrameEditingMenuBar.getMenu(0);
            int n = jMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                Action action;
                JMenuItem jMenuItem = jMenu.getItem(i);
                if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof com.spss.pivottable.gui.actions.menu_actions.CloseAction)) continue;
                jMenuItem.setAction(ActionCatalog.getActionCatalog().getSpssAction("file_close"));
                break;
            }
        }
    }

    private void setActiveSearchLayer(LightPivotTable lightPivotTable, int n) {
        if (this.isInEditMode()) {
            LtEditorRenderer ltEditorRenderer = this.mEditorFrame.getEditorInfo().getRenderer();
            ltEditorRenderer.setActiveLayerIndex(n);
        } else {
            lightPivotTable.setCurrentLayerIndex(n);
        }
    }

    private boolean searchTableLayer(LightPivotTable lightPivotTable, ViewerSearchOptions viewerSearchOptions, Pattern pattern) {
        FootnoteHandler footnoteHandler = lightPivotTable.getFootnoteHandler();
        Point point = viewerSearchOptions.getLightTableCell();
        Dimension dimension = lightPivotTable.getTableCellDimensions();
        if (viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.down) {
            ArrayList arrayList;
            int n;
            int n2 = point.y > -1 ? point.y : 0;
            int n3 = n = point.x > -1 ? point.x + 1 : 0;
            if (this.mEditorInfo != null && this.mEditorInfo.getSelectionMgr() != null && viewerSearchOptions.getFindType() != ViewerSearchOptions.FindType.replaceall && (arrayList = this.mEditorInfo.getSelectionMgr().getSelectedExCells()) != null && arrayList.size() > 0) {
                ExCellData exCellData = (ExCellData)arrayList.get(0);
                n2 = exCellData.getRow();
                n = exCellData.getColumn();
                this.mEditorInfo.getSelectionMgr().clearSelection();
            }
            for (int i = n2; i < dimension.height; ++i) {
                for (int j = n; j < dimension.width; ++j) {
                    int n4 = viewerSearchOptions.getOffset();
                    CellData cellData = lightPivotTable.getCell(i, j);
                    String string = this.getCellValue(cellData);
                    if (string != null && string.length() >= n4) {
                        Matcher matcher;
                        if (viewerSearchOptions.getFootnoteMarkerOnly()) {
                            int[] nArray = cellData.getFootnotesIndexArray();
                            if (nArray != null) {
                                for (int n5 : nArray) {
                                    String string2;
                                    Footnote footnote = footnoteHandler.getFootnote(n5);
                                    if (footnote == null || (string2 = footnote.getMarker()) == null || !(matcher = pattern.matcher(string2)).find(n4) || matcher.end() - matcher.start() != string2.length()) continue;
                                    point.x = j;
                                    point.y = i;
                                    viewerSearchOptions.setLightTableCell(point);
                                    viewerSearchOptions.setOffset(matcher.start());
                                    return true;
                                }
                            }
                        } else {
                            matcher = pattern.matcher(string);
                            if (matcher.find(n4)) {
                                if (viewerSearchOptions.getMatchCells() && matcher.end() - matcher.start() != string.length()) continue;
                                point.x = j;
                                point.y = i;
                                viewerSearchOptions.setLightTableCell(point);
                                viewerSearchOptions.setOffset(matcher.start());
                                return true;
                            }
                        }
                    }
                    viewerSearchOptions.setOffset(0);
                }
                n = 0;
            }
        } else {
            int n = point.y > -1 ? point.y : dimension.height - 1;
            int n6 = viewerSearchOptions.getOffset() == 0 ? point.x - 1 : point.x;
            for (int i = n; i >= 0; --i) {
                for (int j = n6; j >= 0; --j) {
                    int n7 = viewerSearchOptions.getOffset();
                    CellData cellData = lightPivotTable.getCell(i, j);
                    String string = this.getCellValue(cellData);
                    if (string != null && string.length() >= n7) {
                        Matcher matcher;
                        if (n7 <= 0) {
                            n7 = string.length();
                            viewerSearchOptions.setOffset(n7);
                        }
                        if (this.reverseFind(matcher = pattern.matcher(string), viewerSearchOptions)) {
                            point.x = j;
                            point.y = i;
                            viewerSearchOptions.setLightTableCell(point);
                            return true;
                        }
                    }
                    viewerSearchOptions.setOffset(0);
                }
                n6 = dimension.width - 1;
            }
        }
        return false;
    }

    private String getCellValue(CellData cellData) {
        if (cellData == null) {
            return null;
        }
        boolean bl = this.isInEditMode() && this.isInPlaceEdit() && this.mEditorInfo.getTextEditor() != null;
        String string = bl ? this.mEditorInfo.getTextEditor().getText() : cellData.getCellText();
        return string;
    }

    private boolean reverseFind(Matcher matcher, ViewerSearchOptions viewerSearchOptions) {
        boolean bl = false;
        int n = 0;
        int n2 = viewerSearchOptions.getOffset();
        if (n2 > -1) {
            while (matcher.find(n)) {
                int n3 = matcher.start();
                n = matcher.end();
                if (n3 >= n2) continue;
                bl = true;
                viewerSearchOptions.setOffset(n3);
            }
        }
        return bl;
    }

    private boolean isLockedDocument() {
        if (!VersionInfo.isSmartReader() || !(this.getTopLevelAncestor() instanceof ITopWindow)) {
            return false;
        }
        ITopWindow iTopWindow = (ITopWindow)((Object)this.getTopLevelAncestor());
        IOutputDocument iOutputDocument = iTopWindow.getViewerDocument().getCoreDocument();
        return iOutputDocument.isLocked();
    }

    private void positionItemControl() {
        Dimension dimension = this.getCoreItem().getLightPivotTable().getTableSize();
        int n = this.getCoreItem().getLightPivotTable().getTableMeasurer().getLayerLabelWidth();
        int n2 = Math.max(dimension.width, n);
        int n3 = dimension.height;
        this.mCoreItem.setWidth(n2 + 3);
        this.mCoreItem.setHeight(n3 + 3);
        if (this.mEditorInfo != null && this.mEditorInfo.getCanvas() != null) {
            LtCanvas ltCanvas = this.mEditorInfo.getCanvas();
            dimension = this.mEditorInfo.getCanvas().getCanvasSize();
            ltCanvas.setSize(dimension);
            ltCanvas.setPreferredSize(dimension);
            this.mEditorInfo.getEditorFrame().getGlassPane().setSize(new Dimension(dimension.width, dimension.height + 100));
            this.mEditorInfo.getEditorFrame().getGlassPane().setPreferredSize(new Dimension(dimension.width, dimension.height + 100));
        }
    }

    private void deactivateOpen() {
        if (this.mEditorFrame != null) {
            this.mEditorInfo.setRenderer(null);
            this.mEditorFrame.removeTableEditorListener((LtTableEditorListener)this);
            this.mEditorFrame.closeEditor();
            this.mEditorFrame = null;
            this.mEditorInfo = null;
        }
    }

    private void deactivateEdit() {
        LtCanvas ltCanvas;
        if (this.mEditorInfo.getTextEditor() != null) {
            this.mEditorInfo.getTextEditor().commitEdit();
        }
        if ((ltCanvas = this.mEditorInfo.getCanvas()) != null) {
            this.remove(this.mEditorInfo.getEditorFrame().getGlassPane());
            this.remove((Component)ltCanvas);
        }
        WhatIsThisAction.hideTooltip();
        this.updateViewerFrameMenus(false);
        this.updateViewerFrameToolBars(false);
        if (this.mEditorFrame != null) {
            this.mEditorFrame.savePreferences();
            this.mEditorFrame.removeTableEditorListener((LtTableEditorListener)this);
            this.mEditorFrame.closeEditor();
            this.mEditorFrame = null;
            this.mEditorInfo = null;
        }
        this.revalidate();
    }

    private void deactivateLockedEdit() {
        LtCanvas ltCanvas = this.mEditorInfo.getCanvas();
        if (ltCanvas != null) {
            this.remove(this.mEditorInfo.getEditorFrame().getGlassPane());
            this.remove((Component)ltCanvas);
        }
        if (this.mEditorFrame != null) {
            this.mEditorInfo.setRenderer(null);
            this.mEditorFrame.savePreferences();
            this.mEditorFrame.removeTableEditorListener((LtTableEditorListener)this);
            this.mEditorFrame.closeEditor();
            this.mEditorFrame = null;
            this.mEditorInfo = null;
        }
        this.revalidate();
    }

    private String applyChartTemplates(String string) throws OutOfMemoryError {
        String string2;
        try {
            File file;
            String string3;
            Object object;
            String string4;
            String string5;
            File file2;
            String string6;
            ApplyTemplate applyTemplate = new ApplyTemplate();
            String string7 = FileLocationsUtil.getChartTemplateDirectoryPath() + File.separator + "chart_style.sgt";
            File file3 = new File(string7);
            if (!file3.exists()) {
                TraceSettings.trace1((String)("CANNOT OPEN Template File: " + string7), (int)15);
            }
            if ((string6 = this.getTemplateFromFile(string7)) == null || string6.length() == 0) {
                TraceSettings.trace1((String)("CANNOT READ Template File: " + string7), (int)15);
            }
            if ((string2 = applyTemplate.apply(string, string6)) == null || string2.length() == 0) {
                TraceSettings.trace1((String)("CANNOT APPLY Template File: " + string7), (int)15);
            }
            if ((file2 = new File(string5 = (string4 = PrefsMgr.getPrefsMgr().getTempPath()) + "otmpl.tmp")).exists()) {
                string6 = this.getTemplateFromFile(string5);
                string2 = applyTemplate.apply(string2, string6);
            }
            boolean bl = true;
            String string8 = this.getPrefsValue("charts", "use_custom_template", PrefDefaults.CHART_USE_CUSTOM_TEMPLATE);
            if (string8.equals(IOptionConstants.CHART_USE_CUSTOM_TEMPLATE_VALUES[0]) && ((File)(object = new File(string3 = this.getPrefsValue("charts", "custom_template_path", "None")))).exists()) {
                string6 = this.getTemplateFromFile(string3);
                string2 = applyTemplate.apply(string2, string6);
                bl = false;
            }
            if (bl && (file = new File((String)(object = string4 + "dtmpl.tmp"))).exists()) {
                string6 = this.getTemplateFromFile((String)object);
                string2 = applyTemplate.apply(string2, string6);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
            string2 = string;
        }
        catch (Throwable throwable) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    private String getTemplateFromFile(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "";
            while (string3 != null) {
                stringBuffer.append(string3);
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
            string2 = stringBuffer.toString();
        }
        catch (Exception exception) {
            PvtLogger.printStackTrace((Exception)exception);
        }
        return string2;
    }

    private String getPrefsValue(String string, String string2, String string3) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("options");
        Preferences preferences3 = preferences2.node(string);
        return preferences3.get(string2, string3);
    }

    private boolean classifyTableType() {
        boolean bl = true;
        Dimension dimension = this.getPreferredSize();
        if (dimension.width > LightTableViewerItem.MEDIUM_TABLE_SIZE.width || dimension.height > LightTableViewerItem.MEDIUM_TABLE_SIZE.height) {
            bl = false;
        }
        return bl;
    }

    private void doReplace(ViewerSearchOptions viewerSearchOptions, int n) {
        Point point = viewerSearchOptions.getLightTableCell();
        this.mEditorInfo = this.getEditorInfo();
        if (this.mEditorInfo.getCanvas() == null) {
            new LtCanvas(this.mEditorInfo);
        }
        Rectangle rectangle = this.mEditorInfo.getLightPivotTable().getCellSpanRangeRect(point.y, point.x, point.y, point.x);
        this.mEditorInfo.getSelectionMgr().getSelProcessor().process(this.mEditorInfo, new Point((int)rectangle.getX() + 3, (int)rectangle.getY() + 3), false);
        InPlaceEditor inPlaceEditor = new InPlaceEditor(this.mEditorInfo);
        Component component = inPlaceEditor.getComponent();
        if (component instanceof JTextPane) {
            String string = ((JTextPane)component).getText();
            int n2 = viewerSearchOptions.getOffset();
            int n3 = n2 + n;
            CellData cellData = this.mEditorInfo.getLightPivotTable().getCell(point.y, point.x);
            if (cellData != null && cellData.isNumeric()) {
                n2 = 0;
                n3 = string.length();
            }
            if (n3 > string.length()) {
                n3 = string.length();
            }
            ((JTextPane)component).select(n2, n3);
            String string2 = viewerSearchOptions.getReplaceString();
            if (string2 != null && string2.length() > 0) {
                ((JTextPane)component).replaceSelection(string2);
                if (cellData != null && cellData.isNumeric()) {
                    viewerSearchOptions.setOffset(n3);
                } else {
                    viewerSearchOptions.setOffset(n2 + string2.length());
                }
            }
        }
        inPlaceEditor.commitEdit(true);
    }

    private LtEditorInfo getEditorInfo() {
        if (this.mEditorInfo == null) {
            String string = ComponentState.getILangLocale().getLanguage();
            String string2 = ComponentState.getILangLocale().getCountry();
            if (string2 != "") {
                string = string + "_" + string2;
            }
            this.mEditorInfo = new LtEditorInfo(string);
            this.mEditorInfo.setExportFactory((IExporterFactory)new ExporterFactory());
            this.mEditorInfo.setViewerItemListener((ITableViewerItemListener)this);
            this.mEditorInfo.setLightPivotTable(this.getCoreItem().getLightPivotTable());
            this.mEditorInfo.setTableName(this.getName());
        }
        return this.mEditorInfo;
    }

    public boolean findExpression(String string, ViewerSearchOptions viewerSearchOptions) {
        if (this.mEditorInfo != null && this.mEditorInfo.getTextEditor() != null) {
            this.mEditorInfo.getTextEditor().commitEdit(!viewerSearchOptions.isReplaceAll());
        }
        LightPivotTable lightPivotTable = this.getCoreItem().getLightPivotTable();
        boolean bl = false;
        int n = lightPivotTable.getLayerCount();
        if (n > 1) {
            int n2 = lightPivotTable.getCurrentLayerIndex();
            if (viewerSearchOptions.isFirstSearch() || viewerSearchOptions.getOriginalLightTableLayer() == -1) {
                viewerSearchOptions.setOriginalLightTableLayer(n2);
            }
            if (viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.down) {
                int n3;
                for (n3 = n2; n3 < n && (viewerSearchOptions.isFirstSearch() || n3 != viewerSearchOptions.getOriginalLightTableLayer() || n3 == n2); ++n3) {
                    this.setActiveSearchLayer(lightPivotTable, n3);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, string);
                    if (bl) break;
                    viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                }
                for (n3 = 0; n3 < n2 && !bl && (viewerSearchOptions.isFirstSearch() || n3 != viewerSearchOptions.getOriginalLightTableLayer()); ++n3) {
                    this.setActiveSearchLayer(lightPivotTable, n3);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, string);
                    if (!bl) {
                        viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                        continue;
                    }
                    break;
                }
            } else {
                int n4;
                for (n4 = n2; n4 >= 0 && (viewerSearchOptions.isFirstSearch() || n4 != viewerSearchOptions.getOriginalLightTableLayer() || n4 == n2); --n4) {
                    this.setActiveSearchLayer(lightPivotTable, n4);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, string);
                    if (bl) break;
                    viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                }
                for (n4 = n - 1; n4 > n2 && !bl && (viewerSearchOptions.isFirstSearch() || n4 != viewerSearchOptions.getOriginalLightTableLayer()); --n4) {
                    this.setActiveSearchLayer(lightPivotTable, n4);
                    bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, string);
                    if (!bl) {
                        viewerSearchOptions.setLightTableCell(new Point(-1, -1));
                        continue;
                    }
                    break;
                }
            }
            if (!bl) {
                this.setActiveSearchLayer(lightPivotTable, viewerSearchOptions.getOriginalLightTableLayer());
            }
        } else {
            bl = this.searchTableLayer(lightPivotTable, viewerSearchOptions, string);
            viewerSearchOptions.setCurrentLayer(null);
        }
        viewerSearchOptions.setPreviousFind(bl);
        return bl;
    }

    private boolean searchTableLayer(LightPivotTable lightPivotTable, ViewerSearchOptions viewerSearchOptions, String string) {
        SearchOperator searchOperator;
        Double[] doubleArray = new Double[2];
        String[] stringArray = new String[2];
        if (string.indexOf("<>") > -1) {
            searchOperator = SearchOperator.between;
            stringArray = string.split("<>");
            Arrays.sort(stringArray, StringComparator.ASCENDING);
            try {
                doubleArray[0] = Double.valueOf(stringArray[0].replace(this.mSymbol.getDecimalSeparator(), '.'));
                doubleArray[1] = Double.valueOf(stringArray[1].replace(this.mSymbol.getDecimalSeparator(), '.'));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            int n = string.indexOf(">=");
            if (n > -1) {
                searchOperator = SearchOperator.greatThanOrEqual;
                stringArray[0] = string.substring(n + 2);
                try {
                    doubleArray[0] = Double.valueOf(stringArray[0].replace(this.mSymbol.getDecimalSeparator(), '.'));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                n = string.indexOf("<=");
                if (n > -1) {
                    searchOperator = SearchOperator.lessThanOrEqual;
                    stringArray[0] = string.substring(n + 2);
                    try {
                        doubleArray[0] = Double.valueOf(stringArray[0].replace(this.mSymbol.getDecimalSeparator(), '.'));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    return false;
                }
            }
        }
        Collator collator = Collator.getInstance();
        Point point = viewerSearchOptions.getLightTableCell();
        Dimension dimension = lightPivotTable.getTableCellDimensions();
        if (viewerSearchOptions.getSearchDirection() == SearchOptions.SearchDirection.down) {
            int n = point.y > -1 ? point.y : 0;
            int n2 = point.x > -1 ? point.x + 1 : 0;
            for (int i = n; i < dimension.height; ++i) {
                for (int j = n2; j < dimension.width; ++j) {
                    CellData cellData = lightPivotTable.getCell(i, j);
                    String string2 = this.getCellValue(cellData);
                    if (string2 != null && string2.length() > 0 && this.checkValue(searchOperator, cellData, stringArray, doubleArray, string2, collator)) {
                        point.x = j;
                        point.y = i;
                        viewerSearchOptions.setLightTableCell(point);
                        return true;
                    }
                    viewerSearchOptions.setOffset(0);
                }
                n2 = 0;
            }
        } else {
            int n = point.y > -1 ? point.y : dimension.height - 1;
            int n3 = viewerSearchOptions.getOffset() == 0 ? point.x - 1 : point.x;
            for (int i = n; i >= 0; --i) {
                for (int j = n3; j >= 0; --j) {
                    CellData cellData = lightPivotTable.getCell(i, j);
                    String string3 = this.getCellValue(cellData);
                    if (string3 != null && string3.length() > 0 && this.checkValue(searchOperator, cellData, stringArray, doubleArray, string3, collator)) {
                        point.x = j;
                        point.y = i;
                        viewerSearchOptions.setLightTableCell(point);
                        return true;
                    }
                    viewerSearchOptions.setOffset(0);
                }
                n3 = dimension.width - 1;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkValue(SearchOperator searchOperator, CellData cellData, String[] stringArray, Double[] doubleArray, String string, Collator collator) {
        if (searchOperator == SearchOperator.between) {
            if (doubleArray[0] != null && doubleArray[1] != null) {
                if (cellData.isNumeric()) {
                    if (!(cellData.getNumber() >= doubleArray[0])) return false;
                    if (!(cellData.getNumber() <= doubleArray[1])) return false;
                    return true;
                }
                try {
                    Double d = Double.valueOf(string);
                    if (d.compareTo(doubleArray[0]) < 0) return false;
                    if (d.compareTo(doubleArray[1]) > 0) return false;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (collator.compare(cellData.getCellText(), stringArray[0]) < 0) return false;
            if (collator.compare(cellData.getCellText(), stringArray[1]) > 0) return false;
            return true;
        }
        if (searchOperator == SearchOperator.greatThanOrEqual) {
            if (doubleArray[0] != null) {
                if (cellData.isNumeric()) {
                    if (!(cellData.getNumber() >= doubleArray[0])) return false;
                    return true;
                }
                try {
                    Double d = Double.valueOf(string);
                    if (d.compareTo(doubleArray[0]) < 0) return false;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (collator.compare(cellData.getCellText(), stringArray[0]) < 0) return false;
            return true;
        }
        if (searchOperator != SearchOperator.lessThanOrEqual) return false;
        if (doubleArray[0] != null) {
            if (cellData.isNumeric()) {
                if (!(cellData.getNumber() <= doubleArray[0])) return false;
                return true;
            }
            try {
                Double d = Double.valueOf(string);
                if (d.compareTo(doubleArray[0]) > 0) return false;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if (collator.compare(cellData.getCellText(), stringArray[0]) > 0) return false;
        return true;
    }

    private void setSummaryTooltip() {
        LightPivotTable lightPivotTable = this.getCoreItem().getLightPivotTable();
        String string = lightPivotTable.getTableSummary();
        if (string != null && string.length() > 0) {
            String[] stringArray;
            StringBuffer stringBuffer = new StringBuffer("<html>");
            for (String string2 : stringArray = string.split("\\n")) {
                String[] stringArray2;
                for (String string3 : stringArray2 = string2.split("\\\\n")) {
                    stringBuffer.append(this.wrapText(string3)).append("<br>");
                }
            }
            stringBuffer.append("</html>");
            this.setToolTipText(stringBuffer.toString());
        }
    }

    private String wrapText(String string) {
        int n;
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = string.length();
        int n3 = n = breakIterator.first();
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 - n < SINGLE_LINE_LENGTH && n < n2) {
            int n4 = breakIterator.next();
            if (n4 == n2) {
                if (n4 - n < MAX_LINE_LENGTH) {
                    stringBuffer.append(string.substring(n, n4));
                    break;
                }
                if (n3 != n && n3 - n < SINGLE_LINE_LENGTH) {
                    stringBuffer.append(string.substring(n, n3)).append("<br>");
                    LightTableViewerItem.finishUnbrokenEnd(string, n2, stringBuffer, n3);
                    break;
                }
                LightTableViewerItem.finishUnbrokenEnd(string, n2, stringBuffer, n);
                break;
            }
            if (n4 - n < SINGLE_LINE_LENGTH) {
                n3 = n4;
                continue;
            }
            if (n == n3) {
                if (n4 - n < MAX_LINE_LENGTH) {
                    stringBuffer.append(string.substring(n, n4)).append("<br>");
                    n3 = n = n4;
                    continue;
                }
                int n5 = (n4 - n) / SINGLE_LINE_LENGTH;
                for (int i = 0; i <= n5; ++i) {
                    if (i == n5) {
                        n3 = n4;
                        stringBuffer.append(string.substring(n, n3));
                    } else {
                        n3 = n + (SINGLE_LINE_LENGTH - 1);
                        stringBuffer.append(string.substring(n, n3));
                        stringBuffer.append("-");
                    }
                    stringBuffer.append("<br>");
                    n = n3;
                }
                continue;
            }
            stringBuffer.append(string.substring(n, n3)).append("<br>");
            n3 = n = n3;
        }
        return stringBuffer.toString();
    }

    private static void finishUnbrokenEnd(String string, int n, StringBuffer stringBuffer, int n2) {
        while (n2 + SINGLE_LINE_LENGTH < n) {
            stringBuffer.append(string.substring(n2, n2 + SINGLE_LINE_LENGTH)).append("<br>");
            n2 += SINGLE_LINE_LENGTH;
        }
        stringBuffer.append(string.substring(n2, n));
    }

    public static enum SearchOperator {
        between,
        greatThanOrEqual,
        lessThanOrEqual;

    }
}

