/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.statistics.lighttable.LightPivotTable;
import com.ibm.vis.raveeditor.IEditorListener;
import com.spss.charteditor.MyEditor;
import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.ASLExecutor;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.IChartItemUIAgent;
import com.spss.java_client.core.documents.output.interactive.ClusterFeatureImportanceInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.ClusterOutliersInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.DecisionRulesTableInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.InteractiveTableProvider;
import com.spss.java_client.core.documents.output.interactive.JsonInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.PredictorImportanceInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.RulesMapInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.RulesWordCloudInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.STPClustersMapInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.STPCorrelationsHeatMapInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.STPCorrelationsMapInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMImpactDiagramInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMModelQualityInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMModelSystemInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMOutlierDistributionInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMOutlierRootCauseAnalysisInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMScenarioAnalysisInteractiveItem;
import com.spss.java_client.core.documents.output.interactive.TCMSequenceDiagramPopupInteractiveItem;
import com.spss.java_client.core.documents.output.lighttable.JsonTableItem;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.interactive.ClusterFeatureImportanceInteractiveFrame;
import com.spss.java_client.ui.interactive.ClusterOutliersInteractiveFrame;
import com.spss.java_client.ui.interactive.DecisionRulesTableInteractiveFrame;
import com.spss.java_client.ui.interactive.InteractiveTableEditor;
import com.spss.java_client.ui.interactive.JsonInteractiveFrame;
import com.spss.java_client.ui.interactive.PredictorImportanceInteractiveFrame;
import com.spss.java_client.ui.interactive.RulesMapInteractiveFrame;
import com.spss.java_client.ui.interactive.RulesWordCloudInteractiveFrame;
import com.spss.java_client.ui.interactive.STPClustersMapInteractiveFrame;
import com.spss.java_client.ui.interactive.STPCorrelationsHeatMapInteractiveFrame;
import com.spss.java_client.ui.interactive.STPCorrelationsMapInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMImpactDiagramInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMModelQualityInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMModelSystemInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMOutlierDistributionInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMOutlierRootCauseAnalysisInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMScenarioAnalysisInteractiveFrame;
import com.spss.java_client.ui.interactive.TCMSequenceDiagramPopupInteractiveFrame;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JsonInteractiveViewerItem
extends ViewerItem
implements IChartItemUIAgent,
IEditorListener {
    private static final int TOOLBAR_HEIGHT = 32;
    private Dimension mPrefSize = null;
    private JsonInteractiveItem mOutputItem;
    private ViewerImage mImage = new ViewerImage();
    private JsonInteractiveFrame mJsonInteractiveFrame;

    public JsonInteractiveViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        this.setName(iOutputItem.getDescription());
        if (iOutputItem instanceof JsonInteractiveItem) {
            this.mOutputItem = (JsonInteractiveItem)iOutputItem;
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.model;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        Object object;
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            object = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = ((ImageGenerator2.ImageContainer)object).get();
            this.mImage = new ViewerImage(this, bufferedImage, ((ImageGenerator2.ImageContainer)object).isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 4, bufferedImage.getHeight() + 4));
        }
        object = graphics2D.getTransform();
        graphics2D.translate(2, 2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setTransform((AffineTransform)object);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPrefSize == null) {
            BufferedImage bufferedImage = this.mImage.get();
            this.mPrefSize = bufferedImage == null ? ImageGenerator2.getImageGenerator().getDefaultImageSize() : new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        }
        return this.mPrefSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.mPrefSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHeight(int n) {
    }

    public void setWidth(int n) {
    }

    public MyEditor getChartEditorFromUI() {
        return null;
    }

    public boolean isInEditingMode() {
        return false;
    }

    public void applyTemplate(String string) {
    }

    @Override
    public boolean startEdit() {
        if (this.isInEditMode()) {
            return false;
        }
        if (!this.getCoreItem().isEditable()) {
            String string = ResUtil.getString((String)"IDS_NOT_EDITABLE_MSG");
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.getTopLevelAncestor(), string, VersionInfo.getAppVersionString());
            return false;
        }
        boolean bl = super.startEdit();
        try {
            final JsonInteractiveFrame jsonInteractiveFrame = this.getJsonInteractiveFrame();
            if (jsonInteractiveFrame == null) {
                return false;
            }
            jsonInteractiveFrame.setASLExecutor((ASLExecutor)this.getTopLevelAncestor());
            boolean bl2 = jsonInteractiveFrame instanceof PredictorImportanceInteractiveFrame && ((PredictorImportanceInteractiveFrame)jsonInteractiveFrame).showSlider();
            int n = !bl2 ? this.mOutputItem.getHeight() + 32 : this.mOutputItem.getHeight() + 32 + 40;
            jsonInteractiveFrame.getContentPane().setPreferredSize(new Dimension(this.mOutputItem.getWidth(), n));
            jsonInteractiveFrame.pack();
            jsonInteractiveFrame.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jsonInteractiveFrame.toFront();
                }
            });
            jsonInteractiveFrame.doPostDisplayProccessing();
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public void endEdit() {
        Container container;
        if (!this.isInEditMode()) {
            return;
        }
        if (this.mJsonInteractiveFrame != null) {
            container = this.getJsonInteractiveFrame();
            this.mOutputItem.setWidth(((JFrame)container).getContentPane().getWidth());
            this.mOutputItem.setHeight(((JFrame)container).getContentPane().getHeight() - 32);
            this.updateTreeNode();
            if (this.mJsonInteractiveFrame instanceof InteractiveTableEditor) {
                LightPivotTable lightPivotTable = ((InteractiveTableEditor)((Object)this.mJsonInteractiveFrame)).getActiveLightTable();
                if (this.getCoreItem() instanceof InteractiveTableProvider) {
                    JsonTableItem jsonTableItem = ((InteractiveTableProvider)this.getCoreItem()).getTableItem();
                    jsonTableItem.setLightTable(lightPivotTable);
                    if (this.mJsonInteractiveFrame instanceof DecisionRulesTableInteractiveFrame) {
                        jsonTableItem.setHighlightedRow(((DecisionRulesTableInteractiveFrame)this.mJsonInteractiveFrame).getHighlightedRow());
                    }
                }
            }
            ((Window)container).setVisible(false);
            ((JsonInteractiveFrame)container).dispose();
            this.mJsonInteractiveFrame = null;
        }
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        VizCache.getCache().clearItem(this.mOutputItem.getId());
        container = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)container).handleSelectionChange(this, false);
        ((JComponent)container).scrollRectToVisible(this.getBounds());
        ((ViewerOutputPane)container).setDocumentModifiedFlag(true);
        this.repaint();
        super.endEdit();
    }

    @Override
    public void closeEditorWindow() {
        this.endEdit();
    }

    public void close() {
        this.endEdit();
    }

    @Override
    public void applySizeChange(int n, int n2) {
        this.resizeItem(n, n2);
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            this.mCoreItem.setWidth(bufferedImage.getWidth() + 4);
            this.mCoreItem.setHeight(bufferedImage.getHeight() + 4);
            Dimension dimension = new Dimension(this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void resize(Point point) {
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getDragRect(point2);
        if (rectangle != null) {
            this.resizeItem(rectangle.width, rectangle.height);
        }
    }

    public void resizeItem(int n, int n2) {
        if (!this.isInEditMode()) {
            this.mOutputItem.setWidth(n);
            this.mOutputItem.setHeight(n2);
        }
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        this.repaint();
    }

    private JsonInteractiveFrame getJsonInteractiveFrame() {
        if (this.mJsonInteractiveFrame == null) {
            if (this.getItem() instanceof RulesMapInteractiveItem) {
                this.mJsonInteractiveFrame = new RulesMapInteractiveFrame(this);
            } else if (this.getItem() instanceof RulesWordCloudInteractiveItem) {
                this.mJsonInteractiveFrame = new RulesWordCloudInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMModelSystemInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMModelSystemInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMModelQualityInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMModelQualityInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMOutlierDistributionInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMOutlierDistributionInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMOutlierRootCauseAnalysisInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMOutlierRootCauseAnalysisInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMImpactDiagramInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMImpactDiagramInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMScenarioAnalysisInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMScenarioAnalysisInteractiveFrame(this);
            } else if (this.getItem() instanceof TCMSequenceDiagramPopupInteractiveItem) {
                this.mJsonInteractiveFrame = new TCMSequenceDiagramPopupInteractiveFrame(this);
            } else if (this.getItem() instanceof ClusterOutliersInteractiveItem) {
                this.mJsonInteractiveFrame = new ClusterOutliersInteractiveFrame(this);
            } else if (this.getItem() instanceof ClusterFeatureImportanceInteractiveItem) {
                this.mJsonInteractiveFrame = new ClusterFeatureImportanceInteractiveFrame(this);
            } else if (this.getItem() instanceof STPClustersMapInteractiveItem) {
                this.mJsonInteractiveFrame = new STPClustersMapInteractiveFrame(this);
            } else if (this.getItem() instanceof STPCorrelationsHeatMapInteractiveItem) {
                this.mJsonInteractiveFrame = new STPCorrelationsHeatMapInteractiveFrame(this);
            } else if (this.getItem() instanceof STPCorrelationsMapInteractiveItem) {
                this.mJsonInteractiveFrame = new STPCorrelationsMapInteractiveFrame(this);
            } else if (this.getItem() instanceof DecisionRulesTableInteractiveItem) {
                this.mJsonInteractiveFrame = new DecisionRulesTableInteractiveFrame(this);
            } else if (this.getItem() instanceof PredictorImportanceInteractiveItem) {
                this.mJsonInteractiveFrame = new PredictorImportanceInteractiveFrame(this);
            }
        }
        return this.mJsonInteractiveFrame;
    }

    public JsonInteractiveItem getItem() {
        return this.mOutputItem;
    }

    private void updateTreeNode() {
        this.refreshContent();
    }
}

