/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.raveeditor.IEditorListener;
import com.ibm.vis.raveeditor.RaveEditor;
import com.ibm.vis.raveeditor.gui.RaveEditorFrame;
import com.spss.charteditor.MyEditor;
import com.spss.charteditor.util.ResUtil;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.IChartItemUIAgent;
import com.spss.java_client.core.documents.output.chart.JsonChartItem;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JsonChartViewerItem
extends ViewerItem
implements IChartItemUIAgent,
IEditorListener {
    private Dimension mPrefSize = null;
    private JsonChartItem mOutputItem;
    private ViewerImage mImage = new ViewerImage();
    private RaveEditor editor;

    public JsonChartViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        this.setName(iOutputItem.getDescription());
        if (iOutputItem instanceof JsonChartItem) {
            this.mOutputItem = (JsonChartItem)iOutputItem;
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.jsonChart;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        Object object;
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            object = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = ((ImageGenerator2.ImageContainer)object).get();
            this.mImage = new ViewerImage(this, bufferedImage, ((ImageGenerator2.ImageContainer)object).isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 4, bufferedImage.getHeight() + 4));
        }
        object = graphics2D.getTransform();
        graphics2D.translate(2, 2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setTransform((AffineTransform)object);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPrefSize == null) {
            BufferedImage bufferedImage = this.mImage.get();
            this.mPrefSize = bufferedImage == null ? ImageGenerator2.getImageGenerator().getDefaultImageSize() : new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        }
        return this.mPrefSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.mPrefSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHeight(int n) {
    }

    public void setWidth(int n) {
    }

    public MyEditor getChartEditorFromUI() {
        return null;
    }

    public boolean isInEditingMode() {
        return false;
    }

    public void applyTemplate(String string) {
    }

    @Override
    public boolean startEdit() {
        if (this.isInEditMode()) {
            return false;
        }
        if (!this.getCoreItem().isEditable()) {
            String string = ResUtil.getString((String)"IDS_NOT_EDITABLE_MSG");
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.getTopLevelAncestor(), string, VersionInfo.getAppVersionString());
            return false;
        }
        boolean bl = super.startEdit();
        try {
            RaveEditor raveEditor = this.getRaveEditor();
            RaveEditorFrame raveEditorFrame = raveEditor.getRaveEditorInfo().getEditorFrame();
            raveEditorFrame.setSize(this.mOutputItem.getWidth() + 60, this.mOutputItem.getHeight() + 100);
            raveEditor.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JsonChartViewerItem.this.editor.getRaveEditorInfo().getEditorFrame().toFront();
                }
            });
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public void endEdit() {
        Object object;
        if (!this.isInEditMode()) {
            return;
        }
        try {
            object = this.editor.getRaveEditorInfo().getChartJson().serialize(true);
            byte[] byArray = ((String)object).getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
            this.mOutputItem.setVDPData(ByteBuffer.wrap(byArray));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.getRaveEditor().setVisible(false);
        this.getRaveEditor().getRaveEditorInfo().getEditorFrame().dispose();
        this.editor = null;
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        VizCache.getCache().clearItem(this.mOutputItem.getId());
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).handleSelectionChange(this, false);
        ((JComponent)object).scrollRectToVisible(this.getBounds());
        ((ViewerOutputPane)object).setDocumentModifiedFlag(true);
        this.repaint();
        super.endEdit();
    }

    public void close() {
        this.endEdit();
    }

    @Override
    public void applySizeChange(int n, int n2) {
        this.doResize(n, n2);
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            this.mCoreItem.setWidth(bufferedImage.getWidth() + 4);
            this.mCoreItem.setHeight(bufferedImage.getHeight() + 4);
            Dimension dimension = new Dimension(this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void resize(Point point) {
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getDragRect(point2);
        if (rectangle != null) {
            this.doResize(rectangle.width, rectangle.height);
        }
    }

    private void doResize(int n, int n2) {
        this.mOutputItem.setWidth(n);
        this.mOutputItem.setHeight(n2);
        JSONObject jSONObject = this.getRaveEditor().getRaveEditorInfo().getChartJson();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"size");
        jSONObject2.put((Object)"height", (Object)n2);
        jSONObject2.put((Object)"width", (Object)n);
        try {
            String string = this.editor.getRaveEditorInfo().getChartJson().serialize(true);
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write(byArray);
            ((OutputStream)deflaterOutputStream).close();
            byArray = byteArrayOutputStream.toByteArray();
            this.mOutputItem.setVDPData(ByteBuffer.wrap(byArray));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        this.repaint();
    }

    private RaveEditor getRaveEditor() {
        if (this.editor == null) {
            this.editor = new RaveEditor(this.mOutputItem.getUncompressedData());
            this.editor.addEditorListener((IEditorListener)this);
        }
        return this.editor;
    }
}

