/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.ui.doc_types.output.RenderTask;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.TraceSettings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javax.swing.SwingUtilities;

public class ImageGenerator2 {
    private static final int MAX_STACK_SIZE = 5;
    private final Dimension DEFAULT_IMAGE_SIZE = new Dimension(300, 120);
    private BufferedImage mWaitImage = null;
    private BufferedImage mInvalidImage = null;
    private RenderThread mThread = null;
    private ViewerItem mCurrentItem = null;
    private BufferedImage mOutofMemoryImage = null;

    public static ImageGenerator2 getImageGenerator() {
        return ImageGeneratorHolder.IMAGE_GENERATOR;
    }

    public BufferedImage getWaitImage() {
        return this.mWaitImage;
    }

    public BufferedImage getOutofMemoryImage() {
        if (this.mOutofMemoryImage == null) {
            this.mOutofMemoryImage = this.generateInfoImage(ResUtil.getString("IDS_OUTOFMEMORY_ERROR_MSG"), 500, 120);
        }
        return this.mOutofMemoryImage;
    }

    public BufferedImage getInvalidImage() {
        if (this.mInvalidImage == null) {
            this.mInvalidImage = this.generateInfoImage(ResUtil.getString("IDS_IMAGE_RENDERING_ERROR_MSG"), 500, 120);
        }
        return this.mInvalidImage;
    }

    public void resetWaitImage() {
        this.mWaitImage = this.generateInfoImage(ResUtil.getString("IDS_IMAGE_RENDERING_MSG"));
    }

    public final Dimension getDefaultImageSize() {
        return this.DEFAULT_IMAGE_SIZE;
    }

    public synchronized ImageContainer generateImage(ViewerItem viewerItem) {
        boolean bl = viewerItem.getCoreItem().isComplete();
        if (bl && !this.isItemRendering(viewerItem)) {
            RenderTask renderTask = new RenderTask(viewerItem, null, RenderTask.TaskPriority.medium);
            RenderThread renderThread = this.getRenderThread();
            renderThread.enqueue(renderTask);
        }
        return new ImageContainer(this.mWaitImage, bl);
    }

    public void addRenderTask(RenderTask renderTask) {
        boolean bl = renderTask.getItem().getCoreItem().isComplete();
        if (bl && !this.isItemRendering(renderTask)) {
            RenderThread renderThread = this.getRenderThread();
            renderThread.enqueue(renderTask);
        }
    }

    public boolean isItemRendering(ViewerItem viewerItem) {
        return this.mCurrentItem == viewerItem;
    }

    public synchronized void clearItem(ViewerItem viewerItem) {
        if (this.mThread != null && this.mThread.isAlive()) {
            this.mThread.removeItem(viewerItem);
        }
    }

    public synchronized void clearAllItems() {
        if (this.mThread != null && this.mThread.isAlive()) {
            this.mThread.removeAll();
            this.interruptThread();
        }
    }

    public synchronized void stopThread() {
        if (this.mThread != null) {
            TraceSettings.trace1((String)"Stopping ImageGenerator thread...", (int)15);
            this.clearAllItems();
            this.mThread.setStopped(true);
            this.mThread = null;
        }
    }

    public synchronized boolean isStopped() {
        return this.mThread != null && this.mThread.isStopped();
    }

    private ImageGenerator2() {
        this.resetWaitImage();
    }

    private boolean isItemRendering(RenderTask renderTask) {
        return this.mThread != null && this.mThread.hasTask(renderTask);
    }

    private RenderThread getRenderThread() {
        if (this.mThread == null) {
            this.mThread = new RenderThread();
            this.mThread.start();
        }
        return this.mThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptThread() {
        RenderThread renderThread = this.mThread;
        synchronized (renderThread) {
            int n;
            this.mThread.notify();
            this.mThread.interrupt();
            for (n = 0; n < 20 && !this.mThread.isInterrupted(); ++n) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mThread.interrupt();
            }
            TraceSettings.trace1((String)("Rendering item cleared after " + n + " attempts"), (int)15);
        }
    }

    private BufferedImage generateInfoImage(String string) {
        return this.generateInfoImage(string, 300, 120);
    }

    protected BufferedImage generateInfoImage(String string, int n, int n2) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        BufferedImage bufferedImage = graphicsDevice.getDefaultConfiguration().createCompatibleImage(n, n2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        if (string != null && string.length() > 0) {
            this.renderImageText(graphics, string, n, n2);
        }
        graphics.dispose();
        return bufferedImage;
    }

    private void renderImageText(Graphics graphics, String string, int n, int n2) {
        int n3 = 0;
        String string2 = ResUtil.getString("IDS_IMAGE_RENDERING_MSG_STYLE");
        if (string2 != null && string2.indexOf("italic") > -1) {
            n3 |= 2;
        }
        if (string2 != null && string2.indexOf("bold") > -1) {
            n3 |= 1;
        }
        Font font = graphics.getFont().deriveFont(n3);
        graphics.setFont(font);
        graphics.setColor(Color.gray);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String[] stringArray = string.split("\n");
        int n4 = stringArray.length > 1 ? 10 : -1;
        int n5 = 0;
        for (String string3 : stringArray) {
            int n6 = SwingUtilities.computeStringWidth(fontMetrics, string3);
            int n7 = n4 > -1 ? n4 : (n - n6) / 2;
            graphics.drawString(string3, n7, n2 / 2 - 20 + n5);
            n5 += fontMetrics.getHeight() + fontMetrics.getLeading();
        }
    }

    class RenderThread
    extends Thread {
        private final Object mStackLock;
        private Stack<RenderTask> mStack;
        private boolean mFirstPass;
        private boolean mStopped;

        public RenderThread() {
            super("RenderThread");
            this.mStackLock = new Object();
            this.mStack = new Stack();
            this.mFirstPass = true;
            this.mStopped = false;
        }

        @Override
        public synchronized void start() {
            super.start();
            TraceSettings.trace1((String)"Starting the primary rendering thread", (int)15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    Runnable runnable = this;
                    synchronized (runnable) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.mFirstPass = false;
                    while (!this.mStack.isEmpty() && !this.isStopped()) {
                        runnable = this.dequeue();
                        ImageGenerator2.this.mCurrentItem = ((RenderTask)runnable).getItem();
                        try {
                            ((RenderTask)runnable).run();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ImageGenerator2.this.mCurrentItem = null;
                    }
                } while (!this.isStopped());
            }
            catch (Exception exception) {
                TraceSettings.trace1((String)"!!!Exception in the primary rendering thread!!!", (int)15);
                exception.printStackTrace();
            }
            TraceSettings.trace1((String)"Stopped the primary rendering thread", (int)15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(RenderTask renderTask) {
            Object object = this.mStackLock;
            synchronized (object) {
                boolean bl = false;
                RenderTask renderTask2 = null;
                if (!this.mStack.isEmpty()) {
                    renderTask2 = this.mStack.peek();
                    bl = renderTask2.getPriority().ordinal() > renderTask.getPriority().ordinal();
                }
                this.mStack.remove(renderTask);
                this.mStack.push(renderTask);
                if (bl) {
                    this.mStack.remove(renderTask2);
                    this.mStack.push(renderTask2);
                }
                if (this.mStack.size() > 5) {
                    this.trimStack();
                }
            }
            object = this;
            synchronized (object) {
                if (this.mFirstPass) {
                    this.interrupt();
                } else {
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RenderTask dequeue() {
            RenderTask renderTask;
            Object object = this.mStackLock;
            synchronized (object) {
                renderTask = this.mStack.pop();
            }
            return renderTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeItem(ViewerItem viewerItem) {
            Object object = this.mStackLock;
            synchronized (object) {
                for (RenderTask renderTask : this.mStack) {
                    if (renderTask.getItem() != viewerItem) continue;
                    this.mStack.remove(renderTask);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeAll() {
            Object object = this.mStackLock;
            synchronized (object) {
                this.mStack.clear();
            }
        }

        boolean isStopped() {
            return this.mStopped;
        }

        void setStopped(boolean bl) {
            this.mStopped = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasTask(RenderTask renderTask) {
            Object object = this.mStackLock;
            synchronized (object) {
                return this.mStack.indexOf(renderTask) > -1;
            }
        }

        private void trimStack() {
            int n = this.mStack.size();
            if (n <= 5) {
                return;
            }
            int n2 = n - 5;
            for (int i = 0; i < n2; ++i) {
                RenderTask renderTask = (RenderTask)this.mStack.remove(0);
                renderTask.getItem().renderingComplete(null);
            }
        }
    }

    class ImageContainer {
        private BufferedImage mImage;
        private boolean mComplete;

        ImageContainer(BufferedImage bufferedImage, boolean bl) {
            this.mImage = bufferedImage;
            this.mComplete = bl;
        }

        BufferedImage get() {
            return this.mImage;
        }

        boolean isComplete() {
            return this.mComplete;
        }
    }

    private static class ImageGeneratorHolder {
        static final ImageGenerator2 IMAGE_GENERATOR = new ImageGenerator2();

        private ImageGeneratorHolder() {
        }
    }
}

