/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import java.util.LinkedList;

class ImageCache {
    private LinkedList<ViewerImage> mList = new LinkedList();
    private int mMemSize = 0;
    private static final int MAX_MEM_SIZE = 524288;
    private static final int MINIMUM_IMAGE_OVERFLOW = 10;

    public static ImageCache getImageCache() {
        return ImageCacheHolder.IMAGE_CACHE;
    }

    public void clean() {
        this.mList.clear();
        this.mMemSize = 0;
    }

    public ViewerImage add(ViewerImage viewerImage) {
        if (viewerImage != null) {
            this.mMemSize += viewerImage.size();
            while (this.mMemSize > 524288 && this.mList.size() > 10) {
                ViewerImage viewerImage2 = this.mList.removeFirst();
                viewerImage2.uncache();
                this.mMemSize -= viewerImage2.size();
            }
            viewerImage.cache();
            this.mList.addLast(viewerImage);
        }
        return viewerImage;
    }

    public boolean remove(ViewerImage viewerImage) {
        viewerImage.uncache();
        boolean bl = this.mList.remove(viewerImage);
        if (bl) {
            this.mMemSize -= viewerImage.size();
        }
        return bl;
    }

    public boolean remove(ViewerItem viewerItem) {
        ViewerImage viewerImage = null;
        int n = viewerItem.getId();
        for (ViewerImage viewerImage2 : this.mList) {
            if (n != viewerImage2.getViewerItem().getId()) continue;
            viewerImage = viewerImage2;
            break;
        }
        return viewerImage != null && this.remove(viewerImage);
    }

    private ImageCache() {
    }

    private static class ImageCacheHolder {
        static final ImageCache IMAGE_CACHE = new ImageCache();

        private ImageCacheHolder() {
        }
    }
}

