/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.chart.GraphServiceItem;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class GraphServiceViewerItem
extends ViewerItem {
    private GraphServiceItem mOutputItem;
    private BufferedImage mImage;

    public GraphServiceViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        this.setName(iOutputItem.getDescription());
        if (iOutputItem instanceof GraphServiceItem) {
            this.mOutputItem = (GraphServiceItem)iOutputItem;
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.image;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        this.getImage();
        graphics2D.drawImage((Image)this.mImage, 1, 1, null);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mImage == null) {
            return new Dimension(200, 200);
        }
        return new Dimension(this.mImage.getWidth() + 2, this.mImage.getHeight() + 2);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void print(Graphics2D graphics2D, int n, int n2) {
        if (this.mImage != null) {
            graphics2D.drawImage(this.mImage, 0, 0, n, n2, null);
        }
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean canEdit() {
        return false;
    }

    @Override
    protected void resize(Point point) {
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null && (this.mOutputItem.getWidth() != rectangle.width || this.mOutputItem.getHeight() != rectangle.height)) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.mImage, 0, 0, rectangle.width, rectangle.height, null);
            graphics2D.dispose();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferedImage, this.mOutputItem.getImageType(), byteArrayOutputStream);
                ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
                this.mOutputItem.setImageData(byteBuffer);
                byteArrayOutputStream.close();
                this.mOutputItem.setWidth(rectangle.width);
                this.mOutputItem.setHeight(rectangle.height);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.mImage = null;
            this.revalidate();
        }
    }

    private BufferedImage getImage() {
        if (this.mImage == null) {
            try {
                ByteBuffer byteBuffer = this.mOutputItem.getImageData();
                if (byteBuffer == null) {
                    return null;
                }
                byte[] byArray = byteBuffer.array();
                InputStream inputStream = this.getProperInputStream(byArray);
                this.mImage = ImageIO.read(inputStream);
                inputStream.close();
                this.setPreferredSize(new Dimension(this.mImage.getWidth(), this.mImage.getHeight()));
                this.mCoreItem.setWidth(this.mImage.getWidth() + 2);
                this.mCoreItem.setHeight(this.mImage.getHeight() + 2);
                this.revalidate();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.mImage;
    }
}

