/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.charteditor.ChartImager;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.chart.IGraphBoardItemUIAgent;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.doc_types.output.graphboard.GraphBoardFrame;
import com.spss.java_client.ui.interactive.GraphboardFactory;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.vis.Visualization;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.styleSheet.StyleSheet;
import com.spss.vis.graphboard.styleSheet.StyleSheetLoaderException;
import com.spss.vis.graphboard.styleSheet.StylesheetLoader;
import com.spss.vis.graphboard.util.BuildGraphboardDirectories;
import com.spss.vis.graphboard.vismodel.NviznModel;
import com.spss.vis.specification.ExtensionSpecification;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.SpecificationChangeEvent;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.guide.LineGuideSpecification;
import com.spss.vis.specification.interaction.InteractionSpecification;
import com.spss.vis.specification.interaction.SwingControllerSpecification;
import com.spss.vis.specification.layout.LocationPartType;
import com.spss.vis.specification.layout.LocationSpecification;
import com.spss.vizimager.VizDataProcessor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.zip.DeflaterOutputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GraphBoardViewerItem
extends ViewerItem
implements IGraphBoardItemUIAgent {
    private ChartItem mOutputItem = null;
    private ViewerImage mImage = new ViewerImage();
    private Dimension mPrefSize = null;
    private GraphBoardFrame mFrame = null;

    public GraphBoardViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        if (!(iOutputItem instanceof ChartItem)) {
            throw new IllegalArgumentException();
        }
        this.mOutputItem = (ChartItem)iOutputItem;
        this.setName(this.mOutputItem.getDescription());
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.graphboard;
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            ImageGenerator2.ImageContainer imageContainer = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = imageContainer.get();
            this.mImage = new ViewerImage(this, bufferedImage, imageContainer.isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2));
        }
        graphics2D.drawImage((Image)bufferedImage, 1, 1, null);
        if (this.isInEditMode()) {
            this.renderEditModeHatchPattern(graphics2D, this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPrefSize == null) {
            BufferedImage bufferedImage = this.mImage.get();
            this.mPrefSize = bufferedImage == null ? ImageGenerator2.getImageGenerator().getDefaultImageSize() : new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        }
        return this.mPrefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHeight(int n) {
        this.mOutputItem.setHeight(n);
        this.repaint();
    }

    public void setWidth(int n) {
        this.mOutputItem.setWidth(n);
        this.repaint();
    }

    @Override
    public void refreshContent() {
        super.refreshContent();
        byte[] byArray = this.mFrame.extractCompressedXML(this.mOutputItem.isVDPInternal());
        this.mOutputItem.setCompressedXML(ByteBuffer.wrap(byArray));
    }

    @Override
    protected void refreshSize() {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.mPrefSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    @Override
    public boolean startEdit() {
        if (this.isInEditMode()) {
            if (this.mFrame != null) {
                this.mFrame.toFront();
            }
            return false;
        }
        if (!this.getCoreItem().isEditable()) {
            String string = ResUtil.getString("IDS_NOT_EDITABLE_MSG");
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.getTopLevelAncestor(), string, VersionInfo.getAppVersionString());
            return false;
        }
        boolean bl = super.startEdit();
        try {
            GraphboardFactory.reset();
            Graphboard graphboard = GraphboardFactory.createGraphboard();
            this.mFrame = new GraphBoardFrame(this, graphboard, ResUtil.getString("IDS_GRAPHBOARD_EDITOR_TITLE"));
            Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
            VizDataProcessor vizDataProcessor = VizCache.getCache().getDataReader(this.mOutputItem);
            VisualizationSpecification visualizationSpecification = visualization.getSpecification();
            if (this.mOutputItem.getCachedAnimationSpec() != null) {
                visualizationSpecification.addInteraction((InteractionSpecification)this.mOutputItem.getCachedAnimationSpec());
                this.mOutputItem.setCachedAnimationSpec(null);
            }
            this.modifiedForInteractiveChart(visualizationSpecification);
            graphboard.setEditEnabled(((SwingControllerSpecification[])visualizationSpecification.findDescendantsOfType(SwingControllerSpecification.class)).length == 0);
            ChartImager chartImager = new ChartImager();
            graphboard.getModel().setBase(chartImager.getVizString(visualization, vizDataProcessor, this.mPrefSize.width, this.mPrefSize.height), Boolean.valueOf(true));
            graphboard.getModel().setRawMode(false);
            graphboard.getModel().clearUndo();
            this.mFrame.getContentPane().add((Component)graphboard);
            this.mFrame.pack();
            this.mFrame.loadPreferences();
            this.mFrame.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GraphBoardViewerItem.this.mFrame.toFront();
                }
            });
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    @Override
    public void endEdit() {
        Object object;
        if (!this.isInEditMode()) {
            return;
        }
        boolean bl = false;
        if (this.mFrame.needsRerendering()) {
            object = this.mFrame.extractCompressedXML(this.mOutputItem.isVDPInternal());
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap((byte[])object));
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            VizCache.getCache().clearItem(this.mOutputItem.getId());
            bl = true;
        }
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).handleSelectionChange(this, false);
        ((JComponent)object).scrollRectToVisible(this.getBounds());
        if (bl) {
            ((ViewerOutputPane)object).setDocumentModifiedFlag(true);
        }
        this.mFrame.setVisible(false);
        this.mFrame.reset();
        this.mFrame.dispose();
        this.mFrame = null;
        this.repaint();
        super.endEdit();
    }

    @Override
    public void closeEditorWindow() {
        this.mFrame.close();
    }

    public void applyStylesheet(String string) {
        Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
        VizDataProcessor vizDataProcessor = VizCache.getCache().getDataReader(this.mOutputItem);
        StyleSheet styleSheet = this.getStyleSheet(string);
        try {
            NviznModel nviznModel = new NviznModel();
            ChartImager chartImager = new ChartImager();
            nviznModel.setBase(chartImager.getVizString(visualization, vizDataProcessor, this.mOutputItem.getWidth(), this.mOutputItem.getHeight()), Boolean.valueOf(true));
            nviznModel.clearWorkingStyleSheet(true);
            nviznModel.setBaseStyleSheet(styleSheet.getStyle(), false);
            VisualizationSpecification visualizationSpecification = nviznModel.getVisualizationSpecification();
            byte[] byArray = GraphBoardFrame.extractCompressedXML(visualizationSpecification);
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap(byArray));
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            VizCache.getCache().clearItem(this.mOutputItem.getId());
            this.repaint();
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
            viewerOutputPane.setDocumentModifiedFlag(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            ((ChartItem)this.mCoreItem).setChartSize(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
            Dimension dimension = new Dimension(this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.revalidate();
        }
    }

    @Override
    public void applySizeChange(int n, int n2) {
        Object object;
        this.mOutputItem.setWidth(n);
        this.mOutputItem.setHeight(n2);
        Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
        visualization.setOutputSize(n, n2);
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        LocationSpecification[] locationSpecificationArray = visualizationSpecification.getLocations();
        for (LocationSpecification object2 : locationSpecificationArray) {
            if (object2.getPart() == LocationPartType.WIDTH) {
                object2.setMax(null);
                object2.setFixedValue(new Length(n + "px"));
                continue;
            }
            if (object2.getPart() != LocationPartType.HEIGHT) continue;
            object2.setMax(null);
            object2.setFixedValue(new Length(n2 + "px"));
        }
        visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)visualizationSpecification, "redraw chart"));
        StringWriter stringWriter = new StringWriter();
        try {
            visualizationSpecification.writeXml((Writer)stringWriter);
            object = stringWriter.toString().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write((byte[])object);
            ((OutputStream)deflaterOutputStream).close();
            object = byteArrayOutputStream.toByteArray();
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap((byte[])object));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        this.invalidate();
        this.repaint();
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).setDocumentModifiedFlag(true);
    }

    @Override
    protected void resize(Point point) {
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getDragRect(point2);
        if (rectangle != null) {
            this.mOutputItem.setWidth(rectangle.width);
            this.mOutputItem.setHeight(rectangle.height);
            Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
            visualization.setOutputSize(rectangle.width, rectangle.height);
            VisualizationSpecification visualizationSpecification = visualization.getSpecification();
            LocationSpecification[] locationSpecificationArray = visualizationSpecification.getLocations();
            for (LocationSpecification locationSpecification : locationSpecificationArray) {
                if (locationSpecification.getPart() == LocationPartType.WIDTH) {
                    locationSpecification.setMax(null);
                    locationSpecification.setFixedValue(new Length(rectangle.width + "px"));
                    continue;
                }
                if (locationSpecification.getPart() != LocationPartType.HEIGHT) continue;
                locationSpecification.setMax(null);
                locationSpecification.setFixedValue(new Length(rectangle.height + "px"));
            }
            visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)visualizationSpecification, "redraw chart"));
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            this.repaint();
            ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
            viewerDocument.setFocusedViewerItem(this);
            viewerDocument.getCoreDocument().setModifiedFlag(true);
            viewerDocument.notifyChangedModifiedFlag();
            ((ViewerOutputPane)this.getParent()).handleSelectionChange(this, false);
        }
    }

    private void modifiedForInteractiveChart(VisualizationSpecification visualizationSpecification) {
        if (((SwingControllerSpecification[])visualizationSpecification.findDescendantsOfType(SwingControllerSpecification.class)).length > 0) {
            ExtensionSpecification[] extensionSpecificationArray;
            Object object;
            Specification specification = visualizationSpecification.getSpecification("tableGraph");
            if (specification instanceof GraphSpecification && (object = (extensionSpecificationArray = (ExtensionSpecification[])specification).getStyle()) != null) {
                object.setVisible(Boolean.valueOf(false));
            }
            if ((extensionSpecificationArray = visualizationSpecification.getExtensionSpecifications()).length > 0) {
                object = extensionSpecificationArray[0].get("lowerSlider");
                String string = extensionSpecificationArray[0].get("upperSlider");
                if (object != null && string != null) {
                    LineGuideSpecification[] lineGuideSpecificationArray;
                    for (LineGuideSpecification lineGuideSpecification : lineGuideSpecificationArray = (LineGuideSpecification[])visualizationSpecification.findDescendantsOfType(LineGuideSpecification.class)) {
                        if (((String)object).equals(lineGuideSpecification.getName())) {
                            lineGuideSpecification.getStyle().setVisible(Boolean.valueOf(false));
                        }
                        if (!string.equals(lineGuideSpecification.getName())) continue;
                        lineGuideSpecification.getStyle().setVisible(Boolean.valueOf(false));
                    }
                }
            }
        }
    }

    private StyleSheet getStyleSheet(String string) {
        StyleSheet styleSheet = null;
        try {
            File file = BuildGraphboardDirectories.getUserDir();
            StylesheetLoader stylesheetLoader = new StylesheetLoader(new File(file, "stylesheets"));
            Collection collection = stylesheetLoader.getAllStyleSheets();
            for (StyleSheet styleSheet2 : collection) {
                if (string == null || !string.equals(styleSheet2.getInternationalizedName())) continue;
                styleSheet = styleSheet2;
                break;
            }
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            styleSheetLoaderException.printStackTrace();
        }
        return styleSheet;
    }
}

