/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.output.GenericItem;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class GenericViewerItem
extends ViewerItem {
    protected static final Dimension DEFAULT_SIZE = new Dimension(200, 200);
    private GenericItem mOutputItem;
    private ViewerImage mImage = new ViewerImage();

    public GenericViewerItem() {
        this(null);
    }

    public GenericViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        Object object;
        if (iOutputItem.getDescription().length() > 0) {
            this.setName(iOutputItem.getDescription());
        } else {
            object = ResUtil.getString("IDS_PASTED_OBJECT");
            this.setName((String)object);
            iOutputItem.setDescription((String)object);
        }
        this.mOutputItem = (GenericItem)iOutputItem;
        object = this.mOutputItem.render();
        if (object != null) {
            this.mImage = new ViewerImage(this, (BufferedImage)object, true, true);
            ImageCache.getImageCache().add(this.mImage);
            this.setSize(((BufferedImage)object).getWidth(null), ((BufferedImage)object).getHeight(null));
            this.mOutputItem.setWidth(((BufferedImage)object).getWidth(null));
            this.mOutputItem.setHeight(((BufferedImage)object).getHeight(null));
        }
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.generic;
    }

    @Override
    public boolean canEdit() {
        return false;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public boolean startEdit() {
        super.endEdit();
        return true;
    }

    @Override
    public void endEdit() {
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        graphics2D.translate(1, 1);
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            Container container = this.getTopLevelAncestor();
            container.setCursor(Cursor.getPredefinedCursor(3));
            bufferedImage = this.mOutputItem.render();
            this.mImage = new ViewerImage(this, bufferedImage, true, true);
            ImageCache.getImageCache().add(this.mImage);
            container.setCursor(Cursor.getPredefinedCursor(0));
        }
        graphics2D.drawImage(bufferedImage, 0, 0, this.getWidth() - 2, this.getHeight() - 2, new Color(255, 255, 255, 0), null);
        graphics2D.translate(-1, -1);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.mOutputItem.getWidth();
        int n2 = this.mOutputItem.getHeight();
        return new Dimension(n, n2);
    }

    @Override
    public void applySizeChange(int n, int n2) {
        this.mOutputItem.setWidth(n);
        this.mOutputItem.setHeight(n2);
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        this.invalidate();
        this.repaint();
        ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
        viewerOutputPane.setDocumentModifiedFlag(true);
    }

    @Override
    protected void resize(Point point) {
        Rectangle rectangle = this.getDragRect(point);
        if (rectangle != null) {
            this.mOutputItem.setWidth((int)rectangle.getWidth());
            this.mOutputItem.setHeight((int)rectangle.getHeight());
            this.repaint();
        }
        super.resize(point);
    }

    @Override
    protected boolean canResize(int n) {
        return true;
    }
}

