/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssMultiLineLabel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.resources.ClientResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ConvertToFatTableDlg
extends BaseDialog {
    private static final String DONT_SHOW_DIALOG = "dont_show_convert_table_warning";
    private boolean okPressed = false;
    private JCheckBox checkBox;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 1989, 2013.\n\n";
    }

    public static boolean runConvertQuery(JFrame jFrame) {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("dialog_settings");
        int n = preferences2.getInt(DONT_SHOW_DIALOG, 0);
        if (n != 0) {
            return true;
        }
        ConvertToFatTableDlg convertToFatTableDlg = new ConvertToFatTableDlg(jFrame);
        convertToFatTableDlg.setVisible(true);
        return convertToFatTableDlg.isOkPressed();
    }

    public ConvertToFatTableDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, true, ResUtil.getBundle(ClientResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), ClientResBundle.getImageFolder());
        this.initialize();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void doHelp() {
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 24;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jButton = new JButton(new OKAction());
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void initialize() {
        this.setTitle(ResUtil.getString("IDS_CONVERT_TO_FAT_TITLE"));
        JPanel jPanel = this.getViewPanel();
        SpssMultiLineLabel spssMultiLineLabel = new SpssMultiLineLabel(ResUtil.getString("IDS_CONVERT_TO_FAT_MSG"), 0, 400);
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        JLabel jLabel = new JLabel(new ImageIcon(uRL));
        this.checkBox = new JCheckBox(ResUtil.getString("IDS_DONT_SHOW_FAT_WARNING_AGAIN"));
        this.checkBox.setMnemonic(ResUtil.getAccessKey("IDK_DONT_SHOW_FAT_WARNING_AGAIN"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = DialogUtil.getStandardDialogInsets();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)spssMultiLineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = DialogUtil.getStandardControlInsets();
        jPanel.add((Component)this.checkBox, gridBagConstraints);
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ConvertToFatTableDlg.this.checkBox.isSelected()) {
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("dialog_settings");
                preferences2.putInt(ConvertToFatTableDlg.DONT_SHOW_DIALOG, 1);
            }
            ConvertToFatTableDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ConvertToFatTableDlg.this.checkBox.isSelected()) {
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                Preferences preferences2 = preferences.node("dialog_settings");
                preferences2.putInt(ConvertToFatTableDlg.DONT_SHOW_DIALOG, 1);
            }
            ConvertToFatTableDlg.this.okPressed = true;
            ConvertToFatTableDlg.this.dispose();
        }
    }
}

