/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.officeopenxml.excel2007.MGOWriterHelper;
import com.spss.vis.ItemInfo;
import com.spss.vis.ResultsProcessor;
import com.spss.vis.Row;
import com.spss.vis.Visualization;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.processors.picking.InformationProcessor;
import com.spss.vis.specification.AbstractSpecification;
import com.spss.vis.specification.AbstractVisualSpecification;
import com.spss.vis.specification.Attribute;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.LabelFrameSpecification;
import com.spss.vis.specification.Specification;
import com.spss.vis.specification.SpecificationChangeEvent;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.aesthetic.AestheticSpecification;
import com.spss.vis.specification.aesthetic.ColorAestheticSpecification;
import com.spss.vis.specification.aesthetic.DashAestheticSpecification;
import com.spss.vis.specification.aesthetic.LabelingSpecification;
import com.spss.vis.specification.aesthetic.PatternAestheticSpecification;
import com.spss.vis.specification.aesthetic.ShapeAestheticSpecification;
import com.spss.vis.specification.aesthetic.SizeAestheticSpecification;
import com.spss.vis.specification.aesthetic.StyleAestheticSpecification;
import com.spss.vis.specification.axis.AxisSpecification;
import com.spss.vis.specification.axis.MinorTicksSpecification;
import com.spss.vis.specification.coordinate.CoordinateTransformSpecification;
import com.spss.vis.specification.coordinate.CoordinatesSpecification;
import com.spss.vis.specification.coordinate.PolarTransformSpecification;
import com.spss.vis.specification.data.ExpressionVariableSpecification;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.data.VariableSpecification;
import com.spss.vis.specification.dimension.DimensionSpecification;
import com.spss.vis.specification.element.AreaSpecification;
import com.spss.vis.specification.element.ElementSpecification;
import com.spss.vis.specification.element.IntervalSpecification;
import com.spss.vis.specification.element.LineSpecification;
import com.spss.vis.specification.element.PointSpecification;
import com.spss.vis.specification.element.PositionModifierType;
import com.spss.vis.specification.element.SchemaSpecification;
import com.spss.vis.specification.format.FormatSpecification;
import com.spss.vis.specification.format.RelabelSpecification;
import com.spss.vis.specification.label.LabelSpecification;
import com.spss.vis.specification.label.TextSpecification;
import com.spss.vis.specification.legend.LegendSpecification;
import com.spss.vis.specification.legend.LegendTargetSpecification;
import com.spss.vis.specification.statistic.BinStatisticSpecification;
import com.spss.vis.specification.statistic.RegionStatisticSpecification;
import com.spss.vis.specification.statistic.SmoothMethodType;
import com.spss.vis.specification.statistic.SmoothStatisticSpecification;
import com.spss.vis.specification.statistic.StatisticSpecification;
import com.spss.vis.specification.statistic.SummaryBaseType;
import com.spss.vis.specification.statistic.SummaryStatisticSpecification;
import com.spss.vis.specification.statistic.SummaryType;
import com.spss.vis.specification.style.StyleSpecification;
import com.spss.vizimager.VizDataProcessor;
import com.spss.vizimager.VizDataSource;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ChartViewerItemHelper {
    private static final int EXPRESSION_NONE = 0;
    private static final int EXPRESSION_OVERLAY = 1;
    private static final int EXPRESSION_SPLOM = 2;
    private static DateFormat isoFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static DateFormat isoDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static DateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat isoTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");

    public static ChartType getGraphicChartType(ViewerItem viewerItem) {
        ChartType chartType = null;
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        if (visualizationSpecification != null) {
            chartType = ChartViewerItemHelper.getGraphicChartType(visualizationSpecification);
        }
        return chartType;
    }

    protected static VisualizationSpecification getVisSpecFromViewerItem(ViewerItem viewerItem) {
        VisualizationSpecification visualizationSpecification = null;
        if (viewerItem instanceof ChartViewerItem) {
            ChartViewerItem chartViewerItem = (ChartViewerItem)viewerItem;
            ChartItem chartItem = (ChartItem)chartViewerItem.getCoreItem();
            Visualization visualization = VizCache.getCache().getVisualization(chartItem);
            visualizationSpecification = visualization.getSpecification();
        }
        return visualizationSpecification;
    }

    private static ByteBuffer getVizByteBufferFromViewerItem(ViewerItem viewerItem) {
        ByteBuffer byteBuffer = null;
        if (viewerItem instanceof ChartViewerItem) {
            ChartViewerItem chartViewerItem = (ChartViewerItem)viewerItem;
            ChartItem chartItem = (ChartItem)chartViewerItem.getCoreItem();
            byteBuffer = chartItem.getVDPData();
        }
        return byteBuffer;
    }

    private static ChartItem getChartItemFromViewerItem(ViewerItem viewerItem) {
        ChartItem chartItem = null;
        if (viewerItem instanceof ChartViewerItem) {
            ChartViewerItem chartViewerItem = (ChartViewerItem)viewerItem;
            chartItem = (ChartItem)chartViewerItem.getCoreItem();
        }
        return chartItem;
    }

    public static RoleInfo getAxisValues(ViewerItem viewerItem, ChartType chartType, String string) {
        return ChartViewerItemHelper.getAxisValues(viewerItem, chartType, string, true);
    }

    public static RoleInfo getAxisValues(ViewerItem viewerItem, ChartType chartType, String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = null;
        ArrayList<String> arrayList2 = null;
        String string2 = null;
        try {
            VizDataProcessor vizDataProcessor;
            int n;
            ByteBuffer byteBuffer = ChartViewerItemHelper.getVizByteBufferFromViewerItem(viewerItem);
            ChartItem chartItem = ChartViewerItemHelper.getChartItemFromViewerItem(viewerItem);
            Visualization visualization = VizCache.getCache().getVisualization(chartItem);
            VisualizationSpecification visualizationSpecification = visualization.getSpecification();
            if (byteBuffer != null && chartItem != null && visualizationSpecification != null && (n = (vizDataProcessor = new VizDataProcessor()).readDataSources(byteBuffer)) > 0) {
                Collection collection = vizDataProcessor.getSources();
                for (VizDataSource vizDataSource : collection) {
                    vizDataSource.setVisualization(visualization);
                    vizDataSource.setupDateVariables(visualizationSpecification);
                    ChartViewerItemHelper.sytemOutRoleNames(vizDataSource.getVariables());
                    string2 = ChartViewerItemHelper.getSourceNameForRole(visualizationSpecification, string);
                    if (string2 == null) continue;
                    Iterator iterator = vizDataSource.iterator(null);
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        arrayList.add(row.getString(string2));
                    }
                    if (bl) {
                        hashMap = ChartViewerItemHelper.createIDToLabelMap(viewerItem, string2, arrayList);
                    }
                    arrayList2 = ChartViewerItemHelper.getCategoryList(viewerItem, string);
                    ChartViewerItemHelper.updateIDtoLabelMap(viewerItem, string2, hashMap, arrayList2);
                }
            }
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return new RoleInfo(string2, arrayList, arrayList2, hashMap);
    }

    private static void updateIDtoLabelMap(ViewerItem viewerItem, String string, HashMap<String, String> hashMap, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = ChartViewerItemHelper.getLabelsForValuesGivenRoleName(viewerItem, arrayList, string);
        if (arrayList2 != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = arrayList.get(i);
                String string3 = (String)arrayList2.get(i);
                if (string2 == null || string3 == null || ChartViewerItemHelper.areEqual(string2, string3) || hashMap.get(string2) != null) continue;
                hashMap.put(string2, string3);
            }
        }
    }

    private static HashMap<String, String> createIDToLabelMap(ViewerItem viewerItem, String string, ArrayList<String> arrayList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList2 = ChartViewerItemHelper.getLabelsForValuesGivenRoleName(viewerItem, arrayList, string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            String string3 = null;
            if (arrayList2 != null) {
                string3 = (String)arrayList2.get(i);
            }
            if (string2 == null || string3 == null || ChartViewerItemHelper.areEqual(string2, string3)) continue;
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public static ArrayList<String> getLabelsForValuesGivenRole(ViewerItem viewerItem, ArrayList<String> arrayList, String string) {
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        String string2 = ChartViewerItemHelper.getSourceNameForRole(visualizationSpecification, string);
        return ChartViewerItemHelper.getLabelsForValuesGivenRoleName(viewerItem, arrayList, string2);
    }

    public static ArrayList<String> getLabelsForValuesGivenRoleName(ViewerItem viewerItem, ArrayList<String> arrayList, String string) {
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 != null && arrayList2.size() > 0) {
            ByteBuffer byteBuffer = ChartViewerItemHelper.getVizByteBufferFromViewerItem(viewerItem);
            ChartItem chartItem = ChartViewerItemHelper.getChartItemFromViewerItem(viewerItem);
            VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
            if (byteBuffer != null && chartItem != null && visualizationSpecification != null) {
                String[] stringArray = ChartViewerItemHelper.getRelabeledValues(visualizationSpecification, string, arrayList2.toArray(new String[arrayList2.size()]));
                arrayList2 = new ArrayList();
                for (String string2 : stringArray) {
                    arrayList2.add(string2);
                }
            }
        }
        return arrayList2;
    }

    protected static String getAxisColumnName(ViewerItem viewerItem, ChartType chartType, String string) {
        VizDataProcessor vizDataProcessor;
        int n;
        String string2 = null;
        ByteBuffer byteBuffer = ChartViewerItemHelper.getVizByteBufferFromViewerItem(viewerItem);
        if (byteBuffer != null && (n = (vizDataProcessor = new VizDataProcessor()).readDataSources(byteBuffer)) > 0) {
            Collection collection = vizDataProcessor.getSources();
            for (VizDataSource vizDataSource : collection) {
                string2 = ChartViewerItemHelper.getSourceNameForRole(viewerItem, string);
            }
        }
        return string2;
    }

    public static String getSourceNameForRole(ViewerItem viewerItem, String string) {
        return ChartViewerItemHelper.getSourceNameForRole(ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem), string);
    }

    public static String getSourceNameForRole(VisualizationSpecification visualizationSpecification, String string) {
        String string2 = null;
        ElementSpecification elementSpecification = (ElementSpecification)ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, ElementSpecification.class);
        if (string == null) {
            return string2;
        }
        if (!string.equals("split")) {
            if (string.equals("yLOW") || string.equals("yHIGH")) {
                string2 = ChartViewerItemHelper.getSourceName(elementSpecification, "y");
                if (string2.startsWith("#")) {
                    string2 = string.equals("yLOW") ? "#LOW" : "#HIGH";
                } else {
                    String string3 = string.equals("yLOW") ? "_LOW" : "_HIGH";
                    string2 = string2 + string3;
                }
            } else {
                string2 = ChartViewerItemHelper.getSourceName(elementSpecification, string);
            }
        } else {
            AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
            if (aestheticSpecificationArray != null && aestheticSpecificationArray.length > 0) {
                for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray) {
                    VariableSpecification variableSpecification = aestheticSpecification.getVariable();
                    if (!(variableSpecification instanceof SourceVariableSpecification)) continue;
                    string2 = ((SourceVariableSpecification)variableSpecification).getSourceName();
                    break;
                }
            }
        }
        return string2;
    }

    private static void sytemOutRoleNames(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(";");
        }
    }

    private static SourceVariableSpecification getSourceVarSpec(VisualizationSpecification visualizationSpecification, String string) {
        VariableSpecification variableSpecification;
        SourceVariableSpecification sourceVariableSpecification;
        block6: {
            ElementSpecification elementSpecification;
            block4: {
                block5: {
                    DimensionSpecification dimensionSpecification;
                    CoordinatesSpecification[] coordinatesSpecificationArray;
                    sourceVariableSpecification = null;
                    variableSpecification = null;
                    elementSpecification = (ElementSpecification)ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, ElementSpecification.class);
                    if (string.equals("split")) break block4;
                    if (!"x".equals(string) && !"z".equals(string)) break block5;
                    GraphSpecification graphSpecification = (GraphSpecification)elementSpecification.findAncestorOfType(GraphSpecification.class);
                    if (graphSpecification != null && (coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) != null && coordinatesSpecificationArray.length > 0 && (dimensionSpecification = ChartViewerItemHelper.getDimensionSpecByRole(coordinatesSpecificationArray[0], string)) != null) {
                        VariableSpecification variableSpecification2 = dimensionSpecification.getClusterVariable();
                        variableSpecification = variableSpecification2 != null ? variableSpecification2 : ("x".equals(string) ? elementSpecification.getX() : elementSpecification.getZ());
                    }
                    break block6;
                }
                if (!"y".equals(string)) break block6;
                variableSpecification = elementSpecification.getY();
                break block6;
            }
            AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
            if (aestheticSpecificationArray != null && aestheticSpecificationArray.length > 0) {
                for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray) {
                    if (aestheticSpecification instanceof LabelingSpecification) continue;
                    variableSpecification = aestheticSpecification.getVariable();
                }
            }
        }
        if (variableSpecification instanceof SourceVariableSpecification) {
            sourceVariableSpecification = (SourceVariableSpecification)variableSpecification;
        }
        return sourceVariableSpecification;
    }

    private static String getSourceName(ElementSpecification elementSpecification, String string) {
        GraphSpecification graphSpecification;
        String string2 = null;
        VariableSpecification variableSpecification = null;
        if ("x".equals(string) || "z".equals(string)) {
            DimensionSpecification dimensionSpecification;
            CoordinatesSpecification[] coordinatesSpecificationArray;
            graphSpecification = (GraphSpecification)elementSpecification.findAncestorOfType(GraphSpecification.class);
            if (graphSpecification != null && (coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) != null && coordinatesSpecificationArray.length > 0 && (dimensionSpecification = ChartViewerItemHelper.getDimensionSpecByRole(coordinatesSpecificationArray[0], string)) != null) {
                VariableSpecification variableSpecification2 = dimensionSpecification.getClusterVariable();
                variableSpecification = variableSpecification2 != null ? variableSpecification2 : ("x".equals(string) ? elementSpecification.getX() : elementSpecification.getZ());
            }
        } else if ("y".equals(string)) {
            variableSpecification = elementSpecification.getY();
        }
        if (variableSpecification != null && variableSpecification instanceof SourceVariableSpecification) {
            graphSpecification = (SourceVariableSpecification)variableSpecification;
            string2 = graphSpecification.getSourceName();
        }
        return string2;
    }

    private static ArrayList<String> removeCaseNum(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equalsIgnoreCase("$CASENUM")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String getGraphicTitleLabel(ViewerItem viewerItem) {
        ArrayList<String> arrayList = ChartViewerItemHelper.getCategoryList(viewerItem, "split");
        return ChartViewerItemHelper.getGraphicTitleLabel(ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem));
    }

    public static String getGraphicTitleLabel(VisualizationSpecification visualizationSpecification) {
        String string = "";
        if (visualizationSpecification != null) {
            LabelFrameSpecification labelFrameSpecification = (LabelFrameSpecification)ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, LabelFrameSpecification.class);
            TextSpecification[] textSpecificationArray = labelFrameSpecification != null ? labelFrameSpecification.getLabelChild().getTextSpecifications() : null;
            string = textSpecificationArray != null && textSpecificationArray.length > 0 ? textSpecificationArray[0].getText() : "";
        }
        return string;
    }

    public static String getAxisLabel_OLD(ViewerItem viewerItem, String string) {
        String string2 = "";
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        if (visualizationSpecification != null) {
            CoordinatesSpecification[] coordinatesSpecificationArray;
            GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
            for (CoordinatesSpecification coordinatesSpecification : coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) {
                LabelSpecification labelSpecification;
                TextSpecification[] textSpecificationArray;
                AxisSpecification[] axisSpecificationArray;
                DimensionSpecification dimensionSpecification = ChartViewerItemHelper.getDimensionSpecByRole(coordinatesSpecification, string);
                if (dimensionSpecification == null || (axisSpecificationArray = (AxisSpecification[])dimensionSpecification.findDescendantsOfType(AxisSpecification.class)) == null || axisSpecificationArray.length <= 0 || (textSpecificationArray = (labelSpecification = axisSpecificationArray[0].getLabel()).getTextSpecifications()).length <= 0) continue;
                string2 = textSpecificationArray[0].getText();
                break;
            }
        }
        return string2;
    }

    public static String getLegendLabel(ViewerItem viewerItem) {
        String string = ChartViewerItemHelper.getAxisLabel(viewerItem, "split");
        return string;
    }

    public static String getAxisLabel(ViewerItem viewerItem, String string) {
        String string2 = "";
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        if (visualizationSpecification != null) {
            GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
            if (!string.equals("split")) {
                CoordinatesSpecification[] coordinatesSpecificationArray;
                for (CoordinatesSpecification coordinatesSpecification : coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) {
                    TextSpecification[] textSpecificationArray;
                    AxisSpecification[] axisSpecificationArray;
                    DimensionSpecification dimensionSpecification = ChartViewerItemHelper.getDimensionSpecByRole(coordinatesSpecification, string);
                    if (dimensionSpecification == null || (axisSpecificationArray = (AxisSpecification[])dimensionSpecification.findDescendantsOfType(AxisSpecification.class)) == null || axisSpecificationArray.length <= 0) continue;
                    LabelSpecification labelSpecification = axisSpecificationArray[0].getLabel();
                    TextSpecification[] textSpecificationArray2 = textSpecificationArray = labelSpecification != null ? labelSpecification.getTextSpecifications() : null;
                    if (textSpecificationArray == null || textSpecificationArray.length <= 0) continue;
                    string2 = textSpecificationArray[0].getText();
                    break;
                }
            } else {
                TextSpecification[] textSpecificationArray;
                LegendSpecification legendSpecification;
                LabelSpecification labelSpecification;
                LegendTargetSpecification legendTargetSpecification;
                ElementSpecification elementSpecification = (ElementSpecification)ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, ElementSpecification.class);
                if (elementSpecification != null && (legendTargetSpecification = ChartViewerItemHelper.getLegendTargetSpec(elementSpecification)) != null && (labelSpecification = (legendSpecification = (LegendSpecification)legendTargetSpecification.findAncestorOfType(LegendSpecification.class)).getTitleChild()) != null && (textSpecificationArray = labelSpecification.getTextSpecifications()).length > 0) {
                    string2 = textSpecificationArray[0].getText();
                }
            }
        }
        return string2;
    }

    private static SummaryType getStatSummaryType(VisualizationSpecification visualizationSpecification) {
        ElementSpecification[] elementSpecificationArray;
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
        SummaryType summaryType = null;
        block0: for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            StatisticSpecification[] statisticSpecificationArray;
            for (StatisticSpecification statisticSpecification : statisticSpecificationArray = elementSpecification.getStatistics()) {
                if (!(statisticSpecification instanceof SummaryStatisticSpecification)) continue;
                summaryType = ((SummaryStatisticSpecification)statisticSpecification).getMethod();
                break block0;
            }
        }
        return summaryType;
    }

    public static SummaryType getStatSummaryType(ViewerItem viewerItem) {
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        return ChartViewerItemHelper.getStatSummaryType(visualizationSpecification);
    }

    public static boolean isYAxisStatistic(ViewerItem viewerItem) {
        boolean bl = false;
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
        SummaryType summaryType = ChartViewerItemHelper.getStatSummaryType(visualizationSpecification);
        if (summaryType == SummaryType.CUMULATIVE_COUNT || summaryType == SummaryType.PERCENT || summaryType == SummaryType.CUMULATIVE_PERCENT || summaryType == SummaryType.CUMULATIVE_SUM || summaryType == SummaryType.PERCENTILES) {
            bl = true;
        }
        return bl;
    }

    public static ChartType getGraphicChartType(VisualizationSpecification visualizationSpecification) {
        ChartType chartType = ChartType.Other;
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
        Specification specification = ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, ElementSpecification.class);
        boolean bl = ChartViewerItemHelper.isGroupedChart(visualizationSpecification);
        boolean bl2 = ChartViewerItemHelper.hasErrorBarChart(graphSpecification);
        boolean bl3 = ChartViewerItemHelper.hasRangeBarChart(graphSpecification);
        boolean bl4 = ChartViewerItemHelper.isSimpleScatterplotChart(graphSpecification);
        boolean bl5 = ChartViewerItemHelper.is3DChart(graphSpecification, true);
        boolean bl6 = ChartViewerItemHelper.hasSingleAxis(graphSpecification);
        boolean bl7 = graphSpecification.getFacetingChild() != null;
        String string = ChartViewerItemHelper.getGraphicTitleLabel(visualizationSpecification);
        if (ChartViewerItemHelper.isDualYAxis(graphSpecification) || ChartViewerItemHelper.hasDropLineChart(graphSpecification) || bl5 || bl7 || bl3 && !bl2) {
            return chartType;
        }
        if (ChartViewerItemHelper.isPieChart(graphSpecification)) {
            return ChartType.PieChart;
        }
        if (bl2 && ChartViewerItemHelper.isHiLoClose(visualizationSpecification) && !ChartViewerItemHelper.isDifferenceArea(visualizationSpecification)) {
            return bl ? ChartType.ClusteredErrorBar : ChartType.SimpleErrorBar;
        }
        if (ChartViewerItemHelper.isHistogramChart((AbstractSpecification)graphSpecification)) {
            boolean bl8 = ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, AreaSpecification.class) != null;
            chartType = ChartType.Other;
            if (!bl && !bl8) {
                chartType = ChartType.SimpleHistogram;
            }
            return chartType;
        }
        if (ChartViewerItemHelper.isBoxPlotChart(visualizationSpecification)) {
            ChartType chartType2 = ChartType.SimpleBoxplot;
            if (bl6) {
                chartType2 = ChartType.OneDBoxplot;
            } else if (bl && ChartViewerItemHelper.isClusterChart(graphSpecification)) {
                chartType2 = ChartType.ClusteredBoxplot;
            }
            return chartType2;
        }
        if (bl4 && !ChartViewerItemHelper.isSPLOMChart(graphSpecification) && !ChartViewerItemHelper.checkScatterType(graphSpecification, 1)) {
            LineSpecification[] lineSpecificationArray;
            boolean bl9 = false;
            for (LineSpecification lineSpecification : lineSpecificationArray = (LineSpecification[])graphSpecification.findDescendantsOfType(LineSpecification.class)) {
                if (!ChartViewerItemHelper.isFitLineElement(lineSpecification)) continue;
                bl9 = true;
                break;
            }
            if (!bl9) {
                return bl ? ChartType.GroupedScatter : ChartType.SimpleScatter;
            }
            return bl ? ChartType.GroupedScatterWithFitLine : ChartType.SimpleScatterWithFitLine;
        }
        if (specification instanceof IntervalSpecification) {
            if (!bl) {
                chartType = ChartType.SimpleBar;
            } else if (ChartViewerItemHelper.isClusterChart(graphSpecification)) {
                chartType = ChartType.ClusteredBar;
            } else if (ChartViewerItemHelper.isStackedElement(specification)) {
                chartType = ChartType.StackedBar;
            }
        } else if (specification instanceof LineSpecification) {
            chartType = !bl ? ChartType.SimpleLine : ChartType.MultipleLine;
        }
        return chartType;
    }

    public static boolean isErrorBarChart(ViewerItem viewerItem) {
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        boolean bl = false;
        if (visualizationSpecification != null) {
            GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
            bl = ChartViewerItemHelper.hasErrorBarChart(graphSpecification);
        }
        return bl;
    }

    public static boolean is3DChart(ViewerItem viewerItem) {
        boolean bl = false;
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        if (visualizationSpecification != null) {
            GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
            bl = ChartViewerItemHelper.is3DChart(graphSpecification, true);
        }
        return bl;
    }

    public static ArrayList<SmoothStatisticSpecification> getFitlineMethodTypes(ViewerItem viewerItem) {
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        LineSpecification[] lineSpecificationArray = (LineSpecification[])visualizationSpecification.findDescendantsOfType(LineSpecification.class);
        ArrayList<SmoothStatisticSpecification> arrayList = new ArrayList<SmoothStatisticSpecification>();
        if (lineSpecificationArray != null) {
            block0: for (int i = 0; i < lineSpecificationArray.length; ++i) {
                StatisticSpecification[] statisticSpecificationArray;
                LineSpecification lineSpecification = lineSpecificationArray[i];
                for (StatisticSpecification statisticSpecification : statisticSpecificationArray = lineSpecification.getStatistics()) {
                    SmoothMethodType smoothMethodType;
                    if (!(statisticSpecification instanceof SmoothStatisticSpecification) || (smoothMethodType = ((SmoothStatisticSpecification)statisticSpecification).getMethod()) == null || smoothMethodType == SmoothMethodType.STEP_LEFT || smoothMethodType == SmoothMethodType.STEP_CENTER || smoothMethodType == SmoothMethodType.STEP_RIGHT || smoothMethodType == SmoothMethodType.SPLINE) continue;
                    arrayList.add((SmoothStatisticSpecification)statisticSpecification);
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    public static ArrayList performStatsOnDataAxis(ViewerItem viewerItem, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3) {
        ArrayList arrayList4 = null;
        if (ChartViewerItemHelper.getStatSummaryType(viewerItem) == SummaryType.CUMULATIVE_SUM) {
            arrayList4 = arrayList2 != null ? ChartViewerItemHelper.performCumulativeSum(viewerItem, arrayList, arrayList2, arrayList3) : ChartViewerItemHelper.performCumulativeSum(viewerItem, arrayList);
        } else if (ChartViewerItemHelper.getStatSummaryType(viewerItem) == SummaryType.CUMULATIVE_PERCENT) {
            arrayList4 = arrayList2 != null ? ChartViewerItemHelper.performCumulativePercent(viewerItem, arrayList, arrayList2, arrayList3) : ChartViewerItemHelper.performCumulativePercent(viewerItem, arrayList);
        }
        return arrayList4;
    }

    protected static ArrayList performCumulativePercent(ViewerItem viewerItem, ArrayList<String> arrayList) {
        double d = 0.0;
        for (String string : arrayList) {
            Double d2 = Double.valueOf(string);
            if (d2 == null) continue;
            d += d2.doubleValue();
        }
        ArrayList arrayList2 = new ArrayList();
        double d3 = 0.0;
        double d4 = 0.0;
        for (String string : arrayList) {
            Double d5 = Double.valueOf(string);
            if (d5 == null) continue;
            d3 = (d4 += d5.doubleValue()) / d * 100.0;
            arrayList2.add("" + d3);
        }
        return arrayList2;
    }

    protected static ArrayList performCumulativeSum(ViewerItem viewerItem, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        double d = 0.0;
        for (String string : arrayList) {
            Double d2 = Double.valueOf(string);
            if (d2 == null) continue;
            arrayList2.add("" + (d += d2.doubleValue()));
        }
        return arrayList2;
    }

    protected static ArrayList performCumulativePercent(ViewerItem viewerItem, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3) {
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (String string : arrayList) {
            arrayList4.add(null);
        }
        for (String string : arrayList3) {
            Double d;
            String string2;
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n = 0; n < arrayList.size(); ++n) {
                string2 = arrayList.get(n);
                d = Double.valueOf(string2);
                if (d == null) continue;
                d2 += d.doubleValue();
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string2 = arrayList.get(n);
                if (!string.equals(arrayList2.get(n)) || (d = Double.valueOf(string2)) == null) continue;
                double d4 = (d3 += d.doubleValue()) / d2 * 100.0;
                arrayList4.set(n, "" + d4);
            }
        }
        return arrayList4;
    }

    protected static ArrayList performCumulativeSum(ViewerItem viewerItem, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3) {
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (String string : arrayList) {
            arrayList4.add(null);
        }
        double d = 0.0;
        for (String string : arrayList3) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Double d2;
                String string2 = arrayList.get(i);
                if (!string.equals(arrayList2.get(i)) || (d2 = Double.valueOf(string2)) == null) continue;
                arrayList4.add("" + (d += d2.doubleValue()));
            }
        }
        return arrayList4;
    }

    private static GraphSpecification getGraphSpec(VisualizationSpecification visualizationSpecification) {
        return (GraphSpecification)ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, GraphSpecification.class);
    }

    private static boolean isExceptionVariable(VariableSpecification variableSpecification) {
        VisualizationSpecification visualizationSpecification;
        boolean bl = false;
        if (variableSpecification != null && (visualizationSpecification = variableSpecification.getTop()) != null) {
            String string = variableSpecification.getCreator();
            bl = string != null && string.indexOf("_exceptions") > -1;
        }
        return bl;
    }

    private static boolean isPieChart(GraphSpecification graphSpecification) {
        boolean bl = false;
        boolean bl2 = false;
        if (graphSpecification == null) {
            return false;
        }
        Specification specification = ChartViewerItemHelper.getFirstSpecByClass(graphSpecification.getTop(), null, ElementSpecification.class);
        if (specification instanceof IntervalSpecification) {
            bl = true;
        }
        CoordinatesSpecification[] coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications();
        block0: for (int i = 0; coordinatesSpecificationArray != null && i < coordinatesSpecificationArray.length; ++i) {
            CoordinatesSpecification coordinatesSpecification = coordinatesSpecificationArray[i];
            CoordinateTransformSpecification[] coordinateTransformSpecificationArray = coordinatesSpecification.getCoordinateTransformSpecifications();
            for (int j = 0; coordinateTransformSpecificationArray != null && j < coordinateTransformSpecificationArray.length; ++j) {
                if (!(coordinateTransformSpecificationArray[j] instanceof PolarTransformSpecification)) continue;
                bl2 = true;
                break block0;
            }
        }
        return bl && bl2;
    }

    private static boolean isStyleAesthetic(AestheticSpecification aestheticSpecification) {
        boolean bl;
        boolean bl2 = bl = aestheticSpecification instanceof StyleAestheticSpecification || aestheticSpecification instanceof ColorAestheticSpecification || aestheticSpecification instanceof PatternAestheticSpecification || aestheticSpecification instanceof DashAestheticSpecification || aestheticSpecification instanceof ShapeAestheticSpecification || aestheticSpecification instanceof SizeAestheticSpecification;
        if (aestheticSpecification instanceof SizeAestheticSpecification) {
            bl = ((SummaryStatisticSpecification[])aestheticSpecification.findDescendantsOfType(SummaryStatisticSpecification.class)).length == 0;
        }
        return bl;
    }

    private static boolean isSubgroupStyleAesthetic(AestheticSpecification aestheticSpecification) {
        boolean bl = false;
        if (ChartViewerItemHelper.isStyleAesthetic(aestheticSpecification) && aestheticSpecification.getVariable() != null && !ChartViewerItemHelper.isExceptionVariable(aestheticSpecification.getVariable())) {
            bl = true;
        }
        return bl;
    }

    private static boolean isGroupedChart(VisualizationSpecification visualizationSpecification) {
        boolean bl = false;
        ElementSpecification[] elementSpecificationArray = (ElementSpecification[])visualizationSpecification.findDescendantsOfType(ElementSpecification.class);
        if (elementSpecificationArray != null) {
            block0: for (ElementSpecification elementSpecification : elementSpecificationArray) {
                AestheticSpecification[] aestheticSpecificationArray = elementSpecification.getAestheticSpecifications();
                if (aestheticSpecificationArray == null || aestheticSpecificationArray.length <= 0) continue;
                for (AestheticSpecification aestheticSpecification : aestheticSpecificationArray) {
                    if (!ChartViewerItemHelper.isSubgroupStyleAesthetic(aestheticSpecification)) continue;
                    bl = true;
                    break block0;
                }
            }
        }
        return bl;
    }

    private static boolean isClusterChart(GraphSpecification graphSpecification) {
        boolean bl = false;
        DimensionSpecification[] dimensionSpecificationArray = (DimensionSpecification[])graphSpecification.findDescendantsOfType(DimensionSpecification.class);
        if (dimensionSpecificationArray != null && dimensionSpecificationArray.length > 0) {
            for (DimensionSpecification dimensionSpecification : dimensionSpecificationArray) {
                VariableSpecification variableSpecification = dimensionSpecification.getClusterVariable();
                if (variableSpecification == null) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static boolean isStackedElement(Specification specification) {
        PositionModifierType positionModifierType;
        boolean bl = false;
        if (specification instanceof ElementSpecification && (positionModifierType = ((ElementSpecification)specification).getPositionModifier()) != null && (positionModifierType == PositionModifierType.STACK || positionModifierType == PositionModifierType.STACK_INTERPOLATING)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isErrorBarElement(IntervalSpecification intervalSpecification) {
        if (intervalSpecification == null) {
            return false;
        }
        if (!ChartViewerItemHelper.isRangeBar(intervalSpecification)) {
            return false;
        }
        if (ChartViewerItemHelper.isDropLineElement(intervalSpecification)) {
            return false;
        }
        boolean bl = true;
        StyleSpecification styleSpecification = intervalSpecification.getStyle("");
        if (styleSpecification.getSymbol() == null) {
            bl = false;
        }
        if (bl && (ChartViewerItemHelper.isBarWithMethod(intervalSpecification, SummaryType.CONFI_OF_MEAN) || ChartViewerItemHelper.isBarWithMethod(intervalSpecification, SummaryType.SE) || ChartViewerItemHelper.isBarWithMethod(intervalSpecification, SummaryType.SD))) {
            return true;
        }
        return bl;
    }

    private static boolean isDropLineElement(IntervalSpecification intervalSpecification) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        if (intervalSpecification == null || !ChartViewerItemHelper.isRangeBar(intervalSpecification)) {
            return false;
        }
        VariableSpecification variableSpecification = intervalSpecification.getX();
        VariableSpecification variableSpecification2 = intervalSpecification.getY();
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(intervalSpecification.getTop());
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (!elementSpecification.getIdType().equals("point") || !elementSpecification.getX().equals(variableSpecification) || variableSpecification2 == null || !elementSpecification.getY().equals(variableSpecification2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isBarWithMethod(IntervalSpecification intervalSpecification, SummaryType summaryType) {
        SummaryType summaryType2;
        StatisticSpecification statisticSpecification;
        boolean bl = false;
        StatisticSpecification statisticSpecification2 = statisticSpecification = intervalSpecification.getStatistics().length > 0 ? intervalSpecification.getStatistics()[0] : null;
        if (statisticSpecification instanceof SummaryStatisticSpecification && (summaryType2 = ((SummaryStatisticSpecification)statisticSpecification).getMethod()) == summaryType) {
            bl = true;
        }
        return bl;
    }

    private static boolean isRangeBar(IntervalSpecification intervalSpecification) {
        return ChartViewerItemHelper.isBarWithMethod(intervalSpecification, SummaryType.RANGE);
    }

    private static boolean hasRangeBarChart(GraphSpecification graphSpecification) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (!(elementSpecification instanceof IntervalSpecification) || !ChartViewerItemHelper.isRangeBar((IntervalSpecification)elementSpecification)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean hasErrorBarChart(GraphSpecification graphSpecification) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (!(elementSpecification instanceof IntervalSpecification) || !ChartViewerItemHelper.isErrorBarElement((IntervalSpecification)elementSpecification)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isSimpleScatterplotChart(GraphSpecification graphSpecification) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (elementSpecification.getX() == null || elementSpecification.getY() == null) continue;
            bl = true;
            break;
        }
        return ChartViewerItemHelper.hasSimplePointSpecification(graphSpecification) && bl && (!ChartViewerItemHelper.hasCategoricalAxis(graphSpecification) || ChartViewerItemHelper.is3DChart(graphSpecification, true));
    }

    private static boolean hasSimplePointSpecification(GraphSpecification graphSpecification) {
        if (graphSpecification == null) {
            return false;
        }
        ElementSpecification[] elementSpecificationArray = graphSpecification.getElementSpecifications();
        int n = 0;
        for (ElementSpecification elementSpecification : elementSpecificationArray) {
            if (!(elementSpecification instanceof PointSpecification) || !ChartViewerItemHelper.isVisible((AbstractSpecification)elementSpecification, "")) continue;
            ++n;
        }
        return n == 1;
    }

    private static boolean isVisible(AbstractSpecification abstractSpecification, String string) {
        Boolean bl;
        boolean bl2 = true;
        StyleSpecification styleSpecification = null;
        if (abstractSpecification instanceof AbstractVisualSpecification) {
            if (abstractSpecification instanceof MinorTicksSpecification) {
                string = "mark";
            }
            styleSpecification = ((AbstractVisualSpecification)abstractSpecification).getStyle(string);
        } else if (abstractSpecification instanceof LabelingSpecification) {
            styleSpecification = (StyleSpecification)((LabelingSpecification)abstractSpecification).getStyle();
        }
        if (styleSpecification != null && (bl = styleSpecification.getVisible()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public static boolean isAxisCategorical(ViewerItem viewerItem, String string) {
        VisualizationSpecification visualizationSpecification = ChartViewerItemHelper.getVisSpecFromViewerItem(viewerItem);
        boolean bl = false;
        if (visualizationSpecification != null) {
            ElementSpecification[] elementSpecificationArray;
            GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualizationSpecification);
            for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
                if (string.equalsIgnoreCase("x") && ChartViewerItemHelper.isCategorical(elementSpecification.getX())) {
                    return true;
                }
                if (string.equalsIgnoreCase("y") && ChartViewerItemHelper.isCategorical(elementSpecification.getY())) {
                    return true;
                }
                if (!string.equalsIgnoreCase("z") || !ChartViewerItemHelper.isCategorical(elementSpecification.getZ())) continue;
                return true;
            }
        }
        return bl;
    }

    private static boolean hasCategoricalAxis(GraphSpecification graphSpecification) {
        ElementSpecification[] elementSpecificationArray;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (ChartViewerItemHelper.isCategorical(elementSpecification.getX())) {
                return true;
            }
            if (ChartViewerItemHelper.isCategorical(elementSpecification.getY())) {
                return true;
            }
            if (!ChartViewerItemHelper.isCategorical(elementSpecification.getZ())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCategorical(VariableSpecification variableSpecification) {
        if (variableSpecification == null) {
            return false;
        }
        Boolean bl = variableSpecification.getCategorical();
        return bl == null || bl != false;
    }

    private static boolean is3DChart(GraphSpecification graphSpecification, boolean bl) {
        CoordinatesSpecification[] coordinatesSpecificationArray;
        if (graphSpecification == null) {
            return false;
        }
        for (CoordinatesSpecification coordinatesSpecification : coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) {
            DimensionSpecification[] dimensionSpecificationArray = coordinatesSpecification.getDimensionSpecifications();
            if (dimensionSpecificationArray.length != 3 || bl && dimensionSpecificationArray[2].getAxisSpecifications().length == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean isFitLineElement(LineSpecification lineSpecification) {
        StatisticSpecification[] statisticSpecificationArray;
        boolean bl = false;
        if (lineSpecification == null) {
            return false;
        }
        for (StatisticSpecification statisticSpecification : statisticSpecificationArray = lineSpecification.getStatistics()) {
            SmoothMethodType smoothMethodType;
            if (!(statisticSpecification instanceof SmoothStatisticSpecification) && !(statisticSpecification instanceof RegionStatisticSpecification)) continue;
            bl = true;
            if (!(statisticSpecification instanceof SmoothStatisticSpecification) || (smoothMethodType = ((SmoothStatisticSpecification)statisticSpecification).getMethod()) != SmoothMethodType.STEP_LEFT && smoothMethodType != SmoothMethodType.STEP_CENTER && smoothMethodType != SmoothMethodType.STEP_RIGHT && smoothMethodType != SmoothMethodType.SPLINE) break;
            bl = false;
            break;
        }
        return bl;
    }

    private static boolean isHistogramChart(AbstractSpecification abstractSpecification) {
        boolean bl = false;
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(abstractSpecification.getTop());
        if (graphSpecification != null && !ChartViewerItemHelper.isSPLOMChart(graphSpecification)) {
            ElementSpecification[] elementSpecificationArray;
            for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
                if (!ChartViewerItemHelper.isHistogramElement((Specification)elementSpecification)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private static boolean isHistogramElement(Specification specification) {
        ElementSpecification elementSpecification;
        boolean bl = false;
        if (specification instanceof ElementSpecification && ((BinStatisticSpecification[])(elementSpecification = (ElementSpecification)specification).findDescendantsOfType(BinStatisticSpecification.class)).length > 0 && ((SummaryStatisticSpecification[])elementSpecification.findDescendantsOfType(SummaryStatisticSpecification.class)).length > 0) {
            bl = true;
        }
        return bl;
    }

    private static boolean isSPLOMChart(GraphSpecification graphSpecification) {
        boolean bl = false;
        if (graphSpecification != null) {
            bl = ChartViewerItemHelper.checkScatterType(graphSpecification, 2);
        }
        return bl;
    }

    private static boolean checkScatterType(GraphSpecification graphSpecification, int n) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            VariableSpecification variableSpecification;
            if (ChartViewerItemHelper.isIntervalRangeElement(elementSpecification) || (variableSpecification = elementSpecification.getX()) == null || n != ChartViewerItemHelper.getVariableExpressionType(variableSpecification)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static int getVariableExpressionType(VariableSpecification variableSpecification) {
        String string;
        int n = 0;
        if (variableSpecification instanceof ExpressionVariableSpecification && (string = ((ExpressionVariableSpecification)variableSpecification).getExpression()) != null && string.indexOf(43) > 0) {
            n = 1;
            if (string.indexOf(47) > 0) {
                n = 2;
            }
        }
        return n;
    }

    private static boolean isIntervalRangeElement(ElementSpecification elementSpecification) {
        boolean bl = false;
        SummaryStatisticSpecification[] summaryStatisticSpecificationArray = (SummaryStatisticSpecification[])elementSpecification.findDescendantsOfType(SummaryStatisticSpecification.class);
        if (summaryStatisticSpecificationArray.length > 0) {
            bl = SummaryType.RANGE == summaryStatisticSpecificationArray[0].getMethod();
        }
        return bl;
    }

    public static LegendTargetSpecification getLegendTargetSpec(ElementSpecification elementSpecification) {
        LegendTargetSpecification[] legendTargetSpecificationArray;
        LegendTargetSpecification legendTargetSpecification = null;
        VisualizationSpecification visualizationSpecification = elementSpecification.getTop();
        for (LegendTargetSpecification legendTargetSpecification2 : legendTargetSpecificationArray = (LegendTargetSpecification[])visualizationSpecification.findDescendantsOfType(LegendTargetSpecification.class)) {
            ElementSpecification elementSpecification2 = legendTargetSpecification2.getElement();
            AestheticSpecification aestheticSpecification = legendTargetSpecification2.getAesthetic();
            if (aestheticSpecification != null && aestheticSpecification.getParent() == elementSpecification) {
                legendTargetSpecification = legendTargetSpecification2;
                break;
            }
            if (elementSpecification2 == null || elementSpecification2 != elementSpecification) continue;
            legendTargetSpecification = legendTargetSpecification2;
            break;
        }
        return legendTargetSpecification;
    }

    private static boolean isBoxPlotChart(VisualizationSpecification visualizationSpecification) {
        boolean bl = false;
        SchemaSpecification[] schemaSpecificationArray = (SchemaSpecification[])visualizationSpecification.findDescendantsOfType(SchemaSpecification.class);
        if (schemaSpecificationArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    private static boolean hasSingleAxis(GraphSpecification graphSpecification) {
        CoordinatesSpecification[] coordinatesSpecificationArray;
        if (graphSpecification == null) {
            return false;
        }
        int n = 0;
        for (CoordinatesSpecification coordinatesSpecification : coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) {
            DimensionSpecification[] dimensionSpecificationArray;
            for (DimensionSpecification dimensionSpecification : dimensionSpecificationArray = coordinatesSpecification.getDimensionSpecifications()) {
                if (dimensionSpecification.getAxisSpecifications().length <= 0) continue;
                ++n;
            }
        }
        return n == 1;
    }

    private static boolean hasDropLineChart(GraphSpecification graphSpecification) {
        ElementSpecification[] elementSpecificationArray;
        boolean bl = false;
        for (ElementSpecification elementSpecification : elementSpecificationArray = graphSpecification.getElementSpecifications()) {
            if (!(elementSpecification instanceof IntervalSpecification) || !ChartViewerItemHelper.isDropLineElement((IntervalSpecification)elementSpecification)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isHiLoClose(VisualizationSpecification visualizationSpecification) {
        StatisticSpecification[] statisticSpecificationArray;
        boolean bl = ((PointSpecification[])visualizationSpecification.findDescendantsOfType(PointSpecification.class)).length == 1;
        IntervalSpecification[] intervalSpecificationArray = (IntervalSpecification[])visualizationSpecification.findDescendantsOfType(IntervalSpecification.class);
        if (bl && intervalSpecificationArray.length == 1 && (statisticSpecificationArray = intervalSpecificationArray[0].getStatistics()).length > 0 && statisticSpecificationArray[0] instanceof SummaryStatisticSpecification) {
            boolean bl2 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getMethod() == SummaryType.RANGE;
            boolean bl3 = ((SummaryStatisticSpecification)statisticSpecificationArray[0]).getBase() == SummaryBaseType.COORDINATE;
            VariableSpecification variableSpecification = intervalSpecificationArray[0].getY();
            if (bl2 && !bl3 && variableSpecification instanceof ExpressionVariableSpecification) {
                return true;
            }
        }
        return false;
    }

    private static Specification getFirstSpecByClass(VisualizationSpecification visualizationSpecification, Specification specification, Class<? extends Specification> clazz) {
        specification = specification == null ? visualizationSpecification : specification;
        Specification[] specificationArray = specification.findDescendantsOfType(clazz);
        return specificationArray == null || specificationArray.length == 0 ? null : specificationArray[0];
    }

    private static boolean isDifferenceArea(VisualizationSpecification visualizationSpecification) {
        boolean bl = ChartViewerItemHelper.getFirstSpecByClass(visualizationSpecification, null, AreaSpecification.class) != null;
        return bl && (ChartViewerItemHelper.getSpecByClassAndAttr(visualizationSpecification, null, ColorAestheticSpecification.class, "affect", "main") != null || ChartViewerItemHelper.getSpecByClassAndAttr(visualizationSpecification, null, PatternAestheticSpecification.class, "clamp", "true") != null);
    }

    private static Specification getSpecByClassAndAttr(VisualizationSpecification visualizationSpecification, Specification specification, Class<? extends Specification> clazz, String string, String string2) {
        return ChartViewerItemHelper.getSpecByClassAndAttr(visualizationSpecification, specification, clazz, string, string2, 0);
    }

    private static Specification getSpecByClassAndAttr(VisualizationSpecification visualizationSpecification, Specification specification, Class<? extends Specification> clazz, String string, String string2, int n) {
        Specification[] specificationArray;
        int n2 = 0;
        Specification specification2 = null;
        specification = specification == null ? visualizationSpecification : specification;
        for (Specification specification3 : specificationArray = specification.findDescendantsOfType(clazz)) {
            Attribute attribute;
            if (!(specification3 instanceof AbstractSpecification) || (attribute = ((AbstractSpecification)specification3).getAttribute(string)) == null || !attribute.toString().equals(string2) || n != n2++) continue;
            specification2 = specification3;
            break;
        }
        return specification2;
    }

    private static boolean isDualYAxis(GraphSpecification graphSpecification) {
        CoordinatesSpecification[] coordinatesSpecificationArray;
        int n = 0;
        for (CoordinatesSpecification coordinatesSpecification : coordinatesSpecificationArray = graphSpecification.getCoordinatesSpecifications()) {
            AxisSpecification[] axisSpecificationArray;
            DimensionSpecification dimensionSpecification = ChartViewerItemHelper.getDimensionSpecByRole(coordinatesSpecification, "y");
            if (dimensionSpecification == null || (axisSpecificationArray = (AxisSpecification[])dimensionSpecification.findDescendantsOfType(AxisSpecification.class)) == null || axisSpecificationArray.length <= 0) continue;
            ++n;
        }
        return n == 2;
    }

    private static DimensionSpecification getDimensionSpecByRole(CoordinatesSpecification coordinatesSpecification, String string) {
        DimensionSpecification dimensionSpecification = null;
        DimensionSpecification[] dimensionSpecificationArray = coordinatesSpecification.getDimensionSpecifications();
        if (dimensionSpecificationArray.length > 0 && "x".equals(string)) {
            dimensionSpecification = dimensionSpecificationArray[0];
        } else if (dimensionSpecificationArray.length > 1 && "y".equals(string)) {
            dimensionSpecification = dimensionSpecificationArray[1];
        } else if (dimensionSpecificationArray.length > 2 && "z".equals(string)) {
            dimensionSpecification = dimensionSpecificationArray[2];
        }
        return dimensionSpecification;
    }

    public static String[] getRelabeledValues(VisualizationSpecification visualizationSpecification, String string, String[] stringArray) {
        boolean bl;
        String[] stringArray2 = null;
        FormatSpecification formatSpecification = ChartViewerItemHelper.getFormatSpec(visualizationSpecification, string);
        boolean bl2 = bl = formatSpecification != null && formatSpecification.getBaseFormat() != null;
        if (formatSpecification != null && !bl) {
            RelabelSpecification[] relabelSpecificationArray = formatSpecification.getRelabeling();
            stringArray2 = new String[stringArray.length];
            block0: for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
                for (RelabelSpecification relabelSpecification : relabelSpecificationArray) {
                    if (!ChartViewerItemHelper.areEqual(stringArray[i], relabelSpecification.getFrom())) continue;
                    stringArray2[i] = relabelSpecification.getTo();
                    continue block0;
                }
            }
        }
        return stringArray2 != null ? stringArray2 : stringArray;
    }

    private static boolean areEqual(String string, String string2) {
        boolean bl = string.equals(string2) || MGOWriterHelper.isNumber((String)string) && MGOWriterHelper.isNumber((String)string2) && new Integer(string).intValue() == new Double(string2).intValue();
        return bl;
    }

    protected static FormatSpecification getFormatSpec(VisualizationSpecification visualizationSpecification, String string) {
        FormatSpecification formatSpecification = null;
        SourceVariableSpecification[] sourceVariableSpecificationArray = (SourceVariableSpecification[])visualizationSpecification.findDescendantsOfType(SourceVariableSpecification.class);
        SourceVariableSpecification sourceVariableSpecification = null;
        for (SourceVariableSpecification sourceVariableSpecification2 : sourceVariableSpecificationArray) {
            if (!sourceVariableSpecification2.getSourceName().equals(string)) continue;
            sourceVariableSpecification = sourceVariableSpecification2;
            break;
        }
        if (sourceVariableSpecification != null) {
            formatSpecification = sourceVariableSpecification.getDisplayFormatChild();
        }
        return formatSpecification;
    }

    public static ArrayList<String> getCategoryList(ViewerItem viewerItem, String string) {
        LegendTargetSpecification legendTargetSpecification;
        Object object;
        ArrayList<String> arrayList = null;
        Visualization visualization = VizCache.getCache().getVisualization((ChartItem)viewerItem.getCoreItem());
        GraphSpecification graphSpecification = ChartViewerItemHelper.getGraphSpec(visualization.getSpecification());
        LegendTargetSpecification legendTargetSpecification2 = null;
        if (!string.equals("split")) {
            for (LegendTargetSpecification legendTargetSpecification3 : object = graphSpecification.getCoordinatesSpecifications()) {
                AxisSpecification[] axisSpecificationArray;
                legendTargetSpecification = ChartViewerItemHelper.getDimensionSpecByRole((CoordinatesSpecification)legendTargetSpecification3, string);
                if (legendTargetSpecification == null || (axisSpecificationArray = (AxisSpecification[])legendTargetSpecification.findDescendantsOfType(AxisSpecification.class)) == null || axisSpecificationArray.length <= 0) continue;
                legendTargetSpecification2 = axisSpecificationArray[0];
            }
        } else {
            for (LegendTargetSpecification legendTargetSpecification3 : object = (ElementSpecification[])visualization.getSpecification().findDescendantsOfType(ElementSpecification.class)) {
                legendTargetSpecification = ChartViewerItemHelper.getLegendTargetSpec((ElementSpecification)legendTargetSpecification3);
                if (legendTargetSpecification == null) continue;
                legendTargetSpecification2 = legendTargetSpecification;
                break;
            }
        }
        if (legendTargetSpecification2 == null) {
            return arrayList;
        }
        try {
            object = "";
            if (legendTargetSpecification2 instanceof LegendTargetSpecification) {
                object = "tickLabel";
            } else if (legendTargetSpecification2 instanceof AxisSpecification) {
                object = "baseline";
            }
            ItemInfo itemInfo = ChartViewerItemHelper.getItemInfoById(visualization, legendTargetSpecification2.getId(), (String)object);
            if (itemInfo != null) {
                LegendTargetSpecification legendTargetSpecification4 = (LegendTargetSpecification)itemInfo.get(ItemInfo.ALL_TICKS_KEY);
                String string2 = (String)itemInfo.get(ItemInfo.FORMAT_PATTERN_KEY);
                if (string2 != null) {
                    arrayList = new ArrayList<String>();
                    for (String string3 : legendTargetSpecification4) {
                        DateFormat dateFormat = ChartViewerItemHelper.getDateFormat(string3);
                        Date date = dateFormat.parse(string3);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                        arrayList.add(simpleDateFormat.format(date));
                    }
                } else {
                    LegendTargetSpecification legendTargetSpecification3;
                    legendTargetSpecification3 = ChartViewerItemHelper.getSourceVarSpec(visualization.getSpecification(), string);
                    arrayList = new ArrayList();
                    for (String string4 : legendTargetSpecification4) {
                        arrayList.add(legendTargetSpecification2 instanceof LegendTargetSpecification ? ChartViewerItemHelper.originalValue((VariableSpecification)legendTargetSpecification3, string4) : string4);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private static DateFormat getDateFormat(String string) {
        DateFormat dateFormat = null;
        if (string == null) {
            return dateFormat;
        }
        if (string.indexOf(84) > 0) {
            dateFormat = isoDateTimeFormatter;
        } else if (string.indexOf(45) > 0) {
            dateFormat = isoDateFormatter;
        } else if (string.indexOf(58) > 0) {
            dateFormat = isoTimeFormatter;
        }
        return dateFormat;
    }

    private static ItemInfo getItemInfoById(Visualization visualization, String string, String string2) throws Exception {
        ItemInfo[] itemInfoArray;
        ItemInfo itemInfo = null;
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)visualizationSpecification, "changed"));
        ItemInfo itemInfo2 = ItemInfo.makeItemInfo((String)string);
        InformationProcessor informationProcessor = InformationProcessor.getInfoProcessor((String)itemInfo2.getId(), (Map)itemInfo2.getAll());
        visualization.runProcessor((ResultsProcessor)informationProcessor);
        for (ItemInfo itemInfo3 : itemInfoArray = informationProcessor.getItems()) {
            boolean bl;
            Object object = itemInfo3.get(ItemInfo.PART_KEY);
            boolean bl2 = bl = object == null && string2 == null;
            if (!bl && (string2 == null || object == null || !string2.equals(object)) && (string2 != null || !"main".equals(object))) continue;
            itemInfo = itemInfo3;
            break;
        }
        return itemInfo;
    }

    private static String relabeledValue(VariableSpecification variableSpecification, String string) {
        String string2 = string;
        if (string != null && variableSpecification != null) {
            FormatSpecification formatSpecification;
            Object object;
            FormatSpecification formatSpecification2 = variableSpecification.getDisplayFormatChild();
            if (formatSpecification2 != null) {
                object = formatSpecification2.getRelabeling();
                for (int i = ((RelabelSpecification[])object).length - 1; i >= 0; --i) {
                    formatSpecification = object[i];
                    if (!object[i].getFrom().equals(string)) continue;
                    string2 = formatSpecification.getTo();
                    break;
                }
            }
            object = "";
            String string3 = "";
            formatSpecification = variableSpecification.getDisplayFormatChild();
            if (formatSpecification != null) {
                object = formatSpecification.getPrefix();
                if (object == null) {
                    object = "";
                }
                if ((string3 = formatSpecification.getSuffix()) == null) {
                    string3 = "";
                }
                string2 = (String)object + string2 + string3;
            }
        }
        return string2;
    }

    private static String originalValue(VariableSpecification variableSpecification, String string) {
        FormatSpecification formatSpecification;
        String string2 = string;
        if (string != null && variableSpecification != null && (formatSpecification = variableSpecification.getDisplayFormatChild()) != null) {
            RelabelSpecification[] relabelSpecificationArray = formatSpecification.getRelabeling();
            for (int i = relabelSpecificationArray.length - 1; i >= 0; --i) {
                RelabelSpecification relabelSpecification = relabelSpecificationArray[i];
                if (!relabelSpecificationArray[i].getTo().equals(string)) continue;
                string2 = relabelSpecification.getFrom();
                break;
            }
        }
        return string2;
    }

    public static enum ChartType {
        SimpleBar,
        ClusteredBar,
        StackedBar,
        SimpleLine,
        MultipleLine,
        PieChart,
        SimpleScatter,
        SimpleScatterWithFitLine,
        GroupedScatter,
        GroupedScatterWithFitLine,
        SimpleHistogram,
        SimpleBoxplot,
        ClusteredBoxplot,
        OneDBoxplot,
        SimpleErrorBar,
        ClusteredErrorBar,
        Other;

    }

    public static class RoleInfo {
        String mID;
        ArrayList<String> mValues;
        HashMap<String, String> mIdToLabelMap;
        ArrayList<String> mCategoryOrder;

        public RoleInfo(String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, HashMap<String, String> hashMap) {
            this.mID = string;
            this.mValues = arrayList;
            this.mIdToLabelMap = hashMap;
            this.mCategoryOrder = arrayList2;
        }

        public String getID() {
            return this.mID;
        }

        public ArrayList<String> getValues() {
            return this.mValues;
        }

        public HashMap<String, String> getIdToLabelMap() {
            return this.mIdToLabelMap;
        }

        public void setIdToLabelMap(HashMap<String, String> hashMap) {
            this.mIdToLabelMap = hashMap;
        }

        public ArrayList<String> getCategoryOrder() {
            return this.mCategoryOrder;
        }

        public void setCategoryOrder(ArrayList<String> arrayList) {
            this.mCategoryOrder = arrayList;
        }
    }

    public class FitLineInfo {
    }
}

