/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.charteditor.CECloseListener;
import com.spss.charteditor.IPESCallback;
import com.spss.charteditor.MyEditor;
import com.spss.charteditor.SpssMsgListener;
import com.spss.charteditor.template.ApplyTemplate;
import com.spss.charteditor.util.TrinityUtil;
import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.PESCallbackHandler;
import com.spss.java_client.core.documents.output.IOutputItem;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.core.documents.output.chart.ChartItem;
import com.spss.java_client.core.documents.output.chart.IChartItemUIAgent;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.ITopWindow;
import com.spss.java_client.ui.doc_types.output.ImageCache;
import com.spss.java_client.ui.doc_types.output.ImageGenerator2;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerImage;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerOutputPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.vis.Visualization;
import com.spss.vis.specification.AbstractSpecification;
import com.spss.vis.specification.ContainerFrameSpecification;
import com.spss.vis.specification.GraphSpecification;
import com.spss.vis.specification.Length;
import com.spss.vis.specification.SpecificationChangeEvent;
import com.spss.vis.specification.UnitType;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.interaction.InteractionSpecification;
import com.spss.vis.specification.layout.LocationPartType;
import com.spss.vis.specification.layout.LocationSpecification;
import com.spss.vizimager.VizDataProcessor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.zip.DeflaterOutputStream;
import javax.swing.JComponent;

public class ChartViewerItem
extends ViewerItem
implements IChartItemUIAgent {
    private ChartItem mOutputItem = null;
    private MyEditor mEditor;
    private ViewerImage mImage = new ViewerImage();
    private Dimension mPrefSize = null;
    private Locale mUILocale;

    public ChartViewerItem(IOutputItem iOutputItem) {
        super(iOutputItem);
        if (!(iOutputItem instanceof ChartItem)) {
            throw new IllegalArgumentException();
        }
        this.mOutputItem = (ChartItem)iOutputItem;
        this.setName(this.mOutputItem.getDescription());
        this.setRendered(false);
        this.mUILocale = Locale.getDefault();
    }

    @Override
    public ViewerDocument.ComponentType getComponentType() {
        return ViewerDocument.ComponentType.chart;
    }

    @Override
    public void setRendered(boolean bl) {
        super.setRendered(bl);
        this.setToolTipText(bl ? TIP_TEXT : null);
    }

    @Override
    public boolean startEdit() {
        Preferences preferences;
        Object object;
        Object object2;
        this.mEditor = this.getChartEditor();
        try {
            object2 = this.getTopLevelAncestor();
            object = this.mEditor.getEditorInfo();
            if (object2 instanceof ViewerFrame) {
                object.setShowPES(VersionInfo.allowPES());
            }
            object.setTmpPath(PrefsMgr.getPrefsMgr().getTempPath());
            preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
            String string = preferences.get("aspect_ratio", PrefDefaults.DEF_CHART_ASPECT_RATIO);
            object.setChartAspectRatio(Double.parseDouble(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isInEditMode()) {
            this.mEditor.sendToFront();
            return false;
        }
        if (!this.getCoreItem().isEditable()) {
            object2 = ResUtil.getString("IDS_NOT_EDITABLE_MSG");
            object = this.getTopLevelAncestor();
            if (object instanceof ViewerFrame) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.getTopLevelAncestor(), (String)object2, VersionInfo.getAppVersionString());
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)this.getTopLevelAncestor(), (String)object2, "0");
            }
            return false;
        }
        boolean bl = super.startEdit();
        try {
            this.mEditor.setDataSrcEnabled(this.mOutputItem.getDataLinkState());
            object = VizCache.getCache().getVisualization((ChartItem)this.mCoreItem);
            if (this.mOutputItem.getCachedAnimationSpec() != null) {
                preferences = object.getSpecification();
                preferences.addInteraction((InteractionSpecification)this.mOutputItem.getCachedAnimationSpec());
                this.mOutputItem.setCachedAnimationSpec(null);
            }
            preferences = VizCache.getCache().getDataReader((ChartItem)this.mCoreItem);
            this.mEditor.renderXMLToScreen((Visualization)object, (VizDataProcessor)preferences, this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mEditor.removeCECloseListeners();
        this.mEditor.addCECloseListener(new CECloseListener(){

            public void close() {
                ChartViewerItem.this.endEdit();
            }
        });
        return bl;
    }

    @Override
    public void endEdit() {
        Object object;
        if (this.mEditor == null) {
            return;
        }
        if (!this.isInEditMode()) {
            return;
        }
        boolean bl = false;
        if (this.mEditor.needsRerendering()) {
            object = this.mEditor.extractCompressedXML();
            ChartViewerItem chartViewerItem = this;
            byte[] byArray = chartViewerItem.mEditor.extractCompressedDataStream();
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap((byte[])object));
            this.mOutputItem.setVDPData(ByteBuffer.wrap(byArray));
            this.mOutputItem.setChartSize(this.mEditor.getFrameWidth(), this.mEditor.getFrameHeight());
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            bl = true;
        }
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).handleSelectionChange(this, false);
        ((JComponent)object).scrollRectToVisible(this.getBounds());
        if (bl) {
            ((ViewerOutputPane)object).setDocumentModifiedFlag(bl);
        }
        this.mEditor.removeSpssMsgListeners();
        this.mEditor.close(false);
        this.repaint();
        super.endEdit();
    }

    @Override
    public void renderContents(Graphics2D graphics2D) {
        Object object;
        BufferedImage bufferedImage = this.mImage.get();
        if (bufferedImage == null) {
            ImageCache.getImageCache().remove(this.mImage);
            object = ImageGenerator2.getImageGenerator().generateImage(this);
            bufferedImage = ((ImageGenerator2.ImageContainer)object).get();
            this.mImage = new ViewerImage(this, bufferedImage, ((ImageGenerator2.ImageContainer)object).isComplete(), false);
            this.setPreferredSize(new Dimension(bufferedImage.getWidth() + 3, bufferedImage.getHeight() + 3));
        }
        object = graphics2D.getTransform();
        graphics2D.translate(2, 2);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (rectangle != null) {
            Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
            rectangle = rectangle.intersection(rectangle2);
            int n = Math.min(rectangle.x + rectangle.width, bufferedImage.getWidth() - 1);
            int n2 = Math.min(rectangle.y + rectangle.height, bufferedImage.getHeight() - 1);
            if (n - rectangle.x > 0 && n2 - rectangle.y > 0) {
                graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y, n, n2, rectangle.x, rectangle.y, n, n2, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.setTransform((AffineTransform)object);
        if (this.isInEditMode()) {
            this.renderEditModeHatchPattern(graphics2D, this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
        }
    }

    @Override
    public void renderWithTransparency(Graphics2D graphics2D) {
        graphics2D.drawImage((Image)this.mOutputItem.render(true), 0, 0, null);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mPrefSize == null) {
            BufferedImage bufferedImage = this.mImage.get();
            this.mPrefSize = bufferedImage == null ? ImageGenerator2.getImageGenerator().getDefaultImageSize() : new Dimension(bufferedImage.getWidth() + 2, bufferedImage.getHeight() + 2);
        }
        return this.mPrefSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        this.mPrefSize = dimension != null ? (Dimension)dimension.clone() : null;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private MyEditor getChartEditor() {
        MyEditor myEditor = this.mEditor;
        if (myEditor == null || !Locale.getDefault().equals(this.mUILocale)) {
            myEditor = new MyEditor(true, CommandLine.isClementineCaller());
            myEditor.setBasePrefPath(PrefsMgr.getPrefsMgr().getWorkPrefsPath());
            myEditor.getState().setBaseUIUserPref(PrefsMgr.getPrefsMgr().getUIUserPrefs().absolutePath());
            Container container = this.getTopLevelAncestor();
            if (container instanceof ViewerFrame) {
                MyEditor.setMessageBoxTitle((String)VersionInfo.getAppVersionString());
                MyEditor.setPesCallback((IPESCallback)new PESCallbackHandler());
            }
        }
        this.mUILocale = Locale.getDefault();
        myEditor.addSpssMsgListener((SpssMsgListener)new SpssMgr.ChartMsgHandler());
        return myEditor;
    }

    public MyEditor getChartEditorFromUI() {
        return this.getChartEditor();
    }

    @Override
    public void setSize(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        super.setSize(n, n2);
        if (this.getParent() != null) {
            this.getParent().repaint(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
        }
    }

    public void setHeight(int n) {
        this.mOutputItem.setHeight(n);
        this.repaint();
    }

    public void setWidth(int n) {
        this.mOutputItem.setWidth(n);
        this.repaint();
    }

    public void clearDataLinkState() {
        this.mOutputItem.setDataLinkState(false);
        if (this.isInEditMode()) {
            this.mEditor.setDataSrcEnabled(false);
        }
    }

    @Override
    public void closeEditorWindow() {
        this.mEditor.close(true);
    }

    public boolean isInEditingMode() {
        return this.isInEditMode();
    }

    @Override
    public void refreshContent() {
        super.refreshContent();
        MyEditor myEditor = this.getChartEditor();
        this.saveNewSize(myEditor, this.mOutputItem.getWidth(), this.mOutputItem.getHeight());
        byte[] byArray = myEditor.extractCompressedXML();
        this.mOutputItem.setCompressedXML(ByteBuffer.wrap(byArray));
    }

    @Override
    public void applySizeChange(int n, int n2) {
        Object object;
        this.mOutputItem.setChartSize(n, n2);
        Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
        VisualizationSpecification visualizationSpecification = visualization.getSpecification();
        this.modifyVisSize(visualizationSpecification, n, n2);
        visualizationSpecification.fireSpecificationChangedEvent(new SpecificationChangeEvent((Object)visualizationSpecification, "redraw chart"));
        StringWriter stringWriter = new StringWriter();
        try {
            visualizationSpecification.writeXml((Writer)stringWriter);
            object = stringWriter.toString().getBytes("UTF-8");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            ((OutputStream)deflaterOutputStream).write((byte[])object);
            ((OutputStream)deflaterOutputStream).close();
            object = byteArrayOutputStream.toByteArray();
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap((byte[])object));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
        this.invalidate();
        this.repaint();
        object = (ViewerOutputPane)this.getParent();
        ((ViewerOutputPane)object).setDocumentModifiedFlag(true);
    }

    @Override
    protected void refreshSize() {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage();
    }

    public void applyTemplate(String string) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization(this.mOutputItem);
            VisualizationSpecification visualizationSpecification = visualization.getSpecification();
            ApplyTemplate applyTemplate = new ApplyTemplate();
            String string2 = applyTemplate.apply(TrinityUtil.visSpecToString((VisualizationSpecification)visualizationSpecification, (boolean)false), string);
            VisualizationSpecification visualizationSpecification2 = new VisualizationSpecification((Reader)new StringReader(string2));
            byte[] byArray = MyEditor.extractCompressedXML((VisualizationSpecification)visualizationSpecification2);
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap(byArray));
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            this.invalidate();
            this.repaint();
            ViewerOutputPane viewerOutputPane = (ViewerOutputPane)this.getParent();
            viewerOutputPane.setDocumentModifiedFlag(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void resize(Point point) {
        Point point2 = new Point(point.x, point.y);
        Rectangle rectangle = this.getDragRect(point2);
        if (rectangle != null) {
            this.mOutputItem.setChartSize(rectangle.width, rectangle.height);
            MyEditor myEditor = this.getChartEditor();
            this.saveNewSize(myEditor, rectangle.width, rectangle.height);
            byte[] byArray = myEditor.extractCompressedXML();
            this.mOutputItem.setCompressedXML(ByteBuffer.wrap(byArray));
            ImageCache.getImageCache().remove(this.mImage);
            this.mImage = new ViewerImage();
            this.repaint();
            ViewerDocument viewerDocument = ((ITopWindow)((Object)this.getTopLevelAncestor())).getViewerDocument();
            viewerDocument.setFocusedViewerItem(this);
            viewerDocument.getCoreDocument().setModifiedFlag(true);
            viewerDocument.notifyChangedModifiedFlag();
            ((ViewerOutputPane)this.getParent()).handleSelectionChange(this, false);
            ((ViewerOutputPane)this.getParent()).resetFeedback();
        }
    }

    @Override
    protected void renderingComplete(BufferedImage bufferedImage) {
        ImageCache.getImageCache().remove(this.mImage);
        this.mImage = new ViewerImage(this, bufferedImage, true, true);
        if (bufferedImage != null) {
            ImageCache.getImageCache().add(this.mImage);
            ((ChartItem)this.mCoreItem).setChartSize(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
            Dimension dimension = new Dimension(this.mCoreItem.getWidth() + 4, this.mCoreItem.getHeight() + 4);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
            this.setRendered(true);
            this.revalidate();
            this.repaint();
        }
        this.mEditor = null;
    }

    private void saveNewSize(MyEditor myEditor, int n, int n2) {
        VisualizationSpecification visualizationSpecification = myEditor.getEditorInfo().getVisualizationSpecification();
        if (visualizationSpecification == null) {
            this.setupVisualizationSpec(myEditor);
            visualizationSpecification = myEditor.getEditorInfo().getVisualizationSpecification();
        }
        this.modifyVisSize(visualizationSpecification, n, n2);
        myEditor.setOuterFrameSize(n, n2, false);
    }

    private void modifyVisSize(VisualizationSpecification visualizationSpecification, int n, int n2) {
        GraphSpecification graphSpecification = TrinityUtil.getGraphSpec((AbstractSpecification)visualizationSpecification);
        ContainerFrameSpecification containerFrameSpecification = (ContainerFrameSpecification)graphSpecification.getParent();
        if (containerFrameSpecification != null) {
            LocationSpecification locationSpecification;
            LocationSpecification locationSpecification2 = containerFrameSpecification.getLocations();
            Length length = null;
            Length length2 = null;
            for (LocationSpecification locationSpecification3 : locationSpecification2) {
                LocationPartType locationPartType = locationSpecification3.getPart();
                if (LocationPartType.RIGHT == locationPartType) {
                    length = locationSpecification3.getFixedValue();
                    locationSpecification3.setFixedValue(new Length((float)n, UnitType.PX));
                    continue;
                }
                if (LocationPartType.BOTTOM != locationPartType) continue;
                length2 = locationSpecification3.getFixedValue();
                locationSpecification3.setFixedValue(new Length((float)n2, UnitType.PX));
            }
            if (length == null) {
                locationSpecification = new LocationSpecification(LocationPartType.RIGHT);
                locationSpecification.setFixedValue(new Length((float)n, UnitType.PX));
                visualizationSpecification.addLocation(locationSpecification);
            }
            if (length2 == null) {
                locationSpecification = new LocationSpecification(LocationPartType.BOTTOM);
                locationSpecification.setFixedValue(new Length((float)n2, UnitType.PX));
                visualizationSpecification.addLocation(locationSpecification);
            }
        }
    }

    protected void setupVisualizationSpec(MyEditor myEditor) {
        try {
            Visualization visualization = VizCache.getCache().getVisualization((ChartItem)this.getCoreItem());
            myEditor.getEditorInfo().setVisualization(visualization);
            this.convertWidthHeight2RightBottom(visualization.getSpecification());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void convertWidthHeight2RightBottom(VisualizationSpecification visualizationSpecification) {
        LocationSpecification locationSpecification;
        LocationSpecification locationSpecification2 = visualizationSpecification.getLocation(LocationPartType.WIDTH);
        if (locationSpecification2 != null) {
            locationSpecification2.setPart(LocationPartType.RIGHT);
        }
        if ((locationSpecification = visualizationSpecification.getLocation(LocationPartType.HEIGHT)) != null) {
            locationSpecification.setPart(LocationPartType.BOTTOM);
        }
    }
}

