/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.output;

import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerItemConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Vector;

public class BaseViewerLayout
implements LayoutManager2 {
    private static final int LEADING_MARGIN = 20;
    protected HashMap<Integer, ViewerItemConstraints> mCompTable = new HashMap(1024);
    private ViewerItemConstraints mDefaultConstraints = new ViewerItemConstraints();
    private boolean mMultiColumn = false;
    private FasterVector<Component> mRowData = null;
    private Dimension mLayoutSize = null;
    private boolean mNewLayout = true;
    protected Vector<ItemBag> mComponentList = new Vector(1024);

    public BaseViewerLayout() {
        this.mLayoutSize = new Dimension();
    }

    public boolean isMultiColumn() {
        return this.mMultiColumn;
    }

    public void setMultiColumn(boolean bl) {
        this.mMultiColumn = bl;
    }

    public void invalidateItem(Component component) {
        int n;
        int n2;
        boolean bl;
        if (!this.mNewLayout) {
            return;
        }
        int n3 = this.getComponentIndex(component);
        if (n3 < 0) {
            return;
        }
        ItemBag itemBag = this.mComponentList.get(n3);
        ViewerItemConstraints viewerItemConstraints = itemBag.getConstraints();
        Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
        Rectangle rectangle = viewerItemConstraints.getPosition();
        boolean bl2 = bl = itemBag.getVisible() != component.isVisible();
        if (bl) {
            n2 = viewerItemConstraints.getPosition().height;
            if (!component.isVisible()) {
                n2 = -n2;
            }
            itemBag.setVisible(component.isVisible());
            if (component.isVisible()) {
                n = insets.left + insets.right;
                this.mLayoutSize.width = Math.max(this.mLayoutSize.width, (int)rectangle.getMaxX() - n);
            } else {
                this.measureLayoutWidth();
            }
        } else {
            Dimension dimension = component.getPreferredSize();
            if (dimension == null || rectangle == null || insets == null) {
                return;
            }
            if (rectangle.width - (insets.left + insets.right) == dimension.width && rectangle.height - (insets.top + insets.bottom) == dimension.height) {
                return;
            }
            n2 = dimension.height - (rectangle.height - (insets.top + insets.bottom));
            rectangle.width = dimension.width + insets.left + insets.right;
            rectangle.height = dimension.height + insets.top + insets.bottom;
            viewerItemConstraints.setPosition(rectangle);
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x += insets.left;
            rectangle2.y += insets.top;
            rectangle2.width -= insets.left + insets.right;
            rectangle2.height -= insets.top + insets.bottom;
            component.setBounds(rectangle2);
            n = insets.left + insets.right;
            this.mLayoutSize.width = Math.max(this.mLayoutSize.width, (int)rectangle.getMaxX() - n);
        }
        if (component.isVisible() || bl) {
            for (int i = n3 + 1; i < this.mComponentList.size(); ++i) {
                itemBag = this.mComponentList.get(i);
                rectangle = itemBag.getConstraints().getPosition();
                rectangle.y += n2;
                itemBag.getComponent().setBounds(new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom)));
            }
            this.mLayoutSize.height += n2;
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof ViewerItemConstraints) {
            if (this.mNewLayout) {
                this.addComponent(component, (ViewerItemConstraints)object);
            } else {
                this.setConstraints(component, (ViewerItemConstraints)object);
            }
        } else if (object != null) {
            throw new IllegalArgumentException("Cannot add to layout: constraints must be a ViewerItemConstraint");
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
        if (!this.mNewLayout) {
            this.invalidate();
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        try {
            if (this.mNewLayout) {
                this.removeComponent(component);
            } else {
                this.removeConstraints(component);
                this.invalidate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (!this.mNewLayout && !this.isValid()) {
            this.mRowData = new FasterVector(this.mCompTable.size());
            this.determineGridPositions(container, this.mRowData);
            this.determineGridRects(this.mRowData, false);
            this.positionComponents(container, this.mRowData, false, false);
            this.mLayoutSize = this.determineExtents(this.mRowData);
        }
        return this.mLayoutSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (!this.mNewLayout) {
            if (!this.isValid()) {
                this.mRowData = new FasterVector(this.mCompTable.size());
                this.determineGridPositions(container, this.mRowData);
                this.determineGridRects(this.mRowData, true);
                this.positionComponents(container, this.mRowData, true, false);
            }
            return this.determineExtents(this.mRowData);
        }
        return this.mLayoutSize;
    }

    @Override
    public void layoutContainer(Container container) {
        if (!this.mNewLayout) {
            if (!this.isValid()) {
                this.mRowData = new FasterVector(this.mCompTable.size());
                this.determineGridPositions(container, this.mRowData);
                this.determineGridRects(this.mRowData, false);
            }
            this.positionComponents(container, this.mRowData, false, true);
        }
    }

    public void setConstraints(Component component, ViewerItemConstraints viewerItemConstraints) {
        if (!this.isMultiColumn()) {
            this.repositionConstraints(viewerItemConstraints);
        }
        this.mCompTable.put(this.getComponentId(component), (ViewerItemConstraints)viewerItemConstraints.clone());
    }

    public ViewerItemConstraints getConstraints(Component component) {
        ViewerItemConstraints viewerItemConstraints = this.mCompTable.get(this.getComponentId(component));
        if (viewerItemConstraints == null) {
            this.setConstraints(component, this.mDefaultConstraints);
            viewerItemConstraints = this.mCompTable.get(this.getComponentId(component));
        }
        return (ViewerItemConstraints)viewerItemConstraints.clone();
    }

    protected ViewerItemConstraints lookupConstraints(Component component) {
        ViewerItemConstraints viewerItemConstraints = this.mCompTable.get(this.getComponentId(component));
        if (viewerItemConstraints == null) {
            this.setConstraints(component, this.mDefaultConstraints);
            viewerItemConstraints = this.mDefaultConstraints;
        }
        return viewerItemConstraints;
    }

    protected void removeConstraints(Component component) {
        ViewerItemConstraints viewerItemConstraints = this.mCompTable.get(this.getComponentId(component));
        for (ViewerItemConstraints viewerItemConstraints2 : this.mCompTable.values()) {
            if (viewerItemConstraints2.getYPos() <= viewerItemConstraints.getYPos()) continue;
            viewerItemConstraints2.setYPos(viewerItemConstraints2.getYPos() - 1);
        }
        this.mCompTable.remove(this.getComponentId(component));
    }

    protected Insets getAdjustedInsets(ViewerItemConstraints viewerItemConstraints, Component component) {
        Insets insets = (Insets)viewerItemConstraints.getInsets().clone();
        if (viewerItemConstraints.getXPos() == 0) {
            if (component.getComponentOrientation().isLeftToRight()) {
                insets.left += 20;
            } else {
                insets.right += 20;
            }
        }
        return insets;
    }

    protected int getComponentId(Component component) {
        return ((ViewerItem)component).getId();
    }

    protected boolean isValid() {
        return this.mLayoutSize != null && this.mRowData != null;
    }

    protected void invalidate() {
        this.mLayoutSize = null;
        this.mRowData = null;
    }

    protected void repositionConstraints(ViewerItemConstraints viewerItemConstraints) {
        int n = viewerItemConstraints.getYPos();
        int n2 = this.mNewLayout ? 0 : 1;
        for (ViewerItemConstraints viewerItemConstraints2 : this.mCompTable.values()) {
            if (viewerItemConstraints2.getYPos() < n) continue;
            viewerItemConstraints2.setYPos(viewerItemConstraints2.getYPos() + n2);
        }
    }

    private void determineGridPositions(Container container, FasterVector<Component> fasterVector) {
        int n;
        ViewerItemConstraints viewerItemConstraints;
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (!component.isVisible()) continue;
            viewerItemConstraints = this.lookupConstraints(component);
            if (viewerItemConstraints.getYPos() >= fasterVector.size()) {
                component2 = component;
                while (fasterVector.size() < viewerItemConstraints.getYPos()) {
                    fasterVector.add(null);
                }
                if (fasterVector.size() == viewerItemConstraints.getYPos() || fasterVector.get(viewerItemConstraints.getYPos()) != null) {
                    fasterVector.add(viewerItemConstraints.getYPos(), component2);
                }
            }
            if ((component2 = (Component)fasterVector.get(viewerItemConstraints.getYPos())) != null) continue;
            component2 = component;
            fasterVector.set(viewerItemConstraints.getYPos(), component2);
        }
        for (n = fasterVector.size() - 1; n >= 0; --n) {
            if (fasterVector.get(n) != null) continue;
            fasterVector.remove(n);
        }
        n = 0;
        for (Component component : fasterVector) {
            viewerItemConstraints = this.lookupConstraints(component);
            viewerItemConstraints.setAdjustedYPos(n++);
        }
    }

    private void determineGridRects(FasterVector<Component> fasterVector, boolean bl) {
        int n = 0;
        Rectangle rectangle = new Rectangle();
        for (Component component : fasterVector) {
            if (!component.isVisible()) continue;
            ViewerItemConstraints viewerItemConstraints = this.lookupConstraints(component);
            Dimension dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
            rectangle.x = 0;
            rectangle.y = n;
            rectangle.width = dimension.width;
            rectangle.height = dimension.height;
            int n2 = rectangle.height + insets.top + insets.bottom;
            viewerItemConstraints.setPosition(rectangle);
            n += n2 + 1;
        }
    }

    private void positionComponents(Container container, FasterVector<Component> fasterVector, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        for (Component component : fasterVector) {
            Dimension dimension;
            if (!component.isVisible()) continue;
            ViewerItemConstraints viewerItemConstraints = this.lookupConstraints(component);
            Rectangle rectangle = viewerItemConstraints.getPosition();
            Dimension dimension2 = dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
            if (dimension.width < rectangle.width) {
                rectangle.x += (int)((float)(rectangle.width - dimension.width) * this.getLayoutAlignmentX(container));
            }
            if (dimension.height < rectangle.height) {
                rectangle.y += (int)((float)(rectangle.height - dimension.height) * this.getLayoutAlignmentY(container));
            }
            if (bl2) {
                Rectangle rectangle2 = (Rectangle)rectangle.clone();
                Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
                rectangle2.x += insets.left;
                rectangle2.y += insets.top;
                component.setBounds(rectangle2);
                n = (int)((double)n < rectangle2.getMaxX() ? rectangle2.getMaxX() : (double)n);
                n2 = (int)((double)n2 < rectangle2.getMaxY() ? rectangle2.getMaxY() : (double)n2);
                continue;
            }
            viewerItemConstraints.setPosition(rectangle);
        }
        if (bl2) {
            Dimension dimension = container.getSize();
            n = dimension.width;
            n2 = n2 > dimension.height ? n2 : dimension.height;
            container.setSize(n, n2);
        }
    }

    private Dimension determineExtents(FasterVector<Component> fasterVector) {
        int n = 0;
        int n2 = 0;
        for (Component component : fasterVector) {
            ViewerItemConstraints viewerItemConstraints = this.lookupConstraints(component);
            Rectangle rectangle = viewerItemConstraints.getPosition();
            Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
            n = (int)((double)n < rectangle.getMaxX() + (double)insets.right ? rectangle.getMaxX() + (double)insets.right : (double)n);
            n2 = (int)((double)n2 < rectangle.getMaxY() + (double)insets.bottom ? rectangle.getMaxY() + (double)insets.bottom : (double)n2);
        }
        return new Dimension(n, n2);
    }

    private void addComponent(Component component, ViewerItemConstraints viewerItemConstraints) {
        boolean bl = component.isVisible();
        Dimension dimension = component.getPreferredSize();
        Insets insets = this.getAdjustedInsets(viewerItemConstraints, component);
        int n = dimension.height + insets.top + insets.bottom;
        ItemBag itemBag = new ItemBag(component, viewerItemConstraints);
        int n2 = viewerItemConstraints.getYPos();
        if (this.mComponentList.size() > n2) {
            for (ItemBag itemBag2 : this.mComponentList) {
                ViewerItemConstraints viewerItemConstraints2 = itemBag2.getConstraints();
                if (viewerItemConstraints2.getYPos() < n2) continue;
                Rectangle rectangle = viewerItemConstraints2.getPosition();
                Insets insets2 = this.getAdjustedInsets(viewerItemConstraints2, itemBag2.getComponent());
                if (viewerItemConstraints2.getYPos() == n2) {
                    viewerItemConstraints.setPosition(new Rectangle(0, rectangle.y, dimension.width + insets.left + insets.right, n));
                    component.setBounds(insets.left, rectangle.y + insets.top, dimension.width, dimension.height);
                }
                viewerItemConstraints2.setYPos(viewerItemConstraints2.getYPos() + 1);
                if (!bl) continue;
                rectangle.y += n;
                viewerItemConstraints2.setPosition(rectangle);
                itemBag2.getComponent().setBounds(rectangle.x + insets2.left, rectangle.y + insets2.top, rectangle.width - (insets2.left + insets2.right), rectangle.height - (insets2.top + insets2.bottom));
            }
            this.mComponentList.insertElementAt(itemBag, viewerItemConstraints.getYPos());
        } else {
            Rectangle rectangle = new Rectangle(0, this.mLayoutSize.height, dimension.width + insets.left + insets.right, n);
            viewerItemConstraints.setPosition(rectangle);
            component.setBounds(insets.left, rectangle.y + insets.top, dimension.width, dimension.height);
            this.mComponentList.add(itemBag);
        }
        if (bl) {
            int n3 = insets.left + insets.right;
            this.mLayoutSize.width = Math.max((int)viewerItemConstraints.getPosition().getMaxX() - n3, this.mLayoutSize.width);
            this.mLayoutSize.height += n;
        }
    }

    private void removeComponent(Component component) {
        int n = this.getComponentIndex(component);
        if (n < 0) {
            return;
        }
        ItemBag itemBag = this.mComponentList.remove(n);
        ViewerItemConstraints viewerItemConstraints = itemBag.getConstraints();
        Insets insets = null;
        int n2 = 0;
        for (int i = 0; i < this.mComponentList.size(); ++i) {
            itemBag = this.mComponentList.get(i);
            ViewerItemConstraints viewerItemConstraints2 = itemBag.getConstraints();
            if (i >= n) {
                viewerItemConstraints2.setYPos(itemBag.getConstraints().getYPos() - 1);
                if (component.isVisible()) {
                    Rectangle rectangle = viewerItemConstraints2.getPosition();
                    rectangle.y -= viewerItemConstraints.getPosition().height;
                    viewerItemConstraints2.setPosition(rectangle);
                    insets = this.getAdjustedInsets(viewerItemConstraints2, itemBag.getComponent());
                    itemBag.getComponent().setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
                }
            }
            if (itemBag.getComponent().isVisible()) {
                if (insets == null) {
                    insets = this.getAdjustedInsets(viewerItemConstraints2, itemBag.getComponent());
                }
                int n3 = insets.left + insets.right;
                n2 = Math.max((int)(viewerItemConstraints2.getPosition().getMaxX() - (double)n3), n2);
            }
            insets = null;
        }
        if (component.isVisible()) {
            this.mLayoutSize.width = n2;
            this.mLayoutSize.height -= viewerItemConstraints.getPosition().height;
        }
    }

    private int getComponentIndex(Component component) {
        for (int i = 0; i < this.mComponentList.size(); ++i) {
            if (this.mComponentList.get(i).getComponent() != component) continue;
            return i;
        }
        return -1;
    }

    private void measureLayoutWidth() {
        int n = 0;
        for (ItemBag itemBag : this.mComponentList) {
            ViewerItemConstraints viewerItemConstraints = itemBag.getConstraints();
            if (!itemBag.getComponent().isVisible()) continue;
            Insets insets = this.getAdjustedInsets(viewerItemConstraints, itemBag.getComponent());
            int n2 = insets.left + insets.right;
            n = Math.max((int)(viewerItemConstraints.getPosition().getMaxX() - (double)n2), n);
        }
        this.mLayoutSize.width = n;
    }

    class ItemBag {
        private Component mComponent;
        private ViewerItemConstraints mConstraints;
        private boolean mVisible;

        public ItemBag(Component component, ViewerItemConstraints viewerItemConstraints) {
            this.mComponent = component;
            this.mConstraints = viewerItemConstraints;
            this.mVisible = this.mComponent.isVisible();
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public ViewerItemConstraints getConstraints() {
            return this.mConstraints;
        }

        public boolean getVisible() {
            return this.mVisible;
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }
    }

    class FasterVector<E>
    extends Vector<E> {
        public FasterVector() {
        }

        public FasterVector(int n) {
            super(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.indexOf(object, 0);
        }

        @Override
        public int indexOf(Object object, int n) {
            if (object == null) {
                for (int i = n; i < this.elementCount; ++i) {
                    if (this.elementData[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = n; i < this.elementCount; ++i) {
                    if (object != this.elementData[i]) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

