/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.doc_util;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.TCM.TCMAlertDlg;
import com.spss.java_client.ui.dialogs.TCM.TSEAlertDlg;
import com.spss.java_client.ui.dialogs.TCM.res.TCMResBundle;
import com.spss.java_client.ui.dialogs.base.analyze.res.AnalyzeResBundle;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.ChartBuilderAlertDlg;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseGatingDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DefineVariablesAlertDlg;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.MeasureLevelAlertDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.dialogs.complex_samples.ComplexSamplesPlan;
import com.spss.java_client.ui.dialogs.ctables.CTablesAlertDlg;
import com.spss.java_client.ui.dialogs.ctables.res.CTablesResBundle;
import com.spss.java_client.ui.dialogs.trees.TreeAlertDlg;
import com.spss.java_client.ui.dialogs.trees.res.TreeResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.ComplexSamplesAction;
import com.spss.java_client.ui.doc_types.actions.GatingDialogAction;
import com.spss.java_client.ui.doc_types.actions.ProcedureAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.WizardAction;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Cursor;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JFrame;

public class ProcedureDialogLoader {
    private static final String[] EXCEPTION_DIALOGS = new String[]{"data_define_var_property", "analyze_mixed_linear", "analyze_gen_linear_rep_measures", "transform_visual_binning"};
    private static JFrame exFrame = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(ProcedureAction procedureAction, JFrame jFrame) {
        exFrame = jFrame;
        try {
            if (!DocUtil.checkForData(procedureAction.getActionId())) {
                return;
            }
            if (!ProcedureDialogLoader.checkActionIdAndContinue(procedureAction.getActionId())) {
                return;
            }
            String string = procedureAction.getDlgLaunchPath();
            if (string != null && string.length() > 0) {
                if (jFrame != null) {
                    jFrame.setCursor(Cursor.getPredefinedCursor(3));
                }
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = ProcedureDialogLoader.getConstructor(clazz);
                if (procedureAction instanceof WizardAction) {
                    if (CommandLine.isClementineCaller()) {
                        ProcedureDialogLoader.dialogLaunching(procedureAction, jFrame);
                    }
                    BaseWizardDialog baseWizardDialog = (BaseWizardDialog)((Object)constructor.newInstance(jFrame));
                    baseWizardDialog.setVisible(true);
                } else if (procedureAction instanceof ComplexSamplesAction) {
                    ComplexSamplesPlan complexSamplesPlan = (ComplexSamplesPlan)constructor.newInstance(jFrame);
                    complexSamplesPlan.setVisible(true);
                } else if (procedureAction instanceof GatingDialogAction) {
                    BaseGatingDialog baseGatingDialog = (BaseGatingDialog)((Object)constructor.newInstance(jFrame));
                    baseGatingDialog.setVisible(true);
                } else if (ProcedureDialogLoader.dialogLaunching(procedureAction, jFrame)) {
                    BaseProcedureDialog baseProcedureDialog = (BaseProcedureDialog)((Object)constructor.newInstance(jFrame));
                    ProcedureDlgMgr.getMgr().addProcedureDialog(baseProcedureDialog.getIActionKey(), baseProcedureDialog);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (jFrame != null) {
                jFrame.setCursor(null);
            }
        }
    }

    private static boolean checkActionIdAndContinue(String string) {
        boolean bl = true;
        if (string.equals("analyze_regression_partial_least_squares")) {
            bl = ProcedureDialogLoader.checkForCommandExtensionFile("plscommand.xml", AnalyzeResBundle.getBundle((String)AnalyzeResBundle.getDefaultResourceBundleName()).getString("IDS_PARTIAL_LEAST_SQUARES_TITLE"), AnalyzeResBundle.getBundle((String)AnalyzeResBundle.getDefaultResourceBundleName()).getString("ERR_PARTIAL_LEAST_SQUARES_PLSCOMMAND_MISSING_ALERT"));
        }
        return bl;
    }

    public static boolean checkForCommandExtensionFile(String string, String string2, String string3) {
        boolean bl = false;
        Vector vector = FileLocationsUtil.getExtensionsPathes();
        for (String string4 : vector) {
            if (!new File(string4 + File.separator + string).exists()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ComponentState.trace1((String)("Unable to locate: " + vector + File.separator + string), (int)15);
            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame();
            if (CommandLine.isClementineCaller() && spssFrame == null) {
                SpssAlertOptionPane.showErrorMessageDialog(exFrame, string3, string2);
            } else {
                SpssAlertOptionPane.showErrorMessageDialog(spssFrame, string3, string2);
            }
        }
        return bl;
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(JFrame.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                constructor = clazz.getConstructor(SpssFrame.class);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException2.printStackTrace();
            }
        }
        return constructor;
    }

    private ProcedureDialogLoader() {
    }

    public static boolean dialogLaunching(SpssAction spssAction, JFrame jFrame) {
        Object object;
        if (spssAction.getProcDialogListener() != null && !ProcedureDialogLoader.filterThisDialog(spssAction.getActionId())) {
            object = spssAction.getProcDialogListener().preDialog(spssAction.getActionId());
            if (object == null) {
                return false;
            }
            object.setUserObject(spssAction.getProcDialogListener());
        }
        if (spssAction instanceof ProcedureAction && spssAction.careDVP()) {
            object = null;
            if (!((ProcedureAction)spssAction).skipDVPAlert()) {
                if (spssAction.getActionId().equals("graphs_chart_builder")) {
                    ResourceBundle resourceBundle = ResUtil.getBundle(GraphsResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                    object = new ChartBuilderAlertDlg(jFrame, resourceBundle);
                } else if (spssAction.getActionId().equals("analyze_classify_tree")) {
                    ResourceBundle resourceBundle = ResUtil.getBundle(TreeResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                    object = new TreeAlertDlg(jFrame, resourceBundle);
                } else if (spssAction.getActionId().equals("analyze_tables_cust_tables")) {
                    ResourceBundle resourceBundle = ResUtil.getBundle(CTablesResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                    object = new CTablesAlertDlg(jFrame, resourceBundle);
                } else if (spssAction.getActionId().equals("analyze_temporal_causal_modeling_model") || spssAction.getActionId().equals("analyze_time_series_exploration")) {
                    Object object2;
                    LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
                    ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
                    int n = iSpssDataSrc.columnCount();
                    Vector<String> vector = new Vector<String>();
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        object2 = iSpssDataSrc.getVariable(i);
                        if (object2.getFormat().getFormatType().isDateOrTimeFormat()) {
                            vector.add(object2.getName());
                        }
                        if (object2.getMeasurementLevel() != MeasurementLevel.nominal) continue;
                        ++n2;
                    }
                    if (n2 > 0) {
                        ResourceBundle resourceBundle = ResUtil.getBundle(TCMResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                        if (spssAction.getActionId().equals("analyze_temporal_causal_modeling_model")) {
                            object2 = new TCMAlertDlg(jFrame, resourceBundle, vector);
                            object2.setVisible(true);
                        } else {
                            object2 = new TSEAlertDlg(jFrame, resourceBundle, vector);
                            object2.setVisible(true);
                        }
                    }
                    return true;
                }
            }
            return ProcedureDialogLoader.handleTwoLevelAlerts((DefineVariablesAlertDlg)((Object)object), jFrame, spssAction);
        }
        return !spssAction.careMeasurementLevel() || ProcedureDialogLoader.handleMeasureLevelAlert(jFrame, spssAction);
    }

    public static void dialogExiting(String string, LocallyUniqueId locallyUniqueId, String string2, boolean bl) {
        ProcedureDlgMgr procedureDlgMgr;
        DialogDataModel dialogDataModel;
        ProcDialogListener procDialogListener;
        if (!ProcedureDialogLoader.filterThisDialog(string) && (procDialogListener = (ProcDialogListener)(dialogDataModel = (procedureDlgMgr = ProcedureDlgMgr.getMgr()).getDialogDDM(locallyUniqueId, string)).getUserObject()) != null) {
            procDialogListener.postDialog(string, locallyUniqueId, string2, bl);
        }
    }

    private static boolean filterThisDialog(String string) {
        for (String string2 : EXCEPTION_DIALOGS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleTwoLevelAlerts(DefineVariablesAlertDlg defineVariablesAlertDlg, JFrame jFrame, SpssAction spssAction) {
        boolean bl = false;
        if (defineVariablesAlertDlg != null) {
            defineVariablesAlertDlg.setVisible(true);
        }
        if (defineVariablesAlertDlg == null || defineVariablesAlertDlg.isOKPressed()) {
            bl = ProcedureDialogLoader.handleMeasureLevelAlert(jFrame, spssAction);
        }
        return bl;
    }

    public static boolean handleMeasureLevelAlert(JFrame jFrame, SpssAction spssAction) {
        boolean bl = true;
        if (DialogUtil.needMeasureLevelAlertDlg()) {
            Object object;
            LocallyUniqueId locallyUniqueId = ProcedureDlgMgr.getMgr().getActiveDatasetId();
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
            if (iSpssDataSrc != null && iSpssDataSrc.isTempTransformation()) {
                ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                SpssAlertOptionPane.showInfoAlertWithHelp(jFrame, resourceBundle, resourceBundle.getString("IDS_TEMP_TRANSFORM_INFO"), resourceBundle.getString("IDS_TEMP_TRANSFORM_TITLE"), "idh_temporary_trans_alert");
                return false;
            }
            if (spssAction != null && (object = spssAction.getProcDialogListener()) != null) {
                object.dialogError(ProcDialogListener.DialogErrorCode.ML_ERROR);
                return false;
            }
            object = new MeasureLevelAlertDlg(jFrame);
            object.setVisible(true);
            bl = ((MeasureLevelAlertDlg)((Object)object)).isScanDataButtonPressed() && !((MeasureLevelAlertDlg)((Object)object)).isProgressAbort();
        }
        return bl;
    }

    public static interface ProcDialogListener {
        public DialogDataModel preDialog(String var1);

        public void postDialog(String var1, LocallyUniqueId var2, String var3, boolean var4);

        public void dialogError(DialogErrorCode var1);

        public static enum DialogErrorCode {
            ML_ERROR;

        }
    }
}

