/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.doc_util;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LicenseOption;
import com.spss.java_client.core.license.LicenseManager;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controlbar.ToolbarsMenuSelectionListener;
import com.spss.java_client.ui.doc_types.actions.DummyAction;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.actions.UserMenuAction;
import com.spss.java_client.ui.doc_types.doc_util.MenuCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemCache;
import com.spss.java_client.ui.doc_types.doc_util.MenuItemPosComparator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class FrameMenuBuildUtil {
    private FrameMenuBuildUtil() {
    }

    public static void loadMenuPreferencesToCache(MenuItemCache menuItemCache, Preferences preferences, String string) throws BackingStoreException {
        int n = string.indexOf(59);
        if (n >= 0) {
            MenuItemCache menuItemCache2 = FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, string.substring(n + 1), ItemType.MENU);
            if (menuItemCache2 == null) {
                return;
            }
            Preferences preferences2 = preferences.node(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(preferences2.childrenNames()));
            arrayList.addAll(Arrays.asList(preferences2.keys()));
            Collections.sort(arrayList, MenuItemPosComparator.ASCENDING);
            for (String string2 : arrayList) {
                FrameMenuBuildUtil.loadMenuPreferencesToCache(menuItemCache2, preferences2, string2);
            }
        } else {
            String string3 = preferences.get(string, "");
            if ("separator".equals(string3)) {
                FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, string3, ItemType.SEPARATOR);
            } else {
                FrameMenuBuildUtil.loadAPrefToCache(menuItemCache, string3, ItemType.MENUITEM);
            }
        }
    }

    public static void saveSubMenuPreferences(MenuItemCache menuItemCache, Preferences preferences, int n) {
        if (menuItemCache instanceof MenuCache) {
            Preferences preferences2 = FrameMenuBuildUtil.saveAMenuPref(menuItemCache, preferences, n, ItemType.MENU);
            MenuCache menuCache = (MenuCache)menuItemCache;
            int n2 = menuCache.getItemCount();
            for (int i = 0; i < n2; ++i) {
                FrameMenuBuildUtil.saveSubMenuPreferences(menuCache.getItem(i), preferences2, i);
            }
        } else {
            FrameMenuBuildUtil.saveAMenuPref(menuItemCache, preferences, n, ItemType.MENUITEM);
        }
    }

    public static void loadMenusFromCache(JMenuBar jMenuBar, JMenuItem jMenuItem, MenuItemCache menuItemCache, boolean bl) {
        if (menuItemCache instanceof MenuCache) {
            JMenuItem jMenuItem2 = jMenuItem;
            if (bl) {
                jMenuItem2 = FrameMenuBuildUtil.loadAMenuFromCache(jMenuBar, jMenuItem, menuItemCache.getItemId(), ItemType.MENU);
            }
            int n = menuItemCache.getItemCount();
            for (int i = 0; i < n; ++i) {
                FrameMenuBuildUtil.loadMenusFromCache(jMenuBar, jMenuItem2, menuItemCache.getItem(i), true);
            }
            if (jMenuItem2 instanceof JMenu && jMenuItem instanceof JMenu && jMenuItem2 != jMenuItem && ((JMenu)jMenuItem2).getItemCount() == 0 && !FrameMenuBuildUtil.isMenuInitiallyEmpty(menuItemCache.getItemId())) {
                ((JMenu)jMenuItem).remove(jMenuItem2);
            }
        } else {
            FrameMenuBuildUtil.loadAMenuFromCache(jMenuBar, jMenuItem, menuItemCache.getItemId(), ItemType.MENUITEM);
        }
    }

    public static MenuItemCache loadAPrefToCache(MenuItemCache menuItemCache, String string, ItemType itemType) {
        MenuCache menuCache = null;
        if (menuItemCache instanceof MenuCache) {
            MenuCache menuCache2 = (MenuCache)menuItemCache;
            if (itemType == ItemType.MENU) {
                menuCache = new MenuCache(string);
                menuCache2.add(menuCache);
            } else if (itemType == ItemType.MENUITEM) {
                menuCache2.add(new MenuItemCache(string));
            } else if (itemType == ItemType.SEPARATOR) {
                menuCache2.add(new MenuItemCache(string));
            }
        }
        return menuCache;
    }

    public static boolean isValidLicense(String string) {
        boolean bl = false;
        SpssAction spssAction = ActionCatalog.getActionCatalog().getSpssAction(string);
        if (spssAction != null) {
            if (LicenseManager.Status.VALID == LicenseManager.getLicenseManager().getStatus(spssAction.getLicenseOption())) {
                bl = true;
            }
            if (string.equals("file_exit") && !bl) {
                bl = true;
            }
        }
        return bl;
    }

    protected static Preferences saveAMenuPref(MenuItemCache menuItemCache, Preferences preferences, int n, ItemType itemType) {
        Preferences preferences2 = null;
        String string = menuItemCache.getItemId();
        if (itemType == ItemType.MENUITEM) {
            preferences.put(String.valueOf(n), string);
        } else if (itemType == ItemType.MENU) {
            preferences2 = preferences.node(n + ";" + string);
        }
        return preferences2;
    }

    protected static JMenuItem loadAMenuFromCache(JMenuBar jMenuBar, JMenuItem jMenuItem, String string, ItemType itemType) {
        JMenu jMenu = null;
        if (string == null) {
            return jMenu;
        }
        SpssAction spssAction = null;
        if (jMenuItem == null) {
            if (string.contains(";")) {
                jMenu = new JMenu(new UserMenuAction(string));
            } else if (itemType == ItemType.MENU && ((spssAction = ActionCatalog.getActionCatalog().getSpssAction(string)) == null || spssAction.showMenu())) {
                jMenu = new JMenu(new DummyAction(string));
            }
            if (jMenu != null && spssAction == null) {
                try {
                    jMenuBar.add((Component)jMenu);
                }
                catch (NullPointerException nullPointerException) {
                    ComponentState.trace1((String)("Error adding main menu: " + string), (int)15);
                }
            }
        } else if (jMenuItem instanceof JMenu) {
            JMenu jMenu2 = (JMenu)jMenuItem;
            if (itemType == ItemType.MENU) {
                if (string.contains(";")) {
                    jMenu = new JMenu(new UserMenuAction(string));
                } else {
                    spssAction = ActionCatalog.getActionCatalog().getSpssAction(string);
                    if (spssAction == null || FrameMenuBuildUtil.isValidLicense(string) && spssAction.showMenu()) {
                        jMenu = new JMenu(new DummyAction(string));
                        if (string.equals("view_toolbar")) {
                            jMenu.addMenuListener(new ToolbarsMenuSelectionListener());
                        }
                    }
                }
                if (jMenu != null) {
                    try {
                        LicenseManager.Status status;
                        String string2;
                        if (jMenu2.getAction() instanceof DummyAction && (string2 = ((DummyAction)jMenu2.getAction()).getActionId()).equals("Analyze") && (status = LicenseManager.getLicenseManager().getStatus(LicenseOption.ADVANCED_STATS)) != LicenseManager.Status.VALID) {
                            jMenu.setText(jMenu.getText() + "  ");
                        }
                        jMenu2.add(jMenu);
                    }
                    catch (NullPointerException nullPointerException) {
                        ComponentState.trace1((String)("Error adding submenu: " + string), (int)15);
                    }
                }
            } else if (itemType == ItemType.MENUITEM) {
                if (string.equals("separator")) {
                    Component component;
                    boolean bl = false;
                    int n = jMenu2.getMenuComponentCount();
                    if (n > 0 && !((component = jMenu2.getMenuComponent(n - 1)) instanceof JMenu) && !(component instanceof JMenuItem)) {
                        bl = true;
                    }
                    if (!bl && n > 0) {
                        jMenu2.addSeparator();
                    }
                } else if (FrameMenuBuildUtil.isValidLicense(string)) {
                    spssAction = ActionCatalog.getActionCatalog().getSpssAction(string);
                    if (spssAction != null && spssAction.showMenu()) {
                        try {
                            jMenu2.add(spssAction.getMenuItem());
                        }
                        catch (NullPointerException nullPointerException) {
                            ComponentState.trace1((String)("Error adding catalogged menu item: " + string), (int)15);
                        }
                    }
                } else if (string.lastIndexOf(";") > 0) {
                    String string3 = string.substring(0, string.lastIndexOf(";"));
                    if (string3.equals("separator")) {
                        jMenu2.addSeparator();
                    } else if (string3.length() != 0 && ((spssAction = ActionCatalog.getActionCatalog().getSpssAction(string3)) == null || spssAction.showMenu())) {
                        try {
                            jMenu2.add(FrameMenuBuildUtil.getUserMenuItemActionId(string3));
                        }
                        catch (NullPointerException nullPointerException) {
                            ComponentState.trace1((String)("Error adding user menu item: " + string3), (int)15);
                        }
                    }
                }
            }
        }
        return jMenu;
    }

    protected static JMenuItem getUserMenuItemActionId(String string) {
        UserMenuAction userMenuAction = new UserMenuAction(string);
        return userMenuAction.getMenuItem();
    }

    protected static boolean isMenuInitiallyEmpty(String string) {
        return string.equals("file_MRUD") || string.equals("file_MRUF") || string.equals("view_toolbar") || string.equals("syntax_goto_bookmark");
    }

    public static enum ItemType {
        MENU,
        MENUITEM,
        SEPARATOR;

    }
}

