/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.doc_util;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.comp_util.RemoteFileStatus;
import com.spss.java_client.core.comp_util.RemoteFileSysUtil;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.ICoreDocument;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.SaveOptions;
import com.spss.java_client.core.documents.data.SaveSyntaxGenerator;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.output.IOutputDocument;
import com.spss.java_client.core.documents.syntax.ISyntaxDocument;
import com.spss.java_client.core.documents.syntax.SyntaxDocument;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.core.server.messages.sysfilemsg.VariableBlock;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.command.ActionCatalog;
import com.spss.java_client.ui.controls.SpssProgressDlg;
import com.spss.java_client.ui.dialogs.base.file.EncryptionEnterPasswordDlg;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.ChooserUIFactory;
import com.spss.java_client.ui.dialogs.fopen.RefWindowsFileChooserUI;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.actions.SpssAction;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxPrefManager;
import com.spss.java_client.ui.doc_types.syntax.SyntaxView;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.syntaxeditor.SyntaxMasterPanel;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.PASWFileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class DocUtil {
    private static LinkedHashMap<String, String> sSaveFilterTypeMap = new LinkedHashMap();
    private static LinkedHashMap<String, String> sSaveSyntaxFilterTypeMap = new LinkedHashMap();
    protected static boolean mUseQuaqua;
    protected static RefWindowsFileChooserUI mFileChooserUI;
    protected static RemoteFileChooser mFileChooser;

    public static void resetFiltersMap() {
        sSaveFilterTypeMap = new LinkedHashMap();
        sSaveSyntaxFilterTypeMap = new LinkedHashMap();
        DocUtil.populateFiltersMap();
    }

    public static RemoteFileChooser getDocTypeFileChooser(RemoteFileChooser.ChooserType chooserType, DocType docType) {
        return DocUtil.getDocTypeFileChooser(chooserType, docType, false);
    }

    public static RemoteFileChooser getDocTypeFileChooser(RemoteFileChooser.ChooserType chooserType, DocType docType, boolean bl) {
        RemoteFileChooser.ChooserOption chooserOption;
        boolean bl2 = false;
        switch (docType) {
            case DE_DOC: {
                chooserOption = RemoteFileChooser.ChooserOption.Data;
                bl2 = true;
                break;
            }
            case SYNTAX_DOC: {
                chooserOption = RemoteFileChooser.ChooserOption.Syntax;
                break;
            }
            case OUTPUT_DOC: {
                chooserOption = RemoteFileChooser.ChooserOption.Output;
                break;
            }
            case SCRIPT_DOC: {
                chooserOption = RemoteFileChooser.ChooserOption.Script;
                break;
            }
            default: {
                chooserOption = RemoteFileChooser.ChooserOption.Generic;
            }
        }
        boolean bl3 = true;
        String string = FileLocationsUtil.getFilesDirectoryPath((DocType)docType);
        if (docType == DocType.DE_DOC) {
            string = FileLocationsUtil.getDataFilesDirectoryPath();
        } else if (docType == DocType.OUTPUT_DOC) {
            bl3 = DocUtil.showPesButton();
        }
        boolean bl4 = bl2 && chooserType == RemoteFileChooser.ChooserType.SaveFile;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(chooserType, chooserOption, string, bl2, bl4, false, bl3);
        DocUtil.addFilters(remoteFileChooser, chooserType, chooserOption, bl);
        if (docType == DocType.DE_DOC) {
            if (chooserType == RemoteFileChooser.ChooserType.OpenFile) {
                String string2 = "";
                remoteFileChooser.setEncodingSelection(string2);
            } else if (chooserType == RemoteFileChooser.ChooserType.SaveFile) {
                remoteFileChooser.setEncodingSelection(null);
            }
        }
        return remoteFileChooser;
    }

    public static boolean saveAsCoreDocument(SpssFrame spssFrame, ISaveCallBack iSaveCallBack) {
        return DocUtil.saveAsCoreDocument(spssFrame, iSaveCallBack, false, null);
    }

    public static boolean saveAsCoreDocument(SpssFrame spssFrame, ISaveCallBack iSaveCallBack, String string) {
        return DocUtil.saveAsCoreDocument(spssFrame, iSaveCallBack, false, string);
    }

    public static boolean saveAsCoreDocument(SpssFrame spssFrame, ISaveCallBack iSaveCallBack, boolean bl, String string) {
        boolean bl2;
        PassEncrypt passEncrypt;
        boolean bl22 = false;
        ICoreDocument iCoreDocument = spssFrame.getCoreDocument();
        RemoteFileChooser remoteFileChooser = DocUtil.getDocTypeFileChooser(RemoteFileChooser.ChooserType.SaveFile, spssFrame.docType(), iSaveCallBack == null);
        if (spssFrame.docType() == DocType.SYNTAX_DOC) {
            if (iCoreDocument.getlastEncodingSetting() != null) {
                remoteFileChooser.setEncodingSelection(iCoreDocument.getlastEncodingSetting());
                RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)remoteFileChooser.getUI());
                refWindowsFileChooserUI.setEncodingControlsEnabled(true);
            } else {
                String string2 = ComponentState.getCurrentCharset().name();
                remoteFileChooser.setEncodingSelection(string2);
            }
        } else if (spssFrame.docType() == DocType.OUTPUT_DOC) {
            boolean bl3 = ((IOutputDocument)iCoreDocument).lock() == IOutputDocument.Lock.ON;
            remoteFileChooser.readerLock(bl3);
        } else if (spssFrame.docType() == DocType.DE_DOC && iCoreDocument.getlastEncodingSetting() != null) {
            remoteFileChooser.setEncodingSelection(iCoreDocument.getlastEncodingSetting());
            RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)remoteFileChooser.getUI());
            if (iCoreDocument.getDocName().toLowerCase().endsWith(CoreResUtil.getString((String)"IDS_SAVE_SAV_FILE_FILTER_EXTENSION"))) {
                refWindowsFileChooserUI.setEncodingControlsEnabled(false);
            } else {
                refWindowsFileChooserUI.setEncodingControlsEnabled(true);
            }
        }
        String string3 = iCoreDocument.getDocName();
        int n = string3.lastIndexOf(46);
        if (bl && n > -1) {
            string3 = string3.substring(0, n) + CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_WREPORT_FILTER_EXTENSION");
        }
        String string4 = iCoreDocument.getPassword();
        if (iCoreDocument.getPasswordMangled()) {
            passEncrypt = new PassEncrypt();
            try {
                byte[] object = passEncrypt.decryptPrintableString(string4.getBytes("UTF-8"));
                string4 = new String(object, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        for (PassEncrypt passEncrypt2 : passEncrypt = remoteFileChooser.getChoosableFileFilters()) {
            if (!(passEncrypt2 instanceof RefFileFilter)) continue;
            if (string == null) {
                if (!string3.toLowerCase().endsWith(CoreResUtil.getString((String)"IDS_SAVE_ZSAV_FILE_FILTER_EXTENSION")) || !((RefFileFilter)passEncrypt2).getExtension().equals("zsav")) continue;
                remoteFileChooser.setFileFilter((FileFilter)passEncrypt2);
                break;
            }
            if (!DocUtil.foundMatch(string, passEncrypt2.getDescription())) continue;
            remoteFileChooser.setFileFilter((FileFilter)passEncrypt2);
            break;
        }
        if (string != null && n > -1) {
            String string2 = ((RefFileFilter)remoteFileChooser.getFileFilter()).getExtension();
            string3 = string3.substring(0, n + 1) + string2;
        }
        remoteFileChooser.setDialogType(1);
        boolean bl3 = true;
        while (bl2) {
            Object object;
            Object object2;
            Object object3;
            bl2 = false;
            int n2 = remoteFileChooser.showDialog(spssFrame, null, string3, string4);
            if (n2 != 0 || iCoreDocument == null) continue;
            File file = remoteFileChooser.getSelectedFile();
            PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
            boolean bl4 = false;
            if (pesFile != null || file.canWrite()) {
                bl4 = true;
            } else {
                try {
                    if (remoteFileChooser.isServerFileSystem()) {
                        bl4 = true;
                    } else if (file.createNewFile()) {
                        bl4 = true;
                        file.delete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!bl4) {
                if (spssFrame.docType() == DocType.DE_DOC) {
                    object3 = DocUtil.getRemoteFileStat(file.getPath());
                    if (object3.equals((Object)eFileStat.File_Read_Only)) {
                        object2 = ResUtil.getString("ERR_READ_ONLY_NO_ACCESS");
                        SpssAlertOptionPane.showInformationMessageDialog(spssFrame, (String)object2, VersionInfo.getAppVersionString());
                        return false;
                    }
                } else if (!file.canWrite()) {
                    object3 = ResUtil.getString("ERR_READ_ONLY_NO_ACCESS");
                    SpssAlertOptionPane.showInformationMessageDialog(spssFrame, (String)object3, VersionInfo.getAppVersionString());
                    return false;
                }
                object3 = file.getAbsolutePath();
                object2 = ResUtil.getString("ERR_FILE_SAVE_WRONG_PATH");
                object2 = ((String)object2).replace("%s", (CharSequence)object3);
                SpssAlertOptionPane.showInformationMessageDialog(spssFrame, (String)object2, VersionInfo.getAppVersionString());
                return false;
            }
            if (spssFrame.docType() == DocType.DE_DOC) {
                FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                object3 = remoteFileChooser.getSelectedFile();
                mUseQuaqua = ChooserUIFactory.isUseQuaqua();
                mFileChooser = remoteFileChooser;
                if (!mUseQuaqua) {
                    mFileChooserUI = (RefWindowsFileChooserUI)((Object)remoteFileChooser.getUI());
                }
                object2 = remoteFileChooser.getFileFilter();
                SaveOptions n4 = null;
                if (object2 instanceof RefFileFilter) {
                    try {
                        object = pesFile == null ? (remoteFileChooser.isServerFileSystem() ? ((File)object3).getAbsolutePath() : ((File)object3).getCanonicalPath()) : pesFile.getUri();
                    }
                    catch (IOException string7) {
                        string7.printStackTrace();
                        object = ((File)object3).getPath();
                    }
                    n4 = DocUtil.populateSaveOptions((FileFilter)object2, (String)object);
                }
                n4.setFileEncodingRequested(remoteFileChooser.getEncodingSelection());
                iCoreDocument.setLastEncodingSetting(remoteFileChooser.getEncodingSelection());
                object = SaveSyntaxGenerator.getSaveSyntax(n4);
                boolean string8 = DocUtil.isDocChangeRequired(n4);
                if (remoteFileChooser.isPasteSelected()) {
                    iSaveCallBack.pasteSyntaxCallback((String)object);
                    bl22 = true;
                    continue;
                }
                try {
                    if (!((DataDocument)iCoreDocument).saveDocument(file, (String)object, false, string8, remoteFileChooser.getEncryptFilePassword(), false)) continue;
                    spssFrame.updateToolbarEnableStatus();
                    bl22 = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            if (spssFrame.docType() == DocType.OUTPUT_DOC) {
                FileLocationsUtil.setFilesDirectoryPath((DocType)DocType.OUTPUT_DOC, (String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                file = remoteFileChooser.getSelectedFile();
                object3 = (IOutputDocument)iCoreDocument;
                object2 = object3.lock();
                IOutputDocument.Lock string9 = remoteFileChooser.readerLock() ? IOutputDocument.Lock.ON : IOutputDocument.Lock.OFF;
                object3.lock(string9);
                if (!mUseQuaqua) {
                    mFileChooserUI = (RefWindowsFileChooserUI)((Object)remoteFileChooser.getUI());
                }
                object3.setStoreModelOptionAvailable(mFileChooserUI.getStoreModelSystemFileOptionAvailable());
                object3.setStoreModel(mFileChooserUI.getStoreModelSystemFileFlag() ? IOutputDocument.StoreModel.YES : IOutputDocument.StoreModel.NO);
                object = null;
                bl22 = true;
                if (pesFile == null && file.exists() && !remoteFileChooser.isPasteSelected()) {
                    try {
                        File file2 = file.getAbsoluteFile().getParentFile();
                        object = PASWFileUtil.createTempFile((String)"Backup", (String)"", (File)file2);
                        DocUtil.copyFile(file, (File)object);
                    }
                    catch (IOException iOException) {
                        if (object != null) {
                            ((File)object).delete();
                        }
                        bl22 = false;
                    }
                }
                if (bl22) {
                    if (remoteFileChooser.isPasteSelected()) {
                        String string5 = iCoreDocument.getPassword();
                        boolean bl5 = iCoreDocument.getPasswordMangled();
                        String string6 = DocUtil.getMangledPassword();
                        if (string6 != null && string6.length() > 0) {
                            iCoreDocument.setPassword(string6, true);
                        } else {
                            iCoreDocument.setPassword(string6, false);
                        }
                        bl22 = iCoreDocument.saveDocument(file, true);
                        iCoreDocument.setPassword(string5, bl5);
                    } else {
                        iCoreDocument.setPassword(remoteFileChooser.getEncryptFilePassword(), false);
                        DocUtil.saveOutputDocument(iCoreDocument, file);
                    }
                }
                if (!bl22) {
                    String string7 = ResUtil.getString("ERR_FILE_SAVE_READ_ONLY");
                    SpssAlertOptionPane.showInformationMessageDialog(spssFrame, string7, VersionInfo.getAppVersionString());
                }
                if (!bl22 && object != null && ((File)object).exists()) {
                    file.delete();
                    ((File)object).renameTo(file);
                } else if (object != null && ((File)object).exists()) {
                    ((File)object).delete();
                }
                if (bl22) {
                    ((ViewerFrame)spssFrame).updateTitleBar();
                    spssFrame.updateToolbarEnableStatus();
                    continue;
                }
                object3.lock((IOutputDocument.Lock)object2);
                continue;
            }
            if (spssFrame.docType() == DocType.SYNTAX_DOC) {
                object3 = remoteFileChooser.getEncodingSelection();
                if (!((String)object3).startsWith("UTF")) {
                    String string8;
                    int n3;
                    object2 = ((SyntaxFrame)spssFrame).getSyntaxView();
                    SyntaxMasterPanel syntaxMasterPanel = ((SyntaxView)object2).getSyntaxMasterPanel();
                    ((SyntaxView)object2).setEncoding(ComponentState.getCurrentCharset());
                    object = ((SyntaxView)object2).validateCharacterEncoding(syntaxMasterPanel.getAllText(), true);
                    if (!SyntaxView.isValidCoderResult((CoderResult)object) && (n3 = SpssAlertOptionPane.showConfirmDialog(spssFrame, string8 = CoreResUtil.getString((String)"IDS_LOCAL_ENCODING_DATA_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1) {
                        return false;
                    }
                }
                iCoreDocument.setLastEncodingSetting(remoteFileChooser.getEncodingSelection());
                FileLocationsUtil.setFilesDirectoryPath((DocType)DocType.SYNTAX_DOC, (String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                if (!mUseQuaqua) {
                    mFileChooserUI = (RefWindowsFileChooserUI)((Object)remoteFileChooser.getUI());
                }
                file = remoteFileChooser.getSelectedFile();
                bl22 = true;
                object2 = null;
                if (pesFile == null && file.exists()) {
                    try {
                        File file3 = file.getAbsoluteFile().getParentFile();
                        object2 = PASWFileUtil.createTempFile((String)"Backup", (String)"", (File)file3);
                        DocUtil.copyFile(file, (File)object2);
                    }
                    catch (IOException iOException) {
                        if (object2 != null) {
                            ((File)object2).delete();
                        }
                        bl22 = false;
                    }
                }
                if (bl22) {
                    iCoreDocument.setPassword(remoteFileChooser.getEncryptFilePassword(), false);
                    int n4 = DocUtil.doSaveSyntaxDoc((ISyntaxDocument)iCoreDocument, file, (String)object3, true);
                    boolean bl6 = bl22 = n4 == 0;
                    if (n4 == SyntaxDocument.RETRY_AFTER_ERROR_ENCODING_CONTENTS) {
                        bl2 = true;
                        continue;
                    }
                }
                if (!bl22) {
                    String string9 = ResUtil.getString("ERR_FILE_SAVE_READ_ONLY");
                    SpssAlertOptionPane.showInformationMessageDialog(spssFrame, string9, VersionInfo.getAppVersionString());
                }
                if (!bl22 && object2 != null && ((File)object2).exists()) {
                    file.delete();
                    ((File)object2).renameTo(file);
                } else if (object2 != null && ((File)object2).exists()) {
                    ((File)object2).delete();
                }
                if (!bl22) continue;
                spssFrame.updateToolbarEnableStatus();
                continue;
            }
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            file = remoteFileChooser.getSelectedFile();
            object3 = null;
            bl22 = true;
            if (pesFile == null && file.exists() && !remoteFileChooser.isPasteSelected()) {
                try {
                    object2 = file.getAbsoluteFile().getParentFile();
                    object3 = PASWFileUtil.createTempFile((String)"Backup", (String)"", (File)object2);
                    DocUtil.copyFile(file, (File)object3);
                }
                catch (IOException iOException) {
                    if (object3 != null) {
                        ((File)object3).delete();
                    }
                    bl22 = false;
                }
            }
            if (bl22) {
                bl22 = iCoreDocument.saveDocument(file, remoteFileChooser.isPasteSelected());
            }
            if (!bl22) {
                object2 = ResUtil.getString("ERR_FILE_SAVE_READ_ONLY");
                SpssAlertOptionPane.showInformationMessageDialog(spssFrame, (String)object2, VersionInfo.getAppVersionString());
            }
            if (!bl22 && object3 != null && ((File)object3).exists()) {
                file.delete();
                ((File)object3).renameTo(file);
            } else if (object3 != null && ((File)object3).exists()) {
                ((File)object3).delete();
            }
            if (!bl22) continue;
            spssFrame.updateToolbarEnableStatus();
        }
        return bl22;
    }

    private static boolean foundMatch(String string, String string2) {
        return string.equals("file_export_data_csv_text") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_COMMA_DELIMITED_FILE_FILTER")) || string.equals("file_export_data_excel") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_XLS_X_FILE_FILTER")) || string.equals("file_export_data_tab") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_TAB_DELIMITED_FILE_FILTER")) || string.equals("file_export_data_fixed_text") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_FIXED_ASCII_FILE_FILTER")) || string.equals("file_export_data_sas") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_SAS_V9_WIN_FILE_FILTER")) || string.equals("file_export_data_stata") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_STATA_14_SE_FILE_FILTER")) || string.equals("file_export_data_dbase") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_DBASE_4_FILE_FILTER")) || string.equals("file_export_data_lotus") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_WK_3_FILE_FILTER")) || string.equals("file_export_data_sylk") && string2.equals(CoreResUtil.getString((String)"IDS_SAVE_SYLK_FILE_FILTER"));
    }

    private static void saveOutputDocument(final ICoreDocument iCoreDocument, final File file) {
        final SpssProgressDlg spssProgressDlg = new SpssProgressDlg(null, CoreResUtil.getString((String)"IDS_FILE_CHOOSER_SAVE_OUTPUT_TITLE"));
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DocUtil.doSaveOutputDoc(iCoreDocument, file);
                    spssProgressDlg.setVisible(false);
                }
                catch (Exception exception) {
                    spssProgressDlg.setVisible(false);
                    exception.printStackTrace();
                }
                finally {
                    spssProgressDlg.setWorkDone(true);
                    spssProgressDlg.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        spssProgressDlg.setInterruptThread(thread);
        try {
            Thread.sleep(1000L);
            if (!spssProgressDlg.isWorkDone()) {
                spssProgressDlg.setVisible(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean doSaveOutputDoc(ICoreDocument iCoreDocument, File file) {
        if (!iCoreDocument.isPasswordProtected()) return iCoreDocument.saveDocument(file, false);
        try {
            String string = PrefsMgr.getPrefsMgr().getTempPath();
            File file2 = PASWFileUtil.createTempFile((String)"encrypt", (String)".spv", (File)new File(string));
            file2.deleteOnExit();
            boolean bl = iCoreDocument.saveDocument(file2, false);
            if (!bl) return bl;
            bl = iCoreDocument.encryptDocument(file, file2);
            file2.delete();
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int doSaveSyntaxDoc(ISyntaxDocument iSyntaxDocument, File file, String string, boolean bl) {
        if (!iSyntaxDocument.isPasswordProtected()) return iSyntaxDocument.saveDocument(file, Charset.forName(string), bl);
        try {
            String string2 = PrefsMgr.getPrefsMgr().getTempPath();
            File file2 = PASWFileUtil.createTempFile((String)"encrypt", (String)".sps", (File)new File(string2));
            file2.deleteOnExit();
            int n = iSyntaxDocument.saveDocument(file2, Charset.forName(string), bl);
            if (n != 0) return n;
            boolean bl2 = iSyntaxDocument.encryptDocument(file, file2);
            file2.delete();
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    private static SaveOptions populateSaveOptions(FileFilter fileFilter, String string) {
        SaveOptions saveOptions = new SaveOptions();
        saveOptions.setFileNamePath(string);
        saveOptions.setSaveTypeOption(fileFilter.getDescription());
        if (DocUtil.getWriteCheckBox().isEnabled()) {
            saveOptions.setWriteVarNamesSyntax(DocUtil.getWriteCheckBox().isSelected());
            saveOptions.setWriteVarNamesLabelsSyntax(DocUtil.getWriteVarLabelsRB().isSelected());
        }
        if (DocUtil.getSaveValueLabelsCheckBox().isEnabled()) {
            saveOptions.setSaveValueLabelsSyntax(DocUtil.getSaveValueLabelsCheckBox().isSelected());
        }
        if (DocUtil.getSaveValueLabelsToFileCheckBox().isEnabled()) {
            saveOptions.setSaveValueLabelsToFileSyntax(DocUtil.getSaveValueLabelsToFileCheckBox().isSelected());
        }
        saveOptions.setDropVariablesSyntax(DocUtil.getDropVariablesSyntax());
        if (saveOptions.getSaveTypeOption() == SaveOptions.SaveType.DATA_ASCII) {
            saveOptions.setKeptVarsString(DocUtil.getKeptVariablesString());
        }
        if (saveOptions.getSaveTypeOption() == SaveOptions.SaveType.XLS_X) {
            saveOptions.setSheetName(DocUtil.getSheetName());
            saveOptions.setAppendSheetToExistingFile(DocUtil.getAppendSheetToExistingFileCheckBox().isSelected());
        }
        saveOptions.setEncryptFilePassword(DocUtil.getMangledPassword(), true);
        return saveOptions;
    }

    public static JCheckBox getWriteCheckBox() {
        if (mUseQuaqua) {
            return mFileChooser.getWriteCheckBox();
        }
        return mFileChooserUI.getWriteCheckBox();
    }

    public static JRadioButton getWriteVarLabelsRB() {
        if (mUseQuaqua) {
            return mFileChooser.getWriteVarLabelsRB();
        }
        return mFileChooserUI.getWriteVarLabelsRB();
    }

    public static JCheckBox getSaveValueLabelsCheckBox() {
        if (mUseQuaqua) {
            return mFileChooser.getSaveValueLabelsCheckBox();
        }
        return mFileChooserUI.getSaveValueLabelsCheckBox();
    }

    public static JCheckBox getSaveValueLabelsToFileCheckBox() {
        if (mUseQuaqua) {
            return mFileChooser.getSaveValueLabelsToFileCheckBox();
        }
        return mFileChooserUI.getSaveValueLabelsToFileCheckBox();
    }

    public static String getSheetName() {
        return mFileChooserUI.getSheetNameString();
    }

    public static JCheckBox getAppendSheetToExistingFileCheckBox() {
        return mFileChooserUI.getAppendSheetToExistingFileCheckBox();
    }

    private static String getMangledPassword() {
        String string = null;
        if (DocUtil.encryptFileWithPassword()) {
            string = mUseQuaqua ? mFileChooser.getEncryptFilePassword() : mFileChooserUI.getEncryptFilePassword();
            PassEncrypt passEncrypt = new PassEncrypt();
            try {
                byte[] byArray = passEncrypt.encryptPrintableString(string.getBytes("UTF-8"), "'\"");
                string = new String(byArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string;
    }

    private static boolean encryptFileWithPassword() {
        if (mUseQuaqua) {
            return mFileChooser.isEncryptFileWithPassword();
        }
        return mFileChooserUI.isEncryptFileWithPasswordSelected();
    }

    public static String getDropVariablesSyntax() {
        if (mUseQuaqua) {
            return mFileChooser.getDropVariablesSyntax();
        }
        return mFileChooserUI.getDropVariablesSyntax();
    }

    public static String getKeptVariablesString() {
        if (mUseQuaqua) {
            return mFileChooser.getKeptVariablesString();
        }
        return mFileChooserUI.getKeptVariablesString();
    }

    private static boolean isDocChangeRequired(SaveOptions saveOptions) {
        SaveOptions.SaveType saveType = saveOptions.getSaveTypeOption();
        String string = saveOptions.getDropVariablesSyntax();
        boolean bl = string != null && string.length() > 0;
        return (saveType == SaveOptions.SaveType.SAV || saveType == SaveOptions.SaveType.ZSAV) && !bl;
    }

    public static boolean saveCoreDocument(SpssFrame spssFrame) {
        boolean bl = true;
        ICoreDocument iCoreDocument = spssFrame.getCoreDocument();
        if (iCoreDocument != null && iCoreDocument.getModifiedFlag()) {
            Object[] objectArray;
            Object object;
            Object object2;
            String string = null;
            if (iCoreDocument instanceof ISyntaxDocument) {
                string = ((ISyntaxDocument)iCoreDocument).getDocumentEncoding();
            }
            File file = iCoreDocument.getFileSpec();
            PesFile pesFile = null;
            if (file != null) {
                pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
            }
            if (file == null || file.exists() && !file.canWrite()) {
                return DocUtil.saveAsCoreDocument(spssFrame, new ISaveCallBack(){

                    @Override
                    public void pasteSyntaxCallback(String string) {
                        DocUtil.pasteSyntax(string);
                    }
                });
            }
            if (spssFrame instanceof SyntaxFrame && string != null && !string.startsWith("UTF")) {
                String string2;
                int n;
                object2 = ((SyntaxFrame)spssFrame).getSyntaxView();
                object = object2.getSyntaxMasterPanel();
                objectArray = object2.getEncoding();
                if (!objectArray.name().equals(string)) {
                    object2.setEncoding(Charset.forName(string));
                }
                CoderResult coderResult = object2.validateCharacterEncoding(object.getAllText(), true);
                if (!objectArray.name().equals(string)) {
                    object2.setEncoding((Charset)objectArray);
                }
                if (!SyntaxView.isValidCoderResult(coderResult) && (n = SpssAlertOptionPane.showConfirmDialog(spssFrame, string2 = CoreResUtil.getString((String)"IDS_LOCAL_ENCODING_DATA_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1) {
                    return false;
                }
            }
            if (spssFrame.docType().equals((Object)DocType.DE_DOC) && pesFile == null) {
                object2 = DocUtil.getRemoteFileStat(file.getPath());
                if (((Enum)object2).equals((Object)eFileStat.File_Read_Only)) {
                    object = ResUtil.getString("ERR_READ_ONLY_NO_ACCESS");
                    SpssAlertOptionPane.showInformationMessageDialog(spssFrame, (String)object, VersionInfo.getAppVersionString());
                    return false;
                }
                if (((Enum)object2).equals((Object)eFileStat.File_Read_Write_Changed_Externally)) {
                    object = MessageFormat.format(ResUtil.getString("ERR_SAV_FILE_CHANGED_ON_DISK"), file.getName());
                    objectArray = new String[]{ResUtil.getString("IDS_FILE_CHANGED_CONTINUE"), ResUtil.getString("IDS_FILE_CHANGED_SAVE_AS"), ResUtil.getCommonDlgString("IDS_CANCEL")};
                    int n = SpssAlertOptionPane.showOptionDialog(spssFrame, (String)object, ResUtil.getString("IDS_FILE_HAS_CHANGED_STRING"), SpssAlertOptionPane.IconType.eWarning, objectArray, (Object)objectArray[1]);
                    switch (n) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            return DocUtil.saveAsCoreDocument(spssFrame, new ISaveCallBack(){

                                @Override
                                public void pasteSyntaxCallback(String string) {
                                    DocUtil.pasteSyntax(string);
                                }
                            });
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            object2 = null;
            bl = true;
            if (pesFile == null && file.exists()) {
                try {
                    object = file.getAbsoluteFile().getParentFile();
                    object2 = PASWFileUtil.createTempFile((String)"Backup", (String)"", (File)object);
                    DocUtil.copyFile(file, (File)object2);
                }
                catch (IOException iOException) {
                    if (object2 != null) {
                        ((File)object2).delete();
                    }
                    bl = false;
                }
            }
            if (bl) {
                int n;
                bl = iCoreDocument instanceof ISyntaxDocument && string != null ? (n = DocUtil.doSaveSyntaxDoc((ISyntaxDocument)iCoreDocument, file, string, false)) == 0 : (iCoreDocument instanceof IOutputDocument ? DocUtil.doSaveOutputDoc(iCoreDocument, file) : iCoreDocument.saveDocument(file, false));
            }
            if (bl) {
                if (object2 != null && ((File)object2).exists()) {
                    ((File)object2).delete();
                }
                spssFrame.updateToolbarEnableStatus();
            } else {
                String string3 = ResUtil.getString("ERR_FILE_SAVE_READ_ONLY");
                SpssAlertOptionPane.showInformationMessageDialog(spssFrame, string3, VersionInfo.getAppVersionString());
                if (object2 != null && ((File)object2).exists()) {
                    file.delete();
                    ((File)object2).renameTo(file);
                }
            }
        }
        return bl;
    }

    public static void pasteSyntax(String string) {
        SyntaxFrame syntaxFrame = (SyntaxFrame)SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.SYNTAX_DOC);
        if (syntaxFrame != null) {
            SyntaxEditorState syntaxEditorState = SyntaxPrefManager.getSyntaxEditorPreferences();
            boolean bl = syntaxEditorState.isPasteAtCursor();
            syntaxFrame.getSyntaxView().pasteSyntax("\n" + string, bl, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public static eFileStat getRemoteFileStat(String string) {
        eFileStat eFileStat2 = eFileStat.File_Not_Found;
        try {
            RemoteFileStatus remoteFileStatus = RemoteFileSysUtil.getRemoteFileSysUtil().validateFile(string);
            if (!remoteFileStatus.errorOccurred()) {
                RemoteFileStatus.FileNodeStatus fileNodeStatus = remoteFileStatus.getFileStatus();
                if (fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_DOES_NOT_EXIST)) {
                    eFileStat2 = eFileStat.File_Not_Found;
                } else if (remoteFileStatus.getParentDirStatus().equals((Object)RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY)) {
                    eFileStat2 = eFileStat.File_Read_Only;
                } else if (fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_READ_ONLY)) {
                    eFileStat2 = eFileStat.File_Read_Only;
                } else if (fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE) || fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE_BUT_LOCKED)) {
                    eFileStat2 = eFileStat.File_Read_Write;
                } else if (fileNodeStatus.equals((Object)RemoteFileStatus.FileNodeStatus.RFS_WRITEABLE_BUT_CHANGED)) {
                    eFileStat2 = eFileStat.File_Read_Write_Changed_Externally;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return eFileStat2;
        }
        return eFileStat2;
    }

    public static boolean checkForData(String string) {
        boolean bl = false;
        try {
            Object object;
            boolean bl2 = ProcedureDlgMgr.isExceptionDialog(string);
            SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
            if (!(spssFrame instanceof DataFrame)) {
                object = DataMgr.getDataMgr().getActiveBackendDocumentId();
                if (object != null && !object.isNull()) {
                    spssFrame = SpssFrameMgr.getSpssFrameMgr().getDataFrame((LocallyUniqueId)object);
                    assert (spssFrame != null);
                    if (!bl2) {
                        SpssFrameMgr.getSpssFrameMgr().designateWindow(spssFrame);
                    }
                } else {
                    assert (false);
                    return false;
                }
            }
            if (CommandLine.isExternalCaller()) {
                return true;
            }
            bl = ComponentState.getProcessorAvailable();
            if (bl) {
                boolean bl3 = bl = bl2 || !spssFrame.getCoreDocument().isDocumentEmpty();
            }
            if (!bl) {
                object = ResUtil.getCommonDlgString("ERR_NEED_DATA_MSG");
                DocUtil.showNoDataError(spssFrame, (String)object);
            } else if (DocUtil.isSimulationProcedure(string) && DataMgr.getDataMgr().dataSourceCount() == 1 && DataMgr.getDataMgr().getDataSource(0).getDatasetName().equals("DataSet0")) {
                boolean bl4;
                ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(0);
                IVariableSet iVariableSet = iSpssDataSrc.getALLVARIABLES();
                boolean bl5 = bl4 = iVariableSet == null || iVariableSet.getVariableNames().size() == 0;
                if (bl4 || iSpssDataSrc.getFileSpec().length() == 0) {
                    object = ResUtil.getCommonDlgString("ERR_NEED_DATA_MSG_SIMULATION");
                    DocUtil.showNoDataError(spssFrame, (String)object);
                    return false;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (AssertionError assertionError) {
            ((Throwable)((Object)assertionError)).printStackTrace();
        }
        return bl;
    }

    public static SpssAction getActionFromMenu(JPopupMenu jPopupMenu, String string) {
        SpssAction spssAction = null;
        for (Component component : jPopupMenu.getComponents()) {
            Action action;
            if (!(component instanceof JMenuItem) || !((action = ((JMenuItem)component).getAction()) instanceof SpssAction) || !((SpssAction)action).getActionId().equals(string)) continue;
            spssAction = (SpssAction)action;
            break;
        }
        return spssAction;
    }

    public static OBS readObs(ObjectInputStream objectInputStream) {
        OBS oBS;
        block5: {
            oBS = new OBS();
            try {
                int n = objectInputStream.readInt();
                if (n > 0) {
                    String string = "";
                    try {
                        byte[] byArray = (byte[])objectInputStream.readObject();
                        string = new String(byArray, "UTF-8");
                        string = CharacterUtil.rightTrim((String)string);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                    oBS.setString(string);
                    break block5;
                }
                oBS.setNum(objectInputStream.readDouble());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return oBS;
    }

    public static boolean writeObs(ObjectOutputStream objectOutputStream, OBS oBS) {
        try {
            if (oBS.isString()) {
                byte[] byArray = oBS.getString().getBytes("UTF-8");
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.writeObject(byArray);
            } else {
                objectOutputStream.writeInt(0);
                objectOutputStream.writeDouble(oBS.getNum());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public static Vector<String> findVariablesWithRootName(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        String string2 = "_";
        LocallyUniqueId locallyUniqueId = SpssMgr.getSpssMgr().getActiveClientDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        int n2 = iSpssDataSrc.columnCount();
        for (int i = 0; i < n2; ++i) {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(i);
            String string3 = iSpssVariable.getName();
            if (string3.length() <= n || !string3.startsWith(string) || string3.charAt(n) != '_') continue;
            String string4 = string3.substring(n + 1);
            String[] stringArray = string4.split(string2);
            boolean bl = true;
            for (int j = 0; j < stringArray.length && bl; ++j) {
                String string5 = stringArray[j];
                if (string5.length() > 0) {
                    try {
                        Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    continue;
                }
                if (j <= 0) continue;
                bl = false;
            }
            if (!bl || stringArray.length <= 0) continue;
            vector.add(string3);
        }
        return vector;
    }

    private static void addFilters(RemoteFileChooser remoteFileChooser, RemoteFileChooser.ChooserType chooserType, RemoteFileChooser.ChooserOption chooserOption, boolean bl) {
        RefFileFilter[] refFileFilterArray;
        String string = null;
        String string2 = null;
        if (chooserType.equals((Object)RemoteFileChooser.ChooserType.OpenFile)) {
            if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Data)) {
                refFileFilterArray = DacMgr.getDacMgr().getDacFileFilters();
                for (RefFileFilter refFileFilter : refFileFilterArray) {
                    remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                }
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
                remoteFileChooser.setFileFilter((FileFilter)refFileFilterArray[0]);
            } else if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Syntax)) {
                DocUtil.setSaveSyntaxFilters(remoteFileChooser);
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
                remoteFileChooser.setFileFilter(remoteFileChooser.getChoosableFileFilters()[0]);
            } else if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Output)) {
                string = "IDS_OUTPUT_FILE_FILTER";
                string2 = "IDS_OUTPUT_FILE_FILTER_EXTENSION";
            }
        } else if (chooserType.equals((Object)RemoteFileChooser.ChooserType.SaveFile)) {
            if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Data)) {
                refFileFilterArray = DocUtil.setSaveDataFilters(remoteFileChooser);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileFilter((FileFilter)refFileFilterArray);
            } else if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Syntax)) {
                refFileFilterArray = DocUtil.setSaveSyntaxFilters(remoteFileChooser);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileFilter((FileFilter)refFileFilterArray);
            } else if (chooserOption.equals((Object)RemoteFileChooser.ChooserOption.Output)) {
                refFileFilterArray = new RefFileFilter[]{new RefFileFilter(CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_FILE_FILTER_EXTENSION"), ";"), new RefFileFilter(CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_WREPORT_FILTER"), CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_WREPORT_FILTER_EXTENSION"), ";"), new RefFileFilter(CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_AREPORT_FILTER"), CoreResUtil.getString((String)"IDS_OUTPUT_SAVE_AREPORT_FILTER_EXTENSION"), ";")};
                for (RefFileFilter refFileFilter : refFileFilterArray) {
                    remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                }
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileFilter((FileFilter)(bl ? refFileFilterArray[1] : refFileFilterArray[0]));
            }
        }
        if (string != null && !string.equals("")) {
            refFileFilterArray = new RefFileFilter(CoreResUtil.getString((String)string), CoreResUtil.getString((String)string2));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilterArray);
            if (chooserType.equals((Object)RemoteFileChooser.ChooserType.OpenFile)) {
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
            } else if (chooserType.equals((Object)RemoteFileChooser.ChooserType.SaveFile)) {
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
            }
            remoteFileChooser.setFileFilter((FileFilter)refFileFilterArray);
        }
    }

    private static void populateFiltersMap() {
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAV_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAV_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_ZSAV_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_ZSAV_FILE_FILTER_EXTENSION"));
        if (ComponentState.isUnicodeServer()) {
            sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAV_CP_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAV_CP_FILE_FILTER_EXTENSION"));
        }
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAV_7_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAV_7_FILE_FILTER_EXTENSION"));
        if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
            sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SPSS_PC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SPSS_PC_FILE_FILTER_EXTENSION"));
        }
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SPSS_PORT_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SPSS_PORT_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_TAB_DELIMITED_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_TAB_DELIMITED_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_COMMA_DELIMITED_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_COMMA_DELIMITED_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_FIXED_ASCII_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_FIXED_ASCII_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_XLS_2_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_XLS_2_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_XLS_97_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_XLS_97_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_XLS_X_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_XLS_X_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_WK_3_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_WK_3_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_WK_1_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_WK_1_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_WK_S_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_WK_S_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SYLK_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SYLK_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_DBASE_4_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_DBASE_4_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_DBASE_3_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_DBASE_3_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_DBASE_2_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_DBASE_2_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_WIN_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_WIN_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_UNIX_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_UNIX_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_ALPHA_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V6_ALPHA_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_WIN_SHORT_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_WIN_SHORT_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_WIN_LONG_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_WIN_LONG_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_UNIX_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V7_UNIX_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V9_WIN_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V9_WIN_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_V9_UNIX_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_V9_UNIX_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_SAS_TRANSPORT_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_SAS_TRANSPORT_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_4_5_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_4_5_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_6_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_6_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_7_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_7_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_7_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_7_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_8_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_8_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_8_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_8_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_9_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_9_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_9_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_9_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_10_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_10_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_10_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_10_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_11_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_11_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_11_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_11_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_12_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_12_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_12_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_12_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_13_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_13_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_13_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_13_SE_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_14_IC_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_14_IC_FILE_FILTER_EXTENSION"));
        sSaveFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SAVE_STATA_14_SE_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SAVE_STATA_14_SE_FILE_FILTER_EXTENSION"));
        sSaveSyntaxFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SYNTAX_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SYNTAX_FILE_FILTER_EXTENSION"));
        sSaveSyntaxFilterTypeMap.put(CoreResUtil.getString((String)"IDS_SYNTAX_ENCRYPTED_FILE_FILTER"), CoreResUtil.getString((String)"IDS_SYNTAX_ENCRYPTED_FILE_FILTER_EXTENSION"));
    }

    private static FileFilter setSaveDataFilters(RemoteFileChooser remoteFileChooser) {
        for (String string : sSaveFilterTypeMap.keySet()) {
            RefFileFilter refFileFilter = new RefFileFilter(string, sSaveFilterTypeMap.get(string));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        }
        return remoteFileChooser.getChoosableFileFilters()[1];
    }

    private static FileFilter setSaveSyntaxFilters(RemoteFileChooser remoteFileChooser) {
        for (String string : sSaveSyntaxFilterTypeMap.keySet()) {
            RefFileFilter refFileFilter = new RefFileFilter(string, sSaveSyntaxFilterTypeMap.get(string));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
        }
        return remoteFileChooser.getChoosableFileFilters()[1];
    }

    private static boolean showPesButton() {
        if (!VersionInfo.isSmartReader()) {
            return true;
        }
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("general");
        return preferences2.getBoolean("show_pes_on_file_dlgs", false);
    }

    private static void showNoDataError(SpssFrame spssFrame, String string) {
        SpssAction spssAction;
        Object[] objectArray = new Object[]{ResUtil.getCommonDlgString("IDS_OPEN_DATA_FILE"), ResUtil.getCommonDlgString("IDS_CANCEL")};
        int n = SpssAlertOptionPane.showOptionDialog(spssFrame, string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, objectArray, objectArray[0]);
        if (n == 0 && (spssAction = ActionCatalog.getActionCatalog().getSpssAction("file_open_data")) != null) {
            spssAction.actionPerformed(new ActionEvent(spssFrame, 1, "file_open_data"));
        }
    }

    private static boolean isSimulationProcedure(String string) {
        return string.equals("analyze_simulation_gating_dialog");
    }

    public static DataEncryptionTestResults testOpenEncryptedData(JFrame jFrame, String string) {
        DataEncryptionTestResults dataEncryptionTestResults = new DataEncryptionTestResults();
        boolean bl = DacMgr.getDacMgr().isFileEncrypted(string, DacMgr.FileType.Data);
        if (bl) {
            DocUtil.doEncryptPasswordDlg(jFrame, string, dataEncryptionTestResults, DacMgr.FileType.Data);
        } else {
            DacMgr.SysFileVarInfoReturnInfo sysFileVarInfoReturnInfo = DacMgr.getSysFileVarInfoReturnInfo((String)string, null);
            dataEncryptionTestResults.setRetVal(sysFileVarInfoReturnInfo.getRetVal());
            dataEncryptionTestResults.setVarBlocks(sysFileVarInfoReturnInfo.getVarBlocks());
            dataEncryptionTestResults.setErrorMsg(sysFileVarInfoReturnInfo.getErrorMsg());
        }
        return dataEncryptionTestResults;
    }

    public static void doEncryptPasswordDlg(JFrame jFrame, String string, EncryptionTestResults encryptionTestResults, DacMgr.FileType fileType) {
        EncryptionEnterPasswordDlg encryptionEnterPasswordDlg = new EncryptionEnterPasswordDlg(jFrame, string, fileType, encryptionTestResults);
        encryptionEnterPasswordDlg.setVisible(true);
    }

    static {
        DocUtil.populateFiltersMap();
        mUseQuaqua = false;
        mFileChooserUI = null;
    }

    public static class DataEncryptionTestResults
    extends EncryptionTestResults {
        Vector<VariableBlock> varBlocks;

        public Vector<VariableBlock> getVarBlocks() {
            return this.varBlocks;
        }

        public void setVarBlocks(Vector<VariableBlock> vector) {
            this.varBlocks = vector;
        }
    }

    public static class EncryptionTestResults {
        private String mangledPassword = null;
        short retVal = 0;
        String errorMsg = null;
        boolean passwordDlgOKPressed = true;

        public EncryptionTestResults() {
        }

        public EncryptionTestResults(String string) {
            this.mangledPassword = string;
        }

        public void setMangledPassword(String string) {
            this.mangledPassword = string;
        }

        public String getMangledPassword() {
            return this.mangledPassword;
        }

        public boolean isCanContinue() {
            return this.retVal == 0 && this.errorMsg == null && this.passwordDlgOKPressed;
        }

        public boolean hasError() {
            return this.errorMsg != null;
        }

        public short getRetVal() {
            return this.retVal;
        }

        public void setRetVal(short s) {
            this.retVal = s;
        }

        public boolean isPasswordDlgOKPressed() {
            return this.passwordDlgOKPressed;
        }

        public void setPasswordDlgOKPressed(boolean bl) {
            this.passwordDlgOKPressed = bl;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String string) {
            this.errorMsg = string;
        }
    }

    public static interface ISaveCallBack {
        public void pasteSyntaxCallback(String var1);
    }

    public static enum eFileStat {
        File_Not_Found,
        File_Read_Only,
        File_Read_Write,
        File_Read_Write_Changed_Externally;

    }
}

