/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.Role;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.TraceSettings;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class VariableViewCellEdit
extends AbstractUndoableEdit {
    private VarViewTableModel mTableModel;
    private ISpssDataSrc mDataSource;
    private Object mOldValue;
    private Object mNewValue;
    private int mRowIndex;
    private String mColumnId;
    private boolean mWasModified;
    private SpssFrame mFrame = null;

    public VariableViewCellEdit(VarViewTableModel varViewTableModel, Object object, int n, String string) {
        this.mFrame = varViewTableModel.getUndoManager().getSpssFrame();
        this.mTableModel = varViewTableModel;
        this.mDataSource = varViewTableModel.getDataSource();
        this.mOldValue = this.mTableModel.getValueAt(n, this.mTableModel.columnIdToColumnIndex(string));
        this.mNewValue = object;
        this.mRowIndex = n;
        this.mColumnId = string;
        this.mWasModified = this.mDataSource.isModified();
        this.mTableModel.getUndoManager().addEdit(this);
        if (this.mOldValue instanceof String && (this.mColumnId.equals("width") || this.mColumnId.equals("decimals") || this.mColumnId.equals("columns"))) {
            try {
                this.mOldValue = Integer.valueOf((String)this.mOldValue);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
                this.mOldValue = 0;
            }
        }
        this.doAction(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
    }

    @Override
    public void die() {
        super.die();
        this.mTableModel = null;
        this.mDataSource = null;
        this.mOldValue = null;
        this.mNewValue = null;
        this.mWasModified = false;
    }

    private void doAction(boolean bl) {
        ISpssVariable iSpssVariable;
        if (this.mNewValue.equals(this.mOldValue)) {
            return;
        }
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(this.mRowIndex) : null;
        if (iSpssVariable == null) {
            assert (false);
            return;
        }
        if (!this.setVarValue(iSpssVariable, bl)) {
            return;
        }
        this.mDataSource.modifyVariable(iSpssVariable, this.mRowIndex);
        if (this.mDataSource != null) {
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>(1);
            vector.addElement(iSpssVariable);
            DataMgr.getDataMgr().sendModifyVarsMsg(this.mDataSource.getDataSetId(), vector, bl);
            this.mDataSource.getCacheMgr().clearCache();
            this.mDataSource.notifyVariableModified(this.mRowIndex, ORIGINATOR_ID.DATAMGR_ORIGINATOR);
            this.mDataSource.setModified(!bl || this.mWasModified);
        }
        this.mTableModel.fireTableCellUpdated(this.mRowIndex, this.mTableModel.columnIdToColumnIndex(this.mColumnId));
        this.mTableModel.fireTableVariableChanged(this.mRowIndex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariableViewCellEdit.this.mFrame.updateToolbarEnableStatus();
            }
        });
    }

    private boolean setVarValue(ISpssVariable iSpssVariable, boolean bl) {
        boolean bl2 = false;
        if (this.mColumnId.equals("name") || this.mColumnId.equals("label")) {
            bl2 = this.setTextValue(iSpssVariable, bl);
        } else if (this.mColumnId.equals("width") || this.mColumnId.equals("decimals") || this.mColumnId.equals("columns")) {
            bl2 = this.setSpinnerValue(iSpssVariable, bl);
        } else if (this.mColumnId.equals("alignment")) {
            bl2 = this.setAlignmentValue(iSpssVariable, bl);
        } else if (this.mColumnId.equals("measure")) {
            bl2 = this.setMeasurementValue(iSpssVariable, bl);
        } else if (this.mColumnId.equals("role")) {
            bl2 = this.setRoleValue(iSpssVariable, bl);
        }
        return bl2;
    }

    private boolean setMeasurementValue(ISpssVariable iSpssVariable, boolean bl) {
        MeasurementLevel measurementLevel;
        Object object;
        boolean bl2 = false;
        Object object2 = object = bl ? this.mOldValue : this.mNewValue;
        if (object instanceof MeasurementLevel && !(measurementLevel = (MeasurementLevel)object).equals((Object)MeasurementLevel.unknown)) {
            iSpssVariable.setMeasurementLevel(measurementLevel);
            bl2 = true;
        }
        return bl2;
    }

    private boolean setAlignmentValue(ISpssVariable iSpssVariable, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = object = bl ? this.mOldValue : this.mNewValue;
        if (object instanceof DisplayAlignment) {
            DisplayAlignment displayAlignment = (DisplayAlignment)object;
            iSpssVariable.setDisplayAlignment(displayAlignment);
            bl2 = true;
        }
        return bl2;
    }

    private boolean setRoleValue(ISpssVariable iSpssVariable, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = object = bl ? this.mOldValue : this.mNewValue;
        if (object instanceof Role) {
            Role role = (Role)object;
            iSpssVariable.setRole(role);
            bl2 = true;
        }
        return bl2;
    }

    private boolean setTextValue(ISpssVariable iSpssVariable, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = object = bl ? this.mOldValue : this.mNewValue;
        if (this.mColumnId.equals("name")) {
            if (object instanceof String && ((String)object).trim().length() > 0) {
                int n = this.mDataSource.findVarIndex(iSpssVariable.getName());
                int n2 = this.mDataSource.findVarIndex(object.toString());
                boolean bl3 = bl2 = this.mRowIndex < this.mDataSource.columnCount() && n == n2 || DialogUtil.checkNewVarName(this.mFrame, this.mDataSource, object.toString());
                if (bl2) {
                    iSpssVariable.setName(object.toString());
                }
            }
        } else if (this.mColumnId.equals("label") && object != null) {
            int n;
            String string = object.toString();
            try {
                n = string.getBytes(ComponentState.getCurrentCharsetName()).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                n = string.length();
            }
            if (n > 255) {
                string = string.substring(0, 255);
            }
            iSpssVariable.setLabel(string);
            bl2 = true;
        }
        return bl2;
    }

    private boolean setSpinnerValue(ISpssVariable iSpssVariable, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = object = bl ? this.mOldValue : this.mNewValue;
        if (object instanceof String) {
            try {
                object = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                TraceSettings.trace1((String)"Error parsing spinner string", (int)15);
            }
        }
        if (object instanceof Integer) {
            short s;
            bl2 = true;
            Integer n = (Integer)object;
            SPSS_Format sPSS_Format = iSpssVariable.getFormat();
            SPSS_Format sPSS_Format2 = iSpssVariable.getWriteFormat();
            String string = null;
            if (this.mColumnId.equals("width")) {
                if (sPSS_Format.getFormatType().isNumericFormat()) {
                    s = sPSS_Format.getDecimals();
                    if (n <= 0 || n > 40) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DISPWIDTH");
                    } else if (sPSS_Format.getFormatType().isDollarFormat() && n - s < 2) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DOLLAR_VAR_WIDTH_ERROR");
                    } else if (n <= s) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DECIMALS_TOO_BIG");
                    }
                } else if (sPSS_Format.getFormatType().isStringFormat() && (n <= 0 || n > Short.MAX_VALUE)) {
                    bl2 = false;
                    string = ResUtil.getString("ERR_INVALID_WIDTH");
                }
            } else if (this.mColumnId.equals("decimals")) {
                if (sPSS_Format.getFormatType().isNumericFormat()) {
                    s = sPSS_Format.getWidth();
                    if (n < 0 || n > 16) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DISPDECIMAL");
                    } else if (sPSS_Format.getFormatType().isDollarFormat() && s - n < 2) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DOLLAR_VAR_WIDTH_ERROR");
                    } else if (n >= s) {
                        bl2 = false;
                        string = ResUtil.getString("ERR_DECIMALS_TOO_BIG");
                    }
                }
            } else if (this.mColumnId.equals("columns") && n <= 0) {
                bl2 = false;
            }
            if (!bl2) {
                if (string != null) {
                    final String string2 = string;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane jOptionPane = new JOptionPane(string2, 2);
                            JDialog jDialog = jOptionPane.createDialog(VariableViewCellEdit.this.mTableModel.getUndoManager().getSpssFrame(), VersionInfo.getAppVersionString());
                            jDialog.setModal(true);
                            jDialog.setVisible(true);
                        }
                    });
                }
            } else if (this.mColumnId.equals("width")) {
                sPSS_Format.setWidth((short)n.intValue());
                sPSS_Format2.setWidth((short)n.intValue());
                if (iSpssVariable.getType() > 0) {
                    iSpssVariable.setType(sPSS_Format.getWidth());
                }
                iSpssVariable.setFormat(sPSS_Format);
                iSpssVariable.setWriteFormat(sPSS_Format2);
            } else if (this.mColumnId.equals("decimals")) {
                sPSS_Format.setDecimals((byte)n.intValue());
                sPSS_Format2.setDecimals((byte)n.intValue());
                iSpssVariable.setFormat(sPSS_Format);
                iSpssVariable.setWriteFormat(sPSS_Format2);
            } else if (this.mColumnId.equals("columns")) {
                iSpssVariable.setDisplayWidth((short)n.intValue());
            }
        }
        return bl2;
    }

    public Integer integerFromString(Object object) {
        Integer n = 0;
        if (object instanceof String) {
            try {
                n = Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }
}

