/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class VariableInsertEdit
extends AbstractUndoableEdit {
    private ISpssDataSrc mDataSrc = null;
    private int mTargetColumn = -1;
    private int mFirstColumn = -1;
    private int mColumnCount = -1;
    private Vector<String> mNewVarNames = new Vector();
    private int mLastColumnType = -1;
    private boolean mWasDirty = false;
    private SpssUndoManager mUndoMgr = null;
    private Vector<ISpssVariable> mVarList = new Vector();
    private String mLastVarName = null;

    public VariableInsertEdit(SpssUndoManager spssUndoManager, ISpssDataSrc iSpssDataSrc, int n, int n2, int n3) {
        this(spssUndoManager, iSpssDataSrc, n, n2, n3, null);
    }

    public VariableInsertEdit(SpssUndoManager spssUndoManager, ISpssDataSrc iSpssDataSrc, int n, int n2, int n3, String string) {
        this.mDataSrc = iSpssDataSrc;
        this.mFirstColumn = this.mTargetColumn = n;
        this.mColumnCount = n2;
        this.mLastColumnType = n3;
        this.mWasDirty = iSpssDataSrc.isModified();
        this.mUndoMgr = spssUndoManager;
        this.mLastVarName = string;
        if (this.buildVarList(null)) {
            spssUndoManager.addEdit(this);
            this.doAction(false);
        }
    }

    public VariableInsertEdit(SpssUndoManager spssUndoManager, ISpssDataSrc iSpssDataSrc, int n, Vector<ISpssVariable> vector) {
        this.mDataSrc = iSpssDataSrc;
        this.mTargetColumn = n;
        this.mLastColumnType = -1;
        this.mWasDirty = iSpssDataSrc.isModified();
        this.mUndoMgr = spssUndoManager;
        int n2 = this.mDataSrc.columnCount();
        this.mFirstColumn = this.mTargetColumn > n2 ? n2 : this.mTargetColumn;
        this.mColumnCount = n - this.mFirstColumn + vector.size();
        if (this.buildVarList(vector)) {
            spssUndoManager.addEdit(this);
            this.doAction(false);
        }
    }

    public void setLastColType(int n) {
        this.mLastColumnType = n;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasDirty) {
            this.mDataSrc.setModified(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
    }

    @Override
    public void die() {
        super.die();
        this.mDataSrc = null;
        this.mTargetColumn = -1;
        this.mColumnCount = -1;
        this.mLastColumnType = -1;
    }

    private void doAction(boolean bl) {
        ((DataFrame)this.mUndoMgr.getSpssFrame()).getDataView().cancelEdit();
        if (bl) {
            this.mDataSrc.deleteVariables(this.mFirstColumn, this.mFirstColumn + this.mColumnCount - 1);
        } else {
            for (int i = 0; i < this.mVarList.size(); ++i) {
                this.mDataSrc.insertVariable(this.mFirstColumn + i, this.mVarList.get(i));
            }
            this.mUndoMgr.getSpssFrame().getCoreDocument().setModifiedFlag(true);
        }
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>(this.mVarList);
        DataMgr.getDataMgr().sendInsertVarsMsg(this.mDataSrc.getDataSetId(), vector, this.mFirstColumn, bl);
        if (bl) {
            this.mDataSrc.notifyVariablesDeleted(this.mFirstColumn, this.mFirstColumn + this.mColumnCount - 1, this.mDataSrc.columnCount(), ORIGINATOR_ID.DATAMGR_ORIGINATOR);
            int n = ((DataFrame)this.mUndoMgr.getSpssFrame()).getDataView().getActiveView();
            ((DataFrame)this.mUndoMgr.getSpssFrame()).getDataView().getDataTable(n).clearSelection();
        } else {
            for (ISpssVariable iSpssVariable : this.mVarList) {
                this.mDataSrc.notifyVariableInserted(iSpssVariable.getDatasetIndex(), ORIGINATOR_ID.DATAMGR_ORIGINATOR);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((DataFrame)VariableInsertEdit.this.mUndoMgr.getSpssFrame()).getDataView().updateVarsInUse(true);
                VariableInsertEdit.this.mUndoMgr.getSpssFrame().updateToolbarEnableStatus();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean buildVarList(Vector<ISpssVariable> vector) {
        int n = this.mDataSrc.columnCount();
        int n2 = this.mTargetColumn > n ? this.mTargetColumn - n : 0;
        int n3 = 0;
        while (true) {
            ISpssVariable iSpssVariable;
            int n4;
            block15: {
                block17: {
                    block16: {
                        if (n3 >= this.mColumnCount) {
                            return true;
                        }
                        if (this.mLastColumnType == -1) break block16;
                        boolean bl = n3 == this.mColumnCount - 1;
                        n4 = bl ? this.mLastColumnType : 0;
                        ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                        if (bl && this.mLastVarName != null) {
                            SpssVariable spssVariable = new SpssVariable();
                            Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
                            Preferences preferences2 = preferences.node("options");
                            Preferences preferences3 = preferences2.node("data");
                            String string = preferences3.get("display_format_width", "8");
                            String string2 = preferences3.get("display_format_decimal", "2");
                            short s = Short.valueOf(string);
                            byte by = Byte.valueOf(string2);
                            spssVariable.setFormat(new SPSS_Format(FormatType.F, s, by));
                            spssVariable.setWriteFormat(new SPSS_Format(FormatType.F, s, by));
                            spssVariable.setDisplayAlignment(DisplayAlignment.right);
                            spssVariable.setDisplayWidth(s);
                            spssVariable.setMeasurementLevel(this.mLastColumnType == 0 ? MeasurementLevel.unknown : MeasurementLevel.nominal);
                            spssVariable.setName(this.mLastVarName);
                            spssVariable.setType((short)n4);
                            iSpssVariable = this.mDataSrc.makeVariable((ISpssVariable)spssVariable, returnIndex);
                            break block15;
                        } else {
                            iSpssVariable = this.mDataSrc.makeVariable(n4, returnIndex);
                        }
                        break block15;
                    }
                    if (vector == null) break block17;
                    ISpssDataSrc.ReturnIndex returnIndex = new ISpssDataSrc.ReturnIndex();
                    if (n2 - n3 > 0) {
                        iSpssVariable = this.mDataSrc.makeVariable(0, returnIndex);
                        break block15;
                    } else if (vector.size() > n3 - n2) {
                        iSpssVariable = this.mDataSrc.makeVariable(vector.get(n3 - n2), returnIndex);
                        break block15;
                    } else {
                        assert (false);
                        return false;
                    }
                }
                assert (false);
                return false;
            }
            if (iSpssVariable == null) break;
            if (n3 < this.mNewVarNames.size()) {
                iSpssVariable.setName(this.mNewVarNames.get(n3));
            } else {
                String string = iSpssVariable.getName();
                n4 = 0;
                for (String string3 : this.mNewVarNames) {
                    if (!string3.matches(string)) continue;
                    n4 = 1;
                    break;
                }
                if (n4 != 0 || string.trim().equals("") || this.mDataSrc.findVarIndex(string) != -1) {
                    string = this.mDataSrc.getUniqueVarName();
                    iSpssVariable.setName(string);
                }
                this.mNewVarNames.add(string);
            }
            this.mVarList.add(iSpssVariable);
            ++n3;
        }
        assert (false);
        return false;
    }
}

