/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.DisplayAlignment;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.MeasurementLevel;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;

public class VarViewVariableTypeEdit
extends AbstractUndoableEdit {
    private SpssFrame mFrame;
    private VarViewTableModel mTableModel;
    private ISpssDataSrc mDataSource;
    private boolean mWasModified;
    private SPSS_Format mOldValue;
    private short mOldType;
    private SPSS_Format mNewValue;
    private short mNewType;
    private int mRowIndex;
    private int mColumnIndex;

    public VarViewVariableTypeEdit(VarViewTableModel varViewTableModel, short s, SPSS_Format sPSS_Format, int n, int n2) {
        ISpssVariable iSpssVariable;
        this.mTableModel = varViewTableModel;
        this.mDataSource = varViewTableModel.getDataSource();
        this.mFrame = varViewTableModel.getUndoManager().getSpssFrame();
        this.mNewType = s;
        this.mNewValue = sPSS_Format;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mWasModified = this.mDataSource.isModified();
        CompoundEdit compoundEdit = null;
        if (this.mTableModel.getDataSource().columnCount() <= this.mRowIndex) {
            compoundEdit = new CompoundEdit();
            this.mTableModel.getUndoManager().addEdit(compoundEdit);
            this.mTableModel.setValueAt(".", n, n2);
        }
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(this.mRowIndex) : null;
        if (iSpssVariable == null) {
            assert (false);
            return;
        }
        this.mOldValue = iSpssVariable.getFormat();
        this.mOldType = iSpssVariable.getType();
        this.mTableModel.getUndoManager().addEdit(this);
        this.doAction(false);
        if (compoundEdit != null) {
            compoundEdit.end();
        }
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasModified) {
            this.mDataSource.setModified(false);
        }
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mFrame = null;
        this.mTableModel = null;
        this.mDataSource = null;
        this.mOldValue = null;
        this.mNewValue = null;
        this.mWasModified = false;
    }

    private void doAction(boolean bl) {
        if (this.mNewValue == null) {
            return;
        }
        short s = bl ? this.mOldType : this.mNewType;
        SPSS_Format sPSS_Format = bl ? this.mOldValue : this.mNewValue;
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(this.mRowIndex);
        if (iSpssVariable.getType() == 0 && s != 0) {
            iSpssVariable.setMeasurementLevel(MeasurementLevel.nominal);
            iSpssVariable.setDisplayAlignment(DisplayAlignment.left);
        } else if (iSpssVariable.getType() != 0 && s == 0) {
            iSpssVariable.setDisplayAlignment(DisplayAlignment.right);
        }
        iSpssVariable.setType(s);
        iSpssVariable.setFormat(sPSS_Format);
        iSpssVariable.setWriteFormat(sPSS_Format);
        this.mDataSource.modifyVariable(iSpssVariable, this.mRowIndex);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>(1);
        vector.addElement(iSpssVariable);
        DataMgr.getDataMgr().sendModifyVarsMsg(this.mDataSource.getDataSetId(), vector, bl);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataSource.notifyVariableModified(this.mRowIndex, ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        this.mTableModel.fireTableCellUpdated(this.mRowIndex, this.mColumnIndex);
        this.mTableModel.fireTableVariableChanged(this.mRowIndex);
    }
}

