/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.core.documents.data.dictionary.value_labels.SpssVLMapId;
import com.spss.java_client.core.documents.data.dictionary.value_labels.ValueLabelMap;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class VarViewValueLabelsEdit
extends AbstractUndoableEdit {
    private SpssFrame mFrame;
    private VarViewTableModel mTableModel;
    private ISpssDataSrc mDataSource;
    private boolean mWasModified;
    private ValueLabelMap mOldMap;
    private ValueLabelMap mNewMap;
    private int mRowIndex;
    private int mColumnIndex;

    public VarViewValueLabelsEdit(VarViewTableModel varViewTableModel, HashMap<OBS, String> hashMap, int n, int n2) {
        ISpssVariable iSpssVariable;
        this.mTableModel = varViewTableModel;
        this.mDataSource = varViewTableModel.getDataSource();
        this.mFrame = varViewTableModel.getUndoManager().getSpssFrame();
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mWasModified = this.mDataSource.isModified();
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(this.mRowIndex) : null;
        if (iSpssVariable == null) {
            assert (false);
            return;
        }
        this.mNewMap = new ValueLabelMap(SpssVLMapId.next(), hashMap);
        this.mOldMap = (ValueLabelMap)iSpssVariable.getValueLabels();
        this.mTableModel.getUndoManager().addEdit(this);
        this.doAction(false);
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasModified) {
            this.mDataSource.setModified(false);
        }
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mFrame = null;
        this.mTableModel = null;
        this.mDataSource = null;
        this.mOldMap = null;
        this.mNewMap = null;
        this.mWasModified = false;
    }

    private void doAction(boolean bl) {
        if (this.mNewMap == null) {
            return;
        }
        ValueLabelMap valueLabelMap = bl ? this.mOldMap : this.mNewMap;
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(this.mRowIndex);
        iSpssVariable.setValueLabels((IValueLabelMap)valueLabelMap);
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>(1);
        vector.addElement(iSpssVariable);
        DataMgr.getDataMgr().sendModifyVarsMsg(this.mDataSource.getDataSetId(), vector, bl);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataSource.notifyVariableModified(this.mRowIndex, ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        this.mTableModel.fireTableCellUpdated(this.mRowIndex, this.mColumnIndex);
        this.mTableModel.fireTableVariableChanged(this.mRowIndex);
    }
}

