/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.doc_types.data.undo.MissingValueBucket;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class VarViewMissingValueEdit
extends AbstractUndoableEdit {
    private SpssFrame mFrame;
    private VarViewTableModel mTableModel;
    private ISpssDataSrc mDataSource;
    private boolean mWasModified;
    private MissingValueBucket mOldValues;
    private MissingValueBucket mNewValues;
    private int mRowIndex;
    private int mColumnIndex;

    public VarViewMissingValueEdit(VarViewTableModel varViewTableModel, MissingValueBucket missingValueBucket, int n, int n2) {
        ISpssVariable iSpssVariable;
        this.mTableModel = varViewTableModel;
        this.mDataSource = varViewTableModel.getDataSource();
        this.mFrame = varViewTableModel.getUndoManager().getSpssFrame();
        this.mNewValues = missingValueBucket;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mWasModified = this.mDataSource.isModified();
        ISpssVariable iSpssVariable2 = iSpssVariable = this.mDataSource != null ? this.mDataSource.getVariable(this.mRowIndex) : null;
        if (iSpssVariable == null) {
            assert (false);
            return;
        }
        OBS oBS = new OBS();
        OBS oBS2 = new OBS();
        OBS oBS3 = new OBS();
        ISpssVariable.Rule rule = iSpssVariable.getMissingValues(oBS, oBS2, oBS3);
        this.mOldValues = new MissingValueBucket(rule, oBS, oBS2, oBS3);
        if (this.mOldValues.equals(this.mNewValues)) {
            return;
        }
        this.mTableModel.getUndoManager().addEdit(this);
        this.doAction(false);
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasModified) {
            this.mDataSource.setModified(false);
        }
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        this.mDataSource.setModified(true);
        this.mFrame.updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mFrame = null;
        this.mTableModel = null;
        this.mDataSource = null;
        this.mOldValues = null;
        this.mNewValues = null;
        this.mWasModified = false;
    }

    private void doAction(boolean bl) {
        ISpssVariable iSpssVariable = this.mDataSource.getVariable(this.mRowIndex);
        MissingValueBucket missingValueBucket = bl ? this.mOldValues : this.mNewValues;
        OBS[] oBSArray = missingValueBucket.getObsValues();
        assert (oBSArray.length == 3);
        iSpssVariable.setMissingValues(missingValueBucket.getRule(), oBSArray[0], oBSArray[1], oBSArray[2]);
        if (this.mDataSource != null) {
            Vector<ISpssVariable> vector = new Vector<ISpssVariable>(1);
            vector.addElement(iSpssVariable);
            DataMgr.getDataMgr().sendModifyVarsMsg(this.mDataSource.getDataSetId(), vector, bl);
            this.mDataSource.getCacheMgr().clearCache();
            this.mDataSource.notifyVariableModified(this.mRowIndex, ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        }
        this.mTableModel.fireTableCellUpdated(this.mRowIndex, this.mColumnIndex);
        this.mTableModel.fireTableVariableChanged(this.mRowIndex);
    }
}

