/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.OBS;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableValueUpdateEdit
extends AbstractUndoableEdit {
    private DataViewTable mDataTable;
    private ISpssDataSrc mDataSource;
    private OBS mOldValue;
    private OBS mNewValue;
    private int mRowIndex;
    private int mColumnIndex;
    private boolean mWasDirty = false;

    public TableValueUpdateEdit(DataViewTable dataViewTable, ISpssDataSrc iSpssDataSrc, OBS oBS, OBS oBS2, int n, int n2) {
        this.mDataTable = dataViewTable;
        this.mDataSource = iSpssDataSrc;
        this.mNewValue = oBS2;
        this.mRowIndex = n;
        this.mColumnIndex = n2;
        this.mWasDirty = this.mDataSource.isModified();
        ((DataViewTableModel)dataViewTable.getModel()).getUndoManager().addEdit(this);
        try {
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
            this.mOldValue = oBS != null ? (OBS)oBS.clone() : (iSpssVariable.getType() == 0 ? new OBS(this.mDataSource.getSystemMissing()) : new OBS(""));
            this.mDataSource.getCacheMgr().setCellValue((long)this.mRowIndex, this.mColumnIndex, this.mNewValue, true);
            final DataViewTable dataViewTable2 = dataViewTable;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((DataViewTableModel)dataViewTable2.getModel()).getUndoManager().getSpssFrame().updateToolbarEnableStatus();
                }
            });
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.mDataSource.getCacheMgr().setCellValue((long)this.mRowIndex, this.mColumnIndex, this.mOldValue, true);
        ((DataViewTableModel)this.mDataTable.getModel()).fireTableCellUpdated(this.mRowIndex, this.mColumnIndex);
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
        int n = this.mDataTable.getSelectedRow();
        int n2 = this.mDataTable.getSelectedColumn();
        this.mDataTable.clearSelection();
        if (n != -1 && n2 != -1) {
            this.mDataTable.setRowSelectionInterval(n, n);
            this.mDataTable.setColumnSelectionInterval(n2, n2);
        }
        ((DataViewTableModel)this.mDataTable.getModel()).getUndoManager().getSpssFrame().updateToolbarEnableStatus();
        this.mDataTable.repaint(this.mDataTable.getCellRect(this.mRowIndex, this.mColumnIndex, true));
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.mDataSource.getCacheMgr().setCellValue((long)this.mRowIndex, this.mColumnIndex, this.mNewValue, true);
        ((DataViewTableModel)this.mDataTable.getModel()).fireTableCellUpdated(this.mRowIndex, this.mColumnIndex);
        int n = this.mDataTable.getSelectedRow();
        int n2 = this.mDataTable.getSelectedColumn();
        this.mDataTable.clearSelection();
        if (n != -1 && n2 != -1) {
            this.mDataTable.setRowSelectionInterval(n, n);
            this.mDataTable.setColumnSelectionInterval(n2, n2);
        }
        ((DataViewTableModel)this.mDataTable.getModel()).getUndoManager().getSpssFrame().updateToolbarEnableStatus();
        this.mDataTable.repaint(this.mDataTable.getCellRect(this.mRowIndex, this.mColumnIndex, true));
    }

    @Override
    public void die() {
        super.die();
        this.mDataTable = null;
        this.mDataSource = null;
        this.mOldValue = null;
        this.mNewValue = null;
    }
}

