/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.SpssRowHeaderTable;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableRowMoveEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    private int[] mSrcDragRows;
    private int mNewDropRow;
    private LocallyUniqueId mDatasetId;
    private boolean mWasDirty = false;
    private SpssRowHeaderTable mTable;
    private boolean mIsDataView;

    public TableRowMoveEdit(LocallyUniqueId locallyUniqueId, SpssUndoManager spssUndoManager, SpssRowHeaderTable spssRowHeaderTable, int[] nArray, int n) {
        this.mDatasetId = locallyUniqueId;
        this.mManager = spssUndoManager;
        this.mTable = spssRowHeaderTable;
        this.mSrcDragRows = nArray;
        this.mNewDropRow = n;
        this.mIsDataView = this.mTable.getDataTable() instanceof DataViewTable;
        this.mWasDirty = DataMgr.getDataMgr().getDataSource(this.mDatasetId).isModified();
        this.mManager.addEdit(this);
        this.doAction(false);
        DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasDirty) {
            DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(true);
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
    }

    private void doAction(boolean bl) {
        if (this.mSrcDragRows != null) {
            int n;
            Serializable serializable;
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.mDatasetId);
            int n2 = this.mNewDropRow;
            int n3 = this.mNewDropRow;
            if (this.mIsDataView) {
                serializable = new Vector<Number>();
                for (int n4 : this.mSrcDragRows) {
                    ((Vector)serializable).add(Long.valueOf(n4));
                }
                DataMgr.getDataMgr().sendMoveRowsMsg(this.mDatasetId, serializable, (long)this.mNewDropRow, bl);
            } else {
                serializable = new Vector();
                int[] nArray = this.mSrcDragRows;
                n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer n5 = nArray[i];
                    n2 = n2 < n5 ? n2 : n5;
                    n3 = n3 > n5 ? n3 : n5;
                    ((Vector)serializable).add(n5);
                }
                iSpssDataSrc.moveVariables(serializable, this.mNewDropRow, bl, true);
            }
            iSpssDataSrc.getCacheMgr().clearCache();
            if (this.mIsDataView) {
                iSpssDataSrc.notifyRowCountEstablished(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
            } else {
                iSpssDataSrc.notifyVariablesMoved(n2, n3, this.mNewDropRow);
            }
            this.mManager.getSpssFrame().updateToolbarEnableStatus();
            serializable = this.mTable.getDataTable();
            ((JTable)serializable).clearSelection();
            this.mTable.clearSelection();
            ((JTable)serializable).setColumnSelectionInterval(0, ((JTable)serializable).getColumnCount() - 1);
            this.mTable.setColumnSelectionInterval(0, 0);
            if (bl) {
                for (int n6 : this.mSrcDragRows) {
                    ((JTable)serializable).addRowSelectionInterval(n6, n6);
                    this.mTable.addRowSelectionInterval(n6, n6);
                }
            } else {
                int n7 = this.mNewDropRow;
                if (this.mNewDropRow > this.mSrcDragRows[0]) {
                    n7 -= this.mSrcDragRows.length;
                }
                n = n7 + this.mSrcDragRows.length - 1;
                ((JTable)serializable).setRowSelectionInterval(n7, n);
                this.mTable.setRowSelectionInterval(n7, n);
            }
        }
    }
}

