/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableColumnWidthEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    private JTable mTable;
    int[] mColumnIndices;
    int[] mOldWidths;
    int mNewWidth;
    private boolean mWasDirty = false;
    int mViewType;
    DataView mDataView;

    public TableColumnWidthEdit(DataView dataView, int n, int n2, int n3, int n4) {
        this.mDataView = dataView;
        this.mManager = dataView.getUndoManager();
        this.mViewType = n;
        this.mColumnIndices = new int[1];
        this.mColumnIndices[0] = n2;
        this.mOldWidths = new int[1];
        this.mOldWidths[0] = n3;
        this.mNewWidth = n4;
        this.mTable = dataView.getDataTables()[0];
        LocallyUniqueId locallyUniqueId = ((DataFrame)this.mManager.getSpssFrame()).getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mWasDirty = iSpssDataSrc.isModified();
        this.mTable.getColumnModel().getColumn(n2).setPreferredWidth(this.mNewWidth);
        if (this.mViewType == 0) {
            this.setDataColumnWidth(iSpssDataSrc, false);
            iSpssDataSrc.setModified(true);
        }
        this.mManager.addEdit(this);
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    public TableColumnWidthEdit(DataView dataView, int n, int[] nArray, int n2, int n3, int n4) {
        this.mDataView = dataView;
        this.mManager = dataView.getUndoManager();
        this.mViewType = n;
        this.mTable = dataView.getDataTables()[0];
        this.mNewWidth = n4;
        this.mColumnIndices = nArray;
        this.mOldWidths = new int[nArray.length];
        Cursor cursor = this.mTable.getTableHeader().getCursor();
        this.mTable.getTableHeader().setCursor(null);
        this.setWaitCursor(true);
        LocallyUniqueId locallyUniqueId = ((DataFrame)this.mManager.getSpssFrame()).getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mWasDirty = iSpssDataSrc.isModified();
        for (int i = 0; i < this.mColumnIndices.length; ++i) {
            int n5 = this.mColumnIndices[i];
            TableColumn tableColumn = this.mTable.getColumnModel().getColumn(n5);
            this.mOldWidths[i] = n5 == n2 ? n3 : tableColumn.getPreferredWidth();
            this.mTable.getColumnModel().getColumn(n5).setPreferredWidth(this.mNewWidth);
        }
        if (this.mViewType == 0) {
            this.setDataColumnWidth(iSpssDataSrc, false);
            iSpssDataSrc.setModified(true);
        }
        this.mManager.addEdit(this);
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.setWaitCursor(false);
        this.mTable.getTableHeader().setCursor(cursor);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.setWaitCursor(true);
        LocallyUniqueId locallyUniqueId = ((DataFrame)this.mManager.getSpssFrame()).getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int i = 0; i < this.mColumnIndices.length; ++i) {
            this.mTable.getColumnModel().getColumn(this.mColumnIndices[i]).setPreferredWidth(this.mOldWidths[i]);
        }
        if (this.mViewType == 0) {
            this.setDataColumnWidth(iSpssDataSrc, true);
        }
        if (!this.mWasDirty) {
            iSpssDataSrc.setModified(false);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.setWaitCursor(false);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.setWaitCursor(true);
        LocallyUniqueId locallyUniqueId = ((DataFrame)this.mManager.getSpssFrame()).getDatasetId();
        ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        for (int n : this.mColumnIndices) {
            this.mTable.getColumnModel().getColumn(n).setPreferredWidth(this.mNewWidth);
        }
        if (this.mViewType == 0) {
            this.setDataColumnWidth(iSpssDataSrc, false);
        }
        iSpssDataSrc.setModified(true);
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.setWaitCursor(false);
    }

    @Override
    public boolean canUndo() {
        return super.canUndo();
    }

    @Override
    public boolean canRedo() {
        return super.canRedo();
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mTable = null;
        this.mWasDirty = false;
    }

    private void setDataColumnWidth(ISpssDataSrc iSpssDataSrc, boolean bl) {
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        FontMetrics fontMetrics = this.mDataView.getFontMetrics(this.mDataView.getFont());
        int n = fontMetrics.charWidth('A');
        int n2 = this.mTable.getColumnModel().getColumnMargin();
        for (int i = 0; i < this.mColumnIndices.length; ++i) {
            int n3 = this.mColumnIndices[i];
            int n4 = bl ? this.mOldWidths[i] : this.mNewWidth;
            int n5 = (n4 - n2 * 2 - 2) / n;
            ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n3);
            iSpssVariable.setDisplayWidth((short)n5);
            vector.addElement(iSpssVariable);
            this.mDataView.setDataColumnWidth(n3, iSpssVariable.getDisplayWidth());
        }
        DataMgr.getDataMgr().sendModifyVarsMsg(iSpssDataSrc.getDataSetId(), vector, bl);
    }

    private void setWaitCursor(boolean bl) {
        if (bl) {
            this.mManager.getSpssFrame().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.mManager.getSpssFrame().setCursor(null);
        }
    }
}

