/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.server.messages.DataEditorMsg.CellValue;
import com.spss.java_client.core.server.messages.DataEditorMsg.SetCellValuesMsg;
import com.spss.java_client.core.server.messages.IDataMsg;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableColumnValuesEdit
extends AbstractUndoableEdit {
    private DataViewTable mDataTable;
    private ISpssDataSrc mDataSource;
    private Vector<CellValue> mCellValues;
    private boolean mWasDirty;

    public TableColumnValuesEdit(DataViewTable dataViewTable, Vector<CellValue> vector) {
        this.mDataTable = dataViewTable;
        this.mCellValues = vector;
        DataViewTableModel dataViewTableModel = (DataViewTableModel)dataViewTable.getModel();
        this.mDataSource = dataViewTableModel.getDataSource();
        this.mWasDirty = this.mDataSource.isModified();
        dataViewTableModel.getUndoManager().addEdit(this);
        this.doAction(false);
        this.mDataSource.setModified(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        this.mDataSource.setModified(true);
    }

    @Override
    public void die() {
        super.die();
        this.mCellValues = null;
    }

    private void doAction(boolean bl) {
        try {
            this.fireServerChangeNotification(bl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableColumnValuesEdit.this.mDataSource.getCacheMgr().clearCache();
                    ((DataViewTableModel)TableColumnValuesEdit.this.mDataTable.getModel()).fireTableDataChanged();
                    ((DataViewTableModel)TableColumnValuesEdit.this.mDataTable.getModel()).getUndoManager().getSpssFrame().updateToolbarEnableStatus();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fireServerChangeNotification(boolean bl) {
        SetCellValuesMsg setCellValuesMsg = new SetCellValuesMsg();
        setCellValuesMsg.initialize();
        setCellValuesMsg.setDataSetId(this.mDataSource.getDataSetId());
        setCellValuesMsg.setOriginator(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        setCellValuesMsg.setDataSetVersion(this.mDataSource.currentCaseSequenceNumber());
        setCellValuesMsg.setUndoFlag(bl);
        for (CellValue cellValue : this.mCellValues) {
            setCellValuesMsg.addCellValue(cellValue);
        }
        DataMgr.getDataMgr().sendAsyncMessage((IDataMsg)setCellValuesMsg);
    }
}

