/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class TableColumnMoveEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mUndoManager;
    private int[] mSrcDragCols;
    private int mNewDropCol;
    private JTable mTable;
    private LocallyUniqueId mDatasetId;
    private boolean mWasDirty = false;

    public TableColumnMoveEdit(LocallyUniqueId locallyUniqueId, SpssUndoManager spssUndoManager, JTable jTable, int[] nArray, int n) {
        this.mDatasetId = locallyUniqueId;
        this.mUndoManager = spssUndoManager;
        this.mTable = jTable;
        this.mSrcDragCols = nArray;
        this.mNewDropCol = n;
        this.mWasDirty = DataMgr.getDataMgr().getDataSource(this.mDatasetId).isModified();
        this.mUndoManager.addEdit(this);
        this.doAction(false);
        DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(true);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasDirty) {
            DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        DataMgr.getDataMgr().getDataSource(this.mDatasetId).setModified(true);
    }

    @Override
    public void die() {
        super.die();
        this.mUndoManager = null;
        this.mSrcDragCols = null;
        this.mNewDropCol = 0;
        this.mTable = null;
        this.mDatasetId = null;
        this.mWasDirty = false;
    }

    private void doAction(boolean bl) {
        if (this.mSrcDragCols != null) {
            int n;
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(this.mDatasetId);
            Vector<Integer> vector = new Vector<Integer>();
            int n2 = this.mNewDropCol;
            int n3 = this.mNewDropCol;
            int[] nArray = this.mSrcDragCols;
            int n4 = nArray.length;
            for (n = 0; n < n4; ++n) {
                Integer n5 = nArray[n];
                n2 = n2 < n5 ? n2 : n5;
                n3 = n3 > n5 ? n3 : n5;
                vector.add(n5);
            }
            iSpssDataSrc.moveVariables(vector, this.mNewDropCol, bl, true);
            iSpssDataSrc.notifyVariablesMoved(n2, n3, this.mNewDropCol);
            if (this.mUndoManager == null) {
                return;
            }
            this.mUndoManager.getSpssFrame().updateToolbarEnableStatus();
            int n6 = 0;
            for (int n7 : this.mSrcDragCols) {
                if (n7 >= this.mNewDropCol) continue;
                ++n6;
            }
            this.mTable.clearSelection();
            this.mTable.setRowSelectionInterval(0, this.mTable.getRowCount() - 1);
            if (bl) {
                for (int n7 : this.mSrcDragCols) {
                    this.mTable.addColumnSelectionInterval(n7, n7);
                }
            } else {
                int n8 = this.mNewDropCol - n6;
                n = n8 + this.mSrcDragCols.length - 1;
                this.mTable.setColumnSelectionInterval(n8, n);
            }
        }
    }
}

