/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.CommandLine;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.script.ScriptingUtil;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RowInsertEdit
extends AbstractUndoableEdit {
    private DataFrame mFrame = null;
    private ISpssDataSrc mDataSrc = null;
    private long mStart = 0L;
    private long mCount = 0L;
    private boolean mIsSignificant = true;
    private boolean mSignicanceSet = false;
    private boolean mWasDirty = false;
    TablePropertyManager mFromTablePropertyManager;

    public RowInsertEdit(DataFrame dataFrame, long l, long l2) {
        this(dataFrame, null, l, l2);
    }

    public RowInsertEdit(DataFrame dataFrame, TablePropertyManager tablePropertyManager, long l, long l2) {
        this.mFrame = dataFrame;
        this.mStart = l;
        this.mCount = l2;
        this.mDataSrc = DataMgr.getDataMgr().getDataSource(this.mFrame.getDatasetId());
        this.mWasDirty = this.mDataSrc.isModified();
        this.mFrame.getUndoManager().addEdit(this);
        this.mFromTablePropertyManager = null;
        this.doAction(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
        if (!this.mWasDirty) {
            this.mDataSrc.setModified(false);
        }
        if (this.mSignicanceSet) {
            this.mIsSignificant = !this.mIsSignificant;
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
        if (this.mSignicanceSet) {
            this.mIsSignificant = !this.mIsSignificant;
        }
    }

    @Override
    public boolean isSignificant() {
        return this.mSignicanceSet ? this.mIsSignificant : super.isSignificant();
    }

    public void setIsSignificant(boolean bl) {
        this.mIsSignificant = bl;
        this.mSignicanceSet = true;
    }

    @Override
    public void die() {
        super.die();
        this.mFrame = null;
        this.mIsSignificant = true;
        this.mSignicanceSet = false;
        this.mWasDirty = false;
        this.mDataSrc = null;
        this.mStart = 0L;
        this.mCount = 0L;
    }

    private void doAction(boolean bl) {
        DataMgr.getDataMgr().sendInsertRowsMsg(this.mDataSrc.getDataSetId(), this.mStart, this.mCount, bl);
        if (CommandLine.isExternalCaller()) {
            ScriptingUtil.waitForBackend();
        }
        this.mDataSrc.getCacheMgr().clearCache();
        if (!this.mFrame.getUndoManager().isNotificationLocked(2)) {
            this.mDataSrc.notifyRowCountEstablished(ORIGINATOR_ID.DATAMGR_ORIGINATOR);
            this.mFrame.updateToolbarEnableStatus();
        }
        if (!bl && this.mFromTablePropertyManager != null) {
            this.copyFormatInfo();
        }
    }

    private void copyFormatInfo() {
        DataViewTable dataViewTable = (DataViewTable)this.mFrame.getDataView().getDataTable(0);
        int n = this.getCopyCaseID(dataViewTable, (int)this.mStart, (int)this.mCount);
        if (n > 0) {
            int n2 = (int)this.mStart + 1;
            int[] nArray = dataViewTable.getRowCaseIDs((int)this.mStart, (int)(this.mStart + this.mCount - 1L), true);
            this.mFromTablePropertyManager.copyRowProperties(n, nArray);
        }
    }

    private int getCopyCaseID(DataViewTable dataViewTable, int n, int n2) {
        int[] nArray;
        int n3 = -1;
        if (n >= 1 && (nArray = dataViewTable.getRowCaseIDs(new int[]{--n}, false)) != null && nArray[0] > 0) {
            n3 = nArray[0];
        }
        return n3;
    }

    private int[] getNextCaseIDs(DataViewTable dataViewTable, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = dataViewTable.getNextUniqueCaseID();
        }
        return nArray;
    }

    private int[] createIndexArray(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = n; i < n2; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }
}

