/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ModifyVariableEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    private int[] mColumnIndexes;
    private boolean mWasDirty;
    private Vector<ISpssVariable> mOldVariables;
    private Vector<ISpssVariable> mNewVariables;
    private ISpssDataSrc mDataSrc;

    public ModifyVariableEdit(SpssUndoManager spssUndoManager, int n, Vector<ISpssVariable> vector) {
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = n + i;
        }
        this.init(spssUndoManager, nArray, vector);
    }

    public ModifyVariableEdit(SpssUndoManager spssUndoManager, int[] nArray, Vector<ISpssVariable> vector) {
        this.init(spssUndoManager, nArray, vector);
    }

    private void init(SpssUndoManager spssUndoManager, int[] nArray, Vector<ISpssVariable> vector) {
        this.mManager = spssUndoManager;
        this.mColumnIndexes = nArray;
        LocallyUniqueId locallyUniqueId = ((DataFrame)this.mManager.getSpssFrame()).getDatasetId();
        this.mDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        this.mWasDirty = this.mDataSrc.isModified();
        this.mNewVariables = vector;
        try {
            this.mOldVariables = new Vector(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                this.mOldVariables.add(i, this.mDataSrc.getVariable(this.mColumnIndexes[i]).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        this.mManager.addEdit(this);
        this.doAction(false);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.doAction(true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.doAction(false);
    }

    private void doAction(boolean bl) {
        Vector<ISpssVariable> vector = bl ? this.mOldVariables : this.mNewVariables;
        DataMgr.getDataMgr().sendModifyVarsMsg(this.mDataSrc.getDataSetId(), vector, bl);
        this.mDataSrc.getCacheMgr().clearCache();
        for (int i = 0; i < vector.size(); ++i) {
            this.mDataSrc.modifyVariable(vector.get(i), this.mColumnIndexes[i]);
            this.mDataSrc.notifyVariableModified(this.mColumnIndexes[i], ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        }
        if (bl) {
            this.mDataSrc.setModified(this.mWasDirty);
        } else {
            this.mDataSrc.setModified(true);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }
}

