/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.undo.SpssUndoManager;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Document;

public abstract class FormatCellsEditDocBased
extends AbstractUndoableEdit {
    protected SpssUndoManager mManager;
    protected DataViewTable mDataTable;
    protected DataViewTableModel mDataTableModel;
    protected ISpssDataSrc mDataSource;
    protected boolean mWasDirty = false;
    Document mUndoDoc = null;
    protected int[] mSelRows;
    protected int[] mSelColumns;
    protected int[] mRowCaseIDS;
    protected boolean mEntireTableSelected;
    protected boolean mEntireColSelected;
    protected boolean mEntireRowSelected;
    protected int mPropertyStateID;

    protected FormatCellsEditDocBased() {
    }

    public FormatCellsEditDocBased(SpssUndoManager spssUndoManager, DataViewTable dataViewTable, ISpssDataSrc iSpssDataSrc, int n) {
        this.mManager = spssUndoManager;
        this.mDataTableModel = (DataViewTableModel)dataViewTable.getModel();
        this.mDataTable = dataViewTable;
        this.mDataSource = iSpssDataSrc;
        this.mWasDirty = this.mDataSource.isModified();
        this.mSelRows = this.mDataTable.getSelectedRows();
        this.mSelColumns = this.mDataTable.getSelectedColumns();
        this.mEntireTableSelected = this.mDataSource.columnCount() == this.mSelColumns.length && this.mDataSource.rowCount() == (long)this.mSelRows.length;
        this.mEntireColSelected = this.mDataTable.isEntireColumnSelected(this.mSelColumns[0]);
        this.mEntireRowSelected = this.mDataTable.isEntireRowSelected(this.mSelRows[0]);
        this.mPropertyStateID = n;
        if (this.mSelRows.length > 0 || this.mSelColumns.length > 0) {
            SpssFrame spssFrame = this.mManager.getSpssFrame();
            if (spssFrame instanceof DataFrame) {
                DataFrame dataFrame = (DataFrame)spssFrame;
                dataFrame.commitEdit();
            }
            this.mDataSource.setModified(true);
            this.mManager.addEdit(this);
            if (this.needCaseIDs()) {
                this.mRowCaseIDS = this.mDataTable.getRowCaseIDs(this.mSelRows, true);
            }
            this.savePropertyState();
        }
    }

    private boolean needCaseIDs() {
        boolean bl = true;
        if (this.mEntireTableSelected) {
            bl = false;
        } else if (this.mSelColumns != null && this.mSelColumns.length > 0 && this.mEntireColSelected) {
            bl = false;
        }
        return bl;
    }

    protected void restoreSavedPropertyState() {
        this.mDataTable.doRestoreProperties(this.mUndoDoc);
    }

    protected void savePropertyState() {
        this.mUndoDoc = this.mDataTable.createPropertiesXML(null);
    }

    protected void doFormatCellUndo() {
        this.restoreSavedPropertyState();
    }

    protected abstract void redoFormatWholeTableBased();

    protected abstract void redoFormatColBased();

    protected abstract void redoFormatRowBased();

    protected abstract void redoFormatCellBased();

    protected void doFormatCellRedo() {
        if (this.mEntireTableSelected) {
            this.redoFormatWholeTableBased();
        } else if (this.mSelColumns != null && this.mSelColumns.length > 0 && this.mEntireColSelected) {
            this.redoFormatColBased();
        } else if (this.mRowCaseIDS != null && this.mRowCaseIDS.length > 0 && this.mEntireRowSelected && !this.mEntireColSelected) {
            this.redoFormatRowBased();
        } else {
            this.redoFormatCellBased();
        }
        this.mDataTable.repaint();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        this.doFormatCellUndo();
        this.restoreSavedPropertyState();
        this.mDataTableModel.fireTableDataChanged();
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        this.doFormatCellRedo();
        this.mDataSource.setModified(true);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataTableModel.fireTableDataChanged();
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mDataTableModel = null;
        this.mDataSource = null;
        this.mUndoDoc = null;
    }
}

