/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.undo.SpssUndoManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public abstract class FormatCellsEdit
extends AbstractUndoableEdit {
    protected SpssUndoManager mManager;
    protected SpssTable mActiveTable;
    protected DataViewTable mDataTable;
    protected AbstractTableModel mTableModel;
    protected ISpssDataSrc mDataSource;
    protected boolean mWasDirty = false;
    protected TablePropertyManager mUndoTablePropertyManager;
    protected int[] mSelRows;
    protected int[] mSelColumns;
    protected int[] mRowCaseIDS;
    protected boolean mEntireColSelected;
    protected boolean mEntireRowSelected;
    protected boolean mEntireTableSelected;
    protected int mPropertyStateID;

    protected FormatCellsEdit() {
    }

    public FormatCellsEdit(SpssUndoManager spssUndoManager, SpssTable spssTable, DataViewTable dataViewTable, ISpssDataSrc iSpssDataSrc, int n) {
        this.mManager = spssUndoManager;
        this.mTableModel = (AbstractTableModel)dataViewTable.getModel();
        this.mActiveTable = spssTable;
        this.mDataTable = dataViewTable;
        this.mDataSource = iSpssDataSrc;
        this.mWasDirty = this.mDataSource.isModified();
        this.mSelRows = spssTable.getSelectedRows();
        this.mSelColumns = spssTable.getSelectedColumns();
        this.mEntireTableSelected = this.mDataSource.columnCount() == this.mSelColumns.length && this.mDataSource.rowCount() == (long)this.mSelRows.length;
        this.mEntireColSelected = spssTable.isEntireColumnSelected(this.mSelColumns[0]);
        this.mEntireRowSelected = spssTable.isEntireRowSelected(this.mSelRows[0]);
        this.mPropertyStateID = n;
        if (this.mSelRows.length > 0 || this.mSelColumns.length > 0) {
            SpssFrame spssFrame = this.mManager.getSpssFrame();
            if (spssFrame instanceof DataFrame) {
                DataFrame dataFrame = (DataFrame)spssFrame;
                dataFrame.commitEdit();
            }
            this.mDataSource.setModified(true);
            if (this.needCaseIDs()) {
                this.mRowCaseIDS = this.mDataTable.getRowCaseIDs(this.mSelRows, true);
            }
            this.savePropertyState();
            this.mManager.addEdit(this);
        }
    }

    private boolean needCaseIDs() {
        boolean bl = true;
        if (this.mEntireTableSelected) {
            bl = false;
        } else if (this.mSelColumns != null && this.mSelColumns.length > 0 && this.mEntireColSelected) {
            bl = false;
        } else if (this.mActiveTable instanceof VarViewTable) {
            bl = false;
        }
        return bl;
    }

    protected void restoreSavedPropertyState() {
        this.mDataTable.restoreSavedProperties(this.mUndoTablePropertyManager);
    }

    protected void savePropertyState() {
        int[] nArray;
        if (this.mActiveTable instanceof VarViewTable && (nArray = this.getVariableIDs(this.mSelRows)) != null) {
            this.mUndoTablePropertyManager = this.mDataTable.savePropertyStateColumnBased(this.mPropertyStateID, nArray);
        }
        if (this.mEntireTableSelected) {
            this.mUndoTablePropertyManager = this.mDataTable.savePropertyStateWholeTableInfo(this.mPropertyStateID);
        } else if (this.mSelColumns != null && this.mSelColumns.length > 0 && this.mEntireColSelected) {
            nArray = this.getVariableIDs(this.mSelColumns);
            if (nArray != null) {
                this.mUndoTablePropertyManager = this.mDataTable.savePropertyStateColumnBased(this.mPropertyStateID, nArray);
            }
        } else {
            this.mUndoTablePropertyManager = this.mRowCaseIDS != null && this.mRowCaseIDS.length > 0 && this.mEntireRowSelected && !this.mEntireColSelected ? this.mDataTable.savePropertyStateRowBased(this.mPropertyStateID, this.mRowCaseIDS) : this.mDataTable.savePropertyStateCellBased(this.mPropertyStateID, this.mRowCaseIDS, this.mSelColumns);
        }
    }

    private int[] getVariableIDs(int[] nArray) {
        int[] nArray2;
        int[] nArray3 = nArray2 = nArray != null && nArray.length > 0 ? new int[nArray.length] : null;
        if (nArray2 != null) {
            ISpssVariable iSpssVariable;
            for (int i = 0; i < nArray.length && (iSpssVariable = this.mDataSource.getVariable(nArray[i])) != null; ++i) {
                nArray2[i] = iSpssVariable.getId().asInt();
            }
        }
        return nArray2;
    }

    protected void doFormatCellUndo() {
        this.restoreSavedPropertyState();
    }

    protected abstract void redoFormatWholeTableBased();

    protected abstract void redoFormatColBased(int[] var1);

    protected abstract void redoFormatRowBased();

    protected abstract void redoFormatCellBased();

    protected void doFormatCellRedo() {
        if (this.mActiveTable instanceof VarViewTable) {
            if (this.mSelRows != null && this.mSelRows.length > 0 && this.mEntireRowSelected) {
                this.redoFormatColBased(this.mSelRows);
            }
        } else if (this.mEntireTableSelected) {
            this.redoFormatWholeTableBased();
        } else if (this.mSelColumns != null && this.mSelColumns.length > 0 && this.mEntireColSelected) {
            this.redoFormatColBased(this.mSelColumns);
        } else if (this.mRowCaseIDS != null && this.mRowCaseIDS.length > 0 && this.mEntireRowSelected && !this.mEntireColSelected) {
            this.redoFormatRowBased();
        } else {
            this.redoFormatCellBased();
        }
        this.mDataTable.repaint();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        this.doFormatCellUndo();
        this.restoreSavedPropertyState();
        this.mTableModel.fireTableDataChanged();
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        this.doFormatCellRedo();
        this.mDataSource.setModified(true);
        this.mDataSource.getCacheMgr().clearCache();
        this.mTableModel.fireTableDataChanged();
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mTableModel = null;
        this.mDataSource = null;
        this.mDataTable = null;
        this.mUndoTablePropertyManager = null;
        this.mSelRows = null;
        this.mSelColumns = null;
    }
}

