/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.common.ORIGINATOR_ID;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataView;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DeleteVariablesEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    private ISpssDataSrc mDataSource;
    private int[] mIndices;
    private ISpssVariable[] mVariables;
    private DataView mDataView;
    private boolean mWasDirty = false;
    private int mFilterVarIndex;

    public DeleteVariablesEdit(SpssUndoManager spssUndoManager, VarViewTableModel varViewTableModel, ISpssDataSrc iSpssDataSrc, int[] nArray, DataView dataView) {
        Serializable serializable;
        this.mManager = spssUndoManager;
        this.mDataView = dataView;
        this.mDataSource = iSpssDataSrc;
        this.mIndices = nArray;
        this.mVariables = new ISpssVariable[this.mIndices.length];
        this.mWasDirty = this.mDataSource.isModified();
        this.mFilterVarIndex = this.mDataSource.getFilterVarIndex();
        int n = 0xFFFFFF;
        for (int i = 0; i < this.mIndices.length; ++i) {
            n = n > this.mIndices[i] ? this.mIndices[i] : n;
            this.mVariables[i] = this.mDataSource.getVariable(this.mIndices[i]);
            if (this.mVariables[i] != null) continue;
            return;
        }
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            serializable = (DataFrame)spssFrame;
            ((DataFrame)serializable).commitEdit();
        }
        serializable = new Vector();
        ((Vector)serializable).addAll(Arrays.asList(this.mVariables));
        DataMgr.getDataMgr().sendDeleteVarsMsg(this.mDataSource.getDataSetId(), (Vector)serializable, false);
        for (int i = this.mIndices.length - 1; i >= 0; --i) {
            this.mDataSource.deleteVariables(this.mIndices[i], this.mIndices[i]);
        }
        this.mDataSource.setModified(true);
        this.mManager.addEdit(this);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataSource.notifyVariablesDeleted(n, n + this.mIndices.length - 1, this.mDataSource.columnCount(), ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        for (int n2 : this.mIndices) {
            if (this.mFilterVarIndex != n2) continue;
            this.mDataSource.setFilterVarIndex(this.mFilterVarIndex);
            this.mDataSource.notifyFilterVarIndex(this.mFilterVarIndex);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.mDataView.updateVarsInUse(true);
    }

    private int[] getVariableIDs() {
        int[] nArray = this.mVariables != null ? new int[this.mVariables.length] : null;
        for (int i = 0; i < this.mVariables.length; ++i) {
            ISpssVariable iSpssVariable = this.mVariables[i];
            if (iSpssVariable == null) continue;
            nArray[i] = iSpssVariable.getId().asInt();
        }
        return nArray;
    }

    private DataViewTable getDataViewTable() {
        return (DataViewTable)this.mDataView.getDataTable(0);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        for (int i = 0; i < this.mIndices.length; ++i) {
            this.mDataSource.insertVariable(this.mIndices[i], this.mVariables[i]);
        }
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        vector.addAll(Arrays.asList(this.mVariables));
        DataMgr.getDataMgr().sendDeleteVarsMsg(this.mDataSource.getDataSetId(), vector, true);
        this.mDataSource.getCacheMgr().clearCache();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int n : this.mIndices) {
            vector2.add(n);
        }
        this.mDataSource.notifyVariablesInserted(new Vector(vector2), ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        for (int n : this.mIndices) {
            if (this.mFilterVarIndex != n) continue;
            this.mDataSource.setFilterVarIndex(this.mFilterVarIndex);
            this.mDataSource.notifyFilterVarIndex(this.mFilterVarIndex);
        }
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.mDataView.updateVarsInUse(true);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        this.mVariables = new ISpssVariable[this.mIndices.length];
        this.mWasDirty = this.mDataSource.isModified();
        int n = 0xFFFFFF;
        for (int i = 0; i < this.mIndices.length; ++i) {
            n = n > this.mIndices[i] ? this.mIndices[i] : n;
            this.mVariables[i] = this.mDataSource.getVariable(this.mIndices[i]);
            if (this.mVariables[i] != null) continue;
            return;
        }
        Vector<ISpssVariable> vector = new Vector<ISpssVariable>();
        vector.addAll(Arrays.asList(this.mVariables));
        DataMgr.getDataMgr().sendDeleteVarsMsg(this.mDataSource.getDataSetId(), vector, false);
        for (int i = this.mIndices.length - 1; i >= 0; --i) {
            this.mDataSource.deleteVariables(this.mIndices[i], this.mIndices[i]);
        }
        this.mDataSource.setModified(true);
        this.mManager.addEdit(this);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataSource.notifyVariablesDeleted(n, n + this.mIndices.length - 1, this.mDataSource.columnCount(), ORIGINATOR_ID.DATAMGR_ORIGINATOR);
        for (int n2 : this.mIndices) {
            if (this.mFilterVarIndex != n2) continue;
            this.mDataSource.setFilterVarIndex(-1);
            this.mDataSource.notifyFilterVarIndex(-1);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
        this.mDataView.updateVarsInUse(true);
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mDataSource = null;
        this.mIndices = null;
        this.mDataView = null;
        this.mWasDirty = false;
    }
}

