/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.DataViewTableModel;
import com.spss.java_client.ui.doc_types.data.TablePropertyManager;
import com.spss.java_client.ui.undo.SpssUndoManager;
import com.spss.shared.core_tools.utils.Pair;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class DeleteDataRowsEdit
extends AbstractUndoableEdit {
    private SpssUndoManager mManager;
    DataViewTable mDataTable;
    private DataViewTableModel mDataTableModel;
    private ISpssDataSrc mDataSource;
    private LinkedList<Pair<Long, Long>> mIndices;
    private int mRowsDeleted;
    private boolean mWasDirty = false;
    TablePropertyManager mUndoTablePropertyManager;

    public DeleteDataRowsEdit(SpssUndoManager spssUndoManager, DataViewTable dataViewTable, ISpssDataSrc iSpssDataSrc, int[] nArray) {
        this.mManager = spssUndoManager;
        this.mDataTableModel = (DataViewTableModel)dataViewTable.getModel();
        this.mDataTable = dataViewTable;
        this.mDataSource = iSpssDataSrc;
        this.mRowsDeleted = nArray.length;
        this.mWasDirty = this.mDataSource.isModified();
        this.processIndices(nArray);
        if (this.mIndices.size() > 0) {
            SpssFrame spssFrame = this.mManager.getSpssFrame();
            if (spssFrame instanceof DataFrame) {
                DataFrame dataFrame = (DataFrame)spssFrame;
                dataFrame.commitEdit();
            }
            for (Pair pair : this.mIndices) {
                DataMgr.getDataMgr().deleteDataRows(this.mDataSource.getDataSetId(), ((Long)pair.getFirst()).longValue(), ((Long)pair.getSecond()).longValue(), false);
            }
            this.mDataSource.setModified(true);
            this.mManager.addEdit(this);
            this.mDataSource.getCacheMgr().clearCache();
            this.mUndoTablePropertyManager = this.mDataTable.savePropertySateRowBased(nArray);
            this.mDataTableModel.fireTableDataChanged();
            this.mManager.getSpssFrame().updateToolbarEnableStatus();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        Pair<Long, Long> pair;
        super.undo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            pair = (Pair<Long, Long>)spssFrame;
            pair.commitEdit();
        }
        for (int i = this.mIndices.size() - 1; i >= 0; --i) {
            pair = this.mIndices.get(i);
            DataMgr.getDataMgr().deleteDataRows(this.mDataSource.getDataSetId(), ((Long)pair.getFirst()).longValue(), ((Long)pair.getSecond()).longValue(), true);
        }
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataTable.restoreSavedProperties(this.mUndoTablePropertyManager);
        this.mDataTableModel.fireTableDataChanged();
        if (!this.mWasDirty) {
            this.mDataSource.setModified(false);
        }
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        SpssFrame spssFrame = this.mManager.getSpssFrame();
        if (spssFrame instanceof DataFrame) {
            DataFrame dataFrame = (DataFrame)spssFrame;
            dataFrame.commitEdit();
        }
        for (Pair pair : this.mIndices) {
            DataMgr.getDataMgr().deleteDataRows(this.mDataSource.getDataSetId(), ((Long)pair.getFirst()).longValue(), ((Long)pair.getSecond()).longValue(), false);
        }
        this.mDataSource.setModified(true);
        this.mDataSource.getCacheMgr().clearCache();
        this.mDataTableModel.fireTableDataChanged();
        this.mManager.getSpssFrame().updateToolbarEnableStatus();
    }

    @Override
    public void die() {
        super.die();
        this.mManager = null;
        this.mDataTableModel = null;
        this.mDataSource = null;
        this.mIndices = null;
    }

    private void processIndices(int[] nArray) {
        this.mIndices = new LinkedList();
        if (nArray.length == 0) {
            return;
        }
        int n = nArray[0];
        if ((long)n < this.mDataSource.rowCount()) {
            int n2 = nArray[0];
            for (int n3 : nArray) {
                if ((long)n3 >= this.mDataSource.rowCount()) continue;
                if (n3 > n2 + 1) {
                    this.mIndices.addFirst((Pair<Long, Long>)new Pair((Object)n, (Object)n2));
                    n = n3;
                }
                n2 = n3;
            }
            if (this.mIndices.size() == 0 || (Long)this.mIndices.getFirst().getSecond() != (long)nArray[nArray.length - 1]) {
                this.mIndices.addFirst((Pair<Long, Long>)new Pair((Object)n, (Object)n2));
            }
        }
    }
}

