/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.doc_types.data.undo;

import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.doc_types.data.DataViewTable;
import com.spss.java_client.ui.doc_types.data.SpssTable;
import com.spss.java_client.ui.doc_types.data.undo.FormatCellsEdit;
import com.spss.java_client.ui.undo.SpssUndoManager;
import java.awt.Color;

public class ColorCellsEdit
extends FormatCellsEdit {
    private Color mColor;
    private boolean mIsBackground;

    public ColorCellsEdit(SpssUndoManager spssUndoManager, SpssTable spssTable, DataViewTable dataViewTable, ISpssDataSrc iSpssDataSrc, Color color, boolean bl) {
        super(spssUndoManager, spssTable, dataViewTable, iSpssDataSrc, bl ? 0 : 1);
        this.mColor = color;
        this.mIsBackground = bl;
        this.doFormatCellRedo();
    }

    @Override
    protected void redoFormatWholeTableBased() {
        if (this.mIsBackground) {
            this.mDataTable.setWholeTableBKColor(this.mColor);
        } else {
            this.mDataTable.setWholeTableForegroundColor(this.mColor);
        }
    }

    @Override
    protected void redoFormatColBased(int[] nArray) {
        if (this.mIsBackground) {
            this.mDataTable.setWholeBKColumnsColor(nArray, this.mColor);
        } else {
            this.mDataTable.setWholeForegroundColumnsColor(nArray, this.mColor);
        }
    }

    @Override
    protected void redoFormatRowBased() {
        if (this.mIsBackground) {
            this.mDataTable.setWholeBKRowsColor(this.mRowCaseIDS, this.mColor);
        } else {
            this.mDataTable.setWholeForegroundRowsColor(this.mRowCaseIDS, this.mColor);
        }
    }

    @Override
    protected void redoFormatCellBased() {
        if (this.mIsBackground) {
            this.mDataTable.setCellsBkColorInfo(this.mRowCaseIDS, this.mSelColumns, this.mColor);
        } else {
            this.mDataTable.setCellsForegroundColorInfo(this.mRowCaseIDS, this.mSelColumns, this.mColor);
        }
    }

    @Override
    public void die() {
    }
}

